// |jit-test| skip-if: !wasmSimdEnabled()

/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_f32x4_cmp.wast

// ./test/core/simd/simd_f32x4_cmp.wast:3
let $0 = instantiate(`(module
  (func (export "eq") (param $$x v128) (param $$y v128) (result v128) (f32x4.eq (local.get $$x) (local.get $$y)))
  (func (export "ne") (param $$x v128) (param $$y v128) (result v128) (f32x4.ne (local.get $$x) (local.get $$y)))
  (func (export "lt") (param $$x v128) (param $$y v128) (result v128) (f32x4.lt (local.get $$x) (local.get $$y)))
  (func (export "le") (param $$x v128) (param $$y v128) (result v128) (f32x4.le (local.get $$x) (local.get $$y)))
  (func (export "gt") (param $$x v128) (param $$y v128) (result v128) (f32x4.gt (local.get $$x) (local.get $$y)))
  (func (export "ge") (param $$x v128) (param $$y v128) (result v128) (f32x4.ge (local.get $$x) (local.get $$y)))
)`);

// ./test/core/simd/simd_f32x4_cmp.wast:13
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:16
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:19
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:22
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:25
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:28
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:31
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:34
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:37
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:40
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:43
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:46
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:49
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:52
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:55
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:58
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:61
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:64
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:67
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:70
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:73
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:76
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:79
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:82
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:85
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:88
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:91
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:94
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:97
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:100
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:103
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:106
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:109
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:112
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:115
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:118
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:121
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:124
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:127
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:130
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:133
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:136
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:139
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:142
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:145
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:148
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:151
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:154
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:157
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:160
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:163
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:166
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:169
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:172
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:175
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:178
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:181
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:184
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:187
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:190
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:193
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:196
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:199
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:202
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:205
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:208
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:211
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:214
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:217
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:220
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:223
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:226
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:229
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:232
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:235
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:238
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:241
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:244
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:247
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:250
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:253
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:256
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:259
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:262
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:265
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:268
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:271
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:274
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:277
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:280
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:283
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:286
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:289
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:292
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:295
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:298
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:301
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:304
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:307
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:310
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:313
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:316
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:319
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:322
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:325
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:328
assert_return(
  () => invoke($0, `eq`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:331
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:334
assert_return(
  () => invoke($0, `eq`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:337
assert_return(
  () =>
    invoke($0, `eq`, [f32x4([1, 1, 1, 1]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:340
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:343
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:346
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:349
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:352
assert_return(
  () => invoke($0, `eq`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:355
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:358
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:361
assert_return(
  () => invoke($0, `eq`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:364
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:367
assert_return(
  () => invoke($0, `eq`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:370
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:373
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:376
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:379
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:382
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:385
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:388
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:391
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:394
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:397
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:400
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:403
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:406
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:409
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:412
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:415
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:418
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:421
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:424
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:427
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:430
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:433
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:436
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:439
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:442
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:445
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:448
assert_return(
  () => invoke($0, `eq`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:451
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:454
assert_return(
  () => invoke($0, `eq`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:457
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:460
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:463
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:466
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:469
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:472
assert_return(
  () =>
    invoke($0, `eq`, [f32x4([-0, -0, -0, -0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:475
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:478
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:481
assert_return(
  () => invoke($0, `eq`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:484
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:487
assert_return(
  () => invoke($0, `eq`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:490
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:493
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:496
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:499
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:502
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:505
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:508
assert_return(
  () =>
    invoke($0, `eq`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:511
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:514
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:517
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:520
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:523
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:526
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:529
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:532
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:535
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:538
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:541
assert_return(
  () =>
    invoke($0, `eq`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:544
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:547
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:550
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:553
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:556
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:559
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:562
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:565
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:568
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:571
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:574
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:577
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:580
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:583
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:586
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:589
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:592
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:595
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:598
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:601
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:604
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:607
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:610
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:613
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:616
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:619
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:622
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:625
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:628
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:631
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:634
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:637
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:640
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:643
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:646
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:649
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:652
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:655
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:658
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:661
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:664
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:667
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:670
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:673
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:676
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:679
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:682
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:685
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:688
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:691
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:694
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:697
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:700
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:703
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:706
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:709
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:712
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:715
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:718
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:721
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:724
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:727
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:730
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:733
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:736
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:739
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:742
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:745
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:748
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:751
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:754
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:757
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:760
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:763
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:766
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:769
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:772
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:775
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:778
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:781
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:784
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:787
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:790
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:793
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:796
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:799
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:802
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:805
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:808
assert_return(
  () => invoke($0, `eq`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:811
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:814
assert_return(
  () =>
    invoke($0, `eq`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:817
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:820
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:823
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:826
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:829
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:832
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:835
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:838
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:841
assert_return(
  () => invoke($0, `eq`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:844
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:847
assert_return(
  () =>
    invoke($0, `eq`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:850
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:853
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:856
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:859
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:862
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:865
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:868
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:871
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:874
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:877
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:880
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:883
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:886
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:889
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:892
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:895
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:898
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:901
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:904
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:907
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:910
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:913
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:916
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:919
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:922
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:925
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:928
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:931
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:934
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:937
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:940
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:943
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:946
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:949
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:952
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:955
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:958
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:961
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:964
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:967
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:970
assert_return(
  () =>
    invoke($0, `eq`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:973
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:976
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:979
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:982
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:985
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:988
assert_return(
  () => invoke($0, `eq`, [f32x4([0, 0, 0, 0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:991
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:994
assert_return(
  () => invoke($0, `eq`, [f32x4([0, 0, 0, 0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:997
assert_return(
  () =>
    invoke($0, `eq`, [f32x4([0, 0, 0, 0]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1000
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1003
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1006
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1009
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1012
assert_return(
  () => invoke($0, `eq`, [f32x4([0, 0, 0, 0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1015
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1018
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1021
assert_return(
  () => invoke($0, `eq`, [f32x4([0, 0, 0, 0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1024
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1027
assert_return(
  () => invoke($0, `eq`, [f32x4([0, 0, 0, 0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1030
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1033
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1036
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1039
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1042
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1045
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1048
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1051
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1054
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1057
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1060
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1063
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1066
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1069
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1072
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1075
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1078
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1081
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1084
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1087
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1090
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1093
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1096
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1099
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1102
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1105
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1108
assert_return(
  () => invoke($0, `eq`, [f32x4([-1, -1, -1, -1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1111
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1114
assert_return(
  () => invoke($0, `eq`, [f32x4([-1, -1, -1, -1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1117
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1120
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1123
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1126
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1129
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1132
assert_return(
  () =>
    invoke($0, `eq`, [f32x4([-1, -1, -1, -1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1135
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1138
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1141
assert_return(
  () => invoke($0, `eq`, [f32x4([-1, -1, -1, -1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1144
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1147
assert_return(
  () => invoke($0, `eq`, [f32x4([-1, -1, -1, -1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1150
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1153
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1156
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1159
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1162
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1165
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1168
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1171
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1174
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1177
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1180
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1183
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1186
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1189
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1192
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1195
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1198
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1201
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1204
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1207
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1210
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1213
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1216
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1219
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1222
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1225
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1228
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1231
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1234
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1237
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1240
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1243
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1246
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1249
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1252
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1255
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1258
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1261
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1264
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1267
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1270
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1273
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1276
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1279
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1282
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1285
assert_return(
  () =>
    invoke($0, `eq`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1290
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1293
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1296
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1299
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1302
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1305
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1308
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1311
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1314
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1317
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1320
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1323
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1326
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1329
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1332
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1335
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1338
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1341
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1344
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1347
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1350
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1353
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1356
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1359
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1362
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1365
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1368
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1371
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1374
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1377
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1380
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1383
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1386
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1389
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1392
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1395
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1398
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1401
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1404
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1407
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1410
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1413
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1416
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1419
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1422
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1425
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1428
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1431
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1434
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1437
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1440
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1443
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1446
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1449
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1452
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1455
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1458
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1461
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1464
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1467
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1470
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1473
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1476
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1479
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1482
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1485
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1488
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1491
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1494
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1497
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1500
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1503
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1506
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1509
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1512
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1515
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1518
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1521
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1524
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1527
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1530
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1533
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1536
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1539
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1542
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1545
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1548
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1551
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1554
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1557
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1560
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1563
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1566
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1569
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1572
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1575
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1578
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1581
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1584
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1587
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1590
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1593
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1596
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1599
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1602
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1605
assert_return(
  () => invoke($0, `ne`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1608
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1611
assert_return(
  () => invoke($0, `ne`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1614
assert_return(
  () =>
    invoke($0, `ne`, [f32x4([1, 1, 1, 1]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1617
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1620
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1623
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1626
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1629
assert_return(
  () => invoke($0, `ne`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1632
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1635
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1638
assert_return(
  () => invoke($0, `ne`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1641
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1644
assert_return(
  () => invoke($0, `ne`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1647
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1650
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1653
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1656
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1659
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1662
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1665
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1668
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1671
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1674
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1677
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1680
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1683
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1686
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1689
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1692
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1695
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1698
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1701
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1704
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1707
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1710
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1713
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1716
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1719
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1722
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1725
assert_return(
  () => invoke($0, `ne`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1728
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1731
assert_return(
  () => invoke($0, `ne`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1734
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1737
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1740
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1743
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1746
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1749
assert_return(
  () =>
    invoke($0, `ne`, [f32x4([-0, -0, -0, -0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1752
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1755
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1758
assert_return(
  () => invoke($0, `ne`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1761
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1764
assert_return(
  () => invoke($0, `ne`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1767
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1770
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1773
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1776
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1779
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1782
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1785
assert_return(
  () =>
    invoke($0, `ne`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1788
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1791
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1794
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1797
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1800
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1803
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1806
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1809
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1812
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1815
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1818
assert_return(
  () =>
    invoke($0, `ne`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1821
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1824
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1827
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1830
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1833
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1836
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1839
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1842
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1845
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1848
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1851
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1854
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1857
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1860
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1863
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1866
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1869
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1872
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1875
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1878
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1881
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1884
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1887
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1890
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1893
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1896
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1899
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1902
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1905
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1908
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1911
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1914
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1917
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1920
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1923
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1926
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1929
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1932
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1935
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1938
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1941
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1944
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1947
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1950
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1953
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1956
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1959
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1962
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1965
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1968
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1971
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1974
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1977
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1980
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1983
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1986
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1989
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1992
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1995
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:1998
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2001
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2004
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2007
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2010
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2013
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2016
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2019
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2022
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2025
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2028
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2031
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2034
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2037
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2040
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2043
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2046
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2049
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2052
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2055
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2058
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2061
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2064
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2067
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2070
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2073
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2076
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2079
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2082
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2085
assert_return(
  () => invoke($0, `ne`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2088
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2091
assert_return(
  () =>
    invoke($0, `ne`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2094
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2097
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2100
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2103
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2106
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2109
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2112
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2115
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2118
assert_return(
  () => invoke($0, `ne`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2121
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2124
assert_return(
  () =>
    invoke($0, `ne`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2127
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2130
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2133
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2136
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2139
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2142
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2145
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2148
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2151
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2154
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2157
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2160
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2163
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2166
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2169
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2172
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2175
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2178
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2181
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2184
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2187
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2190
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2193
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2196
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2199
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2202
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2205
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2208
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2211
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2214
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2217
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2220
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2223
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2226
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2229
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2232
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2235
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2238
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2241
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2244
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2247
assert_return(
  () =>
    invoke($0, `ne`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2250
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2253
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2256
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2259
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2262
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2265
assert_return(
  () => invoke($0, `ne`, [f32x4([0, 0, 0, 0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2268
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2271
assert_return(
  () => invoke($0, `ne`, [f32x4([0, 0, 0, 0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2274
assert_return(
  () =>
    invoke($0, `ne`, [f32x4([0, 0, 0, 0]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2277
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2280
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2283
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2286
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2289
assert_return(
  () => invoke($0, `ne`, [f32x4([0, 0, 0, 0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2292
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2295
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2298
assert_return(
  () => invoke($0, `ne`, [f32x4([0, 0, 0, 0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2301
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2304
assert_return(
  () => invoke($0, `ne`, [f32x4([0, 0, 0, 0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2307
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2310
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2313
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2316
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2319
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2322
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2325
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2328
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2331
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2334
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2337
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2340
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2343
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2346
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2349
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2352
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2355
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2358
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2361
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2364
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2367
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2370
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2373
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2376
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2379
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2382
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2385
assert_return(
  () => invoke($0, `ne`, [f32x4([-1, -1, -1, -1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2388
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2391
assert_return(
  () => invoke($0, `ne`, [f32x4([-1, -1, -1, -1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2394
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2397
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2400
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2403
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2406
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2409
assert_return(
  () =>
    invoke($0, `ne`, [f32x4([-1, -1, -1, -1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2412
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2415
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2418
assert_return(
  () => invoke($0, `ne`, [f32x4([-1, -1, -1, -1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2421
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2424
assert_return(
  () => invoke($0, `ne`, [f32x4([-1, -1, -1, -1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2427
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2430
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2433
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2436
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2439
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2442
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2445
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2448
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2451
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2454
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2457
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2460
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2463
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2466
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2469
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2472
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2475
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2478
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2481
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2484
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2487
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2490
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2493
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2496
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2499
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2502
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2505
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2508
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2511
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2514
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2517
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2520
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2523
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2526
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2529
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2532
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2535
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2538
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2541
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2544
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2547
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2550
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2553
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2556
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2559
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2562
assert_return(
  () =>
    invoke($0, `ne`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2567
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2570
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2573
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2576
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2579
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2582
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2585
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2588
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2591
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2594
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2597
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2600
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2603
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2606
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2609
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2612
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2615
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2618
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2621
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2624
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2627
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2630
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2633
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2636
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2639
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2642
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2645
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2648
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2651
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2654
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2657
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2660
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2663
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2666
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2669
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2672
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2675
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2678
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2681
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2684
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2687
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2690
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2693
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2696
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2699
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2702
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2705
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2708
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2711
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2714
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2717
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2720
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2723
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2726
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2729
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2732
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2735
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2738
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2741
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2744
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2747
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2750
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2753
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2756
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2759
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2762
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2765
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2768
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2771
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2774
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2777
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2780
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2783
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2786
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2789
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2792
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2795
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2798
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2801
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2804
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2807
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2810
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2813
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2816
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2819
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2822
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2825
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2828
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2831
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2834
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2837
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2840
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2843
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2846
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2849
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2852
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2855
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2858
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2861
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2864
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2867
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2870
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2873
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2876
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2879
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2882
assert_return(
  () => invoke($0, `lt`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2885
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2888
assert_return(
  () => invoke($0, `lt`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2891
assert_return(
  () =>
    invoke($0, `lt`, [f32x4([1, 1, 1, 1]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2894
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2897
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2900
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2903
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2906
assert_return(
  () => invoke($0, `lt`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2909
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2912
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2915
assert_return(
  () => invoke($0, `lt`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2918
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2921
assert_return(
  () => invoke($0, `lt`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2924
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2927
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2930
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2933
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2936
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2939
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2942
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2945
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2948
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2951
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2954
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2957
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2960
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2963
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2966
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2969
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2972
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2975
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2978
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2981
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2984
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2987
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2990
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2993
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2996
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:2999
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3002
assert_return(
  () => invoke($0, `lt`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3005
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3008
assert_return(
  () => invoke($0, `lt`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3011
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3014
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3017
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3020
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3023
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3026
assert_return(
  () =>
    invoke($0, `lt`, [f32x4([-0, -0, -0, -0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3029
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3032
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3035
assert_return(
  () => invoke($0, `lt`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3038
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3041
assert_return(
  () => invoke($0, `lt`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3044
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3047
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3050
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3053
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3056
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3059
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3062
assert_return(
  () =>
    invoke($0, `lt`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3065
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3068
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3071
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3074
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3077
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3080
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3083
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3086
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3089
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3092
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3095
assert_return(
  () =>
    invoke($0, `lt`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3098
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3101
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3104
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3107
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3110
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3113
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3116
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3119
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3122
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3125
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3128
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3131
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3134
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3137
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3140
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3143
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3146
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3149
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3152
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3155
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3158
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3161
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3164
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3167
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3170
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3173
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3176
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3179
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3182
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3185
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3188
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3191
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3194
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3197
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3200
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3203
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3206
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3209
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3212
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3215
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3218
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3221
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3224
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3227
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3230
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3233
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3236
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3239
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3242
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3245
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3248
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3251
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3254
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3257
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3260
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3263
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3266
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3269
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3272
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3275
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3278
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3281
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3284
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3287
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3290
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3293
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3296
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3299
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3302
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3305
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3308
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3311
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3314
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3317
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3320
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3323
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3326
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3329
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3332
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3335
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3338
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3341
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3344
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3347
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3350
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3353
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3356
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3359
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3362
assert_return(
  () => invoke($0, `lt`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3365
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3368
assert_return(
  () =>
    invoke($0, `lt`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3371
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3374
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3377
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3380
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3383
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3386
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3389
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3392
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3395
assert_return(
  () => invoke($0, `lt`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3398
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3401
assert_return(
  () =>
    invoke($0, `lt`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3404
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3407
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3410
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3413
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3416
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3419
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3422
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3425
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3428
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3431
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3434
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3437
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3440
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3443
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3446
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3449
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3452
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3455
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3458
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3461
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3464
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3467
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3470
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3473
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3476
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3479
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3482
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3485
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3488
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3491
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3494
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3497
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3500
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3503
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3506
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3509
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3512
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3515
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3518
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3521
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3524
assert_return(
  () =>
    invoke($0, `lt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3527
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3530
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3533
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3536
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3539
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3542
assert_return(
  () => invoke($0, `lt`, [f32x4([0, 0, 0, 0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3545
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3548
assert_return(
  () => invoke($0, `lt`, [f32x4([0, 0, 0, 0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3551
assert_return(
  () =>
    invoke($0, `lt`, [f32x4([0, 0, 0, 0]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3554
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3557
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3560
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3563
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3566
assert_return(
  () => invoke($0, `lt`, [f32x4([0, 0, 0, 0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3569
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3572
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3575
assert_return(
  () => invoke($0, `lt`, [f32x4([0, 0, 0, 0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3578
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3581
assert_return(
  () => invoke($0, `lt`, [f32x4([0, 0, 0, 0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3584
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3587
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3590
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3593
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3596
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3599
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3602
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3605
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3608
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3611
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3614
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3617
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3620
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3623
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3626
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3629
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3632
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3635
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3638
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3641
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3644
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3647
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3650
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3653
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3656
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3659
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3662
assert_return(
  () => invoke($0, `lt`, [f32x4([-1, -1, -1, -1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3665
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3668
assert_return(
  () => invoke($0, `lt`, [f32x4([-1, -1, -1, -1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3671
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3674
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3677
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3680
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3683
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3686
assert_return(
  () =>
    invoke($0, `lt`, [f32x4([-1, -1, -1, -1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3689
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3692
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3695
assert_return(
  () => invoke($0, `lt`, [f32x4([-1, -1, -1, -1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3698
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3701
assert_return(
  () => invoke($0, `lt`, [f32x4([-1, -1, -1, -1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3704
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3707
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3710
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3713
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3716
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3719
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3722
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3725
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3728
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3731
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3734
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3737
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3740
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3743
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3746
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3749
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3752
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3755
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3758
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3761
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3764
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3767
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3770
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3773
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3776
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3779
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3782
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3785
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3788
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3791
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3794
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3797
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3800
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3803
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3806
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3809
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3812
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3815
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3818
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3821
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3824
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3827
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3830
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3833
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3836
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3839
assert_return(
  () =>
    invoke($0, `lt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3844
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3847
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3850
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3853
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3856
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3859
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3862
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3865
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3868
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3871
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3874
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3877
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3880
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3883
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3886
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3889
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3892
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3895
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3898
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3901
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3904
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3907
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3910
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3913
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3916
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3919
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3922
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3925
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3928
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3931
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3934
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3937
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3940
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3943
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3946
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3949
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3952
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3955
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3958
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3961
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3964
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3967
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3970
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3973
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3976
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3979
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3982
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3985
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3988
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3991
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3994
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:3997
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4000
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4003
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4006
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4009
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4012
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4015
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4018
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4021
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4024
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4027
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4030
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4033
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4036
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4039
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4042
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4045
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4048
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4051
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4054
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4057
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4060
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4063
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4066
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4069
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4072
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4075
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4078
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4081
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4084
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4087
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4090
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4093
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4096
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4099
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4102
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4105
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4108
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4111
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4114
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4117
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4120
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4123
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4126
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4129
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4132
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4135
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4138
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4141
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4144
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4147
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4150
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4153
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4156
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4159
assert_return(
  () => invoke($0, `le`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4162
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4165
assert_return(
  () => invoke($0, `le`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4168
assert_return(
  () =>
    invoke($0, `le`, [f32x4([1, 1, 1, 1]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4171
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4174
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4177
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4180
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4183
assert_return(
  () => invoke($0, `le`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4186
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4189
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4192
assert_return(
  () => invoke($0, `le`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4195
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4198
assert_return(
  () => invoke($0, `le`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4201
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4204
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4207
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4210
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4213
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4216
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4219
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4222
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4225
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4228
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4231
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4234
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4237
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4240
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4243
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4246
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4249
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4252
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4255
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4258
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4261
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4264
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4267
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4270
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4273
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4276
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4279
assert_return(
  () => invoke($0, `le`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4282
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4285
assert_return(
  () => invoke($0, `le`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4288
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4291
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4294
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4297
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4300
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4303
assert_return(
  () =>
    invoke($0, `le`, [f32x4([-0, -0, -0, -0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4306
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4309
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4312
assert_return(
  () => invoke($0, `le`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4315
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4318
assert_return(
  () => invoke($0, `le`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4321
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4324
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4327
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4330
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4333
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4336
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4339
assert_return(
  () =>
    invoke($0, `le`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4342
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4345
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4348
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4351
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4354
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4357
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4360
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4363
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4366
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4369
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4372
assert_return(
  () =>
    invoke($0, `le`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4375
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4378
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4381
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4384
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4387
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4390
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4393
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4396
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4399
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4402
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4405
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4408
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4411
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4414
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4417
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4420
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4423
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4426
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4429
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4432
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4435
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4438
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4441
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4444
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4447
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4450
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4453
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4456
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4459
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4462
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4465
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4468
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4471
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4474
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4477
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4480
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4483
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4486
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4489
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4492
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4495
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4498
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4501
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4504
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4507
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4510
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4513
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4516
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4519
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4522
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4525
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4528
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4531
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4534
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4537
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4540
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4543
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4546
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4549
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4552
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4555
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4558
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4561
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4564
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4567
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4570
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4573
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4576
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4579
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4582
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4585
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4588
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4591
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4594
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4597
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4600
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4603
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4606
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4609
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4612
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4615
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4618
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4621
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4624
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4627
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4630
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4633
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4636
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4639
assert_return(
  () => invoke($0, `le`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4642
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4645
assert_return(
  () =>
    invoke($0, `le`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4648
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4651
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4654
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4657
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4660
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4663
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4666
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4669
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4672
assert_return(
  () => invoke($0, `le`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4675
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4678
assert_return(
  () =>
    invoke($0, `le`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4681
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4684
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4687
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4690
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4693
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4696
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4699
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4702
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4705
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4708
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4711
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4714
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4717
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4720
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4723
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4726
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4729
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4732
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4735
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4738
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4741
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4744
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4747
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4750
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4753
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4756
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4759
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4762
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4765
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4768
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4771
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4774
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4777
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4780
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4783
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4786
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4789
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4792
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4795
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4798
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4801
assert_return(
  () =>
    invoke($0, `le`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4804
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4807
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4810
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4813
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4816
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4819
assert_return(
  () => invoke($0, `le`, [f32x4([0, 0, 0, 0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4822
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4825
assert_return(
  () => invoke($0, `le`, [f32x4([0, 0, 0, 0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4828
assert_return(
  () =>
    invoke($0, `le`, [f32x4([0, 0, 0, 0]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4831
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4834
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4837
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4840
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4843
assert_return(
  () => invoke($0, `le`, [f32x4([0, 0, 0, 0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4846
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4849
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4852
assert_return(
  () => invoke($0, `le`, [f32x4([0, 0, 0, 0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4855
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4858
assert_return(
  () => invoke($0, `le`, [f32x4([0, 0, 0, 0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4861
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4864
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4867
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4870
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4873
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4876
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4879
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4882
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4885
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4888
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4891
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4894
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4897
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4900
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4903
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4906
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4909
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4912
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4915
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4918
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4921
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4924
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4927
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4930
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4933
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4936
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4939
assert_return(
  () => invoke($0, `le`, [f32x4([-1, -1, -1, -1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4942
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4945
assert_return(
  () => invoke($0, `le`, [f32x4([-1, -1, -1, -1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4948
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4951
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4954
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4957
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4960
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4963
assert_return(
  () =>
    invoke($0, `le`, [f32x4([-1, -1, -1, -1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4966
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4969
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4972
assert_return(
  () => invoke($0, `le`, [f32x4([-1, -1, -1, -1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4975
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4978
assert_return(
  () => invoke($0, `le`, [f32x4([-1, -1, -1, -1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4981
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4984
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4987
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4990
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4993
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4996
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:4999
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5002
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5005
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5008
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5011
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5014
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5017
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5020
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5023
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5026
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5029
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5032
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5035
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5038
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5041
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5044
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5047
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5050
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5053
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5056
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5059
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5062
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5065
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5068
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5071
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5074
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5077
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5080
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5083
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5086
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5089
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5092
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5095
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5098
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5101
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5104
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5107
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5110
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5113
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5116
assert_return(
  () =>
    invoke($0, `le`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5121
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5124
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5127
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5130
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5133
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5136
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5139
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5142
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5145
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5148
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5151
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5154
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5157
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5160
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5163
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5166
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5169
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5172
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5175
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5178
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5181
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5184
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5187
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5190
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5193
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5196
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5199
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5202
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5205
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5208
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5211
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5214
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5217
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5220
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5223
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5226
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5229
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5232
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5235
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5238
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5241
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5244
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5247
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5250
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5253
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5256
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5259
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5262
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5265
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5268
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5271
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5274
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5277
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5280
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5283
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5286
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5289
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5292
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5295
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5298
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5301
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5304
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5307
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5310
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5313
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5316
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5319
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5322
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5325
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5328
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5331
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5334
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5337
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5340
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5343
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5346
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5349
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5352
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5355
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5358
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5361
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5364
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5367
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5370
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5373
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5376
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5379
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5382
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5385
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5388
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5391
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5394
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5397
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5400
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5403
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5406
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5409
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5412
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5415
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5418
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5421
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5424
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5427
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5430
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5433
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5436
assert_return(
  () => invoke($0, `gt`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5439
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5442
assert_return(
  () => invoke($0, `gt`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5445
assert_return(
  () =>
    invoke($0, `gt`, [f32x4([1, 1, 1, 1]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5448
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5451
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5454
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5457
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5460
assert_return(
  () => invoke($0, `gt`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5463
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5466
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5469
assert_return(
  () => invoke($0, `gt`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5472
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5475
assert_return(
  () => invoke($0, `gt`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5478
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5481
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5484
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5487
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5490
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5493
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5496
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5499
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5502
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5505
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5508
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5511
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5514
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5517
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5520
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5523
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5526
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5529
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5532
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5535
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5538
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5541
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5544
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5547
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5550
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5553
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5556
assert_return(
  () => invoke($0, `gt`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5559
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5562
assert_return(
  () => invoke($0, `gt`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5565
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5568
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5571
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5574
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5577
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5580
assert_return(
  () =>
    invoke($0, `gt`, [f32x4([-0, -0, -0, -0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5583
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5586
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5589
assert_return(
  () => invoke($0, `gt`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5592
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5595
assert_return(
  () => invoke($0, `gt`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5598
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5601
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5604
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5607
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5610
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5613
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5616
assert_return(
  () =>
    invoke($0, `gt`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5619
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5622
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5625
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5628
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5631
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5634
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5637
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5640
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5643
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5646
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5649
assert_return(
  () =>
    invoke($0, `gt`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5652
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5655
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5658
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5661
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5664
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5667
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5670
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5673
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5676
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5679
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5682
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5685
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5688
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5691
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5694
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5697
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5700
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5703
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5706
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5709
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5712
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5715
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5718
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5721
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5724
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5727
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5730
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5733
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5736
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5739
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5742
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5745
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5748
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5751
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5754
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5757
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5760
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5763
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5766
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5769
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5772
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5775
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5778
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5781
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5784
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5787
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5790
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5793
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5796
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5799
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5802
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5805
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5808
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5811
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5814
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5817
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5820
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5823
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5826
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5829
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5832
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5835
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5838
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5841
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5844
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5847
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5850
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5853
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5856
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5859
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5862
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5865
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5868
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5871
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5874
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5877
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5880
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5883
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5886
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5889
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5892
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5895
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5898
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5901
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5904
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5907
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5910
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5913
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5916
assert_return(
  () => invoke($0, `gt`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5919
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5922
assert_return(
  () =>
    invoke($0, `gt`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5925
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5928
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5931
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5934
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5937
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5940
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5943
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5946
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5949
assert_return(
  () => invoke($0, `gt`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5952
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5955
assert_return(
  () =>
    invoke($0, `gt`, [f32x4([0.5, 0.5, 0.5, 0.5]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5958
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0.5, 0.5, 0.5, 0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5961
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5964
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5967
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5970
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5973
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5976
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5979
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5982
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5985
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5988
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5991
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5994
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:5997
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6000
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6003
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6006
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6009
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6012
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6015
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6018
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6021
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6024
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6027
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6030
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6033
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6036
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6039
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6042
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6045
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6048
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6051
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6054
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6057
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6060
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6063
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6066
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6069
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6072
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6075
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6078
assert_return(
  () =>
    invoke($0, `gt`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6081
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6084
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6087
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6090
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6093
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6096
assert_return(
  () => invoke($0, `gt`, [f32x4([0, 0, 0, 0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6099
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6102
assert_return(
  () => invoke($0, `gt`, [f32x4([0, 0, 0, 0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6105
assert_return(
  () =>
    invoke($0, `gt`, [f32x4([0, 0, 0, 0]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6108
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6111
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6114
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6117
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6120
assert_return(
  () => invoke($0, `gt`, [f32x4([0, 0, 0, 0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6123
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6126
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6129
assert_return(
  () => invoke($0, `gt`, [f32x4([0, 0, 0, 0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6132
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6135
assert_return(
  () => invoke($0, `gt`, [f32x4([0, 0, 0, 0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6138
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([0, 0, 0, 0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6141
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6144
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6147
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6150
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6153
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6156
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6159
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6162
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6165
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6168
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6171
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6174
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6177
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6180
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6183
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6186
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6189
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6192
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6195
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6198
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([Infinity, Infinity, Infinity, Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6201
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6204
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6207
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6210
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6213
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6216
assert_return(
  () => invoke($0, `gt`, [f32x4([-1, -1, -1, -1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6219
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6222
assert_return(
  () => invoke($0, `gt`, [f32x4([-1, -1, -1, -1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6225
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6228
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6231
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6234
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6237
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6240
assert_return(
  () =>
    invoke($0, `gt`, [f32x4([-1, -1, -1, -1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6243
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6246
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6249
assert_return(
  () => invoke($0, `gt`, [f32x4([-1, -1, -1, -1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6252
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6255
assert_return(
  () => invoke($0, `gt`, [f32x4([-1, -1, -1, -1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6258
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([-1, -1, -1, -1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6261
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6264
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6267
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6270
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6273
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6276
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6279
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6282
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6285
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6288
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6291
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6294
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6297
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6300
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6303
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6306
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6309
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6312
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6315
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6318
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6321
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6324
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6327
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6330
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6333
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6336
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6339
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6342
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6345
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6348
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6351
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6354
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6357
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6360
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6363
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6366
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6369
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6372
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6375
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6378
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6381
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6384
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
        0.000000000012345679,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6387
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6390
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
        1234567900000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6393
assert_return(
  () =>
    invoke($0, `gt`, [
      f32x4([123456790, 123456790, 123456790, 123456790]),
      f32x4([123456790, 123456790, 123456790, 123456790]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6398
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6401
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6404
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6407
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6410
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6413
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6416
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6419
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6422
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6425
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6428
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6431
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6434
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6437
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6440
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6443
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6446
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6449
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6452
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6455
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6458
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6461
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6464
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6467
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6470
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6473
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6476
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6479
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6482
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6485
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6488
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6491
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6494
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6497
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6500
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6503
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6506
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6509
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6512
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6515
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6518
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6521
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6524
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6527
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6530
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6533
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6536
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6539
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6542
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6545
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6548
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6551
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6554
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6557
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6560
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6563
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6566
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6569
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6572
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6575
assert_return(
  () =>
    invoke($0, `ge`, [
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6578
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6581
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6584
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6587
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6590
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6593
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6596
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6599
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6602
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6605
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6608
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6611
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6614
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6617
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6620
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6623
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6626
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6629
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6632
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6635
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6638
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6641
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6644
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6647
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6650
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6653
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6656
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6659
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6662
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6665
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6668
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6671
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6674
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6677
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6680
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6683
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6686
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6689
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6692
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6695
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6698
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6701
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6704
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6707
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6710
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6713
assert_return(
  () => invoke($0, `ge`, [f32x4([1, 1, 1, 1]), f32x4([1, 1, 1, 1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6716
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6719
assert_return(
  () => invoke($0, `ge`, [f32x4([1, 1, 1, 1]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6722
assert_return(
  () =>
    invoke($0, `ge`, [f32x4([1, 1, 1, 1]), f32x4([-0.5, -0.5, -0.5, -0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6725
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6728
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6731
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6734
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6737
assert_return(
  () => invoke($0, `ge`, [f32x4([1, 1, 1, 1]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6740
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6743
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6746
assert_return(
  () => invoke($0, `ge`, [f32x4([1, 1, 1, 1]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6749
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6752
assert_return(
  () => invoke($0, `ge`, [f32x4([1, 1, 1, 1]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6755
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([1, 1, 1, 1]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6758
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6761
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6764
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6767
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6770
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6773
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([1, 1, 1, 1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6776
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6779
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6782
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6785
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6788
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6791
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6794
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6797
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6800
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6803
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6806
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([0, 0, 0, 0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6809
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6812
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6815
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6818
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6821
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6824
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6827
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6830
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6833
assert_return(
  () => invoke($0, `ge`, [f32x4([-0, -0, -0, -0]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6836
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6839
assert_return(
  () => invoke($0, `ge`, [f32x4([-0, -0, -0, -0]), f32x4([-0, -0, -0, -0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6842
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6845
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6848
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6851
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6854
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6857
assert_return(
  () =>
    invoke($0, `ge`, [f32x4([-0, -0, -0, -0]), f32x4([0.5, 0.5, 0.5, 0.5])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6860
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6863
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6866
assert_return(
  () => invoke($0, `ge`, [f32x4([-0, -0, -0, -0]), f32x4([0, 0, 0, 0])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6869
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6872
assert_return(
  () => invoke($0, `ge`, [f32x4([-0, -0, -0, -0]), f32x4([-1, -1, -1, -1])]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6875
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0, -0, -0, -0]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6878
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6881
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6884
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6887
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6890
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([6.2831855, 6.2831855, 6.2831855, 6.2831855]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6893
assert_return(
  () =>
    invoke($0, `ge`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([1, 1, 1, 1])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6896
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
        -340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6899
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0, -0, -0, -0]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6902
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-0.5, -0.5, -0.5, -0.5]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6905
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6908
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6911
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
        -0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6914
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
        -0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6917
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([0.5, 0.5, 0.5, 0.5]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6920
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-6.2831855, -6.2831855, -6.2831855, -6.2831855]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6923
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
        0x0,
        0x0,
        0xa0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6926
assert_return(
  () =>
    invoke($0, `ge`, [f32x4([-0.5, -0.5, -0.5, -0.5]), f32x4([0, 0, 0, 0])]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6929
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6932
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([-1, -1, -1, -1]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6935
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([-0.5, -0.5, -0.5, -0.5]),
      f32x4([
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
        0.000000000000000000000000000000000000011754944,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6938
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6941
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
        0.000000000000000000000000000000000000000000001,
      ]),
    ]),
  [i32x4([0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6944
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      bytes("v128", [
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
        0x0,
        0x0,
        0xa0,
        0xff,
      ]),
    ]),
  [i32x4([0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_f32x4_cmp.wast:6947
assert_return(
  () =>
    invoke($0, `ge`, [
      f32x4([
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
        340282350000000000000000000000000000000,
      ]),
      f32x4([-Infini