# Staged release process

## Goal

Today, the release process is all baked into a single release definition, including validation checks, manual steps, etc. 
Also, it requires some pre-work by the PM to download the bits, order them and making sure they are available for the overall
process. With the data in BAR and commands supported by `darc` we can automate some of things.

Also, we would like to introduce the concept of "promotion". In order for a build to be shipped it would need to go
through several **rings**. Each ring has different types of validations. A build is only promoted if it passes all the 
validation checks.

## Release Rings

### Prep Ring

* Generate the file share by running `darc gather-drop`
* Notarize and replace PKGs

**Promotion:** 
* Contract is valid 
* Version is coherent
* Release Team approval

### Source Validation Ring

* Run SDL validation on each repo+sha from the candidate build generated in the Prep Ring

**Promotion:**
* All legs succeed (we'll provide a manual override in case legs fail but failures are known and/or
  we don't want to block the pipeline due to this errors)

### [Build Validation Ring (Candidate Validation channel)](https://dnceng.visualstudio.com/internal/_git/dotnet-release?path=%2Fdocumentation%2Frelease-validation.md)

* BinSkim validation
* Packages validation
* Symbols validation
* Sourcelink validation
* Checksum validation
* Asset validation
* Signing validation

When all the above have succeeded, we'll do:

* VS Insertion
  * VAL Build
* CTI Validation 

**Promotion:** 
* Contract is valid 
* CTI sign off
* VAL build is green
* Individual teams sign off
* Tactics approval

### Staging Ring (Release Staging channel)

* No build required
* Antares: set of zips used to deploy to Azure App Services for the SDK, Runtime and ASP. SDK and Runtime are generated by a 
post-build script. Zips are validated by the ASP team against an App Services test environment
* Create SDK tarball
* Mac + Linux signing
* Create release notes
* Aggregate checksums
* Create release metadata

**Promotion:**
* Contract is valid
* Each task's validation passes
* Tactics approve this version

### Final Release/Publish Ring (Publish Release channel)
 
* Create Git Tags
* Publish and validate to CDN
* Publish signed bits to blob storage
* Publish aggregated checksums to blob storage
* Publish and validate to NuGet
* Publish and validate NuGet symbols
* Publish SNAP
* Publish and validate Linux distributions
* Antares deployment*
* Publish and validate Docker
* Publish signed bits to dot.net
* Publish release notes and metadata to GitHub


<!-- Begin Generated Content: Doc Feedback -->
<sub>Was this helpful? [![Yes](https://helix.dot.net/f/ip/5?p=Documentation%5CReleaseRingsPlan.md)](https://helix.dot.net/f/p/5?p=Documentation%5CReleaseRingsPlan.md) [![No](https://helix.dot.net/f/in)](https://helix.dot.net/f/n/5?p=Documentation%5CReleaseRingsPlan.md)</sub>
<!-- End Generated Content-->
