.\" dselect manual page - dselect(1)
.\"
.\" Copyright © 1995 Juho Vuori <javuori@cc.helsinki.fi>
.\" Copyright © 2000 Josip Rodin
.\" Copyright © 2001 Joost Kooij
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2010-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dselect 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
dselect \- Debian\-Paketverwaltungsoberfläche
.
.SH ÜBERSICHT
\fBdselect\fP [\fIOption\fP …] [\fIBefehl\fP …]
.
.SH BESCHREIBUNG
\fBdselect\fP
ist eine der primären Benutzerschnittstellen zur Verwaltung von Paketen auf
einem Debian\-System. Im Basis\-Menü von \fBdselect\fP kann der Systemadministrator:
 \- Die Liste der verfügbaren Paketversionen aktualisieren,
 \- Den Status der installierten und verfügbaren Pakete betrachten,
 \- Die Paketauswahl ändern und Abhängigkeiten verwalten,
 \- Neue Pakete installieren oder ein Upgrade auf neuere Versionen durchführen.
.PP
\fBdselect\fP arbeitet als Oberfläche von \fBdpkg\fP(1), dem systemnahen
Debian\-Paket\-Handhabungswerkzeug. Es bietet einen
Vollbildschirm\-Paketauswahl\-Verwalter mit einem Paketeabhängigkeits\- und
\-konfliktlöser. Bei Aufruf mit Administratorprivilegien können Pakete
installiert und entfernt sowie Upgrades durchgeführt werden. Verschiedene
Zugriffsmethoden können konfiguriert werden um verfügbare Paketinformationen
und installierbare Pakete aus Paketdepots zu holen. Abhängig von der
verwendeten Zugriffsmethode können diese Depots öffentliche Archiv\-Server im
Internet, lokale Archiv\-Server oder CD\-ROMs sein. Die empfohlene
Zugriffsmethode ist \fIapt\fP, die vom Paket \fBapt\fP bereitgestellt wird.
.PP
Normalerweise wird \fBdselect\fP ohne Parameter aufgerufen. Es wird ein
interaktives Menü präsentiert, das dem Benutzer eine Liste von Befehlen
anbietet. Falls ein Befehl als Argument übergeben wird, wird dieser Befehl
sofort begonnen. Es sind noch mehrere Befehlszeilenparameter vorhanden, um
das Laufzeitverhalten von \fBdselect\fP zu verändern oder zusätzliche
Informationen über das Programm anzuzeigen.
.
.SH OPTIONEN
Alle Optionen können sowohl auf der Befehlszeile als auch in der
Konfigurationsdatei \fI%PKGCONFDIR%/dselect.cfg\fP oder in den Dateien im
Konfigurationsverzeichnis \fI%PKGCONFDIR%/dselect.cfg.d/\fP von \fBdselect\fP
angegeben werden. Jede Zeile in der Konfigurationsdatei ist entweder eine
Option (exakt identisch mit der Befehlszeilenoption, nur ohne einleitende
Bindestriche) oder ein Kommentar (falls sie mit ‚\fB#\fP’ beginnt).
.br
.TP 
\fB\-\-admindir\fP\fI Verzeichnis\fP
Ändert das Verzeichnis, in dem die Dateien ‚\fIstatus\fP’, ‚\fIavailable\fP’ und
ähnliche Dateien von Dpkg liegen. Standardmäßig ist dies \fI%ADMINDIR%\fP und
normalerweise sollte es keinen Grund geben, dieses zu ändern.
.TP 
\fB\-D\fP\fIDatei\fP, \fB\-\-debug\fP \fIDatei\fP
Aktiviert Fehlersuche. Fehlersuchinformationen werden nach \fIDatei\fP
gesendet.
.TP 
\fB\-\-expert\fP
Aktiviert den Expertenmodus, d.h. zeigt keine möglicherweise nervenden
Hilfeinformationen an.
.TP 
\fB\-\-colour\fP|\fB\-\-color\fP \fIBildschirmteil\fP:[\fIVordergrund\fP],[\fIHintergrund\fP][:\fIAttr\fP[\fI+Attr\fP]…]
Konfiguriert die Bildschirmfarben. Dies funktioniert nur, falls Ihr
Bildschirm Farben unterstützt. Diese Option kann mehrfach verwendet werden
(und wird am besten in \fIdselect.cfg\fP verwendet). Jede Verwendung ändert die
Farben (und optional andere Attribute) eines Teils des Bildschirms. Die
Teile des Bildschirms (von oben nach unten) sind:
.RS
.TP 
\fBtitle\fP
Der Bildschirm\-Titel.
.TP 
\fBlisthead\fP
Die Kopfzeile über der Paketliste.
.TP 
\fBlist\fP
Die scrollende Liste von Paketen (und auch etwas Hilfetext).
.TP 
\fBlistsel\fP
Der ausgewählte Eintrag in der Liste.
.TP 
\fBpkgstate\fP
In der Liste der Pakete, der Text, der den aktuellen Zustand jedes Pakets
anzeigt.
.TP 
\fBpkgstatesel\fP
In der Liste der Pakete, der Text, der den aktuellen Zustand des aktuell
ausgewählten Paketes anzeigt.
.TP 
\fBinfohead\fP
Die Kopfzeile, die den Zustand des aktuell ausgewählten Paketes anzeigt.
.TP 
\fBinfodesc\fP
Die Kurzbeschreibung des Pakets.
.TP 
\fBinfo\fP
Verwendet um Paketinformationen wie die Paketbeschreibung anzuzeigen.
.TP 
\fBinfofoot\fP
Die unterste Zeile des Bildschirms bei der Paketauswahl.
.TP 
\fBquery\fP
Verwendet zum Anzeigen von Abfragezeilen
.TP 
\fBhelpscreen\fP
Farbe der Hilfebildschirme.
.RE
.IP
Nach dem Teil des Bildschirms kommt ein Doppelpunkt und die Farbangabe. Sie
können entweder die Vordergrundfarbe, die Hintergrundfarbe oder beide
angeben und damit die eingebauten Werte überschreiben. Verwenden Sie die
Standard\-Farbnamen von Curses.
.IP
Optional kann nach der Farbangabe ein weiterer Doppelpunkt und eine
Attribut\-Angabe folgen. Dies ist eine Liste von einem oder mehreren
Attribut(en), getrennt durch Plus\-Zeichen (‚+’). Folgende Attribute sind
verfügbar (aber nicht alle funktionieren in allen Terminals): \fBnormal\fP,
\fBstandout\fP, \fBunderline\fP, \fBreverse\fP, \fBblink\fP, \fBbright\fP, \fBdim\fP, \fBbold\fP
.TP 
\fB\-?\fP, \fB\-\-help\fP
Gib einen kurzen Hilfetext aus und beende sich erfolgreich.
.TP 
\fB\-\-version\fP
Gebe Versionsinformationen aus und beende sich erfolgreich.
.
.SH BEFEHLE
Wenn \fBDselect\fP gestartet wird, kann es die folgenden Befehle ausführen,
entweder direkt, falls sie auf der Befehlszeile angegeben wurde oder indem
dem Benutzer ein Menü der verfügbaren Befehle bei interkativen Betrieb
angezeigt wird:
.SS Zugriff
Wähle und konfiguriere eine Zugriffsmethode für Paketdepots.
.sp
By default, \fBdselect\fP provides several methods such as \fIcdrom\fP,
\fImulti_cd\fP, \fInfs\fP, \fImulti_nfs\fP, \fIharddisk\fP, \fImounted\fP, \fImulti_mount\fP
or \fIftp\fP, but other packages may provide additional methods, eg. the \fIapt\fP
access method provided by the \fBapt\fP package.
.sp
Die Verwendung der \fIapt\fP\-Zugriffsmethode wird nachdrücklich empfohlen.
.sp
.SS Erneuern
Die verfügbare Paketdatenbank auffrischen.
.sp
Holt die Liste der verfügbaren Paketversionen aus dem Paket\-Depot, das für
die aktuelle Zugriffsmethode konfiguriert ist, und aktualisiert die
Datenbank von dpkg. Die Paketliste wird im Depot typischerweise in Dateien
mit den Namen \fIPackages\fP oder \fIPackages.gz\fP bereitgestellt. Diese Dateien
können von den Betreuern des Depots mit dem Programm \fBdpkg\-scanpackages\fP(1)
erstellt werden.
.sp
Die Details des Befehls »Erneuern« hängen von der Implementierung der
Zugriffsmethode ab. Normalerweise ist der Prozess unkompliziert und verlangt
keine Benutzerinteraktionen.
.sp
.SS Auswählen
Paketauswahlen oder \-abhängigkeiten betrachten oder verwalten.
.sp
Dies ist die Hauptfunktionalität von \fBdselect\fP. Im Auswahlbildschirm kann
der Benutzer die Liste der verfügbaren und installierten Pakete
begutachten. Wenn \fBdselect\fP mit administrativen Rechten ausgeführt wird ist
es auch möglich, den Paketauswahlzustand interaktiv zu verändern. \fBdselect\fP
verfolgt die Auswirkungen dieser Änderungen auf andere abhängige oder im
Konflikt stehende Pakete.
.sp
Wenn ein Konflikt oder eine fehlgeschlagene Abhängigkeit erkannt wird, wird
dem Benutzer ein Unterbildschirm mit einer Lösung der
Abhängigkeitsproblematik angeboten. Auf diesem Bildschirm wird eine Liste
der im Konflikt stehenden oder abhängigen Pakete gezeigt, wobei für jedes
aufgeführte Paket der Grund ebenfalls angegeben ist. Der Benutzer kann die
Vorschläge von \fBdselect\fP annehmen, sich über sie hinwegsetzen oder alle
Änderungen zurücknehmen, darunter diejenigen, die zu den unerfüllten
Abhängigkeiten oder Konflikten führten.
.sp
Die Verwendung des interaktiven Paketauswahlbildschirms wird unten
detaillierter beschrieben.
.sp
.SS Installieren
Installiert ausgewählte Pakete.
.sp
Die konfigurierte Zugriffsmethode wird installierbare oder für ein Upgrade
verfügbare Pakete aus den relevanten Depots holen und dann mittels \fBdpkg\fP
installieren. Abhängig von der Implementation der Zugriffsmethode können
alle Pakete vor der Installation bereits geholt werden, oder bei Bedarf
geholt werden. Bei einigen Zugriffsmethoden werden auch Pakete entfernt, die
zur Entfernung markiert wurden.
.sp
Falls während der Installation ein Fehler auftrat ist es normalerweise
empfehlenswert, die Installation erneut durchzuführen. In den meisten Fällen
wird das Problem verschwinden oder gelöst werden. Falls Probleme bleiben
oder die durchgeführte Installation nicht korrekt war, untersuchen Sie bitte
den Grund und die Umstände und reichen Sie einen Fehler in der
Fehlerdatenbank von Debian ein. Anleitungen wie dies erfolgen kann, sind auf
https://bugs.debian.org/ verfügbar oder können durch Lesen der Dokumentation
für \fBbug\fP(1) oder \fBreportbug\fP(1) (falls diese installiert sind) erhalten
werden.
.sp
Details des Installationsbefehls hängen von der Implementierung der
Zugriffsmethode ab. Die Aufmerksamkeit und Eingabe des Benutzers könnten
während der Installation, Konfiguration oder dem Entfernen von Paketen
notwendig sein. Dies hängt von den Betreuerskripten im Paket ab. Einige
Pakete verwenden die Bibliothek \fBdebconf\fP(1), die flexiblere oder sogar
automatisierte Installationseinrichtungen erlaubt.
.sp
.SS Konfig
Konfiguriert alle bisher installierten, aber noch nicht voll konfigurierten
Pakete.
.sp
.SS Löschen
Löscht oder entfernt installierte Pakete vollständig, die zum Löschen
markiert sind.
.sp
.SS Beenden
\fBDselect\fP beenden
.sp
Beendet das Programm mit dem Fehlercode Null (erfolgreich).
.sp
.
.SH PAKETAUSWAHLVERWALTUNG
.sp
.SS Einführung
.sp
\fBdselect\fP setzt den Administrator direkt einigen Komplexitäten aus, die
beim Verwalten großer Paketmengen mit vielen Abhängigkeiten untereinander
auftreten. Für einen Benutzer, der sich mit den Konzepten und den Arten des
Debian\-Paktverwaltungssystems nicht auskennt kann dies recht überwältigend
sein. Obwohl \fBdselect\fP darauf abzielt, die Paketverwaltung und
\-administration zu vereinfachen, kann es dazu nur ein Werkzeug sein und
somit nicht ausreichende Administratorfähigkeiten und
Administratorverständnis ersetzen. Es wird vom Benutzer erwartet, dass er
mit den Konzepten des unterliegenden Debian\-Paketsystems vertraut ist. Im
Zweifelsfall ziehen Sie die Handbuchseite \fBdpkg\fP(1) und die Richtlinien der
Distribution zu Rate.
.sp
Falls \fBdselect\fP nicht im Experten\- oder direkten Modus läuft wird zuerst
ein Hilfebildschirm angezeigt, wenn dieser Befehl vom Menü ausgewählt
wird. Dem Benutzer wird \fInachdrücklich\fP empfohlen, die gesamten in der
Online\-Hilfe angezeigten Informationen zu prüfen, wenn diese angezeigt
werden. Die Online\-Hilfebildschirme können jederzeit mit der Taste ‚\fB?\fP’
aufgerufen werden.
.sp
.SS Bildschirmlayout
.sp
Der Auswahlbildschirm ist standardmäßig in eine obere und eine untere Hälfte
geteilt. Die obere Hälft zeigt eine Liste von Paketen. Ein Cursorbalken
wählt individuelle Pakete oder, falls zutreffend, eine Gruppe von Paketen
durch Auswahl der Gruppenkopfzeile aus. Die untere Hälfte des Bildschirms
zeigt einige Details über das derzeit in der oberen Hälfte des Bildschirms
ausgewählte Paket an. Die Art der angezeigten Details kann variiert werden.
.sp
Drücken der Taste ‚\fBI\fP’ schaltet zwischen der Vollbilddarstellung der
Paketliste, einer vergrößerten Darstellung der Paketdetails und dem
gleichmäßig geteilten Bildschirm um.
.sp
.SS Paket\-Detailbetrachtung
.sp
Standardmäßig zeigt die Paket\-Detailbetrachtung die ausführliche
Paketbeschreibung des derzeit in der Paketstatusliste ausgewählten Pakets.
Die Art der Details kann durch Drücken der Taste ‚\fBi\fP’ umgeschaltet werden.
Diese wechseln zwischen:
 \- der ausführlichen Beschreibung
 \- der Steuerinformation für die installierte Version
 \- der Steuerinformation für die verfügbare Version
.sp
Im Bildschirm der Abhängigkeitsauflösung gibt es auch die Möglichkeit, die
spezifizierten nicht aufgelösten Abhängigkeiten oder Konflikte mit Bezug zu
dem Paket anzuschauen und deren Auflistung zu erreichen.
.sp
.SS Paketstatusliste
.sp
Der Hauptauswahlbildschirm zeigt eine Liste aller Pakete, die dem
Debian\-Paketverwaltungssystem bekannt sind. Dies beinhaltet alle auf dem
System installierten Pakete und Pakete, die aus den verfügbaren
Paketdatenbanken bekannt sind.
.sp
Für jedes Paket zeigt die Liste den Paketstatus, die Priorität, die Sektion,
installierte und verfügbare Architektur, installierte und verfügbare
Versionen, den Namen und die Kurzbeschreibung des Paketes, alles in einer
Zeile. Durch Drücken der Taste ‚\fBA\fP’ kann die Anzeige der installierten und
verfügbaren Architektur an\- und ausgeschaltet werden. Durch Drücken der
Taste ‚\fBV\fP’ kann die Anzeige der installierten und verfügbaren Version
zwischen ein und aus umgeschaltet werden. Durch Drücken der Taste ‚\fBv\fP’
wird die Anzeige des Paketstatus zwischen ausführlich und verkürzt
umgeschaltet. Die verkürzte Anzeige ist voreingestellt.
.sp
Die Kurzstatusangabe besteht aus vier Teilen: einer Fehlermarkierung, die
normalerweise leer sein sollte, dem aktuellen Status, dem letzten
Auswahlstatus und dem aktuellen Auswahlstatus. Die ersten zwei beziehen sich
auf den derzeitigen Status des Pakets, das zweite Paar behandeln die vom
Benutzer gesetzte Auswahl.
.sp
Dies sind die Bedeutungen der kurzen Paketstatus\-Anzeige\-Codes:
 Fehlermarkierung:
  \fIleer\fP    kein Fehler
  \fBR\fP       schwerwiegender Fehler, Neuinstallation notwendig;
 Installierter Status:
  \fIleer\fP    nicht installiert;
  \fB*\fP       vollständig installiert und konfiguriert;
  \fB\-\fP       nicht installiert, aber einige Konfigurationsdateien könnten bleiben;
  \fBU\fP       entpackt, aber noch nicht konfiguriert;
  \fBC\fP       halb konfiguriert (ein Fehler ist aufgetreten);
  \fBI\fP       halb installiert (ein Fehler ist aufgetreten).
 Aktuelle und angeforderte Auswahlen:
  \fB*\fP       markiert zur Installation oder Upgrade;
  \fB\-\fP       markiert zur Entfernung, Konfigurationsdateien bleiben;
  \fB=\fP       auf »halten«: Paket wird überhaupt nicht verarbeitet werden;
  \fB_\fP       markiert zum vollständigen Löschen, auch der Konfiguration;
  \fBn\fP       Paket ist neu und muss erst noch markiert werden.
.sp
.SS "Cursor\- und Bildschirm\-Bewegung"
.sp
Die Paketauswahllisten und die Abhängigkeitskonflikte\-Lösungsbildschirme
können mit den Bewegungsbefehlen navigiert werden, die auf die folgenden
Tasten abgebildet sind:
.br
  \fBp, Hoch, k\fP                bewege Cursor\-Balken hoch
  \fBn, Runter, j\fP              bewege Cursor\-Balken runter
  \fBP, Bild hoch, Rückschritt\fP scrolle Liste eine Seite hoch
  \fBN, Bild runter, Leertaste\fP scrolle Liste eine Seite runter
  \fB^p\fP                        scrolle Liste eine Zeile hoch
  \fB^n\fP                        scrolle Liste eine Zeile runter
  \fBt, Pos 1\fP                  springe zum Listen\-Anfang
  \fBe, Ende\fP                   springe zum Listen\-Ende
  \fBu\fP                         scrolle Info eine Seite hoch
  \fBd\fP                         scrolle Info eine Seite runter
  \fB^u\fP                        scrolle Info eine Zeile hoch
  \fB^d\fP                        scrolle Info eine Zeile runter
  \fBB, Linker Pfeil\fP           bewege Bildschirm 1/3\-Bildschirmbreite links
  \fBF, Rechter Pfeil\fP          bewege Bildschirm 1/3\-Bildschirmbreite rechts
  \fB^b\fP                        bewege Bildschirm ein Zeichen nach links
  \fB^f\fP                        bewege Bildschirm ein Zeichen nach rechts
.sp
.SS "Suchen und Sortieren"
.sp
Die Liste der Pakete kann nach Paketnamen durchsucht werden. Dies erfolgt
durch Drücken von ‚\fB/\fP’ und der Eingabe einer einfachen
Suchzeichenkette. Die Zeichenkette wird als regulärer Ausdruck gemäß
\fBregex\fP(7) interpretiert. Falls Sie zu dem Suchausdruck ‚\fB/d\fP’ hinzufügen
wird Dselect auch in Beschreibungen suchen. Falls Sie ‚\fB/id\fP’ hinzufügen,
wird Groß\-/Kleinschreibung ignoriert. Sie können die Suffixe wie folgt
kombinieren: \fB»/id«\fP. Wiederholtes Suchen wird durch Drücken von ‚\fBn\fP’
oder ‚\fB\e\fP’ erreicht, bis das gewünschte Paket gefunden wurde. Falls die
Suche das Ende der Liste erreicht, springt sie zum Anfang und fährt von dort
fort.
.sp
Die List\-Sortierreihenfolge kann durch wiederholtes
Drücken der Tasten ‚\fBo\fP’ and ‚\fBO\fP’ verändert werden.
Die folgenden Sortierreihenfolgen können ausgewählt werden:
 alphabetisch      verfügbar           Status
 Priorität+Sektion verfügbar+Priorität Status+Priorität
 Bereich+Priorität verfügbar+Bereich   Status+Bereich
.br
Wo dies oben nicht explizit aufgeführt ist, wird alphabetische Reihenfolge
als abschließender Unterordnungs\-Sortierschlüssel verwendet.
.sp
.SS "Auswahlen ändern"
.sp
Der angeforderte Auswahlstatus individueller Pakete kann mit
den folgenden Befehlen geändert werden:
  \fB+, Einfg\fP     Installieren oder Upgrade durchführen
  \fB=, H\fP         gegenwärtigen Status und Version beibehalten
  \fB:, G\fP         Loslassen: Upgrad durchführen oder uninstalliert lassen
  \fB\-, Entf\fP      Entfernen, aber Konfiguration behalten
  \fB_\fP            Entfernen und Konfiguration löschen
.sp
Wenn sich aus der Änderungsanforderung eine oder mehrere unerfüllte
Abhängigkeiten oder Konflikte ergeben, bietet \fBdselect\fP dem Benutzer einen
Bildschirm zu Abhängigkeitsauflösung an. Dieser wird weiter unten
detaillierter beschrieben.
.sp
Es ist auch möglich, die Befehle auf Gruppen von Paketauswahlen anzuwenden,
indem mit dem Cursor\-Balken die Gruppen\-Überschrift ausgewählt wird. Die
genaue Gruppierung der Pakete hängt von den Einstellungen der aktuellen
Listensortierung ab.
.sp
Veränderungen von großen Gruppen von Auswahlen sollten vorsichtig
durchgeführt werden, da dies sofort zu einer großen Anzahl an
nicht\-aufgelösten Abhängigkeiten oder Konflikten führen kann, die dann alle
im Bildschirm der Abhängigkeitsauflösung dargestellt werden. Dies kann dann
schwer zu handhaben sein. In der Praxis sind nur die Operationen Halten und
Loslassen nützlich, wenn sie auf Gruppen angewandt werden.
.sp
.SS "Abhängigkeiten und Konflikte auflösen"
.sp
Wenn sich aus der Änderungsanforderung eine oder mehrere unerfüllte
Abhängigkeiten oder Konflikte ergeben, bietet \fBdselect\fP dem Benutzer einen
Bildschirm zu Abhängigkeitsauflösung an. Zuerst wird allerdings ein
Hilfebildschirm angezeigt.
.sp
Die obere Hälfte dieses Bildschirms führt alle Pakete auf, die auf Grund der
angeforderten Änderung unerfüllte Abhängigkeiten oder Konflikte haben und
alle Pakete, deren Installation (einige) dieser Abhängigkeiten erfüllen oder
deren Entfernung (einige) der Konflikte beseitigen kann. Die untere Hälfte
zeigt standardmäßig die Abhängigkeiten oder Konflikte, die zu der Auflistung
des derzeit ausgewählte Paketes geführt haben.
.sp
Wenn anfänglich eine Teilliste von Paketen dargestellt wird, könnte
\fBdselect\fP bereits den erbetenen Auswahlstatus von einigen der aufgeführten
Pakete gesetzt haben, um die Abhängigkeiten oder Konflikte aufzulösen, die
dazu geführt hatten, dass der Bildschirm zu Abhängigkeitsauflösung angezeigt
wurde. Normalerweise ist es am besten, den Vorschlägen von \fBdselect\fP zu
folgen.
.sp
Durch Drücken der Taste ‚\fBR\fP’ kann der Auswahlzustand der aufgeführten
Pakete zu den Originaleinstellungen zurückgesetzt werden, wie er vor den
unaufgelösten Abhängigkeiten oder Konflikten war. Durch Drücken der Taste
‚\fBD\fP’ werden die automatischen Vorschläge zurückgesetzt, aber die
Änderungen, die zu der Anzeige des Abhängigkeitsauflösungsbildschirms
geführt hatten, werden wie gebeten beibehalten. Schließlich werden durch
Drücken der Taste ‚\fBU\fP’ die Auswahlen wieder auf die automatischen
Auswahlwerte gesetzt.
.sp
.SS "Die angeforderten Auswahlen einrichten"
.sp
Durch Drücken von \fBEnter\fP wird die derzeit angezeigte Auswahlgruppe
akzeptiert. Falls \fBdselect\fP keine unaufgelösten Abhängigkeit als Ergebnis
der angeforderten Auswahl entdeckt, wird die neue Auswahl gesetzt. Falls es
allerdings unaufgelöste Abhängigkeiten gibt, wird \fBdselect\fP dem Benutzer
erneut den Bildschirm mit der Abhängigkeitsauflösung anzeigen.
.sp
Um die Menge der Auswahlen zu ändern, die unaufgelöste Abhängigkeiten oder
Konflikte erzeugt und \fBdselect\fP zu zwingen, diese zu akzeptieren, drücken
Sie die Taste ‚\fBQ\fP’. Dies setzt die Auswahl wie vom Benutzer angegeben,
ohne Bedingungen. Machen Sie dies nur, wenn Sie sich über die Konsequenzen
im Klaren sind.
.sp
Der gegenteilige Effekt, um alle Auswahländerungen zurückzusetzen und zurück
auf die vorherige Auswahlliste zu gehen, wird durch Drücken der Tasten
‚\fBX\fP’ oder \fB»Esc«\fP erreicht. Durch wiederholtes Drücken dieser Tasten
können möglicherweise schädliche Änderungen an der angeforderten
Paketauswahl komplett auf die letzten bestehenden Einstellungen
zurückgesetzt werden.
.sp
Falls Sie bestimmte Einstellungen aus Versehen vornehmen und alle Auswahlen
so zurücksetzen wollen, dass diese den bereits auf dem System installierten
Paketen entsprechen, dann drücken Sie die Taste ‚\fBC\fP’. Dies ähnelt etwas
der Verwendung des Befehls Loslassen, angewendet auf alle Pakete, bietet
aber einen etwas deutlicheren Panikknopf, falls der Benutzer aus Versehen
die \fBEingabetaste\fP gedrückt hat.
.sp
.
.SH RÜCKGABEWERT
.TP 
\fB0\fP
Die angeforderte Befehl wurde erfolgreich ausgeführt.
.TP 
\fB2\fP
Fataler oder nicht behebbarer Fehler aufgrund ungültiger
Befehlszeilenverwendung oder Interaktionen mit dem System, wie Zugriffe auf
die Datenbank, Speicherzuweisungen usw.
.
.SH UMGEBUNG
.TP 
\fBHOME\fP
Falls gesetzt, wird \fBdselect\fP es als das Verzeichnis verwenden, aus dem die
benutzerspezifische Konfigurationsdatei gelesen wird.
.
.SH FEHLER
Die Paketauswahl\-Schnittstelle von \fBDselect\fP bringt einige neue Benutzer
durcheinander. Gerüchteweise bringt sie sogar erfahrene Kernelentwickler zum
Heulen.
.sp
Die Dokumentation ist verbesserungswürdig.
.sp
Es gibt keine Hilfe\-Option im Hauptmenü.
.sp
Die sichtbare Liste von verfügbaren Paketen kann nicht verkleinert werden.
.sp
Die eingebauten Zugriffsmethoden können sich nicht mehr mit aktuellen
Qualitätsstandards messen. Verwenden Sie die von apt bereitgestellte
Zugriffsmethode, sie funktioniert nicht nur, sondern ist sogar flexibler als
die eingebauten Zugriffsmethoden.
.
.SH "SIEHE AUCH"
\fBdpkg\fP(1), \fBapt\-get\fP(8), \fBsources.list\fP(5), \fBdeb\fP(5).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2017 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
