/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "bamf-plugin.h"

#include <QtDeclarative/qdeclarative.h>
#include <QDeclarativeEngine>
#include <QDeclarativeContext>

#include "bamf-view.h"
#include "bamf-application.h"
#include "bamf-window.h"
#include "bamf-indicator.h"
#include "bamf-control.h"
#include "bamf-matcher.h"

#include "bamf-list.h"

void
BamfPlugin::registerTypes(const char *uri)
{
    const QString message("This type is not meant to be instantiated.");
    qmlRegisterUncreatableType<BamfUintList>(uri, 0, 2, "BamfUintList", message);
    qmlRegisterUncreatableType<BamfView>(uri, 0, 2, "BamfView", message);
    qmlRegisterUncreatableType<BamfViewList>(uri, 0, 2, "BamfViewList", message);
    qmlRegisterUncreatableType<BamfApplication>(uri, 0, 2, "BamfApplication", message);
    qmlRegisterUncreatableType<BamfApplicationList>(uri, 0, 2, "BamfApplicationList", message);
    qmlRegisterUncreatableType<BamfWindow>(uri, 0, 2, "BamfWindow", message);
    qmlRegisterUncreatableType<BamfIndicator>(uri, 0, 2, "BamfIndicator", message);
    qmlRegisterUncreatableType<BamfWindowList>(uri, 0, 2, "BamfWindowList", message);
    qmlRegisterUncreatableType<BamfControl>(uri, 0, 2, "BamfControl", message);
    qmlRegisterUncreatableType<BamfMatcher>(uri, 0, 2, "BamfMatcher", message);
}

void BamfPlugin::initializeEngine(QDeclarativeEngine *engine, const char *uri)
{
    BamfMatcher& matcher = BamfMatcher::get_default();
    engine->rootContext()->setContextProperty("BamfMatcher", &matcher);
}

Q_EXPORT_PLUGIN2(QtBamf, BamfPlugin);

