.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XRecolorCursor __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XRecolorCursor, XFreeCursor, XQueryBestCursor \- manipulate cursors
.SH SYNTAX
.HP
int XRecolorCursor\^(\^Display *\fIdisplay\fP\^, Cursor \fIcursor\fP\^, XColor
*\fIforeground_color\fP\^, XColor *\fIbackground_color\fP\^);
.HP
int XFreeCursor\^(\^Display *\fIdisplay\fP\^, Cursor \fIcursor\fP\^);
.HP
Status XQueryBestCursor\^(\^Display *\fIdisplay\fP\^, Drawable \fId\fP\^,
unsigned int \fIwidth\fP\^, unsigned int \fIheight\fP\^, unsigned int
*\fIwidth_return\fP\^, unsigned int *\fIheight_return\fP\^);
.SH ARGUMENTS
.IP \fIbackground_color\fP 1i
Specifies the RGB values for the background of the source.
.IP \fIcursor\fP 1i
Specifies the cursor.
.IP \fId\fP 1i
Specifies the drawable, which indicates the screen.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIforeground_color\fP 1i
Specifies the RGB values for the foreground of the source.
.IP \fIwidth\fP 1i
.br
.ns
.IP \fIheight\fP 1i
Specify the width and height of the cursor that you want the size information for.
.IP \fIwidth_return\fP 1i
.br
.ns
.IP \fIheight_return\fP 1i
Return the best width and height that is closest to the specified width
and height.
.SH DESCRIPTION
The
.B XRecolorCursor
function changes the color of the specified cursor, and
if the cursor is being displayed on a screen,
the change is visible immediately.
The pixel members of the
.B XColor
structures are ignored; only the RGB values are used.
.LP
.B XRecolorCursor
can generate a
.B BadCursor
error.
.LP
The
.B XFreeCursor
function deletes the association between the cursor resource ID
and the specified cursor.
The cursor storage is freed when no other resource references it.
The specified cursor ID should not be referred to again.
.LP
.B XFreeCursor
can generate a
.B BadCursor
error.
.LP
Some displays allow larger cursors than other displays.
The
.B XQueryBestCursor
function provides a way to find out what size cursors are actually
possible on the display.
.IN "Cursor" "limitations"
It returns the largest size that can be displayed.
Applications should be prepared to use smaller cursors on displays that
cannot support large ones.
.LP
.B XQueryBestCursor
can generate a
.B BadDrawable
error.
.SH DIAGNOSTICS
.TP 1i
.B BadCursor
A value for a Cursor argument does not name a defined Cursor.
.TP 1i
.B BadDrawable
A value for a Drawable argument does not name a defined Window or Pixmap.
.SH "SEE ALSO"
XCreateColormap(__libmansuffix__),
XCreateFontCursor(__libmansuffix__),
XDefineCursor(__libmansuffix__)
.br
\fI\*(xL\fP
