/* OAuth1Support.c generated by valac 0.40.4, the Vala compiler
 * generated from OAuth1Support.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>
#include "shotwell-plugin-dev-1.0.h"
#include <gee.h>


#define PUBLISHING_REST_SUPPORT_TYPE_SESSION (publishing_rest_support_session_get_type ())
#define PUBLISHING_REST_SUPPORT_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession))
#define PUBLISHING_REST_SUPPORT_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSessionClass))
#define PUBLISHING_REST_SUPPORT_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_REST_SUPPORT_TYPE_SESSION))
#define PUBLISHING_REST_SUPPORT_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_REST_SUPPORT_TYPE_SESSION))
#define PUBLISHING_REST_SUPPORT_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSessionClass))

typedef struct _PublishingRESTSupportSession PublishingRESTSupportSession;
typedef struct _PublishingRESTSupportSessionClass PublishingRESTSupportSessionClass;
typedef struct _PublishingRESTSupportSessionPrivate PublishingRESTSupportSessionPrivate;

#define PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION (publishing_rest_support_oauth1_session_get_type ())
#define PUBLISHING_REST_SUPPORT_OAUTH1_SESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1Session))
#define PUBLISHING_REST_SUPPORT_OAUTH1_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1SessionClass))
#define PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION))
#define PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION))
#define PUBLISHING_REST_SUPPORT_OAUTH1_SESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1SessionClass))

typedef struct _PublishingRESTSupportOAuth1Session PublishingRESTSupportOAuth1Session;
typedef struct _PublishingRESTSupportOAuth1SessionClass PublishingRESTSupportOAuth1SessionClass;
typedef struct _PublishingRESTSupportOAuth1SessionPrivate PublishingRESTSupportOAuth1SessionPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION (publishing_rest_support_transaction_get_type ())
#define PUBLISHING_REST_SUPPORT_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction))
#define PUBLISHING_REST_SUPPORT_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransactionClass))
#define PUBLISHING_REST_SUPPORT_IS_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION))
#define PUBLISHING_REST_SUPPORT_IS_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION))
#define PUBLISHING_REST_SUPPORT_TRANSACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransactionClass))

typedef struct _PublishingRESTSupportTransaction PublishingRESTSupportTransaction;
typedef struct _PublishingRESTSupportTransactionClass PublishingRESTSupportTransactionClass;

#define PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT (publishing_rest_support_argument_get_type ())
#define PUBLISHING_REST_SUPPORT_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT, PublishingRESTSupportArgument))
#define PUBLISHING_REST_SUPPORT_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT, PublishingRESTSupportArgumentClass))
#define PUBLISHING_REST_SUPPORT_IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT))
#define PUBLISHING_REST_SUPPORT_IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT))
#define PUBLISHING_REST_SUPPORT_ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_REST_SUPPORT_TYPE_ARGUMENT, PublishingRESTSupportArgumentClass))

typedef struct _PublishingRESTSupportArgument PublishingRESTSupportArgument;
typedef struct _PublishingRESTSupportArgumentClass PublishingRESTSupportArgumentClass;

#define PUBLISHING_REST_SUPPORT_TYPE_HTTP_METHOD (publishing_rest_support_http_method_get_type ())
#define _publishing_rest_support_argument_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_argument_unref (var), NULL)))
typedef struct _PublishingRESTSupportTransactionPrivate PublishingRESTSupportTransactionPrivate;

#define PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION (publishing_rest_support_oauth1_transaction_get_type ())
#define PUBLISHING_REST_SUPPORT_OAUTH1_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, PublishingRESTSupportOAuth1Transaction))
#define PUBLISHING_REST_SUPPORT_OAUTH1_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, PublishingRESTSupportOAuth1TransactionClass))
#define PUBLISHING_REST_SUPPORT_OAUTH1_IS_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION))
#define PUBLISHING_REST_SUPPORT_OAUTH1_IS_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION))
#define PUBLISHING_REST_SUPPORT_OAUTH1_TRANSACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, PublishingRESTSupportOAuth1TransactionClass))

typedef struct _PublishingRESTSupportOAuth1Transaction PublishingRESTSupportOAuth1Transaction;
typedef struct _PublishingRESTSupportOAuth1TransactionClass PublishingRESTSupportOAuth1TransactionClass;
typedef struct _PublishingRESTSupportOAuth1TransactionPrivate PublishingRESTSupportOAuth1TransactionPrivate;
#define _publishing_rest_support_session_unref0(var) ((var == NULL) ? NULL : (var = (publishing_rest_support_session_unref (var), NULL)))

#define PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION (publishing_rest_support_upload_transaction_get_type ())
#define PUBLISHING_REST_SUPPORT_UPLOAD_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportUploadTransaction))
#define PUBLISHING_REST_SUPPORT_UPLOAD_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportUploadTransactionClass))
#define PUBLISHING_REST_SUPPORT_IS_UPLOAD_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION))
#define PUBLISHING_REST_SUPPORT_IS_UPLOAD_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION))
#define PUBLISHING_REST_SUPPORT_UPLOAD_TRANSACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportUploadTransactionClass))

typedef struct _PublishingRESTSupportUploadTransaction PublishingRESTSupportUploadTransaction;
typedef struct _PublishingRESTSupportUploadTransactionClass PublishingRESTSupportUploadTransactionClass;
typedef struct _PublishingRESTSupportUploadTransactionPrivate PublishingRESTSupportUploadTransactionPrivate;

#define PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION (publishing_rest_support_oauth1_upload_transaction_get_type ())
#define PUBLISHING_REST_SUPPORT_OAUTH1_UPLOAD_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportOAuth1UploadTransaction))
#define PUBLISHING_REST_SUPPORT_OAUTH1_UPLOAD_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportOAuth1UploadTransactionClass))
#define PUBLISHING_REST_SUPPORT_OAUTH1_IS_UPLOAD_TRANSACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION))
#define PUBLISHING_REST_SUPPORT_OAUTH1_IS_UPLOAD_TRANSACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION))
#define PUBLISHING_REST_SUPPORT_OAUTH1_UPLOAD_TRANSACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportOAuth1UploadTransactionClass))

typedef struct _PublishingRESTSupportOAuth1UploadTransaction PublishingRESTSupportOAuth1UploadTransaction;
typedef struct _PublishingRESTSupportOAuth1UploadTransactionClass PublishingRESTSupportOAuth1UploadTransactionClass;
typedef struct _PublishingRESTSupportOAuth1UploadTransactionPrivate PublishingRESTSupportOAuth1UploadTransactionPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PublishingRESTSupportSession {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PublishingRESTSupportSessionPrivate * priv;
};

struct _PublishingRESTSupportSessionClass {
	GTypeClass parent_class;
	void (*finalize) (PublishingRESTSupportSession *self);
	gboolean (*is_authenticated) (PublishingRESTSupportSession* self);
};

struct _PublishingRESTSupportOAuth1Session {
	PublishingRESTSupportSession parent_instance;
	PublishingRESTSupportOAuth1SessionPrivate * priv;
};

struct _PublishingRESTSupportOAuth1SessionClass {
	PublishingRESTSupportSessionClass parent_class;
};

struct _PublishingRESTSupportOAuth1SessionPrivate {
	gchar* request_phase_token;
	gchar* request_phase_token_secret;
	gchar* access_phase_token;
	gchar* access_phase_token_secret;
	gchar* username;
	gchar* consumer_key;
	gchar* consumer_secret;
};

typedef enum  {
	PUBLISHING_REST_SUPPORT_HTTP_METHOD_GET,
	PUBLISHING_REST_SUPPORT_HTTP_METHOD_POST,
	PUBLISHING_REST_SUPPORT_HTTP_METHOD_PUT
} PublishingRESTSupportHttpMethod;

struct _PublishingRESTSupportTransaction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PublishingRESTSupportTransactionPrivate * priv;
};

struct _PublishingRESTSupportTransactionClass {
	GTypeClass parent_class;
	void (*finalize) (PublishingRESTSupportTransaction *self);
	void (*add_header) (PublishingRESTSupportTransaction* self, const gchar* key, const gchar* value);
	void (*execute) (PublishingRESTSupportTransaction* self, GError** error);
};

struct _PublishingRESTSupportOAuth1Transaction {
	PublishingRESTSupportTransaction parent_instance;
	PublishingRESTSupportOAuth1TransactionPrivate * priv;
};

struct _PublishingRESTSupportOAuth1TransactionClass {
	PublishingRESTSupportTransactionClass parent_class;
};

struct _PublishingRESTSupportUploadTransaction {
	PublishingRESTSupportTransaction parent_instance;
	PublishingRESTSupportUploadTransactionPrivate * priv;
	GHashTable* binary_disposition_table;
	SpitPublishingPublishable* publishable;
	gchar* mime_type;
	GeeHashMap* message_headers;
};

struct _PublishingRESTSupportUploadTransactionClass {
	PublishingRESTSupportTransactionClass parent_class;
};

struct _PublishingRESTSupportOAuth1UploadTransaction {
	PublishingRESTSupportUploadTransaction parent_instance;
	PublishingRESTSupportOAuth1UploadTransactionPrivate * priv;
	PublishingRESTSupportOAuth1Session* session;
};

struct _PublishingRESTSupportOAuth1UploadTransactionClass {
	PublishingRESTSupportUploadTransactionClass parent_class;
};

struct _PublishingRESTSupportOAuth1UploadTransactionPrivate {
	PublishingRESTSupportArgument** auth_header_fields;
	gint auth_header_fields_length1;
	gint _auth_header_fields_size_;
};


static gpointer publishing_rest_support_oauth1_session_parent_class = NULL;
static gpointer publishing_rest_support_oauth1_transaction_parent_class = NULL;
static gpointer publishing_rest_support_oauth1_upload_transaction_parent_class = NULL;

#define PUBLISHING_REST_SUPPORT_OAUTH1_ENCODE_RFC_3986_EXTRA "!*'();:@&=+$,/?%#[] \\"
gpointer publishing_rest_support_session_ref (gpointer instance);
void publishing_rest_support_session_unref (gpointer instance);
GParamSpec* publishing_rest_support_param_spec_session (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags);
void publishing_rest_support_value_set_session (GValue* value,
                                                gpointer v_object);
void publishing_rest_support_value_take_session (GValue* value,
                                                 gpointer v_object);
gpointer publishing_rest_support_value_get_session (const GValue* value);
GType publishing_rest_support_session_get_type (void) G_GNUC_CONST;
GType publishing_rest_support_oauth1_session_get_type (void) G_GNUC_CONST;
#define PUBLISHING_REST_SUPPORT_OAUTH1_SESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1SessionPrivate))
PublishingRESTSupportOAuth1Session* publishing_rest_support_oauth1_session_new (const gchar* endpoint_uri);
PublishingRESTSupportOAuth1Session* publishing_rest_support_oauth1_session_construct (GType object_type,
                                                                                      const gchar* endpoint_uri);
PublishingRESTSupportSession* publishing_rest_support_session_construct (GType object_type,
                                                                         const gchar* endpoint_url);
static gboolean publishing_rest_support_oauth1_session_real_is_authenticated (PublishingRESTSupportSession* base);
void publishing_rest_support_oauth1_session_authenticate_from_persistent_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                                      const gchar* token,
                                                                                      const gchar* secret,
                                                                                      const gchar* username);
void publishing_rest_support_oauth1_session_deauthenticate (PublishingRESTSupportOAuth1Session* self);
void publishing_rest_support_oauth1_session_set_api_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                 const gchar* consumer_key,
                                                                 const gchar* consumer_secret);
gpointer publishing_rest_support_transaction_ref (gpointer instance);
void publishing_rest_support_transaction_unref (gpointer instance);
GParamSpec* publishing_rest_support_param_spec_transaction (const gchar* name,
                                                            const gchar* nick,
                                                            const gchar* blurb,
                                                            GType object_type,
                                                            GParamFlags flags);
void publishing_rest_support_value_set_transaction (GValue* value,
                                                    gpointer v_object);
void publishing_rest_support_value_take_transaction (GValue* value,
                                                     gpointer v_object);
gpointer publishing_rest_support_value_get_transaction (const GValue* value);
GType publishing_rest_support_transaction_get_type (void) G_GNUC_CONST;
gpointer publishing_rest_support_argument_ref (gpointer instance);
void publishing_rest_support_argument_unref (gpointer instance);
GParamSpec* publishing_rest_support_param_spec_argument (const gchar* name,
                                                         const gchar* nick,
                                                         const gchar* blurb,
                                                         GType object_type,
                                                         GParamFlags flags);
void publishing_rest_support_value_set_argument (GValue* value,
                                                 gpointer v_object);
void publishing_rest_support_value_take_argument (GValue* value,
                                                  gpointer v_object);
gpointer publishing_rest_support_value_get_argument (const GValue* value);
GType publishing_rest_support_argument_get_type (void) G_GNUC_CONST;
gchar* publishing_rest_support_oauth1_session_sign_transaction (PublishingRESTSupportOAuth1Session* self,
                                                                PublishingRESTSupportTransaction* txn,
                                                                PublishingRESTSupportArgument** extra_arguments,
                                                                int extra_arguments_length1);
GType publishing_rest_support_http_method_get_type (void) G_GNUC_CONST;
PublishingRESTSupportHttpMethod publishing_rest_support_transaction_get_method (PublishingRESTSupportTransaction* self);
gchar* publishing_rest_support_http_method_to_string (PublishingRESTSupportHttpMethod self);
PublishingRESTSupportArgument** publishing_rest_support_transaction_get_arguments (PublishingRESTSupportTransaction* self,
                                                                                   int* result_length1);
static void _vala_array_add2 (PublishingRESTSupportArgument** * array,
                       int* length,
                       int* size,
                       PublishingRESTSupportArgument* value);
PublishingRESTSupportArgument** publishing_rest_support_argument_sort (PublishingRESTSupportArgument** inputArray,
                                                                       int inputArray_length1,
                                                                       int* result_length1);
gchar* publishing_rest_support_argument_serialize_list (PublishingRESTSupportArgument** args,
                                                        int args_length1,
                                                        gboolean escape,
                                                        const gchar* separator);
gchar* publishing_rest_support_transaction_get_endpoint_url (PublishingRESTSupportTransaction* self);
gchar* publishing_rest_support_hmac_sha1 (const gchar* key,
                                          const gchar* message);
void publishing_rest_support_oauth1_session_set_request_phase_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                           const gchar* token,
                                                                           const gchar* secret);
void publishing_rest_support_oauth1_session_set_access_phase_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                          const gchar* token,
                                                                          const gchar* secret,
                                                                          const gchar* username);
gchar* publishing_rest_support_oauth1_session_get_oauth_nonce (PublishingRESTSupportOAuth1Session* self);
gchar* publishing_rest_support_oauth1_session_get_oauth_timestamp (PublishingRESTSupportOAuth1Session* self);
gchar* publishing_rest_support_oauth1_session_get_consumer_key (PublishingRESTSupportOAuth1Session* self);
gchar* publishing_rest_support_oauth1_session_get_request_phase_token (PublishingRESTSupportOAuth1Session* self);
gchar* publishing_rest_support_oauth1_session_get_access_phase_token (PublishingRESTSupportOAuth1Session* self);
gboolean publishing_rest_support_oauth1_session_has_access_phase_token (PublishingRESTSupportOAuth1Session* self);
gchar* publishing_rest_support_oauth1_session_get_access_phase_token_secret (PublishingRESTSupportOAuth1Session* self);
gchar* publishing_rest_support_oauth1_session_get_username (PublishingRESTSupportOAuth1Session* self);
gboolean publishing_rest_support_session_is_authenticated (PublishingRESTSupportSession* self);
static void publishing_rest_support_oauth1_session_finalize (PublishingRESTSupportSession * obj);
GType publishing_rest_support_oauth1_transaction_get_type (void) G_GNUC_CONST;
PublishingRESTSupportOAuth1Transaction* publishing_rest_support_oauth1_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                                                        PublishingRESTSupportHttpMethod method);
PublishingRESTSupportOAuth1Transaction* publishing_rest_support_oauth1_transaction_construct (GType object_type,
                                                                                              PublishingRESTSupportOAuth1Session* session,
                                                                                              PublishingRESTSupportHttpMethod method);
PublishingRESTSupportTransaction* publishing_rest_support_transaction_new (PublishingRESTSupportSession* parent_session,
                                                                           PublishingRESTSupportHttpMethod method);
PublishingRESTSupportTransaction* publishing_rest_support_transaction_construct (GType object_type,
                                                                                 PublishingRESTSupportSession* parent_session,
                                                                                 PublishingRESTSupportHttpMethod method);
static void publishing_rest_support_oauth1_transaction_setup_arguments (PublishingRESTSupportOAuth1Transaction* self);
PublishingRESTSupportOAuth1Transaction* publishing_rest_support_oauth1_transaction_new_with_uri (PublishingRESTSupportOAuth1Session* session,
                                                                                                 const gchar* uri,
                                                                                                 PublishingRESTSupportHttpMethod method);
PublishingRESTSupportOAuth1Transaction* publishing_rest_support_oauth1_transaction_construct_with_uri (GType object_type,
                                                                                                       PublishingRESTSupportOAuth1Session* session,
                                                                                                       const gchar* uri,
                                                                                                       PublishingRESTSupportHttpMethod method);
PublishingRESTSupportTransaction* publishing_rest_support_transaction_new_with_endpoint_url (PublishingRESTSupportSession* parent_session,
                                                                                             const gchar* endpoint_url,
                                                                                             PublishingRESTSupportHttpMethod method);
PublishingRESTSupportTransaction* publishing_rest_support_transaction_construct_with_endpoint_url (GType object_type,
                                                                                                   PublishingRESTSupportSession* parent_session,
                                                                                                   const gchar* endpoint_url,
                                                                                                   PublishingRESTSupportHttpMethod method);
PublishingRESTSupportSession* publishing_rest_support_transaction_get_parent_session (PublishingRESTSupportTransaction* self);
void publishing_rest_support_transaction_add_argument (PublishingRESTSupportTransaction* self,
                                                       const gchar* name,
                                                       const gchar* value);
static void publishing_rest_support_oauth1_transaction_real_execute (PublishingRESTSupportTransaction* base,
                                                              GError** error);
void publishing_rest_support_transaction_execute (PublishingRESTSupportTransaction* self,
                                                  GError** error);
GType publishing_rest_support_upload_transaction_get_type (void) G_GNUC_CONST;
GType publishing_rest_support_oauth1_upload_transaction_get_type (void) G_GNUC_CONST;
#define PUBLISHING_REST_SUPPORT_OAUTH1_UPLOAD_TRANSACTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportOAuth1UploadTransactionPrivate))
PublishingRESTSupportOAuth1UploadTransaction* publishing_rest_support_oauth1_upload_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                                                                     SpitPublishingPublishable* publishable,
                                                                                                     const gchar* endpoint_uri);
PublishingRESTSupportOAuth1UploadTransaction* publishing_rest_support_oauth1_upload_transaction_construct (GType object_type,
                                                                                                           PublishingRESTSupportOAuth1Session* session,
                                                                                                           SpitPublishingPublishable* publishable,
                                                                                                           const gchar* endpoint_uri);
PublishingRESTSupportUploadTransaction* publishing_rest_support_upload_transaction_new_with_endpoint_url (PublishingRESTSupportSession* session,
                                                                                                          SpitPublishingPublishable* publishable,
                                                                                                          const gchar* endpoint_url);
PublishingRESTSupportUploadTransaction* publishing_rest_support_upload_transaction_construct_with_endpoint_url (GType object_type,
                                                                                                                PublishingRESTSupportSession* session,
                                                                                                                SpitPublishingPublishable* publishable,
                                                                                                                const gchar* endpoint_url);
void publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (PublishingRESTSupportOAuth1UploadTransaction* self,
                                                                                       const gchar* key,
                                                                                       const gchar* value);
PublishingRESTSupportArgument* publishing_rest_support_argument_new (const gchar* key,
                                                                     const gchar* value);
PublishingRESTSupportArgument* publishing_rest_support_argument_construct (GType object_type,
                                                                           const gchar* key,
                                                                           const gchar* value);
static void _vala_array_add3 (PublishingRESTSupportArgument** * array,
                       int* length,
                       int* size,
                       PublishingRESTSupportArgument* value);
gchar* publishing_rest_support_oauth1_upload_transaction_get_authorization_header_string (PublishingRESTSupportOAuth1UploadTransaction* self);
void publishing_rest_support_oauth1_upload_transaction_authorize (PublishingRESTSupportOAuth1UploadTransaction* self);
void publishing_rest_support_transaction_add_header (PublishingRESTSupportTransaction* self,
                                                     const gchar* key,
                                                     const gchar* value);
static void publishing_rest_support_oauth1_upload_transaction_finalize (PublishingRESTSupportTransaction * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


PublishingRESTSupportOAuth1Session*
publishing_rest_support_oauth1_session_construct (GType object_type,
                                                  const gchar* endpoint_uri)
{
	PublishingRESTSupportOAuth1Session* self = NULL;
#line 21 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self = (PublishingRESTSupportOAuth1Session*) publishing_rest_support_session_construct (object_type, endpoint_uri);
#line 20 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return self;
#line 382 "OAuth1Support.c"
}


PublishingRESTSupportOAuth1Session*
publishing_rest_support_oauth1_session_new (const gchar* endpoint_uri)
{
#line 20 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return publishing_rest_support_oauth1_session_construct (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, endpoint_uri);
#line 391 "OAuth1Support.c"
}


static gboolean
publishing_rest_support_oauth1_session_real_is_authenticated (PublishingRESTSupportSession* base)
{
	PublishingRESTSupportOAuth1Session * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
#line 24 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1Session);
#line 25 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = self->priv->access_phase_token;
#line 25 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	if (_tmp2_ != NULL) {
#line 409 "OAuth1Support.c"
		const gchar* _tmp3_;
#line 25 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp3_ = self->priv->access_phase_token_secret;
#line 25 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp1_ = _tmp3_ != NULL;
#line 415 "OAuth1Support.c"
	} else {
#line 25 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp1_ = FALSE;
#line 419 "OAuth1Support.c"
	}
#line 25 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	if (_tmp1_) {
#line 423 "OAuth1Support.c"
		const gchar* _tmp4_;
#line 26 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp4_ = self->priv->username;
#line 26 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp0_ = _tmp4_ != NULL;
#line 429 "OAuth1Support.c"
	} else {
#line 25 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp0_ = FALSE;
#line 433 "OAuth1Support.c"
	}
#line 25 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp0_;
#line 25 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 439 "OAuth1Support.c"
}


void
publishing_rest_support_oauth1_session_authenticate_from_persistent_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                                 const gchar* token,
                                                                                 const gchar* secret,
                                                                                 const gchar* username)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 29 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
#line 29 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (token != NULL);
#line 29 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (secret != NULL);
#line 29 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (username != NULL);
#line 31 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = g_strdup (token);
#line 31 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->access_phase_token);
#line 31 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->access_phase_token = _tmp0_;
#line 32 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = g_strdup (secret);
#line 32 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->access_phase_token_secret);
#line 32 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->access_phase_token_secret = _tmp1_;
#line 33 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = g_strdup (username);
#line 33 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->username);
#line 33 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->username = _tmp2_;
#line 35 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), "authenticated");
#line 480 "OAuth1Support.c"
}


void
publishing_rest_support_oauth1_session_deauthenticate (PublishingRESTSupportOAuth1Session* self)
{
#line 38 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
#line 39 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->access_phase_token);
#line 39 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->access_phase_token = NULL;
#line 40 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->access_phase_token_secret);
#line 40 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->access_phase_token_secret = NULL;
#line 41 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->username);
#line 41 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->username = NULL;
#line 501 "OAuth1Support.c"
}


void
publishing_rest_support_oauth1_session_set_api_credentials (PublishingRESTSupportOAuth1Session* self,
                                                            const gchar* consumer_key,
                                                            const gchar* consumer_secret)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 44 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
#line 44 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (consumer_key != NULL);
#line 44 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (consumer_secret != NULL);
#line 45 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = g_strdup (consumer_key);
#line 45 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->consumer_key);
#line 45 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->consumer_key = _tmp0_;
#line 46 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = g_strdup (consumer_secret);
#line 46 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->consumer_secret);
#line 46 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->consumer_secret = _tmp1_;
#line 530 "OAuth1Support.c"
}


static gpointer
_publishing_rest_support_argument_ref0 (gpointer self)
{
#line 58 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return self ? publishing_rest_support_argument_ref (self) : NULL;
#line 539 "OAuth1Support.c"
}


static void
_vala_array_add2 (PublishingRESTSupportArgument** * array,
                  int* length,
                  int* size,
                  PublishingRESTSupportArgument* value)
{
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	if ((*length) == (*size)) {
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		*array = g_renew (PublishingRESTSupportArgument*, *array, (*size) + 1);
#line 555 "OAuth1Support.c"
	}
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	(*array)[(*length)++] = value;
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	(*array)[*length] = NULL;
#line 561 "OAuth1Support.c"
}


gchar*
publishing_rest_support_oauth1_session_sign_transaction (PublishingRESTSupportOAuth1Session* self,
                                                         PublishingRESTSupportTransaction* txn,
                                                         PublishingRESTSupportArgument** extra_arguments,
                                                         int extra_arguments_length1)
{
	gchar* result = NULL;
	gchar* http_method = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PublishingRESTSupportArgument** base_string_arguments = NULL;
	gint _tmp4_;
	PublishingRESTSupportArgument** _tmp5_;
	gint base_string_arguments_length1;
	gint _base_string_arguments_size_;
	PublishingRESTSupportArgument** sorted_args = NULL;
	PublishingRESTSupportArgument** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	PublishingRESTSupportArgument** _tmp12_;
	gint sorted_args_length1;
	gint _sorted_args_size_;
	gchar* arguments_string = NULL;
	PublishingRESTSupportArgument** _tmp13_;
	gint _tmp13__length1;
	gchar* _tmp14_;
	gchar* signing_key = NULL;
	const gchar* _tmp15_;
	gchar* signature_base_string = NULL;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* signature = NULL;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
#line 49 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
#line 49 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_IS_TRANSACTION (txn), NULL);
#line 51 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = publishing_rest_support_http_method_to_string (publishing_rest_support_transaction_get_method (txn));
#line 51 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	http_method = _tmp0_;
#line 53 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_debug ("OAuth1Support.vala:53: signing transaction with parameters:");
#line 54 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = http_method;
#line 54 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = g_strconcat ("HTTP method = ", _tmp1_, NULL);
#line 54 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp3_ = _tmp2_;
#line 54 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_debug ("OAuth1Support.vala:54: %s", _tmp3_);
#line 54 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp3_);
#line 56 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp5_ = publishing_rest_support_transaction_get_arguments (txn, &_tmp4_);
#line 56 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	base_string_arguments = _tmp5_;
#line 56 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	base_string_arguments_length1 = _tmp4_;
#line 56 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_base_string_arguments_size_ = base_string_arguments_length1;
#line 647 "OAuth1Support.c"
	{
		PublishingRESTSupportArgument** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
#line 58 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		arg_collection = extra_arguments;
#line 58 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		arg_collection_length1 = extra_arguments_length1;
#line 58 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		for (arg_it = 0; arg_it < extra_arguments_length1; arg_it = arg_it + 1) {
#line 659 "OAuth1Support.c"
			PublishingRESTSupportArgument* _tmp6_;
			PublishingRESTSupportArgument* arg = NULL;
#line 58 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_tmp6_ = _publishing_rest_support_argument_ref0 (arg_collection[arg_it]);
#line 58 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			arg = _tmp6_;
#line 666 "OAuth1Support.c"
			{
				PublishingRESTSupportArgument** _tmp7_;
				gint _tmp7__length1;
				PublishingRESTSupportArgument* _tmp8_;
				PublishingRESTSupportArgument* _tmp9_;
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
				_tmp7_ = base_string_arguments;
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
				_tmp7__length1 = base_string_arguments_length1;
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
				_tmp8_ = arg;
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
				_tmp9_ = _publishing_rest_support_argument_ref0 (_tmp8_);
#line 59 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
				_vala_array_add2 (&base_string_arguments, &base_string_arguments_length1, &_base_string_arguments_size_, _tmp9_);
#line 58 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
				_publishing_rest_support_argument_unref0 (arg);
#line 684 "OAuth1Support.c"
			}
		}
	}
#line 62 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp10_ = base_string_arguments;
#line 62 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp10__length1 = base_string_arguments_length1;
#line 62 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp12_ = publishing_rest_support_argument_sort (_tmp10_, _tmp10__length1, &_tmp11_);
#line 62 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	sorted_args = _tmp12_;
#line 62 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	sorted_args_length1 = _tmp11_;
#line 62 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_sorted_args_size_ = sorted_args_length1;
#line 65 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp13_ = sorted_args;
#line 65 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp13__length1 = sorted_args_length1;
#line 65 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp14_ = publishing_rest_support_argument_serialize_list (_tmp13_, _tmp13__length1, FALSE, "&");
#line 65 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	arguments_string = _tmp14_;
#line 67 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	signing_key = NULL;
#line 68 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp15_ = self->priv->access_phase_token_secret;
#line 68 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	if (_tmp15_ != NULL) {
#line 714 "OAuth1Support.c"
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
#line 69 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		g_debug ("OAuth1Support.vala:69: access phase token secret available; using it a" \
"s signing key");
#line 71 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp16_ = self->priv->consumer_secret;
#line 71 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp17_ = g_strconcat (_tmp16_, "&", NULL);
#line 71 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp18_ = _tmp17_;
#line 71 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp19_ = self->priv->access_phase_token_secret;
#line 71 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
#line 71 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_g_free0 (signing_key);
#line 71 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		signing_key = _tmp20_;
#line 71 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_g_free0 (_tmp18_);
#line 738 "OAuth1Support.c"
	} else {
		const gchar* _tmp21_;
#line 72 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp21_ = self->priv->request_phase_token_secret;
#line 72 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		if (_tmp21_ != NULL) {
#line 745 "OAuth1Support.c"
			const gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			const gchar* _tmp25_;
			gchar* _tmp26_;
#line 73 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			g_debug ("OAuth1Support.vala:73: request phase token secret available; using it " \
"as signing key");
#line 75 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_tmp22_ = self->priv->consumer_secret;
#line 75 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_tmp23_ = g_strconcat (_tmp22_, "&", NULL);
#line 75 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_tmp24_ = _tmp23_;
#line 75 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_tmp25_ = self->priv->request_phase_token_secret;
#line 75 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_tmp26_ = g_strconcat (_tmp24_, _tmp25_, NULL);
#line 75 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_g_free0 (signing_key);
#line 75 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			signing_key = _tmp26_;
#line 75 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_g_free0 (_tmp24_);
#line 769 "OAuth1Support.c"
		} else {
			const gchar* _tmp27_;
			gchar* _tmp28_;
#line 77 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			g_debug ("OAuth1Support.vala:77: %s", "neither access phase nor request phase token secrets available; using " \
"API " "key as signing key");
#line 80 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_tmp27_ = self->priv->consumer_secret;
#line 80 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_tmp28_ = g_strconcat (_tmp27_, "&", NULL);
#line 80 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_g_free0 (signing_key);
#line 80 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			signing_key = _tmp28_;
#line 783 "OAuth1Support.c"
		}
	}
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp29_ = http_method;
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp30_ = g_strconcat (_tmp29_, "&", NULL);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp31_ = _tmp30_;
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp32_ = publishing_rest_support_transaction_get_endpoint_url (txn);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp33_ = _tmp32_;
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp34_ = soup_uri_encode (_tmp33_, PUBLISHING_REST_SUPPORT_OAUTH1_ENCODE_RFC_3986_EXTRA);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp35_ = _tmp34_;
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp36_ = g_strconcat (_tmp31_, _tmp35_, NULL);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp37_ = _tmp36_;
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp38_ = g_strconcat (_tmp37_, "&", NULL);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp39_ = _tmp38_;
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp40_ = arguments_string;
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp41_ = soup_uri_encode (_tmp40_, PUBLISHING_REST_SUPPORT_OAUTH1_ENCODE_RFC_3986_EXTRA);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp42_ = _tmp41_;
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp43_ = g_strconcat (_tmp39_, _tmp42_, NULL);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp44_ = _tmp43_;
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp42_);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp39_);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp37_);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp35_);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp33_);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp31_);
#line 83 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	signature_base_string = _tmp44_;
#line 87 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_debug ("OAuth1Support.vala:87: signature base string = '%s'", signature_base_string);
#line 89 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp45_ = signing_key;
#line 89 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_debug ("OAuth1Support.vala:89: signing key = '%s'", _tmp45_);
#line 92 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp46_ = signing_key;
#line 92 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp47_ = publishing_rest_support_hmac_sha1 (_tmp46_, signature_base_string);
#line 92 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	signature = _tmp47_;
#line 93 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp48_ = signature;
#line 93 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp49_ = soup_uri_encode (_tmp48_, PUBLISHING_REST_SUPPORT_OAUTH1_ENCODE_RFC_3986_EXTRA);
#line 93 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (signature);
#line 93 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	signature = _tmp49_;
#line 95 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp50_ = signature;
#line 95 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_debug ("OAuth1Support.vala:95: signature = '%s'", _tmp50_);
#line 97 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = signature;
#line 97 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (signature_base_string);
#line 97 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (signing_key);
#line 97 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (arguments_string);
#line 97 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	sorted_args = (_vala_array_free (sorted_args, sorted_args_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
#line 97 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	base_string_arguments = (_vala_array_free (base_string_arguments, base_string_arguments_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
#line 97 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (http_method);
#line 97 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 872 "OAuth1Support.c"
}


void
publishing_rest_support_oauth1_session_set_request_phase_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                      const gchar* token,
                                                                      const gchar* secret)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 100 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
#line 100 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (token != NULL);
#line 100 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (secret != NULL);
#line 101 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = g_strdup (token);
#line 101 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->request_phase_token);
#line 101 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->request_phase_token = _tmp0_;
#line 102 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = g_strdup (secret);
#line 102 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->request_phase_token_secret);
#line 102 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->request_phase_token_secret = _tmp1_;
#line 901 "OAuth1Support.c"
}


void
publishing_rest_support_oauth1_session_set_access_phase_credentials (PublishingRESTSupportOAuth1Session* self,
                                                                     const gchar* token,
                                                                     const gchar* secret,
                                                                     const gchar* username)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
#line 105 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self));
#line 105 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (token != NULL);
#line 105 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (secret != NULL);
#line 105 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (username != NULL);
#line 106 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = g_strdup (token);
#line 106 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->access_phase_token);
#line 106 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->access_phase_token = _tmp0_;
#line 107 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = g_strdup (secret);
#line 107 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->access_phase_token_secret);
#line 107 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->access_phase_token_secret = _tmp1_;
#line 108 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = g_strdup (username);
#line 108 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->username);
#line 108 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->username = _tmp2_;
#line 110 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), "authenticated");
#line 942 "OAuth1Support.c"
}


gchar*
publishing_rest_support_oauth1_session_get_oauth_nonce (PublishingRESTSupportOAuth1Session* self)
{
	gchar* result = NULL;
	GTimeVal currtime = {0};
	GTimeVal _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GTimeVal _tmp4_;
	glong _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
#line 113 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
#line 114 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_get_current_time (&currtime);
#line 115 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_get_current_time (&currtime);
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = currtime;
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = _tmp0_.tv_sec;
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = g_strdup_printf ("%li", _tmp1_);
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp3_ = _tmp2_;
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp4_ = currtime;
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp5_ = _tmp4_.tv_usec;
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp6_ = g_strdup_printf ("%li", _tmp5_);
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp7_ = _tmp6_;
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp8_ = g_strconcat (_tmp3_, _tmp7_, NULL);
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp9_ = _tmp8_;
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp10_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp9_, (gsize) -1);
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp11_ = _tmp10_;
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp9_);
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp7_);
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp3_);
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp11_;
#line 117 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 1003 "OAuth1Support.c"
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1336 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	end = _tmp0_;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = end;
#line 1337 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = maxlen;
#line 1338 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1027 "OAuth1Support.c"
	} else {
		gchar* _tmp2_;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = end;
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1340 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		return result;
#line 1036 "OAuth1Support.c"
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
#line 1347 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1057 "OAuth1Support.c"
	} else {
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1061 "OAuth1Support.c"
	}
#line 1349 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 1351 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1067 "OAuth1Support.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1353 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1077 "OAuth1Support.c"
	}
#line 1356 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1081 "OAuth1Support.c"
		glong _tmp3_;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1357 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		offset = _tmp3_ + offset;
#line 1358 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1089 "OAuth1Support.c"
	} else {
		glong _tmp4_;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = string_length;
#line 1360 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		g_return_val_if_fail (offset <= _tmp4_, NULL);
#line 1096 "OAuth1Support.c"
	}
#line 1362 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1100 "OAuth1Support.c"
		glong _tmp5_;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1363 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
		len = _tmp5_ - offset;
#line 1106 "OAuth1Support.c"
	}
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp6_ = string_length;
#line 1365 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp7_;
#line 1366 "/usr/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1118 "OAuth1Support.c"
}


gchar*
publishing_rest_support_oauth1_session_get_oauth_timestamp (PublishingRESTSupportOAuth1Session* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 121 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
#line 122 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_get_real_time ());
#line 122 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = _tmp0_;
#line 122 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = string_substring (_tmp1_, (glong) 0, (glong) 10);
#line 122 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp3_ = _tmp2_;
#line 122 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp1_);
#line 122 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp3_;
#line 122 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 1146 "OAuth1Support.c"
}


gchar*
publishing_rest_support_oauth1_session_get_consumer_key (PublishingRESTSupportOAuth1Session* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 125 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
#line 126 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = self->priv->consumer_key;
#line 126 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_vala_assert (_tmp0_ != NULL, "consumer_key != null");
#line 127 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = self->priv->consumer_key;
#line 127 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 127 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp2_;
#line 127 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 1171 "OAuth1Support.c"
}


gchar*
publishing_rest_support_oauth1_session_get_request_phase_token (PublishingRESTSupportOAuth1Session* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 130 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
#line 131 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = self->priv->request_phase_token;
#line 131 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_vala_assert (_tmp0_ != NULL, "request_phase_token != null");
#line 132 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = self->priv->request_phase_token;
#line 132 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 132 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp2_;
#line 132 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 1196 "OAuth1Support.c"
}


gchar*
publishing_rest_support_oauth1_session_get_access_phase_token (PublishingRESTSupportOAuth1Session* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 135 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
#line 136 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = self->priv->access_phase_token;
#line 136 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_vala_assert (_tmp0_ != NULL, "access_phase_token != null");
#line 137 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = self->priv->access_phase_token;
#line 137 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 137 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp2_;
#line 137 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 1221 "OAuth1Support.c"
}


gboolean
publishing_rest_support_oauth1_session_has_access_phase_token (PublishingRESTSupportOAuth1Session* self)
{
	gboolean result = FALSE;
	const gchar* _tmp0_;
#line 140 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), FALSE);
#line 141 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = self->priv->access_phase_token;
#line 141 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp0_ != NULL;
#line 141 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 1238 "OAuth1Support.c"
}


gchar*
publishing_rest_support_oauth1_session_get_access_phase_token_secret (PublishingRESTSupportOAuth1Session* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
#line 144 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
#line 145 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = self->priv->access_phase_token_secret;
#line 145 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_vala_assert (_tmp0_ != NULL, "access_phase_token_secret != null");
#line 146 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = self->priv->access_phase_token_secret;
#line 146 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 146 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp2_;
#line 146 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 1263 "OAuth1Support.c"
}


gchar*
publishing_rest_support_oauth1_session_get_username (PublishingRESTSupportOAuth1Session* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 149 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (self), NULL);
#line 150 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_vala_assert (publishing_rest_support_session_is_authenticated (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession)), "is_authenticated()");
#line 151 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = self->priv->username;
#line 151 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 151 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp1_;
#line 151 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 1285 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_session_class_init (PublishingRESTSupportOAuth1SessionClass * klass)
{
#line 11 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_session_parent_class = g_type_class_peek_parent (klass);
#line 11 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	((PublishingRESTSupportSessionClass *) klass)->finalize = publishing_rest_support_oauth1_session_finalize;
#line 11 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_type_class_add_private (klass, sizeof (PublishingRESTSupportOAuth1SessionPrivate));
#line 11 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	((PublishingRESTSupportSessionClass *) klass)->is_authenticated = (gboolean (*) (PublishingRESTSupportSession *)) publishing_rest_support_oauth1_session_real_is_authenticated;
#line 1300 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_session_instance_init (PublishingRESTSupportOAuth1Session * self)
{
#line 11 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv = PUBLISHING_REST_SUPPORT_OAUTH1_SESSION_GET_PRIVATE (self);
#line 12 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->request_phase_token = NULL;
#line 13 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->request_phase_token_secret = NULL;
#line 14 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->access_phase_token = NULL;
#line 15 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->access_phase_token_secret = NULL;
#line 16 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->username = NULL;
#line 17 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->consumer_key = NULL;
#line 18 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->consumer_secret = NULL;
#line 1323 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_session_finalize (PublishingRESTSupportSession * obj)
{
	PublishingRESTSupportOAuth1Session * self;
#line 11 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1Session);
#line 12 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->request_phase_token);
#line 13 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->request_phase_token_secret);
#line 14 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->access_phase_token);
#line 15 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->access_phase_token_secret);
#line 16 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->username);
#line 17 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->consumer_key);
#line 18 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (self->priv->consumer_secret);
#line 11 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	PUBLISHING_REST_SUPPORT_SESSION_CLASS (publishing_rest_support_oauth1_session_parent_class)->finalize (obj);
#line 1349 "OAuth1Support.c"
}


GType
publishing_rest_support_oauth1_session_get_type (void)
{
	static volatile gsize publishing_rest_support_oauth1_session_type_id__volatile = 0;
	if (g_once_init_enter (&publishing_rest_support_oauth1_session_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportOAuth1SessionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_oauth1_session_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportOAuth1Session), 0, (GInstanceInitFunc) publishing_rest_support_oauth1_session_instance_init, NULL };
		GType publishing_rest_support_oauth1_session_type_id;
		publishing_rest_support_oauth1_session_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_SESSION, "PublishingRESTSupportOAuth1Session", &g_define_type_info, 0);
		g_once_init_leave (&publishing_rest_support_oauth1_session_type_id__volatile, publishing_rest_support_oauth1_session_type_id);
	}
	return publishing_rest_support_oauth1_session_type_id__volatile;
}


PublishingRESTSupportOAuth1Transaction*
publishing_rest_support_oauth1_transaction_construct (GType object_type,
                                                      PublishingRESTSupportOAuth1Session* session,
                                                      PublishingRESTSupportHttpMethod method)
{
	PublishingRESTSupportOAuth1Transaction* self = NULL;
#line 156 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (session), NULL);
#line 158 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self = (PublishingRESTSupportOAuth1Transaction*) publishing_rest_support_transaction_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), method);
#line 159 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_transaction_setup_arguments (self);
#line 156 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return self;
#line 1381 "OAuth1Support.c"
}


PublishingRESTSupportOAuth1Transaction*
publishing_rest_support_oauth1_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                PublishingRESTSupportHttpMethod method)
{
#line 156 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return publishing_rest_support_oauth1_transaction_construct (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, session, method);
#line 1391 "OAuth1Support.c"
}


PublishingRESTSupportOAuth1Transaction*
publishing_rest_support_oauth1_transaction_construct_with_uri (GType object_type,
                                                               PublishingRESTSupportOAuth1Session* session,
                                                               const gchar* uri,
                                                               PublishingRESTSupportHttpMethod method)
{
	PublishingRESTSupportOAuth1Transaction* self = NULL;
#line 162 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (session), NULL);
#line 162 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (uri != NULL, NULL);
#line 164 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self = (PublishingRESTSupportOAuth1Transaction*) publishing_rest_support_transaction_construct_with_endpoint_url (object_type, G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), uri, method);
#line 165 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_transaction_setup_arguments (self);
#line 162 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return self;
#line 1412 "OAuth1Support.c"
}


PublishingRESTSupportOAuth1Transaction*
publishing_rest_support_oauth1_transaction_new_with_uri (PublishingRESTSupportOAuth1Session* session,
                                                         const gchar* uri,
                                                         PublishingRESTSupportHttpMethod method)
{
#line 162 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return publishing_rest_support_oauth1_transaction_construct_with_uri (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, session, uri, method);
#line 1423 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_transaction_setup_arguments (PublishingRESTSupportOAuth1Transaction* self)
{
	PublishingRESTSupportOAuth1Session* session = NULL;
	PublishingRESTSupportSession* _tmp0_;
	PublishingRESTSupportOAuth1Session* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PublishingRESTSupportOAuth1Session* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	PublishingRESTSupportOAuth1Session* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	PublishingRESTSupportOAuth1Session* _tmp10_;
#line 168 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_TRANSACTION (self));
#line 169 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = publishing_rest_support_transaction_get_parent_session (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction));
#line 169 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	session = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1Session);
#line 171 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = session;
#line 171 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = publishing_rest_support_oauth1_session_get_oauth_nonce (_tmp1_);
#line 171 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp3_ = _tmp2_;
#line 171 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_nonce", _tmp3_);
#line 171 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp3_);
#line 172 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_signature_method", "HMAC-SHA1");
#line 173 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_version", "1.0");
#line 174 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp4_ = session;
#line 174 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp5_ = publishing_rest_support_oauth1_session_get_oauth_timestamp (_tmp4_);
#line 174 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp6_ = _tmp5_;
#line 174 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_timestamp", _tmp6_);
#line 174 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp6_);
#line 175 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp7_ = session;
#line 175 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp8_ = publishing_rest_support_oauth1_session_get_consumer_key (_tmp7_);
#line 175 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp9_ = _tmp8_;
#line 175 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_consumer_key", _tmp9_);
#line 175 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp9_);
#line 176 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp10_ = session;
#line 176 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	if (publishing_rest_support_oauth1_session_has_access_phase_token (_tmp10_)) {
#line 1486 "OAuth1Support.c"
		PublishingRESTSupportOAuth1Session* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
#line 177 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp11_ = session;
#line 177 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp12_ = publishing_rest_support_oauth1_session_get_access_phase_token (_tmp11_);
#line 177 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_tmp13_ = _tmp12_;
#line 177 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_token", _tmp13_);
#line 177 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		_g_free0 (_tmp13_);
#line 1500 "OAuth1Support.c"
	}
#line 168 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_publishing_rest_support_session_unref0 (session);
#line 1504 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_transaction_real_execute (PublishingRESTSupportTransaction* base,
                                                         GError** error)
{
	PublishingRESTSupportOAuth1Transaction * self;
	gchar* signature = NULL;
	PublishingRESTSupportSession* _tmp0_;
	PublishingRESTSupportOAuth1Session* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
#line 182 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_TRANSACTION, PublishingRESTSupportOAuth1Transaction);
#line 183 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = publishing_rest_support_transaction_get_parent_session (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction));
#line 183 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_SESSION, PublishingRESTSupportOAuth1Session);
#line 183 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = publishing_rest_support_oauth1_session_sign_transaction (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), NULL, 0);
#line 183 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp3_ = _tmp2_;
#line 183 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_publishing_rest_support_session_unref0 (_tmp1_);
#line 183 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	signature = _tmp3_;
#line 184 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_transaction_add_argument (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "oauth_signature", signature);
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	PUBLISHING_REST_SUPPORT_TRANSACTION_CLASS (publishing_rest_support_oauth1_transaction_parent_class)->execute (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), &_inner_error_);
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		if (_inner_error_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			g_propagate_error (error, _inner_error_);
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_g_free0 (signature);
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			return;
#line 1547 "OAuth1Support.c"
		} else {
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			_g_free0 (signature);
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			g_clear_error (&_inner_error_);
#line 186 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
			return;
#line 1557 "OAuth1Support.c"
		}
	}
#line 182 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (signature);
#line 1562 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_transaction_class_init (PublishingRESTSupportOAuth1TransactionClass * klass)
{
#line 155 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_transaction_parent_class = g_type_class_peek_parent (klass);
#line 155 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	((PublishingRESTSupportTransactionClass *) klass)->execute = (void (*) (PublishingRESTSupportTransaction *, GError**)) publishing_rest_support_oauth1_transaction_real_execute;
#line 1573 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_transaction_instance_init (PublishingRESTSupportOAuth1Transaction * self)
{
}


GType
publishing_rest_support_oauth1_transaction_get_type (void)
{
	static volatile gsize publishing_rest_support_oauth1_transaction_type_id__volatile = 0;
	if (g_once_init_enter (&publishing_rest_support_oauth1_transaction_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportOAuth1TransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_oauth1_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportOAuth1Transaction), 0, (GInstanceInitFunc) publishing_rest_support_oauth1_transaction_instance_init, NULL };
		GType publishing_rest_support_oauth1_transaction_type_id;
		publishing_rest_support_oauth1_transaction_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, "PublishingRESTSupportOAuth1Transaction", &g_define_type_info, 0);
		g_once_init_leave (&publishing_rest_support_oauth1_transaction_type_id__volatile, publishing_rest_support_oauth1_transaction_type_id);
	}
	return publishing_rest_support_oauth1_transaction_type_id__volatile;
}


PublishingRESTSupportOAuth1UploadTransaction*
publishing_rest_support_oauth1_upload_transaction_construct (GType object_type,
                                                             PublishingRESTSupportOAuth1Session* session,
                                                             SpitPublishingPublishable* publishable,
                                                             const gchar* endpoint_uri)
{
	PublishingRESTSupportOAuth1UploadTransaction* self = NULL;
	PublishingRESTSupportArgument** _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
#line 194 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_SESSION (session), NULL);
#line 194 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (SPIT_PUBLISHING_IS_PUBLISHABLE (publishable), NULL);
#line 194 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (endpoint_uri != NULL, NULL);
#line 197 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self = (PublishingRESTSupportOAuth1UploadTransaction*) publishing_rest_support_upload_transaction_construct_with_endpoint_url (object_type, G_TYPE_CHECK_INSTANCE_CAST (session, PUBLISHING_REST_SUPPORT_TYPE_SESSION, PublishingRESTSupportSession), publishable, endpoint_uri);
#line 199 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = g_new0 (PublishingRESTSupportArgument*, 0 + 1);
#line 199 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->auth_header_fields = (_vala_array_free (self->priv->auth_header_fields, self->priv->auth_header_fields_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
#line 199 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->auth_header_fields = _tmp0_;
#line 199 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->auth_header_fields_length1 = 0;
#line 199 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->_auth_header_fields_size_ = self->priv->auth_header_fields_length1;
#line 200 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->session = session;
#line 202 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = publishing_rest_support_oauth1_session_get_oauth_nonce (session);
#line 202 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = _tmp1_;
#line 202 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_nonce", _tmp2_);
#line 202 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp2_);
#line 203 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_signature_method", "HMAC-SHA1");
#line 204 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_version", "1.0");
#line 205 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp3_ = publishing_rest_support_oauth1_session_get_oauth_timestamp (session);
#line 205 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp4_ = _tmp3_;
#line 205 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_timestamp", _tmp4_);
#line 205 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp4_);
#line 206 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp5_ = publishing_rest_support_oauth1_session_get_consumer_key (session);
#line 206 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp6_ = _tmp5_;
#line 206 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_consumer_key", _tmp6_);
#line 206 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp6_);
#line 207 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp7_ = publishing_rest_support_oauth1_session_get_access_phase_token (session);
#line 207 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp8_ = _tmp7_;
#line 207 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_token", _tmp8_);
#line 207 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp8_);
#line 194 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return self;
#line 1671 "OAuth1Support.c"
}


PublishingRESTSupportOAuth1UploadTransaction*
publishing_rest_support_oauth1_upload_transaction_new (PublishingRESTSupportOAuth1Session* session,
                                                       SpitPublishingPublishable* publishable,
                                                       const gchar* endpoint_uri)
{
#line 194 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return publishing_rest_support_oauth1_upload_transaction_construct (PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION, session, publishable, endpoint_uri);
#line 1682 "OAuth1Support.c"
}


static void
_vala_array_add3 (PublishingRESTSupportArgument** * array,
                  int* length,
                  int* size,
                  PublishingRESTSupportArgument* value)
{
#line 211 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	if ((*length) == (*size)) {
#line 211 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 211 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
		*array = g_renew (PublishingRESTSupportArgument*, *array, (*size) + 1);
#line 1698 "OAuth1Support.c"
	}
#line 211 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	(*array)[(*length)++] = value;
#line 211 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	(*array)[*length] = NULL;
#line 1704 "OAuth1Support.c"
}


void
publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (PublishingRESTSupportOAuth1UploadTransaction* self,
                                                                                  const gchar* key,
                                                                                  const gchar* value)
{
	PublishingRESTSupportArgument** _tmp0_;
	gint _tmp0__length1;
	PublishingRESTSupportArgument* _tmp1_;
#line 210 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_UPLOAD_TRANSACTION (self));
#line 210 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (key != NULL);
#line 210 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (value != NULL);
#line 211 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = self->priv->auth_header_fields;
#line 211 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0__length1 = self->priv->auth_header_fields_length1;
#line 211 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = publishing_rest_support_argument_new (key, value);
#line 211 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_vala_array_add3 (&self->priv->auth_header_fields, &self->priv->auth_header_fields_length1, &self->priv->_auth_header_fields_size_, _tmp1_);
#line 1730 "OAuth1Support.c"
}


gchar*
publishing_rest_support_oauth1_upload_transaction_get_authorization_header_string (PublishingRESTSupportOAuth1UploadTransaction* self)
{
	gchar* result = NULL;
	PublishingRESTSupportArgument** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 214 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_val_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_UPLOAD_TRANSACTION (self), NULL);
#line 215 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = self->priv->auth_header_fields;
#line 215 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0__length1 = self->priv->auth_header_fields_length1;
#line 215 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = publishing_rest_support_argument_serialize_list (_tmp0_, _tmp0__length1, TRUE, ", ");
#line 215 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = _tmp1_;
#line 215 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp3_ = g_strconcat ("OAuth ", _tmp2_, NULL);
#line 215 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp4_ = _tmp3_;
#line 215 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (_tmp2_);
#line 215 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	result = _tmp4_;
#line 215 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	return result;
#line 1764 "OAuth1Support.c"
}


void
publishing_rest_support_oauth1_upload_transaction_authorize (PublishingRESTSupportOAuth1UploadTransaction* self)
{
	gchar* signature = NULL;
	PublishingRESTSupportOAuth1Session* _tmp0_;
	PublishingRESTSupportArgument** _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar* authorization_header = NULL;
	gchar* _tmp3_;
#line 218 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_return_if_fail (PUBLISHING_REST_SUPPORT_OAUTH1_IS_UPLOAD_TRANSACTION (self));
#line 219 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp0_ = self->session;
#line 219 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1_ = self->priv->auth_header_fields;
#line 219 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp1__length1 = self->priv->auth_header_fields_length1;
#line 219 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp2_ = publishing_rest_support_oauth1_session_sign_transaction (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), _tmp1_, _tmp1__length1);
#line 219 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	signature = _tmp2_;
#line 220 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_upload_transaction_add_authorization_header_field (self, "oauth_signature", signature);
#line 223 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_tmp3_ = publishing_rest_support_oauth1_upload_transaction_get_authorization_header_string (self);
#line 223 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	authorization_header = _tmp3_;
#line 225 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_debug ("OAuth1Support.vala:225: executing upload transaction: authorization he" \
"ader string = '%s'", authorization_header);
#line 227 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_transaction_add_header (G_TYPE_CHECK_INSTANCE_CAST (self, PUBLISHING_REST_SUPPORT_TYPE_TRANSACTION, PublishingRESTSupportTransaction), "Authorization", authorization_header);
#line 218 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (authorization_header);
#line 218 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	_g_free0 (signature);
#line 1804 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_upload_transaction_class_init (PublishingRESTSupportOAuth1UploadTransactionClass * klass)
{
#line 190 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	publishing_rest_support_oauth1_upload_transaction_parent_class = g_type_class_peek_parent (klass);
#line 190 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	((PublishingRESTSupportTransactionClass *) klass)->finalize = publishing_rest_support_oauth1_upload_transaction_finalize;
#line 190 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	g_type_class_add_private (klass, sizeof (PublishingRESTSupportOAuth1UploadTransactionPrivate));
#line 1817 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_upload_transaction_instance_init (PublishingRESTSupportOAuth1UploadTransaction * self)
{
#line 190 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv = PUBLISHING_REST_SUPPORT_OAUTH1_UPLOAD_TRANSACTION_GET_PRIVATE (self);
#line 1826 "OAuth1Support.c"
}


static void
publishing_rest_support_oauth1_upload_transaction_finalize (PublishingRESTSupportTransaction * obj)
{
	PublishingRESTSupportOAuth1UploadTransaction * self;
#line 190 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_REST_SUPPORT_OAUTH1_TYPE_UPLOAD_TRANSACTION, PublishingRESTSupportOAuth1UploadTransaction);
#line 192 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	self->priv->auth_header_fields = (_vala_array_free (self->priv->auth_header_fields, self->priv->auth_header_fields_length1, (GDestroyNotify) publishing_rest_support_argument_unref), NULL);
#line 190 "/home/jens/Source/shotwell/plugins/common/OAuth1Support.vala"
	PUBLISHING_REST_SUPPORT_TRANSACTION_CLASS (publishing_rest_support_oauth1_upload_transaction_parent_class)->finalize (obj);
#line 1840 "OAuth1Support.c"
}


GType
publishing_rest_support_oauth1_upload_transaction_get_type (void)
{
	static volatile gsize publishing_rest_support_oauth1_upload_transaction_type_id__volatile = 0;
	if (g_once_init_enter (&publishing_rest_support_oauth1_upload_transaction_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PublishingRESTSupportOAuth1UploadTransactionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_rest_support_oauth1_upload_transaction_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingRESTSupportOAuth1UploadTransaction), 0, (GInstanceInitFunc) publishing_rest_support_oauth1_upload_transaction_instance_init, NULL };
		GType publishing_rest_support_oauth1_upload_transaction_type_id;
		publishing_rest_support_oauth1_upload_transaction_type_id = g_type_register_static (PUBLISHING_REST_SUPPORT_TYPE_UPLOAD_TRANSACTION, "PublishingRESTSupportOAuth1UploadTransaction", &g_define_type_info, 0);
		g_once_init_leave (&publishing_rest_support_oauth1_upload_transaction_type_id__volatile, publishing_rest_support_oauth1_upload_transaction_type_id);
	}
	return publishing_rest_support_oauth1_upload_transaction_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



