/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_CPY.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_copy(void);
	int cfgi_copyall(void);
	int cfgi_copyto(const fpos_t * const pos);
	int cfgi_copyallto(const fpos_t * const pos);

 *	Copy the a part of the user INI file into the temp output INI
 *	If no user INI file is opened, these functions succeed.
 *	copy(): copies all the remaining part of the user INI file
 *	copyall(): copies the complete user INI file
 *	copyto(): copies all upto, but excluding the specified position
 *	copyallto(): copies from the beginning to the specified position
 *	Return cfg error code

ob: cfgi_copyall
ty: L
su: inifile/2
sh: Copy the whole INI file
lo: Copies the whole INI file opened for reading to the INI file opened for
	writing. The process rewinds the read-INI file before continueing, otherwise
	it is similiar to cfgi_copy().
re: cfgi_copy
fi: cfgi_cpy.c
in:

ob: cfgi_copyallto
ty: L
su: inifile/2
sh: Copy the beginning of the INI file upto, but excluding, a specified position
lo: Copies the beginning of the  INI file opened for reading to the INI file opened for
	writing upto, but not including, the specified position. The process rewinds the read-INI file before continueing, otherwise
	it is similiar to cfgi_copyto().
re: cfgi_copyto
fi: cfgi_cpy.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_CPY.C 1.4 2000/03/31 09:08:52 ska Exp ska $";
#endif

/* transform from Fcopy() error number --> cfg error number */
static int err2err(int errnr)
{
	switch(errnr) {
	case 3:	return CFG_ERR_MEM;
	case 1: return CFG_ERR_READ;
	case 0: return CFG_ERR_NONE;
	}
	return CFG_ERR_WRITE;
}

int cfgi_copy(void)
{	DBG_ENTER("cfgi_copy", Suppl_inifile2)

	assert(cfgi_ini);

	if(!usrini.cfgi_fp)
		DBG_RETURN_I( CFG_ERR_NONE)

	chkHeap
	DBG_RETURN_BI( err2err(Fcopy(cfgi_ini, usrini.cfgi_fp)))
}

int cfgi_copyall(void)
{	DBG_ENTER("cfgi_copyall", Suppl_inifile2)

	assert(cfgi_ini);

	if(!usrini.cfgi_fp)
		DBG_RETURN_I( CFG_ERR_NONE)

	chkHeap
	Frewind(usrini.cfgi_fp);

	chkHeap
	DBG_RETURN_BI( err2err(Fcopy(cfgi_ini, usrini.cfgi_fp)))
}

int cfgi_copyallfrom(const fpos_t * const pos)
{	DBG_ENTER("cfgi_copyfrom", Suppl_inifile2)

	assert(cfgi_ini);

	if(!usrini.cfgi_fp)
		DBG_RETURN_I( CFG_ERR_NONE)

	if(Fsetpos(usrini.cfgi_fp, pos))
		DBG_RETURN_I( CFG_ERR_ACC)

	chkHeap
	DBG_RETURN_BI( err2err(Fcopy(cfgi_ini, usrini.cfgi_fp)))
}

int cfgi_copyto(const fpos_t * const pos)
{	DBG_ENTER("cfgi_copyto", Suppl_inifile2)

		assert(cfgi_ini);

	if(!usrini.cfgi_fp)
		DBG_RETURN_I( CFG_ERR_NONE)

	chkHeap
	DBG_RETURN_BI( err2err(Fcopyto(cfgi_ini, usrini.cfgi_fp, pos)))
}

int cfgi_copyallto(const fpos_t * const pos)
{	DBG_ENTER("cfgi_copyallto", Suppl_inifile2)

	assert(cfgi_ini);

	if(!usrini.cfgi_fp)
		DBG_RETURN_I( CFG_ERR_NONE)

	Frewind(usrini.cfgi_fp);

	chkHeap
	DBG_RETURN_BI( err2err(Fcopyto(cfgi_ini, usrini.cfgi_fp, pos)))
}
