/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.viewer;

import edu.harvard.hul.ois.jhove.viewer.ConfigWindow;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;

public class ConfigWriter {
    private PrintWriter _confOut;
    private File _tempFile;
    private File _confFile;
    ConfigWindow _parent;

    public ConfigWriter(File file, ConfigWindow configWindow) throws IOException {
        this._confFile = file;
        this._parent = configWindow;
        String string = file.getParent();
        this._tempFile = File.createTempFile("jho", ".conf", new File(string));
        FileOutputStream fileOutputStream = new FileOutputStream(this._tempFile);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        this._confOut = new PrintWriter(outputStreamWriter);
    }

    public void writeFile(List list, List list2, File file, File file2, String string, int n) throws IOException {
        Object object;
        this.writeHead();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            object = (String[])listIterator.next();
            String string2 = object[0];
            String string3 = object[1];
            if ("".equals(string2)) continue;
            this._confOut.println(" <module>");
            this._confOut.println("   <class>" + ConfigWriter.encodeContent(string2) + "</class>");
            if (string3 != null && string3.length() > 0) {
                this._confOut.println("   <init>" + ConfigWriter.encodeContent(string3) + "</init>");
            }
            this._confOut.println(" </module>");
        }
        listIterator = list2.listIterator();
        while (listIterator.hasNext()) {
            object = (String)listIterator.next();
            this._confOut.println(" <handler>");
            this._confOut.println("   <class>" + ConfigWriter.encodeContent((String)object) + "</class>");
            this._confOut.println(" </handler>");
        }
        if (n > 0) {
            this._confOut.println(" <bufferSize>" + n + "</bufferSize>");
        }
        if (string != null && string.length() > 0) {
            this._confOut.println(" <defaultEncoding>" + ConfigWriter.encodeContent(string) + "</defaultEncoding>");
        }
        this._confOut.println(" <jhoveHome>" + ConfigWriter.encodeContent(file.getPath()) + "</jhoveHome>");
        if (file2 != null) {
            this._confOut.println(" <tempDirectory>" + ConfigWriter.encodeContent(file2.getPath()) + "</tempDirectory>");
        }
        this.writeTail();
        this._confOut.close();
        if (this._confFile.exists() && !this._confFile.delete()) {
            JOptionPane.showMessageDialog(this._parent, "Can't replace old config file", "Error", 0);
            this._tempFile.delete();
        } else {
            this._tempFile.renameTo(this._confFile);
        }
    }

    private void writeHead() throws IOException {
        this._confOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this._confOut.println("<jhoveConfig version=\"1.0\"");
        this._confOut.println("             xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        this._confOut.println("             xmlns=\"http://hul.harvard.edu/ois/xml/ns/jhove/jhoveConfig\"");
        this._confOut.println("xsi:schemaLocation=\"http://hul.harvard.edu/ois/xml/ns/jhove/jhoveConfig");
        this._confOut.println("             http://hul.harvard.edu/ois/xml/xsd/jhove/jhoveConfig.xsd\">");
    }

    private void writeTail() throws IOException {
        this._confOut.println("</jhoveConfig>");
    }

    private static String encodeContent(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while ((n = stringBuffer.indexOf("&", n)) > -1) {
            stringBuffer.insert(n + 1, "amp;");
            n += 5;
        }
        n = 0;
        while ((n = stringBuffer.indexOf("<", n)) > -1) {
            stringBuffer.replace(n, n + 1, "&lt;");
            n += 4;
        }
        n = 0;
        while ((n = stringBuffer.indexOf(">", n)) > -1) {
            stringBuffer.replace(n, n + 1, "&gt;");
            n += 4;
        }
        return stringBuffer.toString();
    }
}

