/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.KernelCallSite;
import com.nvidia.cuda.ide.debug.service.IDebuggerUIState;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LayoutChangeEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LinkedSelectionChangedEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.vms.KernelHierarchy;
import com.nvidia.cuda.ide.debug.util.ConditionalLabelColors;
import com.nvidia.cuda.ide.debug.util.CudaObjectLabelImage;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelText;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public class CDPCallStackNode
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementPropertiesProvider {
    private IElementLabelProvider provider;

    public CDPCallStackNode(AbstractDMVMProvider provider, DsfSession session) {
        super(provider, session, KernelCallSite.class);
    }

    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof LinkedSelectionChangedEvent || event instanceof LayoutChangeEvent) {
            this.selectOrExpand(((IDMEvent)event).getDMContext(), parent, nodeOffset, requestMonitor);
        } else {
            requestMonitor.done();
        }
    }

    private PropertiesBasedLabelProvider createLabelProvider() {
        PropertiesBasedLabelProvider labelProvider = new PropertiesBasedLabelProvider();
        labelProvider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME", this.createNameColumnInfo());
        labelProvider.setColumnInfo("ID_COLUMN_NO_COLUMNS", this.createNameColumnInfo());
        return labelProvider;
    }

    private LabelColumnInfo createNameColumnInfo() {
        return new LabelColumnInfo(new LabelAttribute[]{new LabelText("{2,choice,0#{3}|0<{0}} [{1}]", new String[]{"kernel_name", "kernel_id", "active_kernel_blocks", "short_name"}), new CudaObjectLabelImage(CudaDebugImages.CDP_CALLER, CudaDebugImages.CDP_CALLER_INACTIVE), new ConditionalLabelColors("active_kernel_blocks", 0)});
    }

    private boolean fillKernelProperties(final IPropertiesUpdate update, KernelCallSite item) {
        if (item != null) {
            Kernel kernel = item.getParent();
            update.setProperty("kernel_name", (Object)kernel.getName());
            update.setProperty("short_name", (Object)kernel.getShortName());
            update.setProperty("kernel_id", (Object)kernel.getId());
            Set properties = update.getProperties();
            if (properties.contains("active_kernel_blocks") || properties.contains("cuda_object_active")) {
                kernel.getActiveBlocksCount((DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                    protected void handleSuccess() {
                        int blocks = (Integer)this.getData();
                        update.setProperty("active_kernel_blocks", (Object)blocks);
                        update.setProperty("cuda_object_active", (Object)(blocks > 0 ? 1 : 0));
                        update.setProperty("diverged", (Object)false);
                        update.done();
                    }
                });
                return false;
            }
            return true;
        }
        return true;
    }

    private void fillNoElements(IChildrenUpdate[] updates) {
        IChildrenUpdate[] iChildrenUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IChildrenUpdate update = iChildrenUpdateArray[n2];
            this.fillUpdateWithVMCs(update, new IDMContext[0]);
            update.done();
            ++n2;
        }
    }

    public int getDeltaFlags(Object event) {
        if (event instanceof FullStackRefreshEvent) {
            return 1024;
        }
        if (event instanceof LinkedSelectionChangedEvent || event instanceof LayoutChangeEvent) {
            return 0x300400;
        }
        return 0;
    }

    private Kernel getKernel(IChildrenUpdate update) {
        KernelCallSite item = (KernelCallSite)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), KernelCallSite.class);
        if (item != null) {
            return item.getParent();
        }
        return (Kernel)this.findDmcInPath(update.getViewerInput(), update.getElementPath(), Kernel.class);
    }

    private synchronized IElementLabelProvider getLabelProvider() {
        if (this.provider == null) {
            this.provider = this.createLabelProvider();
        }
        return this.provider;
    }

    private void isEnabled(DataRequestMonitor<Boolean> drm) {
        new KernelHierarchy(this.getServicesTracker(), false).isCdpStackVisible(drm);
    }

    private void selectOrExpand(IDMContext dmContext, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        IDebuggerUIState service;
        String val = Activator.getDefault().getPreferenceStore().getString("device.kernels.mode");
        if ("device_kernels_filtered".equals(val) && dmContext instanceof ICudaRuntimeObject && (service = (IDebuggerUIState)this.getServicesTracker().getService(IDebuggerUIState.class)) != null && service.getFocus() != null) {
            Kernel toExpand;
            KernelCallSite site;
            Kernel focused = service.getFocus().getKernel();
            Object element = parent.getElement();
            if (element instanceof IDMVMContext && ((IDMVMContext)element).getDMContext().equals(service.getFocus()) && (site = focused.getCallSite((toExpand = dmContext instanceof Kernel ? (Kernel)dmContext : (Kernel)DMContexts.getAncestorOfType((IDMContext)dmContext, Kernel.class)).getId())) != null) {
                DebugUtil.select((IDMContext)site, parent, toExpand.equals(dmContext), false, this.getVMProvider(), requestMonitor);
                return;
            }
        }
        requestMonitor.done();
    }

    public void update(final IChildrenUpdate[] updates) {
        this.isEnabled(new DataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), null){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleCompleted() {
                if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                    CDPCallStackNode.super.update(updates);
                } else {
                    CDPCallStackNode.this.fillNoElements(updates);
                }
            }
        });
    }

    public void update(ILabelUpdate[] updates) {
        this.getLabelProvider().update(updates);
    }

    public void update(IPropertiesUpdate[] updates) {
        IPropertiesUpdate[] iPropertiesUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertiesUpdate update = iPropertiesUpdateArray[n2];
            Object element = update.getElement();
            KernelCallSite item = DebugUtil.getObject(element, KernelCallSite.class, this.getServicesTracker());
            if (this.fillKernelProperties(update, item)) {
                update.done();
            }
            ++n2;
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    protected void updateElementsInSessionThread(IChildrenUpdate update) {
        Kernel kernel = this.getKernel(update);
        if (kernel != null) {
            LinkedList<KernelCallSite> parents = new LinkedList<KernelCallSite>();
            KernelCallSite site = kernel.getCallSite();
            while (site != null) {
                parents.add(site);
                site = site.getParent().getCallSite();
            }
            this.fillUpdateWithVMCs(update, parents.toArray(new IDMContext[parents.size()]));
            update.done();
        } else {
            this.handleFailedUpdate((IViewerUpdate)update);
        }
    }
}

