/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.activity;

import com.nvidia.viper.activity.CuptiActivityKind;
import java.util.HashMap;
import java.util.Map;

public enum CuptiActivityFlag {
    CUPTI_ACTIVITY_FLAG_NONE(CuptiActivityKind.CUPTI_ACTIVITY_KIND_INVALID, 0),
    CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELS(CuptiActivityKind.CUPTI_ACTIVITY_KIND_DEVICE, 1),
    CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICE(CuptiActivityKind.CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE, 1),
    CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MEMCPY, 1),
    CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER, 1),
    CUPTI_ACTIVITY_FLAG_MARKER_START(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER, 2),
    CUPTI_ACTIVITY_FLAG_MARKER_END(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER, 4),
    CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER, 8),
    CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER, 16),
    CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER, 32),
    CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER, 64),
    CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONE(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER_DATA, 1),
    CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB(CuptiActivityKind.CUPTI_ACTIVITY_KIND_MARKER_DATA, 2),
    CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK(CuptiActivityKind.CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS, 255),
    CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD(CuptiActivityKind.CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS, 256),
    CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED(CuptiActivityKind.CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS, 512),
    CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASK(CuptiActivityKind.CUPTI_ACTIVITY_KIND_SHARED_ACCESS, 255),
    CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOAD(CuptiActivityKind.CUPTI_ACTIVITY_KIND_SHARED_ACCESS, 256),
    CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOW(CuptiActivityKind.CUPTI_ACTIVITY_KIND_METRIC, 1),
    CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALID(CuptiActivityKind.CUPTI_ACTIVITY_KIND_METRIC, 2),
    CUPTI_ACTIVITY_FLAG_METRIC_INSTANCE_OVERFLOW(CuptiActivityKind.CUPTI_ACTIVITY_KIND_METRIC_INSTANCE, 1),
    CUPTI_ACTIVITY_FLAG_METRIC_INSTANCE_VALUE_INVALID(CuptiActivityKind.CUPTI_ACTIVITY_KIND_METRIC_INSTANCE, 2),
    CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID(CuptiActivityKind.CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION, 1),
    CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASK(CuptiActivityKind.CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION, 510),
    CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPU(CuptiActivityKind.CUPTI_ACTIVITY_KIND_UVM_COUNTER, 1),
    CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU(CuptiActivityKind.CUPTI_ACTIVITY_KIND_UVM_COUNTER, 1);

    private int code;
    private CuptiActivityKind kind;
    private static Map<Integer, CuptiActivityFlag> codeMap;

    static {
        codeMap = new HashMap<Integer, CuptiActivityFlag>();
        CuptiActivityFlag[] cuptiActivityFlagArray = CuptiActivityFlag.values();
        int n = cuptiActivityFlagArray.length;
        int n2 = 0;
        while (n2 < n) {
            CuptiActivityFlag res = cuptiActivityFlagArray[n2];
            codeMap.put(res.getCode(), res);
            ++n2;
        }
    }

    private CuptiActivityFlag(CuptiActivityKind kind, int code) {
        this.code = code;
        this.kind = kind;
    }

    public int getCode() {
        return this.code;
    }

    public CuptiActivityKind getKind() {
        return this.kind;
    }

    public boolean isSet(int flags) {
        return (this.code & flags) != 0;
    }

    public static CuptiActivityFlag valueOf(String string) {
        return Enum.valueOf(CuptiActivityFlag.class, string);
    }
}

