/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mimepull;

import java.io.File;

public class MIMEConfig {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private static final long DEFAULT_MEMORY_THRESHOLD = 0x100000L;
    private static final String DEFAULT_FILE_PREFIX = "MIME";
    boolean parseEagerly;
    int chunkSize;
    long memoryThreshold;
    boolean onlyMemory;
    File tempDir;
    String prefix;
    String suffix;

    private MIMEConfig(boolean parseEagerly, int chunkSize, long inMemoryThreshold, String dir, String prefix, String suffix) {
        this.parseEagerly = parseEagerly;
        this.chunkSize = chunkSize;
        this.memoryThreshold = inMemoryThreshold;
        this.prefix = prefix;
        this.suffix = suffix;
        this.setDir(dir);
    }

    public MIMEConfig() {
        this(false, 8192, 0x100000L, null, DEFAULT_FILE_PREFIX, null);
    }

    boolean isParseEagerly() {
        return this.parseEagerly;
    }

    public void setParseEagerly(boolean parseEagerly) {
        this.parseEagerly = parseEagerly;
    }

    int getChunkSize() {
        return this.chunkSize;
    }

    void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    long getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public void setMemoryThreshold(long memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    boolean isOnlyMemory() {
        return this.memoryThreshold == -1L;
    }

    File getTempDir() {
        return this.tempDir;
    }

    String getTempFilePrefix() {
        return this.prefix;
    }

    String getTempFileSuffix() {
        return this.suffix;
    }

    public void setDir(String dir) {
        if (this.tempDir == null && dir != null && !dir.equals("")) {
            this.tempDir = new File(dir);
        }
    }

    public void validate() {
        if (!this.isOnlyMemory()) {
            try {
                File tempFile = this.tempDir == null ? File.createTempFile(this.prefix, this.suffix) : File.createTempFile(this.prefix, this.suffix, this.tempDir);
                tempFile.delete();
            }
            catch (Exception ioe) {
                this.memoryThreshold = -1L;
            }
        }
    }
}

