subroutine  move_li(pos,npart,ndim,vel,masse,dt,cell,nvec,reall,options,dx,rcut,nimage)

  !Deplace les particules
  !Suivant Verlet des vitesses. 
  !Passe des positions et des vitesses a t, a celles a t+1
  !En input, les positions, vitesses, forces a t 
  !En output, les memes a t+1

  !variables
  !eneropt: modele de calcul de l'energie
  !vel(npart,ndim):vitesse des particules
  !energy: energie
  !forces(npart,ndim): forces sur les particules
  !npart: nombre de particules
  !ndim: dimension de l'espace
  !pos(npart,ndim):position des particules
  !cell(nvec,ndim): cellule de simulation
  !nvec: nombre de vecteurs de la cellule
  !masse: masse des particules
  !dt: pas de temps
  !reall:cote maille de simulation
  USE types_def
  IMPLICIT NONE
  TYPE(options_type) :: options
  !input
  integer :: ndim,npart,nvec,nimage,idim
  double precision :: pos(npart,ndim),vel(npart,ndim),cell(nvec,ndim)
  double precision :: masse,dt,reall,dx,rcut
  !output
  !local variables
  integer :: ipart
  double precision, allocatable :: forcesant(:,:),forces(:,:)
  allocate(forcesant(npart,ndim),forces(npart,ndim))
  Call forc(forces,npart,ndim,pos,cell,nvec,reall,dx,options,rcut,nimage)
  do ipart=1,npart
     pos(ipart,:)=pos(ipart,:)+vel(ipart,:)*dt+dt**2/2./masse*forces(ipart,:)/reall**2
  enddo
  forcesant(:,:)=forces(:,:)
!periodic boundary conditions in [0,1]
  do ipart=1,npart
     do idim=1,ndim
!        pos(ipart,idim)=pos(ipart,idim)+float(10.)-int(pos(ipart,idim)+float(10.))
     enddo
  enddo
  Call forc(forces,npart,ndim,pos,cell,nvec,reall,dx,options,rcut,nimage)
  do ipart=1,npart
     vel(ipart,:)=vel(ipart,:)+dt/2./masse*(forcesant(ipart,:)+forces(ipart,:))/reall**2
  enddo
  deallocate(forcesant,forces)
  return
end subroutine move_li
subroutine  move_li_right(pos_right,npart,ndim,vel_right,masse,dt,cell,nvec,reall,options,dx,rcut,nimage)

  !Deplace les particules
  !Suivant Verlet des vitesses. 
  !Passe des positions et des vitesses a t, a celles a t+1
  !En input, les positions, vitesses, forces a t 
  !En output, les memes a t+1

  !variables
  !eneropt: modele de calcul de l'energie
  !vel(npart,ndim):vitesse des particules
  !energy: energie
  !forces(npart,ndim): forces sur les particules
  !npart: nombre de particules
  !ndim: dimension de l'espace
  !pos(npart,ndim):position des particules
  !cell(nvec,ndim): cellule de simulation
  !nvec: nombre de vecteurs de la cellule
  !masse: masse des particules
  !dt: pas de temps
  !reall:cote maille de simulation
  USE types_def
  IMPLICIT NONE
  TYPE(options_type) :: options
  !input
  integer :: ndim,npart,nvec,nimage
  double precision :: pos_right(ndim,npart),vel_right(ndim,npart),cell(nvec,ndim)
  double precision :: masse,dt,reall,dx,rcut
  !output
  !local variables
  integer :: ipart,idim
  double precision, allocatable :: pos(:,:),pos_per(:,:),vel(:,:)
  double precision, allocatable :: forcesant(:,:),forces(:,:)
  allocate(pos(npart,ndim),pos_per(npart,ndim),vel(npart,ndim))  
  do idim=1,ndim
  do ipart=1,npart
  pos(ipart,idim)=pos_right(idim,ipart) !note inversion...ugly
  vel(ipart,idim)=vel_right(idim,ipart)/reall
  enddo
  enddo
  allocate(forcesant(npart,ndim),forces(npart,ndim))
!periodic boundary conditions in [0,1]
        pos_per(:,:)=pos(:,:)+float(10)-int(pos(:,:)+float(10))

  Call forc(forces,npart,ndim,pos_per,cell,nvec,reall,dx,options,rcut,nimage)
  do ipart=1,npart
     pos(ipart,:)=pos(ipart,:)+vel(ipart,:)*dt+dt**2/2./masse*forces(ipart,:)/reall**2
  enddo
  forcesant(:,:)=forces(:,:)
!periodic boundary conditions in [0,1]
        pos_per(:,:)=pos(:,:)+float(10)-int(pos(:,:)+float(10))

  Call forc(forces,npart,ndim,pos_per,cell,nvec,reall,dx,options,rcut,nimage)
  do ipart=1,npart
     vel(ipart,:)=vel(ipart,:)+dt/2./masse*(forcesant(ipart,:)+forces(ipart,:))/reall**2
  enddo
  do idim=1,ndim
  do ipart=1,npart
  pos_right(idim,ipart)=pos(ipart,idim)
  vel_right(idim,ipart)=reall*vel(ipart,idim)
  enddo
  enddo
  deallocate(pos,pos_per,vel)
  deallocate(forcesant,forces)
  return
end subroutine move_li_right







