# ---------------------------------------------------------------------------
# - SPS0007.als                                                             -
# - afnix:sps mdoule test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2015 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   literal stack test unit
# @author amaury darsch

# get the module
interp:library "afnix-sps"

# create a new xref table
const  lstk (afnix:sps:Lstack)
assert true (afnix:sps:lstack-p lstk)

# check length
assert 0 (lstk:length)

# test the boolean stack
lstk:add true
assert 1 (lstk:length)
assert true (lstk:get 0)
lstk:add false
assert 2 (lstk:length)
assert false (lstk:get 1)
lstk:set 0 false
lstk:set 1 true
assert 2 (lstk:length)
assert false (lstk:get 0)
assert true  (lstk:get 1)
assert false (lstk:first)
assert true  (lstk:last)

# test the integer stack
lstk:clear
lstk:add 0
assert 1 (lstk:length)
assert 0 (lstk:get 0)
lstk:add 1
assert 2 (lstk:length)
assert 1 (lstk:get 1)
lstk:set 0 2
lstk:set 1 3
assert 2 (lstk:length)
assert 2 (lstk:get 0)
assert 3 (lstk:get 1)
assert 2 (lstk:first)
assert 3 (lstk:last)

# check iterator
trans sum 0.
for (x) (lstk) (sum:+= x)
assert 5 sum

# test the real stack
lstk:clear
lstk:add 0.0
assert 1 (lstk:length)
assert 0.0 (lstk:get 0)
lstk:add 1.0
assert 2 (lstk:length)
assert 1.0 (lstk:get 1)
lstk:set 0 2.0
lstk:set 1 3.0
assert 2 (lstk:length)
assert 2.0 (lstk:get 0)
assert 3.0 (lstk:get 1)
assert 2.0 (lstk:first)
assert 3.0 (lstk:last)

# check iterator
trans sum 0.0
for (x) (lstk) (sum:+= x)
assert 5.0 sum

# test the literal stack
lstk:clear
lstk:add 0R
assert 1  (lstk:length)
assert 0R (lstk:get 0)
lstk:add 1R
assert 2  (lstk:length)
assert 1R (lstk:get 1)
lstk:set 0 2R
lstk:set 1 3R
assert 2  (lstk:length)
assert 2R (lstk:get 0)
assert 3R (lstk:get 1)
assert 2R (lstk:first)
assert 3R (lstk:last)
