/*
 * Copyright (C) 2016 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.databinding.testapp;

import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.support.test.InstrumentationRegistry;
import android.support.test.rule.ActivityTestRule;

/**
 * Convenience rule for tests that use data binding.
 * @param <T> The type of the generated binding class
 */
public class DataBindingTestRule<T extends ViewDataBinding>
        extends ActivityTestRule<TestActivity> {
    final int mLayoutId;
    private T mBinding;
    public DataBindingTestRule(int layoutId) {
        super(TestActivity.class);
        mLayoutId = layoutId;
    }

    @Override
    protected void afterActivityLaunched() {
        super.afterActivityLaunched();
        InstrumentationRegistry.getInstrumentation().runOnMainSync(new Runnable() {
            @Override
            public void run() {
                mBinding = DataBindingUtil.setContentView(getActivity(), mLayoutId);
            }
        });
    }

    public T getBinding() {
        return mBinding;
    }

    public void executePending() {
        try {
            runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mBinding.executePendingBindings();
                }
            });
        } catch (Throwable throwable) {
            throw new RuntimeException("unexpected problem in execute pending", throwable);
        }
    }
}
