/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jiapi.reflect;

import java.util.LinkedList;
import java.util.List;
import net.sf.jiapi.file.ConstantPool;
import net.sf.jiapi.reflect.BranchInstruction;
import net.sf.jiapi.reflect.Instruction;
import net.sf.jiapi.reflect.SwitchInstruction;
import net.sf.jiapi.reflect.instruction.AALoad;
import net.sf.jiapi.reflect.instruction.AAStore;
import net.sf.jiapi.reflect.instruction.AConstNull;
import net.sf.jiapi.reflect.instruction.ALoad;
import net.sf.jiapi.reflect.instruction.ALoad0;
import net.sf.jiapi.reflect.instruction.ALoad1;
import net.sf.jiapi.reflect.instruction.ALoad2;
import net.sf.jiapi.reflect.instruction.ALoad3;
import net.sf.jiapi.reflect.instruction.ANewArray;
import net.sf.jiapi.reflect.instruction.AReturn;
import net.sf.jiapi.reflect.instruction.AStore;
import net.sf.jiapi.reflect.instruction.AStore0;
import net.sf.jiapi.reflect.instruction.AStore1;
import net.sf.jiapi.reflect.instruction.AStore2;
import net.sf.jiapi.reflect.instruction.AStore3;
import net.sf.jiapi.reflect.instruction.AThrow;
import net.sf.jiapi.reflect.instruction.ArrayLength;
import net.sf.jiapi.reflect.instruction.BALoad;
import net.sf.jiapi.reflect.instruction.BAStore;
import net.sf.jiapi.reflect.instruction.BIPush;
import net.sf.jiapi.reflect.instruction.BreakPoint;
import net.sf.jiapi.reflect.instruction.CALoad;
import net.sf.jiapi.reflect.instruction.CAStore;
import net.sf.jiapi.reflect.instruction.CheckCast;
import net.sf.jiapi.reflect.instruction.D2F;
import net.sf.jiapi.reflect.instruction.D2I;
import net.sf.jiapi.reflect.instruction.D2L;
import net.sf.jiapi.reflect.instruction.DALoad;
import net.sf.jiapi.reflect.instruction.DAStore;
import net.sf.jiapi.reflect.instruction.DAdd;
import net.sf.jiapi.reflect.instruction.DCmpG;
import net.sf.jiapi.reflect.instruction.DCmpL;
import net.sf.jiapi.reflect.instruction.DConst0;
import net.sf.jiapi.reflect.instruction.DConst1;
import net.sf.jiapi.reflect.instruction.DDiv;
import net.sf.jiapi.reflect.instruction.DLoad;
import net.sf.jiapi.reflect.instruction.DLoad0;
import net.sf.jiapi.reflect.instruction.DLoad1;
import net.sf.jiapi.reflect.instruction.DLoad2;
import net.sf.jiapi.reflect.instruction.DLoad3;
import net.sf.jiapi.reflect.instruction.DMul;
import net.sf.jiapi.reflect.instruction.DNeg;
import net.sf.jiapi.reflect.instruction.DRem;
import net.sf.jiapi.reflect.instruction.DReturn;
import net.sf.jiapi.reflect.instruction.DStore;
import net.sf.jiapi.reflect.instruction.DStore0;
import net.sf.jiapi.reflect.instruction.DStore1;
import net.sf.jiapi.reflect.instruction.DStore2;
import net.sf.jiapi.reflect.instruction.DStore3;
import net.sf.jiapi.reflect.instruction.DSub;
import net.sf.jiapi.reflect.instruction.Dup;
import net.sf.jiapi.reflect.instruction.Dup2;
import net.sf.jiapi.reflect.instruction.Dup2X1;
import net.sf.jiapi.reflect.instruction.Dup2X2;
import net.sf.jiapi.reflect.instruction.DupX1;
import net.sf.jiapi.reflect.instruction.DupX2;
import net.sf.jiapi.reflect.instruction.F2D;
import net.sf.jiapi.reflect.instruction.F2I;
import net.sf.jiapi.reflect.instruction.F2L;
import net.sf.jiapi.reflect.instruction.FALoad;
import net.sf.jiapi.reflect.instruction.FAStore;
import net.sf.jiapi.reflect.instruction.FAdd;
import net.sf.jiapi.reflect.instruction.FCmpG;
import net.sf.jiapi.reflect.instruction.FCmpL;
import net.sf.jiapi.reflect.instruction.FConst0;
import net.sf.jiapi.reflect.instruction.FConst1;
import net.sf.jiapi.reflect.instruction.FConst2;
import net.sf.jiapi.reflect.instruction.FDiv;
import net.sf.jiapi.reflect.instruction.FLoad;
import net.sf.jiapi.reflect.instruction.FLoad0;
import net.sf.jiapi.reflect.instruction.FLoad1;
import net.sf.jiapi.reflect.instruction.FLoad2;
import net.sf.jiapi.reflect.instruction.FLoad3;
import net.sf.jiapi.reflect.instruction.FMul;
import net.sf.jiapi.reflect.instruction.FNeg;
import net.sf.jiapi.reflect.instruction.FRem;
import net.sf.jiapi.reflect.instruction.FReturn;
import net.sf.jiapi.reflect.instruction.FStore;
import net.sf.jiapi.reflect.instruction.FStore0;
import net.sf.jiapi.reflect.instruction.FStore1;
import net.sf.jiapi.reflect.instruction.FStore2;
import net.sf.jiapi.reflect.instruction.FStore3;
import net.sf.jiapi.reflect.instruction.FSub;
import net.sf.jiapi.reflect.instruction.GetField;
import net.sf.jiapi.reflect.instruction.GetStatic;
import net.sf.jiapi.reflect.instruction.Goto;
import net.sf.jiapi.reflect.instruction.GotoW;
import net.sf.jiapi.reflect.instruction.I2B;
import net.sf.jiapi.reflect.instruction.I2C;
import net.sf.jiapi.reflect.instruction.I2D;
import net.sf.jiapi.reflect.instruction.I2F;
import net.sf.jiapi.reflect.instruction.I2L;
import net.sf.jiapi.reflect.instruction.I2S;
import net.sf.jiapi.reflect.instruction.IALoad;
import net.sf.jiapi.reflect.instruction.IAStore;
import net.sf.jiapi.reflect.instruction.IAdd;
import net.sf.jiapi.reflect.instruction.IAnd;
import net.sf.jiapi.reflect.instruction.IConst0;
import net.sf.jiapi.reflect.instruction.IConst1;
import net.sf.jiapi.reflect.instruction.IConst2;
import net.sf.jiapi.reflect.instruction.IConst3;
import net.sf.jiapi.reflect.instruction.IConst4;
import net.sf.jiapi.reflect.instruction.IConst5;
import net.sf.jiapi.reflect.instruction.IConstM1;
import net.sf.jiapi.reflect.instruction.IDiv;
import net.sf.jiapi.reflect.instruction.IInc;
import net.sf.jiapi.reflect.instruction.ILoad;
import net.sf.jiapi.reflect.instruction.ILoad0;
import net.sf.jiapi.reflect.instruction.ILoad1;
import net.sf.jiapi.reflect.instruction.ILoad2;
import net.sf.jiapi.reflect.instruction.ILoad3;
import net.sf.jiapi.reflect.instruction.IMul;
import net.sf.jiapi.reflect.instruction.INeg;
import net.sf.jiapi.reflect.instruction.IOr;
import net.sf.jiapi.reflect.instruction.IRem;
import net.sf.jiapi.reflect.instruction.IReturn;
import net.sf.jiapi.reflect.instruction.IShl;
import net.sf.jiapi.reflect.instruction.IShr;
import net.sf.jiapi.reflect.instruction.IStore;
import net.sf.jiapi.reflect.instruction.IStore0;
import net.sf.jiapi.reflect.instruction.IStore1;
import net.sf.jiapi.reflect.instruction.IStore2;
import net.sf.jiapi.reflect.instruction.IStore3;
import net.sf.jiapi.reflect.instruction.ISub;
import net.sf.jiapi.reflect.instruction.IUShr;
import net.sf.jiapi.reflect.instruction.IXor;
import net.sf.jiapi.reflect.instruction.IfACmpEq;
import net.sf.jiapi.reflect.instruction.IfACmpNe;
import net.sf.jiapi.reflect.instruction.IfEq;
import net.sf.jiapi.reflect.instruction.IfGe;
import net.sf.jiapi.reflect.instruction.IfGt;
import net.sf.jiapi.reflect.instruction.IfICmpEq;
import net.sf.jiapi.reflect.instruction.IfICmpGe;
import net.sf.jiapi.reflect.instruction.IfICmpGt;
import net.sf.jiapi.reflect.instruction.IfICmpLe;
import net.sf.jiapi.reflect.instruction.IfICmpLt;
import net.sf.jiapi.reflect.instruction.IfICmpNe;
import net.sf.jiapi.reflect.instruction.IfLe;
import net.sf.jiapi.reflect.instruction.IfLt;
import net.sf.jiapi.reflect.instruction.IfNe;
import net.sf.jiapi.reflect.instruction.IfNonNull;
import net.sf.jiapi.reflect.instruction.IfNull;
import net.sf.jiapi.reflect.instruction.ImpDep1;
import net.sf.jiapi.reflect.instruction.ImpDep2;
import net.sf.jiapi.reflect.instruction.InstanceOf;
import net.sf.jiapi.reflect.instruction.InvokeDynamic;
import net.sf.jiapi.reflect.instruction.InvokeInterface;
import net.sf.jiapi.reflect.instruction.InvokeSpecial;
import net.sf.jiapi.reflect.instruction.InvokeStatic;
import net.sf.jiapi.reflect.instruction.InvokeVirtual;
import net.sf.jiapi.reflect.instruction.Jsr;
import net.sf.jiapi.reflect.instruction.JsrW;
import net.sf.jiapi.reflect.instruction.L2D;
import net.sf.jiapi.reflect.instruction.L2F;
import net.sf.jiapi.reflect.instruction.L2I;
import net.sf.jiapi.reflect.instruction.LALoad;
import net.sf.jiapi.reflect.instruction.LAStore;
import net.sf.jiapi.reflect.instruction.LAdd;
import net.sf.jiapi.reflect.instruction.LAnd;
import net.sf.jiapi.reflect.instruction.LCmp;
import net.sf.jiapi.reflect.instruction.LConst0;
import net.sf.jiapi.reflect.instruction.LConst1;
import net.sf.jiapi.reflect.instruction.LDiv;
import net.sf.jiapi.reflect.instruction.LLoad;
import net.sf.jiapi.reflect.instruction.LLoad0;
import net.sf.jiapi.reflect.instruction.LLoad1;
import net.sf.jiapi.reflect.instruction.LLoad2;
import net.sf.jiapi.reflect.instruction.LLoad3;
import net.sf.jiapi.reflect.instruction.LMul;
import net.sf.jiapi.reflect.instruction.LNeg;
import net.sf.jiapi.reflect.instruction.LOr;
import net.sf.jiapi.reflect.instruction.LRem;
import net.sf.jiapi.reflect.instruction.LReturn;
import net.sf.jiapi.reflect.instruction.LShl;
import net.sf.jiapi.reflect.instruction.LShr;
import net.sf.jiapi.reflect.instruction.LStore;
import net.sf.jiapi.reflect.instruction.LStore0;
import net.sf.jiapi.reflect.instruction.LStore1;
import net.sf.jiapi.reflect.instruction.LStore2;
import net.sf.jiapi.reflect.instruction.LStore3;
import net.sf.jiapi.reflect.instruction.LSub;
import net.sf.jiapi.reflect.instruction.LUShr;
import net.sf.jiapi.reflect.instruction.LXor;
import net.sf.jiapi.reflect.instruction.Ldc;
import net.sf.jiapi.reflect.instruction.Ldc2W;
import net.sf.jiapi.reflect.instruction.LdcW;
import net.sf.jiapi.reflect.instruction.MonitorEnter;
import net.sf.jiapi.reflect.instruction.MonitorExit;
import net.sf.jiapi.reflect.instruction.MultiNewArray;
import net.sf.jiapi.reflect.instruction.New;
import net.sf.jiapi.reflect.instruction.NewArray;
import net.sf.jiapi.reflect.instruction.Nop;
import net.sf.jiapi.reflect.instruction.Pop;
import net.sf.jiapi.reflect.instruction.Pop2;
import net.sf.jiapi.reflect.instruction.PutField;
import net.sf.jiapi.reflect.instruction.PutStatic;
import net.sf.jiapi.reflect.instruction.Ret;
import net.sf.jiapi.reflect.instruction.Return;
import net.sf.jiapi.reflect.instruction.SALoad;
import net.sf.jiapi.reflect.instruction.SAStore;
import net.sf.jiapi.reflect.instruction.SIPush;
import net.sf.jiapi.reflect.instruction.Swap;

class InstructionParser {
    InstructionParser() {
    }

    List<Instruction> createInstructionList(byte[] byteCode, ConstantPool cp) {
        int i;
        LinkedList<Instruction> list = new LinkedList<Instruction>();
        boolean branchesFound = false;
        for (i = 0; i < byteCode.length; ++i) {
            byte opcode = byteCode[i];
            Instruction ins = null;
            switch (opcode) {
                case 0: {
                    ins = new Nop();
                    break;
                }
                case 1: {
                    ins = new AConstNull();
                    break;
                }
                case 2: {
                    ins = new IConstM1();
                    break;
                }
                case 3: {
                    ins = new IConst0();
                    break;
                }
                case 4: {
                    ins = new IConst1();
                    break;
                }
                case 5: {
                    ins = new IConst2();
                    break;
                }
                case 6: {
                    ins = new IConst3();
                    break;
                }
                case 7: {
                    ins = new IConst4();
                    break;
                }
                case 8: {
                    ins = new IConst5();
                    break;
                }
                case 9: {
                    ins = new LConst0();
                    break;
                }
                case 10: {
                    ins = new LConst1();
                    break;
                }
                case 11: {
                    ins = new FConst0();
                    break;
                }
                case 12: {
                    ins = new FConst1();
                    break;
                }
                case 13: {
                    ins = new FConst2();
                    break;
                }
                case 14: {
                    ins = new DConst0();
                    break;
                }
                case 15: {
                    ins = new DConst1();
                    break;
                }
                case 16: {
                    ins = new BIPush(byteCode[i + 1]);
                    break;
                }
                case 17: {
                    ins = new SIPush(byteCode[i + 1], byteCode[i + 2]);
                    break;
                }
                case 18: {
                    ins = new Ldc(byteCode[i + 1], cp);
                    break;
                }
                case 19: {
                    ins = new LdcW(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case 20: {
                    ins = new Ldc2W(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case 21: {
                    ins = new ILoad(byteCode[i + 1]);
                    break;
                }
                case 22: {
                    ins = new LLoad(byteCode[i + 1]);
                    break;
                }
                case 23: {
                    ins = new FLoad(byteCode[i + 1]);
                    break;
                }
                case 24: {
                    ins = new DLoad(byteCode[i + 1]);
                    break;
                }
                case 25: {
                    ins = new ALoad(byteCode[i + 1]);
                    break;
                }
                case 26: {
                    ins = new ILoad0();
                    break;
                }
                case 27: {
                    ins = new ILoad1();
                    break;
                }
                case 28: {
                    ins = new ILoad2();
                    break;
                }
                case 29: {
                    ins = new ILoad3();
                    break;
                }
                case 30: {
                    ins = new LLoad0();
                    break;
                }
                case 31: {
                    ins = new LLoad1();
                    break;
                }
                case 32: {
                    ins = new LLoad2();
                    break;
                }
                case 33: {
                    ins = new LLoad3();
                    break;
                }
                case 34: {
                    ins = new FLoad0();
                    break;
                }
                case 35: {
                    ins = new FLoad1();
                    break;
                }
                case 36: {
                    ins = new FLoad2();
                    break;
                }
                case 37: {
                    ins = new FLoad3();
                    break;
                }
                case 38: {
                    ins = new DLoad0();
                    break;
                }
                case 39: {
                    ins = new DLoad1();
                    break;
                }
                case 40: {
                    ins = new DLoad2();
                    break;
                }
                case 41: {
                    ins = new DLoad3();
                    break;
                }
                case 42: {
                    ins = new ALoad0();
                    break;
                }
                case 43: {
                    ins = new ALoad1();
                    break;
                }
                case 44: {
                    ins = new ALoad2();
                    break;
                }
                case 45: {
                    ins = new ALoad3();
                    break;
                }
                case 46: {
                    ins = new IALoad();
                    break;
                }
                case 47: {
                    ins = new LALoad();
                    break;
                }
                case 48: {
                    ins = new FALoad();
                    break;
                }
                case 49: {
                    ins = new DALoad();
                    break;
                }
                case 50: {
                    ins = new AALoad();
                    break;
                }
                case 51: {
                    ins = new BALoad();
                    break;
                }
                case 52: {
                    ins = new CALoad();
                    break;
                }
                case 53: {
                    ins = new SALoad();
                    break;
                }
                case 54: {
                    ins = new IStore(byteCode[i + 1]);
                    break;
                }
                case 55: {
                    ins = new LStore(byteCode[i + 1]);
                    break;
                }
                case 56: {
                    ins = new FStore(byteCode[i + 1]);
                    break;
                }
                case 57: {
                    ins = new DStore(byteCode[i + 1]);
                    break;
                }
                case 58: {
                    ins = new AStore(byteCode[i + 1]);
                    break;
                }
                case 59: {
                    ins = new IStore0();
                    break;
                }
                case 60: {
                    ins = new IStore1();
                    break;
                }
                case 61: {
                    ins = new IStore2();
                    break;
                }
                case 62: {
                    ins = new IStore3();
                    break;
                }
                case 63: {
                    ins = new LStore0();
                    break;
                }
                case 64: {
                    ins = new LStore1();
                    break;
                }
                case 65: {
                    ins = new LStore2();
                    break;
                }
                case 66: {
                    ins = new LStore3();
                    break;
                }
                case 67: {
                    ins = new FStore0();
                    break;
                }
                case 68: {
                    ins = new FStore1();
                    break;
                }
                case 69: {
                    ins = new FStore2();
                    break;
                }
                case 70: {
                    ins = new FStore3();
                    break;
                }
                case 71: {
                    ins = new DStore0();
                    break;
                }
                case 72: {
                    ins = new DStore1();
                    break;
                }
                case 73: {
                    ins = new DStore2();
                    break;
                }
                case 74: {
                    ins = new DStore3();
                    break;
                }
                case 75: {
                    ins = new AStore0();
                    break;
                }
                case 76: {
                    ins = new AStore1();
                    break;
                }
                case 77: {
                    ins = new AStore2();
                    break;
                }
                case 78: {
                    ins = new AStore3();
                    break;
                }
                case 79: {
                    ins = new IAStore();
                    break;
                }
                case 80: {
                    ins = new LAStore();
                    break;
                }
                case 81: {
                    ins = new FAStore();
                    break;
                }
                case 82: {
                    ins = new DAStore();
                    break;
                }
                case 83: {
                    ins = new AAStore();
                    break;
                }
                case 84: {
                    ins = new BAStore();
                    break;
                }
                case 85: {
                    ins = new CAStore();
                    break;
                }
                case 86: {
                    ins = new SAStore();
                    break;
                }
                case 87: {
                    ins = new Pop();
                    break;
                }
                case 88: {
                    ins = new Pop2();
                    break;
                }
                case 89: {
                    ins = new Dup();
                    break;
                }
                case 90: {
                    ins = new DupX1();
                    break;
                }
                case 91: {
                    ins = new DupX2();
                    break;
                }
                case 92: {
                    ins = new Dup2();
                    break;
                }
                case 93: {
                    ins = new Dup2X1();
                    break;
                }
                case 94: {
                    ins = new Dup2X2();
                    break;
                }
                case 95: {
                    ins = new Swap();
                    break;
                }
                case 96: {
                    ins = new IAdd();
                    break;
                }
                case 97: {
                    ins = new LAdd();
                    break;
                }
                case 98: {
                    ins = new FAdd();
                    break;
                }
                case 99: {
                    ins = new DAdd();
                    break;
                }
                case 100: {
                    ins = new ISub();
                    break;
                }
                case 101: {
                    ins = new LSub();
                    break;
                }
                case 102: {
                    ins = new FSub();
                    break;
                }
                case 103: {
                    ins = new DSub();
                    break;
                }
                case 104: {
                    ins = new IMul();
                    break;
                }
                case 105: {
                    ins = new LMul();
                    break;
                }
                case 106: {
                    ins = new FMul();
                    break;
                }
                case 107: {
                    ins = new DMul();
                    break;
                }
                case 108: {
                    ins = new IDiv();
                    break;
                }
                case 109: {
                    ins = new LDiv();
                    break;
                }
                case 110: {
                    ins = new FDiv();
                    break;
                }
                case 111: {
                    ins = new DDiv();
                    break;
                }
                case 112: {
                    ins = new IRem();
                    break;
                }
                case 113: {
                    ins = new LRem();
                    break;
                }
                case 114: {
                    ins = new FRem();
                    break;
                }
                case 115: {
                    ins = new DRem();
                    break;
                }
                case 116: {
                    ins = new INeg();
                    break;
                }
                case 117: {
                    ins = new LNeg();
                    break;
                }
                case 118: {
                    ins = new FNeg();
                    break;
                }
                case 119: {
                    ins = new DNeg();
                    break;
                }
                case 120: {
                    ins = new IShl();
                    break;
                }
                case 121: {
                    ins = new LShl();
                    break;
                }
                case 122: {
                    ins = new IShr();
                    break;
                }
                case 123: {
                    ins = new LShr();
                    break;
                }
                case 124: {
                    ins = new IUShr();
                    break;
                }
                case 125: {
                    ins = new LUShr();
                    break;
                }
                case 126: {
                    ins = new IAnd();
                    break;
                }
                case 127: {
                    ins = new LAnd();
                    break;
                }
                case -128: {
                    ins = new IOr();
                    break;
                }
                case -127: {
                    ins = new LOr();
                    break;
                }
                case -126: {
                    ins = new IXor();
                    break;
                }
                case -125: {
                    ins = new LXor();
                    break;
                }
                case -124: {
                    ins = new IInc(byteCode[i + 1], byteCode[i + 2]);
                    break;
                }
                case -123: {
                    ins = new I2L();
                    break;
                }
                case -122: {
                    ins = new I2F();
                    break;
                }
                case -121: {
                    ins = new I2D();
                    break;
                }
                case -120: {
                    ins = new L2I();
                    break;
                }
                case -119: {
                    ins = new L2F();
                    break;
                }
                case -118: {
                    ins = new L2D();
                    break;
                }
                case -117: {
                    ins = new F2I();
                    break;
                }
                case -116: {
                    ins = new F2L();
                    break;
                }
                case -115: {
                    ins = new F2D();
                    break;
                }
                case -114: {
                    ins = new D2I();
                    break;
                }
                case -113: {
                    ins = new D2L();
                    break;
                }
                case -112: {
                    ins = new D2F();
                    break;
                }
                case -111: {
                    ins = new I2B();
                    break;
                }
                case -110: {
                    ins = new I2C();
                    break;
                }
                case -109: {
                    ins = new I2S();
                    break;
                }
                case -108: {
                    ins = new LCmp();
                    break;
                }
                case -107: {
                    ins = new FCmpL();
                    break;
                }
                case -106: {
                    ins = new FCmpG();
                    break;
                }
                case -105: {
                    ins = new DCmpL();
                    break;
                }
                case -104: {
                    ins = new DCmpG();
                    break;
                }
                case -103: {
                    ins = new IfEq(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -102: {
                    ins = new IfNe(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -101: {
                    ins = new IfLt(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -100: {
                    ins = new IfGe(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -99: {
                    ins = new IfGt(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -98: {
                    ins = new IfLe(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -97: {
                    ins = new IfICmpEq(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -96: {
                    ins = new IfICmpNe(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -95: {
                    ins = new IfICmpLt(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -94: {
                    ins = new IfICmpGe(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -93: {
                    ins = new IfICmpGt(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -92: {
                    ins = new IfICmpLe(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -91: {
                    ins = new IfACmpEq(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -90: {
                    ins = new IfACmpNe(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -89: {
                    ins = new Goto(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -88: {
                    ins = new Jsr(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -87: {
                    ins = new Ret(byteCode[i + 1]);
                    break;
                }
                case -86: {
                    branchesFound = true;
                    int tspCount = 3 - i % 4;
                    byte l1 = byteCode[i + tspCount + 5];
                    byte l2 = byteCode[i + tspCount + 6];
                    byte l3 = byteCode[i + tspCount + 7];
                    byte l4 = byteCode[i + tspCount + 8];
                    int low = l1 << 24 | l2 << 16 | l3 << 8 | l4;
                    byte h1 = byteCode[i + tspCount + 9];
                    byte h2 = byteCode[i + tspCount + 10];
                    byte h3 = byteCode[i + tspCount + 11];
                    byte h4 = byteCode[i + tspCount + 12];
                    int high = h1 << 24 | h2 << 16 | h3 << 8 | h4;
                    int size = high - low + 1;
                    int bSize = size * 4;
                    byte[] tsBytes = new byte[13 + tspCount + bSize];
                    for (int k = 0; k < tsBytes.length; ++k) {
                        tsBytes[k] = byteCode[i + k];
                    }
                    ins = new SwitchInstruction(tsBytes, tspCount, size);
                    break;
                }
                case -85: {
                    branchesFound = true;
                    int pCount = 3 - i % 4;
                    byte np1 = byteCode[i + pCount + 5];
                    byte np2 = byteCode[i + pCount + 6];
                    byte np3 = byteCode[i + pCount + 7];
                    byte np4 = byteCode[i + pCount + 8];
                    int nPairs = np1 << 24 & 0xFF000000 | np2 << 16 & 0xFF0000 | np3 << 8 & 0xFF00 | np4 & 0xFF;
                    int lbSize = nPairs * 4 * 2;
                    byte[] lsBytes = new byte[9 + pCount + lbSize];
                    for (int k = 0; k < lsBytes.length; ++k) {
                        lsBytes[k] = byteCode[i + k];
                    }
                    ins = new SwitchInstruction(lsBytes, pCount, nPairs);
                    break;
                }
                case -84: {
                    ins = new IReturn();
                    break;
                }
                case -83: {
                    ins = new LReturn();
                    break;
                }
                case -82: {
                    ins = new FReturn();
                    break;
                }
                case -81: {
                    ins = new DReturn();
                    break;
                }
                case -80: {
                    ins = new AReturn();
                    break;
                }
                case -79: {
                    ins = new Return();
                    break;
                }
                case -78: {
                    ins = new GetStatic(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -77: {
                    ins = new PutStatic(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -76: {
                    ins = new GetField(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -75: {
                    ins = new PutField(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -74: {
                    ins = new InvokeVirtual(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -73: {
                    ins = new InvokeSpecial(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -72: {
                    ins = new InvokeStatic(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -71: {
                    ins = new InvokeInterface(byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], byteCode[i + 4], cp);
                    break;
                }
                case -70: {
                    ins = new InvokeDynamic(byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], byteCode[i + 4], cp);
                    break;
                }
                case -69: {
                    ins = new New(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -68: {
                    ins = new NewArray(byteCode[i + 1]);
                    break;
                }
                case -67: {
                    ins = new ANewArray(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -66: {
                    ins = new ArrayLength();
                    break;
                }
                case -65: {
                    ins = new AThrow();
                    break;
                }
                case -64: {
                    ins = new CheckCast(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -63: {
                    ins = new InstanceOf(byteCode[i + 1], byteCode[i + 2], cp);
                    break;
                }
                case -62: {
                    ins = new MonitorEnter();
                    break;
                }
                case -61: {
                    ins = new MonitorExit();
                    break;
                }
                case -60: {
                    if (byteCode[i + 1] == -124) {
                        ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], byteCode[i + 4], byteCode[i + 5]});
                        break;
                    }
                    ins = new Instruction(new byte[]{byteCode[i], byteCode[i + 1], byteCode[i + 2], byteCode[i + 3]});
                    break;
                }
                case -59: {
                    ins = new MultiNewArray(byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], byteCode[i + 4]);
                    break;
                }
                case -58: {
                    ins = new IfNull(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -57: {
                    ins = new IfNonNull(byteCode[i + 1], byteCode[i + 2]);
                    branchesFound = true;
                    break;
                }
                case -56: {
                    ins = new GotoW(byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], byteCode[i + 4]);
                    branchesFound = true;
                    break;
                }
                case -55: {
                    ins = new JsrW(byteCode[i + 1], byteCode[i + 2], byteCode[i + 3], byteCode[i + 4]);
                    branchesFound = true;
                    break;
                }
                case -54: {
                    ins = new BreakPoint();
                    break;
                }
                case -2: {
                    ins = new ImpDep1();
                    break;
                }
                case -1: {
                    ins = new ImpDep2();
                }
            }
            ins.setOffset((short)i);
            i += ins.length() - 1;
            list.add(ins);
        }
        if (branchesFound) {
            for (i = 0; i < list.size(); ++i) {
                Instruction target;
                Instruction ins = (Instruction)list.get(i);
                if (ins instanceof BranchInstruction) {
                    BranchInstruction bi = (BranchInstruction)ins;
                    int offset = bi.getTargetOffset();
                    target = null;
                    target = this.findTarget(list, bi.getOffset() + offset);
                    if (target != null) {
                        bi.setTarget(target);
                        target.setBranchParent(bi);
                        continue;
                    }
                    System.out.println("Error locating branch target for instruction at " + i + ": " + bi);
                    continue;
                }
                if (!(ins instanceof SwitchInstruction)) continue;
                SwitchInstruction si = (SwitchInstruction)ins;
                int dOffset = si.getDefaultOffset();
                target = null;
                target = this.findTarget(list, i, dOffset);
                si.setDefault(target);
                int[] tOffsets = si.getTargetOffsets();
                Instruction[] targets = new Instruction[tOffsets.length];
                for (int j = 0; j < targets.length; ++j) {
                    targets[j] = this.findTarget(list, i, tOffsets[j]);
                }
                si.setTargets(targets);
            }
        }
        return list;
    }

    private Instruction findTarget(List<Instruction> list, int offset) {
        int idx = 0;
        int currentOffset = 0;
        while (currentOffset != offset) {
            if (idx == list.size()) {
                return null;
            }
            Instruction ins = list.get(idx);
            currentOffset += ins.length();
            ++idx;
        }
        return list.get(idx);
    }

    private Instruction findTarget(List<Instruction> list, int idx, int offset) {
        int offs = offset;
        int dir = 1;
        if (offset < 0) {
            offs = -offset;
            dir = -1;
        }
        int i = 0;
        while (i < offs) {
            Instruction ins = list.get(idx);
            i += ins.length();
            idx += dir;
        }
        return list.get(idx);
    }
}

