/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLStyleSheet;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.xpath.XPathException;

public class XSLCharacterMap
extends StyleElement {
    int fingerprint;
    String use;
    List characterMapElements = null;
    boolean validated = false;
    boolean redundant = false;

    public int getCharacterMapFingerprint() {
        return this.fingerprint;
    }

    public boolean isRedundant() {
        return this.redundant;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        String string = null;
        this.use = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            String string2 = this.getNamePool().getClarkName(n);
            if (string2 == "name") {
                string = attributeCollection.getValue(n2).trim();
            } else if (string2 == "use-character-maps") {
                this.use = attributeCollection.getValue(n2);
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            n = this.makeNameCode(string);
            this.fingerprint = n & 0xFFFFF;
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
    }

    public void validate() throws TransformerConfigurationException {
        Item item;
        if (this.validated) {
            return;
        }
        this.checkTopLevel();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((item = axisIterator.next()) != null) {
            if (item instanceof XSLOutputCharacter) continue;
            this.compileError("Only xsl:output-character is allowed within xsl:character-map");
        }
        item = this.getPrincipalStyleSheet();
        XSLCharacterMap xSLCharacterMap = ((XSLStyleSheet)item).getCharacterMap(this.fingerprint);
        if (xSLCharacterMap != this) {
            if (this.getPrecedence() == xSLCharacterMap.getPrecedence()) {
                this.compileError("There are two character-maps with the same name and import precedence");
            } else if (this.getPrecedence() < xSLCharacterMap.getPrecedence()) {
                this.redundant = true;
            }
        }
        if (this.use != null) {
            Object object;
            this.characterMapElements = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(this.use);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                try {
                    String[] stringArray = Name.getQNameParts((String)object);
                    String string = this.getURIForPrefix(stringArray[0], false);
                    int n = this.getTargetNamePool().allocate(stringArray[0], string, stringArray[1]);
                    XSLCharacterMap xSLCharacterMap2 = ((XSLStyleSheet)item).getCharacterMap(n & 0xFFFFF);
                    if (xSLCharacterMap2 == null) {
                        this.compileError("No character-map named '" + (String)object + "' has been defined");
                        continue;
                    }
                    this.characterMapElements.add(xSLCharacterMap2);
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid character-map name. " + qNameException.getMessage());
                }
                catch (NamespaceException namespaceException) {
                    this.compileError(namespaceException.getMessage());
                }
            }
            object = this.characterMapElements.iterator();
            while (object.hasNext()) {
                ((XSLCharacterMap)object.next()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    private void checkCircularity(XSLCharacterMap xSLCharacterMap) throws TransformerConfigurationException {
        if (this == xSLCharacterMap) {
            this.compileError("The definition of the character map is circular");
            this.characterMapElements = null;
        } else {
            if (!this.validated) {
                return;
            }
            if (this.characterMapElements != null) {
                Iterator iterator = this.characterMapElements.iterator();
                while (iterator.hasNext()) {
                    ((XSLCharacterMap)iterator.next()).checkCircularity(xSLCharacterMap);
                }
            }
        }
    }

    public void assemble(HashMap hashMap) {
        Item item;
        if (this.characterMapElements != null) {
            int n = 0;
            while (n < this.characterMapElements.size()) {
                item = (XSLCharacterMap)this.characterMapElements.get(n);
                ((XSLCharacterMap)item).assemble(hashMap);
                ++n;
            }
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((item = axisIterator.next()) != null) {
            XSLOutputCharacter xSLOutputCharacter = (XSLOutputCharacter)item;
            hashMap.put(new Integer(xSLOutputCharacter.getCodePoint()), xSLOutputCharacter.getReplacementString());
        }
        return;
    }

    public Instruction compile() throws TransformerConfigurationException {
        return null;
    }
}

