function jjprem(nombre, iret)
! ======================================================================
! COPYRIGHT (C) 1991 - 2012  EDF R&D                  WWW.CODE-ASTER.ORG
! THIS PROGRAM IS FREE SOFTWARE; YOU CAN REDISTRIBUTE IT AND/OR MODIFY
! IT UNDER THE TERMS OF THE GNU GENERAL PUBLIC LICENSE AS PUBLISHED BY
! THE FREE SOFTWARE FOUNDATION; EITHER VERSION 2 OF THE LICENSE, OR
! (AT YOUR OPTION) ANY LATER VERSION.
!
! THIS PROGRAM IS DISTRIBUTED IN THE HOPE THAT IT WILL BE USEFUL, BUT
! WITHOUT ANY WARRANTY; WITHOUT EVEN THE IMPLIED WARRANTY OF
! MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. SEE THE GNU
! GENERAL PUBLIC LICENSE FOR MORE DETAILS.
!
! YOU SHOULD HAVE RECEIVED A COPY OF THE GNU GENERAL PUBLIC LICENSE
! ALONG WITH THIS PROGRAM; IF NOT, WRITE TO EDF R&D CODE_ASTER,
!    1 AVENUE DU GENERAL DE GAULLE, 92141 CLAMART CEDEX, FRANCE.
! ======================================================================
    implicit none
#include "asterfort/u2mesi.h"
    integer :: jjprem, nombre, iret
!     ==================================================================
    integer :: npre
!-----------------------------------------------------------------------
    integer :: iter
!-----------------------------------------------------------------------
    parameter      ( npre = 281 )
    integer :: jprem
    common /jpreje/  jprem(npre)
!     ==================================================================
    real(kind=8) :: prem(npre), fact, r8nomb
    save             prem
    parameter      ( fact = 1.3d0 )
    integer :: ipas, i, iprem, j, vali(2)
    integer :: npr1, npr2, npr3, npr4
    parameter      ( npr1 = 81, npr2 = 90, npr3 = 90, npr4 =  20)
    integer :: ipr1(npr1), ipr2(npr2), ipr3(npr3), ipr4(npr4)
!
    data ipas /   0 /
    data ipr1/   11,         17,         23,         37,         53,&
     &             71,         97,        127,        167,        223,&
     &            293,        383,        499,        547,        647,&
     &            757,        853,        941,       1031,       1109,&
     &           1223,       1327,       1447,       1549,       1657,&
     &           1759,       1889,       1987,       2459,       3203,&
     &           4177,       5431,       6121,       7069,       8111,&
     &           9199,      10271,      11959,      15551,      20219,&
     &          26293,      34183,      44449,      57787,      66179,&
     &          75133,      86113,      97673,     126989,     165089,&
     &         214631,     279029,     362741,     471571,     540703,&
     &         611957,    1000003,    1299827,    2015179,    5023309,&
     &        5800139,   10000019,   12500003,   15000017,   17500013,&
     &       20000003,   22500011,   25000009,   27500003,   30000001,&
     &       32500001,   35000011,   37500007,   40000003,   42500023,&
     &       45000017,   47500001,   50000017,   61500059,   70000027,&
     &       80000023/
    data ipr2/         85000103,   90000121,   95000123,  100000123,&
     &      105000121,  110000117,  115000099,  120000121,  125000089,&
     &      130000099,  135000101,  140000099,  145000117,  150000113,&
     &      155000107,  160000117,  165000119,  170000099,  175000109,&
     &      180000113,  185000119,  190000103,  195000119,  200000123,&
     &      205000079,  210000113,  215000117,  220000073,  225000107,&
     &      230000117,  235000123,  240000113,  245000101,  250000123,&
     &      255000113,  260000093,  265000117,  270000119,  275000113,&
     &      280000109,  285000119,  290000107,  295000103,  300000119,&
     &      305000123,  310000099,  315000121,  320000113,  325000121,&
     &      330000109,  335000123,  340000081,  345000107,  350000113,&
     &      355000073,  360000103,  365000113,  370000123,  375000121,&
     &      380000087,  385000123,  390000103,  395000119,  400000109,&
     &      405000053,  410000117,  415000097,  420000109,  425000101,&
     &      430000099,  435000107,  440000107,  445000123,  450000121,&
     &      455000123,  460000043,  465000079,  470000117,  475000067,&
     &      480000121,  485000041,  490000117,  495000113,  500000117,&
     &      505000123,  510000121,  515000089,  520000111,  525000107,&
     &      530000101/
    data ipr3/        535000121,  540000119,  545000101,  550000103,&
     &      555000109,  560000107,  565000109,  570000113,  575000123,&
     &      580000217,  585000223,  590000221,  595000199,  600000217,&
     &      605000191,  610000219,  615000209,  620000219,  625000171,&
     &      630000193,  635000213,  640000223,  645000199,  650000209,&
     &      655000211,  660000151,  665000213,  670000207,  675000217,&
     &      680000203,  685000223,  690000211,  695000161,  700000207,&
     &      705000203,  710000209,  715000219,  720000217,  725000191,&
     &      730000199,  735000223,  740000179,  745000211,  750000221,&
     &      755000143,  760000223,  765000199,  770000173,  775000211,&
     &      780000223,  785000221,  790000219,  795000197,  800000209,&
     &      805000223,  810000199,  815000201,  820000177,  825000217,&
     &      830000219,  835000223,  840000223,  845000209,  850000219,&
     &      855000221,  860000203,  865000219,  870000223,  875000197,&
     &      880000211,  885000223,  890000149,  895000217,  900000223,&
     &      905000189,  910000219,  915000223,  920000219,  925000217,&
     &      930000191,  935000177,  940000199,  945000211,  950000179,&
     &      955000213,  960000221,  965000173,  970000211,  975000211,&
     &      980000213/
    data ipr4/        985000207,  990000217,  995000221, 1000000223,&
     &     1005000223, 1010000207, 1015000211, 1020000217, 1025000191,&
     &     1030000211, 1035000221, 1040000201, 1045000219, 1050000199,&
     &     1055000183, 1060000217, 1065000187, 1070000221, 1300000003,&
     &     2147483647/
!
!    Nom du site www.prime-numbers.org
!
!
!     ------------------------------------------------------------------
    iter=0
    iret = 0
    if (fact * nombre .gt. ipr4(npr4)) then
        vali(1) = nint(ipr4(npr4)/fact)
        vali(2) = nombre
        call u2mesi('F', 'JEVEUX_39', 2, vali)
    endif
    if (ipas .eq. 0) then
        do 1 i = 1, npr1
            jprem(i) = ipr1(i)
            prem (i) = ipr1(i)
 1      continue
        do 2 i = 1, npr2
            jprem(npr1+i) = ipr2(i)
            prem (npr1+i) = ipr2(i)
 2      continue
        do 3 i = 1, npr3
            jprem(npr1+npr2+i) = ipr3(i)
            prem (npr1+npr2+i) = ipr3(i)
 3      continue
        do 4 i = 1, npr4
            jprem(npr1+npr2+npr3+i) = ipr4(i)
            prem (npr1+npr2+npr3+i) = ipr4(i)
 4      continue
        ipas = 1
    endif
!
    r8nomb = fact * nombre
!
    i = npre / 2
    j = i
 5  continue
    if (r8nomb .eq. prem(i)) then
        iprem = i
    else
        if (r8nomb .gt. prem(i)) then
            j = (j + 1) / 2
            i = min( i + j , npre)
        else
            j = (j + 1) / 2
            i = max(i - j,1)
        endif
        iter=iter+1
        if (j .gt. 1) goto 5
        iprem = i
        if (r8nomb .gt. prem(i)) then
            iprem = iprem + 1
        endif
    endif
    jjprem = jprem(iprem)
    if (iprem .eq. npre) iret = 1
!
end function
