/*
   birthday

   Birthday/Anniversary display on login

   (c) 1996 AS Mortimer

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  You may also
    distribute it under the Artistic License, as comes with Perl.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    You should also have recieved a copy of the Artistic license with
    this program.

   $Id: bdcal.c,v 1.4 2005/12/09 18:06:59 andymort Exp $ */

#include <time.h>
#include <string.h>

#include "birthday.h"

int iCLines  = 6;  /* lines-per-day in the calendar */
int iCWidth  = 80; /* width of calendar, in characters */
int iCWeeks  = 0;  /* weeks-per-page in the calendar, or 0 to supress page-breaks */
int iCTotal  = 28; /* total number of days to print the calendar for */

/* output the list in a calendar-style format */

void do_cal(struct event *evl, const struct date *today)
{
  unsigned i,j,k,lines, chars;
  char *buf = xmalloc(iCWidth+1);
  char *buf2 = xmalloc(iCWidth*3+1);
  struct tm btime;

  /* need the day-of-week info for whatever we're using as today */
  {
    time_t now;
    struct tm tmtoday;
    tmtoday.tm_sec = 0;
    tmtoday.tm_min = 0;
    tmtoday.tm_hour = 12; /* safely halfway through the day */
    tmtoday.tm_mday = today->day;
    tmtoday.tm_mon = today->month - 1;
    tmtoday.tm_year = today->year - 1900;
    now = mktime( &tmtoday );
    btime = *localtime( &now );
  }

  for (i=j=0; i < iCTotal; i++)
    {
      if (iCWeeks != 0 && i!=0 && (i%(iCWeeks*7))==0) printf("\x0c");
      strftime(buf, iCWidth+1, "---%A-%B-%d-%Y", &btime);
      for (k=0; buf[k]!=0; k++)
	if (buf[k]==' ') buf[k]='-';
      for (;k < iCWidth; k++) buf[k]='-';
      buf[iCWidth]=0;
      if (btime.tm_wday==0 || btime.tm_wday==6) /* weekend---make it bold */
	{
	  for (k=0; buf[k]!=0; k++)
	    {
	      buf2[k*3]=buf[k];
	      buf2[k*3+1]='\b';
	      buf2[k*3+2]=buf[k];
	    }
	  buf2[k*3]=0;
	  printf("%s\n", buf2);
	}
      else
	printf("%s\n", buf);
      
      lines=1;
      chars=0;
      /* assuming the events are ordered by date, this will process all the events for the current day, if any, and
	 leave j pointing to the first event which is not for today */
      for (; evl[j].text != NULL && delta(&(evl[j].date), today) <= i; j++)
	if (delta(&(evl[j].date), today) == i)
	  {
	    chars+=strlen(evl[j].text)+4;
	    if (chars > iCWidth)
	      {
		chars=strlen(evl[j].text);
		printf("\n");
		lines++;
	      }
	    printf("%s    ", evl[j].text);
	  }
      for (;lines < iCLines; lines++) printf("\n");

      /* increment d */
      btime.tm_mday++;
      btime.tm_wday=(++btime.tm_wday)%7;
      if(btime.tm_mday>mlen(btime.tm_mon+1, btime.tm_year))
	{
	  if (btime.tm_mon==11)
	    {
	      btime.tm_year++;
	      btime.tm_mon = 0;
	    }
	  else
	    btime.tm_mon++;
	  btime.tm_mday=1;
	}
    }
    free(buf);
    free(buf2);
}
