#include "Bdef.h"

void ctrpack00(uplo, diag, m, n, A, lda)
char  uplo;
char  diag;
int  m;
int  n;
SCOMPLEX  *A;
int  lda;
{
   int start, j;
   int maxrow, maxcol;
   int info;
   SCOMPLEX *tmpA;
   tmpA = A;

   j = pvm_initsend(PvmDataDefault);
   if ( (m < 1) || (n < 1) ) return;

   if (diag == 'u') start = 1;
   else start = 0;

   if (uplo == 'u')
   {
      if (m > n)
      {
         for (j=0; j < n; j++)  /* loop over columns */
         {
            maxrow = m - n + j + 1 - start;
            if (maxrow > 0)
            {
               info = pvm_pkcplx((float *) tmpA, maxrow, 1);
               Mpvmerror(info, "pvm_pkcplx", __LINE__, __FILE__);
            }
            tmpA += lda;
         }
      }
      else /* if (uplo == 'u' && m <= n) */
      {

      /* --------------------------------------------- */
      /* copy m x m upper-triangular portion of matrix */
      /* --------------------------------------------- */
         for (j=0; j < m; j++) /* do 1st m columns */
         {
            maxrow = j + 1 - start;
            if (maxrow > 0)
            {
               info = pvm_pkcplx((float *) tmpA, maxrow, 1);
               Mpvmerror(info, "pvm_pkcplx", __LINE__, __FILE__);
            }
            tmpA += lda;
         }
      /* -------------------------------------------- */
      /* copy m x (n-m) rectangular portion of matrix */
      /* -------------------------------------------- */
         maxcol = n - m;
         for (j=0; j < maxcol; j++) /* do last m-n columns */
         {
            info = pvm_pkcplx((float *) tmpA, m, 1);
            Mpvmerror(info, "pvm_pkcplx", __LINE__, __FILE__);
            tmpA += lda;
         }
      }
   }
   else /* if (uplo == 'l') */
   {
      if (m > n)
      {
         tmpA += start;
         for (j=0; j < n; j++)
         {
            maxrow = m - j - start;
            if (maxrow > 0)
            {
               info = pvm_pkcplx((float *) tmpA, maxrow, 1);
               Mpvmerror(info, "pvm_pkcplx", __LINE__, __FILE__);
            }
            tmpA += lda + 1;
         }
      }
      else /* if (uplo == 'l' && m <= n) */
      {

      /* -------------------------------- */
      /* copy m x (n-m) rectangular piece */
      /* -------------------------------- */
         maxcol = n - m;
         for (j=0; j < maxcol; j++)
         {
            info = pvm_pkcplx((float *) tmpA, m, 1);
            Mpvmerror(info, "pvm_pkcplx", __LINE__, __FILE__);
            tmpA += lda;
         }

      /* --------------------------------- */
      /* copy m x m lower triangular piece */
      /* --------------------------------- */
         tmpA += start;
         for (j=0; j < m; j++)
         {
            maxrow = m - j - start;
            if (maxrow > 0)
            {
               info = pvm_pkcplx((float *) tmpA, maxrow, 1);
               Mpvmerror(info, "pvm_pkcplx", __LINE__, __FILE__);
            }
            tmpA += lda + 1;
         }
      }
   }
}  /* end ctrpack00 */
