{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAlphaFactor: Single;
    procedure SetAlphaFactor(const Value: Single);
    function GetAlphaTextureId: Integer;
    procedure SetAlphaTextureId(const Value: Integer);
    function GetAlphaTextureCoordinatesId: Integer;
    procedure SetAlphaTextureCoordinatesId(const Value: Integer);
    function GetAlphaTextureChannelMask: String;
    procedure SetAlphaTextureChannelMask(const Value: String);
    function GetAlphaTexture: TAbstractTextureNode;
    procedure SetAlphaTexture(const Value: TAbstractTextureNode);
    function GetAmbientFactor: TVector3;
    procedure SetAmbientFactor(const Value: TVector3);
    function GetAmbientTextureId: Integer;
    procedure SetAmbientTextureId(const Value: Integer);
    function GetAmbientTextureCoordinatesId: Integer;
    procedure SetAmbientTextureCoordinatesId(const Value: Integer);
    function GetAmbientTextureChannelMask: String;
    procedure SetAmbientTextureChannelMask(const Value: String);
    function GetAmbientTexture: TAbstractTextureNode;
    procedure SetAmbientTexture(const Value: TAbstractTextureNode);
    function GetDiffuseFactor: TVector3;
    procedure SetDiffuseFactor(const Value: TVector3);
    function GetDiffuseTextureId: Integer;
    procedure SetDiffuseTextureId(const Value: Integer);
    function GetDiffuseTextureCoordinatesId: Integer;
    procedure SetDiffuseTextureCoordinatesId(const Value: Integer);
    function GetDiffuseTextureChannelMask: String;
    procedure SetDiffuseTextureChannelMask(const Value: String);
    function GetDiffuseTexture: TAbstractTextureNode;
    procedure SetDiffuseTexture(const Value: TAbstractTextureNode);
    function GetDiffuseDisplacementTexture: TAbstractTextureNode;
    procedure SetDiffuseDisplacementTexture(const Value: TAbstractTextureNode);
    function GetDisplacementAxis: String;
    procedure SetDisplacementAxis(const Value: String);
    function GetDisplacementFactor: Single;
    procedure SetDisplacementFactor(const Value: Single);
    function GetDisplacementTextureId: Integer;
    procedure SetDisplacementTextureId(const Value: Integer);
    function GetDisplacementTextureCoordinatesId: Integer;
    procedure SetDisplacementTextureCoordinatesId(const Value: Integer);
    function GetDisplacementTexture: TAbstractTextureNode;
    procedure SetDisplacementTexture(const Value: TAbstractTextureNode);
    function GetEmissiveFactor: TVector3;
    procedure SetEmissiveFactor(const Value: TVector3);
    function GetEmissiveTextureId: Integer;
    procedure SetEmissiveTextureId(const Value: Integer);
    function GetEmissiveTextureCoordinatesId: Integer;
    procedure SetEmissiveTextureCoordinatesId(const Value: Integer);
    function GetEmissiveTextureChannelMask: String;
    procedure SetEmissiveTextureChannelMask(const Value: String);
    function GetEmissiveTexture: TAbstractTextureNode;
    procedure SetEmissiveTexture(const Value: TAbstractTextureNode);
    function GetEnvironmentFactor: TVector3;
    procedure SetEnvironmentFactor(const Value: TVector3);
    function GetEnvironmentTextureId: Integer;
    procedure SetEnvironmentTextureId(const Value: Integer);
    function GetEnvironmentTextureCoordinatesId: Integer;
    procedure SetEnvironmentTextureCoordinatesId(const Value: Integer);
    function GetEnvironmentTextureChannelMask: String;
    procedure SetEnvironmentTextureChannelMask(const Value: String);
    function GetEnvironmentTexture: TAbstractEnvironmentTextureNode;
    procedure SetEnvironmentTexture(const Value: TAbstractEnvironmentTextureNode);
    function GetMultiDiffuseAlphaTexture: TAbstractTextureNode;
    procedure SetMultiDiffuseAlphaTexture(const Value: TAbstractTextureNode);
    function GetMultiEmmisiveAmbientIntensityTexture: TAbstractTextureNode;
    procedure SetMultiEmmisiveAmbientIntensityTexture(const Value: TAbstractTextureNode);
    function GetMultiSpecularShininessTexture: TAbstractTextureNode;
    procedure SetMultiSpecularShininessTexture(const Value: TAbstractTextureNode);
    function GetMultiVisibilityTexture: TAbstractTextureNode;
    procedure SetMultiVisibilityTexture(const Value: TAbstractTextureNode);
    function GetNormalFormat: String;
    procedure SetNormalFormat(const Value: String);
    function GetNormalSpace: String;
    procedure SetNormalSpace(const Value: String);
    function GetNormalTextureId: Integer;
    procedure SetNormalTextureId(const Value: Integer);
    function GetNormalTextureCoordinatesId: Integer;
    procedure SetNormalTextureCoordinatesId(const Value: Integer);
    function GetNormalTextureChannelMask: String;
    procedure SetNormalTextureChannelMask(const Value: String);
    function GetNormalScale: TVector3;
    procedure SetNormalScale(const Value: TVector3);
    function GetNormalBias: TVector3;
    procedure SetNormalBias(const Value: TVector3);
    function GetNormalTexture: TAbstractTextureNode;
    procedure SetNormalTexture(const Value: TAbstractTextureNode);
    function GetNormalTextureParallaxHeight: Single;
    procedure SetNormalTextureParallaxHeight(const Value: Single);
    function GetReflectionFactor: TVector3;
    procedure SetReflectionFactor(const Value: TVector3);
    function GetReflectionTextureId: Integer;
    procedure SetReflectionTextureId(const Value: Integer);
    function GetReflectionTextureCoordinatesId: Integer;
    procedure SetReflectionTextureCoordinatesId(const Value: Integer);
    function GetReflectionTextureChannelMask: String;
    procedure SetReflectionTextureChannelMask(const Value: String);
    function GetReflectionTexture: TAbstractTextureNode;
    procedure SetReflectionTexture(const Value: TAbstractTextureNode);
    function GetShininessFactor: Single;
    procedure SetShininessFactor(const Value: Single);
    function GetShininessTextureId: Integer;
    procedure SetShininessTextureId(const Value: Integer);
    function GetShininessTextureCoordinatesId: Integer;
    procedure SetShininessTextureCoordinatesId(const Value: Integer);
    function GetShininessTextureChannelMask: String;
    procedure SetShininessTextureChannelMask(const Value: String);
    function GetShininessTexture: TAbstractTextureNode;
    procedure SetShininessTexture(const Value: TAbstractTextureNode);
    function GetSpecularFactor: TVector3;
    procedure SetSpecularFactor(const Value: TVector3);
    function GetSpecularTextureId: Integer;
    procedure SetSpecularTextureId(const Value: Integer);
    function GetSpecularTextureCoordinatesId: Integer;
    procedure SetSpecularTextureCoordinatesId(const Value: Integer);
    function GetSpecularTextureChannelMask: String;
    procedure SetSpecularTextureChannelMask(const Value: String);
    function GetSpecularTexture: TAbstractTextureNode;
    procedure SetSpecularTexture(const Value: TAbstractTextureNode);
    function GetTransmissionFactor: TVector3;
    procedure SetTransmissionFactor(const Value: TVector3);
    function GetTransmissionTextureId: Integer;
    procedure SetTransmissionTextureId(const Value: Integer);
    function GetTransmissionTextureCoordinatesId: Integer;
    procedure SetTransmissionTextureCoordinatesId(const Value: Integer);
    function GetTransmissionTextureChannelMask: String;
    procedure SetTransmissionTextureChannelMask(const Value: String);
    function GetTransmissionTexture: TAbstractTextureNode;
    procedure SetTransmissionTexture(const Value: TAbstractTextureNode);
    function GetTangentTextureCoordinatesId: Integer;
    procedure SetTangentTextureCoordinatesId(const Value: Integer);
    function GetBinormalTextureCoordinatesId: Integer;
    procedure SetBinormalTextureCoordinatesId(const Value: Integer);
    function GetInvertAlphaTexture: Boolean;
    procedure SetInvertAlphaTexture(const Value: Boolean);
    function GetRelativeIndexOfRefraction: Single;
    procedure SetRelativeIndexOfRefraction(const Value: Single);
    function GetFresnelBlend: Single;
    procedure SetFresnelBlend(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAlphaFactor: TSFFloat;
    { Internal wrapper for property @code(AlphaFactor). This wrapper API may change, we advise to access simpler @code(AlphaFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAlphaFactor: TSFFloat read FFdAlphaFactor;
    {  }
    property AlphaFactor: Single read GetAlphaFactor write SetAlphaFactor;

    strict private FFdAlphaTextureId: TSFInt32;
    { Internal wrapper for property @code(AlphaTextureId). This wrapper API may change, we advise to access simpler @code(AlphaTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAlphaTextureId: TSFInt32 read FFdAlphaTextureId;
    {  }
    property AlphaTextureId: Integer read GetAlphaTextureId write SetAlphaTextureId;

    strict private FFdAlphaTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(AlphaTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(AlphaTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAlphaTextureCoordinatesId: TSFInt32 read FFdAlphaTextureCoordinatesId;
    {  }
    property AlphaTextureCoordinatesId: Integer read GetAlphaTextureCoordinatesId write SetAlphaTextureCoordinatesId;

    strict private FFdAlphaTextureChannelMask: TSFString;
    { Internal wrapper for property @code(AlphaTextureChannelMask). This wrapper API may change, we advise to access simpler @code(AlphaTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAlphaTextureChannelMask: TSFString read FFdAlphaTextureChannelMask;
    {  }
    property AlphaTextureChannelMask: String read GetAlphaTextureChannelMask write SetAlphaTextureChannelMask;

    strict private FFdAlphaTexture: TSFNode;
    { Internal wrapper for property @code(AlphaTexture). This wrapper API may change, we advise to access simpler @code(AlphaTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAlphaTexture: TSFNode read FFdAlphaTexture;
    {  }
    property AlphaTexture: TAbstractTextureNode read GetAlphaTexture write SetAlphaTexture;

    strict private FFdAmbientFactor: TSFVec3f;
    { Internal wrapper for property @code(AmbientFactor). This wrapper API may change, we advise to access simpler @code(AmbientFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAmbientFactor: TSFVec3f read FFdAmbientFactor;
    {  }
    property AmbientFactor: TVector3 read GetAmbientFactor write SetAmbientFactor;

    strict private FFdAmbientTextureId: TSFInt32;
    { Internal wrapper for property @code(AmbientTextureId). This wrapper API may change, we advise to access simpler @code(AmbientTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAmbientTextureId: TSFInt32 read FFdAmbientTextureId;
    {  }
    property AmbientTextureId: Integer read GetAmbientTextureId write SetAmbientTextureId;

    strict private FFdAmbientTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(AmbientTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(AmbientTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAmbientTextureCoordinatesId: TSFInt32 read FFdAmbientTextureCoordinatesId;
    {  }
    property AmbientTextureCoordinatesId: Integer read GetAmbientTextureCoordinatesId write SetAmbientTextureCoordinatesId;

    strict private FFdAmbientTextureChannelMask: TSFString;
    { Internal wrapper for property @code(AmbientTextureChannelMask). This wrapper API may change, we advise to access simpler @code(AmbientTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAmbientTextureChannelMask: TSFString read FFdAmbientTextureChannelMask;
    {  }
    property AmbientTextureChannelMask: String read GetAmbientTextureChannelMask write SetAmbientTextureChannelMask;

    strict private FFdAmbientTexture: TSFNode;
    { Internal wrapper for property @code(AmbientTexture). This wrapper API may change, we advise to access simpler @code(AmbientTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAmbientTexture: TSFNode read FFdAmbientTexture;
    {  }
    property AmbientTexture: TAbstractTextureNode read GetAmbientTexture write SetAmbientTexture;

    strict private FFdDiffuseFactor: TSFVec3f;
    { Internal wrapper for property @code(DiffuseFactor). This wrapper API may change, we advise to access simpler @code(DiffuseFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDiffuseFactor: TSFVec3f read FFdDiffuseFactor;
    {  }
    property DiffuseFactor: TVector3 read GetDiffuseFactor write SetDiffuseFactor;

    strict private FFdDiffuseTextureId: TSFInt32;
    { Internal wrapper for property @code(DiffuseTextureId). This wrapper API may change, we advise to access simpler @code(DiffuseTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDiffuseTextureId: TSFInt32 read FFdDiffuseTextureId;
    {  }
    property DiffuseTextureId: Integer read GetDiffuseTextureId write SetDiffuseTextureId;

    strict private FFdDiffuseTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(DiffuseTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(DiffuseTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDiffuseTextureCoordinatesId: TSFInt32 read FFdDiffuseTextureCoordinatesId;
    {  }
    property DiffuseTextureCoordinatesId: Integer read GetDiffuseTextureCoordinatesId write SetDiffuseTextureCoordinatesId;

    strict private FFdDiffuseTextureChannelMask: TSFString;
    { Internal wrapper for property @code(DiffuseTextureChannelMask). This wrapper API may change, we advise to access simpler @code(DiffuseTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDiffuseTextureChannelMask: TSFString read FFdDiffuseTextureChannelMask;
    {  }
    property DiffuseTextureChannelMask: String read GetDiffuseTextureChannelMask write SetDiffuseTextureChannelMask;

    strict private FFdDiffuseTexture: TSFNode;
    { Internal wrapper for property @code(DiffuseTexture). This wrapper API may change, we advise to access simpler @code(DiffuseTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDiffuseTexture: TSFNode read FFdDiffuseTexture;
    { The texture controlling the diffuse color, multiplied by @link(DiffuseFactor). }
    property DiffuseTexture: TAbstractTextureNode read GetDiffuseTexture write SetDiffuseTexture;

    strict private FFdDiffuseDisplacementTexture: TSFNode;
    { Internal wrapper for property @code(DiffuseDisplacementTexture). This wrapper API may change, we advise to access simpler @code(DiffuseDisplacementTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDiffuseDisplacementTexture: TSFNode read FFdDiffuseDisplacementTexture;
    {  }
    property DiffuseDisplacementTexture: TAbstractTextureNode read GetDiffuseDisplacementTexture write SetDiffuseDisplacementTexture;

    strict private FFdDisplacementAxis: TSFString;
    { Internal wrapper for property @code(DisplacementAxis). This wrapper API may change, we advise to access simpler @code(DisplacementAxis) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDisplacementAxis: TSFString read FFdDisplacementAxis;
    {  }
    property DisplacementAxis: String read GetDisplacementAxis write SetDisplacementAxis;

    strict private FFdDisplacementFactor: TSFFloat;
    { Internal wrapper for property @code(DisplacementFactor). This wrapper API may change, we advise to access simpler @code(DisplacementFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDisplacementFactor: TSFFloat read FFdDisplacementFactor;
    {  }
    property DisplacementFactor: Single read GetDisplacementFactor write SetDisplacementFactor;

    strict private FFdDisplacementTextureId: TSFInt32;
    { Internal wrapper for property @code(DisplacementTextureId). This wrapper API may change, we advise to access simpler @code(DisplacementTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDisplacementTextureId: TSFInt32 read FFdDisplacementTextureId;
    {  }
    property DisplacementTextureId: Integer read GetDisplacementTextureId write SetDisplacementTextureId;

    strict private FFdDisplacementTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(DisplacementTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(DisplacementTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDisplacementTextureCoordinatesId: TSFInt32 read FFdDisplacementTextureCoordinatesId;
    {  }
    property DisplacementTextureCoordinatesId: Integer read GetDisplacementTextureCoordinatesId write SetDisplacementTextureCoordinatesId;

    strict private FFdDisplacementTexture: TSFNode;
    { Internal wrapper for property @code(DisplacementTexture). This wrapper API may change, we advise to access simpler @code(DisplacementTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdDisplacementTexture: TSFNode read FFdDisplacementTexture;
    {  }
    property DisplacementTexture: TAbstractTextureNode read GetDisplacementTexture write SetDisplacementTexture;

    strict private FFdEmissiveFactor: TSFVec3f;
    { Internal wrapper for property @code(EmissiveFactor). This wrapper API may change, we advise to access simpler @code(EmissiveFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEmissiveFactor: TSFVec3f read FFdEmissiveFactor;
    {  }
    property EmissiveFactor: TVector3 read GetEmissiveFactor write SetEmissiveFactor;

    strict private FFdEmissiveTextureId: TSFInt32;
    { Internal wrapper for property @code(EmissiveTextureId). This wrapper API may change, we advise to access simpler @code(EmissiveTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEmissiveTextureId: TSFInt32 read FFdEmissiveTextureId;
    {  }
    property EmissiveTextureId: Integer read GetEmissiveTextureId write SetEmissiveTextureId;

    strict private FFdEmissiveTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(EmissiveTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(EmissiveTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEmissiveTextureCoordinatesId: TSFInt32 read FFdEmissiveTextureCoordinatesId;
    {  }
    property EmissiveTextureCoordinatesId: Integer read GetEmissiveTextureCoordinatesId write SetEmissiveTextureCoordinatesId;

    strict private FFdEmissiveTextureChannelMask: TSFString;
    { Internal wrapper for property @code(EmissiveTextureChannelMask). This wrapper API may change, we advise to access simpler @code(EmissiveTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEmissiveTextureChannelMask: TSFString read FFdEmissiveTextureChannelMask;
    {  }
    property EmissiveTextureChannelMask: String read GetEmissiveTextureChannelMask write SetEmissiveTextureChannelMask;

    strict private FFdEmissiveTexture: TSFNode;
    { Internal wrapper for property @code(EmissiveTexture). This wrapper API may change, we advise to access simpler @code(EmissiveTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEmissiveTexture: TSFNode read FFdEmissiveTexture;
    {  }
    property EmissiveTexture: TAbstractTextureNode read GetEmissiveTexture write SetEmissiveTexture;

    strict private FFdEnvironmentFactor: TSFVec3f;
    { Internal wrapper for property @code(EnvironmentFactor). This wrapper API may change, we advise to access simpler @code(EnvironmentFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnvironmentFactor: TSFVec3f read FFdEnvironmentFactor;
    {  }
    property EnvironmentFactor: TVector3 read GetEnvironmentFactor write SetEnvironmentFactor;

    strict private FFdEnvironmentTextureId: TSFInt32;
    { Internal wrapper for property @code(EnvironmentTextureId). This wrapper API may change, we advise to access simpler @code(EnvironmentTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnvironmentTextureId: TSFInt32 read FFdEnvironmentTextureId;
    {  }
    property EnvironmentTextureId: Integer read GetEnvironmentTextureId write SetEnvironmentTextureId;

    strict private FFdEnvironmentTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(EnvironmentTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(EnvironmentTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnvironmentTextureCoordinatesId: TSFInt32 read FFdEnvironmentTextureCoordinatesId;
    {  }
    property EnvironmentTextureCoordinatesId: Integer read GetEnvironmentTextureCoordinatesId write SetEnvironmentTextureCoordinatesId;

    strict private FFdEnvironmentTextureChannelMask: TSFString;
    { Internal wrapper for property @code(EnvironmentTextureChannelMask). This wrapper API may change, we advise to access simpler @code(EnvironmentTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnvironmentTextureChannelMask: TSFString read FFdEnvironmentTextureChannelMask;
    {  }
    property EnvironmentTextureChannelMask: String read GetEnvironmentTextureChannelMask write SetEnvironmentTextureChannelMask;

    strict private FFdEnvironmentTexture: TSFNode;
    { Internal wrapper for property @code(EnvironmentTexture). This wrapper API may change, we advise to access simpler @code(EnvironmentTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnvironmentTexture: TSFNode read FFdEnvironmentTexture;
    {  }
    property EnvironmentTexture: TAbstractEnvironmentTextureNode read GetEnvironmentTexture write SetEnvironmentTexture;

    strict private FFdMultiDiffuseAlphaTexture: TSFNode;
    { Internal wrapper for property @code(MultiDiffuseAlphaTexture). This wrapper API may change, we advise to access simpler @code(MultiDiffuseAlphaTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMultiDiffuseAlphaTexture: TSFNode read FFdMultiDiffuseAlphaTexture;
    { The texture controlling the diffuse (rgb) and alpha (alpha channel). Diffuse color is multiplied by @link(DiffuseFactor), alpha is (or rather: should be) multiplied by @link(AlphaFactor). }
    property MultiDiffuseAlphaTexture: TAbstractTextureNode read GetMultiDiffuseAlphaTexture write SetMultiDiffuseAlphaTexture;

    strict private FFdMultiEmmisiveAmbientIntensityTexture: TSFNode;
    { Internal wrapper for property @code(MultiEmmisiveAmbientIntensityTexture). This wrapper API may change, we advise to access simpler @code(MultiEmmisiveAmbientIntensityTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMultiEmmisiveAmbientIntensityTexture: TSFNode read FFdMultiEmmisiveAmbientIntensityTexture;
    {  }
    property MultiEmmisiveAmbientIntensityTexture: TAbstractTextureNode read GetMultiEmmisiveAmbientIntensityTexture write SetMultiEmmisiveAmbientIntensityTexture;

    strict private FFdMultiSpecularShininessTexture: TSFNode;
    { Internal wrapper for property @code(MultiSpecularShininessTexture). This wrapper API may change, we advise to access simpler @code(MultiSpecularShininessTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMultiSpecularShininessTexture: TSFNode read FFdMultiSpecularShininessTexture;
    {  }
    property MultiSpecularShininessTexture: TAbstractTextureNode read GetMultiSpecularShininessTexture write SetMultiSpecularShininessTexture;

    strict private FFdMultiVisibilityTexture: TSFNode;
    { Internal wrapper for property @code(MultiVisibilityTexture). This wrapper API may change, we advise to access simpler @code(MultiVisibilityTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMultiVisibilityTexture: TSFNode read FFdMultiVisibilityTexture;
    {  }
    property MultiVisibilityTexture: TAbstractTextureNode read GetMultiVisibilityTexture write SetMultiVisibilityTexture;

    strict private FFdNormalFormat: TSFString;
    { Internal wrapper for property @code(NormalFormat). This wrapper API may change, we advise to access simpler @code(NormalFormat) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalFormat: TSFString read FFdNormalFormat;
    {  }
    property NormalFormat: String read GetNormalFormat write SetNormalFormat;

    strict private FFdNormalSpace: TSFString;
    { Internal wrapper for property @code(NormalSpace). This wrapper API may change, we advise to access simpler @code(NormalSpace) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalSpace: TSFString read FFdNormalSpace;
    {  }
    property NormalSpace: String read GetNormalSpace write SetNormalSpace;

    strict private FFdNormalTextureId: TSFInt32;
    { Internal wrapper for property @code(NormalTextureId). This wrapper API may change, we advise to access simpler @code(NormalTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalTextureId: TSFInt32 read FFdNormalTextureId;
    {  }
    property NormalTextureId: Integer read GetNormalTextureId write SetNormalTextureId;

    strict private FFdNormalTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(NormalTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(NormalTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalTextureCoordinatesId: TSFInt32 read FFdNormalTextureCoordinatesId;
    {  }
    property NormalTextureCoordinatesId: Integer read GetNormalTextureCoordinatesId write SetNormalTextureCoordinatesId;

    strict private FFdNormalTextureChannelMask: TSFString;
    { Internal wrapper for property @code(NormalTextureChannelMask). This wrapper API may change, we advise to access simpler @code(NormalTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalTextureChannelMask: TSFString read FFdNormalTextureChannelMask;
    {  }
    property NormalTextureChannelMask: String read GetNormalTextureChannelMask write SetNormalTextureChannelMask;

    strict private FFdNormalScale: TSFVec3f;
    { Internal wrapper for property @code(NormalScale). This wrapper API may change, we advise to access simpler @code(NormalScale) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalScale: TSFVec3f read FFdNormalScale;
    {  }
    property NormalScale: TVector3 read GetNormalScale write SetNormalScale;

    strict private FFdNormalBias: TSFVec3f;
    { Internal wrapper for property @code(NormalBias). This wrapper API may change, we advise to access simpler @code(NormalBias) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalBias: TSFVec3f read FFdNormalBias;
    {  }
    property NormalBias: TVector3 read GetNormalBias write SetNormalBias;

    strict private FFdNormalTexture: TSFNode;
    { Internal wrapper for property @code(NormalTexture). This wrapper API may change, we advise to access simpler @code(NormalTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalTexture: TSFNode read FFdNormalTexture;
    { Normalmap for bump mapping (the texture controlling the normals). }
    property NormalTexture: TAbstractTextureNode read GetNormalTexture write SetNormalTexture;

    strict private FFdNormalTextureParallaxHeight: TSFFloat;
    { Internal wrapper for property @code(NormalTextureParallaxHeight). This wrapper API may change, we advise to access simpler @code(NormalTextureParallaxHeight) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdNormalTextureParallaxHeight: TSFFloat read FFdNormalTextureParallaxHeight;
    {  }
    property NormalTextureParallaxHeight: Single read GetNormalTextureParallaxHeight write SetNormalTextureParallaxHeight;

    strict private FFdReflectionFactor: TSFVec3f;
    { Internal wrapper for property @code(ReflectionFactor). This wrapper API may change, we advise to access simpler @code(ReflectionFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdReflectionFactor: TSFVec3f read FFdReflectionFactor;
    {  }
    property ReflectionFactor: TVector3 read GetReflectionFactor write SetReflectionFactor;

    strict private FFdReflectionTextureId: TSFInt32;
    { Internal wrapper for property @code(ReflectionTextureId). This wrapper API may change, we advise to access simpler @code(ReflectionTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdReflectionTextureId: TSFInt32 read FFdReflectionTextureId;
    {  }
    property ReflectionTextureId: Integer read GetReflectionTextureId write SetReflectionTextureId;

    strict private FFdReflectionTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(ReflectionTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(ReflectionTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdReflectionTextureCoordinatesId: TSFInt32 read FFdReflectionTextureCoordinatesId;
    {  }
    property ReflectionTextureCoordinatesId: Integer read GetReflectionTextureCoordinatesId write SetReflectionTextureCoordinatesId;

    strict private FFdReflectionTextureChannelMask: TSFString;
    { Internal wrapper for property @code(ReflectionTextureChannelMask). This wrapper API may change, we advise to access simpler @code(ReflectionTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdReflectionTextureChannelMask: TSFString read FFdReflectionTextureChannelMask;
    {  }
    property ReflectionTextureChannelMask: String read GetReflectionTextureChannelMask write SetReflectionTextureChannelMask;

    strict private FFdReflectionTexture: TSFNode;
    { Internal wrapper for property @code(ReflectionTexture). This wrapper API may change, we advise to access simpler @code(ReflectionTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdReflectionTexture: TSFNode read FFdReflectionTexture;
    {  }
    property ReflectionTexture: TAbstractTextureNode read GetReflectionTexture write SetReflectionTexture;

    strict private FFdShininessFactor: TSFFloat;
    { Internal wrapper for property @code(ShininessFactor). This wrapper API may change, we advise to access simpler @code(ShininessFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShininessFactor: TSFFloat read FFdShininessFactor;
    {  }
    property ShininessFactor: Single read GetShininessFactor write SetShininessFactor;

    strict private FFdShininessTextureId: TSFInt32;
    { Internal wrapper for property @code(ShininessTextureId). This wrapper API may change, we advise to access simpler @code(ShininessTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShininessTextureId: TSFInt32 read FFdShininessTextureId;
    {  }
    property ShininessTextureId: Integer read GetShininessTextureId write SetShininessTextureId;

    strict private FFdShininessTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(ShininessTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(ShininessTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShininessTextureCoordinatesId: TSFInt32 read FFdShininessTextureCoordinatesId;
    {  }
    property ShininessTextureCoordinatesId: Integer read GetShininessTextureCoordinatesId write SetShininessTextureCoordinatesId;

    strict private FFdShininessTextureChannelMask: TSFString;
    { Internal wrapper for property @code(ShininessTextureChannelMask). This wrapper API may change, we advise to access simpler @code(ShininessTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShininessTextureChannelMask: TSFString read FFdShininessTextureChannelMask;
    {  }
    property ShininessTextureChannelMask: String read GetShininessTextureChannelMask write SetShininessTextureChannelMask;

    strict private FFdShininessTexture: TSFNode;
    { Internal wrapper for property @code(ShininessTexture). This wrapper API may change, we advise to access simpler @code(ShininessTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShininessTexture: TSFNode read FFdShininessTexture;
    {  }
    property ShininessTexture: TAbstractTextureNode read GetShininessTexture write SetShininessTexture;

    strict private FFdSpecularFactor: TSFVec3f;
    { Internal wrapper for property @code(SpecularFactor). This wrapper API may change, we advise to access simpler @code(SpecularFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSpecularFactor: TSFVec3f read FFdSpecularFactor;
    {  }
    property SpecularFactor: TVector3 read GetSpecularFactor write SetSpecularFactor;

    strict private FFdSpecularTextureId: TSFInt32;
    { Internal wrapper for property @code(SpecularTextureId). This wrapper API may change, we advise to access simpler @code(SpecularTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSpecularTextureId: TSFInt32 read FFdSpecularTextureId;
    {  }
    property SpecularTextureId: Integer read GetSpecularTextureId write SetSpecularTextureId;

    strict private FFdSpecularTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(SpecularTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(SpecularTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSpecularTextureCoordinatesId: TSFInt32 read FFdSpecularTextureCoordinatesId;
    {  }
    property SpecularTextureCoordinatesId: Integer read GetSpecularTextureCoordinatesId write SetSpecularTextureCoordinatesId;

    strict private FFdSpecularTextureChannelMask: TSFString;
    { Internal wrapper for property @code(SpecularTextureChannelMask). This wrapper API may change, we advise to access simpler @code(SpecularTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSpecularTextureChannelMask: TSFString read FFdSpecularTextureChannelMask;
    {  }
    property SpecularTextureChannelMask: String read GetSpecularTextureChannelMask write SetSpecularTextureChannelMask;

    strict private FFdSpecularTexture: TSFNode;
    { Internal wrapper for property @code(SpecularTexture). This wrapper API may change, we advise to access simpler @code(SpecularTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSpecularTexture: TSFNode read FFdSpecularTexture;
    {  }
    property SpecularTexture: TAbstractTextureNode read GetSpecularTexture write SetSpecularTexture;

    strict private FFdTransmissionFactor: TSFVec3f;
    { Internal wrapper for property @code(TransmissionFactor). This wrapper API may change, we advise to access simpler @code(TransmissionFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransmissionFactor: TSFVec3f read FFdTransmissionFactor;
    {  }
    property TransmissionFactor: TVector3 read GetTransmissionFactor write SetTransmissionFactor;

    strict private FFdTransmissionTextureId: TSFInt32;
    { Internal wrapper for property @code(TransmissionTextureId). This wrapper API may change, we advise to access simpler @code(TransmissionTextureId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransmissionTextureId: TSFInt32 read FFdTransmissionTextureId;
    {  }
    property TransmissionTextureId: Integer read GetTransmissionTextureId write SetTransmissionTextureId;

    strict private FFdTransmissionTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(TransmissionTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(TransmissionTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransmissionTextureCoordinatesId: TSFInt32 read FFdTransmissionTextureCoordinatesId;
    {  }
    property TransmissionTextureCoordinatesId: Integer read GetTransmissionTextureCoordinatesId write SetTransmissionTextureCoordinatesId;

    strict private FFdTransmissionTextureChannelMask: TSFString;
    { Internal wrapper for property @code(TransmissionTextureChannelMask). This wrapper API may change, we advise to access simpler @code(TransmissionTextureChannelMask) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransmissionTextureChannelMask: TSFString read FFdTransmissionTextureChannelMask;
    {  }
    property TransmissionTextureChannelMask: String read GetTransmissionTextureChannelMask write SetTransmissionTextureChannelMask;

    strict private FFdTransmissionTexture: TSFNode;
    { Internal wrapper for property @code(TransmissionTexture). This wrapper API may change, we advise to access simpler @code(TransmissionTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTransmissionTexture: TSFNode read FFdTransmissionTexture;
    {  }
    property TransmissionTexture: TAbstractTextureNode read GetTransmissionTexture write SetTransmissionTexture;

    strict private FFdTangentTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(TangentTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(TangentTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTangentTextureCoordinatesId: TSFInt32 read FFdTangentTextureCoordinatesId;
    {  }
    property TangentTextureCoordinatesId: Integer read GetTangentTextureCoordinatesId write SetTangentTextureCoordinatesId;

    strict private FFdBinormalTextureCoordinatesId: TSFInt32;
    { Internal wrapper for property @code(BinormalTextureCoordinatesId). This wrapper API may change, we advise to access simpler @code(BinormalTextureCoordinatesId) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBinormalTextureCoordinatesId: TSFInt32 read FFdBinormalTextureCoordinatesId;
    {  }
    property BinormalTextureCoordinatesId: Integer read GetBinormalTextureCoordinatesId write SetBinormalTextureCoordinatesId;

    strict private FFdInvertAlphaTexture: TSFBool;
    { Internal wrapper for property @code(InvertAlphaTexture). This wrapper API may change, we advise to access simpler @code(InvertAlphaTexture) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdInvertAlphaTexture: TSFBool read FFdInvertAlphaTexture;
    {  }
    property InvertAlphaTexture: Boolean read GetInvertAlphaTexture write SetInvertAlphaTexture;

    strict private FFdRelativeIndexOfRefraction: TSFFloat;
    { Internal wrapper for property @code(RelativeIndexOfRefraction). This wrapper API may change, we advise to access simpler @code(RelativeIndexOfRefraction) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRelativeIndexOfRefraction: TSFFloat read FFdRelativeIndexOfRefraction;
    {  }
    property RelativeIndexOfRefraction: Single read GetRelativeIndexOfRefraction write SetRelativeIndexOfRefraction;

    strict private FFdFresnelBlend: TSFFloat;
    { Internal wrapper for property @code(FresnelBlend). This wrapper API may change, we advise to access simpler @code(FresnelBlend) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFresnelBlend: TSFFloat read FFdFresnelBlend;
    {  }
    property FresnelBlend: Single read GetFresnelBlend write SetFresnelBlend;

    strict private FFdTextureTransformEnabled: TMFBool;
    { Internal wrapper for property @code(TextureTransformEnabled). This wrapper API may change, we advise to access simpler @code(TextureTransformEnabled) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTextureTransformEnabled: TMFBool read FFdTextureTransformEnabled;
    {  }
    procedure SetTextureTransformEnabled(const Value: array of boolean); overload;
    {  }
    procedure SetTextureTransformEnabled(const Value: TBooleanList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TCommonSurfaceShaderNode ----------------------------------------------- }

function TCommonSurfaceShaderNode.GetAlphaFactor: Single;
begin
  Result := FdAlphaFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetAlphaFactor(const Value: Single);
begin
  FdAlphaFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetAlphaTextureId: Integer;
begin
  Result := FdAlphaTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetAlphaTextureId(const Value: Integer);
begin
  FdAlphaTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetAlphaTextureCoordinatesId: Integer;
begin
  Result := FdAlphaTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetAlphaTextureCoordinatesId(const Value: Integer);
begin
  FdAlphaTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetAlphaTextureChannelMask: String;
begin
  Result := FdAlphaTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetAlphaTextureChannelMask(const Value: String);
begin
  FdAlphaTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetAlphaTexture: TAbstractTextureNode;
begin
  if FdAlphaTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdAlphaTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetAlphaTexture(const Value: TAbstractTextureNode);
begin
  FdAlphaTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetAmbientFactor: TVector3;
begin
  Result := FdAmbientFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetAmbientFactor(const Value: TVector3);
begin
  FdAmbientFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetAmbientTextureId: Integer;
begin
  Result := FdAmbientTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetAmbientTextureId(const Value: Integer);
begin
  FdAmbientTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetAmbientTextureCoordinatesId: Integer;
begin
  Result := FdAmbientTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetAmbientTextureCoordinatesId(const Value: Integer);
begin
  FdAmbientTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetAmbientTextureChannelMask: String;
begin
  Result := FdAmbientTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetAmbientTextureChannelMask(const Value: String);
begin
  FdAmbientTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetAmbientTexture: TAbstractTextureNode;
begin
  if FdAmbientTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdAmbientTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetAmbientTexture(const Value: TAbstractTextureNode);
begin
  FdAmbientTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDiffuseFactor: TVector3;
begin
  Result := FdDiffuseFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetDiffuseFactor(const Value: TVector3);
begin
  FdDiffuseFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDiffuseTextureId: Integer;
begin
  Result := FdDiffuseTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetDiffuseTextureId(const Value: Integer);
begin
  FdDiffuseTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDiffuseTextureCoordinatesId: Integer;
begin
  Result := FdDiffuseTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetDiffuseTextureCoordinatesId(const Value: Integer);
begin
  FdDiffuseTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDiffuseTextureChannelMask: String;
begin
  Result := FdDiffuseTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetDiffuseTextureChannelMask(const Value: String);
begin
  FdDiffuseTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDiffuseTexture: TAbstractTextureNode;
begin
  if FdDiffuseTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdDiffuseTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetDiffuseTexture(const Value: TAbstractTextureNode);
begin
  FdDiffuseTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDiffuseDisplacementTexture: TAbstractTextureNode;
begin
  if FdDiffuseDisplacementTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdDiffuseDisplacementTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetDiffuseDisplacementTexture(const Value: TAbstractTextureNode);
begin
  FdDiffuseDisplacementTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDisplacementAxis: String;
begin
  Result := FdDisplacementAxis.Value;
end;

procedure TCommonSurfaceShaderNode.SetDisplacementAxis(const Value: String);
begin
  FdDisplacementAxis.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDisplacementFactor: Single;
begin
  Result := FdDisplacementFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetDisplacementFactor(const Value: Single);
begin
  FdDisplacementFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDisplacementTextureId: Integer;
begin
  Result := FdDisplacementTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetDisplacementTextureId(const Value: Integer);
begin
  FdDisplacementTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDisplacementTextureCoordinatesId: Integer;
begin
  Result := FdDisplacementTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetDisplacementTextureCoordinatesId(const Value: Integer);
begin
  FdDisplacementTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetDisplacementTexture: TAbstractTextureNode;
begin
  if FdDisplacementTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdDisplacementTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetDisplacementTexture(const Value: TAbstractTextureNode);
begin
  FdDisplacementTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEmissiveFactor: TVector3;
begin
  Result := FdEmissiveFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetEmissiveFactor(const Value: TVector3);
begin
  FdEmissiveFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEmissiveTextureId: Integer;
begin
  Result := FdEmissiveTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetEmissiveTextureId(const Value: Integer);
begin
  FdEmissiveTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEmissiveTextureCoordinatesId: Integer;
begin
  Result := FdEmissiveTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetEmissiveTextureCoordinatesId(const Value: Integer);
begin
  FdEmissiveTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEmissiveTextureChannelMask: String;
begin
  Result := FdEmissiveTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetEmissiveTextureChannelMask(const Value: String);
begin
  FdEmissiveTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEmissiveTexture: TAbstractTextureNode;
begin
  if FdEmissiveTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdEmissiveTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetEmissiveTexture(const Value: TAbstractTextureNode);
begin
  FdEmissiveTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEnvironmentFactor: TVector3;
begin
  Result := FdEnvironmentFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetEnvironmentFactor(const Value: TVector3);
begin
  FdEnvironmentFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEnvironmentTextureId: Integer;
begin
  Result := FdEnvironmentTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetEnvironmentTextureId(const Value: Integer);
begin
  FdEnvironmentTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEnvironmentTextureCoordinatesId: Integer;
begin
  Result := FdEnvironmentTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetEnvironmentTextureCoordinatesId(const Value: Integer);
begin
  FdEnvironmentTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEnvironmentTextureChannelMask: String;
begin
  Result := FdEnvironmentTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetEnvironmentTextureChannelMask(const Value: String);
begin
  FdEnvironmentTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetEnvironmentTexture: TAbstractEnvironmentTextureNode;
begin
  if FdEnvironmentTexture.Value is TAbstractEnvironmentTextureNode then
    Result := TAbstractEnvironmentTextureNode(FdEnvironmentTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetEnvironmentTexture(const Value: TAbstractEnvironmentTextureNode);
begin
  FdEnvironmentTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetMultiDiffuseAlphaTexture: TAbstractTextureNode;
begin
  if FdMultiDiffuseAlphaTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdMultiDiffuseAlphaTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetMultiDiffuseAlphaTexture(const Value: TAbstractTextureNode);
begin
  FdMultiDiffuseAlphaTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetMultiEmmisiveAmbientIntensityTexture: TAbstractTextureNode;
begin
  if FdMultiEmmisiveAmbientIntensityTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdMultiEmmisiveAmbientIntensityTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetMultiEmmisiveAmbientIntensityTexture(const Value: TAbstractTextureNode);
begin
  FdMultiEmmisiveAmbientIntensityTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetMultiSpecularShininessTexture: TAbstractTextureNode;
begin
  if FdMultiSpecularShininessTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdMultiSpecularShininessTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetMultiSpecularShininessTexture(const Value: TAbstractTextureNode);
begin
  FdMultiSpecularShininessTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetMultiVisibilityTexture: TAbstractTextureNode;
begin
  if FdMultiVisibilityTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdMultiVisibilityTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetMultiVisibilityTexture(const Value: TAbstractTextureNode);
begin
  FdMultiVisibilityTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetNormalFormat: String;
begin
  Result := FdNormalFormat.Value;
end;

procedure TCommonSurfaceShaderNode.SetNormalFormat(const Value: String);
begin
  FdNormalFormat.Send(Value);
end;

function TCommonSurfaceShaderNode.GetNormalSpace: String;
begin
  Result := FdNormalSpace.Value;
end;

procedure TCommonSurfaceShaderNode.SetNormalSpace(const Value: String);
begin
  FdNormalSpace.Send(Value);
end;

function TCommonSurfaceShaderNode.GetNormalTextureId: Integer;
begin
  Result := FdNormalTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetNormalTextureId(const Value: Integer);
begin
  FdNormalTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetNormalTextureCoordinatesId: Integer;
begin
  Result := FdNormalTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetNormalTextureCoordinatesId(const Value: Integer);
begin
  FdNormalTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetNormalTextureChannelMask: String;
begin
  Result := FdNormalTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetNormalTextureChannelMask(const Value: String);
begin
  FdNormalTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetNormalScale: TVector3;
begin
  Result := FdNormalScale.Value;
end;

procedure TCommonSurfaceShaderNode.SetNormalScale(const Value: TVector3);
begin
  FdNormalScale.Send(Value);
end;

function TCommonSurfaceShaderNode.GetNormalBias: TVector3;
begin
  Result := FdNormalBias.Value;
end;

procedure TCommonSurfaceShaderNode.SetNormalBias(const Value: TVector3);
begin
  FdNormalBias.Send(Value);
end;

function TCommonSurfaceShaderNode.GetNormalTexture: TAbstractTextureNode;
begin
  if FdNormalTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdNormalTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetNormalTexture(const Value: TAbstractTextureNode);
begin
  FdNormalTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetNormalTextureParallaxHeight: Single;
begin
  Result := FdNormalTextureParallaxHeight.Value;
end;

procedure TCommonSurfaceShaderNode.SetNormalTextureParallaxHeight(const Value: Single);
begin
  FdNormalTextureParallaxHeight.Send(Value);
end;

function TCommonSurfaceShaderNode.GetReflectionFactor: TVector3;
begin
  Result := FdReflectionFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetReflectionFactor(const Value: TVector3);
begin
  FdReflectionFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetReflectionTextureId: Integer;
begin
  Result := FdReflectionTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetReflectionTextureId(const Value: Integer);
begin
  FdReflectionTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetReflectionTextureCoordinatesId: Integer;
begin
  Result := FdReflectionTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetReflectionTextureCoordinatesId(const Value: Integer);
begin
  FdReflectionTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetReflectionTextureChannelMask: String;
begin
  Result := FdReflectionTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetReflectionTextureChannelMask(const Value: String);
begin
  FdReflectionTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetReflectionTexture: TAbstractTextureNode;
begin
  if FdReflectionTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdReflectionTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetReflectionTexture(const Value: TAbstractTextureNode);
begin
  FdReflectionTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetShininessFactor: Single;
begin
  Result := FdShininessFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetShininessFactor(const Value: Single);
begin
  FdShininessFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetShininessTextureId: Integer;
begin
  Result := FdShininessTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetShininessTextureId(const Value: Integer);
begin
  FdShininessTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetShininessTextureCoordinatesId: Integer;
begin
  Result := FdShininessTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetShininessTextureCoordinatesId(const Value: Integer);
begin
  FdShininessTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetShininessTextureChannelMask: String;
begin
  Result := FdShininessTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetShininessTextureChannelMask(const Value: String);
begin
  FdShininessTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetShininessTexture: TAbstractTextureNode;
begin
  if FdShininessTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdShininessTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetShininessTexture(const Value: TAbstractTextureNode);
begin
  FdShininessTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetSpecularFactor: TVector3;
begin
  Result := FdSpecularFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetSpecularFactor(const Value: TVector3);
begin
  FdSpecularFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetSpecularTextureId: Integer;
begin
  Result := FdSpecularTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetSpecularTextureId(const Value: Integer);
begin
  FdSpecularTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetSpecularTextureCoordinatesId: Integer;
begin
  Result := FdSpecularTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetSpecularTextureCoordinatesId(const Value: Integer);
begin
  FdSpecularTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetSpecularTextureChannelMask: String;
begin
  Result := FdSpecularTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetSpecularTextureChannelMask(const Value: String);
begin
  FdSpecularTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetSpecularTexture: TAbstractTextureNode;
begin
  if FdSpecularTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdSpecularTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetSpecularTexture(const Value: TAbstractTextureNode);
begin
  FdSpecularTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetTransmissionFactor: TVector3;
begin
  Result := FdTransmissionFactor.Value;
end;

procedure TCommonSurfaceShaderNode.SetTransmissionFactor(const Value: TVector3);
begin
  FdTransmissionFactor.Send(Value);
end;

function TCommonSurfaceShaderNode.GetTransmissionTextureId: Integer;
begin
  Result := FdTransmissionTextureId.Value;
end;

procedure TCommonSurfaceShaderNode.SetTransmissionTextureId(const Value: Integer);
begin
  FdTransmissionTextureId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetTransmissionTextureCoordinatesId: Integer;
begin
  Result := FdTransmissionTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetTransmissionTextureCoordinatesId(const Value: Integer);
begin
  FdTransmissionTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetTransmissionTextureChannelMask: String;
begin
  Result := FdTransmissionTextureChannelMask.Value;
end;

procedure TCommonSurfaceShaderNode.SetTransmissionTextureChannelMask(const Value: String);
begin
  FdTransmissionTextureChannelMask.Send(Value);
end;

function TCommonSurfaceShaderNode.GetTransmissionTexture: TAbstractTextureNode;
begin
  if FdTransmissionTexture.Value is TAbstractTextureNode then
    Result := TAbstractTextureNode(FdTransmissionTexture.Value)
  else
    Result := nil;
end;

procedure TCommonSurfaceShaderNode.SetTransmissionTexture(const Value: TAbstractTextureNode);
begin
  FdTransmissionTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetTangentTextureCoordinatesId: Integer;
begin
  Result := FdTangentTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetTangentTextureCoordinatesId(const Value: Integer);
begin
  FdTangentTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetBinormalTextureCoordinatesId: Integer;
begin
  Result := FdBinormalTextureCoordinatesId.Value;
end;

procedure TCommonSurfaceShaderNode.SetBinormalTextureCoordinatesId(const Value: Integer);
begin
  FdBinormalTextureCoordinatesId.Send(Value);
end;

function TCommonSurfaceShaderNode.GetInvertAlphaTexture: Boolean;
begin
  Result := FdInvertAlphaTexture.Value;
end;

procedure TCommonSurfaceShaderNode.SetInvertAlphaTexture(const Value: Boolean);
begin
  FdInvertAlphaTexture.Send(Value);
end;

function TCommonSurfaceShaderNode.GetRelativeIndexOfRefraction: Single;
begin
  Result := FdRelativeIndexOfRefraction.Value;
end;

procedure TCommonSurfaceShaderNode.SetRelativeIndexOfRefraction(const Value: Single);
begin
  FdRelativeIndexOfRefraction.Send(Value);
end;

function TCommonSurfaceShaderNode.GetFresnelBlend: Single;
begin
  Result := FdFresnelBlend.Value;
end;

procedure TCommonSurfaceShaderNode.SetFresnelBlend(const Value: Single);
begin
  FdFresnelBlend.Send(Value);
end;

procedure TCommonSurfaceShaderNode.SetTextureTransformEnabled(const Value: array of boolean);
begin
  FdTextureTransformEnabled.Send(Value);
end;

procedure TCommonSurfaceShaderNode.SetTextureTransformEnabled(const Value: TBooleanList);
begin
  FdTextureTransformEnabled.Send(Value);
end;

class function TCommonSurfaceShaderNode.ClassX3DType: String;
begin
  Result := 'CommonSurfaceShader';
end;

procedure TCommonSurfaceShaderNode.CreateNode;
begin
  inherited;

  FFdAlphaFactor := TSFFloat.Create(Self, True, 'alphaFactor', 1);
   FdAlphaFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAlphaFactor);

  FFdAlphaTextureId := TSFInt32.Create(Self, True, 'alphaTextureId', -1);
   FdAlphaTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAlphaTextureId);

  FFdAlphaTextureCoordinatesId := TSFInt32.Create(Self, True, 'alphaTextureCoordinatesId', 0);
   FdAlphaTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAlphaTextureCoordinatesId);

  FFdAlphaTextureChannelMask := TSFString.Create(Self, True, 'alphaTextureChannelMask', 'a');
   FdAlphaTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAlphaTextureChannelMask);

  FFdAlphaTexture := TSFNode.Create(Self, True, 'alphaTexture', [TAbstractTextureNode]);
   FdAlphaTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAlphaTexture);

  FFdAmbientFactor := TSFVec3f.Create(Self, True, 'ambientFactor', Vector3(0.2, 0.2, 0.2));
   FdAmbientFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAmbientFactor);

  FFdAmbientTextureId := TSFInt32.Create(Self, True, 'ambientTextureId', -1);
   FdAmbientTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAmbientTextureId);

  FFdAmbientTextureCoordinatesId := TSFInt32.Create(Self, True, 'ambientTextureCoordinatesId', 0);
   FdAmbientTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAmbientTextureCoordinatesId);

  FFdAmbientTextureChannelMask := TSFString.Create(Self, True, 'ambientTextureChannelMask', 'rgb');
   FdAmbientTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAmbientTextureChannelMask);

  FFdAmbientTexture := TSFNode.Create(Self, True, 'ambientTexture', [TAbstractTextureNode]);
   FdAmbientTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAmbientTexture);

  FFdDiffuseFactor := TSFVec3f.Create(Self, True, 'diffuseFactor', Vector3(0.8, 0.8, 0.8));
   FdDiffuseFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseFactor);

  FFdDiffuseTextureId := TSFInt32.Create(Self, True, 'diffuseTextureId', -1);
   FdDiffuseTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseTextureId);

  FFdDiffuseTextureCoordinatesId := TSFInt32.Create(Self, True, 'diffuseTextureCoordinatesId', 0);
   FdDiffuseTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseTextureCoordinatesId);

  FFdDiffuseTextureChannelMask := TSFString.Create(Self, True, 'diffuseTextureChannelMask', 'rgb');
   FdDiffuseTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseTextureChannelMask);

  FFdDiffuseTexture := TSFNode.Create(Self, True, 'diffuseTexture', [TAbstractTextureNode]);
   FdDiffuseTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseTexture);

  FFdDiffuseDisplacementTexture := TSFNode.Create(Self, True, 'diffuseDisplacementTexture', [TAbstractTextureNode]);
   FdDiffuseDisplacementTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDiffuseDisplacementTexture);

  FFdDisplacementAxis := TSFString.Create(Self, True, 'displacementAxis', 'y');
   FdDisplacementAxis.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisplacementAxis);

  FFdDisplacementFactor := TSFFloat.Create(Self, True, 'displacementFactor', 255.0);
   FdDisplacementFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisplacementFactor);

  FFdDisplacementTextureId := TSFInt32.Create(Self, True, 'displacementTextureId', -1);
   FdDisplacementTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisplacementTextureId);

  FFdDisplacementTextureCoordinatesId := TSFInt32.Create(Self, True, 'displacementTextureCoordinatesId', 0);
   FdDisplacementTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisplacementTextureCoordinatesId);

  FFdDisplacementTexture := TSFNode.Create(Self, True, 'displacementTexture', [TAbstractTextureNode]);
   FdDisplacementTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDisplacementTexture);

  FFdEmissiveFactor := TSFVec3f.Create(Self, True, 'emissiveFactor', Vector3(0, 0, 0));
   FdEmissiveFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveFactor);

  FFdEmissiveTextureId := TSFInt32.Create(Self, True, 'emissiveTextureId', -1);
   FdEmissiveTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveTextureId);

  FFdEmissiveTextureCoordinatesId := TSFInt32.Create(Self, True, 'emissiveTextureCoordinatesId', 0);
   FdEmissiveTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveTextureCoordinatesId);

  FFdEmissiveTextureChannelMask := TSFString.Create(Self, True, 'emissiveTextureChannelMask', 'rgb');
   FdEmissiveTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveTextureChannelMask);

  FFdEmissiveTexture := TSFNode.Create(Self, True, 'emissiveTexture', [TAbstractTextureNode]);
   FdEmissiveTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEmissiveTexture);

  FFdEnvironmentFactor := TSFVec3f.Create(Self, True, 'environmentFactor', Vector3(1, 1, 1));
   FdEnvironmentFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnvironmentFactor);

  FFdEnvironmentTextureId := TSFInt32.Create(Self, True, 'environmentTextureId', -1);
   FdEnvironmentTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnvironmentTextureId);

  FFdEnvironmentTextureCoordinatesId := TSFInt32.Create(Self, True, 'environmentTextureCoordinatesId', 0);
   FdEnvironmentTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnvironmentTextureCoordinatesId);

  FFdEnvironmentTextureChannelMask := TSFString.Create(Self, True, 'environmentTextureChannelMask', 'rgb');
   FdEnvironmentTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnvironmentTextureChannelMask);

  FFdEnvironmentTexture := TSFNode.Create(Self, True, 'environmentTexture', [TAbstractEnvironmentTextureNode]);
   FdEnvironmentTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnvironmentTexture);

  FFdMultiDiffuseAlphaTexture := TSFNode.Create(Self, True, 'multiDiffuseAlphaTexture', [TAbstractTextureNode]);
   FdMultiDiffuseAlphaTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMultiDiffuseAlphaTexture);

  FFdMultiEmmisiveAmbientIntensityTexture := TSFNode.Create(Self, True, 'multiEmmisiveAmbientIntensityTexture', [TAbstractTextureNode]);
   FdMultiEmmisiveAmbientIntensityTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMultiEmmisiveAmbientIntensityTexture);

  FFdMultiSpecularShininessTexture := TSFNode.Create(Self, True, 'multiSpecularShininessTexture', [TAbstractTextureNode]);
   FdMultiSpecularShininessTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMultiSpecularShininessTexture);

  FFdMultiVisibilityTexture := TSFNode.Create(Self, True, 'multiVisibilityTexture', [TAbstractTextureNode]);
   FdMultiVisibilityTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMultiVisibilityTexture);

  FFdNormalFormat := TSFString.Create(Self, True, 'normalFormat', 'UNORM');
   FdNormalFormat.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalFormat);

  FFdNormalSpace := TSFString.Create(Self, True, 'normalSpace', 'TANGENT');
   FdNormalSpace.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalSpace);

  FFdNormalTextureId := TSFInt32.Create(Self, True, 'normalTextureId', -1);
   FdNormalTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalTextureId);

  FFdNormalTextureCoordinatesId := TSFInt32.Create(Self, True, 'normalTextureCoordinatesId', 0);
   FdNormalTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalTextureCoordinatesId);

  FFdNormalTextureChannelMask := TSFString.Create(Self, True, 'normalTextureChannelMask', 'rgb');
   FdNormalTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalTextureChannelMask);

  FFdNormalScale := TSFVec3f.Create(Self, False, 'normalScale', Vector3(2, 2, 2));
   FdNormalScale.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalScale);

  FFdNormalBias := TSFVec3f.Create(Self, False, 'normalBias', Vector3(-1, -1, -1));
   FdNormalBias.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalBias);

  FFdNormalTexture := TSFNode.Create(Self, True, 'normalTexture', [TAbstractTextureNode]);
   FdNormalTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalTexture);

  FFdNormalTextureParallaxHeight := TSFFloat.Create(Self, True, 'normalTextureParallaxHeight', 0);
   FdNormalTextureParallaxHeight.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNormalTextureParallaxHeight);

  FFdReflectionFactor := TSFVec3f.Create(Self, True, 'reflectionFactor', Vector3(0, 0, 0));
   FdReflectionFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReflectionFactor);

  FFdReflectionTextureId := TSFInt32.Create(Self, True, 'reflectionTextureId', -1);
   FdReflectionTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReflectionTextureId);

  FFdReflectionTextureCoordinatesId := TSFInt32.Create(Self, True, 'reflectionTextureCoordinatesId', 0);
   FdReflectionTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReflectionTextureCoordinatesId);

  FFdReflectionTextureChannelMask := TSFString.Create(Self, True, 'reflectionTextureChannelMask', 'rgb');
   FdReflectionTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReflectionTextureChannelMask);

  FFdReflectionTexture := TSFNode.Create(Self, True, 'reflectionTexture', [TAbstractTextureNode]);
   FdReflectionTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReflectionTexture);

  FFdShininessFactor := TSFFloat.Create(Self, True, 'shininessFactor', 0.2);
   FdShininessFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShininessFactor);

  FFdShininessTextureId := TSFInt32.Create(Self, True, 'shininessTextureId', -1);
   FdShininessTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShininessTextureId);

  FFdShininessTextureCoordinatesId := TSFInt32.Create(Self, True, 'shininessTextureCoordinatesId', 0);
   FdShininessTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShininessTextureCoordinatesId);

  FFdShininessTextureChannelMask := TSFString.Create(Self, True, 'shininessTextureChannelMask', 'a');
   FdShininessTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShininessTextureChannelMask);

  FFdShininessTexture := TSFNode.Create(Self, True, 'shininessTexture', [TAbstractTextureNode]);
   FdShininessTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShininessTexture);

  FFdSpecularFactor := TSFVec3f.Create(Self, True, 'specularFactor', Vector3(0, 0, 0));
   FdSpecularFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpecularFactor);

  FFdSpecularTextureId := TSFInt32.Create(Self, True, 'specularTextureId', -1);
   FdSpecularTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpecularTextureId);

  FFdSpecularTextureCoordinatesId := TSFInt32.Create(Self, True, 'specularTextureCoordinatesId', 0);
   FdSpecularTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpecularTextureCoordinatesId);

  FFdSpecularTextureChannelMask := TSFString.Create(Self, True, 'specularTextureChannelMask', 'rgb');
   FdSpecularTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpecularTextureChannelMask);

  FFdSpecularTexture := TSFNode.Create(Self, True, 'specularTexture', [TAbstractTextureNode]);
   FdSpecularTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSpecularTexture);

  FFdTransmissionFactor := TSFVec3f.Create(Self, True, 'transmissionFactor', Vector3(0, 0, 0));
   FdTransmissionFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmissionFactor);

  FFdTransmissionTextureId := TSFInt32.Create(Self, True, 'transmissionTextureId', -1);
   FdTransmissionTextureId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmissionTextureId);

  FFdTransmissionTextureCoordinatesId := TSFInt32.Create(Self, True, 'transmissionTextureCoordinatesId', 0);
   FdTransmissionTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmissionTextureCoordinatesId);

  FFdTransmissionTextureChannelMask := TSFString.Create(Self, True, 'transmissionTextureChannelMask', 'rgb');
   FdTransmissionTextureChannelMask.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmissionTextureChannelMask);

  FFdTransmissionTexture := TSFNode.Create(Self, True, 'transmissionTexture', [TAbstractTextureNode]);
   FdTransmissionTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmissionTexture);

  FFdTangentTextureCoordinatesId := TSFInt32.Create(Self, True, 'tangentTextureCoordinatesId', -1);
   FdTangentTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTangentTextureCoordinatesId);

  FFdBinormalTextureCoordinatesId := TSFInt32.Create(Self, True, 'binormalTextureCoordinatesId', -1);
   FdBinormalTextureCoordinatesId.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBinormalTextureCoordinatesId);

  FFdInvertAlphaTexture := TSFBool.Create(Self, True, 'invertAlphaTexture', false);
   FdInvertAlphaTexture.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdInvertAlphaTexture);

  FFdRelativeIndexOfRefraction := TSFFloat.Create(Self, True, 'relativeIndexOfRefraction', 1);
   FdRelativeIndexOfRefraction.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRelativeIndexOfRefraction);

  FFdFresnelBlend := TSFFloat.Create(Self, True, 'fresnelBlend', 0);
   FdFresnelBlend.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFresnelBlend);

  FFdTextureTransformEnabled := TMFBool.Create(Self, False, 'textureTransformEnabled', [false, false, false, false, false, false, false, false]);
   FdTextureTransformEnabled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTextureTransformEnabled);

  DefaultContainerField := 'shaders';
end;

{$endif read_implementation}
