{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetRadius: Single;
    procedure SetRadius(const Value: Single);
    function GetHeight: Single;
    procedure SetHeight(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdParts: TSFBitMask;
    { Internal wrapper for property @code(Parts). This wrapper API may change, we advise to access simpler @code(Parts) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdParts: TSFBitMask read FFdParts;

    strict private FFdRadius: TSFFloat;
    { Internal wrapper for property @code(Radius). This wrapper API may change, we advise to access simpler @code(Radius) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdRadius: TSFFloat read FFdRadius;
    {  }
    property Radius: Single read GetRadius write SetRadius;

    strict private FFdHeight: TSFFloat;
    { Internal wrapper for property @code(Height). This wrapper API may change, we advise to access simpler @code(Height) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdHeight: TSFFloat read FFdHeight;
    {  }
    property Height: Single read GetHeight write SetHeight;

{$endif read_interface}

{$ifdef read_implementation}

{ TCylinderNode_1 ----------------------------------------------- }

function TCylinderNode_1.GetRadius: Single;
begin
  Result := FdRadius.Value;
end;

procedure TCylinderNode_1.SetRadius(const Value: Single);
begin
  FdRadius.Send(Value);
end;

function TCylinderNode_1.GetHeight: Single;
begin
  Result := FdHeight.Value;
end;

procedure TCylinderNode_1.SetHeight(const Value: Single);
begin
  FdHeight.Send(Value);
end;

class function TCylinderNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TCylinderNode_1.ClassX3DType: String;
begin
  Result := 'Cylinder';
end;

procedure TCylinderNode_1.CreateNode;
begin
  inherited;

  FFdParts := TSFBitMask.Create(Self, True, 'parts', ['SIDES', 'TOP', 'BOTTOM'], 'NONE', 'ALL', [true, true, true]);
   FdParts.ChangeAlways := chGeometry;
  AddField(FFdParts);

  FFdRadius := TSFFloat.Create(Self, True, 'radius', 1);
   FdRadius.ChangeAlways := chGeometry;
   FdRadius.MustBeNonnegative := true;
  AddField(FFdRadius);

  FFdHeight := TSFFloat.Create(Self, True, 'height', 2);
   FdHeight.ChangeAlways := chGeometry;
   FdHeight.MustBeNonnegative := true;
  AddField(FFdHeight);
end;

{$endif read_implementation}
