#include "capture.h"
#include "../cordova.h"
#include <QMediaRecorder>
#include <QImageReader>
#include <QQuickView>
#include <QQuickItem>

#define AUDIO_STATE_NAME "audio"

Capture::Capture(Cordova *cordova): CPlugin(cordova), m_scId(0), m_ecId(0) {
}

void Capture::onError(QMediaRecorder::Error) {
    if (!m_ecId)
        return;
    this->cb(m_ecId);
    m_ecId = m_scId = 0;

    m_cordova->popViewState(AUDIO_STATE_NAME);
    m_recorder.clear();
    m_files.clear();
}

void Capture::getSupportedFormats(int scId, int ecId) {
    Q_UNUSED(ecId)

    QAudioRecorder recorder;
    QString audioCodecs, videoCodecs, imageFormats;

    audioCodecs = QString("'audio/amr', 'audio/wav'");

    for (const QString &format: recorder.supportedVideoCodecs()) {
        if (videoCodecs.size())
            videoCodecs += ",";
        videoCodecs += QString("\'%1\'").arg(format);
    }

    for (const QByteArray &format: QImageReader::supportedImageFormats()) {
        if (imageFormats.size())
            imageFormats += ",";
        imageFormats += QString("'image/%1'").arg(QString(format).toLower());
    }
    this->callback(scId, QString("[%1], [%2], [%3]").arg(audioCodecs).arg(videoCodecs).arg(imageFormats));
}

void Capture::startAudioRecordApp(int scId, int ecId, QVariantMap p_options) {
    if (m_scId || m_ecId) {
        this->callbackWithoutRemove(ecId, "\"Device is busy\"");
        return;
    }
    m_scId = scId;
    m_ecId = ecId;

    m_cordova->pushViewState(AUDIO_STATE_NAME);
    m_options = p_options;
}

static QString
join(const QList<QString> &in) {
    QString res;
    for (const QString &str: in)
        res += QString("'%1',").arg(str);
    return res;
}

void Capture::record() {
    if (m_recorder.data()) {
        QUrl url = m_recorder->outputLocation();
        QString path = url.toString();
        m_recorder->stop();

        m_recorder.clear();

        m_files.append(path);
        qDebug() << m_options.find("limit")->toInt();
        if (m_options.find("limit")->toInt() > 0) {
            m_options["limit"] = m_options.find("limit")->toInt() - 1;
        } else {
            //FIXME
            this->callback(m_scId, QString("[%1]").arg(join(m_files)));
            m_files.clear();
            m_ecId = m_scId = 0;

            m_cordova->popViewState(AUDIO_STATE_NAME);
        }
    } else {
        m_recorder = QSharedPointer<QAudioRecorder>(new QAudioRecorder);
        QObject::connect(m_recorder.data(), SIGNAL(error(QMediaRecorder::Error)), this, SLOT(onError(QMediaRecorder::Error)));

        if (m_options.find("mode")->toString() == "audio/amr")
            m_recorder->setContainerFormat("amr");
        else
            m_recorder->setContainerFormat("wav");
        m_recorder->record();
    }
}

void Capture::cancel() {
    if (!m_ecId)
        return;
    if (m_files.size()) {
        this->callback(m_scId, QString("[%1]").arg(join(m_files)));
        m_ecId = m_scId = 0;
        m_files.clear();

        m_cordova->popViewState(AUDIO_STATE_NAME);
        m_recorder.clear();
        return;
    }
    this->cb(m_ecId, "canceled");
    m_ecId = m_scId = 0;

    m_cordova->popViewState(AUDIO_STATE_NAME);
    m_recorder.clear();
}
