# Copyright (C) 2008 by Intevation GmbH
# Authors:
# Bernhard Herzog <bh@intevation.de>
#
# This program is free software under the LGPL (>=v2.1)
# Read the file COPYING coming with the software for details.

import unittest
from imapsupport import ImapConnection, ImapError, default_config

from test_annotatemore import AnnotationTests

class TestSetAnnotation(AnnotationTests):

    def setUp(self):
        AnnotationTests.setUp(self)
        self.mailbox = "INBOX/Calendar"
        self.entry = "/vendor/kolab/folder-type"
        self.attribute = "value.shared"
        self.value = "event"
        self.ensure_mailbox_new_and_empty(self.mailbox)

    def test_setannotation_private(self):
        attribute = "value.priv"
        value = "private value"
        self.imap.setannotation(self.mailbox, self.entry, [attribute, value])
        annotation = self.imap.getannotation(self.mailbox, self.entry,
                                             attribute)
        self.assertEquals(annotation,
                          ['"%s" "%s" ("%s" "%s")'
                           % (self.mailbox, self.entry, attribute, value)])

    def test_setannotation_deleting_private(self):
        attribute = "value.priv"
        value = "private value"
        self.imap.setannotation(self.mailbox, self.entry, [attribute, value])
        self.imap.setannotation(self.mailbox, self.entry, [attribute, None])
        annotation = self.imap.getannotation(self.mailbox, self.entry,
                                             attribute)
        self.assertEquals(annotation, [])


class TestMisc(AnnotationTests):

    def setUp(self):
        AnnotationTests.setUp(self)
        self.mailbox = "INBOX/Tasks"
        self.entry = "/vendor/kolab/folder-test"
        self.attribute = "value"
        self.attribute_shared = self.attribute + ".shared"
        self.attribute_private = self.attribute + ".priv"
        self.value = "task"
        self.ensure_mailbox_new_and_empty(self.mailbox)

    def test_public_and_private_are_different_namespaces(self):
        value_shared = "shared value"
        value_private = "private value"
        self.imap.setannotation(self.mailbox, self.entry,
                                [self.attribute_shared, value_shared])
        self.imap.setannotation(self.mailbox, self.entry,
                                [self.attribute_private, value_private])
        self.assertEquals(self.imap.getannotation(self.mailbox, self.entry,
                                                  self.attribute_shared),
                          ['"%s" "%s" ("%s" "%s")'
                           % (self.mailbox, self.entry,
                              self.attribute_shared, value_shared)])
        self.assertEquals(self.imap.getannotation(self.mailbox, self.entry,
                                                  self.attribute_private),
                          ['"%s" "%s" ("%s" "%s")'
                           % (self.mailbox, self.entry,
                              self.attribute_private, value_private)])

    def test_getannotation_attribute_without_suffix(self):
        value_shared = "shared value"
        value_private = "private value"
        self.imap.setannotation(self.mailbox, self.entry,
                                [self.attribute_shared, value_shared])
        self.imap.setannotation(self.mailbox, self.entry,
                                [self.attribute_private, value_private])
        self.assertEquals(sorted(self.imap.getannotation(self.mailbox,
                                                         self.entry,
                                                         self.attribute)),
                          sorted(['"%s" "%s" ("%s" "%s")'
                                  % (self.mailbox, self.entry,
                                     self.attribute_shared, value_shared),
                                  '"%s" "%s" ("%s" "%s")'
                                  % (self.mailbox, self.entry,
                                     self.attribute_private, value_private),]))




if __name__ == "__main__":
    unittest.main()
