dnl -*- autoconf -*-
# DUNE_CHECK_LIB_EXT(PATH, LIBRARY, FUNCTION, [ACTION-IF-FOUND],
#                    [ACTION-IF-NOT-FOUND], [OTHER-LIBRARIES])
#
# Just like AC_CHECK_LIB, but it allows a library path to be specified.  The
# default ACTION-IF-FOUND is extended to also add that library path to LIBS.
#
# PATH    Path to search for the library.  This should be something suitable
#         to be used inside a double quoted shell string.
#
# LIBRARY Name of the library.  This should be something suitable to be used
#         inside a double quoted shell string.  If this containes shell
#         subtitutions, no config.h template will be generated by the default
#         action.
#
# FUNCTION Function to check for.  This should be something suitable to be
#         used inside a double quoted shell string.
#
# ACTION-IF-FOUND Action to perform when the library was found.  If empty, set
#         prepend "-L{PATH} -l{LIBRARY}" and create a preprocessor define
#         HAVE_LIB{LIBRARY} (the preprocessor define's name is passed through
#         AS_TR_CPP to make it suitable first).
#
# ACTION-IF-NOT-FOUND Action to perform when the library was not found.
#
# OTHER-LIBRARIES If linking agains LIBRARY will only succeed in the presence
#         of other libraries not already in LIBS, specify them here.  These
#         libraries will not be added to LIBS in the default ACTION-IF-FOUND.
AC_DEFUN([DUNE_CHECK_LIB_EXT],
[m4_ifval([$4], , [AH_TEMPLATE(AS_TR_CPP([HAVE_LIB$2]),
                               [Define to 1 if you have the `$2' library (-L$1 -l$2).])])dnl
AS_VAR_PUSHDEF([dune_Lib],
               [dune_cv_lib_$1]AS_LITERAL_IF([$1], , [['']])dnl
[_$2]AS_LITERAL_IF([$2], , [['']])dnl
[_$3])dnl
AC_CACHE_CHECK([for $3 in -L$1 -l$2], dune_Lib,
[dune_check_lib_ext_save_LIBS=$LIBS
LIBS="-L$1 -l$2 $6 $LIBS"
AC_LINK_IFELSE([AC_LANG_CALL([], [$3])],
	       [AS_VAR_SET(dune_Lib, [yes])],
	       [AS_VAR_SET(dune_Lib, [no])])
LIBS=$dune_check_lib_ext_save_LIBS])
DUNE_VAR_IF([dune_Lib], [yes],
      [m4_default([$4], [AC_DEFINE_UNQUOTED(AS_TR_CPP([HAVE_LIB$2]))
  LIBS="-L$1 -l$2 $LIBS"
])],
      [$5])
AS_VAR_POPDEF([dune_Lib])dnl
])# DUNE_CHECK_LIB_EXT
