/* $Id: bridge.h,v 1.126 2009-01-27 17:44:18 potyra Exp $ 
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LIB_BRIDGE_H_INCLUDED
#define __LIB_BRIDGE_H_INCLUDED

#include "config.h"

/* Compile time parameters */
#define MAX_PEERS 8			/* maximum number of peers to
					   communicate with */

#include <inttypes.h>
#include <sys/types.h>
#include <netinet/in.h>

struct cim_msg {
	uint64_t timestamp;
	uint32_t conn_id;
	uint16_t length;
	uint8_t buf[0]; /* 'length' bytes following */
};

struct bridge {
	struct bridge *prev;
	struct bridge *next;

	unsigned int conn_id;
	/*unsigned*/ int count;
	uint64_t hosts;

	void (*receive)(void *, void *, unsigned int);
	void *s;
};

extern void
cim_send(struct bridge *b, const void *buf, unsigned int len);

extern void
cim_connect(
	struct bridge *b,
	void (*receive)(void *, void *, unsigned int),
	void *s);

extern int
cim_get_peer_count(struct bridge *b);
extern void
cim_reconfig(struct bridge *b);

extern void
cim_create(struct bridge *b);
extern void
cim_destroy(struct bridge *b);

extern void
conn_init(void);
extern void
conn_exit(void);

extern void
conn_create(void);
extern void
conn_destroy(void);

#endif /* ! __LIB_BRIDGE_H_INCLUDED */
