// Generated by Flexc++ V2.13.00 on Thu, 16 Mar 2023 14:21:13 +0100

#ifndef Scanner_H_INCLUDED_
#define Scanner_H_INCLUDED_

#include <fstream>

// $insert baseclass_h
#include "scannerbase.h"

#include "../enums/enums.h"

// $insert classHead
class Scanner: private std::ifstream, public ScannerBase
{
    eAction d_action;                // set by action() called in lexer
    size_t d_idx;
    size_t d_offset;                // current offset in the Rules file
    size_t d_nextOffset;            // begin offset of a Rule section
    bool d_pushStreamOK;
    bool d_pushed;

    public:
        enum
        {
            DATE_WIDTH = 3 * 2 + 2      // see lexer
        };

        Scanner();

        eAction action() const;                                      //  .f

        // $insert lexFunctionDecl
        int lex();
        size_t idx() const;

        size_t nextOffset() const;  // the begin offset of a Rule-spec
        void setNextOffset();       // sets d_nextOffset to d_offset
        size_t offset() const;      // offset of each line

        void allowFileSwitching();  // pushing streams is again OK
        void stopFileSwitching();
        void toEOF();

    private:
        int action(eAction type);

        int error2INITIAL();     
        int regex2INITIAL();     
        int nlOffset();         // returns \n, sets d_offset
        int pushedStream();     // 0 (EOF) or '\n' when a rules file is used
                                // (maybe) switch to a Rules file
        int rulesFile();        // reset d_offset. d_nextOffset
        void incNextOffset();   // set d_ruleBegin
        void toMs(StartCondition_ sc);

        int setIdx(int retToken);

        int lex_();
        int executeAction_(size_t ruleNr);

        void print();
        void preCode();     // re-implement this function for code that must 
                            // be exec'ed before the patternmatching starts

        void postCode(PostEnum_ type);    
                            // re-implement this function for code that must 
                            // be exec'ed after the rules's actions.
};

#include "scanner.f"

#endif // Scanner_H_INCLUDED_

