.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "regbounds n"
.TH regbounds n "January 2, 2008" "version 1.4.2" "SAORD Documentation"
.SH "NAME"
\&\fBRegBounds: Region Boundaries\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
Describes how spatial region boundaries are handled.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
The golden rule for spatial region filtering was first enunciated by
Leon VanSpeybroeck in 1986:
.PP
Each photon will be counted once, and no photon will be counted
more than once.
.PP
This means that we must be careful about boundary
conditions.  For example, if a circle is contained in an annulus such
that the inner radius of the annulus is the same as the radius of the
circle, then photons on that boundary must always be assigned to one
or the other region. That is, the number of photons in both regions
must equal the sum of the number of photons in each region taken
separately.
.PP
With this in mind, the rules for determining whether a boundary image
pixel or table row are assigned to a region are defined below.
.PP
\&\fBImage boundaries : radially-symmetric shapes (circle, annuli, ellipse)\fR
.PP
For image filtering, pixels whose center is inside the boundary are
included.  This also applies non-radially-symmetric shapes.  When a
pixel center is exactly on the boundary, the pixel assignment rule is:
.IP "\(bu" 4
the outer boundary of a symmetric shape does not include such pixels
.IP "\(bu" 4
the inner boundary of a symmetric shape (annulus) includes such pixels
.PP
In this way, an annulus with radius from 0 to 1, centered exactly on a
pixel, includes the pixel on which it is centered, but none of its
neighbors.
.PP
These rules ensure that when defining concentric shapes, no pixels are
omitted between concentric regions and no pixels are claimed by two
regions.  When applied to small symmetric shapes, the shape is less
likely to be skewed, as would happen with non-radially-symmetric
rules.  These rules differ from the rules for box-like shapes, which
are more likely to be positioned adjacent to one another.
.PP
\&\fBImage Boundaries: non-radially symmetric shapes (polygons, boxes)\fR
.PP
For image filtering, pixels whose center is inside the boundary are
included. This also applies radially-symmetric shapes.  When a pixel
center is exactly on the boundary of a non-radially symmetric region,
the pixel is included in the right or upper region, but not the left
or lower region.  This ensures that geometrically adjoining regions
touch but don't overlap.
.PP
\&\fBRow Boundaries are Analytic\fR
.PP
When filtering table rows, the boundary rules are the same as for
images, except that the calculation is not done on the center of a
pixel, (since table rows, especially X\-ray events rows, often have
discrete, floating point positions) but are calculated exactly. That
is, an row is inside the boundary without regard to its integerized
pixel value.  For rows that are exactly on a region boundary, the
above rules are applied to ensure that all rows are counted once and
no row is counted more than once.
.PP
Because row boundaries are calculated differently from image boundaries,
certain programs will give different results when filtering the same
region file. In particular, fundisp/funtable (which utilize analytic
row filtering) perform differently from funcnts (which performs image
filtering, even on tables).
.PP
\&\fBImage Boundaries vs. Row Boundaries: Practical Considerations\fR
.PP
You will sometimes notice a discrepancy between running funcnts on an
binary table file and running fundisp on the same file with the same filter.
For example, consider the following:
.PP
.Vb 2
\&  fundisp test1.fits"[box(4219,3887,6,6,0)]" | wc
\&  8893  320148 3752846
.Ve
.PP
Since fundisp has a 2\-line header, there are actually 8891 photons
that pass the filter.  But then run funtable and select only the
rows that pass this filter, placing them in a new file:
.PP
.Vb 1
\&  ./funtable test1.fits"[box(4219,3887,6,6,0)]" test2.fits
.Ve
.PP
Now run funcnts using the original filter on the derived file:
.PP
.Vb 1
\&  ./funcnts test2.fits "physical; box(4219,3887,6,6,0)"
.Ve
.PP
.Vb 1
\&  [... lot of processed output ...]
.Ve
.PP
.Vb 4
\&  # the following source and background components were used:
\&  source region(s)
\&  ----------------
\&  physical; box(4219,3887,6,6,0)
.Ve
.PP
.Vb 3
\&   reg       counts    pixels
\&  ---- ------------ ---------
\&     1     7847.000        36
.Ve
.PP
There are 1044 rows (events) that pass the row filter in fundisp (or
funtable) but fail to make it through funcnts. Why?
.PP
The reason can be traced to how analytic row filtering (fundisp, funtable)
differs from integerized pixel filtering(funcnts, funimage). Consider the
region:
.PP
.Vb 1
\&  box(4219,3887,6,6,0)
.Ve
.PP
Analytically (i.e., using row filtering), positions will pass this
filter successfully if:
.PP
.Vb 2
\&  4216 <= x <= 4222
\&  3884 <= y <= 3890
.Ve
.PP
For example, photons with position values of x=4216.4 or y=3884.08 will pass.
.PP
Integerized image filtering is different in that the pixels that will
pass this filter have centers at:
.PP
.Vb 2
\&  x = 4217, 4218, 4219, 4220, 4221, 4222
\&  y = 3885, 3886, 3887, 3888, 3889, 3890
.Ve
.PP
Note that there are 6 pixels in each direction, as specified by the region.
That means that positions will pass the filter successfully if:
.PP
.Vb 2
\&  4217 <= (int)x <= 4222
\&  3885 <= (int)y <= 3890
.Ve
.PP
Photons with position values of x=4216.4 or y=3884.08 will \s-1NOT\s0 pass.
.PP
Note that the position values are integerized, in effect, binned into
image values.  This means that x=4222.4 will pass this filter, but not
the analytic filter above. We do this to maintain the design goal that
either all counts in a pixel are included in an integerized filter, or
else none are included.
.PP
[It could be argued that the correct photon limits for floating point
row data really should be:
.PP
.Vb 2
\&  4216.5 <= x <= 4222.5
\&  3884.5 <= y <= 3890.5
.Ve
.PP
since each pixel extends for .5 on either side of the center. We chose
to the maintain integerized algorithm for all image-style filtering so
that funcnts would give the exact same results regardless of whether
a table or a derived non-blocked binned image is used.]
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See funtools(n) for a list of Funtools help pages
