ITK 5.3 Release Candidate 1 Release Notes: Performance
=======================================================

We are happy to announce the [Insight Toolkit (ITK)](https://itk.org) 5.3 Release Candidate 1 is available for testing! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

ITK 5.3 is a feature release that accelerates performance, provides new segmentation and shape analysis algorithms, and makes over 200 more improvements.

Release Candidate 1 highlights performance improvements. For deformable image registration, b-spline sampling was improved by ~30%. Multi-threading in Python was improved by adding Threading Building Blocks ([oneTBB](https://github.com/oneapi-src/oneTBB)) to the cross-platform binaries, which [improves multi-threaded parallelism](https://github.com/InsightSoftwareConsortium/ITK/releases/tag/v5.0a02) by ~5-10%. Compression time with zlib, used by common medical imaging file formats like NIFTI, NRRD, or MetaImage, was dramatically reduced through migration to [zlib-ng](https://github.com/zlib-ng/zlib-ng).


![](https://i.imgur.com/tQl8niW.png)


| name              | description      | zlib duration \[ms\] | zlib C.Ratio | zlib-ng duration \[ms\] | zlib-ng C.Ratio | zlib-ng Speed-up | zlib-ng C. Ratio improvement |
| ----------------- | ---------------- | ---------------- | ------------ | ------------------- | --------------- | ---------------- | ---------------------------- |
| wbPET.mha         | whole body PET   | 672              | 9.7%         | 661                 | 9.3%            | 2%               | 4%                           |
| mra.nrrd          | MR angiography   | 1300             | 49.0%        | 1097                | 49.1%           | 19%              | 0%                           |
| CBCT.nrrd         | ConeBeam CT      | 11281            | 42.5%        | 9486                | 41.3%           | 19%              | 3%                           |
| input.nii         | brain MRI        | 4818             | 57.6%        | 3353                | 57.4%           | 44%              | 0%                           |
| scan7.mha         | mouse ultrasound | 5939             | 45.4%        | 4694                | 46.2%           | 27%              | \-2%                         |
| TBR5\_clinpet.nii | label map        | 782              | 0.5%         | 91                  | 0.5%            | 759%             | \-2%                         |
| WhiteMatter.nii   | label map        | 185              | 5.6%         | 76                  | 5.8%            | 143%             | \-4%                         |
| **Average**           |                  |                  |              |                     |                 | **145\%**             | **0\%**                           |

*Comparison of image compression with traditional `zlib` library and the new `zlib-ng` replacement introduced with ITK 5.3 using the default compression level.*

Download
--------

**Python Packages**

Install [ITK Python packages](https://itkpythonpackage.readthedocs.io/en/latest/Quick_start_guide.html) with:

```
pip install --upgrade --pre itk
```

**Library Sources**

- [InsightToolkit-5.3rc01.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc01/InsightToolkit-5.3rc01.tar.gz)
- [InsightToolkit-5.3rc01.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc01/InsightToolkit-5.3rc01.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.3rc01.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc01/InsightData-5.3rc01.tar.gz)
- [InsightData-5.3rc01.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc01/InsightData-5.3rc01.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc01/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.3rc01/SHA512SUMS)



Features
--------

### Python

- Python packages now include oneTBB support for improved performance.
- Following CPython's deprecation schedule Python 3.6 is no longer supported.
- Initial Python wrapping is available for the Video modules.
- `TransformToDisplacementField` is now available in Python.

### C++

- C++14 is now required.
- The minimum CMake version required is now 3.16.3.
- New functions: `MakePoint`, `MakeVector`, `MakeIndex`, `MakeSize`.

### New filter

- `itk::TransformGeometryImageFilter`: applies a rigid transform to an `Image`'s metadata.

### Remote module updates

New remote modules:

- [HASI](https://github.com/KitwareMedical/HASI): High-Throughput Applications for Skeletal Imaging
- [ITKGrowCut](https://github.com/InsightSoftwareConsortium/ITKGrowCut): segments a 3D image from user-provided foreground and background seeds

Updated modules: *AdaptiveDenoising*, *AnisotropicDiffusionLBR*, *BSplineGradient*, *BoneEnhancement*, *BoneMorphometry*, *Cuberille*, *GrowCut*, *HASI*, *HigherOrderAccurateGradient*, *IOFDF*, *IOScanco*, *IsotropicWavelets*, *MinimalPathExtraction*, *Montage*, *MorphologicalContourInterpolation*, *RTK*, *SimpleITKFilters*, *SkullStrip*, *SplitComponents*, *Strain*, *TextureFeatures*, *Thickness3D*, *TotalVariation*, *TubeTK*, and *Ultrasound*.


### Third party library updates

- gdcm
- niftilib
- zlib migrated to zlib-ng
- hdf5
- kwsys
- metaio
- googletest
- vxl

### Congratulations

Congratulations and **thank you** to everyone who contributed to this release.

Of the *32 authors* who contributed since v5.2.0, we would like to specially recognize the new contributors:

*Pranjal Sahu, Darren Thompson, Tomoyuki SADAKANE, Oleksandr Zavalistyi, Jose Tascon, Kian Weimer, Michael Kuczynski, Ebrahim Ebrahim, and Philip Cook.*


What's Next
-----------


We anticipate an additional release candidate following community testing before the 5.3.0 release. The following release candidates will improve related documentation and make further improvements. Please try out the current release candidate, and discuss your experiences at [discourse.itk.org](https://discourse.itk.org). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium).

**Enjoy ITK!**


ITK Changes Since v5.2.0
---------------------------------------------

### Brad T. Moore (1):

#### Bug Fixes

- fixed reference leak when SWIG passing tuples or lists ([95ee15a07e](https://github.com/InsightSoftwareConsortium/ITK/commit/95ee15a07e))


### Bradley Lowekamp (12):

#### Enhancements

- Add additional testing for zero sized label object ([bc95f51d9f](https://github.com/InsightSoftwareConsortium/ITK/commit/bc95f51d9f))
- StatisticsLabelMapFilter use improve integer histogram ([daa2a20f4b](https://github.com/InsightSoftwareConsortium/ITK/commit/daa2a20f4b))
- Rename ResampleInPlaceImage to TransformGeometryImageFilter ([9827449b4b](https://github.com/InsightSoftwareConsortium/ITK/commit/9827449b4b))

#### Platform Fixes

- Address braces around initializer warning. ([dae904e3d9](https://github.com/InsightSoftwareConsortium/ITK/commit/dae904e3d9))
- Use C99 int types over libtiff's ([f98f6a8920](https://github.com/InsightSoftwareConsortium/ITK/commit/f98f6a8920))

#### Bug Fixes

- Register ComposeScaleSkewVersor3DTransform transform ([8c7784d183](https://github.com/InsightSoftwareConsortium/ITK/commit/8c7784d183))
- Fix SpatialOrientationAdapter::FromDirectionCosines ([8801247049](https://github.com/InsightSoftwareConsortium/ITK/commit/8801247049))
- Add tests demonstration current behavior of histogram based median ([c6da8be54c](https://github.com/InsightSoftwareConsortium/ITK/commit/c6da8be54c))
- Fix StatisticsLabelMap median for even number of pixels ([208d7e32d7](https://github.com/InsightSoftwareConsortium/ITK/commit/208d7e32d7))
- Fix HDF5 installation with cmake targets ([4ecd711eab](https://github.com/InsightSoftwareConsortium/ITK/commit/4ecd711eab))
- Propagate usage of HDF5 find_package NO_MODULE arg to install ([f83a0ba9f4](https://github.com/InsightSoftwareConsortium/ITK/commit/f83a0ba9f4))
- Add tests demonstration current behavior of histogram based median ([55d0fdfafa](https://github.com/InsightSoftwareConsortium/ITK/commit/55d0fdfafa))
- Fix StatisticsLabelMap median for even number of pixels ([3abace1991](https://github.com/InsightSoftwareConsortium/ITK/commit/3abace1991))
- Correct stop condition description ([362dd4c7cf](https://github.com/InsightSoftwareConsortium/ITK/commit/362dd4c7cf))


### Dave Chen (1):

#### Enhancements

- add support for direction in VTK image ([80bcb13d9b](https://github.com/InsightSoftwareConsortium/ITK/commit/80bcb13d9b))


### Dženan Zukić (50):

#### Enhancements

- Add ResampleInPlaceImageFilter ([53f8473c2d](https://github.com/InsightSoftwareConsortium/ITK/commit/53f8473c2d))
- Update style and use the test of ResampleInPlaceImageFilter ([e08395a7c0](https://github.com/InsightSoftwareConsortium/ITK/commit/e08395a7c0))
- Add Transform::ApplyToImageMetadata method ([510586750a](https://github.com/InsightSoftwareConsortium/ITK/commit/510586750a))
- Add support for long long pixel types to ImageDuplicator wrapping ([18ae7502f0](https://github.com/InsightSoftwareConsortium/ITK/commit/18ae7502f0))
- update remote modules using the maintenance script ([c6f4685638](https://github.com/InsightSoftwareConsortium/ITK/commit/c6f4685638))
- Python wrapping reads VLV pixel type correctly ([231ecb7d3d](https://github.com/InsightSoftwareConsortium/ITK/commit/231ecb7d3d))
- add HASI remote module ([2798c2a85f](https://github.com/InsightSoftwareConsortium/ITK/commit/2798c2a85f))
- Add GrowCut remote module ([22524c5f71](https://github.com/InsightSoftwareConsortium/ITK/commit/22524c5f71))
- Remove WriteCompilerDetectionHeader ([d3e151f09d](https://github.com/InsightSoftwareConsortium/ITK/commit/d3e151f09d))
- Port GTest update script to update-third-party.bash ([9661691ded](https://github.com/InsightSoftwareConsortium/ITK/commit/9661691ded))
- Update GTest branch name to `master` in order to "Live at Head" ([001cd1440b](https://github.com/InsightSoftwareConsortium/ITK/commit/001cd1440b))
- fix Python multi-processing hang on unix ([597a6dfe6f](https://github.com/InsightSoftwareConsortium/ITK/commit/2370517505))
- Python wrapping reads VLV pixel type correctly ([4ae3749a61](https://github.com/InsightSoftwareConsortium/ITK/commit/4ae3749a61))
- Add support for long long pixel types to ImageDuplicator wrapping ([278ac68e40](https://github.com/InsightSoftwareConsortium/ITK/commit/278ac68e40))
- remove HDF5 customization to work with older versions of CMake ([83bff5e537](https://github.com/InsightSoftwareConsortium/ITK/commit/83bff5e537))
- fix Windows Bitmap (BMP) channel order ABGR -> BGRA ([29e60cdeca](https://github.com/InsightSoftwareConsortium/ITK/commit/29e60cdeca))
- respect initial position in itkExhaustiveOptimizerv4 ([7777908fe8](https://github.com/InsightSoftwareConsortium/ITK/commit/7777908fe8))
- Update remote modules using the script ([1b16b76599](https://github.com/InsightSoftwareConsortium/ITK/commit/1b16b76599))
- Switch to modern maintained zlib-ng fork of zlib ([f352883354](https://github.com/InsightSoftwareConsortium/ITK/commit/f352883354))
- Temporarily use a fork of zlib-ng until outstanding PRs are merged ([ac071fa0f2](https://github.com/InsightSoftwareConsortium/ITK/commit/ac071fa0f2))

#### Documentation Updates

- Fix broken documentation in ResampleInPlaceImageFilter ([047fa6934a](https://github.com/InsightSoftwareConsortium/ITK/commit/047fa6934a))
- Fix usage information in ImageReadExtractWrite example ([c901eff21c](https://github.com/InsightSoftwareConsortium/ITK/commit/c901eff21c))
- document that 0 pixel count causes every chunk to report progress ([aa36784239](https://github.com/InsightSoftwareConsortium/ITK/commit/aa36784239))
- improve commands for updating mangling symbols on Windows for HDF5 ([af1c73cad5](https://github.com/InsightSoftwareConsortium/ITK/commit/af1c73cad5))

#### Platform Fixes

- Tests depend on GTest ([e4a76a888b](https://github.com/InsightSoftwareConsortium/ITK/commit/e4a76a888b))
- Use non-deprecated ITK_DISALLOW_COPY_AND_MOVE in ResampleInPlace ([6500affdb5](https://github.com/InsightSoftwareConsortium/ITK/commit/6500affdb5))
- Update KWStyle to fix compile warnings on Ubuntu 20.04 ([32501b4230](https://github.com/InsightSoftwareConsortium/ITK/commit/32501b4230))
- Restore generation of static runtime library on MSVC ([dbb34f96cc](https://github.com/InsightSoftwareConsortium/ITK/commit/dbb34f96cc))
- an explicit cast is required to convert itksys::Status into bool ([b8ea8a11d4](https://github.com/InsightSoftwareConsortium/ITK/commit/b8ea8a11d4))
- use WRAP_ITK_SCALAR instead of WRAP_ITK_REAL in mesh filters ([4009370c61](https://github.com/InsightSoftwareConsortium/ITK/commit/4009370c61))
- Update KWStyle's version to avoid compile errors with C++23 ([769981b974](https://github.com/InsightSoftwareConsortium/ITK/commit/769981b974))
- test fails to compile when legacy support is removed ([041261e563](https://github.com/InsightSoftwareConsortium/ITK/commit/041261e563))
- directly use [[deprecated]] in itkLegacyMacro - C++14 allows that ([196a4c8a69](https://github.com/InsightSoftwareConsortium/ITK/commit/196a4c8a69))
- add ITK_ prefix in itkStochasticFractalDimensionImageFilterTest ([dab652d279](https://github.com/InsightSoftwareConsortium/ITK/commit/dab652d279))
- Update KWStyle's version to avoid compile errors with C++23 ([3d85fafc77](https://github.com/InsightSoftwareConsortium/ITK/commit/3d85fafc77))
- use WRAP_ITK_SCALAR instead of WRAP_ITK_REAL in mesh filters ([68944d52d7](https://github.com/InsightSoftwareConsortium/ITK/commit/68944d52d7))
- add Windows symbols to the mangling list ([97105c3ae1](https://github.com/InsightSoftwareConsortium/ITK/commit/97105c3ae1))
- add Linux and MacOS symbols to the mangling list ([21cb724c2c](https://github.com/InsightSoftwareConsortium/ITK/commit/21cb724c2c))
- a method should not return an integer instead of an std::string ([f9f2ea833a](https://github.com/InsightSoftwareConsortium/ITK/commit/f9f2ea833a))
- update KWStyle (so it reports its version number) ([581c4445ca](https://github.com/InsightSoftwareConsortium/ITK/commit/581c4445ca))
- modify zlib-ng to make it build within ITK ([3bcc933052](https://github.com/InsightSoftwareConsortium/ITK/commit/3bcc933052))

#### Bug Fixes

- Fix wrong argument count comparison in ResampleImageFilter example ([a652269b21](https://github.com/InsightSoftwareConsortium/ITK/commit/a652269b21))
- add support for long long pixel types in PyBuffer ([ae7079c4fd](https://github.com/InsightSoftwareConsortium/ITK/commit/ae7079c4fd))

#### Style Changes

- remove pixel count parameter which is no longer used ([791534a99e](https://github.com/InsightSoftwareConsortium/ITK/commit/791534a99e))
- enable git blame to use ignoreRevsFile by default ([ce4fd8fe21](https://github.com/InsightSoftwareConsortium/ITK/commit/ce4fd8fe21))
- remove uninformative comments in BMPImageIO ([b6ccca64a6](https://github.com/InsightSoftwareConsortium/ITK/commit/b6ccca64a6))
- move initialization of iVars to itkExhaustiveOptimizerv4.h ([9b2000ac21](https://github.com/InsightSoftwareConsortium/ITK/commit/9b2000ac21))

#### Miscellaneous Changes

- Revert "COMP: Use CMake 3.18.4 in macOS CI builds" ([ae01547bec](https://github.com/InsightSoftwareConsortium/ITK/commit/ae01547bec))


### Ebrahim Ebrahim (3):

#### Enhancements

- Split Hausdorff distance test ([ab15f0a343](https://github.com/InsightSoftwareConsortium/ITK/commit/ab15f0a343))
- Simplify a directed Hausdorff distance test ([3a63e79d17](https://github.com/InsightSoftwareConsortium/ITK/commit/3a63e79d17))

#### Style Changes

- Make job piece naming consistent ([03024da662](https://github.com/InsightSoftwareConsortium/ITK/commit/03024da662))


### GDCM Upstream (2):

#### Miscellaneous Changes

- GDCM 2021-06-07 (4404b770) ([aae9fdc684](https://github.com/InsightSoftwareConsortium/ITK/commit/aae9fdc684))
- GDCM 2021-06-07 (4404b770) ([47e97596b9](https://github.com/InsightSoftwareConsortium/ITK/commit/47e97596b9))


### Gabriel A. Devenyi (3):

#### Enhancements

- Ignore more bulk changes for git blame ([6b5578ceb1](https://github.com/InsightSoftwareConsortium/ITK/commit/6b5578ceb1))
- Prepare for update to NIFTILIB3.0.1 ([68221fdd30](https://github.com/InsightSoftwareConsortium/ITK/commit/68221fdd30))
- Cleanup in preparation for zlib-ng ([9bc41df7c7](https://github.com/InsightSoftwareConsortium/ITK/commit/9bc41df7c7))


### GoogleTest Upstream (3):

#### Miscellaneous Changes

- GoogleTest 2019-10-03 (703bd9ca) ([d685cc3ba5](https://github.com/InsightSoftwareConsortium/ITK/commit/d685cc3ba5))
- GoogleTest 2021-07-09 (8d51ffdf) ([1b539548fc](https://github.com/InsightSoftwareConsortium/ITK/commit/1b539548fc))
- GoogleTest 2021-08-06 (aefb4546) ([b73f9c3f95](https://github.com/InsightSoftwareConsortium/ITK/commit/b73f9c3f95))


### HDF5 Maintainers (1):

#### Miscellaneous Changes

- HDF5 2020-10-16 (db30c2da) ([044057f763](https://github.com/InsightSoftwareConsortium/ITK/commit/044057f763))


### Hans Johnson (6):

#### Enhancements

- Run unexecuted NiftiImageIOTest12 ([5b54be0b78](https://github.com/InsightSoftwareConsortium/ITK/commit/5b54be0b78))
- Use language features directly without macro ([2e8e4df315](https://github.com/InsightSoftwareConsortium/ITK/commit/2e8e4df315))

#### Platform Fixes

- Fix compilation for ITK_FUTURE_LEGACY=ON ([e88e234de1](https://github.com/InsightSoftwareConsortium/ITK/commit/e88e234de1))

#### Bug Fixes

- Missed wrapping of itkResampleInPlaceImageFilter ([71e04b4fba](https://github.com/InsightSoftwareConsortium/ITK/commit/71e04b4fba))

#### Style Changes

- Improve attribution by ignoring bulk formatting ([3a969e556a](https://github.com/InsightSoftwareConsortium/ITK/commit/3a969e556a))
- utizes -> utilizes spelling fix ([97945bc332](https://github.com/InsightSoftwareConsortium/ITK/commit/97945bc332))


### Jon Haitz Legarreta Gorroño (23):

#### Enhancements

- Improve `itk::ResampleInPlaceImageFilter` coverage ([897351edfd](https://github.com/InsightSoftwareConsortium/ITK/commit/897351edfd))
- Add Python wrapping for `itk::ResampleInPlaceImageFilter` ([3d492cfb85](https://github.com/InsightSoftwareConsortium/ITK/commit/3d492cfb85))
- Bump labeler action version ([13b709360d](https://github.com/InsightSoftwareConsortium/ITK/commit/13b709360d))
- Add further regexes to PR labeler config file ([3bd6b6c715](https://github.com/InsightSoftwareConsortium/ITK/commit/3bd6b6c715))
- Add missing getter method to `itk::GaussianDerivativeOperator` ivar ([d8856ebb1a](https://github.com/InsightSoftwareConsortium/ITK/commit/d8856ebb1a))
- Add RTTI information to `itk::GaussianDerivativeOperator` ([3a7bd3a328](https://github.com/InsightSoftwareConsortium/ITK/commit/3a7bd3a328))
- Make `PixelType` alias be `public` in `itk::AnnulusOperator` ([8aacef9f1d](https://github.com/InsightSoftwareConsortium/ITK/commit/8aacef9f1d))
- Add missing getter method to `itk::LaplacianOperator` ivar ([d94d9ed8c8](https://github.com/InsightSoftwareConsortium/ITK/commit/d94d9ed8c8))
- Add RTTI information to `Common` operator classes ([3f07584abd](https://github.com/InsightSoftwareConsortium/ITK/commit/3f07584abd))
- Increase `Common` operators' code coverage ([71bb6a99fe](https://github.com/InsightSoftwareConsortium/ITK/commit/71bb6a99fe))
- Increase `Review` module classes' code coverage ([230d319fde](https://github.com/InsightSoftwareConsortium/ITK/commit/230d319fde))

#### Documentation Updates

- Improve `itk::ResampleInPlaceImageFilter` documentation ([6fecdb5a57](https://github.com/InsightSoftwareConsortium/ITK/commit/6fecdb5a57))
- Improve documentation in `Common` operator classes ([fc822d75f7](https://github.com/InsightSoftwareConsortium/ITK/commit/fc822d75f7))
- Document members in header methods ([67632ac0dc](https://github.com/InsightSoftwareConsortium/ITK/commit/67632ac0dc))
- Fix enum class name in documentation ([b4cb2d50cf](https://github.com/InsightSoftwareConsortium/ITK/commit/b4cb2d50cf))

#### Bug Fixes

- Fix labeler action file regexes (#2516) ([21793c61b1](https://github.com/InsightSoftwareConsortium/ITK/commit/21793c61b1))
- Fix Python wrapping labeler action regex ([0c047d580d](https://github.com/InsightSoftwareConsortium/ITK/commit/0c047d580d))
- Initialize member in `itk::AttributeLabelObject` ([ce012968d1](https://github.com/InsightSoftwareConsortium/ITK/commit/ce012968d1))

#### Style Changes

- Improve style in miscellaneous files ([68d73baecb](https://github.com/InsightSoftwareConsortium/ITK/commit/68d73baecb))
- Make test style more consistent ([8132e06fe0](https://github.com/InsightSoftwareConsortium/ITK/commit/8132e06fe0))
- Prefer aliasing template pixel type in `common` operator classes ([9f31b6a1c3](https://github.com/InsightSoftwareConsortium/ITK/commit/9f31b6a1c3))
- Prefer implicitly deriving array size in test ([30e6e2b6c7](https://github.com/InsightSoftwareConsortium/ITK/commit/30e6e2b6c7))
- Increase tests style consistency ([16cadc05d0](https://github.com/InsightSoftwareConsortium/ITK/commit/16cadc05d0))


### KWSys Upstream (1):

#### Miscellaneous Changes

- KWSys 2021-07-08 (d5a1dc68) ([12acc786e8](https://github.com/InsightSoftwareConsortium/ITK/commit/12acc786e8))


### Lee Newberg (9):

#### Enhancements

- Propagate StatisticsLabelMapFilter's default NumberOfBins ([bb54bad693](https://github.com/InsightSoftwareConsortium/ITK/commit/bb54bad693))
- Wrap itkAdaptiveHistogramEqualizationImageFilter for Python. ([974c63db99](https://github.com/InsightSoftwareConsortium/ITK/commit/974c63db99))

#### Platform Fixes

- Change ::uint32_t to std::uint32_t, uint32 to uint32_t, etc. ([12f7fede22](https://github.com/InsightSoftwareConsortium/ITK/commit/12f7fede22))
- Add ITK_TEMPLATE_EXPORT to some class declarations. ([5efe8f3359](https://github.com/InsightSoftwareConsortium/ITK/commit/5efe8f3359))

#### Bug Fixes

- Ellipsis is not iterable ([ca0690069a](https://github.com/InsightSoftwareConsortium/ITK/commit/ca0690069a))
- Add run-time type information to FFT filter base classes ([c693dbc830](https://github.com/InsightSoftwareConsortium/ITK/commit/c693dbc830))

#### Style Changes

- Apply "black -l 88" to format Python ([fbbc7aa38c](https://github.com/InsightSoftwareConsortium/ITK/commit/fbbc7aa38c))
- Add pyproject.toml to set default configuration for black Python format ([935237cdf1](https://github.com/InsightSoftwareConsortium/ITK/commit/935237cdf1))
- Add recent Python-formatting commit's hash to .git-blame-ignore-revs. ([4705a3e692](https://github.com/InsightSoftwareConsortium/ITK/commit/4705a3e692))


### Matt McCormick (40):

#### Enhancements

- Bump ITK version to 5.3.0 ([0eacf4e96e](https://github.com/InsightSoftwareConsortium/ITK/commit/0eacf4e96e))
- Update CastXML source builds to v0.4.3, LLVM 11.1.0 ([67fdd3067e](https://github.com/InsightSoftwareConsortium/ITK/commit/67fdd3067e))
- Add CastXML binary for macOS arm64 ([fde7fa6ce8](https://github.com/InsightSoftwareConsortium/ITK/commit/fde7fa6ce8))
- Add Linux arm64 CastXML binaries ([42aa3be3e4](https://github.com/InsightSoftwareConsortium/ITK/commit/42aa3be3e4))
- Updated CI cached testing ExternalData to 5.2.0 ([356710288b](https://github.com/InsightSoftwareConsortium/ITK/commit/356710288b))
- Required VTK 8 or newer ([9f88ad2007](https://github.com/InsightSoftwareConsortium/ITK/commit/9f88ad2007))
- Bump the ITK CMake version to 5.1.0 ([9f3fc5dd12](https://github.com/InsightSoftwareConsortium/ITK/commit/9f3fc5dd12))
- Content link synchronization for ITK 5.2.1 ([8be208ee1f](https://github.com/InsightSoftwareConsortium/ITK/commit/8be208ee1f))
- Check for C++ standard after defaults applied ([74fbb88ec4](https://github.com/InsightSoftwareConsortium/ITK/commit/74fbb88ec4))
- Content link synchronization for ITK 5.3 RC 1 ([6dd08e6a55](https://github.com/InsightSoftwareConsortium/ITK/commit/6dd08e6a55))

#### Documentation Updates

- Add a pointer to good first issues ([ca39327b60](https://github.com/InsightSoftwareConsortium/ITK/commit/ca39327b60))
- Remove indication NarrowBandCurvesLevelSetImageFilter not wrapped ([f7e67070d5](https://github.com/InsightSoftwareConsortium/ITK/commit/f7e67070d5))
- Add Professional Services section to the README ([88085c0177](https://github.com/InsightSoftwareConsortium/ITK/commit/88085c0177))
- Improve Apple Clang error to include C++14 requirement ([6e3d31d138](https://github.com/InsightSoftwareConsortium/ITK/commit/6e3d31d138))

#### Platform Fixes

- Backport CastXML arm64 Eigen support ([a3996fe99a](https://github.com/InsightSoftwareConsortium/ITK/commit/a3996fe99a))
- Do not add IPO to Python wrapping if not supported ([3d2e898400](https://github.com/InsightSoftwareConsortium/ITK/commit/3d2e898400))
- Only use np.float128 when available ([1237a57a3d](https://github.com/InsightSoftwareConsortium/ITK/commit/1237a57a3d))
- Make floating point exceptions a no-op with MUSL, Linux, ARMv8 ([0afa3f06a1](https://github.com/InsightSoftwareConsortium/ITK/commit/0afa3f06a1))
- Replace np.bool with np.bool8 ([5c5e679675](https://github.com/InsightSoftwareConsortium/ITK/commit/5c5e679675))
- Require Python 3.7 or newer ([dfa43f3837](https://github.com/InsightSoftwareConsortium/ITK/commit/dfa43f3837))
- Use Python 3.9 in macOS.Python CI build ([a654bc0317](https://github.com/InsightSoftwareConsortium/ITK/commit/a654bc0317))
- Remove MultiThreaderBase pixelCount ([e086988337](https://github.com/InsightSoftwareConsortium/ITK/commit/e086988337))
- Use numpy==1.20.3 for CI testing ([b667ce4d25](https://github.com/InsightSoftwareConsortium/ITK/commit/b667ce4d25))
- Provide default values for floating point macros ([26b2a2fb4d](https://github.com/InsightSoftwareConsortium/ITK/commit/26b2a2fb4d))
- Do not enable remote module examples when building Doxygen docs ([c754b5d010](https://github.com/InsightSoftwareConsortium/ITK/commit/c754b5d010))
- Use mallinfo2 when available ([54fe14a568](https://github.com/InsightSoftwareConsortium/ITK/commit/f540091c6a))
- Revert "COMP: Use numpy==1.20.3 for CI testing" ([04fd61e3e0](https://github.com/InsightSoftwareConsortium/ITK/commit/04fd61e3e0))
- Add missing template exports to ResampleInPlace,N4Bias,Py ImageFilters ([cafb5ff591](https://github.com/InsightSoftwareConsortium/ITK/commit/cafb5ff591))
- Add missing template export macro to SLICImageFilter ([c3e40927f8](https://github.com/InsightSoftwareConsortium/ITK/commit/c3e40927f8))
- Bump KWStyle to address Boost warnings with GCC 11.2 ([a2aab1bb9c](https://github.com/InsightSoftwareConsortium/ITK/commit/a2aab1bb9c))

#### Bug Fixes

- Add vnl_vector_from_array to extras __all__ ([3f8b14be54](https://github.com/InsightSoftwareConsortium/ITK/commit/3f8b14be54))
- Do not create global multiprocessing RLock ([cfdb5023a8](https://github.com/InsightSoftwareConsortium/ITK/commit/cfdb5023a8))
- Support double colons in Changelog commit summary ([62804d09e9](https://github.com/InsightSoftwareConsortium/ITK/commit/62804d09e9))
- Use consistent ITK_USE_CLANG_FORMAT variable name ([8ecdebad1e](https://github.com/InsightSoftwareConsortium/ITK/commit/8ecdebad1e))
- Ignore ImageToVTKImageFilter in VerifyGetOutputAPIConsistency test ([b085d40c02](https://github.com/InsightSoftwareConsortium/ITK/commit/b085d40c02))
- Initialize C++ standard for remote modules ([9ef180e254](https://github.com/InsightSoftwareConsortium/ITK/commit/9ef180e254))
- Remove slicer.kitware.com as a content link server ([453fc6be24](https://github.com/InsightSoftwareConsortium/ITK/commit/453fc6be24))
- Improve dimension-dependent BSplineInterpolationWeightFunction wrapping ([61f98c7fff](https://github.com/InsightSoftwareConsortium/ITK/commit/61f98c7fff))

#### Style Changes

- Apply black to AuthorsChangesSince.py script ([7504f6e45c](https://github.com/InsightSoftwareConsortium/ITK/commit/7504f6e45c))
- Use CLANG_FORMAT in CMake variable names ([90398b4aad](https://github.com/InsightSoftwareConsortium/ITK/commit/90398b4aad))


### MetaIO Maintainers (1):

#### Miscellaneous Changes

- MetaIO 2021-06-24 (3f37ad78) ([8131832530](https://github.com/InsightSoftwareConsortium/ITK/commit/8131832530))


### NIFTI Upstream (1):

#### Miscellaneous Changes

- nifti 2020-08-07 (96b9954f) ([9c2c9fa9b8](https://github.com/InsightSoftwareConsortium/ITK/commit/9c2c9fa9b8))


### Niels Dekker (49):

#### Enhancements

- Overload `PhasedArray3DSpecialCoordinatesImage` Transform functions ([3d7b84e6ed](https://github.com/InsightSoftwareConsortium/ITK/commit/3d7b84e6ed))
- Add explicit `itk::Vector(const std::array &)` constructor ([4ce3383a46](https://github.com/InsightSoftwareConsortium/ITK/commit/4ce3383a46))
- Add operator==, operator!= to MetaDataObject and MetaDataDictionary ([694bbc0a1f](https://github.com/InsightSoftwareConsortium/ITK/commit/694bbc0a1f))
- Upgrade ITK from C++11 to C++14 ([daec0fdd70](https://github.com/InsightSoftwareConsortium/ITK/commit/daec0fdd70))
- Add numbers to the three `itkPyBufferMemoryLeakTest` print messages ([8d2de7122a](https://github.com/InsightSoftwareConsortium/ITK/commit/8d2de7122a))
- Add `ITK_UNEQUAL_OPERATOR_MEMBER_FUNCTION`, defining `operator!=` ([5efdd93749](https://github.com/InsightSoftwareConsortium/ITK/commit/5efdd93749))
- Add `NthElementPixelAccessor::operator==` ([c97191e6f6](https://github.com/InsightSoftwareConsortium/ITK/commit/c97191e6f6))
- Add `ITK_EXPERIMENTAL_CXX20_REWRITTEN_UNEQUAL_OPERATOR` macro ([2e5ffc8bd4](https://github.com/InsightSoftwareConsortium/ITK/commit/2e5ffc8bd4))
- Add MakePoint, MakeVector, MakeIndex, MakeSize function templates ([8aed68490b](https://github.com/InsightSoftwareConsortium/ITK/commit/8aed68490b))
- Declare Filled and operator[] of Index, Size, FixedArray constexpr ([829bb066a0](https://github.com/InsightSoftwareConsortium/ITK/commit/829bb066a0))
- Replace GetNumberOfWeights() by static constexpr `NumberOfWeights` ([34f3db8d8a](https://github.com/InsightSoftwareConsortium/ITK/commit/34f3db8d8a))
- Replace BSpline GetSupportSize() by static constexpr `SupportSize` ([c178324e39](https://github.com/InsightSoftwareConsortium/ITK/commit/c178324e39))
- Add static member function `BSplineKernelFunction::FastEvaluate(u)` ([99f04d7df4](https://github.com/InsightSoftwareConsortium/ITK/commit/99f04d7df4))

#### Performance Improvements

- Make `ResampleImageFilter::LinearThreadedGenerateData` faster ([c64a58d42a](https://github.com/InsightSoftwareConsortium/ITK/commit/c64a58d42a))
- Use FixedArray for BSplineInterpolationWeightFunction OutputType ([9bf745bda5](https://github.com/InsightSoftwareConsortium/ITK/commit/9bf745bda5))
- Use FixedArray for BSplineBaseTransform ParameterIndexArrayType ([bc7c5dff2d](https://github.com/InsightSoftwareConsortium/ITK/commit/bc7c5dff2d))
- Remove BSplineInterpolationWeightFunction Kernel, use FastEvaluate ([c23944ba54](https://github.com/InsightSoftwareConsortium/ITK/commit/c23944ba54))

#### Platform Fixes

- Require compiler versions that support C++14 ([4e812d6074](https://github.com/InsightSoftwareConsortium/ITK/commit/4e812d6074))
- Adjust CMAKE_CXX..._COMPILE_OPTION for _castxml_cc_flags to C++14 ([577ba4380a](https://github.com/InsightSoftwareConsortium/ITK/commit/577ba4380a))
- Support non-EqualityComparable pixels Image template instantiation ([a293c03b46](https://github.com/InsightSoftwareConsortium/ITK/commit/a293c03b46))
- Require Apple Clang 7.0.2 as minimum in itkCompilerChecks.cmake ([ae4c0ab756](https://github.com/InsightSoftwareConsortium/ITK/commit/ae4c0ab756))
- Add missing `#include <iostream>` to Deprecated module test ([2a7f5ed199](https://github.com/InsightSoftwareConsortium/ITK/commit/2a7f5ed199))
- Remove comparison to FixedArray in MatrixOffsetTransformBase GTest ([feb845afb1](https://github.com/InsightSoftwareConsortium/ITK/commit/feb845afb1))

#### Bug Fixes

- Avoid crash TranslationTransform::SetParameters when too few params ([deb0af73c0](https://github.com/InsightSoftwareConsortium/ITK/commit/deb0af73c0))
- Remove unused virtual operator!=, operator== from ColormapFunction ([384fc45b0c](https://github.com/InsightSoftwareConsortium/ITK/commit/384fc45b0c))
- `Similarity3DTransform::SetScale` should recompute `m_Offset` ([53bb498ba4](https://github.com/InsightSoftwareConsortium/ITK/commit/53bb498ba4))
- `Similarity3DTransform::SetScale` should recompute `m_Offset` ([dd893faf8a](https://github.com/InsightSoftwareConsortium/ITK/commit/dd893faf8a))
- BSplineInterpolationWeightFunction should not print NumberOfWeights ([8dba2bdefe](https://github.com/InsightSoftwareConsortium/ITK/commit/8dba2bdefe))

#### Style Changes

- Replace postfix by prefix increment in `for` loops in Core/Common ([f81578bbb6](https://github.com/InsightSoftwareConsortium/ITK/commit/f81578bbb6))
- Replace postfix by prefix increment in `for` loops in ITK/Modules ([971aef211c](https://github.com/InsightSoftwareConsortium/ITK/commit/971aef211c))
- Replace postfix by prefix increment in `for` loops in Examples ([878fa6f435](https://github.com/InsightSoftwareConsortium/ITK/commit/878fa6f435))
- Matrix constructors vnl_matrix/vnl_matrix_fixed explicit/implicit ([7f5f3360a2](https://github.com/InsightSoftwareConsortium/ITK/commit/7f5f3360a2))
- Combine code `MatrixOffsetTransformBase` constructors ([e6f5f96975](https://github.com/InsightSoftwareConsortium/ITK/commit/e6f5f96975))
- Remove obsolete FixedArray::operator[] workaround for Visual C++ ([fc100111c4](https://github.com/InsightSoftwareConsortium/ITK/commit/fc100111c4))
- Replace `new` by C++14 `std::make_unique` ([22bce725ae](https://github.com/InsightSoftwareConsortium/ITK/commit/22bce725ae))
- Use C++14 <type_traits> template aliases instead of nested types ([0f139ccfff](https://github.com/InsightSoftwareConsortium/ITK/commit/0f139ccfff))
- Use C++14 `make_reverse_iterator` inside `CoLexicographicCompare` ([4ed1cf4035](https://github.com/InsightSoftwareConsortium/ITK/commit/4ed1cf4035))
- C++14 auto return type for ConnectedImageNeighborhoodShapeOffsets ([6ccf7bc3e0](https://github.com/InsightSoftwareConsortium/ITK/commit/6ccf7bc3e0))
- Use `ITK_UNEQUAL_OPERATOR_MEMBER_FUNCTION` in Core/Common ([0ad6ef1b55](https://github.com/InsightSoftwareConsortium/ITK/commit/0ad6ef1b55))
- Use `ITK_UNEQUAL_OPERATOR_MEMBER_FUNCTION` in Modules/Core ([27f26685cc](https://github.com/InsightSoftwareConsortium/ITK/commit/27f26685cc))
- ITK_UNEQUAL_OPERATOR_MEMBER_FUNCTION when `==` just returns true ([f820eef7a5](https://github.com/InsightSoftwareConsortium/ITK/commit/f820eef7a5))
- Use ITK_UNEQUAL_OPERATOR_MEMBER_FUNCTION in Modules/Filtering ([647efb8507](https://github.com/InsightSoftwareConsortium/ITK/commit/647efb8507))
- Use ITK_UNEQUAL_OPERATOR_MEMBER_FUNCTION in Numerics, ..., Video ([29da972077](https://github.com/InsightSoftwareConsortium/ITK/commit/29da972077))
- Make operator!= of UnsharpMaskingFunctor and SliceIterator const ([be45faec96](https://github.com/InsightSoftwareConsortium/ITK/commit/be45faec96))
- Add TanHelper::operator== + ITK_UNEQUAL_OPERATOR_MEMBER_FUNCTION ([16607aa7b7](https://github.com/InsightSoftwareConsortium/ITK/commit/16607aa7b7))
- Add default member initializer `true` to `m_LetArrayManageMemory` ([67d4cf7cfe](https://github.com/InsightSoftwareConsortium/ITK/commit/67d4cf7cfe))
- Use MakePoint, MakeVector, MakeIndex, MakeSize from itk namespace ([5ac7407986](https://github.com/InsightSoftwareConsortium/ITK/commit/5ac7407986))
- Remove `Make` functions from itk::GTest::TypedefsAndConstructors ([558ea67a35](https://github.com/InsightSoftwareConsortium/ITK/commit/558ea67a35))
- TransformInitializers constructors = default; default-member-init ([d2548ce321](https://github.com/InsightSoftwareConsortium/ITK/commit/d2548ce321))


### Oleksandr Zavalistyi (1):

#### Bug Fixes

- Fix initializing FixedImageMarginalPDF with garbage ([0de9cfe31d](https://github.com/InsightSoftwareConsortium/ITK/commit/0de9cfe31d))


### Pablo Hernandez-Cerdan (2):

#### Enhancements

- Increase hook-max-size for next GDCM update ([e25fbbffc2](https://github.com/InsightSoftwareConsortium/ITK/commit/e25fbbffc2))


#### Platform Fixes

- CastXML, ITKVtkGlue, include only when property exists ([0c31aa688e](https://github.com/InsightSoftwareConsortium/ITK/commit/0c31aa688e))


### Philip Cook (1):

#### Bug Fixes

- Fix matrix check rejecting NIFTI sform for small voxels ([6278c4171f](https://github.com/InsightSoftwareConsortium/ITK/commit/6278c4171f))


### Samuel Gerber (1):

#### Enhancements

- Adapt LBFGS2Optimizerv4 to inherit from GradientDescentOptimizerV4 ([c34fb54e10](https://github.com/InsightSoftwareConsortium/ITK/commit/c34fb54e10))


### Sean McBride (3):

#### Enhancements

- Updated HDF5 update script's HDF5 git tag from 1.10.6 to 1.10.7 ([15f1e33e8c](https://github.com/InsightSoftwareConsortium/ITK/commit/15f1e33e8c))
- Made a few slow tests run serially, so they won't timeout ([d794791c7e](https://github.com/InsightSoftwareConsortium/ITK/commit/d794791c7e))

#### Platform Fixes

- Increased min cmake from 3.10.2 to 3.16.3 ([0c3b8cbf9b](https://github.com/InsightSoftwareConsortium/ITK/commit/0c3b8cbf9b))


### Stephen R. Aylward (8):

#### Enhancements

- Bump TubeTK to TubeTK 0.9.0 rc1 ([b8d95b7cad](https://github.com/InsightSoftwareConsortium/ITK/commit/b8d95b7cad))
- Bump TubeTK to version the fixes linux CI ([e230e6d322](https://github.com/InsightSoftwareConsortium/ITK/commit/e230e6d322))
- Updated SpatialObject wrapping to support CONST_POINTER ([28cb8507fd](https://github.com/InsightSoftwareConsortium/ITK/commit/28cb8507fd))

#### Documentation Updates

- Fix description of SpatialObjectToImage registration ([11c2977314](https://github.com/InsightSoftwareConsortium/ITK/commit/11c2977314))

#### Platform Fixes

- Update SpatialObjects to correct const-ness ([903f7c152e](https://github.com/InsightSoftwareConsortium/ITK/commit/903f7c152e))

#### Bug Fixes

- SpatialObject writes object color ([3bf34f6cc5](https://github.com/InsightSoftwareConsortium/ITK/commit/3bf34f6cc5))
- TubeSpatialObject missing CopyInformation ([3060a6d1e5](https://github.com/InsightSoftwareConsortium/ITK/commit/3060a6d1e5))
- TubeSpatialObject didn't preserver Artery flag ([2c3d27c9ee](https://github.com/InsightSoftwareConsortium/ITK/commit/2c3d27c9ee))


### Tabish Syed (1):

#### Bug Fixes

- Call Specialized Curvature Computation for 3D ([faccaa9681](https://github.com/InsightSoftwareConsortium/ITK/commit/faccaa9681))


### Thompson, Darren (IM&T, Clayton) (2):

#### Platform Fixes

- Removed constructor template parameters from the VNL library ([103ffa4372](https://github.com/InsightSoftwareConsortium/ITK/commit/103ffa4372))
- Removed constructor template parameters from itkSmapsFileParser ([867dda0585](https://github.com/InsightSoftwareConsortium/ITK/commit/867dda0585))


### Tom Birdsong (8):

#### Enhancements

- Add ITKVideoCore Python wrapping ([b31c5d4b73](https://github.com/InsightSoftwareConsortium/ITK/commit/b31c5d4b73))
- Add `float` wrappings for itkSymmetricSecondRankTensor ([11fbc6ecce](https://github.com/InsightSoftwareConsortium/ITK/commit/11fbc6ecce))
- Add wrappings for video IO ([ad6e718858](https://github.com/InsightSoftwareConsortium/ITK/commit/ad6e718858))
- Add ImageToVideoFilter and accompanying wrappings ([546ba05c37](https://github.com/InsightSoftwareConsortium/ITK/commit/546ba05c37))
- Add vector image support to VideoStream and ImageToVideoFilter ([9125fca8f8](https://github.com/InsightSoftwareConsortium/ITK/commit/9125fca8f8))
- Add `float` wrappings for itkSymmetricSecondRankTensor ([5378dae447](https://github.com/InsightSoftwareConsortium/ITK/commit/5378dae447))
- Wrap TransformToDisplacementField for Python ([f87c9bdaee](https://github.com/InsightSoftwareConsortium/ITK/commit/f87c9bdaee))

#### Bug Fixes

- Resolve warnings with MakeIndex and MakePoint ([7f1469270a](https://github.com/InsightSoftwareConsortium/ITK/commit/7f1469270a))


### VXL Maintainers (2):

#### Miscellaneous Changes

- VXL 2021-07-15 (d8888fd5) ([afa97fa43b](https://github.com/InsightSoftwareConsortium/ITK/commit/afa97fa43b))
- VXL 2021-07-19 (22f874db) ([82e8027330](https://github.com/InsightSoftwareConsortium/ITK/commit/82e8027330))


### Zlib-ng Upstream (1):

#### Miscellaneous Changes

- zlib-ng 2021-09-07 (547e8bc1) ([f0790950ed](https://github.com/InsightSoftwareConsortium/ITK/commit/f0790950ed))




ITK Sphinx Examples Changes Since v5.2.0
---------------------------------------------

### Brad T. Moore (2):

#### Enhancements

- Added ImageMomentsCalculator test and Jupyter example. ([25716277](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/25716277))
- Add CalculateImageMoments and fix cookiecutter and other issues. ([22f432f6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/22f432f6))


### Dženan Zukić (2):

#### Enhancements

- Update build-test-documentation to use v5.2.0 ([59473cb3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/59473cb3))

#### Style Changes

- Switch to the new code order: Python before C++ ([5db4da31](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5db4da31))


### Jose Tascon (5):

#### Style Changes

- Use itk::WriteImage in ScaleAnImage ([fe75959c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/fe75959c))
- Use itk::ReadImage and itk::WriteImage in src/Core examples ([9ab36963](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/9ab36963))
- Use itk::ReadImage and itk::WriteImage in src/Filtering examples ([6fa7e3c9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/6fa7e3c9))
- Use itk::ReadImage and itk::WriteImage in src/ Reg., Seg., Num. ([7ab88a63](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7ab88a63))
- Use itk::ReadImage and itk::WriteImage in remaining modules ([367b6b56](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/367b6b56))


### Kian Weimer (12):

#### Enhancements

- Added ThinImage Python script ([c1ca53f6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c1ca53f6))
- Added WriteAnImage Python script ([ce855854](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ce855854))
- Added RescaleIntensity Python script ([62407af0](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/62407af0))
- Added ApplyKernelToEveryPixel Python script ([473c1c27](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/473c1c27))
- Added missing Python licensing files ([8d0cf11e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8d0cf11e))
- Added ReadAnImage Python script ([35ca99d7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/35ca99d7))
- Added CombineTwoImagesWithCheckerBoardPattern Python script ([1a6ddb3f](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/1a6ddb3f))
- Added CreateAListOfFileNames Python script ([6918c50b](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/6918c50b))
- Added ComputeInverseFFTOfImage Python script ([1c1318bc](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/1c1318bc))
- Added SobelEdgeDetectionImageFilter Python script ([5e4adf5c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5e4adf5c))
- Added LaplacianRecursiveGaussianImageFilter Python script ([38987907](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/38987907))
- Modified most Python examples to make use of `argparse`. ([29857829](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/29857829))


### Lee Newberg (5):

#### Documentation Updates

- Indicate how to adjust resolution in ResampleAnImage ([896d48e2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/896d48e2))
- Add details for running CreateNewExample.py ([532ca008](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/532ca008))
- RescaleAnImage -> RescaleIntensity to clarify that it's not about size. ([a732d546](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a732d546))

#### Bug Fixes

- Fix continuous integration failure of ResampleAnImage ([66b8d2f0](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/66b8d2f0))

#### Style Changes

- Reformat Jupyter labs using jblack. ([6fb0e9c8](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/6fb0e9c8))


### Matt McCormick (15):

#### Enhancements

- Update ITK to v5.2.0 ([5377df13](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5377df13))
- Simplify ResampleAnImage output parameters ([e148246a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e148246a))
- Add Python version of RegisterImageToAnotherUsingLandmarks ([5f341060](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/5f341060))

#### Documentation Updates

- Install titlecase package for CreateNewExample.py script ([7489cce3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7489cce3))
- Update example Download link instructions ([c17864d3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c17864d3))
- Update build instructions for example .zip files ([249b93e9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/249b93e9))

#### Platform Fixes

- Make the Sphinx linkcheck optional ([7eae01a1](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/7eae01a1))

#### Bug Fixes

- Require itk>=5.2.0.post2 for notebook tests ([97c6e553](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/97c6e553))
- Tarball html output path when not built as a remote module ([f76dc431](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f76dc431))
- Fix download links ([635cbc75](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/635cbc75))
- Add ipython to Python environment for documentation build ([f6cbeb76](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f6cbeb76))
- Correct MutualInformationAffine output ([f5e029f2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f5e029f2))
- Transform SVG files in Sphinx ([0e0de5fb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0e0de5fb))
- Fix epub output path link in documentation ([0ca83aa3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0ca83aa3))

#### Style Changes

- Only output downloadable .zip archives for examples ([567b01c6](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/567b01c6))


### Stephen Aylward (4):

#### Bug Fixes

- CreateTarball assumes /src/ is unique in path ([37da5d6c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/37da5d6c))

#### Style Changes

- Reformatting CreateTarball.py to match lint ([e706163a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e706163a))
- Additional lint changes to CreateTarball.py ([d19ecc34](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d19ecc34))

#### Miscellaneous Changes

- Style: Fix remaining lint issues ([94d58947](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/94d58947))




ITK Software Guide Changes Since v5.2.0
---------------------------------------------

### Jon Haitz Legarreta Gorroño (3):

#### Documentation Updates

- Adapt enum section to strongly typed enums ([088a010](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/088a010))
- Add `long long` specifier C++ and mangling types ([cf51385](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/cf51385))

#### Style Changes

- Use `itkNameOfTestExecutableMacro` macro for test names ([e116243](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/e116243))


### Matt McCormick (3):

#### Enhancements

- Update ITK to v5.2.0 ([d5dab33](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/d5dab33))
- Update ITK version to 5.2.1 ([81c741c](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/81c741c))

#### Documentation Updates

- Correct signed long mangling and C++ variables ([1481a04](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/1481a04))


### Niels Dekker (2):

#### Enhancements

- Update compiler versions for C++14 ([80b8f89](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/80b8f89))
- Update Xcode Apple Clang compiler for nightly dashboard ([f65f786](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/f65f786))




Remote Module Changes Since v5.2.0
---------------------------------------------

## AdaptiveDenoising:
### Hans Johnson (1):

#### Platform Fixes

- Replace SetUseImageSpacingOn() with SetUseImageSpacing(true) ([a31fc7d](https://github.com/ntustison/ITKAdaptiveDenoising/commit/a31fc7d))



## AnisotropicDiffusionLBR:
### Matt McCormick (1):

#### Enhancements

- Update package for itk-5.2.0.post2 ([690cfa5](https://github.com/InsightSoftwareConsortium/ITKAnisotropicDiffusionLBR/commit/690cfa5))



## BSplineGradient:
### Dženan Zukić (1):

#### Enhancements

- Update CI to 5.2 ([85e38ff](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/85e38ff))


### Matt McCormick (1):

#### Enhancements

- Update package for itk-5.2.0.post2 ([a93687b](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/a93687b))


### Tom Birdsong (1):

#### Enhancements

- Update Python CI for ITK v5.2.0.post2 ([11e7430](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/11e7430))



## BoneEnhancement:
### Dženan Zukić (7):

#### Enhancements

- update CI to 5.2.0 ([b21721f](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/b21721f))

#### Platform Fixes

- Tests depend on GTest ([1b8f2b4](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/1b8f2b4))

#### Bug Fixes

- disable unit tests which fail on CI but not locally ([0faa86d](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/0faa86d))

#### Style Changes

- update style in the reverted code ([91217df](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/91217df))

#### Miscellaneous Changes

- Revert "ENH: Move itkHessianGaussianImageFilterTest to GTest" ([5b5e9d5](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/5b5e9d5))
- Revert "ENH: Move itkMaximumAbsoluteValueImageFilterTest to GTest" ([8f95864](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/8f95864))
- Revert "ENH: Move itkMultiScaleHessianEnhancementImageFilterStaticMethodsTest to GTest" ([0dd70c5](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/0dd70c5))


### Mathew Seng (1):

#### Platform Fixes

- updating CI to ITKv5.2RC3+ ([ece9d47](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/ece9d47))


### Tom Birdsong (1):

#### Enhancements

- Bump for ITK Python v5.2.0.post2 ([a36ab2f](https://github.com/InsightSoftwareConsortium/ITKBoneEnhancement/commit/a36ab2f))



## BoneMorphometry:
### Matt McCormick (1):

#### Enhancements

- Update package for itk-5.2.0.post2 ([10d3eb2](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry/commit/10d3eb2))



## Cuberille:
### Matt McCormick (1):

#### Enhancements

- Update CI for ITK v5.2.0 ([023878d](https://github.com/InsightSoftwareConsortium/ITKCuberille/commit/023878d))



## GrowCut:
### Dženan Zukić (6):

#### Enhancements

- use unsigned char as label type in wrapping ([debd1ac](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/debd1ac))
- update CI to 5.2.0.post3 ([bbc9938](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/bbc9938))
- big refactoring to follow Slicer's version ([777ba0e](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/777ba0e))
- Minor fixes to the build system ([eadab30](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/eadab30))
- bump version number to 0.1.2 ([713c468](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/713c468))

#### Bug Fixes

- re-introduce region padding radius ([e6e978a](https://github.com/InsightSoftwareConsortium/ITKGrowCut/commit/e6e978a))



## HASI:



## HigherOrderAccurateGradient:
### Dženan Zukić (1):

#### Enhancements

- Update CI to 5.2.0 ([c816e46](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/c816e46))


### Matt McCormick (1):

#### Enhancements

- Update package for itk-5.2.0.post2 ([03d1753](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/03d1753))


### Tom Birdsong (1):

#### Enhancements

- Update Python CI for ITK v5.2.0.post2 ([64ff5e5](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/64ff5e5))



## IOFDF:
### Matt McCormick (1):

#### Enhancements

- Update package for itk-5.2.0.post3 ([90e0ad6](https://github.com/InsightSoftwareConsortium/ITKIOFDF/commit/90e0ad6))



## IOScanco:
### Dženan Zukić (5):

#### Enhancements

- add support for writing metadata ([71c2511](https://github.com/KitwareMedical/ITKIOScanco/commit/71c2511))
- Compare the image with updated metadata ([80ea796](https://github.com/KitwareMedical/ITKIOScanco/commit/80ea796))
- Avoid re-scaling when image is converted to AIM format ([348ca2e](https://github.com/KitwareMedical/ITKIOScanco/commit/348ca2e))

#### Bug Fixes

- fix Windows packages CI path ([505976e](https://github.com/KitwareMedical/ITKIOScanco/commit/505976e))

#### Style Changes

- initialize the header fields in the order of declaration ([69e6de6](https://github.com/KitwareMedical/ITKIOScanco/commit/69e6de6))


### Matt McCormick (11):

#### Enhancements

- Update ITK to 5.2.0 ([3c5fbe0](https://github.com/KitwareMedical/ITKIOScanco/commit/3c5fbe0))
- Bump Python package version to 0.9.1 ([c02636b](https://github.com/KitwareMedical/ITKIOScanco/commit/c02636b))
- Add notebook CI testing configuration ([4854428](https://github.com/KitwareMedical/ITKIOScanco/commit/4854428))
- Update Binder requirements ([28dcd99](https://github.com/KitwareMedical/ITKIOScanco/commit/28dcd99))
- Update Binder itk-ioscanco requirement to 0.9.1 ([84e570b](https://github.com/KitwareMedical/ITKIOScanco/commit/84e570b))

#### Documentation Updates

- Add basic usage documentation to the README ([8b14461](https://github.com/KitwareMedical/ITKIOScanco/commit/8b14461))
- Update basic notebook ([cabe055](https://github.com/KitwareMedical/ITKIOScanco/commit/cabe055))
- Add Convert Scanco Volumes To Open Standard Formats example ([e416a5b](https://github.com/KitwareMedical/ITKIOScanco/commit/e416a5b))
- Remove Nifti from the formats notebook ([45f7c3a](https://github.com/KitwareMedical/ITKIOScanco/commit/45f7c3a))

#### Bug Fixes

- Update itk package requirement to 5.2.0 ([957ac6d](https://github.com/KitwareMedical/ITKIOScanco/commit/957ac6d))

#### Style Changes

- Move binder/ to .binder/ ([fb7c12f](https://github.com/KitwareMedical/ITKIOScanco/commit/fb7c12f))


### Michael Kuczynski (1):

#### Enhancements

- Apply rescaling to compressed images (#56) ([e585671](https://github.com/KitwareMedical/ITKIOScanco/commit/e585671))



## IsotropicWavelets:
### Dženan Zukić (3):

#### Enhancements

- Getting an up to date CI configuration v5.2.0.post3 ([f33b5e9](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/f33b5e9))
- enable building this module's examples as part of ITK's examples ([9d9ce5c](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/9d9ce5c))
- build examples as part of CI testing ([2549b15](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/2549b15))


### Pablo Hernandez-Cerdan (5):

#### Enhancements

- Add .editorconfig from ITKModuleTemplate ([07eea36](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/07eea36))
- Set RieszRotationMatrix ValueType to std::complex ([31c4d79](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/31c4d79))
- Add python wrappings for expand with zeros and decimate ([9469396](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/9469396))
- Python, wrap utilities free functions intro a struct ([3330ffe](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/3330ffe))

#### Miscellaneous Changes

- Style: Rename itkStructureTensor to itkStructureTensorImageFilter ([1c28ed0](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/1c28ed0))


### pranjal.sahu@kitware.com (3):

#### Miscellaneous Changes

- Adding the executables for two additional sample in CMake. One small function change as well. ([96b3a8e](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/96b3a8e))
- Correct way of setting the boundary condition ([67afc40](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/67afc40))
- Adding the header for itkConstantBoundaryCondition ([eed32b8](https://github.com/InsightSoftwareConsortium/ITKIsotropicWavelets/commit/eed32b8))



## MinimalPathExtraction:
### Matt McCormick (1):

#### Enhancements

- Update CI for ITK 5.2.0 ([2dc7ed8](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/2dc7ed8))



## Montage:
### Dženan Zukić (1):

#### Enhancements

- Update CI to 5.2.0 ([e2039b9](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/e2039b9))



## MorphologicalContourInterpolation:
### Dženan Zukić (1):

#### Enhancements

- Update CI to v5.2.0.post3 ([44854a4](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/44854a4))



## RTK:
### Antoine Robert (2):

#### Bug Fixes

- Fix attenuation correction of zeng projectors ([0b21f74f](https://github.com/SimonRit/RTK/commit/0b21f74f))
- Fix test for attenuated joseph forward projector ([d13d60b8](https://github.com/SimonRit/RTK/commit/d13d60b8))


### Lucas Gandel (1):

#### Platform Fixes

- Fix hardcoded path in RTK install ([42f0c5fc](https://github.com/SimonRit/RTK/commit/42f0c5fc))


### Simon Rit (16):

#### Enhancements

- Update CI to ITK v5.2.0 ([b65c6e3a](https://github.com/SimonRit/RTK/commit/b65c6e3a))
- wrap attenuated versions of Joseph forward and back projectors ([1d0bef5b](https://github.com/SimonRit/RTK/commit/1d0bef5b))
- Update GitHub Actions to checkout v2 ([a7158ef1](https://github.com/SimonRit/RTK/commit/a7158ef1))
- Build for itk-5.2.0.post3 ([0f93554a](https://github.com/SimonRit/RTK/commit/0f93554a))
- allow displaced detector weighting for 4D sinogram ([1c7b6656](https://github.com/SimonRit/RTK/commit/1c7b6656))

#### Platform Fixes

- Install newer Python for cookiecutter testing ([fe0d1f3d](https://github.com/SimonRit/RTK/commit/fe0d1f3d))
- remove warnings due to unused type and lambda capture ([835d4e3b](https://github.com/SimonRit/RTK/commit/835d4e3b))
- remove warnings due to the use of deprecated CUDA declarations ([184d0cad](https://github.com/SimonRit/RTK/commit/184d0cad))
- fix CMake CMP0106 witk RTK_BUILD_DOXYGEN ([6399e12a](https://github.com/SimonRit/RTK/commit/6399e12a))
- do not set C++ standard manually, use cmake property ([f66e98ac](https://github.com/SimonRit/RTK/commit/f66e98ac))
- clean and modernize CMake handling of CUDA compilation ([642ad254](https://github.com/SimonRit/RTK/commit/642ad254))
- add missing depedency of lib RTK to lib ITKCudaCommon ([4d288a55](https://github.com/SimonRit/RTK/commit/4d288a55))

#### Bug Fixes

- Do use use shallow version of checkout for clang format linting ([fea2a1c6](https://github.com/SimonRit/RTK/commit/fea2a1c6))
- unsigned int is already wrapped by ITK ([9401a38c](https://github.com/SimonRit/RTK/commit/9401a38c))
- fix joseph forward and backprojector with attenuation ([581f3b3f](https://github.com/SimonRit/RTK/commit/581f3b3f))
- fix wrapping of Joseph attenuated forward and backprojection ([0a77b542](https://github.com/SimonRit/RTK/commit/0a77b542))


### Tomoyuki SADAKANE (1):

#### Platform Fixes

- Fix compilation error with VS 2019 (16.9.5) and CUDA 11.1 ([3bd80190](https://github.com/SimonRit/RTK/commit/3bd80190))



## SimpleITKFilters:
### Bradley Lowekamp (8):

#### Miscellaneous Changes

- Update checkout version 2 ([83cc86d](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/83cc86d))
- Update to ITK tag v5.20 ([9450615](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/9450615))
- Update Ubuntu 20.04 ([4cd0a63](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/4cd0a63))
- Update used python version in setup ([8a7586c](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/8a7586c))
- Update setup.py version ([2ff7b07](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/2ff7b07))
- Add test case for report matrix with an INVALID orientation ([0a6d1bf](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/0a6d1bf))
- Update to greedy algorithm for determining closes orientation ([a728f6d](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/a728f6d))
- Fix CI to use Ubuntu 18.04 ([432d457](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/432d457))


### Mathew Seng (2):

#### Platform Fixes

- Update GitHub Actions from ITKModuleTemplate ([6917415](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/6917415))

#### Bug Fixes

- Incorrect expectations for tests ([be21024](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/be21024))



## SkullStrip:
### Matt McCormick (2):

#### Enhancements

- Update package for itk-5.2.0.post2 ([51fc9be](https://github.com/InsightSoftwareConsortium/ITKSkullStrip/commit/51fc9be))

#### Documentation Updates

- Add PyPI, License badges ([fcb84ce](https://github.com/InsightSoftwareConsortium/ITKSkullStrip/commit/fcb84ce))



## SplitComponents:
### Dženan Zukić (1):

#### Enhancements

- Update CI to 5.2.0 ([ff8b58d](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/ff8b58d))


### Matt McCormick (1):

#### Enhancements

- Update Python package for itk-5.2.0.post2 ([faea2f4](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/faea2f4))


### Tom Birdsong (1):

#### Enhancements

- Update Python CI for ITK v5.2.0.post2 ([58bde35](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/58bde35))



## Strain:
### Dženan Zukić (2):

#### Enhancements

- Update CI to 5.2.0 ([3bd13f1](https://github.com/KitwareMedical/ITKStrain/commit/3bd13f1))
- Update version number ([64e7d29](https://github.com/KitwareMedical/ITKStrain/commit/64e7d29))


### Matt McCormick (1):

#### Enhancements

- Update package version for itk-5.2.0.post2 ([892c54d](https://github.com/KitwareMedical/ITKStrain/commit/892c54d))


### Tom Birdsong (1):

#### Enhancements

- Update Python CI for ITK v5.2.0.post2 ([b09e3bd](https://github.com/KitwareMedical/ITKStrain/commit/b09e3bd))



## TextureFeatures:
### Matt McCormick (2):

#### Enhancements

- Update to ITK 5.2.0 ([dd60884](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures/commit/dd60884))
- Update Python packages for itk-5.2.0.post3 ([f3234bb](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures/commit/f3234bb))



## Thickness3D:
### Dženan Zukić (1):

#### Enhancements

- Update package versions to v5.2.0.post3 ([4f29b73](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/4f29b73))



## TotalVariation:
### Matt McCormick (1):

#### Enhancements

- Update package for itk-5.2.0.post2 ([9ac40a6](https://github.com/InsightSoftwareConsortium/ITKTotalVariation/commit/9ac40a6))



## TubeTK:
### Matt McCormick (1):

#### Enhancements

- Update for ITK 5.2.0.post2 (#56) ([9a93871e](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/9a93871e))


### Pablo Hernandez-Cerdan (1):

#### Documentation Updates

- Fix links and small typo in README (#53) ([ce024a88](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/ce024a88))


### Stephen Aylward (6):

#### Enhancements

- Make Applications available as examples. ([66c60ce4](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/66c60ce4))
- Update ConvertTubes demos ([3eb57bc9](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/3eb57bc9))
- Sphinx documentation for read-the-docs ([7b3a0a35](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/7b3a0a35))
- Add requirements.txt file for sphinx docs ([5288d615](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/5288d615))

#### Bug Fixes

- Update path in AtlasBuilder app ([6cba3508](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/6cba3508))
- Fix landmark registration to use versorrigid3dtransform ([8e236e38](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/8e236e38))


### Stephen R. Aylward (17):

#### Enhancements

- Tube path interpolation uses stepsize (max dist between interp pnts) (#61) ([f5524ca3](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/f5524ca3))
- Update README.md to point to proper license file ([fe0d22e9](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/fe0d22e9))
- Add sphinx_autodoc_typehints ([e0cecfa0](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/e0cecfa0))
- require sphinx_rtd_theme ([cf4e4fc5](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/cf4e4fc5))
- Upgrade readthedocs to use cpython3 (#73) ([59622ce2](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/59622ce2))
- Add apt-get update to remove stale repos ([1ad63f72](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/1ad63f72))
- Reduce list in requirements.txt to essential top-level ([ca5f67d9](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/ca5f67d9))
- numpy removed from setup.py ([b340c719](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/b340c719))

#### Platform Fixes

- Removed shadowed typedefs from tubeTubeMathFilters.hxx (#60) ([0abd1cfe](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/0abd1cfe))

#### Bug Fixes

- SlicerExecutionModel requires ITK_DIR (#59) ([a3853605](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/a3853605))
- SEM requires path for ITK_DIR for linux wheel building (#65) ([f8cae3ae](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/f8cae3ae))

#### Style Changes

- Remove year from copyright notice ([3be3736a](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/3be3736a))

#### Miscellaneous Changes

- Itk5.2.0 vtk2 (#55) ([9fd4c12d](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/9fd4c12d))
- Convert tubes to tube tree baseline (#62) ([dd6d95a5](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/dd6d95a5))
- v0.9.0 (#67) ([61f1156b](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/61f1156b))
- Update Readme.md ([48ac0028](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/48ac0028))
- Update Readme.md ([4a80fc80](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/4a80fc80))



## Ultrasound:
### Dženan Zukić (8):

#### Enhancements

- update CI to ITK v5.2.0 ([260de1d](https://github.com/KitwareMedical/ITKUltrasound/commit/260de1d))
- replace VectorResampleIdentityNeumann by ordinary Resample filter ([343afab](https://github.com/KitwareMedical/ITKUltrasound/commit/343afab))
- remove ResampleIdentityNeumannImageFilter ([7de39b3](https://github.com/KitwareMedical/ITKUltrasound/commit/7de39b3))
- Example notebook for Spectral generation and visualization ([2e4918c](https://github.com/KitwareMedical/ITKUltrasound/commit/2e4918c))
- add symbolic link to requirements.txt in .binder directory ([29937ee](https://github.com/KitwareMedical/ITKUltrasound/commit/29937ee))
- Set a longer cell execution timeout ([8ee4f97](https://github.com/KitwareMedical/ITKUltrasound/commit/8ee4f97))
- Cover all (Continuous)Index<->PhysicalPoint conversion signatures ([d5d9f41](https://github.com/KitwareMedical/ITKUltrasound/commit/d5d9f41))

#### Platform Fixes

- Fix CI. Closes #143. ([8c2a21f](https://github.com/KitwareMedical/ITKUltrasound/commit/8c2a21f))


### Lee Newberg (1):

#### Style Changes

- Add semicolons at end of macro invocations. ([1f3a06f](https://github.com/KitwareMedical/ITKUltrasound/commit/1f3a06f))


### Matt McCormick (4):

#### Enhancements

- Update Python package builds to v5.2.0.post1 ([bde69e7](https://github.com/KitwareMedical/ITKUltrasound/commit/bde69e7))
- Update package version to 0.4.0 ([ca5342c](https://github.com/KitwareMedical/ITKUltrasound/commit/ca5342c))
- Bump Python package builds for itk-v5.2.0.post3 ([7a796b0](https://github.com/KitwareMedical/ITKUltrasound/commit/7a796b0))

#### Bug Fixes

- Update Binder requirement to itk-ultrasound>=0.3.2 ([b4b30e0](https://github.com/KitwareMedical/ITKUltrasound/commit/b4b30e0))


### Tom Birdsong (7):

#### Enhancements

- Add wrapping files for forward and inverse 1D FFT filter ([581e97d](https://github.com/KitwareMedical/ITKUltrasound/commit/581e97d))
- Add analytic filter wrappings ([5429066](https://github.com/KitwareMedical/ITKUltrasound/commit/5429066))
- Add example for generating power spectral distribution plot ([3c8be0a](https://github.com/KitwareMedical/ITKUltrasound/commit/3c8be0a))
- Add descriptive comments to spectra filter files ([067677e](https://github.com/KitwareMedical/ITKUltrasound/commit/067677e))
- Add example notebook for BMode image generation steps ([a664fa3](https://github.com/KitwareMedical/ITKUltrasound/commit/a664fa3))
- Fix frequency axis in PlotPowerSpectra example notebook ([2f0a6f0](https://github.com/KitwareMedical/ITKUltrasound/commit/2f0a6f0))
- Add SRAD denoising filter with data and testing ([e1bcd9b](https://github.com/KitwareMedical/ITKUltrasound/commit/e1bcd9b))
