
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDateTime.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QDateTime>
#include <QCalendar>
#include <QDate>
#include <QTime>
#include <QTimeZone>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDateTime

//  Constructor QDateTime::QDateTime()


static void _init_ctor_QDateTime_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QDateTime> ();
}

static void _call_ctor_QDateTime_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDateTime *> (new QDateTime ());
}


//  Constructor QDateTime::QDateTime(QDate date, QTime time, Qt::TimeSpec spec, int offsetSeconds)


static void _init_ctor_QDateTime_3801 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("time");
  decl->add_arg<QTime > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("spec", true, "Qt::LocalTime");
  decl->add_arg<const qt_gsi::Converter<Qt::TimeSpec>::target_type & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("offsetSeconds", true, "0");
  decl->add_arg<int > (argspec_3);
  decl->set_return_new<QDateTime> ();
}

static void _call_ctor_QDateTime_3801 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  QTime arg2 = gsi::arg_reader<QTime >() (args, heap);
  const qt_gsi::Converter<Qt::TimeSpec>::target_type & arg3 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TimeSpec>(heap, Qt::LocalTime), heap);
  int arg4 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QDateTime *> (new QDateTime (arg1, arg2, qt_gsi::QtToCppAdaptor<Qt::TimeSpec>(arg3).cref(), arg4));
}


//  Constructor QDateTime::QDateTime(QDate date, QTime time, const QTimeZone &timeZone)


static void _init_ctor_QDateTime_3804 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("time");
  decl->add_arg<QTime > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("timeZone");
  decl->add_arg<const QTimeZone & > (argspec_2);
  decl->set_return_new<QDateTime> ();
}

static void _call_ctor_QDateTime_3804 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  QTime arg2 = gsi::arg_reader<QTime >() (args, heap);
  const QTimeZone &arg3 = gsi::arg_reader<const QTimeZone & >() (args, heap);
  ret.write<QDateTime *> (new QDateTime (arg1, arg2, arg3));
}


//  Constructor QDateTime::QDateTime(const QDateTime &other)


static void _init_ctor_QDateTime_2175 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return_new<QDateTime> ();
}

static void _call_ctor_QDateTime_2175 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  ret.write<QDateTime *> (new QDateTime (arg1));
}


// QDateTime QDateTime::addDays(qint64 days)


static void _init_f_addDays_c986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("days");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_addDays_c986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->addDays (arg1));
}


// QDateTime QDateTime::addMSecs(qint64 msecs)


static void _init_f_addMSecs_c986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_addMSecs_c986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->addMSecs (arg1));
}


// QDateTime QDateTime::addMonths(int months)


static void _init_f_addMonths_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("months");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_addMonths_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->addMonths (arg1));
}


// QDateTime QDateTime::addSecs(qint64 secs)


static void _init_f_addSecs_c986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("secs");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_addSecs_c986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->addSecs (arg1));
}


// QDateTime QDateTime::addYears(int years)


static void _init_f_addYears_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("years");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_addYears_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->addYears (arg1));
}


// QDate QDateTime::date()


static void _init_f_date_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_date_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDate > ((QDate)((QDateTime *)cls)->date ());
}


// qint64 QDateTime::daysTo(const QDateTime &)


static void _init_f_daysTo_c2175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<qint64 > ();
}

static void _call_f_daysTo_c2175 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  ret.write<qint64 > ((qint64)((QDateTime *)cls)->daysTo (arg1));
}


// bool QDateTime::isDaylightTime()


static void _init_f_isDaylightTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDaylightTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDateTime *)cls)->isDaylightTime ());
}


// bool QDateTime::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDateTime *)cls)->isNull ());
}


// bool QDateTime::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QDateTime *)cls)->isValid ());
}


// qint64 QDateTime::msecsTo(const QDateTime &)


static void _init_f_msecsTo_c2175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<qint64 > ();
}

static void _call_f_msecsTo_c2175 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  ret.write<qint64 > ((qint64)((QDateTime *)cls)->msecsTo (arg1));
}


// int QDateTime::offsetFromUtc()


static void _init_f_offsetFromUtc_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_offsetFromUtc_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QDateTime *)cls)->offsetFromUtc ());
}


// QDateTime &QDateTime::operator=(const QDateTime &other)


static void _init_f_operator_eq__2175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<QDateTime & > ();
}

static void _call_f_operator_eq__2175 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  ret.write<QDateTime & > ((QDateTime &)((QDateTime *)cls)->operator= (arg1));
}


// qint64 QDateTime::secsTo(const QDateTime &)


static void _init_f_secsTo_c2175 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDateTime & > (argspec_0);
  decl->set_return<qint64 > ();
}

static void _call_f_secsTo_c2175 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QDateTime &arg1 = gsi::arg_reader<const QDateTime & >() (args, heap);
  ret.write<qint64 > ((qint64)((QDateTime *)cls)->secsTo (arg1));
}


// void QDateTime::setDate(QDate date)


static void _init_f_setDate_899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<QDate > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDate_899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDate arg1 = gsi::arg_reader<QDate >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDateTime *)cls)->setDate (arg1);
}


// void QDateTime::setMSecsSinceEpoch(qint64 msecs)


static void _init_f_setMSecsSinceEpoch_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMSecsSinceEpoch_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDateTime *)cls)->setMSecsSinceEpoch (arg1);
}


// void QDateTime::setOffsetFromUtc(int offsetSeconds)


static void _init_f_setOffsetFromUtc_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offsetSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOffsetFromUtc_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDateTime *)cls)->setOffsetFromUtc (arg1);
}


// void QDateTime::setSecsSinceEpoch(qint64 secs)


static void _init_f_setSecsSinceEpoch_986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("secs");
  decl->add_arg<qint64 > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSecsSinceEpoch_986 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDateTime *)cls)->setSecsSinceEpoch (arg1);
}


// void QDateTime::setTime(QTime time)


static void _init_f_setTime_916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("time");
  decl->add_arg<QTime > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTime_916 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTime arg1 = gsi::arg_reader<QTime >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDateTime *)cls)->setTime (arg1);
}


// void QDateTime::setTimeSpec(Qt::TimeSpec spec)


static void _init_f_setTimeSpec_1543 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spec");
  decl->add_arg<const qt_gsi::Converter<Qt::TimeSpec>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTimeSpec_1543 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TimeSpec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDateTime *)cls)->setTimeSpec (qt_gsi::QtToCppAdaptor<Qt::TimeSpec>(arg1).cref());
}


// void QDateTime::setTimeZone(const QTimeZone &toZone)


static void _init_f_setTimeZone_2205 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toZone");
  decl->add_arg<const QTimeZone & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTimeZone_2205 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTimeZone &arg1 = gsi::arg_reader<const QTimeZone & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDateTime *)cls)->setTimeZone (arg1);
}


// void QDateTime::swap(QDateTime &other)


static void _init_f_swap_1480 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QDateTime & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_1480 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QDateTime &arg1 = gsi::arg_reader<QDateTime & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QDateTime *)cls)->swap (arg1);
}


// QTime QDateTime::time()


static void _init_f_time_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTime > ();
}

static void _call_f_time_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTime > ((QTime)((QDateTime *)cls)->time ());
}


// Qt::TimeSpec QDateTime::timeSpec()


static void _init_f_timeSpec_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::TimeSpec>::target_type > ();
}

static void _call_f_timeSpec_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<Qt::TimeSpec>::target_type > ((qt_gsi::Converter<Qt::TimeSpec>::target_type)qt_gsi::CppToQtAdaptor<Qt::TimeSpec>(((QDateTime *)cls)->timeSpec ()));
}


// QTimeZone QDateTime::timeZone()


static void _init_f_timeZone_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTimeZone > ();
}

static void _call_f_timeZone_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QTimeZone > ((QTimeZone)((QDateTime *)cls)->timeZone ());
}


// QString QDateTime::timeZoneAbbreviation()


static void _init_f_timeZoneAbbreviation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_timeZoneAbbreviation_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QDateTime *)cls)->timeZoneAbbreviation ());
}


// QDateTime QDateTime::toLocalTime()


static void _init_f_toLocalTime_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_toLocalTime_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->toLocalTime ());
}


// qint64 QDateTime::toMSecsSinceEpoch()


static void _init_f_toMSecsSinceEpoch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_toMSecsSinceEpoch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QDateTime *)cls)->toMSecsSinceEpoch ());
}


// QDateTime QDateTime::toOffsetFromUtc(int offsetSeconds)


static void _init_f_toOffsetFromUtc_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offsetSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_toOffsetFromUtc_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->toOffsetFromUtc (arg1));
}


// qint64 QDateTime::toSecsSinceEpoch()


static void _init_f_toSecsSinceEpoch_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_toSecsSinceEpoch_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QDateTime *)cls)->toSecsSinceEpoch ());
}


// QString QDateTime::toString(Qt::DateFormat format)


static void _init_f_toString_c1748 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "Qt::TextDate");
  decl->add_arg<const qt_gsi::Converter<Qt::DateFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c1748 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::DateFormat>::target_type & arg1 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::DateFormat>(heap, Qt::TextDate), heap);
  ret.write<QString > ((QString)((QDateTime *)cls)->toString (qt_gsi::QtToCppAdaptor<Qt::DateFormat>(arg1).cref()));
}


// QString QDateTime::toString(const QString &format, QCalendar cal)


static void _init_f_toString_c3228 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("cal", true, "QCalendar()");
  decl->add_arg<QCalendar > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3228 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QCalendar arg2 = args ? gsi::arg_reader<QCalendar >() (args, heap) : gsi::arg_maker<QCalendar >() (QCalendar(), heap);
  ret.write<QString > ((QString)((QDateTime *)cls)->toString (arg1, arg2));
}


// QDateTime QDateTime::toTimeSpec(Qt::TimeSpec spec)


static void _init_f_toTimeSpec_c1543 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spec");
  decl->add_arg<const qt_gsi::Converter<Qt::TimeSpec>::target_type & > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_toTimeSpec_c1543 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<Qt::TimeSpec>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->toTimeSpec (qt_gsi::QtToCppAdaptor<Qt::TimeSpec>(arg1).cref()));
}


// QDateTime QDateTime::toTimeZone(const QTimeZone &toZone)


static void _init_f_toTimeZone_c2205 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("toZone");
  decl->add_arg<const QTimeZone & > (argspec_0);
  decl->set_return<QDateTime > ();
}

static void _call_f_toTimeZone_c2205 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QTimeZone &arg1 = gsi::arg_reader<const QTimeZone & >() (args, heap);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->toTimeZone (arg1));
}


// QDateTime QDateTime::toUTC()


static void _init_f_toUTC_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_toUTC_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDateTime > ((QDateTime)((QDateTime *)cls)->toUTC ());
}


// static QDateTime QDateTime::currentDateTime()


static void _init_f_currentDateTime_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_currentDateTime_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDateTime > ((QDateTime)QDateTime::currentDateTime ());
}


// static QDateTime QDateTime::currentDateTimeUtc()


static void _init_f_currentDateTimeUtc_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDateTime > ();
}

static void _call_f_currentDateTimeUtc_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QDateTime > ((QDateTime)QDateTime::currentDateTimeUtc ());
}


// static qint64 QDateTime::currentMSecsSinceEpoch()


static void _init_f_currentMSecsSinceEpoch_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_currentMSecsSinceEpoch_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)QDateTime::currentMSecsSinceEpoch ());
}


// static qint64 QDateTime::currentSecsSinceEpoch()


static void _init_f_currentSecsSinceEpoch_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_currentSecsSinceEpoch_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)QDateTime::currentSecsSinceEpoch ());
}


// static QDateTime QDateTime::fromMSecsSinceEpoch(qint64 msecs, Qt::TimeSpec spec, int offsetFromUtc)


static void _init_f_fromMSecsSinceEpoch_3080 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<qint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("spec", true, "Qt::LocalTime");
  decl->add_arg<const qt_gsi::Converter<Qt::TimeSpec>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("offsetFromUtc", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QDateTime > ();
}

static void _call_f_fromMSecsSinceEpoch_3080 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  const qt_gsi::Converter<Qt::TimeSpec>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TimeSpec>(heap, Qt::LocalTime), heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QDateTime > ((QDateTime)QDateTime::fromMSecsSinceEpoch (arg1, qt_gsi::QtToCppAdaptor<Qt::TimeSpec>(arg2).cref(), arg3));
}


// static QDateTime QDateTime::fromMSecsSinceEpoch(qint64 msecs, const QTimeZone &timeZone)


static void _init_f_fromMSecsSinceEpoch_3083 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<qint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("timeZone");
  decl->add_arg<const QTimeZone & > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_fromMSecsSinceEpoch_3083 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  const QTimeZone &arg2 = gsi::arg_reader<const QTimeZone & >() (args, heap);
  ret.write<QDateTime > ((QDateTime)QDateTime::fromMSecsSinceEpoch (arg1, arg2));
}


// static QDateTime QDateTime::fromSecsSinceEpoch(qint64 secs, Qt::TimeSpec spec, int offsetFromUtc)


static void _init_f_fromSecsSinceEpoch_3080 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("secs");
  decl->add_arg<qint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("spec", true, "Qt::LocalTime");
  decl->add_arg<const qt_gsi::Converter<Qt::TimeSpec>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("offsetFromUtc", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QDateTime > ();
}

static void _call_f_fromSecsSinceEpoch_3080 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  const qt_gsi::Converter<Qt::TimeSpec>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::TimeSpec>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::TimeSpec>(heap, Qt::LocalTime), heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (0, heap);
  ret.write<QDateTime > ((QDateTime)QDateTime::fromSecsSinceEpoch (arg1, qt_gsi::QtToCppAdaptor<Qt::TimeSpec>(arg2).cref(), arg3));
}


// static QDateTime QDateTime::fromSecsSinceEpoch(qint64 secs, const QTimeZone &timeZone)


static void _init_f_fromSecsSinceEpoch_3083 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("secs");
  decl->add_arg<qint64 > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("timeZone");
  decl->add_arg<const QTimeZone & > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_fromSecsSinceEpoch_3083 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  qint64 arg1 = gsi::arg_reader<qint64 >() (args, heap);
  const QTimeZone &arg2 = gsi::arg_reader<const QTimeZone & >() (args, heap);
  ret.write<QDateTime > ((QDateTime)QDateTime::fromSecsSinceEpoch (arg1, arg2));
}


// static QDateTime QDateTime::fromString(const QString &string, Qt::DateFormat format)


static void _init_f_fromString_3665 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "Qt::TextDate");
  decl->add_arg<const qt_gsi::Converter<Qt::DateFormat>::target_type & > (argspec_1);
  decl->set_return<QDateTime > ();
}

static void _call_f_fromString_3665 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const qt_gsi::Converter<Qt::DateFormat>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<Qt::DateFormat>::target_type & >() (qt_gsi::CppToQtReadAdaptor<Qt::DateFormat>(heap, Qt::TextDate), heap);
  ret.write<QDateTime > ((QDateTime)QDateTime::fromString (arg1, qt_gsi::QtToCppAdaptor<Qt::DateFormat>(arg2).cref()));
}


// static QDateTime QDateTime::fromString(const QString &string, const QString &format, QCalendar cal)


static void _init_f_fromString_5145 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("string");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("cal", true, "QCalendar()");
  decl->add_arg<QCalendar > (argspec_2);
  decl->set_return<QDateTime > ();
}

static void _call_f_fromString_5145 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  QCalendar arg3 = args ? gsi::arg_reader<QCalendar >() (args, heap) : gsi::arg_maker<QCalendar >() (QCalendar(), heap);
  ret.write<QDateTime > ((QDateTime)QDateTime::fromString (arg1, arg2, arg3));
}



namespace gsi
{

static gsi::Methods methods_QDateTime () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDateTime::QDateTime()\nThis method creates an object of class QDateTime.", &_init_ctor_QDateTime_0, &_call_ctor_QDateTime_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDateTime::QDateTime(QDate date, QTime time, Qt::TimeSpec spec, int offsetSeconds)\nThis method creates an object of class QDateTime.", &_init_ctor_QDateTime_3801, &_call_ctor_QDateTime_3801);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDateTime::QDateTime(QDate date, QTime time, const QTimeZone &timeZone)\nThis method creates an object of class QDateTime.", &_init_ctor_QDateTime_3804, &_call_ctor_QDateTime_3804);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDateTime::QDateTime(const QDateTime &other)\nThis method creates an object of class QDateTime.", &_init_ctor_QDateTime_2175, &_call_ctor_QDateTime_2175);
  methods += new qt_gsi::GenericMethod ("addDays", "@brief Method QDateTime QDateTime::addDays(qint64 days)\n", true, &_init_f_addDays_c986, &_call_f_addDays_c986);
  methods += new qt_gsi::GenericMethod ("addMSecs", "@brief Method QDateTime QDateTime::addMSecs(qint64 msecs)\n", true, &_init_f_addMSecs_c986, &_call_f_addMSecs_c986);
  methods += new qt_gsi::GenericMethod ("addMonths", "@brief Method QDateTime QDateTime::addMonths(int months)\n", true, &_init_f_addMonths_c767, &_call_f_addMonths_c767);
  methods += new qt_gsi::GenericMethod ("addSecs", "@brief Method QDateTime QDateTime::addSecs(qint64 secs)\n", true, &_init_f_addSecs_c986, &_call_f_addSecs_c986);
  methods += new qt_gsi::GenericMethod ("addYears", "@brief Method QDateTime QDateTime::addYears(int years)\n", true, &_init_f_addYears_c767, &_call_f_addYears_c767);
  methods += new qt_gsi::GenericMethod (":date", "@brief Method QDate QDateTime::date()\n", true, &_init_f_date_c0, &_call_f_date_c0);
  methods += new qt_gsi::GenericMethod ("daysTo", "@brief Method qint64 QDateTime::daysTo(const QDateTime &)\n", true, &_init_f_daysTo_c2175, &_call_f_daysTo_c2175);
  methods += new qt_gsi::GenericMethod ("isDaylightTime?", "@brief Method bool QDateTime::isDaylightTime()\n", true, &_init_f_isDaylightTime_c0, &_call_f_isDaylightTime_c0);
  methods += new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QDateTime::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QDateTime::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("msecsTo", "@brief Method qint64 QDateTime::msecsTo(const QDateTime &)\n", true, &_init_f_msecsTo_c2175, &_call_f_msecsTo_c2175);
  methods += new qt_gsi::GenericMethod (":offsetFromUtc", "@brief Method int QDateTime::offsetFromUtc()\n", true, &_init_f_offsetFromUtc_c0, &_call_f_offsetFromUtc_c0);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QDateTime &QDateTime::operator=(const QDateTime &other)\n", false, &_init_f_operator_eq__2175, &_call_f_operator_eq__2175);
  methods += new qt_gsi::GenericMethod ("secsTo", "@brief Method qint64 QDateTime::secsTo(const QDateTime &)\n", true, &_init_f_secsTo_c2175, &_call_f_secsTo_c2175);
  methods += new qt_gsi::GenericMethod ("setDate|date=", "@brief Method void QDateTime::setDate(QDate date)\n", false, &_init_f_setDate_899, &_call_f_setDate_899);
  methods += new qt_gsi::GenericMethod ("setMSecsSinceEpoch", "@brief Method void QDateTime::setMSecsSinceEpoch(qint64 msecs)\n", false, &_init_f_setMSecsSinceEpoch_986, &_call_f_setMSecsSinceEpoch_986);
  methods += new qt_gsi::GenericMethod ("setOffsetFromUtc|offsetFromUtc=", "@brief Method void QDateTime::setOffsetFromUtc(int offsetSeconds)\n", false, &_init_f_setOffsetFromUtc_767, &_call_f_setOffsetFromUtc_767);
  methods += new qt_gsi::GenericMethod ("setSecsSinceEpoch", "@brief Method void QDateTime::setSecsSinceEpoch(qint64 secs)\n", false, &_init_f_setSecsSinceEpoch_986, &_call_f_setSecsSinceEpoch_986);
  methods += new qt_gsi::GenericMethod ("setTime|time=", "@brief Method void QDateTime::setTime(QTime time)\n", false, &_init_f_setTime_916, &_call_f_setTime_916);
  methods += new qt_gsi::GenericMethod ("setTimeSpec|timeSpec=", "@brief Method void QDateTime::setTimeSpec(Qt::TimeSpec spec)\n", false, &_init_f_setTimeSpec_1543, &_call_f_setTimeSpec_1543);
  methods += new qt_gsi::GenericMethod ("setTimeZone|timeZone=", "@brief Method void QDateTime::setTimeZone(const QTimeZone &toZone)\n", false, &_init_f_setTimeZone_2205, &_call_f_setTimeZone_2205);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QDateTime::swap(QDateTime &other)\n", false, &_init_f_swap_1480, &_call_f_swap_1480);
  methods += new qt_gsi::GenericMethod (":time", "@brief Method QTime QDateTime::time()\n", true, &_init_f_time_c0, &_call_f_time_c0);
  methods += new qt_gsi::GenericMethod (":timeSpec", "@brief Method Qt::TimeSpec QDateTime::timeSpec()\n", true, &_init_f_timeSpec_c0, &_call_f_timeSpec_c0);
  methods += new qt_gsi::GenericMethod (":timeZone", "@brief Method QTimeZone QDateTime::timeZone()\n", true, &_init_f_timeZone_c0, &_call_f_timeZone_c0);
  methods += new qt_gsi::GenericMethod ("timeZoneAbbreviation", "@brief Method QString QDateTime::timeZoneAbbreviation()\n", true, &_init_f_timeZoneAbbreviation_c0, &_call_f_timeZoneAbbreviation_c0);
  methods += new qt_gsi::GenericMethod ("toLocalTime", "@brief Method QDateTime QDateTime::toLocalTime()\n", true, &_init_f_toLocalTime_c0, &_call_f_toLocalTime_c0);
  methods += new qt_gsi::GenericMethod ("toMSecsSinceEpoch", "@brief Method qint64 QDateTime::toMSecsSinceEpoch()\n", true, &_init_f_toMSecsSinceEpoch_c0, &_call_f_toMSecsSinceEpoch_c0);
  methods += new qt_gsi::GenericMethod ("toOffsetFromUtc", "@brief Method QDateTime QDateTime::toOffsetFromUtc(int offsetSeconds)\n", true, &_init_f_toOffsetFromUtc_c767, &_call_f_toOffsetFromUtc_c767);
  methods += new qt_gsi::GenericMethod ("toSecsSinceEpoch", "@brief Method qint64 QDateTime::toSecsSinceEpoch()\n", true, &_init_f_toSecsSinceEpoch_c0, &_call_f_toSecsSinceEpoch_c0);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QDateTime::toString(Qt::DateFormat format)\n", true, &_init_f_toString_c1748, &_call_f_toString_c1748);
  methods += new qt_gsi::GenericMethod ("toString", "@brief Method QString QDateTime::toString(const QString &format, QCalendar cal)\n", true, &_init_f_toString_c3228, &_call_f_toString_c3228);
  methods += new qt_gsi::GenericMethod ("toTimeSpec", "@brief Method QDateTime QDateTime::toTimeSpec(Qt::TimeSpec spec)\n", true, &_init_f_toTimeSpec_c1543, &_call_f_toTimeSpec_c1543);
  methods += new qt_gsi::GenericMethod ("toTimeZone", "@brief Method QDateTime QDateTime::toTimeZone(const QTimeZone &toZone)\n", true, &_init_f_toTimeZone_c2205, &_call_f_toTimeZone_c2205);
  methods += new qt_gsi::GenericMethod ("toUTC", "@brief Method QDateTime QDateTime::toUTC()\n", true, &_init_f_toUTC_c0, &_call_f_toUTC_c0);
  methods += new qt_gsi::GenericStaticMethod ("currentDateTime", "@brief Static method QDateTime QDateTime::currentDateTime()\nThis method is static and can be called without an instance.", &_init_f_currentDateTime_0, &_call_f_currentDateTime_0);
  methods += new qt_gsi::GenericStaticMethod ("currentDateTimeUtc", "@brief Static method QDateTime QDateTime::currentDateTimeUtc()\nThis method is static and can be called without an instance.", &_init_f_currentDateTimeUtc_0, &_call_f_currentDateTimeUtc_0);
  methods += new qt_gsi::GenericStaticMethod ("currentMSecsSinceEpoch", "@brief Static method qint64 QDateTime::currentMSecsSinceEpoch()\nThis method is static and can be called without an instance.", &_init_f_currentMSecsSinceEpoch_0, &_call_f_currentMSecsSinceEpoch_0);
  methods += new qt_gsi::GenericStaticMethod ("currentSecsSinceEpoch", "@brief Static method qint64 QDateTime::currentSecsSinceEpoch()\nThis method is static and can be called without an instance.", &_init_f_currentSecsSinceEpoch_0, &_call_f_currentSecsSinceEpoch_0);
  methods += new qt_gsi::GenericStaticMethod ("fromMSecsSinceEpoch", "@brief Static method QDateTime QDateTime::fromMSecsSinceEpoch(qint64 msecs, Qt::TimeSpec spec, int offsetFromUtc)\nThis method is static and can be called without an instance.", &_init_f_fromMSecsSinceEpoch_3080, &_call_f_fromMSecsSinceEpoch_3080);
  methods += new qt_gsi::GenericStaticMethod ("fromMSecsSinceEpoch", "@brief Static method QDateTime QDateTime::fromMSecsSinceEpoch(qint64 msecs, const QTimeZone &timeZone)\nThis method is static and can be called without an instance.", &_init_f_fromMSecsSinceEpoch_3083, &_call_f_fromMSecsSinceEpoch_3083);
  methods += new qt_gsi::GenericStaticMethod ("fromSecsSinceEpoch", "@brief Static method QDateTime QDateTime::fromSecsSinceEpoch(qint64 secs, Qt::TimeSpec spec, int offsetFromUtc)\nThis method is static and can be called without an instance.", &_init_f_fromSecsSinceEpoch_3080, &_call_f_fromSecsSinceEpoch_3080);
  methods += new qt_gsi::GenericStaticMethod ("fromSecsSinceEpoch", "@brief Static method QDateTime QDateTime::fromSecsSinceEpoch(qint64 secs, const QTimeZone &timeZone)\nThis method is static and can be called without an instance.", &_init_f_fromSecsSinceEpoch_3083, &_call_f_fromSecsSinceEpoch_3083);
  methods += new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QDateTime QDateTime::fromString(const QString &string, Qt::DateFormat format)\nThis method is static and can be called without an instance.", &_init_f_fromString_3665, &_call_f_fromString_3665);
  methods += new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QDateTime QDateTime::fromString(const QString &string, const QString &format, QCalendar cal)\nThis method is static and can be called without an instance.", &_init_f_fromString_5145, &_call_f_fromString_5145);
  return methods;
}

gsi::Class<QDateTime> decl_QDateTime ("QtCore", "QDateTime",
  methods_QDateTime (),
  "@qt\n@brief Binding of QDateTime");


GSI_QTCORE_PUBLIC gsi::Class<QDateTime> &qtdecl_QDateTime () { return decl_QDateTime; }

}

