/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.util;

import java.util.Hashtable;

public abstract class XmlUtil {
    public static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
    public static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/XML/2000/xmlns/";
    public static final String XSLT_NAMESPACE_URI = "http://www.w3.org/1999/XSL/Transform";
    public static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/2001/XInclude";

    public static boolean isWhitespaceString(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c <= ' ' && (c == ' ' || c == '\t' || c == '\r' || c == '\n')) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespaceString(char[] cArray, int n, int n2) {
        for (int i = n + n2 - 1; i >= n; --i) {
            char c = cArray[i];
            if (c <= ' ' && (c == ' ' || c == '\t' || c == '\r' || c == '\n')) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public static boolean startsSurrogatePair(char c) {
        return c >= '\ud800' && c <= '\udbff';
    }

    public static boolean isNCNameStartChar(char c) {
        return Character.isLetter(c) || c == '_';
    }

    public static boolean isNCNameChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '.' || c == '-';
    }

    public static boolean isNCName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!XmlUtil.isNCNameStartChar(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (XmlUtil.isNCNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isQName(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return XmlUtil.isNCName(string);
        }
        if (n == 0 || n == string.length() - 1) {
            return false;
        }
        return XmlUtil.isNCName(string.substring(0, n)) && XmlUtil.isNCName(string.substring(n + 1));
    }

    public static String getLocalPart(String string) {
        int n = string.indexOf(58);
        return n == -1 ? string : string.substring(n + 1);
    }

    public static String getPrefix(String string) {
        int n = string.indexOf(58);
        return n == -1 ? null : string.substring(0, n);
    }

    public static Hashtable getPiPseudoAttributes(String string) {
        String string2;
        Hashtable<String, String> hashtable = new Hashtable<String, String>(10);
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf(61, n2 + 1)) != -1 && (string2 = string.substring(n2, n).trim()).length() != 0) {
            String string3 = null;
            for (int i = n + 1; i < string.length(); ++i) {
                int n3;
                char c = string.charAt(i);
                if (c != '\'' && c != '\"' || (n3 = string.indexOf(c, i + 1)) == -1) continue;
                string3 = string.substring(i + 1, n3);
                n2 = n3 + 1;
                break;
            }
            if (string3 == null) break;
            hashtable.put(string2, string3);
        }
        return hashtable;
    }
}

