/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

import java.util.List;
import java.util.Vector;

/**
 * This class uses tests the IteratorAdapter for proper behavior.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class IteratorAdapterTest
	extends junit.framework.TestCase
{
	public IteratorAdapterTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(IteratorAdapterTest.class);
	}

	public void testToList() 
		throws Exception
	{
		Vector v = new Vector();
		Vector v2 = new Vector();
		v.add("object");
		v.add("object1");
		v2.add("one");
		v2.add("two");
		v.add(v2);
		IteratorAdapter ia = new IteratorAdapter(v.iterator());
		List l = IteratorAdapter.toList(ia);
		assertTrue("Both equal", v.equals(l));
	}

	public void test() 
		throws Exception
	{
		Vector v = new Vector();
		v.add("object");
		v.add("object1");
		IteratorAdapter ia = new IteratorAdapter(v.iterator());
		assertEquals(ia.getIteratorType(), ParamIterator.ARRAY_ITERATOR);
		assertEquals(ia.hasNext(), true);
		assertEquals(ia.next(), "object");
		assertEquals(ia.next(), "object1");
		assertEquals(ia.hasNext(), false);
		ia.close();
		try {
			ia.next();
			fail("Should throw NullPointerException");
		} catch (Exception e) { }
	}
}
