/*
 *  @(#)ITFJUnitListener.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.autodoc.v1;

import junit.framework.Test;
import junit.framework.AssertionFailedError;

import net.sourceforge.groboutils.autodoc.v1.testserver.junit.JUnitTestListener;
import net.sourceforge.groboutils.autodoc.v1.testserver.TestData;

import org.apache.log4j.Logger;


/**
 * Listens to JUnit tests, and sends a report to the ITFServer via the
 * ITFBootstrap.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since      March 4, 2002
 * @version    $Date: 2003/02/10 22:51:56 $
 */
public class ITFJUnitListener extends JUnitTestListener
{
    private static final Logger LOG = Logger.getLogger( ITFJUnitListener.class );
    
    
    public ITFJUnitListener()
    {
        super( new ITFMonitorFinder() );
    }
    
    
    /**
     * Called before the test starts, and after the test has been registered.
     */
    protected void startTest( TestData data )
    {
        if (data != null)
        {
            ITFTestData itd = (ITFTestData)data;
            itd.setStartTime( System.currentTimeMillis() );
            itd.addTest();
        }
    }
    
    
    /**
     * Called after the test ends.  The implemented method must not send off
     * the data - that is done by the JUnitTestListener implementation.
     */
    protected void endTest( TestData data )
    {
        if (data != null)
        {
            ITFTestData itd = (ITFTestData)data;
            itd.setEndTime( System.currentTimeMillis() );
        }
    }

    
    
    /**
     * Called when the test in the data has an unexpected exception thrown.
     */
    protected void addError( TestData data, Throwable t )
    {
        if (data != null && t != null)
        {
            ITFTestData itd = (ITFTestData)data;
            itd.addError( t );
        }
    }

    
    
    /**
     * Called when the test in the data has an assertion error.
     */
    protected void addFailure( TestData data, AssertionFailedError t )
    {
        if (data != null && t != null)
        {
            ITFTestData itd = (ITFTestData)data;
            itd.addFailure( t );
        }
    }

}

