package org.jboss.cache.loader;

import org.jboss.cache.config.CacheLoaderConfig.IndividualCacheLoaderConfig;

import java.util.Properties;

public class AsyncCacheLoaderConfig extends IndividualCacheLoaderConfig
{
   /**
    * The serialVersionUID
    */
   private static final long serialVersionUID = 5038037589485991681L;

   private int batchSize = 100;
   private boolean returnOld = true;
   private int queueSize = 0;
   private boolean useAsyncPut = true;

   /**
    * Default constructor.
    */
   public AsyncCacheLoaderConfig()
   {
      setClassName(AsyncCacheLoader.class.getName());
   }

   /**
    * For use by {@link AsyncCacheLoader}.
    *
    * @param base generic config object created by XML parsing.
    */
   AsyncCacheLoaderConfig(IndividualCacheLoaderConfig base)
   {
      setClassName(AsyncCacheLoader.class.getName());
      populateFromBaseConfig(base);
   }

   public int getBatchSize()
   {
      return batchSize;
   }

   public void setBatchSize(int batchSize)
   {
      testImmutability("batchSize");
      this.batchSize = batchSize;
   }

   public int getQueueSize()
   {
      return queueSize;
   }

   public void setQueueSize(int queueSize)
   {
      testImmutability("queueSize");
      this.queueSize = queueSize;
   }

   public boolean getReturnOld()
   {
      return returnOld;
   }

   public void setReturnOld(boolean returnOld)
   {
      testImmutability("returnOld");
      this.returnOld = returnOld;
   }

   public boolean getUseAsyncPut()
   {
      return useAsyncPut;
   }

   public void setUseAsyncPut(boolean useAsyncPut)
   {
      testImmutability("useAsyncPut");
      this.useAsyncPut = useAsyncPut;
   }

   @Override
   public void setProperties(Properties props)
   {
      super.setProperties(props);
      String s;

      s = props.getProperty("cache.async.batchSize");
      if (s != null)
      {
         batchSize = Integer.parseInt(s);
      }
      if (batchSize <= 0)
      {
         throw new IllegalArgumentException("Invalid size: " + batchSize);
      }

      s = props.getProperty("cache.async.returnOld");
      if (s != null)
      {
         returnOld = Boolean.valueOf(s);
      }

      s = props.getProperty("cache.async.queueSize");
      if (s != null)
      {
         queueSize = Integer.parseInt(s);
      }

      s = props.getProperty("cache.async.put");
      if (s != null)
      {
         useAsyncPut = Boolean.valueOf(s);
      }
   }

   @Override
   public boolean equals(Object obj)
   {
      if (obj instanceof AsyncCacheLoaderConfig && equalsExcludingProperties(obj))
      {
         AsyncCacheLoaderConfig other = (AsyncCacheLoaderConfig) obj;
         return (batchSize == other.batchSize)
               && (queueSize == other.queueSize)
               && (returnOld == other.returnOld)
               && (useAsyncPut == other.useAsyncPut);
      }
      return false;
   }

   @Override
   public int hashCode()
   {
      int result = hashCodeExcludingProperties();
      result = 31 * result + batchSize;
      result = 31 * result + queueSize;
      result = 31 * result + (returnOld ? 0 : 1);
      result = 31 * result + (useAsyncPut ? 0 : 1);
      return result;
   }

   @Override
   public AsyncCacheLoaderConfig clone() throws CloneNotSupportedException
   {
      return (AsyncCacheLoaderConfig) super.clone();
   }


}