/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import static org.testng.AssertJUnit.assertEquals;
import static org.testng.AssertJUnit.assertTrue;

import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.xml.XmlHelper;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

/**
 * Unit tests for MRUConfiguration.
 *
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 4444 $
 */
@Test(groups = {"functional"})
public class MRUConfigurationTest
{
   MRUConfiguration config = null;

   @BeforeMethod(alwaysRun = true)
   public void setUp() throws Exception
   {
      config = new MRUConfiguration();
   }

   public void testXMLParsing() throws Exception
   {
      String xml =
            "<region name=\"/org/jboss/data\">\n" +
                  "<attribute name=\"maxNodes\">5000</attribute>\n" +
                  "</region>";
      Element element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(5000, config.getMaxNodes());
   }

   public void testXMLParsing2() throws Exception
   {
      String xml = "<region name=\"/Test/\">\n" +
            "<attribute name=\"maxNodes\">10000</attribute>\n" +
            "</region>";
      Element element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(10000, config.getMaxNodes());
   }

   public void testXMLParsing3() throws Exception
   {
      String xml = "<region name=\"/Test/\">\n" +
            "</region>";
      Element element = XmlHelper.stringToElement(xml);
      boolean caught = false;
      try
      {
         XmlConfigurationParser.parseEvictionPolicyConfig(element, config);
      }
      catch (ConfigurationException ce)
      {
         caught = true;
      }
      assertTrue("Configure exception should have been caught, maxNodes is required", caught);

      xml = "<region name=\"/Test/\">\n" +
            "<attribute name=\"maxNodes\">10000</attribute>\n" +
            "</region>";

      element = XmlHelper.stringToElement(xml);

      XmlConfigurationParser.parseEvictionPolicyConfig(element, config);

      assertEquals(10000, config.getMaxNodes());
   }

}
