// #include "osl/KingWalk.h"
#include "osl/move_generator/kingWalk.h"
#include "osl/move_action/store.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/move.h"
#include "osl/container/moveVector.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

#include <iostream>

using namespace osl;
using namespace osl::move_action;
using namespace osl::move_generator;

class KingWalkTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(KingWalkTest);
  CPPUNIT_TEST(testKingWalkSimple0);
  CPPUNIT_TEST_SUITE_END();
public:
  void testKingWalkSimple0()
  {
    NumEffectState state=CsaString(
      "P1 *  *  *  *  *  *  * -OU * \n"
      "P2 *  *  *  *  *  *  *  *  * \n"
      "P3 *  *  *  *  *  *  * +FU * \n"
      "P4 *  *  *  *  *  *  *  *  * \n"
      "P5 *  *  *  *  *  *  *  *  * \n"
      "P6 *  *  *  *  *  *  *  *  * \n"
      "P7 *  *  *  *  *  *  *  *  * \n"
      "P8 *  * +OU *  *  *  *  *  * \n"
      "P9 *  *  *  *  *  *  *  *  * \n"
      "P+00KI\n"
      "P-00AL\n"
      "-\n").getInitialState();
    {
      MoveVector moves;
      {
	Store store(moves);
	KingWalk<BLACK>::generate(state, store);
      }
      CPPUNIT_ASSERT(8u == moves.size());
    }

    {
      MoveVector moves;
      {
	Store store(moves);
	KingWalk<WHITE>::generate<>(state, store);
      }
      // 現在は自殺手は生成しない
      CPPUNIT_ASSERT(4u == moves.size());
    }
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(KingWalkTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
