# @file    TestSBMLNamespaces.rb
# @brief   SBMLNamespaces unit tests
#
# @author  Akiya Jouraku (Ruby conversion)
# @author  Sarah Keating 
#
#
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestSBMLNamespaces.cpp
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------
require 'test/unit'
require 'libSBML'

class TestSBMLNamespaces < Test::Unit::TestCase

  def test_SBMLNamespaces_L1V1
    sbml = LibSBML::SBMLNamespaces.new(1,1)
    assert( sbml.getLevel() == 1 )
    assert( sbml.getVersion() == 1 )
    ns = sbml.getNamespaces()
    assert( ns.getLength() == 1 )
    assert( ns.getURI(0) ==  "http://www.sbml.org/sbml/level1" )
    assert( ns.getPrefix(0) ==  "" )
    sbml = nil
  end

  def test_SBMLNamespaces_L1V2
    sbml = LibSBML::SBMLNamespaces.new(1,2)
    assert( sbml.getLevel() == 1 )
    assert( sbml.getVersion() == 2 )
    ns = sbml.getNamespaces()
    assert( ns.getLength() == 1 )
    assert( ns.getURI(0) ==  "http://www.sbml.org/sbml/level1" )
    assert( ns.getPrefix(0) ==  "" )
    sbml = nil
  end

  def test_SBMLNamespaces_L2V1
    sbml = LibSBML::SBMLNamespaces.new(2,1)
    assert( sbml.getLevel() == 2 )
    assert( sbml.getVersion() == 1 )
    ns = sbml.getNamespaces()
    assert( ns.getLength() == 1 )
    assert( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2" )
    assert( ns.getPrefix(0) ==  "" )
    sbml = nil
  end

  def test_SBMLNamespaces_L2V2
    sbml = LibSBML::SBMLNamespaces.new(2,2)
    assert( sbml.getLevel() == 2 )
    assert( sbml.getVersion() == 2 )
    ns = sbml.getNamespaces()
    assert( ns.getLength() == 1 )
    assert( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2/version2" )
    assert( ns.getPrefix(0) ==  "" )
    sbml = nil
  end

  def test_SBMLNamespaces_L2V3
    sbml = LibSBML::SBMLNamespaces.new(2,3)
    assert( sbml.getLevel() == 2 )
    assert( sbml.getVersion() == 3 )
    ns = sbml.getNamespaces()
    assert( ns.getLength() == 1 )
    assert( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2/version3" )
    assert( ns.getPrefix(0) ==  "" )
    sbml = nil
  end

  def test_SBMLNamespaces_L2V4
    sbml = LibSBML::SBMLNamespaces.new(2,4)
    assert( sbml.getLevel() == 2 )
    assert( sbml.getVersion() == 4 )
    ns = sbml.getNamespaces()
    assert( ns.getLength() == 1 )
    assert( ns.getURI(0) ==  "http://www.sbml.org/sbml/level2/version4" )
    assert( ns.getPrefix(0) ==  "" )
    sbml = nil
  end

  def test_SBMLNamespaces_L3V1
    sbml = LibSBML::SBMLNamespaces.new(3,1)
    assert( sbml.getLevel() == 3 )
    assert( sbml.getVersion() == 1 )
    ns = sbml.getNamespaces()
    assert( ns.getLength() == 1 )
    assert( ns.getURI(0) ==  "http://www.sbml.org/sbml/level3/version1/core" )
    assert( ns.getPrefix(0) ==  "" )
    sbml = nil
  end

  def test_SBMLNamespaces_add_and_remove_namespaces
    sbmlns = LibSBML::SBMLNamespaces.new( 3,1 )
    assert( sbmlns.getLevel() == 3 )
    assert( sbmlns.getVersion() == 1 )
    sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/group/version1",  "group")
    sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/layout/version1", "layout")
    sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/render/version1", "render")
    sbmlns.addNamespace("http://www.sbml.org/sbml/level3/version1/multi/version1",  "multi")
    ns = sbmlns.getNamespaces()
    assert( ns.getLength() == 5 )
    assert( ns.getURI(0) ==  "http://www.sbml.org/sbml/level3/version1/core" )
    assert( ns.getPrefix(0) ==  "" )
    assert( ns.getURI(1) ==  "http://www.sbml.org/sbml/level3/version1/group/version1" )
    assert( ns.getPrefix(1) ==  "group" )
    assert( ns.getURI(2) ==  "http://www.sbml.org/sbml/level3/version1/layout/version1" )
    assert( ns.getPrefix(2) ==  "layout" )
    assert( ns.getURI(3) ==  "http://www.sbml.org/sbml/level3/version1/render/version1" )
    assert( ns.getPrefix(3) ==  "render" )
    assert( ns.getURI(4) ==  "http://www.sbml.org/sbml/level3/version1/multi/version1" )
    assert( ns.getPrefix(4) ==  "multi" )
    sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/layout/version1")
    sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/group/version1")
    sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/render/version1")
    sbmlns.removeNamespace("http://www.sbml.org/sbml/level3/version1/multi/version1")
  end

  def test_SBMLNamespaces_getURI
    assert( LibSBML::SBMLNamespaces.getSBMLNamespaceURI(1,1) ==                              "http://www.sbml.org/sbml/level1" )
    assert( LibSBML::SBMLNamespaces.getSBMLNamespaceURI(1,2) ==                              "http://www.sbml.org/sbml/level1" )
    assert( LibSBML::SBMLNamespaces.getSBMLNamespaceURI(2,1) ==                              "http://www.sbml.org/sbml/level2" )
    assert( LibSBML::SBMLNamespaces.getSBMLNamespaceURI(2,2) ==                              "http://www.sbml.org/sbml/level2/version2" )
    assert( LibSBML::SBMLNamespaces.getSBMLNamespaceURI(2,3) ==                              "http://www.sbml.org/sbml/level2/version3" )
    assert( LibSBML::SBMLNamespaces.getSBMLNamespaceURI(2,4) ==                              "http://www.sbml.org/sbml/level2/version4" )
    assert( LibSBML::SBMLNamespaces.getSBMLNamespaceURI(3,1) ==                              "http://www.sbml.org/sbml/level3/version1/core" )
  end

end

