#
# @file    TestReadFromFile2.py
# @brief   Reads tests/l1v1-units.xml into memory and tests it.
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestReadFromFile2.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import unittest
import libsbml


class TestReadFromFile2(unittest.TestCase):


  def test_create_l1v1_units(self):
    d = libsbml.SBMLDocument()
    m = libsbml.Model(2,4)
    d.setModel(m)
    ud = m.createUnitDefinition()
    ud.setName( "substance")
    u = m.createUnit()
    u.setKind(libsbml.UNIT_KIND_MOLE)
    u.setScale(-3)
    ud = m.createUnitDefinition()
    ud.setName( "mls")
    u = m.createUnit()
    u.setKind(libsbml.UNIT_KIND_MOLE)
    u.setScale(-3)
    u = m.createUnit()
    u.setKind(libsbml.UNIT_KIND_LITER)
    u.setExponent(-1)
    u = m.createUnit()
    u.setKind(libsbml.UNIT_KIND_SECOND)
    u.setExponent(-1)
    c = m.createCompartment()
    c.setName( "cell")
    s = m.createSpecies()
    s.setName( "x0")
    s.setCompartment( "cell")
    s.setInitialAmount(1)
    s = m.createSpecies()
    s.setName( "x1")
    s.setCompartment( "cell")
    s.setInitialAmount(1)
    s = m.createSpecies()
    s.setName( "s1")
    s.setCompartment( "cell")
    s.setInitialAmount(1)
    s = m.createSpecies()
    s.setName( "s2")
    s.setCompartment( "cell")
    s.setInitialAmount(1)
    p = m.createParameter()
    p.setName( "vm")
    p.setUnits( "mls")
    p.setValue(2)
    p = m.createParameter()
    p.setName( "km")
    p.setValue(2)
    r = m.createReaction()
    r.setName( "v1")
    sr = m.createReactant()
    sr.setSpecies( "x0")
    sr = m.createProduct()
    sr.setSpecies( "s1")
    kl = m.createKineticLaw()
    kl.setFormula( "(vm * s1)/(km + s1)")
    r = m.createReaction()
    r.setName( "v2")
    sr = m.createReactant()
    sr.setSpecies( "s1")
    sr = m.createProduct()
    sr.setSpecies( "s2")
    kl = m.createKineticLaw()
    kl.setFormula( "(vm * s2)/(km + s2)")
    r = m.createReaction()
    r.setName( "v3")
    sr = m.createReactant()
    sr.setSpecies( "s2")
    sr = m.createProduct()
    sr.setSpecies( "x1")
    kl = m.createKineticLaw()
    kl.setFormula( "(vm * s1)/(km + s1)")
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_read_l1v1_units(self):
    filename = "../../sbml/test/test-data/l1v1-units.xml"
    d = libsbml.readSBML(filename)
    if (d == None):
      pass    
    self.assertTrue( d.getLevel() == 1 )
    self.assertTrue( d.getVersion() == 1 )
    m = d.getModel()
    self.assertTrue( m.getNumUnitDefinitions() == 2 )
    ud = m.getUnitDefinition(0)
    self.assertTrue((  "substance" == ud.getName() ))
    ud = m.getUnitDefinition(1)
    self.assertTrue((  "mls" == ud.getName() ))
    ud = m.getUnitDefinition(0)
    self.assertTrue( ud.getNumUnits() == 1 )
    u = ud.getUnit(0)
    self.assertTrue( u.getKind() == libsbml.UNIT_KIND_MOLE )
    self.assertTrue( u.getExponent() == 1 )
    self.assertTrue( u.getScale() == -3 )
    ud = m.getUnitDefinition(1)
    self.assertTrue( ud.getNumUnits() == 3 )
    u = ud.getUnit(0)
    self.assertTrue( u.getKind() == libsbml.UNIT_KIND_MOLE )
    self.assertTrue( u.getExponent() == 1 )
    self.assertTrue( u.getScale() == -3 )
    u = ud.getUnit(1)
    self.assertTrue( u.getKind() == libsbml.UNIT_KIND_LITER )
    self.assertTrue( u.getExponent() == -1 )
    self.assertTrue( u.getScale() == 0 )
    u = ud.getUnit(2)
    self.assertTrue( u.getKind() == libsbml.UNIT_KIND_SECOND )
    self.assertTrue( u.getExponent() == -1 )
    self.assertTrue( u.getScale() == 0 )
    self.assertTrue( m.getNumCompartments() == 1 )
    c = m.getCompartment(0)
    self.assertTrue((  "cell" == c.getName() ))
    self.assertTrue( m.getNumSpecies() == 4 )
    s = m.getSpecies(0)
    self.assertTrue((  "x0"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 1 )
    self.assertTrue( s.getBoundaryCondition() == False )
    ud = s.getDerivedUnitDefinition()
    self.assertTrue( ud.getNumUnits() == 2 )
    self.assertTrue( ud.getUnit(0).getKind() == libsbml.UNIT_KIND_MOLE )
    self.assertTrue( ud.getUnit(0).getExponent() == 1 )
    self.assertTrue( ud.getUnit(0).getScale() == -3 )
    self.assertTrue( ud.getUnit(1).getKind() == libsbml.UNIT_KIND_LITRE )
    self.assertTrue( ud.getUnit(1).getExponent() == -1 )
    s = m.getSpecies(1)
    self.assertTrue((  "x1"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 1 )
    self.assertTrue( s.getBoundaryCondition() == False )
    s = m.getSpecies(2)
    self.assertTrue((  "s1"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 1 )
    self.assertTrue( s.getBoundaryCondition() == False )
    s = m.getSpecies(3)
    self.assertTrue((  "s2"    == s.getName() ))
    self.assertTrue((  "cell"  == s.getCompartment() ))
    self.assertTrue( s.getInitialAmount() == 1 )
    self.assertTrue( s.getBoundaryCondition() == False )
    self.assertTrue( m.getNumParameters() == 2 )
    p = m.getParameter(0)
    self.assertTrue((  "vm"   == p.getName() ))
    self.assertTrue((  "mls"  == p.getUnits() ))
    self.assertTrue( p.getValue() == 2 )
    ud = p.getDerivedUnitDefinition()
    self.assertTrue( ud.getNumUnits() == 3 )
    self.assertTrue( ud.getUnit(0).getKind() == libsbml.UNIT_KIND_MOLE )
    self.assertTrue( ud.getUnit(0).getExponent() == 1 )
    self.assertTrue( ud.getUnit(0).getScale() == -3 )
    self.assertTrue( ud.getUnit(1).getKind() == libsbml.UNIT_KIND_LITER )
    self.assertTrue( ud.getUnit(1).getExponent() == -1 )
    self.assertTrue( ud.getUnit(2).getKind() == libsbml.UNIT_KIND_SECOND )
    self.assertTrue( ud.getUnit(2).getExponent() == -1 )
    p = m.getParameter(1)
    self.assertTrue((  "km"   == p.getName() ))
    self.assertTrue( p.getValue() == 2 )
    ud = p.getDerivedUnitDefinition()
    self.assertTrue( ud.getNumUnits() == 0 )
    self.assertTrue( m.getNumReactions() == 3 )
    r = m.getReaction(0)
    self.assertTrue((  "v1" == r.getName() ))
    self.assertTrue( r.getReversible() != False )
    self.assertTrue( r.getFast() == False )
    r = m.getReaction(1)
    self.assertTrue((  "v2" == r.getName() ))
    self.assertTrue( r.getReversible() != False )
    self.assertTrue( r.getFast() == False )
    r = m.getReaction(2)
    self.assertTrue((  "v3" == r.getName() ))
    self.assertTrue( r.getReversible() != False )
    self.assertTrue( r.getFast() == False )
    r = m.getReaction(0)
    self.assertTrue( r.getNumReactants() == 1 )
    self.assertTrue( r.getNumProducts() == 1 )
    sr = r.getReactant(0)
    self.assertTrue((  "x0" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    sr = r.getProduct(0)
    self.assertTrue((  "s1" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    kl = r.getKineticLaw()
    self.assertTrue((  "cell * (vm * s1)/(km + s1)" == kl.getFormula() ))
    r = m.getReaction(1)
    self.assertTrue( r.getNumReactants() == 1 )
    self.assertTrue( r.getNumProducts() == 1 )
    sr = r.getReactant(0)
    self.assertTrue((  "s1" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    sr = r.getProduct(0)
    self.assertTrue((  "s2" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    kl = r.getKineticLaw()
    self.assertTrue((  "cell * (vm * s2)/(km + s2)" == kl.getFormula() ))
    r = m.getReaction(2)
    self.assertTrue( r.getNumReactants() == 1 )
    self.assertTrue( r.getNumProducts() == 1 )
    sr = r.getReactant(0)
    self.assertTrue((  "s2" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    sr = r.getProduct(0)
    self.assertTrue((  "x1" == sr.getSpecies() ))
    self.assertTrue( sr.getStoichiometry() == 1 )
    self.assertTrue( sr.getDenominator() == 1 )
    kl = r.getKineticLaw()
    self.assertTrue((  "cell * (vm * s1)/(km + s1)" == kl.getFormula() ))
    _dummyList = [ d ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestReadFromFile2))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)

