/* Copyright (C) 2002 Free Software Foundation, Inc.
   Written by Mark Wielaard (mark@klomp.org)

   This file is part of Mauve.

   Mauve is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Mauve is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Mauve; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

// Tags: JDK1.2

package gnu.testlet.java.util.ArrayList;
import gnu.testlet.Testlet;
import gnu.testlet.TestHarness;

import java.io.*;
import java.util.*;

/**
 * Tests serializable form. New .ser files can be generated by calling
 * the main() method.
 */
public class serial implements Testlet
{

  public void test (TestHarness harness)
  {
    try
      {
	// Self test
	ByteArrayOutputStream baos = new ByteArrayOutputStream();
	ObjectOutputStream oos = new ObjectOutputStream(baos);
	ArrayList[] array = getArrayListArray();
	
	oos.writeObject(array);
	oos.close();

	byte[] bs = baos.toByteArray();
	ByteArrayInputStream bois = new ByteArrayInputStream(bs);
	ObjectInputStream ois = new ObjectInputStream(bois);
	Object o = ois.readObject();
	array = (ArrayList[]) o;
	harness.check(Arrays.equals(array, getArrayListArray()));
	
	ois.close();
	
	// Pre generated test
	String ser = "gnu#testlet#java#util#ArrayList#ArrayList.ser";
	InputStream is = harness.getResourceStream(ser);
	ois = new ObjectInputStream(is);
	o = ois.readObject();
	array = (ArrayList[]) o;
	harness.check(Arrays.equals(array, getArrayListArray()));

	ois.close();
	is.close();
      }
    catch (Throwable t)
      {
	harness.check(false);
	harness.debug(t);
      }
  }

  /**
   * Creates an array of ArrayLists.
   */
  static ArrayList[] getArrayListArray() {
    ArrayList[] array = new ArrayList[5];
    
    ArrayList al = new ArrayList();

    ArrayList empty = (ArrayList) al.clone();
    array[0] = empty;
    array[4] = empty;
    
    al.add(new Integer(1));
    
    ArrayList one = (ArrayList) al.clone();
    array[1] = one;
    
    for (int i = 2; i <= 32; i++)
      al.add(new Integer(i));
    ArrayList list32 = (ArrayList) al.clone();
    array[2] = list32;
    
    for (int i = 0; i < 20; i++)
      al.remove(4);
    array[3] = al;
    
    return array;
  }

  public static void main(String[] args) throws Exception
  {
    String filename = "ArrayListSerial.ser";
    OutputStream os = new FileOutputStream(filename);
    ObjectOutputStream oos = new ObjectOutputStream(os);
    ArrayList[] array = getArrayListArray();

    oos.writeObject(array);
    oos.close();
    os.close();

  }
}
