macro(to_yes_no vars)
  foreach(var ${ARGV})
    if(${var})
      set(${var} "yes")
    else()
      set(${var} "no ")
    endif()
  endforeach()
endmacro()

macro(if_empty_print_missing vars)
  foreach(var ${ARGV})
    if(NOT ${var})
      set(${var} "<not set>")
    endif()
  endforeach()
endmacro()

function(to_space_list sc_list)
    set(ret)
    foreach(val ${${sc_list}})
        set(ret "${ret} ${val}")
    endforeach()
    if(ret)
        string(STRIP ${ret} ret)
        set(${sc_list} "${ret}" PARENT_SCOPE)
    endif()
endfunction()

macro(find_pkg_config prefix pkgname)
    find_package(PkgConfig ${ARGV2})
    if(PKG_CONFIG_FOUND)
        pkg_check_modules(${prefix}_PKGCONF ${ARGV2} ${pkgname})
        if(${${prefix}_PKGCONF_FOUND})
            message(STATUS "${pkgname} library dirs: ${${prefix}_PKGCONF_LIBRARY_DIRS}")
            message(STATUS "${pkgname} cflags: ${${prefix}_PKGCONF_CFLAGS_OTHER}")
            message(STATUS "${pkgname} include dirs: ${${prefix}_PKGCONF_INCLUDE_DIRS}")
            message(STATUS "${pkgname} libraries: ${${prefix}_PKGCONF_LIBRARIES}")
            message(STATUS "${pkgname} ldflags: ${${prefix}_PKGCONF_LDFLAGS_OTHER}")

            set(${prefix}_FOUND ${${prefix}_PKGCONF_FOUND})
            set(${prefix}_CFLAGS ${${prefix}_PKGCONF_CFLAGS_OTHER})
            to_space_list(${prefix}_CFLAGS)
            set(${prefix}_INCLUDE_DIRS ${${prefix}_PKGCONF_INCLUDE_DIRS})
            foreach(lib ${${prefix}_PKGCONF_LIBRARIES})
                string(TOUPPER ${lib} LIB)
                find_library(${prefix}_${LIB}_LIBRARY ${lib}
                    HINTS ${${prefix}_PKGCONF_LIBRARY_DIRS})
                mark_as_advanced(${prefix}_${LIB}_LIBRARY)
                list(APPEND ${prefix}_LIBRARIES ${${prefix}_${LIB}_LIBRARY})
            endforeach()
            list(APPEND ${prefix}_LIBRARIES ${${prefix}_PKGCONF_LDFLAGS_OTHER})
        endif()
    endif()
endmacro()
