/*  $Id: ecnum_specific.inc 656068 2022-09-14 12:55:11Z fukanchi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  The Enzyme Commission
 *
 * File Description:
 *   Built-in copy of ecnum_specific.txt.
 *
 */

static const char* const kECNum_specific[] = {
    "1.1.1.1\talcohol dehydrogenase",
    "1.1.1.2\talcohol dehydrogenase (NADP(+))",
    "1.1.1.3\thomoserine dehydrogenase",
    "1.1.1.4\t(R,R)-butanediol dehydrogenase",
    "1.1.1.6\tglycerol dehydrogenase",
    "1.1.1.7\tpropanediol-phosphate dehydrogenase",
    "1.1.1.8\tglycerol-3-phosphate dehydrogenase (NAD(+))",
    "1.1.1.9\tD-xylulose reductase",
    "1.1.1.10\tL-xylulose reductase",
    "1.1.1.11\tD-arabinitol 4-dehydrogenase",
    "1.1.1.12\tL-arabinitol 4-dehydrogenase",
    "1.1.1.13\tL-arabinitol 2-dehydrogenase",
    "1.1.1.14\tL-iditol 2-dehydrogenase",
    "1.1.1.15\tD-iditol 2-dehydrogenase",
    "1.1.1.16\tgalactitol 2-dehydrogenase",
    "1.1.1.17\tmannitol-1-phosphate 5-dehydrogenase",
    "1.1.1.18\tinositol 2-dehydrogenase",
    "1.1.1.19\tglucuronate reductase",
    "1.1.1.20\tglucuronolactone reductase",
    "1.1.1.21\taldose reductase",
    "1.1.1.22\tUDP-glucose 6-dehydrogenase",
    "1.1.1.23\thistidinol dehydrogenase",
    "1.1.1.24\tquinate/shikimate dehydrogenase (NAD(+))",
    "1.1.1.25\tshikimate dehydrogenase (NADP(+))",
    "1.1.1.26\tglyoxylate reductase",
    "1.1.1.27\tL-lactate dehydrogenase",
    "1.1.1.28\tD-lactate dehydrogenase",
    "1.1.1.29\tglycerate dehydrogenase",
    "1.1.1.30\t3-hydroxybutyrate dehydrogenase",
    "1.1.1.31\t3-hydroxyisobutyrate dehydrogenase",
    "1.1.1.32\tmevaldate reductase",
    "1.1.1.33\tmevaldate reductase (NADPH)",
    "1.1.1.34\thydroxymethylglutaryl-CoA reductase (NADPH)",
    "1.1.1.35\t3-hydroxyacyl-CoA dehydrogenase",
    "1.1.1.36\tacetoacetyl-CoA reductase",
    "1.1.1.37\tmalate dehydrogenase",
    "1.1.1.38\tmalate dehydrogenase (oxaloacetate-decarboxylating)",
    "1.1.1.39\tmalate dehydrogenase (decarboxylating)",
    "1.1.1.40\tmalate dehydrogenase (oxaloacetate-decarboxylating) (NADP(+))",
    "1.1.1.41\tisocitrate dehydrogenase (NAD(+))",
    "1.1.1.42\tisocitrate dehydrogenase (NADP(+))",
    "1.1.1.43\tphosphogluconate 2-dehydrogenase",
    "1.1.1.44\tphosphogluconate dehydrogenase (NADP(+)-dependent, decarboxylating)",
    "1.1.1.45\tL-gulonate 3-dehydrogenase",
    "1.1.1.46\tL-arabinose 1-dehydrogenase",
    "1.1.1.47\tglucose 1-dehydrogenase [NAD(P)(+)]",
    "1.1.1.48\tD-galactose 1-dehydrogenase",
    "1.1.1.49\tglucose-6-phosphate dehydrogenase (NADP(+))",
    "1.1.1.50\t3alpha-hydroxysteroid 3-dehydrogenase (Si-specific)",
    "1.1.1.51\t3(or 17)beta-hydroxysteroid dehydrogenase",
    "1.1.1.52\t3alpha-hydroxycholanate dehydrogenase (NAD(+))",
    "1.1.1.53\t3alpha(or 20beta)-hydroxysteroid dehydrogenase",
    "1.1.1.54\tallyl-alcohol dehydrogenase",
    "1.1.1.55\tlactaldehyde reductase (NADPH)",
    "1.1.1.56\tribitol 2-dehydrogenase",
    "1.1.1.57\tfructuronate reductase",
    "1.1.1.58\ttagaturonate reductase",
    "1.1.1.59\t3-hydroxypropionate dehydrogenase",
    "1.1.1.60\t2-hydroxy-3-oxopropionate reductase",
    "1.1.1.61\t4-hydroxybutyrate dehydrogenase",
    "1.1.1.62\t17beta-estradiol 17-dehydrogenase",
    "1.1.1.64\ttestosterone 17beta-dehydrogenase (NADP(+))",
    "1.1.1.65\tpyridoxine 4-dehydrogenase",
    "1.1.1.66\tomega-hydroxydecanoate dehydrogenase",
    "1.1.1.67\tmannitol 2-dehydrogenase",
    "1.1.1.69\tgluconate 5-dehydrogenase",
    "1.1.1.71\talcohol dehydrogenase [NAD(P)(+)]",
    "1.1.1.72\tglycerol dehydrogenase (NADP(+))",
    "1.1.1.73\toctanol dehydrogenase",
    "1.1.1.75\t(R)-aminopropanol dehydrogenase",
    "1.1.1.76\t(S,S)-butanediol dehydrogenase",
    "1.1.1.77\tlactaldehyde reductase",
    "1.1.1.78\tmethylglyoxal reductase (NADH)",
    "1.1.1.79\tglyoxylate reductase (NADP(+))",
    "1.1.1.80\tisopropanol dehydrogenase (NADP(+))",
    "1.1.1.81\thydroxypyruvate reductase",
    "1.1.1.82\tmalate dehydrogenase (NADP(+))",
    "1.1.1.83\tD-malate dehydrogenase (decarboxylating)",
    "1.1.1.84\tdimethylmalate dehydrogenase",
    "1.1.1.85\t3-isopropylmalate dehydrogenase",
    "1.1.1.86\tketol-acid reductoisomerase (NADP(+))",
    "1.1.1.87\thomoisocitrate dehydrogenase",
    "1.1.1.88\thydroxymethylglutaryl-CoA reductase",
    "1.1.1.90\taryl-alcohol dehydrogenase",
    "1.1.1.91\taryl-alcohol dehydrogenase (NADP(+))",
    "1.1.1.92\toxaloglycolate reductase (decarboxylating)",
    "1.1.1.93\ttartrate dehydrogenase",
    "1.1.1.94\tglycerol-3-phosphate dehydrogenase [NAD(P)(+)]",
    "1.1.1.95\tphosphoglycerate dehydrogenase",
    "1.1.1.96\tdiiodophenylpyruvate reductase",
    "1.1.1.97\t3-hydroxybenzyl-alcohol dehydrogenase",
    "1.1.1.98\t(R)-2-hydroxy-fatty-acid dehydrogenase",
    "1.1.1.99\t(S)-2-hydroxy-fatty-acid dehydrogenase",
    "1.1.1.100\t3-oxoacyl-[acyl-carrier-protein] reductase",
    "1.1.1.101\tacylglycerone-phosphate reductase",
    "1.1.1.102\t3-dehydrosphinganine reductase",
    "1.1.1.103\tL-threonine 3-dehydrogenase",
    "1.1.1.104\t4-oxoproline reductase",
    "1.1.1.105\tall-trans-retinol dehydrogenase (NAD(+))",
    "1.1.1.106\tpantoate 4-dehydrogenase",
    "1.1.1.107\tpyridoxal 4-dehydrogenase",
    "1.1.1.108\tcarnitine 3-dehydrogenase",
    "1.1.1.110\taromatic 2-oxoacid reductase",
    "1.1.1.111\t3-(imidazol-5-yl)lactate dehydrogenase",
    "1.1.1.112\tindanol dehydrogenase",
    "1.1.1.113\tL-xylose 1-dehydrogenase",
    "1.1.1.114\tapiose 1-reductase",
    "1.1.1.115\tribose 1-dehydrogenase (NADP(+))",
    "1.1.1.116\tD-arabinose 1-dehydrogenase (NAD(+))",
    "1.1.1.117\tD-arabinose 1-dehydrogenase [NAD(P)(+)]",
    "1.1.1.118\tglucose 1-dehydrogenase (NAD(+))",
    "1.1.1.119\tglucose 1-dehydrogenase (NADP(+))",
    "1.1.1.120\tgalactose 1-dehydrogenase (NADP(+))",
    "1.1.1.121\taldose 1-dehydrogenase (NAD(+))",
    "1.1.1.122\tD-threo-aldose 1-dehydrogenase",
    "1.1.1.123\tsorbose 5-dehydrogenase (NADP(+))",
    "1.1.1.124\tfructose 5-dehydrogenase (NADP(+))",
    "1.1.1.125\t2-deoxy-D-gluconate 3-dehydrogenase",
    "1.1.1.126\t2-dehydro-3-deoxy-D-gluconate 6-dehydrogenase",
    "1.1.1.127\t2-dehydro-3-deoxy-D-gluconate 5-dehydrogenase",
    "1.1.1.129\tL-threonate 3-dehydrogenase",
    "1.1.1.130\t3-dehydro-L-gulonate 2-dehydrogenase",
    "1.1.1.131\tmannuronate reductase",
    "1.1.1.132\tGDP-mannose 6-dehydrogenase",
    "1.1.1.133\tdTDP-4-dehydrorhamnose reductase",
    "1.1.1.134\tdTDP-6-deoxy-L-talose 4-dehydrogenase",
    "1.1.1.135\tGDP-6-deoxy-D-talose 4-dehydrogenase",
    "1.1.1.136\tUDP-N-acetylglucosamine 6-dehydrogenase",
    "1.1.1.137\tribitol-5-phosphate 2-dehydrogenase",
    "1.1.1.138\tmannitol 2-dehydrogenase (NADP(+))",
    "1.1.1.140\tsorbitol-6-phosphate 2-dehydrogenase",
    "1.1.1.141\t15-hydroxyprostaglandin dehydrogenase (NAD(+))",
    "1.1.1.142\tD-pinitol dehydrogenase",
    "1.1.1.143\tsequoyitol dehydrogenase",
    "1.1.1.144\tperillyl-alcohol dehydrogenase",
    "1.1.1.145\t3beta-hydroxy-Delta(5)-steroid dehydrogenase",
    "1.1.1.146\t11beta-hydroxysteroid dehydrogenase",
    "1.1.1.147\t16alpha-hydroxysteroid dehydrogenase",
    "1.1.1.148\testradiol 17alpha-dehydrogenase",
    "1.1.1.149\t20alpha-hydroxysteroid dehydrogenase",
    "1.1.1.150\t21-hydroxysteroid dehydrogenase (NAD(+))",
    "1.1.1.151\t21-hydroxysteroid dehydrogenase (NADP(+))",
    "1.1.1.152\t3alpha-hydroxy-5beta-androstane-17-one 3alpha-dehydrogenase",
    "1.1.1.153\tsepiapterin reductase (L-erythro-7,8-dihydrobiopterin forming)",
    "1.1.1.154\tureidoglycolate dehydrogenase",
    "1.1.1.156\tglycerol 2-dehydrogenase (NADP(+))",
    "1.1.1.157\t3-hydroxybutyryl-CoA dehydrogenase",
    "1.1.1.159\t7alpha-hydroxysteroid dehydrogenase",
    "1.1.1.160\tdihydrobunolol dehydrogenase",
    "1.1.1.162\terythrulose reductase",
    "1.1.1.163\tcyclopentanol dehydrogenase",
    "1.1.1.164\thexadecanol dehydrogenase",
    "1.1.1.165\t2-alkyn-1-ol dehydrogenase",
    "1.1.1.166\thydroxycyclohexanecarboxylate dehydrogenase",
    "1.1.1.167\thydroxymalonate dehydrogenase",
    "1.1.1.168\t2-dehydropantolactone reductase (Re-specific)",
    "1.1.1.169\t2-dehydropantoate 2-reductase",
    "1.1.1.170\t3beta-hydroxysteroid-4alpha-carboxylate 3-dehydrogenase (decarboxylating)",
    "1.1.1.172\t2-oxoadipate reductase",
    "1.1.1.173\tL-rhamnose 1-dehydrogenase",
    "1.1.1.174\tcyclohexane-1,2-diol dehydrogenase",
    "1.1.1.175\tD-xylose 1-dehydrogenase",
    "1.1.1.176\t12alpha-hydroxysteroid dehydrogenase",
    "1.1.1.177\tglycerol-3-phosphate 1-dehydrogenase (NADP(+))",
    "1.1.1.178\t3-hydroxy-2-methylbutyryl-CoA dehydrogenase",
    "1.1.1.179\tD-xylose 1-dehydrogenase (NADP(+), D-xylono-1,5-lactone-forming)",
    "1.1.1.181\tcholest-5-ene-3beta,7alpha-diol 3beta-dehydrogenase",
    "1.1.1.183\tgeraniol dehydrogenase (NADP(+))",
    "1.1.1.184\tcarbonyl reductase (NADPH)",
    "1.1.1.185\tL-glycol dehydrogenase",
    "1.1.1.186\tdTDP-galactose 6-dehydrogenase",
    "1.1.1.187\tGDP-4-dehydro-D-rhamnose reductase",
    "1.1.1.188\tprostaglandin-F synthase",
    "1.1.1.189\tprostaglandin-E2 9-reductase",
    "1.1.1.190\tindole-3-acetaldehyde reductase (NADH)",
    "1.1.1.191\tindole-3-acetaldehyde reductase (NADPH)",
    "1.1.1.192\tlong-chain-alcohol dehydrogenase",
    "1.1.1.193\t5-amino-6-(5-phosphoribosylamino)uracil reductase",
    "1.1.1.194\tconiferyl-alcohol dehydrogenase",
    "1.1.1.195\tcinnamyl-alcohol dehydrogenase",
    "1.1.1.196\t15-hydroxyprostaglandin-D dehydrogenase (NADP(+))",
    "1.1.1.197\t15-hydroxyprostaglandin dehydrogenase (NADP(+))",
    "1.1.1.198\t(+)-borneol dehydrogenase",
    "1.1.1.199\t(S)-usnate reductase",
    "1.1.1.200\taldose-6-phosphate reductase (NADPH)",
    "1.1.1.201\t7beta-hydroxysteroid dehydrogenase (NADP(+))",
    "1.1.1.202\t1,3-propanediol dehydrogenase",
    "1.1.1.203\turonate dehydrogenase",
    "1.1.1.205\tIMP dehydrogenase",
    "1.1.1.206\ttropinone reductase I",
    "1.1.1.207\t(-)-menthol dehydrogenase",
    "1.1.1.208\t(+)-neomenthol dehydrogenase",
    "1.1.1.209\t3(or 17)alpha-hydroxysteroid dehydrogenase",
    "1.1.1.210\t3beta-(or 20alpha)-hydroxysteroid dehydrogenase",
    "1.1.1.211\tlong-chain-3-hydroxyacyl-CoA dehydrogenase",
    "1.1.1.212\t3-oxoacyl-[acyl-carrier-protein] reductase (NADH)",
    "1.1.1.213\t3alpha-hydroxysteroid dehydrogenase (Re-specific)",
    "1.1.1.214\t2-dehydropantolactone reductase (Si-specific)",
    "1.1.1.215\tgluconate 2-dehydrogenase",
    "1.1.1.216\tfarnesol dehydrogenase",
    "1.1.1.217\tbenzyl-2-methyl-hydroxybutyrate dehydrogenase",
    "1.1.1.218\tmorphine 6-dehydrogenase",
    "1.1.1.219\tdihydroflavanol 4-reductase",
    "1.1.1.220\t6-pyruvoyltetrahydropterin 2'-reductase",
    "1.1.1.221\tvomifoliol dehydrogenase",
    "1.1.1.223\tisopiperitenol dehydrogenase",
    "1.1.1.224\tmannose-6-phosphate 6-reductase",
    "1.1.1.225\tchlordecone reductase",
    "1.1.1.226\t4-hydroxycyclohexanecarboxylate dehydrogenase",
    "1.1.1.227\t(-)-borneol dehydrogenase",
    "1.1.1.228\t(+)-sabinol dehydrogenase",
    "1.1.1.229\tdiethyl 2-methyl-3-oxosuccinate reductase",
    "1.1.1.230\t3alpha-hydroxyglycyrrhetinate dehydrogenase",
    "1.1.1.231\t15-hydroxyprostaglandin-I dehydrogenase (NADP(+))",
    "1.1.1.232\t15-hydroxyicosatetraenoate dehydrogenase",
    "1.1.1.233\tN-acylmannosamine 1-dehydrogenase",
    "1.1.1.234\tflavanone 4-reductase",
    "1.1.1.235\t8-oxocoformycin reductase",
    "1.1.1.236\ttropinone reductase II",
    "1.1.1.237\thydroxyphenylpyruvate reductase",
    "1.1.1.238\t12beta-hydroxysteroid dehydrogenase",
    "1.1.1.239\t3alpha-(17beta)-hydroxysteroid dehydrogenase (NAD(+))",
    "1.1.1.240\tN-acetylhexosamine 1-dehydrogenase",
    "1.1.1.241\t6-endo-hydroxycineole dehydrogenase",
    "1.1.1.243\tcarveol dehydrogenase",
    "1.1.1.244\tmethanol dehydrogenase",
    "1.1.1.245\tcyclohexanol dehydrogenase",
    "1.1.1.247\tcodeinone reductase (NADPH)",
    "1.1.1.248\tsalutaridine reductase (NADPH)",
    "1.1.1.250\tD-arabinitol 2-dehydrogenase",
    "1.1.1.251\tgalactitol-1-phosphate 5-dehydrogenase",
    "1.1.1.252\ttetrahydroxynaphthalene reductase",
    "1.1.1.254\t(S)-carnitine 3-dehydrogenase",
    "1.1.1.255\tmannitol dehydrogenase",
    "1.1.1.256\tfluoren-9-ol dehydrogenase",
    "1.1.1.257\t4-(hydroxymethyl)benzenesulfonate dehydrogenase",
    "1.1.1.258\t6-hydroxyhexanoate dehydrogenase",
    "1.1.1.259\t3-hydroxypimeloyl-CoA dehydrogenase",
    "1.1.1.260\tsulcatone reductase",
    "1.1.1.261\tsn-glycerol-1-phosphate dehydrogenase",
    "1.1.1.262\t4-hydroxythreonine-4-phosphate dehydrogenase",
    "1.1.1.263\t1,5-anhydro-D-fructose reductase",
    "1.1.1.264\tL-idonate 5-dehydrogenase [NAD(P)(+)]",
    "1.1.1.265\t3-methylbutanal reductase",
    "1.1.1.266\tdTDP-4-dehydro-6-deoxyglucose reductase",
    "1.1.1.267\t1-deoxy-D-xylulose-5-phosphate reductoisomerase",
    "1.1.1.268\t2-(R)-hydroxypropyl-CoM dehydrogenase",
    "1.1.1.269\t2-(S)-hydroxypropyl-CoM dehydrogenase",
    "1.1.1.270\t3beta-hydroxysteroid 3-dehydrogenase",
    "1.1.1.271\tGDP-L-fucose synthase",
    "1.1.1.272\tD-2-hydroxyacid dehydrogenase (NADP(+))",
    "1.1.1.273\tvellosimine dehydrogenase",
    "1.1.1.274\t2,5-didehydrogluconate reductase (2-dehydro-D-gluconate-forming)",
    "1.1.1.275\t(+)-trans-carveol dehydrogenase",
    "1.1.1.276\tserine 3-dehydrogenase (NADP(+))",
    "1.1.1.277\t3beta-hydroxy-5beta-steroid dehydrogenase",
    "1.1.1.278\t3beta-hydroxy-5alpha-steroid dehydrogenase",
    "1.1.1.279\t(R)-3-hydroxyacid-ester dehydrogenase",
    "1.1.1.280\t(S)-3-hydroxyacid-ester dehydrogenase",
    "1.1.1.281\tGDP-4-dehydro-6-deoxy-D-mannose reductase",
    "1.1.1.282\tquinate/shikimate dehydrogenase [NAD(P)(+)]",
    "1.1.1.283\tmethylglyoxal reductase (NADPH)",
    "1.1.1.284\tS-(hydroxymethyl)glutathione dehydrogenase",
    "1.1.1.285\t3''-deamino-3''-oxonicotianamine reductase",
    "1.1.1.286\tisocitrate--homoisocitrate dehydrogenase",
    "1.1.1.287\tD-arabinitol dehydrogenase (NADP(+))",
    "1.1.1.288\txanthoxin dehydrogenase",
    "1.1.1.289\tsorbose reductase",
    "1.1.1.290\t4-phosphoerythronate dehydrogenase",
    "1.1.1.291\t2-hydroxymethylglutarate dehydrogenase",
    "1.1.1.292\t1,5-anhydro-D-fructose reductase (1,5-anhydro-D-mannitol-forming)",
    "1.1.1.294\tchlorophyll(ide) b reductase",
    "1.1.1.295\tmomilactone-A synthase",
    "1.1.1.296\tdihydrocarveol dehydrogenase",
    "1.1.1.297\tlimonene-1,2-diol dehydrogenase",
    "1.1.1.298\t3-hydroxypropionate dehydrogenase (NADP(+))",
    "1.1.1.299\tmalate dehydrogenase [NAD(P)(+)]",
    "1.1.1.300\tNADP-retinol dehydrogenase",
    "1.1.1.301\tD-arabitol-phosphate dehydrogenase",
    "1.1.1.302\t2,5-diamino-6-(ribosylamino)-4(3H)-pyrimidinone 5'-phosphate reductase",
    "1.1.1.303\tdiacetyl reductase [(R)-acetoin forming]",
    "1.1.1.304\tdiacetyl reductase [(S)-acetoin forming]",
    "1.1.1.305\tUDP-glucuronic acid oxidase (UDP-4-keto-hexauronic acid decarboxylating)",
    "1.1.1.306\tS-(hydroxymethyl)mycothiol dehydrogenase",
    "1.1.1.307\tD-xylose reductase [NAD(P)H]",
    "1.1.1.308\tsulfopropanediol 3-dehydrogenase",
    "1.1.1.309\tphosphonoacetaldehyde reductase (NADH)",
    "1.1.1.310\t(S)-sulfolactate dehydrogenase",
    "1.1.1.311\t(S)-1-phenylethanol dehydrogenase",
    "1.1.1.312\t2-hydroxy-4-carboxymuconate semialdehyde hemiacetal dehydrogenase",
    "1.1.1.313\tsulfoacetaldehyde reductase (NADPH)",
    "1.1.1.315\t11-cis-retinol dehydrogenase",
    "1.1.1.316\tL-galactose 1-dehydrogenase",
    "1.1.1.317\tperakine reductase",
    "1.1.1.318\teugenol synthase",
    "1.1.1.319\tisoeugenol synthase",
    "1.1.1.320\tbenzil reductase [(S)-benzoin forming]",
    "1.1.1.321\tbenzil reductase [(R)-benzoin forming]",
    "1.1.1.322\t(-)-endo-fenchol dehydrogenase",
    "1.1.1.323\t(+)-thujan-3-ol dehydrogenase",
    "1.1.1.324\t8-hydroxygeraniol dehydrogenase",
    "1.1.1.325\tsepiapterin reductase (L-threo-7,8-dihydrobiopterin forming)",
    "1.1.1.326\tzerumbone synthase",
    "1.1.1.327\t5-exo-hydroxycamphor dehydrogenase",
    "1.1.1.328\tnicotine blue oxidoreductase",
    "1.1.1.329\t2-deoxy-scyllo-inosamine dehydrogenase",
    "1.1.1.330\tvery-long-chain 3-oxoacyl-CoA reductase",
    "1.1.1.331\tsecoisolariciresinol dehydrogenase",
    "1.1.1.332\tchanoclavine-I dehydrogenase",
    "1.1.1.333\tdecaprenylphospho-beta-D-erythro-pentofuranosid-2-ulose 2-reductase",
    "1.1.1.334\tmethylecgonone reductase",
    "1.1.1.335\tUDP-N-acetyl-2-amino-2-deoxyglucuronate dehydrogenase",
    "1.1.1.336\tUDP-N-acetyl-D-mannosamine dehydrogenase",
    "1.1.1.337\tL-2-hydroxycarboxylate dehydrogenase (NAD(+))",
    "1.1.1.338\t(2R)-3-sulfolactate dehydrogenase (NADP(+))",
    "1.1.1.339\tdTDP-6-deoxy-L-talose 4-dehydrogenase (NAD(+))",
    "1.1.1.340\t1-deoxy-11beta-hydroxypentalenate dehydrogenase",
    "1.1.1.341\tCDP-abequose synthase",
    "1.1.1.342\tCDP-paratose synthase",
    "1.1.1.343\tphosphogluconate dehydrogenase (NAD(+)-dependent, decarboxylating)",
    "1.1.1.344\tdTDP-6-deoxy-L-talose 4-dehydrogenase [NAD(P)(+)]",
    "1.1.1.345\tD-2-hydroxyacid dehydrogenase (NAD(+))",
    "1.1.1.346\t2,5-didehydrogluconate reductase (2-dehydro-L-gulonate-forming)",
    "1.1.1.347\tgeraniol dehydrogenase (NAD(+))",
    "1.1.1.348\t(3R)-2'-hydroxyisoflavanone reductase",
    "1.1.1.349\tnorsolorinic acid ketoreductase",
    "1.1.1.350\tureidoglycolate dehydrogenase (NAD(+))",
    "1.1.1.351\tphosphogluconate dehydrogenase [NAD(P)(+)-dependent, decarboxylating]",
    "1.1.1.352\t5'-hydroxyaverantin dehydrogenase",
    "1.1.1.353\tversiconal hemiacetal acetate reductase",
    "1.1.1.354\tfarnesol dehydrogenase (NAD(+))",
    "1.1.1.355\t2'-dehydrokanamycin reductase",
    "1.1.1.356\tGDP-L-colitose synthase",
    "1.1.1.357\t3alpha-hydroxysteroid 3-dehydrogenase",
    "1.1.1.358\t2-dehydropantolactone reductase",
    "1.1.1.359\taldose 1-dehydrogenase [NAD(P)(+)]",
    "1.1.1.360\tglucose/galactose 1-dehydrogenase",
    "1.1.1.361\tglucose-6-phosphate 3-dehydrogenase",
    "1.1.1.362\taklaviketone reductase",
    "1.1.1.363\tglucose-6-phosphate dehydrogenase [NAD(P)(+)]",
    "1.1.1.364\tdTDP-4-dehydro-6-deoxy-alpha-D-gulose 4-ketoreductase",
    "1.1.1.365\tD-galacturonate reductase",
    "1.1.1.366\tL-idonate 5-dehydrogenase (NAD(+))",
    "1.1.1.367\tUDP-2-acetamido-2,6-beta-L-arabino-hexul-4-ose reductase",
    "1.1.1.368\t6-hydroxycyclohex-1-ene-1-carbonyl-CoA dehydrogenase",
    "1.1.1.369\tD-chiro-inositol 1-dehydrogenase",
    "1.1.1.370\tscyllo-inositol 2-dehydrogenase (NAD(+))",
    "1.1.1.371\tscyllo-inositol 2-dehydrogenase (NADP(+))",
    "1.1.1.372\tD/L-glyceraldehyde reductase",
    "1.1.1.373\tsulfolactaldehyde 3-reductase",
    "1.1.1.374\tUDP-N-acetylglucosamine 3-dehydrogenase",
    "1.1.1.375\tL-2-hydroxycarboxylate dehydrogenase [NAD(P)(+)]",
    "1.1.1.376\tL-arabinose 1-dehydrogenase [NAD(P)(+)]",
    "1.1.1.377\tL-rhamnose 1-dehydrogenase (NADP(+))",
    "1.1.1.378\tL-rhamnose 1-dehydrogenase [NAD(P)(+)]",
    "1.1.1.379\t(R)-mandelate dehydrogenase",
    "1.1.1.380\tL-gulonate 5-dehydrogenase",
    "1.1.1.381\t3-hydroxy acid dehydrogenase",
    "1.1.1.382\tketol-acid reductoisomerase (NAD(+))",
    "1.1.1.383\tketol-acid reductoisomerase [NAD(P)(+)]",
    "1.1.1.384\tdTDP-3,4-didehydro-2,6-dideoxy-alpha-D-glucose 3-reductase",
    "1.1.1.385\tdihydroanticapsin 7-dehydrogenase",
    "1.1.1.386\tipsdienol dehydrogenase",
    "1.1.1.387\tL-serine 3-dehydrogenase (NAD(+))",
    "1.1.1.388\tglucose-6-phosphate dehydrogenase (NAD(+))",
    "1.1.1.389\t2-dehydro-3-deoxy-L-galactonate 5-dehydrogenase",
    "1.1.1.390\tsulfoquinovose 1-dehydrogenase",
    "1.1.1.391\t3beta-hydroxycholanate 3-dehydrogenase (NAD(+))",
    "1.1.1.392\t3alpha-hydroxycholanate dehydrogenase (NADP(+))",
    "1.1.1.393\t3beta-hydroxycholanate 3-dehydrogenase (NADP(+))",
    "1.1.1.394\taurachin B dehydrogenase",
    "1.1.1.395\t3alpha-hydroxybile acid CoA 3-dehydrogenase",
    "1.1.1.396\tbacteriochlorophyllide-a dehydrogenase",
    "1.1.1.397\tbeta-methylindole-3-pyruvate reductase",
    "1.1.1.398\t2-glutathionyl-2-methylbut-3-en-1-ol dehydrogenase",
    "1.1.1.399\t2-oxoglutarate reductase",
    "1.1.1.400\t2-methyl-1,2-propanediol dehydrogenase",
    "1.1.1.401\t2-dehydro-3-deoxy-L-rhamnonate dehydrogenase (NAD(+))",
    "1.1.1.402\tD-erythritol 1-phosphate dehydrogenase",
    "1.1.1.403\tD-threitol dehydrogenase (NAD(+))",
    "1.1.1.404\ttetrachlorobenzoquinone reductase",
    "1.1.1.405\tribitol-5-phosphate 2-dehydrogenase (NADP(+))",
    "1.1.1.406\tgalactitol 2-dehydrogenase (L-tagatose-forming)",
    "1.1.1.407\tD-altritol 5-dehydrogenase",
    "1.1.1.408\t4-phospho-D-threonate 3-dehydrogenase",
    "1.1.1.409\t4-phospho-D-erythronate 3-dehydrogenase",
    "1.1.1.410\tD-erythronate 2-dehydrogenase",
    "1.1.1.411\tL-threonate 2-dehydrogenase",
    "1.1.1.412\t2-alkyl-3-oxoalkanoate reductase",
    "1.1.1.413\tA-factor type gamma-butyrolactone 1'-reductase (1S-forming)",
    "1.1.1.414\tL-galactonate 5-dehydrogenase",
    "1.1.1.415\tnoscapine synthase",
    "1.1.1.416\tisopyridoxal dehydrogenase (5-pyridoxolactone-forming)",
    "1.1.1.417\t3beta-hydroxysteroid-4beta-carboxylate 3-dehydrogenase (decarboxylating)",
    "1.1.1.418\tplant 3beta-hydroxysteroid-4alpha-carboxylate 3-dehydrogenase (decarboxylating)",
    "1.1.1.419\tnepetalactol dehydrogenase",
    "1.1.1.420\tD-apiose dehydrogenase",
    "1.1.1.421\tD-apionate oxidoisomerase",
    "1.1.1.422\tpseudoephedrine dehydrogenase",
    "1.1.1.423\t(1R,2S)-ephedrine 1-dehydrogenase",
    "1.1.1.424\tD-xylose 1-dehydrogenase (NADP(+), D-xylono-1,4-lactone-forming)",
    "1.1.1.425\tlevoglucosan dehydrogenase",
    "1.1.1.426\tUDP-N-acetyl-alpha-D-quinovosamine dehydrogenase",
    "1.1.1.n4\t(-)-trans-carveol dehydrogenase",
    "1.1.1.n5\t3-methylmalate dehydrogenase",
    "1.1.1.n11\tsuccinic semialdehyde reductase",
    "1.1.1.n12\t(3R)-hydroxyacyl-CoA dehydrogenase",
    "1.1.2.2\tmannitol dehydrogenase (cytochrome)",
    "1.1.2.3\tL-lactate dehydrogenase (cytochrome)",
    "1.1.2.4\tD-lactate dehydrogenase (cytochrome)",
    "1.1.2.5\tD-lactate dehydrogenase (cytochrome c-553)",
    "1.1.2.6\tpolyvinyl alcohol dehydrogenase (cytochrome)",
    "1.1.2.7\tmethanol dehydrogenase (cytochrome c)",
    "1.1.2.8\talcohol dehydrogenase (cytochrome c)",
    "1.1.2.9\t1-butanol dehydrogenase (cytochrome c)",
    "1.1.2.10\tlanthanide-dependent methanol dehydrogenase",
    "1.1.3.4\tglucose oxidase",
    "1.1.3.5\thexose oxidase",
    "1.1.3.6\tcholesterol oxidase",
    "1.1.3.7\taryl-alcohol oxidase",
    "1.1.3.8\tL-gulonolactone oxidase",
    "1.1.3.9\tgalactose oxidase",
    "1.1.3.10\tpyranose oxidase",
    "1.1.3.11\tL-sorbose oxidase",
    "1.1.3.12\tpyridoxine 4-oxidase",
    "1.1.3.13\talcohol oxidase",
    "1.1.3.14\tcatechol oxidase (dimerizing)",
    "1.1.3.15\t(S)-2-hydroxy-acid oxidase",
    "1.1.3.16\tecdysone oxidase",
    "1.1.3.17\tcholine oxidase",
    "1.1.3.18\tsecondary-alcohol oxidase",
    "1.1.3.19\t4-hydroxymandelate oxidase (decarboxylating)",
    "1.1.3.20\tlong-chain-alcohol oxidase",
    "1.1.3.21\tglycerol-3-phosphate oxidase",
    "1.1.3.23\tthiamine oxidase",
    "1.1.3.27\thydroxyphytanate oxidase",
    "1.1.3.28\tnucleoside oxidase",
    "1.1.3.29\tN-acylhexosamine oxidase",
    "1.1.3.30\tpolyvinyl-alcohol oxidase",
    "1.1.3.37\tD-arabinono-1,4-lactone oxidase",
    "1.1.3.38\tvanillyl-alcohol oxidase",
    "1.1.3.39\tnucleoside oxidase (H2O2-forming)",
    "1.1.3.40\tD-mannitol oxidase",
    "1.1.3.41\talditol oxidase",
    "1.1.3.42\tprosolanapyrone-II oxidase",
    "1.1.3.43\tparomamine 6'-oxidase",
    "1.1.3.44\t6'''-hydroxyneomycin C oxidase",
    "1.1.3.45\taclacinomycin-N oxidase",
    "1.1.3.46\t4-hydroxymandelate oxidase",
    "1.1.3.47\t5-(hydroxymethyl)furfural oxidase",
    "1.1.3.48\t3-deoxy-alpha-D-manno-octulosonate 8-oxidase",
    "1.1.3.49\t(R)-mandelonitrile oxidase",
    "1.1.5.2\tquinoprotein glucose dehydrogenase (PQQ, quinone)",
    "1.1.5.3\tglycerol-3-phosphate dehydrogenase",
    "1.1.5.4\tmalate dehydrogenase (quinone)",
    "1.1.5.5\talcohol dehydrogenase (quinone)",
    "1.1.5.7\tcyclic alcohol dehydrogenase (quinone)",
    "1.1.5.8\tquinate/shikimate dehydrogenase (quinone)",
    "1.1.5.9\tglucose 1-dehydrogenase (FAD, quinone)",
    "1.1.5.10\tD-2-hydroxyacid dehydrogenase (quinone)",
    "1.1.5.11\t1-butanol dehydrogenase (quinone)",
    "1.1.5.12\tD-lactate dehydrogenase (quinone)",
    "1.1.5.13\t(S)-2-hydroxyglutarate dehydrogenase",
    "1.1.5.14\tfructose 5-dehydrogenase",
    "1.1.5.n1\tquinoprotein inositol dehydrogenase",
    "1.1.7.1\t4-hydroxybenzoyl-CoA reductase",
    "1.1.9.1\talcohol dehydrogenase (azurin)",
    "1.1.98.2\tglucose-6-phosphate dehydrogenase (coenzyme-F420)",
    "1.1.98.3\tdecaprenylphospho-beta-D-ribofuranose 2-dehydrogenase",
    "1.1.98.4\tF420H2:quinone oxidoreductase",
    "1.1.98.5\tsecondary-alcohol dehydrogenase (coenzyme-F420)",
    "1.1.98.6\tribonucleoside-triphosphate reductase (formate)",
    "1.1.98.7\tserine-type anaerobic sulfatase-maturating enzyme",
    "1.1.99.1\tcholine dehydrogenase",
    "1.1.99.2\tL-2-hydroxyglutarate dehydrogenase",
    "1.1.99.3\tgluconate 2-dehydrogenase (acceptor)",
    "1.1.99.4\tdehydrogluconate dehydrogenase",
    "1.1.99.6\tD-lactate dehydrogenase (acceptor)",
    "1.1.99.7\tlactate--malate transhydrogenase",
    "1.1.99.9\tpyridoxine 5-dehydrogenase",
    "1.1.99.12\tsorbose dehydrogenase",
    "1.1.99.13\tglucoside 3-dehydrogenase (acceptor)",
    "1.1.99.14\tglycolate dehydrogenase",
    "1.1.99.18\tcellobiose dehydrogenase (acceptor)",
    "1.1.99.20\talkan-1-ol dehydrogenase (acceptor)",
    "1.1.99.21\tD-sorbitol dehydrogenase (acceptor)",
    "1.1.99.22\tglycerol dehydrogenase (acceptor)",
    "1.1.99.24\thydroxyacid-oxoacid transhydrogenase",
    "1.1.99.26\t3-hydroxycyclohexanone dehydrogenase",
    "1.1.99.27\t(R)-pantolactone dehydrogenase (flavin)",
    "1.1.99.28\tglucose-fructose oxidoreductase",
    "1.1.99.29\tpyranose dehydrogenase (acceptor)",
    "1.1.99.30\t2-oxo-acid reductase",
    "1.1.99.31\t(S)-mandelate dehydrogenase",
    "1.1.99.32\tL-sorbose 1-dehydrogenase",
    "1.1.99.35\tsoluble quinoprotein glucose dehydrogenase",
    "1.1.99.36\talcohol dehydrogenase (nicotinoprotein)",
    "1.1.99.37\tmethanol dehydrogenase (nicotinoprotein)",
    "1.1.99.38\t2-deoxy-scyllo-inosamine dehydrogenase (AdoMet-dependent)",
    "1.1.99.39\tD-2-hydroxyglutarate dehydrogenase",
    "1.1.99.40\t(R)-2-hydroxyglutarate--pyruvate transhydrogenase",
    "1.1.99.41\t3-hydroxy-1,2-didehydro-2,3-dihydrotabersonine reductase",
    "1.1.99.42\t4-pyridoxate dehydrogenase",
    "1.2.1.3\taldehyde dehydrogenase (NAD(+))",
    "1.2.1.4\taldehyde dehydrogenase (NADP(+))",
    "1.2.1.5\taldehyde dehydrogenase [NAD(P)(+)]",
    "1.2.1.7\tbenzaldehyde dehydrogenase (NADP(+))",
    "1.2.1.8\tbetaine-aldehyde dehydrogenase",
    "1.2.1.9\tglyceraldehyde-3-phosphate dehydrogenase (NADP(+))",
    "1.2.1.10\tacetaldehyde dehydrogenase (acetylating)",
    "1.2.1.11\taspartate-semialdehyde dehydrogenase",
    "1.2.1.12\tglyceraldehyde-3-phosphate dehydrogenase (phosphorylating)",
    "1.2.1.13\tglyceraldehyde-3-phosphate dehydrogenase (NADP(+)) (phosphorylating)",
    "1.2.1.15\tmalonate-semialdehyde dehydrogenase",
    "1.2.1.16\tsuccinate-semialdehyde dehydrogenase [NAD(P)(+)]",
    "1.2.1.17\tglyoxylate dehydrogenase (acylating)",
    "1.2.1.18\tmalonate-semialdehyde dehydrogenase (acetylating)",
    "1.2.1.19\taminobutyraldehyde dehydrogenase",
    "1.2.1.20\tglutarate-semialdehyde dehydrogenase",
    "1.2.1.21\tglycolaldehyde dehydrogenase",
    "1.2.1.22\tlactaldehyde dehydrogenase",
    "1.2.1.23\t2-oxoaldehyde dehydrogenase (NAD(+))",
    "1.2.1.24\tsuccinate-semialdehyde dehydrogenase (NAD(+))",
    "1.2.1.25\tbranched-chain alpha-keto acid dehydrogenase system",
    "1.2.1.26\t2,5-dioxovalerate dehydrogenase",
    "1.2.1.27\tmethylmalonate-semialdehyde dehydrogenase (CoA acylating)",
    "1.2.1.28\tbenzaldehyde dehydrogenase (NAD(+))",
    "1.2.1.29\taryl-aldehyde dehydrogenase",
    "1.2.1.30\tcarboxylate reductase (NADP(+))",
    "1.2.1.31\tL-aminoadipate-semialdehyde dehydrogenase",
    "1.2.1.32\taminomuconate-semialdehyde dehydrogenase",
    "1.2.1.33\t(R)-dehydropantoate dehydrogenase",
    "1.2.1.36\tretinal dehydrogenase",
    "1.2.1.38\tN-acetyl-gamma-glutamyl-phosphate reductase",
    "1.2.1.39\tphenylacetaldehyde dehydrogenase",
    "1.2.1.41\tglutamate-5-semialdehyde dehydrogenase",
    "1.2.1.42\thexadecanal dehydrogenase (acylating)",
    "1.2.1.44\tcinnamoyl-CoA reductase",
    "1.2.1.46\tformaldehyde dehydrogenase",
    "1.2.1.47\t4-trimethylammoniobutyraldehyde dehydrogenase",
    "1.2.1.48\tlong-chain-aldehyde dehydrogenase",
    "1.2.1.49\t2-oxoaldehyde dehydrogenase (NADP(+))",
    "1.2.1.50\tlong-chain-fatty-acyl-CoA reductase",
    "1.2.1.51\tpyruvate dehydrogenase (NADP(+))",
    "1.2.1.52\toxoglutarate dehydrogenase (NADP(+))",
    "1.2.1.53\t4-hydroxyphenylacetaldehyde dehydrogenase",
    "1.2.1.54\tgamma-guanidinobutyraldehyde dehydrogenase",
    "1.2.1.57\tbutanal dehydrogenase",
    "1.2.1.58\tphenylglyoxylate dehydrogenase (acylating)",
    "1.2.1.59\tglyceraldehyde-3-phosphate dehydrogenase (NAD(P)(+)) (phosphorylating)",
    "1.2.1.60\t5-carboxymethyl-2-hydroxymuconic-semialdehyde dehydrogenase",
    "1.2.1.61\t4-hydroxymuconic-semialdehyde dehydrogenase",
    "1.2.1.62\t4-formylbenzenesulfonate dehydrogenase",
    "1.2.1.63\t6-oxohexanoate dehydrogenase",
    "1.2.1.64\t4-hydroxybenzaldehyde dehydrogenase (NAD(+))",
    "1.2.1.65\tsalicylaldehyde dehydrogenase",
    "1.2.1.67\tvanillin dehydrogenase",
    "1.2.1.68\tconiferyl-aldehyde dehydrogenase",
    "1.2.1.69\tfluoroacetaldehyde dehydrogenase",
    "1.2.1.70\tglutamyl-tRNA reductase",
    "1.2.1.71\tsuccinylglutamate-semialdehyde dehydrogenase",
    "1.2.1.72\terythrose-4-phosphate dehydrogenase",
    "1.2.1.73\tsulfoacetaldehyde dehydrogenase",
    "1.2.1.74\tabieta-7,13-dien-18-al dehydrogenase",
    "1.2.1.75\tmalonyl CoA reductase (malonate semialdehyde-forming)",
    "1.2.1.76\tsuccinate-semialdehyde dehydrogenase (acetylating)",
    "1.2.1.77\t3,4-dehydroadipyl-CoA semialdehyde dehydrogenase (NADP(+))",
    "1.2.1.78\t2-formylbenzoate dehydrogenase",
    "1.2.1.79\tsuccinate-semialdehyde dehydrogenase (NADP(+))",
    "1.2.1.80\tlong-chain acyl-[acyl-carrier-protein] reductase",
    "1.2.1.81\tsulfoacetaldehyde dehydrogenase (acylating)",
    "1.2.1.82\tbeta-apo-4'-carotenal oxygenase",
    "1.2.1.83\t3-succinoylsemialdehyde-pyridine dehydrogenase",
    "1.2.1.84\talcohol-forming fatty acyl-CoA reductase",
    "1.2.1.85\t2-hydroxymuconate-6-semialdehyde dehydrogenase",
    "1.2.1.86\tgeranial dehydrogenase",
    "1.2.1.87\tpropanal dehydrogenase (CoA-propanoylating)",
    "1.2.1.88\tL-glutamate gamma-semialdehyde dehydrogenase",
    "1.2.1.89\tD-glyceraldehyde dehydrogenase (NADP(+))",
    "1.2.1.90\tglyceraldehyde-3-phosphate dehydrogenase [NAD(P)(+)]",
    "1.2.1.91\t3-oxo-5,6-dehydrosuberyl-CoA semialdehyde dehydrogenase",
    "1.2.1.92\t3,6-anhydro-alpha-L-galactose dehydrogenase",
    "1.2.1.94\tfarnesal dehydrogenase",
    "1.2.1.95\tL-2-aminoadipate reductase",
    "1.2.1.96\t4-hydroxybenzaldehyde dehydrogenase (NADP(+))",
    "1.2.1.97\t3-sulfolactaldehyde dehydrogenase",
    "1.2.1.98\t2-hydroxy-2-methylpropanal dehydrogenase",
    "1.2.1.99\t4-(gamma-glutamylamino)butanal dehydrogenase",
    "1.2.1.100\t5-formyl-3-hydroxy-2-methylpyridine 4-carboxylate 5-dehydrogenase",
    "1.2.1.101\tL-tyrosine reductase",
    "1.2.1.102\tisopyridoxal dehydrogenase (5-pyridoxate-forming)",
    "1.2.1.103\t[amino-group carrier protein]-6-phospho-L-2-aminoadipate reductase",
    "1.2.1.104\tpyruvate dehydrogenase system",
    "1.2.1.105\t2-oxoglutarate dehydrogenase system",
    "1.2.1.106\t[amino-group carrier protein]-5-phospho-L-glutamate reductase",
    "1.2.1.107\tglyceraldehyde-3-phosphate dehydrogenase (arsenate-transferring)",
    "1.2.1.n2\tfatty acyl-CoA reductase",
    "1.2.2.1\tformate dehydrogenase (cytochrome)",
    "1.2.3.1\taldehyde oxidase",
    "1.2.3.3\tpyruvate oxidase",
    "1.2.3.4\toxalate oxidase",
    "1.2.3.5\tglyoxylate oxidase",
    "1.2.3.6\tpyruvate oxidase (CoA-acetylating)",
    "1.2.3.7\tindole-3-acetaldehyde oxidase",
    "1.2.3.8\tpyridoxal oxidase",
    "1.2.3.9\taryl-aldehyde oxidase",
    "1.2.3.13\t4-hydroxyphenylpyruvate oxidase",
    "1.2.3.14\tabscisic-aldehyde oxidase",
    "1.2.3.15\t(methyl)glyoxal oxidase",
    "1.2.4.1\tpyruvate dehydrogenase (acetyl-transferring)",
    "1.2.4.2\toxoglutarate dehydrogenase (succinyl-transferring)",
    "1.2.4.4\t3-methyl-2-oxobutanoate dehydrogenase (2-methylpropanoyl-transferring)",
    "1.2.5.1\tpyruvate dehydrogenase (quinone)",
    "1.2.5.2\taldehyde dehydrogenase (quinone)",
    "1.2.5.3\taerobic carbon monoxide dehydrogenase",
    "1.2.7.1\tpyruvate synthase",
    "1.2.7.3\t2-oxoglutarate synthase",
    "1.2.7.4\tanaerobic carbon-monoxide dehydrogenase",
    "1.2.7.5\taldehyde ferredoxin oxidoreductase",
    "1.2.7.6\tglyceraldehyde-3-phosphate dehydrogenase (ferredoxin)",
    "1.2.7.7\t3-methyl-2-oxobutanoate dehydrogenase (ferredoxin)",
    "1.2.7.8\tindolepyruvate ferredoxin oxidoreductase",
    "1.2.7.10\toxalate oxidoreductase",
    "1.2.7.11\t2-oxoacid oxidoreductase (ferredoxin)",
    "1.2.7.12\tformylmethanofuran dehydrogenase",
    "1.2.98.1\tformaldehyde dismutase",
    "1.2.99.6\tcarboxylate reductase",
    "1.2.99.7\taldehyde dehydrogenase (FAD-independent)",
    "1.2.99.8\tglyceraldehyde dehydrogenase (FAD-containing)",
    "1.2.99.10\t4,4'-diapolycopenoate synthase",
    "1.3.1.1\tdihydrouracil dehydrogenase (NAD(+))",
    "1.3.1.2\tdihydropyrimidine dehydrogenase (NADP(+))",
    "1.3.1.3\tDelta(4)-3-oxosteroid 5beta-reductase",
    "1.3.1.5\tcucurbitacin Delta(23)-reductase",
    "1.3.1.6\tfumarate reductase (NADH)",
    "1.3.1.7\tmeso-tartrate dehydrogenase",
    "1.3.1.8\tacyl-CoA dehydrogenase (NADP(+))",
    "1.3.1.9\tenoyl-[acyl-carrier-protein] reductase (NADH)",
    "1.3.1.10\tenoyl-[acyl-carrier-protein] reductase (NADPH, Si-specific)",
    "1.3.1.11\t2-coumarate reductase",
    "1.3.1.12\tprephenate dehydrogenase",
    "1.3.1.13\tprephenate dehydrogenase (NADP(+))",
    "1.3.1.14\tdihydroorotate dehydrogenase (NAD(+))",
    "1.3.1.15\tdihydroorotate dehydrogenase (NADP(+))",
    "1.3.1.16\tbeta-nitroacrylate reductase",
    "1.3.1.17\t3-methyleneoxindole reductase",
    "1.3.1.18\tkynurenate-7,8-dihydrodiol dehydrogenase",
    "1.3.1.19\tcis-1,2-dihydrobenzene-1,2-diol dehydrogenase",
    "1.3.1.20\ttrans-1,2-dihydrobenzene-1,2-diol dehydrogenase",
    "1.3.1.21\t7-dehydrocholesterol reductase",
    "1.3.1.22\t3-oxo-5alpha-steroid 4-dehydrogenase (NADP(+))",
    "1.3.1.24\tbiliverdin reductase",
    "1.3.1.25\t1,6-dihydroxycyclohexa-2,4-diene-1-carboxylate dehydrogenase",
    "1.3.1.27\t2-hexadecenal reductase",
    "1.3.1.28\t2,3-dihydro-2,3-dihydroxybenzoate dehydrogenase",
    "1.3.1.29\tcis-1,2-dihydro-1,2-dihydroxynaphthalene dehydrogenase",
    "1.3.1.31\t2-enoate reductase",
    "1.3.1.32\tmaleylacetate reductase",
    "1.3.1.33\tprotochlorophyllide reductase",
    "1.3.1.34\t2,4-dienoyl-CoA reductase [(2E)-enoyl-CoA-producing]",
    "1.3.1.36\tgeissoschizine dehydrogenase",
    "1.3.1.37\tcis-2-enoyl-CoA reductase (NADPH)",
    "1.3.1.38\ttrans-2-enoyl-CoA reductase (NADPH)",
    "1.3.1.39\tenoyl-[acyl-carrier-protein] reductase (NADPH, Re-specific)",
    "1.3.1.40\t2-hydroxy-6-oxo-6-phenylhexa-2,4-dienoate reductase",
    "1.3.1.41\txanthommatin reductase",
    "1.3.1.42\t12-oxophytodienoate reductase",
    "1.3.1.43\tarogenate dehydrogenase",
    "1.3.1.44\ttrans-2-enoyl-CoA reductase (NAD(+))",
    "1.3.1.45\t2'-hydroxyisoflavone reductase",
    "1.3.1.46\tbiochanin-A reductase",
    "1.3.1.47\talpha-santonin 1,2-reductase",
    "1.3.1.48\t15-oxoprostaglandin 13-reductase",
    "1.3.1.49\tcis-3,4-dihydrophenanthrene-3,4-diol dehydrogenase",
    "1.3.1.51\t2'-hydroxydaidzein reductase",
    "1.3.1.53\t(3S,4R)-3,4-dihydroxycyclohexa-1,5-diene-1,4-dicarboxylate dehydrogenase",
    "1.3.1.54\tprecorrin-6A reductase",
    "1.3.1.56\tcis-2,3-dihydrobiphenyl-2,3-diol dehydrogenase",
    "1.3.1.57\tphloroglucinol reductase",
    "1.3.1.58\t2,3-dihydroxy-2,3-dihydro-p-cumate dehydrogenase",
    "1.3.1.60\tdibenzothiophene dihydrodiol dehydrogenase",
    "1.3.1.62\tpimeloyl-CoA dehydrogenase",
    "1.3.1.64\tphthalate 4,5-cis-dihydrodiol dehydrogenase",
    "1.3.1.65\t5,6-dihydroxy-3-methyl-2-oxo-1,2,5,6-tetrahydroquinoline dehydrogenase",
    "1.3.1.66\tcis-dihydroethylcatechol dehydrogenase",
    "1.3.1.67\tcis-1,2-dihydroxy-4-methylcyclohexa-3,5-diene-1-carboxylate dehydrogenase",
    "1.3.1.68\t1,2-dihydroxy-6-methylcyclohexa-3,5-dienecarboxylate dehydrogenase",
    "1.3.1.69\tzeatin reductase",
    "1.3.1.70\tDelta(14)-sterol reductase",
    "1.3.1.71\tDelta(24(24(1)))-sterol reductase",
    "1.3.1.72\tDelta(24)-sterol reductase",
    "1.3.1.73\t1,2-dihydrovomilenine reductase",
    "1.3.1.74\t2-alkenal reductase [NAD(P)(+)]",
    "1.3.1.75\t3,8-divinyl protochlorophyllide a 8-vinyl-reductase (NADPH)",
    "1.3.1.76\tprecorrin-2 dehydrogenase",
    "1.3.1.77\tanthocyanidin reductase [(2R,3R)-flavan-3-ol-forming]",
    "1.3.1.78\tarogenate dehydrogenase (NADP(+))",
    "1.3.1.79\tarogenate dehydrogenase [NAD(P)(+)]",
    "1.3.1.81\t(+)-pulegone reductase",
    "1.3.1.82\t(-)-isopiperitenone reductase",
    "1.3.1.83\tgeranylgeranyl diphosphate reductase",
    "1.3.1.84\tacrylyl-CoA reductase (NADPH)",
    "1.3.1.85\tcrotonyl-CoA carboxylase/reductase",
    "1.3.1.86\tcrotonyl-CoA reductase",
    "1.3.1.87\t3-(cis-5,6-dihydroxycyclohexa-1,3-dien-1-yl)propanoate dehydrogenase",
    "1.3.1.88\ttRNA-dihydrouridine(16/17) synthase [NAD(P)(+)]",
    "1.3.1.89\ttRNA-dihydrouridine(47) synthase [NAD(P)(+)]",
    "1.3.1.90\ttRNA-dihydrouridine(20a/20b) synthase [NAD(P)(+)]",
    "1.3.1.91\ttRNA-dihydrouridine(20) synthase [NAD(P)(+)]",
    "1.3.1.92\tartemisinic aldehyde Delta(11(13)) reductase",
    "1.3.1.93\tvery-long-chain enoyl-CoA reductase",
    "1.3.1.94\tpolyprenol reductase",
    "1.3.1.95\tacryloyl-CoA reductase (NADH)",
    "1.3.1.96\tBotryococcus squalene synthase",
    "1.3.1.97\tbotryococcene synthase",
    "1.3.1.98\tUDP-N-acetylmuramate dehydrogenase",
    "1.3.1.100\tchanoclavine-I aldehyde reductase",
    "1.3.1.101\t2,3-bis-O-geranylgeranyl-sn-glycerol 1-phosphate reductase [NAD(P)H]",
    "1.3.1.102\t2-alkenal reductase (NADP(+))",
    "1.3.1.103\t2-haloacrylate reductase",
    "1.3.1.104\tenoyl-[acyl-carrier-protein] reductase",
    "1.3.1.105\t2-methylene-furan-3-one reductase",
    "1.3.1.106\tcobalt-precorrin-6A reductase",
    "1.3.1.107\tsanguinarine reductase",
    "1.3.1.108\tcaffeoyl-CoA reductase",
    "1.3.1.109\tbutanoyl-CoA dehydrogenase complex (NAD(+), ferredoxin)",
    "1.3.1.110\tlactate dehydrogenase (NAD(+),ferredoxin)",
    "1.3.1.111\tgeranylgeranyl-bacteriochlorophyllide a reductase",
    "1.3.1.112\tanthocyanidin reductase [(2S)-flavan-3-ol-forming]",
    "1.3.1.113\t(4-alkanoyl-5-oxo-2,5-dihydrofuran-3-yl)methyl phosphate reductase",
    "1.3.1.114\t3-dehydro-bile acid Delta(4,6)-reductase",
    "1.3.1.115\t3-oxocholoyl-CoA 4-desaturase",
    "1.3.1.116\t7beta-hydroxy-3-oxochol-24-oyl-CoA 4-desaturase",
    "1.3.1.117\thydroxycinnamoyl-CoA reductase",
    "1.3.1.118\tmeromycolic acid enoyl-[acyl-carrier-protein] reductase",
    "1.3.1.119\tchlorobenzene dihydrodiol dehydrogenase",
    "1.3.1.120\tcyclohexane-1-carbonyl-CoA reductase (NADP(+))",
    "1.3.1.121\t4-amino-4-deoxyprephenate dehydrogenase",
    "1.3.1.122\t(S)-8-oxocitronellyl enol synthase",
    "1.3.1.123\t7-epi-iridoid synthase",
    "1.3.1.124\t2,4-dienoyl-CoA reductase [(3E)-enoyl-CoA-producing]",
    "1.3.1.n3\tcurcumin reductase",
    "1.3.2.3\tL-galactonolactone dehydrogenase",
    "1.3.3.3\tcoproporphyrinogen oxidase",
    "1.3.3.4\tprotoporphyrinogen oxidase",
    "1.3.3.5\tbilirubin oxidase",
    "1.3.3.6\tacyl-CoA oxidase",
    "1.3.3.7\tdihydrouracil oxidase",
    "1.3.3.8\ttetrahydroberberine oxidase",
    "1.3.3.10\ttryptophan alpha,beta-oxidase",
    "1.3.3.11\tpyrroloquinoline-quinone synthase",
    "1.3.3.12\tL-galactonolactone oxidase",
    "1.3.3.13\talbonoursin synthase",
    "1.3.3.14\taclacinomycin-A oxidase",
    "1.3.3.15\tcoproporphyrinogen III oxidase (coproporphyrin-forming)",
    "1.3.3.16\toxazoline dehydrogenase",
    "1.3.4.1\tfumarate reductase (CoM/CoB)",
    "1.3.5.1\tsuccinate dehydrogenase",
    "1.3.5.2\tdihydroorotate dehydrogenase (quinone)",
    "1.3.5.3\tprotoporphyrinogen IX dehydrogenase (quinone)",
    "1.3.5.4\tfumarate reductase (quinol)",
    "1.3.5.5\t15-cis-phytoene desaturase",
    "1.3.5.6\t9,9'-di-cis-zeta-carotene desaturase",
    "1.3.7.1\t6-hydroxynicotinate reductase",
    "1.3.7.2\t15,16-dihydrobiliverdin:ferredoxin oxidoreductase",
    "1.3.7.3\tphycoerythrobilin:ferredoxin oxidoreductase",
    "1.3.7.4\tphytochromobilin:ferredoxin oxidoreductase",
    "1.3.7.5\tphycocyanobilin:ferredoxin oxidoreductase",
    "1.3.7.6\tphycoerythrobilin synthase",
    "1.3.7.7\tferredoxin:protochlorophyllide reductase (ATP-dependent)",
    "1.3.7.8\tbenzoyl-CoA reductase",
    "1.3.7.11\t2,3-bis-O-geranylgeranyl-sn-glycero-phospholipid reductase",
    "1.3.7.12\tred chlorophyll catabolite reductase",
    "1.3.7.13\t3,8-divinyl protochlorophyllide a 8-vinyl-reductase (ferredoxin)",
    "1.3.7.14\t3,8-divinyl chlorophyllide a reductase",
    "1.3.7.15\tchlorophyllide a reductase",
    "1.3.8.1\tshort-chain acyl-CoA dehydrogenase",
    "1.3.8.2\t4,4'-diapophytoene desaturase (4,4'-diapolycopene-forming)",
    "1.3.8.3\t(R)-benzylsuccinyl-CoA dehydrogenase",
    "1.3.8.4\tisovaleryl-CoA dehydrogenase",
    "1.3.8.5\tshort-chain 2-methylacyl-CoA dehydrogenase",
    "1.3.8.6\tglutaryl-CoA dehydrogenase (ETF)",
    "1.3.8.7\tmedium-chain acyl-CoA dehydrogenase",
    "1.3.8.8\tlong-chain-acyl-CoA dehydrogenase",
    "1.3.8.9\tvery-long-chain acyl-CoA dehydrogenase",
    "1.3.8.10\tcyclohex-1-ene-1-carbonyl-CoA dehydrogenase",
    "1.3.8.11\tcyclohexane-1-carbonyl-CoA dehydrogenase (electron-transfer flavoprotein)",
    "1.3.8.12\t(2S)-methylsuccinyl-CoA dehydrogenase",
    "1.3.8.13\tcrotonobetainyl-CoA reductase",
    "1.3.8.14\tL-prolyl-[peptidyl-carrier protein] dehydrogenase",
    "1.3.8.15\t3-(aryl)acrylate reductase",
    "1.3.8.16\t2-amino-4-deoxychorismate dehydrogenase",
    "1.3.8.17\tdehydro coenzyme F420 reductase",
    "1.3.98.1\tdihydroorotate oxidase (fumarate)",
    "1.3.98.3\tcoproporphyrinogen dehydrogenase",
    "1.3.98.4\t5a,11a-dehydrotetracycline reductase",
    "1.3.98.5\thydrogen peroxide-dependent heme synthase",
    "1.3.98.6\tAdoMet-dependent heme synthase",
    "1.3.98.7\t[mycofactocin precursor peptide]-tyrosine decarboxylase",
    "1.3.99.4\t3-oxosteroid 1-dehydrogenase",
    "1.3.99.5\t3-oxo-5alpha-steroid 4-dehydrogenase (acceptor)",
    "1.3.99.6\t3-oxo-5beta-steroid 4-dehydrogenase",
    "1.3.99.8\t2-furoyl-CoA dehydrogenase",
    "1.3.99.12\t2-methylacyl-CoA dehydrogenase",
    "1.3.99.14\tcyclohexanone dehydrogenase",
    "1.3.99.16\tisoquinoline 1-oxidoreductase",
    "1.3.99.17\tquinoline 2-oxidoreductase",
    "1.3.99.18\tquinaldate 4-oxidoreductase",
    "1.3.99.19\tquinoline-4-carboxylate 2-oxidoreductase",
    "1.3.99.23\tall-trans-retinol 13,14-reductase",
    "1.3.99.25\tcarvone reductase",
    "1.3.99.26\tall-trans-zeta-carotene desaturase",
    "1.3.99.27\t1-hydroxycarotenoid 3,4-desaturase",
    "1.3.99.28\tphytoene desaturase (neurosporene-forming)",
    "1.3.99.29\tphytoene desaturase (zeta-carotene-forming)",
    "1.3.99.30\tphytoene desaturase (3,4-didehydrolycopene-forming)",
    "1.3.99.31\tphytoene desaturase (lycopene-forming)",
    "1.3.99.32\tglutaryl-CoA dehydrogenase (acceptor)",
    "1.3.99.33\turocanate reductase",
    "1.3.99.36\tcypemycin cysteine dehydrogenase (decarboxylating)",
    "1.3.99.37\t1-hydroxy-2-isopentenylcarotenoid 3,4-desaturase",
    "1.3.99.38\tmenaquinone-9beta-reductase",
    "1.3.99.39\tcarotenoid phi-ring synthase",
    "1.3.99.40\tcarotenoid chi-ring synthase",
    "1.3.99.n1\t3-hydroxybenzoyl-CoA reductase",
    "1.4.1.1\talanine dehydrogenase",
    "1.4.1.2\tglutamate dehydrogenase",
    "1.4.1.3\tglutamate dehydrogenase [NAD(P)(+)]",
    "1.4.1.4\tglutamate dehydrogenase (NADP(+))",
    "1.4.1.5\tL-amino-acid dehydrogenase",
    "1.4.1.7\tserine 2-dehydrogenase",
    "1.4.1.8\tvaline dehydrogenase (NADP(+))",
    "1.4.1.9\tleucine dehydrogenase",
    "1.4.1.10\tglycine dehydrogenase",
    "1.4.1.11\tL-erythro-3,5-diaminohexanoate dehydrogenase",
    "1.4.1.12\t2,4-diaminopentanoate dehydrogenase",
    "1.4.1.13\tglutamate synthase (NADPH)",
    "1.4.1.14\tglutamate synthase (NADH)",
    "1.4.1.15\tlysine dehydrogenase",
    "1.4.1.16\tdiaminopimelate dehydrogenase",
    "1.4.1.17\tN-methylalanine dehydrogenase",
    "1.4.1.18\tlysine 6-dehydrogenase",
    "1.4.1.19\ttryptophan dehydrogenase",
    "1.4.1.20\tphenylalanine dehydrogenase",
    "1.4.1.21\taspartate dehydrogenase",
    "1.4.1.23\tvaline dehydrogenase (NAD(+))",
    "1.4.1.24\t3-dehydroquinate synthase II",
    "1.4.1.25\tL-arginine dehydrogenase",
    "1.4.1.26\t2,4-diaminopentanoate dehydrogenase (NAD(+))",
    "1.4.1.27\tglycine cleavage system",
    "1.4.2.1\tglycine dehydrogenase (cytochrome)",
    "1.4.3.1\tD-aspartate oxidase",
    "1.4.3.2\tL-amino-acid oxidase",
    "1.4.3.3\tD-amino-acid oxidase",
    "1.4.3.4\tmonoamine oxidase",
    "1.4.3.5\tpyridoxal 5'-phosphate synthase",
    "1.4.3.7\tD-glutamate oxidase",
    "1.4.3.8\tethanolamine oxidase",
    "1.4.3.10\tputrescine oxidase",
    "1.4.3.11\tL-glutamate oxidase",
    "1.4.3.12\tcyclohexylamine oxidase",
    "1.4.3.13\tprotein-lysine 6-oxidase",
    "1.4.3.14\tL-lysine oxidase",
    "1.4.3.15\tD-glutamate(D-aspartate) oxidase",
    "1.4.3.16\tL-aspartate oxidase",
    "1.4.3.19\tglycine oxidase",
    "1.4.3.20\tL-lysine 6-oxidase",
    "1.4.3.21\tprimary-amine oxidase",
    "1.4.3.22\tdiamine oxidase",
    "1.4.3.23\t7-chloro-L-tryptophan oxidase",
    "1.4.3.24\tpseudooxynicotine oxidase",
    "1.4.3.25\tL-arginine oxidase",
    "1.4.3.26\tpre-mycofactocin synthase",
    "1.4.4.2\tglycine dehydrogenase (aminomethyl-transferring)",
    "1.4.5.1\tD-amino acid dehydrogenase (quinone)",
    "1.4.7.1\tglutamate synthase (ferredoxin)",
    "1.4.9.1\tmethylamine dehydrogenase (amicyanin)",
    "1.4.9.2\taralkylamine dehydrogenase (azurin)",
    "1.4.99.2\ttaurine dehydrogenase",
    "1.4.99.5\tglycine dehydrogenase (cyanide-forming)",
    "1.4.99.6\tD-arginine dehydrogenase",
    "1.5.1.1\t1-piperideine-2-carboxylate/1-pyrroline-2-carboxylate reductase [NAD(P)H]",
    "1.5.1.2\tpyrroline-5-carboxylate reductase",
    "1.5.1.3\tdihydrofolate reductase",
    "1.5.1.5\tmethylenetetrahydrofolate dehydrogenase (NADP(+))",
    "1.5.1.6\tformyltetrahydrofolate dehydrogenase",
    "1.5.1.7\tsaccharopine dehydrogenase (NAD(+), L-lysine-forming)",
    "1.5.1.8\tsaccharopine dehydrogenase (NADP(+), L-lysine-forming)",
    "1.5.1.9\tsaccharopine dehydrogenase (NAD(+), L-glutamate-forming)",
    "1.5.1.10\tsaccharopine dehydrogenase (NADP(+), L-glutamate-forming)",
    "1.5.1.11\tD-octopine dehydrogenase",
    "1.5.1.15\tmethylenetetrahydrofolate dehydrogenase (NAD(+))",
    "1.5.1.16\tD-lysopine dehydrogenase",
    "1.5.1.17\talanopine dehydrogenase",
    "1.5.1.18\t(-)-ephedrine dehydrogenase",
    "1.5.1.19\tD-nopaline dehydrogenase",
    "1.5.1.20\tmethylenetetrahydrofolate reductase [NAD(P)H]",
    "1.5.1.21\t1-piperideine-2-carboxylate/1-pyrroline-2-carboxylate reductase (NADPH)",
    "1.5.1.22\tstrombine dehydrogenase",
    "1.5.1.23\ttauropine dehydrogenase",
    "1.5.1.24\tN(5)-(carboxyethyl)ornithine synthase",
    "1.5.1.25\tthiomorpholine-carboxylate dehydrogenase",
    "1.5.1.26\tbeta-alanopine dehydrogenase",
    "1.5.1.27\t1,2-dehydroreticulinium reductase (NADPH)",
    "1.5.1.28\topine dehydrogenase",
    "1.5.1.30\tflavin reductase (NADPH)",
    "1.5.1.31\tberberine reductase",
    "1.5.1.32\tvomilenine reductase",
    "1.5.1.33\tpteridine reductase",
    "1.5.1.34\t6,7-dihydropteridine reductase",
    "1.5.1.36\tflavin reductase (NADH)",
    "1.5.1.37\tFAD reductase (NADH)",
    "1.5.1.38\tFMN reductase (NADPH)",
    "1.5.1.39\tFMN reductase [NAD(P)H]",
    "1.5.1.40\t8-hydroxy-5-deazaflavin:NADPH oxidoreductase",
    "1.5.1.41\triboflavin reductase [NAD(P)H]",
    "1.5.1.42\tFMN reductase (NADH)",
    "1.5.1.43\tcarboxynorspermidine synthase",
    "1.5.1.44\tfestuclavine dehydrogenase",
    "1.5.1.45\tFAD reductase [NAD(P)H]",
    "1.5.1.46\tagroclavine dehydrogenase",
    "1.5.1.47\tdihydromethanopterin reductase [NAD(P)(+)]",
    "1.5.1.48\t2-methyl-1-pyrroline reductase",
    "1.5.1.49\t1-pyrroline-2-carboxylate reductase [NAD(P)H]",
    "1.5.1.50\tdihydromonapterin reductase",
    "1.5.1.51\tN-[(2S)-2-amino-2-carboxyethyl]-L-glutamate dehydrogenase",
    "1.5.1.52\tstaphylopine dehydrogenase",
    "1.5.1.53\tmethylenetetrahydrofolate reductase (NADPH)",
    "1.5.1.54\tmethylenetetrahydrofolate reductase (NADH)",
    "1.5.3.1\tsarcosine oxidasee (formaldehyde-forming)",
    "1.5.3.2\tN-methyl-L-amino-acid oxidase",
    "1.5.3.4\tN(6)-methyl-lysine oxidase",
    "1.5.3.5\t(S)-6-hydroxynicotine oxidase",
    "1.5.3.6\t(R)-6-hydroxynicotine oxidase",
    "1.5.3.7\tL-pipecolate oxidase",
    "1.5.3.10\tdimethylglycine oxidase",
    "1.5.3.12\tdihydrobenzophenanthridine oxidase",
    "1.5.3.13\tN(1)-acetylpolyamine oxidase",
    "1.5.3.14\tpolyamine oxidase (propane-1,3-diamine-forming)",
    "1.5.3.15\tN(8)-acetylspermidine oxidase (propane-1,3-diamine-forming)",
    "1.5.3.16\tspermine oxidase",
    "1.5.3.17\tnon-specific polyamine oxidase",
    "1.5.3.18\tL-saccharopine oxidase",
    "1.5.3.19\t4-methylaminobutanoate oxidase (formaldehyde-forming)",
    "1.5.3.20\tN-alkylglycine oxidase",
    "1.5.3.21\t4-methylaminobutanoate oxidase (methylamine-forming)",
    "1.5.3.22\tcoenzyme F420H2 oxidase",
    "1.5.3.23\tglyphosate oxidoreductase",
    "1.5.4.1\tpyrimidodiazepine synthase",
    "1.5.5.1\telectron-transferring-flavoprotein dehydrogenase",
    "1.5.5.2\tproline dehydrogenase",
    "1.5.5.3\thydroxyproline dehydrogenase",
    "1.5.7.1\tmethylenetetrahydrofolate reductase (ferredoxin)",
    "1.5.7.2\tcoenzyme F420 oxidoreductase (ferredoxin)",
    "1.5.8.1\tdimethylamine dehydrogenase",
    "1.5.8.2\ttrimethylamine dehydrogenase",
    "1.5.8.3\tsarcosine dehydrogenase",
    "1.5.8.4\tdimethylglycine dehydrogenase",
    "1.5.98.1\tmethylenetetrahydromethanopterin dehydrogenase",
    "1.5.98.2\t5,10-methylenetetrahydromethanopterin reductase",
    "1.5.98.3\tcoenzyme F420:methanophenazine dehydrogenase",
    "1.5.99.3\tL-pipecolate dehydrogenase",
    "1.5.99.4\tnicotine dehydrogenase",
    "1.5.99.5\tmethylglutamate dehydrogenase",
    "1.5.99.6\tspermidine dehydrogenase",
    "1.5.99.12\tcytokinin dehydrogenase",
    "1.5.99.13\tD-proline dehydrogenase",
    "1.5.99.14\t6-hydroxypseudooxynicotine dehydrogenase",
    "1.5.99.15\tdihydromethanopterin reductase (acceptor)",
    "1.6.1.1\tNAD(P)(+) transhydrogenase (Si-specific)",
    "1.6.1.2\tNAD(P)(+) transhydrogenase (Re/Si-specific)",
    "1.6.1.3\tNAD(P)(+) transhydrogenase",
    "1.6.1.4\tNAD(P)(+) transhydrogenase (ferredoxin)",
    "1.6.2.2\tcytochrome-b5 reductase",
    "1.6.2.4\tNADPH--hemoprotein reductase",
    "1.6.2.5\tNADPH--cytochrome-c2 reductase",
    "1.6.2.6\tleghemoglobin reductase",
    "1.6.3.1\tNAD(P)H oxidase (H2O2-forming)",
    "1.6.3.2\tNAD(P)H oxidase (H2O-forming)",
    "1.6.3.3\tNADH oxidase (H2O2-forming)",
    "1.6.3.4\tNADH oxidase (H2O-forming)",
    "1.6.3.5\trenalase",
    "1.6.5.2\tNAD(P)H dehydrogenase (quinone)",
    "1.6.5.4\tmonodehydroascorbate reductase (NADH)",
    "1.6.5.5\tNADPH:quinone reductase",
    "1.6.5.6\tp-benzoquinone reductase (NADPH)",
    "1.6.5.7\t2-hydroxy-1,4-benzoquinone reductase",
    "1.6.5.9\tNADH:ubiquinone reductase (non-electrogenic)",
    "1.6.5.10\tNADPH dehydrogenase (quinone)",
    "1.6.5.12\tdemethylphylloquinone reductase",
    "1.6.99.1\tNADPH dehydrogenase",
    "1.6.99.n1\tNADPH dehydrogenase (coenzyme F420 dependent)",
    "1.7.1.1\tnitrate reductase (NADH)",
    "1.7.1.2\tnitrate reductase [NAD(P)H]",
    "1.7.1.3\tnitrate reductase (NADPH)",
    "1.7.1.4\tnitrite reductase [NAD(P)H]",
    "1.7.1.5\thyponitrite reductase",
    "1.7.1.6\tazobenzene reductase",
    "1.7.1.7\tGMP reductase",
    "1.7.1.9\tnitroquinoline-N-oxide reductase",
    "1.7.1.10\thydroxylamine reductase (NADH)",
    "1.7.1.11\t4-(dimethylamino)phenylazoxybenzene reductase",
    "1.7.1.12\tN-hydroxy-2-acetamidofluorene reductase",
    "1.7.1.13\tpreQ1 synthase",
    "1.7.1.14\tnitric oxide reductase [NAD(P)(+), nitrous oxide-forming]",
    "1.7.1.15\tnitrite reductase (NADH)",
    "1.7.1.16\tnitrobenzene nitroreductase",
    "1.7.1.17\tFMN-dependent NADH-azoreductase",
    "1.7.2.1\tnitrite reductase (NO-forming)",
    "1.7.2.2\tnitrite reductase (cytochrome; ammonia-forming)",
    "1.7.2.3\ttrimethylamine-N-oxide reductase",
    "1.7.2.4\tnitrous-oxide reductase",
    "1.7.2.5\tnitric-oxide reductase (cytochrome c)",
    "1.7.2.6\thydroxylamine dehydrogenase",
    "1.7.2.7\thydrazine synthase",
    "1.7.2.8\thydrazine dehydrogenase",
    "1.7.2.9\thydroxylamine oxidase",
    "1.7.3.1\tnitroalkane oxidase",
    "1.7.3.2\tacetylindoxyl oxidase",
    "1.7.3.3\tfactor independent urate hydroxylase",
    "1.7.3.5\t3-aci-nitropropanoate oxidase",
    "1.7.3.6\thydroxylamine oxidase (cytochrome)",
    "1.7.5.1\tnitrate reductase (quinone)",
    "1.7.5.2\tnitric oxide reductase (menaquinol)",
    "1.7.6.1\tnitrite dismutase",
    "1.7.7.1\tferredoxin--nitrite reductase",
    "1.7.7.2\tferredoxin--nitrate reductase",
    "1.7.99.1\thydroxylamine reductase",
    "1.8.1.2\tassimilatory sulfite reductase (NADPH)",
    "1.8.1.3\thypotaurine dehydrogenase",
    "1.8.1.4\tdihydrolipoyl dehydrogenase",
    "1.8.1.5\t2-oxopropyl-CoM reductase (carboxylating)",
    "1.8.1.6\tcystine reductase",
    "1.8.1.7\tglutathione-disulfide reductase",
    "1.8.1.8\tprotein-disulfide reductase",
    "1.8.1.9\tthioredoxin-disulfide reductase",
    "1.8.1.10\tCoA-glutathione reductase",
    "1.8.1.11\tasparagusate reductase",
    "1.8.1.12\ttrypanothione-disulfide reductase",
    "1.8.1.13\tbis-gamma-glutamylcystine reductase",
    "1.8.1.14\tCoA-disulfide reductase",
    "1.8.1.15\tmycothione reductase",
    "1.8.1.16\tglutathione amide reductase",
    "1.8.1.17\tdimethylsulfone reductase",
    "1.8.1.18\tNAD(P)H sulfur oxidoreductase (CoA-dependent)",
    "1.8.1.19\tsulfide dehydrogenase",
    "1.8.1.20\t4,4'-dithiodibutanoate disulfide reductase",
    "1.8.1.21\tdissimilatory dimethyldisulfide reductase",
    "1.8.2.1\tsulfite dehydrogenase (cytochrome)",
    "1.8.2.2\tthiosulfate dehydrogenase",
    "1.8.2.3\tsulfide-cytochrome-c reductase (flavocytochrome c)",
    "1.8.2.4\tdimethyl sulfide:cytochrome c2 reductase",
    "1.8.2.5\tthiosulfate reductase (cytochrome)",
    "1.8.2.6\tS-disulfanyl-L-cysteine oxidoreductase",
    "1.8.2.7\tthiocyanate desulfurase",
    "1.8.3.1\tsulfite oxidase",
    "1.8.3.2\tthiol oxidase",
    "1.8.3.3\tglutathione oxidase",
    "1.8.3.4\tmethanethiol oxidase",
    "1.8.3.5\tprenylcysteine oxidase",
    "1.8.3.6\tfarnesylcysteine lyase",
    "1.8.3.7\tformylglycine-generating enzyme",
    "1.8.4.1\tglutathione--homocystine transhydrogenase",
    "1.8.4.2\tprotein-disulfide reductase (glutathione)",
    "1.8.4.3\tglutathione--CoA-glutathione transhydrogenase",
    "1.8.4.4\tglutathione--cystine transhydrogenase",
    "1.8.4.7\tenzyme-thiol transhydrogenase (glutathione-disulfide)",
    "1.8.4.8\tphosphoadenylyl-sulfate reductase (thioredoxin)",
    "1.8.4.9\tadenylyl-sulfate reductase (glutathione)",
    "1.8.4.10\tadenylyl-sulfate reductase (thioredoxin)",
    "1.8.4.11\tpeptide-methionine (S)-S-oxide reductase",
    "1.8.4.12\tpeptide-methionine (R)-S-oxide reductase",
    "1.8.4.13\tL-methionine (S)-S-oxide reductase",
    "1.8.4.14\tL-methionine (R)-S-oxide reductase",
    "1.8.4.15\tprotein dithiol oxidoreductase (disulfide-forming)",
    "1.8.4.16\tthioredoxin:protein disulfide reductase",
    "1.8.5.1\tglutathione dehydrogenase (ascorbate)",
    "1.8.5.2\tthiosulfate dehydrogenase (quinone)",
    "1.8.5.3\trespiratory dimethylsulfoxide reductase",
    "1.8.5.4\tbacterial sulfide:quinone reductase",
    "1.8.5.5\tthiosulfate reductase (quinone)",
    "1.8.5.6\tsulfite dehydrogenase (quinone)",
    "1.8.5.7\tglutathionyl-hydroquinone reductase",
    "1.8.5.8\teukaryotic sulfide quinone oxidoreductase",
    "1.8.5.9\tprotein dithiol:quinone oxidoreductase DsbB",
    "1.8.7.1\tassimilatory sulfite reductase (ferredoxin)",
    "1.8.7.2\tferredoxin:thioredoxin reductase",
    "1.8.7.3\tferredoxin:CoB-CoM heterodisulfide reductase",
    "1.8.98.1\tdihydromethanophenazine:CoB--CoM heterodisulfide reductase",
    "1.8.98.2\tsulfiredoxin",
    "1.8.98.3\tsulfite reductase (coenzyme F420)",
    "1.8.98.4\tcoenzyme F420:CoB-CoM heterodisulfide,ferredoxin reductase",
    "1.8.98.5\tH2:CoB-CoM heterodisulfide,ferredoxin reductase",
    "1.8.98.6\tformate:CoB-CoM heterodisulfide,ferredoxin reductase",
    "1.8.98.7\tcysteine-type anaerobic sulfatase-maturating enzyme",
    "1.8.99.2\tadenylyl-sulfate reductase",
    "1.8.99.5\tdissimilatory sulfite reductase",
    "1.9.6.1\tnitrate reductase (cytochrome)",
    "1.9.98.1\tiron--cytochrome-c reductase",
    "1.10.1.1\ttrans-acenaphthene-1,2-diol dehydrogenase",
    "1.10.3.1\tcatechol oxidase",
    "1.10.3.2\tlaccase",
    "1.10.3.3\tL-ascorbate oxidase",
    "1.10.3.4\to-aminophenol oxidase",
    "1.10.3.5\t3-hydroxyanthranilate oxidase",
    "1.10.3.6\trifamycin-B oxidase",
    "1.10.3.9\tphotosystem II",
    "1.10.3.11\tubiquinol oxidase (non-electrogenic)",
    "1.10.3.15\tgrixazone synthase",
    "1.10.3.16\tdihydrophenazinedicarboxylate synthase",
    "1.10.3.17\tsuperoxide oxidase",
    "1.10.5.1\tribosyldihydronicotinamide dehydrogenase (quinone)",
    "1.11.1.1\tNADH peroxidase",
    "1.11.1.2\tNADPH peroxidase",
    "1.11.1.3\tfatty-acid peroxidase",
    "1.11.1.5\tcytochrome-c peroxidase",
    "1.11.1.6\tcatalase",
    "1.11.1.7\tperoxidase",
    "1.11.1.8\tiodide peroxidase",
    "1.11.1.9\tglutathione peroxidase",
    "1.11.1.10\tchloride peroxidase",
    "1.11.1.11\tL-ascorbate peroxidase",
    "1.11.1.12\tphospholipid-hydroperoxide glutathione peroxidase",
    "1.11.1.13\tmanganese peroxidase",
    "1.11.1.14\tlignin peroxidase",
    "1.11.1.16\tversatile peroxidase",
    "1.11.1.17\tglutathione amide-dependent peroxidase",
    "1.11.1.18\tbromide peroxidase",
    "1.11.1.19\tdye decolorizing peroxidase",
    "1.11.1.20\tprostamide/prostaglandin F2alpha synthase",
    "1.11.1.21\tcatalase peroxidase",
    "1.11.1.22\thydroperoxy fatty acid reductase",
    "1.11.1.23\t(S)-2-hydroxypropylphosphonic acid epoxidase",
    "1.11.1.24\tthioredoxin-dependent peroxiredoxin",
    "1.11.1.25\tglutaredoxin-dependent peroxiredoxin",
    "1.11.1.26\tNADH-dependent peroxiredoxin",
    "1.11.1.27\tglutathione-dependent peroxiredoxin",
    "1.11.1.28\tlipoyl-dependent peroxiredoxin",
    "1.11.1.29\tmycoredoxin-dependent peroxiredoxin",
    "1.11.2.1\tunspecific peroxygenase",
    "1.11.2.2\tmyeloperoxidase",
    "1.11.2.3\tplant seed peroxygenase",
    "1.11.2.4\tfatty-acid peroxygenase",
    "1.11.2.5\t3-methyl-L-tyrosine peroxygenase",
    "1.11.2.6\tL-tyrosine peroxygenase",
    "1.12.1.2\thydrogen dehydrogenase",
    "1.12.1.3\thydrogen dehydrogenase (NADP(+))",
    "1.12.1.4\thydrogenase (NAD(+), ferredoxin)",
    "1.12.1.5\thydrogen dehydrogenase [NAD(P)(+)]",
    "1.12.2.1\tcytochrome-c3 hydrogenase",
    "1.12.5.1\thydrogen:quinone oxidoreductase",
    "1.12.7.2\tferredoxin hydrogenase",
    "1.12.98.1\tcoenzyme F420 hydrogenase",
    "1.12.98.2\t5,10-methenyltetrahydromethanopterin hydrogenase",
    "1.12.98.3\tMethanosarcina-phenazine hydrogenase",
    "1.12.98.4\tsulfhydrogenase",
    "1.12.99.6\thydrogenase (acceptor)",
    "1.13.11.1\tcatechol 1,2-dioxygenase",
    "1.13.11.2\tcatechol 2,3-dioxygenase",
    "1.13.11.3\tprotocatechuate 3,4-dioxygenase",
    "1.13.11.4\tgentisate 1,2-dioxygenase",
    "1.13.11.5\thomogentisate 1,2-dioxygenase",
    "1.13.11.6\t3-hydroxyanthranilate 3,4-dioxygenase",
    "1.13.11.8\tprotocatechuate 4,5-dioxygenase",
    "1.13.11.9\t2,5-dihydroxypyridine 5,6-dioxygenase",
    "1.13.11.10\t7,8-dihydroxykynurenate 8,8a-dioxygenase",
    "1.13.11.11\ttryptophan 2,3-dioxygenase",
    "1.13.11.12\tlinoleate 13S-lipoxygenase",
    "1.13.11.14\t2,3-dihydroxybenzoate 3,4-dioxygenase",
    "1.13.11.15\t3,4-dihydroxyphenylacetate 2,3-dioxygenase",
    "1.13.11.16\t3-carboxyethylcatechol 2,3-dioxygenase",
    "1.13.11.17\tindole 2,3-dioxygenase",
    "1.13.11.18\tpersulfide dioxygenase",
    "1.13.11.19\tcysteamine dioxygenase",
    "1.13.11.20\tcysteine dioxygenase",
    "1.13.11.22\tcaffeate 3,4-dioxygenase",
    "1.13.11.23\t2,3-dihydroxyindole 2,3-dioxygenase",
    "1.13.11.24\tquercetin 2,3-dioxygenase",
    "1.13.11.25\t3,4-dihydroxy-9,10-secoandrosta-1,3,5(10)-triene-9,17-dione 4,5-dioxygenase",
    "1.13.11.26\tpeptide-tryptophan 2,3-dioxygenase",
    "1.13.11.27\t4-hydroxyphenylpyruvate dioxygenase",
    "1.13.11.28\t2,3-dihydroxybenzoate 2,3-dioxygenase",
    "1.13.11.29\tstizolobate synthase",
    "1.13.11.30\tstizolobinate synthase",
    "1.13.11.31\tarachidonate 12-lipoxygenase",
    "1.13.11.33\tarachidonate 15-lipoxygenase",
    "1.13.11.34\tarachidonate 5-lipoxygenase",
    "1.13.11.35\tpyrogallol 1,2-oxygenase",
    "1.13.11.36\tchloridazon-catechol dioxygenase",
    "1.13.11.37\thydroxyquinol 1,2-dioxygenase",
    "1.13.11.38\t1-hydroxy-2-naphthoate 1,2-dioxygenase",
    "1.13.11.39\tbiphenyl-2,3-diol 1,2-dioxygenase",
    "1.13.11.40\tarachidonate 8-lipoxygenase",
    "1.13.11.41\t2,4'-dihydroxyacetophenone dioxygenase",
    "1.13.11.43\tlignostilbene alphabeta-dioxygenase",
    "1.13.11.45\tlinoleate 11-lipoxygenase",
    "1.13.11.46\t4-hydroxymandelate synthase",
    "1.13.11.47\t3-hydroxy-4-oxoquinoline 2,4-dioxygenase",
    "1.13.11.48\t3-hydroxy-2-methylquinolin-4-one 2,4-dioxygenase",
    "1.13.11.49\tchlorite O2-lyase",
    "1.13.11.50\tacetylacetone-cleaving enzyme",
    "1.13.11.51\t9-cis-epoxycarotenoid dioxygenase",
    "1.13.11.52\tindoleamine 2,3-dioxygenase",
    "1.13.11.53\tacireductone dioxygenase (Ni(2+)-requiring)",
    "1.13.11.54\tacireductone dioxygenase (Fe(2+)-requiring)",
    "1.13.11.55\tsulfur oxygenase/reductase",
    "1.13.11.56\t1,2-dihydroxynaphthalene dioxygenase",
    "1.13.11.57\tgallate dioxygenase",
    "1.13.11.58\tlinoleate 9S-lipoxygenase",
    "1.13.11.59\ttorulene dioxygenase",
    "1.13.11.60\tlinoleate 8R-lipoxygenase",
    "1.13.11.61\tlinolenate 9R-lipoxygenase",
    "1.13.11.62\tlinoleate 10R-lipoxygenase",
    "1.13.11.63\tbeta-carotene 15,15'-dioxygenase",
    "1.13.11.64\t5-nitrosalicylate dioxygenase",
    "1.13.11.65\tcarotenoid isomerooxygenase",
    "1.13.11.66\thydroquinone 1,2-dioxygenase",
    "1.13.11.67\t8'-apo-beta-carotenoid 14',13'-cleaving dioxygenase",
    "1.13.11.68\t9-cis-beta-carotene 9',10'-cleaving dioxygenase",
    "1.13.11.69\tcarlactone synthase",
    "1.13.11.70\tall-trans-10'-apo-beta-carotenal 13,14-cleaving dioxygenase",
    "1.13.11.71\tcarotenoid-9',10'-cleaving dioxygenase",
    "1.13.11.72\t2-hydroxyethylphosphonate dioxygenase",
    "1.13.11.73\tmethylphosphonate synthase",
    "1.13.11.74\t2-aminophenol 1,6-dioxygenase",
    "1.13.11.75\tall-trans-8'-apo-beta-carotenal 15,15'-oxygenase",
    "1.13.11.76\t2-amino-5-chlorophenol 1,6-dioxygenase",
    "1.13.11.77\toleate 10S-lipoxygenase",
    "1.13.11.78\t2-amino-1-hydroxyethylphosphonate dioxygenase (glycine-forming)",
    "1.13.11.79\taerobic 5,6-dimethylbenzimidazole synthase",
    "1.13.11.80\t(3,5-dihydroxyphenyl)acetyl-CoA 1,2-dioxygenase",
    "1.13.11.81\t7,8-dihydroneopterin oxygenase",
    "1.13.11.82\t8'-apo-carotenoid 13,14-cleaving dioxygenase",
    "1.13.11.83\t4-hydroxy-3-prenylphenylpyruvate oxygenase",
    "1.13.11.84\tcrocetin dialdehyde synthase",
    "1.13.11.85\texo-cleaving rubber dioxygenase",
    "1.13.11.86\t5-aminosalicylate 1,2-dioxygenase",
    "1.13.11.87\tendo-cleaving rubber dioxygenase",
    "1.13.11.88\tisoeugenol monooxygenase",
    "1.13.11.89\t(hydroxymethyl)phosphonate dioxygenase",
    "1.13.11.90\t[1-hydroxy-2-(trimethylamino)ethyl]phosphonate dioxygenase (glycine-betaine-forming)",
    "1.13.11.91\t3-mercaptopropionate dioxygenase",
    "1.13.11.92\tfatty acid alpha-dioxygenase",
    "1.13.12.1\targinine 2-monooxygenase",
    "1.13.12.2\tlysine 2-monooxygenase",
    "1.13.12.3\ttryptophan 2-monooxygenase",
    "1.13.12.4\tlactate 2-monooxygenase",
    "1.13.12.5\tRenilla-type luciferase",
    "1.13.12.6\tCypridina-luciferin 2-monooxygenase",
    "1.13.12.7\tfirefly luciferase",
    "1.13.12.8\tWatasenia-luciferin 2-monooxygenase",
    "1.13.12.9\tphenylalanine 2-monooxygenase",
    "1.13.12.13\tOplophorus-luciferin 2-monooxygenase",
    "1.13.12.15\t3,4-dihydroxyphenylalanine oxidative deaminase",
    "1.13.12.16\tnitronate monooxygenase",
    "1.13.12.17\tdichloroarcyriaflavin A synthase",
    "1.13.12.18\tdinoflagellate luciferase",
    "1.13.12.19\t2-oxoglutarate dioxygenase (ethylene-forming)",
    "1.13.12.20\tnoranthrone monooxygenase",
    "1.13.12.21\ttetracenomycin-F1 monooxygenase",
    "1.13.12.22\tdeoxynogalonate monooxygenase",
    "1.13.12.23\t4-hydroxy-3-prenylbenzoate synthase",
    "1.13.12.24\tcalcium-regulated photoprotein",
    "1.13.99.1\tinositol oxygenase",
    "1.13.99.3\ttryptophan 2'-dioxygenase",
    "1.14.11.1\tgamma-butyrobetaine dioxygenase",
    "1.14.11.2\tprocollagen-proline 4-dioxygenase",
    "1.14.11.3\tpyrimidine-deoxynucleoside 2'-dioxygenase",
    "1.14.11.4\tprocollagen-lysine 5-dioxygenase",
    "1.14.11.6\tthymine dioxygenase",
    "1.14.11.7\tprocollagen-proline 3-dioxygenase",
    "1.14.11.8\ttrimethyllysine dioxygenase",
    "1.14.11.9\tflavanone 3-dioxygenase",
    "1.14.11.10\tpyrimidine-deoxynucleoside 1'-dioxygenase",
    "1.14.11.11\thyoscyamine (6S)-dioxygenase",
    "1.14.11.12\tgibberellin-44 dioxygenase",
    "1.14.11.13\tgibberellin 2beta-dioxygenase",
    "1.14.11.15\tgibberellin 3beta-dioxygenase",
    "1.14.11.16\tpeptide-aspartate beta-dioxygenase",
    "1.14.11.17\ttaurine dioxygenase",
    "1.14.11.18\tphytanoyl-CoA dioxygenase",
    "1.14.11.20\tdeacetoxyvindoline 4-hydroxylase",
    "1.14.11.21\tclavaminate synthase",
    "1.14.11.24\t2'-deoxymugineic-acid 2'-dioxygenase",
    "1.14.11.25\tmugineic-acid 3-dioxygenase",
    "1.14.11.26\tdeacetoxycephalosporin-C hydroxylase",
    "1.14.11.27\t[histone H3]-dimethyl-L-lysine(36) demethylase",
    "1.14.11.28\tproline 3-hydroxylase",
    "1.14.11.29\thypoxia-inducible factor-proline dioxygenase",
    "1.14.11.30\thypoxia-inducible factor-asparagine dioxygenase",
    "1.14.11.31\tthebaine 6-O-demethylase",
    "1.14.11.32\tcodeine 3-O-demethylase",
    "1.14.11.33\tDNA oxidative demethylase",
    "1.14.11.35\t1-deoxypentalenic acid 11beta-hydroxylase",
    "1.14.11.36\tpentalenolactone F synthase",
    "1.14.11.37\tkanamycin B dioxygenase",
    "1.14.11.38\tverruculogen synthase",
    "1.14.11.39\tL-asparagine oxygenase",
    "1.14.11.40\tenduracididine beta-hydroxylase",
    "1.14.11.41\tL-arginine hydroxylase",
    "1.14.11.42\ttRNA(Phe) (7-(3-amino-3-carboxypropyl)wyosine(37)-C(2))-hydroxylase",
    "1.14.11.43\t(S)-dichlorprop dioxygenase (2-oxoglutarate)",
    "1.14.11.44\t(R)-dichlorprop dioxygenase (2-oxoglutarate)",
    "1.14.11.45\tL-isoleucine 4-hydroxylase",
    "1.14.11.46\t2-aminoethylphosphonate dioxygenase",
    "1.14.11.47\t[50S ribosomal protein L16]-arginine 3-hydroxylase",
    "1.14.11.48\txanthine dioxygenase",
    "1.14.11.49\turidine-5'-phosphate dioxygenase",
    "1.14.11.51\tDNA N(6)-methyladenine demethylase",
    "1.14.11.52\tvalidamycin A dioxygenase",
    "1.14.11.53\tmRNA N(6)-methyladenine demethylase",
    "1.14.11.54\tmRNA N(1)-methyladenine demethylase",
    "1.14.11.55\tectoine hydroxylase",
    "1.14.11.56\tL-proline cis-4-hydroxylase",
    "1.14.11.57\tL-proline trans-4-hydroxylase",
    "1.14.11.58\tornithine lipid ester-linked acyl 2-hydroxylase",
    "1.14.11.59\t2,4-dihydroxy-1,4-benzoxazin-3-one-glucoside dioxygenase",
    "1.14.11.60\tscopoletin 8-hydroxylase",
    "1.14.11.61\tferuloyl-CoA 6-hydroxylase",
    "1.14.11.62\ttrans-4-coumaroyl-CoA 2'-hydroxylase",
    "1.14.11.63\tpeptidyl-lysine (3S)-dioxygenase",
    "1.14.11.64\tglutarate dioxygenase",
    "1.14.11.65\t[histone H3]-dimethyl-L-lysine(9) demethylase",
    "1.14.11.66\t[histone H3]-trimethyl-L-lysine(9) demethylase",
    "1.14.11.67\t[histone H3]-trimethyl-L-lysine(4) demethylase",
    "1.14.11.68\t[histone H3]-trimethyl-L-lysine(27) demethylase",
    "1.14.11.69\t[histone H3]-trimethyl-L-lysine(36) demethylase",
    "1.14.11.70\t7-deoxycylindrospermopsin hydroxylase",
    "1.14.11.71\tmethylphosphonate hydroxylase",
    "1.14.11.72\t[2-(trimethylamino)ethyl]phosphonate dioxygenase",
    "1.14.11.73\t[protein]-arginine 3-hydroxylase",
    "1.14.11.74\tL-isoleucine 3(1)-dioxygenase",
    "1.14.11.75\t3(1)-hydroxy-L-isoleucine 4-dioxygenase",
    "1.14.11.76\tL-glutamate 3(R)-hydroxylase",
    "1.14.11.77\talkyl sulfatase",
    "1.14.11.n2\tmethylcytosine dioxygenase",
    "1.14.11.n4\tankyrin-repeat-histidine dioxagenase",
    "1.14.12.1\tanthranilate 1,2-dioxygenase (deaminating, decarboxylating)",
    "1.14.12.3\tbenzene 1,2-dioxygenase",
    "1.14.12.7\tphthalate 4,5-dioxygenase",
    "1.14.12.8\t4-sulfobenzoate 3,4-dioxygenase",
    "1.14.12.9\t4-chlorophenylacetate 3,4-dioxygenase",
    "1.14.12.10\tbenzoate 1,2-dioxygenase",
    "1.14.12.11\ttoluene dioxygenase",
    "1.14.12.12\tnaphthalene 1,2-dioxygenase",
    "1.14.12.13\t2-halobenzoate 1,2-dioxygenase",
    "1.14.12.14\t2-aminobenzenesulfonate 2,3-dioxygenase",
    "1.14.12.15\tterephthalate 1,2-dioxygenase",
    "1.14.12.16\t2-hydroxyquinoline 5,6-dioxygenase",
    "1.14.12.17\tnitric oxide dioxygenase",
    "1.14.12.18\tbiphenyl 2,3-dioxygenase",
    "1.14.12.19\t3-phenylpropanoate dioxygenase",
    "1.14.12.22\tcarbazole 1,9a-dioxygenase",
    "1.14.12.23\tnitroarene dioxygenase",
    "1.14.12.24\t2,4-dinitrotoluene dioxygenase",
    "1.14.12.25\tp-cumate 2,3-dioxygenase",
    "1.14.12.26\tchlorobenzene dioxygenase",
    "1.14.13.1\tsalicylate 1-monooxygenase",
    "1.14.13.2\t4-hydroxybenzoate 3-monooxygenase",
    "1.14.13.4\tmelilotate 3-monooxygenase",
    "1.14.13.5\timidazoleacetate 4-monooxygenase",
    "1.14.13.6\torcinol 2-monooxygenase",
    "1.14.13.7\tphenol 2-monooxygenase (NADPH)",
    "1.14.13.8\tflavin-containing monooxygenase",
    "1.14.13.9\tkynurenine 3-monooxygenase",
    "1.14.13.10\t2,6-dihydroxypyridine 3-monooxygenase",
    "1.14.13.14\ttrans-cinnamate 2-monooxygenase",
    "1.14.13.16\tcyclopentanone monooxygenase",
    "1.14.13.18\t4-hydroxyphenylacetate 1-monooxygenase",
    "1.14.13.19\ttaxifolin 8-monooxygenase",
    "1.14.13.20\t2,4-dichlorophenol 6-monooxygenase",
    "1.14.13.22\tcyclohexanone monooxygenase",
    "1.14.13.23\t3-hydroxybenzoate 4-monooxygenase",
    "1.14.13.24\t3-hydroxybenzoate 6-monooxygenase",
    "1.14.13.25\tmethane monooxygenase (soluble)",
    "1.14.13.27\t4-aminobenzoate 1-monooxygenase",
    "1.14.13.29\t4-nitrophenol 2-monooxygenase",
    "1.14.13.31\t2-nitrophenol 2-monooxygenase",
    "1.14.13.32\talbendazole monooxygenase",
    "1.14.13.33\t4-hydroxybenzoate 3-monooxygenase [NAD(P)H]",
    "1.14.13.34\tleukotriene-E4 20-monooxygenase",
    "1.14.13.35\tanthranilate 3-monooxygenase (deaminating)",
    "1.14.13.38\tanhydrotetracycline 6-monooxygenase",
    "1.14.13.39\tnitric-oxide synthase (NADPH)",
    "1.14.13.40\tanthraniloyl-CoA monooxygenase",
    "1.14.13.43\tquestin monooxygenase",
    "1.14.13.44\t2-hydroxybiphenyl 3-monooxygenase",
    "1.14.13.46\t(-)-menthol monooxygenase",
    "1.14.13.50\tpentachlorophenol monooxygenase",
    "1.14.13.51\t6-oxocineole dehydrogenase",
    "1.14.13.54\tketosteroid monooxygenase",
    "1.14.13.58\tbenzoyl-CoA 3-monooxygenase",
    "1.14.13.59\tL-lysine N(6)-monooxygenase (NADPH)",
    "1.14.13.61\t2-hydroxyquinoline 8-monooxygenase",
    "1.14.13.62\t4-hydroxyquinoline 3-monooxygenase",
    "1.14.13.63\t3-hydroxyphenylacetate 6-hydroxylase",
    "1.14.13.64\t4-hydroxybenzoate 1-hydroxylase",
    "1.14.13.66\t2-hydroxycyclohexanone 2-monooxygenase",
    "1.14.13.69\talkene monooxygenase",
    "1.14.13.81\tmagnesium-protoporphyrin IX monomethyl ester (oxidative) cyclase",
    "1.14.13.82\tvanillate monooxygenase",
    "1.14.13.83\tprecorrin-3B synthase",
    "1.14.13.84\t4-hydroxyacetophenone monooxygenase",
    "1.14.13.92\tphenylacetone monooxygenase",
    "1.14.13.101\tsenecionine N-oxygenase",
    "1.14.13.105\tmonocyclic monoterpene ketone monooxygenase",
    "1.14.13.107\tlimonene 1,2-monooxygenase",
    "1.14.13.111\tmethanesulfonate monooxygenase (NADH)",
    "1.14.13.113\tFAD-dependent urate hydroxylase",
    "1.14.13.114\t6-hydroxynicotinate 3-monooxygenase",
    "1.14.13.122\tchlorophyllide a oxygenase",
    "1.14.13.127\t3-(3-hydroxy-phenyl)propanoic acid hydroxylase",
    "1.14.13.128\t7-methylxanthine demethylase",
    "1.14.13.130\tpyrrole-2-carboxylate monooxygenase",
    "1.14.13.131\tdissimilatory dimethyl-sulfide monooxygenase",
    "1.14.13.135\t1-hydroxy-2-naphthoate hydroxylase",
    "1.14.13.146\ttaxoid 14beta-hydroxylase",
    "1.14.13.147\ttaxoid 7beta-hydroxylase",
    "1.14.13.148\ttrimethylamine monooxygenase",
    "1.14.13.149\tphenylacetyl-CoA 1,2-epoxidase",
    "1.14.13.153\t(+)-sabinene 3-hydroxylase",
    "1.14.13.154\terythromycin 12 hydroxylase",
    "1.14.13.155\talpha-pinene monooxygenase",
    "1.14.13.160\t(2,2,3-trimethyl-5-oxocyclopent-3-enyl)acetyl-CoA 1,5-monooxygenase",
    "1.14.13.161\t(+)-camphor 6-exo-hydroxylase",
    "1.14.13.163\t6-hydroxy-3-succinoylpyridine 3-monooxygenase",
    "1.14.13.166\t4-nitrocatechol 4-monooxygenase",
    "1.14.13.167\t4-nitrophenol 4-monooxygenase",
    "1.14.13.168\tindole-3-pyruvate monooxygenase",
    "1.14.13.170\tpentalenolactone D synthase",
    "1.14.13.171\tneopentalenolactone D synthase",
    "1.14.13.172\tsalicylate 5-hydroxylase",
    "1.14.13.178\tmethylxanthine N(1)-demethylase",
    "1.14.13.179\tmethylxanthine N(3)-demethylase",
    "1.14.13.180\taklavinone 12-hydroxylase",
    "1.14.13.181\t13-deoxydaunorubicin hydroxylase",
    "1.14.13.182\t2-heptyl-3-hydroxy-4(1H)-quinolone synthase",
    "1.14.13.187\tL-evernosamine nitrososynthase",
    "1.14.13.189\t5-methyl-1-naphthoate 3-hydroxylase",
    "1.14.13.195\tL-ornithine N(5)-monooxygenase (NADPH)",
    "1.14.13.196\tL-ornithine N(5)-monooxygenase [NAD(P)H]",
    "1.14.13.200\ttetracenomycin A2 monooxygenase-diooxygenase",
    "1.14.13.208\tbenzoyl-CoA 2,3-epoxidase",
    "1.14.13.209\tsalicyloyl-CoA 5-hydroxylase",
    "1.14.13.210\t4-methyl-5-nitrocatechol 5-monooxygenase",
    "1.14.13.211\trifampicin monooxygenase",
    "1.14.13.212\t1,3,7-trimethyluric acid 5-monooxygenase",
    "1.14.13.215\tprotoasukamycin 4-monooxygenase",
    "1.14.13.216\tasperlicin C monooxygenase",
    "1.14.13.217\tprotodeoxyviolaceinate monooxygenase",
    "1.14.13.218\t5-methylphenazine-1-carboxylate 1-monooxygenase",
    "1.14.13.219\tresorcinol 4-hydroxylase (NADPH)",
    "1.14.13.220\tresorcinol 4-hydroxylase (NADH)",
    "1.14.13.222\taurachin C monooxygenase/isomerase",
    "1.14.13.223\t3-hydroxy-4-methyl-anthranilyl-[aryl-carrier protein] 5-monooxygenase",
    "1.14.13.224\tviolacein synthase",
    "1.14.13.225\tF-actin monooxygenase",
    "1.14.13.226\tacetone monooxygenase (methyl acetate-forming)",
    "1.14.13.227\tpropane 2-monooxygenase",
    "1.14.13.228\tjasmomic acid 12-hydroxylase",
    "1.14.13.229\ttert-butanol monooxygenase",
    "1.14.13.230\tbutane monooxygenase (soluble)",
    "1.14.13.231\ttetracycline 11a-monooxygenase",
    "1.14.13.232\t6-methylpretetramide 4-monooxygenase",
    "1.14.13.233\t4-hydroxy-6-methylpretetramide 12a-monooxygenase",
    "1.14.13.234\t12-dehydrotetracycline 5-monooxygenase",
    "1.14.13.235\tindole-3-acetate monooxygenase",
    "1.14.13.236\ttoluene 4-monooxygenase",
    "1.14.13.237\taliphatic glucosinolate S-oxygenase",
    "1.14.13.238\tdimethylamine monooxygenase",
    "1.14.13.239\tcarnitine monooxygenase",
    "1.14.13.240\t2-polyprenylphenol 6-hydroxylase",
    "1.14.13.241\t5-pyridoxate monooxygenase",
    "1.14.13.242\t3-hydroxy-2-methylpyridine-5-carboxylate monooxygenase",
    "1.14.13.243\ttoluene 2-monooxygenase",
    "1.14.13.244\tphenol 2-monooxygenase (NADH)",
    "1.14.13.245\tassimilatory dimethylsulfide S-monooxygenase",
    "1.14.13.246\t4beta-methylsterol monooxygenase",
    "1.14.13.247\tstachydrine N-demethylase",
    "1.14.13.248\tL-aspartate N-monooxygenase (nitrosuccinate-forming)",
    "1.14.13.249\t3-amino-4-hydroxybenzoate 2-monooxygenase",
    "1.14.13.250\tnitrosourea synthase",
    "1.14.13.n6\thexahomomethionine N-hydroxylase",
    "1.14.13.n7\t4-nitrophenol 2-hydroxylase",
    "1.14.14.1\tunspecific monooxygenase",
    "1.14.14.3\tbacterial luciferase",
    "1.14.14.5\talkanesulfonate monooxygenase",
    "1.14.14.8\tanthranilate 3-monooxygenase (FAD)",
    "1.14.14.9\t4-hydroxyphenylacetate 3-monooxygenase",
    "1.14.14.10\tnitrilotriacetate monooxygenase",
    "1.14.14.11\tstyrene monooxygenase",
    "1.14.14.12\t3-hydroxy-9,10-secoandrosta-1,3,5(10)-triene-9,17-dione monooxygenase",
    "1.14.14.13\t4-(gamma-L-glutamylamino)butanoyl-[BtrI acyl-carrier protein] monooxygenase",
    "1.14.14.14\taromatase",
    "1.14.14.15\t(3S)-3-amino-3-(3-chloro-4-hydroxyphenyl)propanoyl-[peptidyl-carrier protein SgcC2] monooxygenase",
    "1.14.14.16\tsteroid 21-monooxygenase",
    "1.14.14.17\tsqualene monooxygenase",
    "1.14.14.18\theme oxygenase (biliverdin-producing)",
    "1.14.14.19\tsteroid 17alpha-monooxygenase",
    "1.14.14.20\tphenol 2-monooxygenase (FADH2)",
    "1.14.14.21\tdibenzothiophene monooxygenase",
    "1.14.14.22\tdibenzothiophene sulfone monooxygenase",
    "1.14.14.23\tcholesterol 7alpha-monooxygenase",
    "1.14.14.24\tvitamin D 25-hydroxylase",
    "1.14.14.25\tcholesterol 24-hydroxylase",
    "1.14.14.26\t24-hydroxycholesterol 7alpha-hydroxylase",
    "1.14.14.27\tresorcinol 4-hydroxylase (FADH2)",
    "1.14.14.28\tlong-chain alkane monooxygenase",
    "1.14.14.29\t25/26-hydroxycholesterol 7alpha-hydroxylase",
    "1.14.14.30\tisobutylamine N-monooxygenase",
    "1.14.14.31\tipsdienol synthase",
    "1.14.14.32\t17alpha-hydroxyprogesterone deacetylase",
    "1.14.14.33\tethylenediaminetetraacetate monooxygenase",
    "1.14.14.34\tmethanesulfonate monooxygenase (FMNH2)",
    "1.14.14.35\tdimethylsulfone monooxygenase",
    "1.14.14.36\ttyrosine N-monooxygenase",
    "1.14.14.37\t4-hydroxyphenylacetaldehyde oxime monooxygenase",
    "1.14.14.38\tvaline N-monooxygenase",
    "1.14.14.39\tisoleucine N-monooxygenase",
    "1.14.14.40\tphenylalanine N-monooxygenase",
    "1.14.14.41\t(E)-2-methylbutanal oxime monooxygenase",
    "1.14.14.42\thomomethionine N-monooxygenase",
    "1.14.14.43\t(methylsulfanyl)alkanaldoxime N-monooxygenase",
    "1.14.14.44\tphenylacetaldehyde oxime monooxygenase",
    "1.14.14.45\taromatic aldoxime N-monooxygenase",
    "1.14.14.46\tpimeloyl-[acyl-carrier protein] synthase",
    "1.14.14.47\tnitric-oxide synthase (flavodoxin)",
    "1.14.14.48\tjasmonoyl-L-amino acid 12-hydroxylase",
    "1.14.14.49\t12-hydroxyjasmonoyl-L-amino acid 12-hydroxylase",
    "1.14.14.50\ttabersonine 3-oxygenase",
    "1.14.14.51\t(S)-limonene 6-monooxygenase",
    "1.14.14.52\t(S)-limonene 7-monooxygenase",
    "1.14.14.53\t(R)-limonene 6-monooxygenase",
    "1.14.14.54\tphenylacetate 2-hydroxylase",
    "1.14.14.55\tquinine 3-monooxygenase",
    "1.14.14.56\t1,8-cineole 2-exo-monooxygenase",
    "1.14.14.57\ttaurochenodeoxycholate 6alpha-hydroxylase",
    "1.14.14.58\ttrimethyltridecatetraene synthase",
    "1.14.14.59\tdimethylnonatriene synthase",
    "1.14.14.60\tferruginol monooxygenase",
    "1.14.14.61\tcarnosic acid synthase",
    "1.14.14.62\tsalviol synthase",
    "1.14.14.63\tbeta-amyrin 16beta-monooxygenase",
    "1.14.14.64\tbeta-amyrin 6beta-monooxygenase",
    "1.14.14.65\tsugiol synthase",
    "1.14.14.66\tmarmesin synthase",
    "1.14.14.67\t11-hydroxysugiol 20-monooxygenase",
    "1.14.14.68\tsyn-pimaradiene 3-monooxygenase",
    "1.14.14.69\tent-cassadiene hydroxylase",
    "1.14.14.70\tent-sandaracopimaradiene 3-hydroxylase",
    "1.14.14.71\tcucurbitadienol 11-hydroxylase",
    "1.14.14.72\tdrimenol monooxygenase",
    "1.14.14.73\talbendazole monooxygenase (sufoxide-forming)",
    "1.14.14.74\talbendazole monooxygenase (hydroxylating)",
    "1.14.14.75\tfenbendazole monooxygenase (4'-hydroxylating)",
    "1.14.14.76\tent-isokaurene C2/C3-hydroxylase",
    "1.14.14.77\tphenylacetonitrile alpha-monooxygenase",
    "1.14.14.78\tphylloquinone omega-hydroxylase",
    "1.14.14.79\tdocosahexaenoic acid omega-hydroxylase",
    "1.14.14.80\tlong-chain fatty acid omega-monooxygenase",
    "1.14.14.81\tflavonoid 3',5'-hydroxylase",
    "1.14.14.82\tflavonoid 3'-monooxygenase",
    "1.14.14.83\tgeraniol 8-hydroxylase",
    "1.14.14.84\tlinalool 8-monooxygenase",
    "1.14.14.85\t7-deoxyloganate 7-hydroxylase",
    "1.14.14.86\tent-kaurene monooxygenase",
    "1.14.14.87\t2-hydroxyisoflavanone synthase",
    "1.14.14.88\tisoflavone 3'-hydroxylase",
    "1.14.14.89\t4'-methoxyisoflavone 2'-hydroxylase",
    "1.14.14.90\tisoflavone 2'-hydroxylase",
    "1.14.14.91\ttrans-cinnamate 4-monooxygenase",
    "1.14.14.92\tbenzoate 4-monooxygenase",
    "1.14.14.93\t3,9-dihydroxypterocarpan 6a-monooxygenase",
    "1.14.14.94\tleukotriene-B4 20-monooxygenase",
    "1.14.14.95\tgermacrene A hydroxylase",
    "1.14.14.96\t5-O-(4-coumaroyl)-D-quinate 3'-monooxygenase",
    "1.14.14.97\tmethyltetrahydroprotoberberine 14-monooxygenase",
    "1.14.14.98\tprotopine 6-monooxygenase",
    "1.14.14.99\t(S)-limonene 3-monooxygenase",
    "1.14.14.100\tdihydrosanguinarine 10-monooxygenase",
    "1.14.14.101\tdihydrochelirubine 12-monooxygenase",
    "1.14.14.102\tN-methylcoclaurine 3'-monooxygenase",
    "1.14.14.103\ttabersonine 16-hydroxylase",
    "1.14.14.104\tvinorine hydroxylase",
    "1.14.14.105\ttaxane 10beta-hydroxylase",
    "1.14.14.106\ttaxane 13alpha-hydroxylase",
    "1.14.14.107\tent-kaurenoic acid monooxygenase",
    "1.14.14.108\t2,5-diketocamphane 1,2-monooxygenase",
    "1.14.14.109\t3-hydroxyindolin-2-one monooxygenase",
    "1.14.14.110\t2-hydroxy-1,4-benzoxazin-3-one monooxygenase",
    "1.14.14.111\t9beta-pimara-7,15-diene oxidase",
    "1.14.14.112\tent-cassa-12,15-diene 11-hydroxylase",
    "1.14.14.113\talpha-humulene 10-hydroxylase",
    "1.14.14.114\tamorpha-4,11-diene 12 monooxygenase",
    "1.14.14.115\t11-oxo-beta-amyrin 30-oxidase",
    "1.14.14.116\taverantin hydroxylase",
    "1.14.14.117\taflatoxin B synthase",
    "1.14.14.118\ttryprostatin B 6-hydroxylase",
    "1.14.14.119\tfumitremorgin C monooxygenase",
    "1.14.14.120\tdammarenediol 12-hydroxylase",
    "1.14.14.121\tprotopanaxadiol 6-hydroxylase",
    "1.14.14.122\toryzalexin E synthase",
    "1.14.14.123\toryzalexin D synthase",
    "1.14.14.124\tdihydromonacolin L hydroxylase",
    "1.14.14.125\tmonacolin L hydroxylase",
    "1.14.14.126\tbeta-amyrin 28-monooxygenase",
    "1.14.14.127\tmethyl farnesoate epoxidase",
    "1.14.14.128\tfarnesoate epoxidase",
    "1.14.14.129\tlong-chain acyl-CoA omega-monooxygenase",
    "1.14.14.130\tlaurate 7-monooxygenase",
    "1.14.14.131\tbursehernin 5'-monooxygenase",
    "1.14.14.132\t(-)-4'-demethyl-deoxypodophyllotoxin 4-hydroxylase",
    "1.14.14.133\t1,8-cineole 2-endo-monooxygenase",
    "1.14.14.134\tbeta-amyrin 24-hydroxylase",
    "1.14.14.135\tglyceollin synthase",
    "1.14.14.136\tdeoxysarpagine hydroxylase",
    "1.14.14.137\t(+)-abscisic acid 8'-hydroxylase",
    "1.14.14.138\tlithocholate 6beta-hydroxylase",
    "1.14.14.139\t5beta-cholestane-3alpha,7alpha-diol 12alpha-hydroxylase",
    "1.14.14.140\tlicodione synthase",
    "1.14.14.141\tpsoralen synthase",
    "1.14.14.142\t8-dimethylallylnaringenin 2'-hydroxylase",
    "1.14.14.143\t(+)-menthofuran synthase",
    "1.14.14.144\tabieta-7,13-diene hydroxylase",
    "1.14.14.145\tabieta-7,13-dien-18-ol hydroxylase",
    "1.14.14.146\tgeranylgeraniol 18-hydroxylase",
    "1.14.14.147\t22alpha-hydroxysteroid 23-monooxygenase",
    "1.14.14.148\tangelicin synthase",
    "1.14.14.149\t5-epiaristolochene 1,3-dihydroxylase",
    "1.14.14.150\tcostunolide synthase",
    "1.14.14.151\tpremnaspirodiene oxygenase",
    "1.14.14.152\tbeta-amyrin 11-oxidase",
    "1.14.14.153\tindole-2-monooxygenase",
    "1.14.14.154\tsterol 14alpha-demethylase",
    "1.14.14.155\t3,6-diketocamphane 1,2-monooxygenase",
    "1.14.14.156\ttryptophan N-monooxygenase",
    "1.14.14.157\tindolin-2-one monooxygenase",
    "1.14.14.158\tcarotene epsilon-hydroxylase",
    "1.14.14.159\tdolabradiene monooxygenase",
    "1.14.14.160\tzealexin A1 synthase",
    "1.14.14.161\tnepetalactol monooxygenase",
    "1.14.14.162\tflavanone 2-hydroxylase",
    "1.14.14.163\t(S)-1-hydroxy-N-methylcanadine 13-hydroxylase",
    "1.14.14.164\tfraxetin 5-hydroxylase",
    "1.14.14.165\tindole-3-carbonyl nitrile 4-hydroxylase",
    "1.14.14.166\t(S)-N-methylcanadine 1-hydroxylase",
    "1.14.14.167\t(13S,14R)-13-O-acetyl-1-hydroxy-N-methylcanadine 8-hydroxylase",
    "1.14.14.168\tgermacreene A acid 8beta-hydroxylase",
    "1.14.14.169\teupatolide synthase",
    "1.14.14.170\t8-epi-inunolide synthase",
    "1.14.14.171\tbeta-amyrin 16alpha-hydroxylase",
    "1.14.14.172\t3,5,6-trichloropyridin-2-ol monooxygenase",
    "1.14.14.173\t2,4,6-trichlorophenol monooxygenase",
    "1.14.14.174\tgeranylhydroquinone 3''-hydroxylase",
    "1.14.14.175\tferruginol synthase",
    "1.14.14.176\ttaxadiene 5alpha-hydroxylase",
    "1.14.14.177\tultra-long-chain fatty acid omega-hydroxylase",
    "1.14.15.1\tcamphor 5-monooxygenase",
    "1.14.15.3\talkane 1-monooxygenase",
    "1.14.15.4\tsteroid 11beta-monooxygenase",
    "1.14.15.5\tcorticosterone 18-monooxygenase",
    "1.14.15.6\tcholesterol monooxygenase (side-chain-cleaving)",
    "1.14.15.7\tcholine monooxygenase",
    "1.14.15.8\tsteroid 15beta-monooxygenase",
    "1.14.15.9\tspheroidene monooxygenase",
    "1.14.15.10\t(+)-camphor 6-endo-hydroxylase",
    "1.14.15.11\tpentalenic acid synthase",
    "1.14.15.13\tpulcherriminic acid synthase",
    "1.14.15.14\tmethyl-branched lipid omega-hydroxylase",
    "1.14.15.15\tcholestanetriol 26-monooxygenase",
    "1.14.15.16\tvitamin D3 24-hydroxylase",
    "1.14.15.17\tpheophorbide a oxygenase",
    "1.14.15.18\tcalcidiol 1-monooxygenase",
    "1.14.15.19\tC-19 steroid 1alpha-hydroxylase",
    "1.14.15.20\theme oxygenase (biliverdin-producing, ferredoxin)",
    "1.14.15.21\tzeaxanthin epoxidase",
    "1.14.15.22\tvitamin D 1,25-hydroxylase",
    "1.14.15.23\tchloroacetanilide N-alkylformylase",
    "1.14.15.24\tbeta-carotene 3-hydroxylase",
    "1.14.15.25\tp-cymene methyl-monooxygenase",
    "1.14.15.26\ttoluene methyl-monooxygenase",
    "1.14.15.27\tbeta-dihydromenaquinone-9 omega-hydroxylase",
    "1.14.15.28\tcholest-4-en-3-one 26-monooxygenase [(25R)-3-oxocholest-4-en-26-oate forming]",
    "1.14.15.29\tcholest-4-en-3-one 26-monooxygenase [(25S)-3-oxocholest-4-en-26-oate forming]",
    "1.14.15.30\t3-ketosteroid 9alpha-monooxygenase",
    "1.14.15.31\t2-hydroxy-5-methyl-1-naphthoate 7-hydroxylase",
    "1.14.15.32\tpentalenene oxygenase",
    "1.14.15.33\tpikromycin synthase",
    "1.14.15.34\t20-oxo-5-O-mycaminosyltylactone 23-monooxygenase",
    "1.14.15.35\t6-deoxyerythronolide B hydroxylase",
    "1.14.15.36\tsterol 14alpha-demethylase (ferredoxin)",
    "1.14.15.37\tluteothin monooxygenase",
    "1.14.15.38\tN,N-dimethyl phenylurea N-demethylase",
    "1.14.15.39\tepi-isozizaene 5-monooxygenase",
    "1.14.16.1\tphenylalanine 4-monooxygenase",
    "1.14.16.2\ttyrosine 3-monooxygenase",
    "1.14.16.4\ttryptophan 5-monooxygenase",
    "1.14.16.5\talkylglycerol monooxygenase",
    "1.14.16.6\tmandelate 4-monooxygenase",
    "1.14.16.7\tphenylalanine 3-monooxygenase",
    "1.14.17.1\tdopamine beta-monooxygenase",
    "1.14.17.3\tpeptidylglycine monooxygenase",
    "1.14.17.4\taminocyclopropanecarboxylate oxidase",
    "1.14.18.1\ttyrosinase",
    "1.14.18.2\tCMP-N-acetylneuraminate monooxygenase",
    "1.14.18.3\tmethane monooxygenase (particulate)",
    "1.14.18.4\tphosphatidylcholine 12-monooxygenase",
    "1.14.18.5\tsphingolipid C4-monooxygenase",
    "1.14.18.6\t4-hydroxysphinganine ceramide fatty acyl 2-hydroxylase",
    "1.14.18.7\tdihydroceramide fatty acyl 2-hydroxylase",
    "1.14.18.8\t7alpha-hydroxycholest-4-en-3-one 12alpha-hydroxylase",
    "1.14.18.9\t4alpha-methylsterol monooxygenase",
    "1.14.18.10\tplant 4,4-dimethylsterol C-4alpha-methyl-monooxygenase",
    "1.14.18.11\tplant 4alpha-monomethylsterol monooxygenase",
    "1.14.18.12\t2-hydroxy fatty acid dioxygenase",
    "1.14.19.1\tstearoyl-CoA 9-desaturase",
    "1.14.19.2\tstearoyl-[acyl-carrier-protein] 9-desaturase",
    "1.14.19.3\tacyl-CoA 6-desaturase",
    "1.14.19.4\tacyl-lipid (11-3)-desaturase",
    "1.14.19.5\tacyl-CoA 11-(Z)-desaturase",
    "1.14.19.6\tacyl-CoA (9+3)-desaturase",
    "1.14.19.8\tpentalenolactone synthase",
    "1.14.19.9\ttryptophan 7-halogenase",
    "1.14.19.10\ticosanoyl-CoA 5-desaturase",
    "1.14.19.11\tacyl-[acyl-carrier-protein] 4-desaturase",
    "1.14.19.12\tacyl-lipid omega-(9-4) desaturase",
    "1.14.19.13\tacyl-CoA 15-desaturase",
    "1.14.19.14\tlinoleoyl-lipid Delta(9) conjugase",
    "1.14.19.15\t(11Z)-hexadec-11-enoyl-CoA conjugase",
    "1.14.19.16\tlinoleoyl-lipid Delta(12) conjugase (11E,13Z-forming)",
    "1.14.19.17\tsphingolipid 4-desaturase",
    "1.14.19.18\tsphingolipid 8-(E)-desaturase",
    "1.14.19.19\tsphingolipid 10-desaturase",
    "1.14.19.20\tDelta(7)-sterol 5(6)-desaturase",
    "1.14.19.21\tcholesterol 7-desaturase",
    "1.14.19.22\tacyl-lipid omega-6 desaturase (cytochrome b5)",
    "1.14.19.23\tacyl-lipid (n+3)-(Z)-desaturase (ferredoxin)",
    "1.14.19.24\tacyl-CoA 11-(E)-desaturase",
    "1.14.19.25\tacyl-lipid omega-3 desaturase (cytochrome b5)",
    "1.14.19.26\tacyl-[acyl-carrier-protein] 6-desaturase",
    "1.14.19.27\tsn-2 palmitoyl-lipid 9-desaturase",
    "1.14.19.28\tsn-1 stearoyl-lipid 9-desaturase",
    "1.14.19.29\tsphingolipid 8-(E/Z)-desaturase",
    "1.14.19.30\tacyl-lipid (8-3)-desaturase",
    "1.14.19.31\tacyl-lipid (7-3)-desaturase",
    "1.14.19.32\tpalmitoyl-CoA 14-(E/Z)-desaturase",
    "1.14.19.33\tDelta(12) acyl-lipid conjugase (11E,13E-forming)",
    "1.14.19.34\tacyl-lipid (9+3)-(E)-desaturase",
    "1.14.19.35\tsn-2 acyl-lipid omega-3 desaturase (ferredoxin)",
    "1.14.19.36\tsn-1 acyl-lipid omega-3 desaturase (ferredoxin)",
    "1.14.19.37\tacyl-CoA 5-desaturase",
    "1.14.19.38\tacyl-lipid Delta(6)-acetylenase",
    "1.14.19.39\tacyl-lipid Delta(12)-acetylenase",
    "1.14.19.40\thex-5-enoyl-[acyl-carrier protein] acetylenase",
    "1.14.19.41\tsterol 22-desaturase",
    "1.14.19.42\tpalmitoyl-[glycerolipid] 7-desaturase",
    "1.14.19.43\tpalmitoyl-[glycerolipid] 3-(E)-desaturase",
    "1.14.19.44\tacyl-CoA (8-3)-desaturase",
    "1.14.19.45\tsn-1 oleoyl-lipid 12-desaturase",
    "1.14.19.46\tsn-1 linoleoyl-lipid 6-desaturase",
    "1.14.19.47\tacyl-lipid (9-3)-desaturase",
    "1.14.19.48\ttert-amyl alcohol desaturase",
    "1.14.19.49\ttetracycline 7-halogenase",
    "1.14.19.50\tnoroxomaritidine synthase",
    "1.14.19.51\t(S)-corytuberine synthase",
    "1.14.19.52\tcamalexin synthase",
    "1.14.19.53\tall-trans-retinol 3,4-desaturase",
    "1.14.19.54\t1,2-dehydroreticuline synthase",
    "1.14.19.55\t4-hydroxybenzoate brominase (decarboxylating)",
    "1.14.19.56\t1H-pyrrole-2-carbonyl-[peptidyl-carrier protein] chlorinase",
    "1.14.19.57\t1H-pyrrole-2-carbonyl-[peptidyl-carrier protein] brominase",
    "1.14.19.58\ttryptophan 5-halogenase",
    "1.14.19.59\ttryptophan 6-halogenase",
    "1.14.19.60\t7-chloro-L-tryptophan 6-halogenase",
    "1.14.19.61\tdihydrorhizobitoxine desaturase",
    "1.14.19.62\tsecologanin synthase",
    "1.14.19.63\tpseudobaptigenin synthase",
    "1.14.19.64\t(S)-stylopine synthase",
    "1.14.19.65\t(S)-cheilanthifoline synthase",
    "1.14.19.66\tberbamunine synthase",
    "1.14.19.67\tsalutaridine synthase",
    "1.14.19.68\t(S)-canadine synthase",
    "1.14.19.69\tbiflaviolin synthase",
    "1.14.19.70\tmycocyclosin synthase",
    "1.14.19.71\tfumitremorgin C synthase",
    "1.14.19.72\t(-)-pluviatolide synthase",
    "1.14.19.73\t(S)-nandinine synthase",
    "1.14.19.74\t(+)-piperitol/(+)-sesamin synthase",
    "1.14.19.75\tvery-long-chain acyl-lipid omega-9 desaturase",
    "1.14.19.76\tflavone synthase II",
    "1.14.19.77\tplasmanylethanolamine desaturase",
    "1.14.19.78\tdecanoyl-[acyl-carrier protein] acetylenase",
    "1.14.19.n4\tstearoyl-CoA 9-desaturase (NADPH)",
    "1.14.19.n5\tversicolorin B desaturase",
    "1.14.20.1\tdeacetoxycephalosporin-C synthase",
    "1.14.20.3\t(5R)-carbapenem-3-carboxylate synthase",
    "1.14.20.4\tanthocyanidin synthase",
    "1.14.20.5\tflavone synthase I",
    "1.14.20.6\tflavonol synthase",
    "1.14.20.7\t2-oxoglutarate/L-arginine monooxygenase/decarboxylase (succinate-forming)",
    "1.14.20.8\t(-)-deoxypodophyllotoxin synthase",
    "1.14.20.9\ttyrosine isonitrile desaturase",
    "1.14.20.10\ttyrosine isonitrile desaturase/decarboxylase",
    "1.14.20.11\t3-[(Z)-2-isocyanoethenyl]-1H-indole synthase",
    "1.14.20.12\t3-[(E)-2-isocyanoethenyl]-1H-indole synthase",
    "1.14.20.13\t6beta-hydroxyhyoscyamine epoxidase",
    "1.14.20.14\thapalindole-type alkaloid chlorinase",
    "1.14.20.15\tL-threonyl-[L-threonyl-carrier protein] 4-chlorinase",
    "1.14.99.1\tprostaglandin-endoperoxide synthase",
    "1.14.99.2\tkynurenine 7,8-hydroxylase",
    "1.14.99.4\tprogesterone monooxygenase",
    "1.14.99.11\testradiol 6beta-monooxygenase",
    "1.14.99.12\tandrost-4-ene-3,17-dione monooxygenase",
    "1.14.99.14\tprogesterone 11alpha-monooxygenase",
    "1.14.99.15\t4-methoxybenzoate monooxygenase (O-demethylating)",
    "1.14.99.20\tphylloquinone monooxygenase (2,3-epoxidizing)",
    "1.14.99.21\tLatia-luciferin monooxygenase (demethylating)",
    "1.14.99.22\tecdysone 20-monooxygenase",
    "1.14.99.23\t3-hydroxybenzoate 2-monooxygenase",
    "1.14.99.24\tsteroid 9alpha-monooxygenase",
    "1.14.99.26\t2-hydroxypyridine 5-monooxygenase",
    "1.14.99.29\tdeoxyhypusine monooxygenase",
    "1.14.99.34\tmonoprenyl isoflavone epoxidase",
    "1.14.99.35\tthiophene-2-carbonyl-CoA monooxygenase",
    "1.14.99.38\tcholesterol 25-monooxygenase",
    "1.14.99.39\tammonia monooxygenase",
    "1.14.99.44\tdiapolycopene oxygenase",
    "1.14.99.46\tpyrimidine monooxygenase",
    "1.14.99.47\t(+)-larreatricin hydroxylase",
    "1.14.99.48\theme oxygenase (staphylobilin-producing)",
    "1.14.99.50\tgamma-glutamyl hercynylcysteine S-oxide synthase",
    "1.14.99.51\thercynylcysteine S-oxide synthase",
    "1.14.99.52\tL-cysteinyl-L-histidinylsulfoxide synthase",
    "1.14.99.53\tlytic chitin monooxygenase",
    "1.14.99.54\tlytic cellulose monooxygenase (C1-hydroxylating)",
    "1.14.99.55\tlytic starch monooxygenase",
    "1.14.99.56\tlytic cellulose monooxygenase (C4-dehydrogenating)",
    "1.14.99.57\theme oxygenase (mycobilin-producing)",
    "1.14.99.58\theme oxygenase (biliverdin-IX-beta and delta-forming)",
    "1.14.99.59\ttryptamine 4-monooxygenase",
    "1.14.99.60\t3-demethoxyubiquinol 3-hydroxylase",
    "1.14.99.61\tcyclooctat-9-en-7-ol 5-monooxygenase",
    "1.14.99.62\tcyclooctatin synthase",
    "1.14.99.63\tbeta-carotene 4-ketolase",
    "1.14.99.64\tzeaxanthin 4-ketolase",
    "1.14.99.65\t4-amino-L-phenylalanyl-[CmlP-peptidyl-carrier-protein] 3-hydroxylase",
    "1.14.99.66\t[histone-H3]-N(6),N(6)-dimethyl-L-lysine(4) FAD-dependent demethylase",
    "1.14.99.67\talpha-N-dichloroacetyl-p-aminophenylserinol N-oxygenase",
    "1.14.99.68\t4-aminobenzoate N-oxygenase",
    "1.14.99.69\ttRNA 2-(methylsulfanyl)-N(6)-isopentenyladenosine(37) hydroxylase",
    "1.14.99.n4\tcarotenoid 9,10-dioxygenase",
    "1.15.1.1\tsuperoxide dismutase",
    "1.15.1.2\tsuperoxide reductase",
    "1.16.1.1\tmercury(II) reductase",
    "1.16.1.2\tdiferric-transferrin reductase",
    "1.16.1.6\tcyanocobalamin reductase",
    "1.16.1.7\tferric-chelate reductase (NADH)",
    "1.16.1.8\t[methionine synthase] reductase",
    "1.16.1.9\tferric-chelate reductase (NADPH)",
    "1.16.1.10\tferric-chelate reductase [NAD(P)H]",
    "1.16.3.1\tferroxidase",
    "1.16.3.2\tbacterial non-heme ferritin",
    "1.16.3.3\tmanganese oxidase",
    "1.16.3.4\tcuproxidase",
    "1.16.9.1\tiron:rusticyanin reductase",
    "1.16.99.1\t[Co(II) methylated amine-specific corrinoid protein] reductase",
    "1.17.1.1\tCDP-4-dehydro-6-deoxyglucose reductase",
    "1.17.1.3\tleucoanthocyanidin reductase",
    "1.17.1.4\txanthine dehydrogenase",
    "1.17.1.5\tnicotinate dehydrogenase",
    "1.17.1.8\t4-hydroxy-tetrahydrodipicolinate reductase",
    "1.17.1.9\tformate dehydrogenase",
    "1.17.1.10\tformate dehydrogenase (NADP(+))",
    "1.17.1.11\tformate dehydrogenase (NAD(+), ferredoxin)",
    "1.17.2.1\tnicotinate dehydrogenase (cytochrome)",
    "1.17.2.2\tlupanine 17-hydroxylase (cytochrome c)",
    "1.17.2.3\tformate dehydrogenase (cytochrome c-553)",
    "1.17.3.1\tpteridine oxidase",
    "1.17.3.2\txanthine oxidase",
    "1.17.3.3\t6-hydroxynicotinate dehydrogenase",
    "1.17.3.4\tjuglone 3-hydroxylase",
    "1.17.4.1\tribonucleoside-diphosphate reductase",
    "1.17.4.2\tribonucleoside-triphosphate reductase (thioredoxin)",
    "1.17.4.4\tvitamin-K-epoxide reductase (warfarin-sensitive)",
    "1.17.4.5\tvitamin-K-epoxide reductase (warfarin-insensitive)",
    "1.17.5.1\tphenylacetyl-CoA dehydrogenase",
    "1.17.5.2\tcaffeine dehydrogenase",
    "1.17.5.3\tformate dehydrogenase-N",
    "1.17.7.1\t(E)-4-hydroxy-3-methylbut-2-enyl-diphosphate synthase (ferredoxin)",
    "1.17.7.2\t7-hydroxymethyl chlorophyll a reductase",
    "1.17.7.3\t(E)-4-hydroxy-3-methylbut-2-enyl-diphosphate synthase (flavodoxin)",
    "1.17.7.4\t4-hydroxy-3-methylbut-2-enyl diphosphate reductase",
    "1.17.8.1\thydroxysqualene dehydroxylase",
    "1.17.9.1\t4-methylphenol dehydrogenase (hydroxylating)",
    "1.17.9.2\t(+)-pinoresinol hydroxylase",
    "1.17.98.2\tbacteriochlorophyllide c C-7(1)-hydroxylase",
    "1.17.98.3\tformate dehydrogenase (coenzyme F420)",
    "1.17.98.4\tformate dehydrogenase (acceptor)",
    "1.17.99.2\tethylbenzene hydroxylase",
    "1.17.99.3\t3alpha,7alpha,12alpha-trihydroxy-5beta-cholestanoyl-CoA 24-hydroxylase",
    "1.17.99.4\turacil/thymine dehydrogenase",
    "1.17.99.6\tepoxyqueuosine reductase",
    "1.17.99.8\tlimonene dehydrogenase",
    "1.17.99.9\theme a synthase",
    "1.17.99.10\tsteroid C-25 hydroxylase",
    "1.17.99.11\t3-oxo-Delta(1)-steroid hydratase/dehydrogenase",
    "1.18.1.1\trubredoxin--NAD(+) reductase",
    "1.18.1.2\tferredoxin--NADP(+) reductase",
    "1.18.1.3\tferredoxin--NAD(+) reductase",
    "1.18.1.4\trubredoxin--NAD(P)(+) reductase",
    "1.18.1.5\tputidaredoxin--NAD(+) reductase",
    "1.18.1.6\tadrenodoxin-NADP(+) reductase",
    "1.18.1.7\tferredoxin--NAD(P)(+) reductase (naphthalene dioxygenase ferredoxin-specific)",
    "1.18.6.1\tnitrogenase",
    "1.18.6.2\tvanadium-dependent nitrogenase",
    "1.19.1.1\tflavodoxin--NADP(+) reductase",
    "1.19.6.1\tnitrogenase (flavodoxin)",
    "1.20.1.1\tphosphonate dehydrogenase",
    "1.20.2.1\tarsenate reductase (cytochrome c)",
    "1.20.4.1\tarsenate reductase (glutathione/glutaredoxin)",
    "1.20.4.2\tmethylarsonate reductase",
    "1.20.4.3\tmycoredoxin",
    "1.20.4.4\tarsenate reductase (thioredoxin)",
    "1.20.9.1\tarsenate reductase (azurin)",
    "1.20.99.1\tarsenate reductase (donor)",
    "1.21.1.1\tiodotyrosine deiodinase",
    "1.21.1.2\t2,4-dichlorobenzoyl-CoA reductase",
    "1.21.3.1\tisopenicillin-N synthase",
    "1.21.3.2\tcolumbamine oxidase",
    "1.21.3.3\treticuline oxidase",
    "1.21.3.4\tsulochrin oxidase [(+)-bisdechlorogeodin-forming]",
    "1.21.3.5\tsulochrin oxidase [(-)-bisdechlorogeodin-forming]",
    "1.21.3.6\taureusidin synthase",
    "1.21.3.7\ttetrahydrocannabinolic acid synthase",
    "1.21.3.8\tcannabidiolic acid synthase",
    "1.21.4.1\tD-proline reductase",
    "1.21.4.2\tglycine reductase",
    "1.21.4.3\tsarcosine reductase",
    "1.21.4.4\tbetaine reductase",
    "1.21.4.5\ttetrachlorohydroquinone reductive dehalogenase",
    "1.21.98.1\tcyclic dehypoxanthinyl futalosine synthase",
    "1.21.98.2\tdichlorochromopyrrolate synthase",
    "1.21.98.3\tanaerobic magnesium-protoporphyrin IX monomethyl ester cyclase",
    "1.21.98.4\tPqqA peptide cyclase",
    "1.21.99.1\tbeta-cyclopiazonate dehydrogenase",
    "1.21.99.3\tthyroxine 5-deiodinase",
    "1.21.99.4\tthyroxine 5'-deiodinase",
    "1.21.99.5\ttetrachloroethene reductive dehalogenase",
    "1.23.1.1\t(+)-pinoresinol reductase",
    "1.23.1.2\t(+)-lariciresinol reductase",
    "1.23.1.3\t(-)-pinoresinol reductase",
    "1.23.1.4\t(-)-lariciresinol reductase",
    "1.23.5.1\tviolaxanthin de-epoxidase",
    "1.97.1.1\tchlorate reductase",
    "1.97.1.2\tpyrogallol hydroxytransferase",
    "1.97.1.4\t[formate-C-acetyltransferase]-activating enzyme",
    "1.97.1.9\tselenate reductase",
    "1.97.1.12\tphotosystem I",
    "2.1.1.1\tnicotinamide N-methyltransferase",
    "2.1.1.2\tguanidinoacetate N-methyltransferase",
    "2.1.1.3\tthetin--homocysteine S-methyltransferase",
    "2.1.1.4\tacetylserotonin O-methyltransferase",
    "2.1.1.5\tbetaine--homocysteine S-methyltransferase",
    "2.1.1.6\tcatechol O-methyltransferase",
    "2.1.1.7\tnicotinate N-methyltransferase",
    "2.1.1.8\thistamine N-methyltransferase",
    "2.1.1.9\tthiol S-methyltransferase",
    "2.1.1.10\thomocysteine S-methyltransferase",
    "2.1.1.11\tmagnesium protoporphyrin IX methyltransferase",
    "2.1.1.12\tmethionine S-methyltransferase",
    "2.1.1.13\tmethionine synthase",
    "2.1.1.14\t5-methyltetrahydropteroyltriglutamate--homocysteine S-methyltransferase",
    "2.1.1.15\tfatty-acid O-methyltransferase",
    "2.1.1.16\tmethylene-fatty-acyl-phospholipid synthase",
    "2.1.1.17\tphosphatidylethanolamine N-methyltransferase",
    "2.1.1.18\tpolysaccharide O-methyltransferase",
    "2.1.1.19\ttrimethylsulfonium--tetrahydrofolate N-methyltransferase",
    "2.1.1.20\tglycine N-methyltransferase",
    "2.1.1.21\tmethylamine--glutamate N-methyltransferase",
    "2.1.1.22\tcarnosine N-methyltransferase",
    "2.1.1.25\tphenol O-methyltransferase",
    "2.1.1.26\tiodophenol O-methyltransferase",
    "2.1.1.27\ttyramine N-methyltransferase",
    "2.1.1.28\tphenylethanolamine N-methyltransferase",
    "2.1.1.33\ttRNA (guanine(46)-N(7))-methyltransferase",
    "2.1.1.34\ttRNA (guanosine(18)-2'-O)-methyltransferase",
    "2.1.1.35\ttRNA (uracil(54)-C(5))-methyltransferase",
    "2.1.1.37\tDNA (cytosine-5-)-methyltransferase",
    "2.1.1.38\tO-demethylpuromycin O-methyltransferase",
    "2.1.1.39\tinositol 3-methyltransferase",
    "2.1.1.40\tinositol 1-methyltransferase",
    "2.1.1.41\tsterol 24-C-methyltransferase",
    "2.1.1.42\tflavone 3'-O-methyltransferase",
    "2.1.1.44\tL-histidine N(alpha)-methyltransferase",
    "2.1.1.45\tthymidylate synthase",
    "2.1.1.46\tisoflavone 4'-O-methyltransferase",
    "2.1.1.47\tindolepyruvate C-methyltransferase",
    "2.1.1.49\tamine N-methyltransferase",
    "2.1.1.50\tloganate O-methyltransferase",
    "2.1.1.53\tputrescine N-methyltransferase",
    "2.1.1.54\tdeoxycytidylate C-methyltransferase",
    "2.1.1.55\ttRNA (adenine-N(6)-)-methyltransferase",
    "2.1.1.56\tmRNA (guanine-N(7))-methyltransferase",
    "2.1.1.57\tmethyltransferase cap1",
    "2.1.1.59\t[cytochrome c]-lysine N-methyltransferase",
    "2.1.1.60\tcalmodulin-lysine N-methyltransferase",
    "2.1.1.61\ttRNA 5-(aminomethyl)-2-thiouridylate-methyltransferase",
    "2.1.1.62\tmRNA (2'-O-methyladenosine-N(6)-)-methyltransferase",
    "2.1.1.63\tmethylated-DNA--[protein]-cysteine S-methyltransferase",
    "2.1.1.64\t3-demethylubiquinol 3-O-methyltransferase",
    "2.1.1.65\tlicodione 2'-O-methyltransferase",
    "2.1.1.67\tthiopurine S-methyltransferase",
    "2.1.1.68\tcaffeate O-methyltransferase",
    "2.1.1.69\t5-hydroxyfuranocoumarin 5-O-methyltransferase",
    "2.1.1.70\t8-hydroxyfuranocoumarin 8-O-methyltransferase",
    "2.1.1.71\tphosphatidyl-N-methylethanolamine N-methyltransferase",
    "2.1.1.72\tsite-specific DNA-methyltransferase (adenine-specific)",
    "2.1.1.74\tmethylenetetrahydrofolate--tRNA-(uracil(54)-C(5))-methyltransferase [NAD(P)H-oxidizing]",
    "2.1.1.75\tapigenin 4'-O-methyltransferase",
    "2.1.1.76\tquercetin 3-O-methyltransferase",
    "2.1.1.77\tprotein-L-isoaspartate(D-aspartate) O-methyltransferase",
    "2.1.1.78\tisoorientin 3'-O-methyltransferase",
    "2.1.1.79\tcyclopropane-fatty-acyl-phospholipid synthase",
    "2.1.1.80\tprotein-glutamate O-methyltransferase",
    "2.1.1.82\t3-methylquercetin 7-O-methyltransferase",
    "2.1.1.83\t3,7-dimethylquercetin 4'-O-methyltransferase",
    "2.1.1.84\tmethylquercetagetin 6-O-methyltransferase",
    "2.1.1.85\tprotein-histidine N-methyltransferase",
    "2.1.1.86\ttetrahydromethanopterin S-methyltransferase",
    "2.1.1.87\tpyridine N-methyltransferase",
    "2.1.1.88\t8-hydroxyquercetin 8-O-methyltransferase",
    "2.1.1.89\ttetrahydrocolumbamine 2-O-methyltransferase",
    "2.1.1.90\tmethanol--corrinoid protein Co-methyltransferase",
    "2.1.1.91\tisobutyraldoxime O-methyltransferase",
    "2.1.1.94\ttabersonine 16-O-methyltransferase",
    "2.1.1.95\ttocopherol C-methyltransferase",
    "2.1.1.96\tthioether S-methyltransferase",
    "2.1.1.97\t3-hydroxyanthranilate 4-C-methyltransferase",
    "2.1.1.98\tdiphthine synthase",
    "2.1.1.99\t3-hydroxy-16-methoxy-2,3-dihydrotabersonine N-methyltransferase",
    "2.1.1.100\tprotein-S-isoprenylcysteine O-methyltransferase",
    "2.1.1.101\tmacrocin O-methyltransferase",
    "2.1.1.102\tdemethylmacrocin O-methyltransferase",
    "2.1.1.103\tphosphoethanolamine N-methyltransferase",
    "2.1.1.104\tcaffeoyl-CoA O-methyltransferase",
    "2.1.1.105\tN-benzoyl-4-hydroxyanthranilate 4-O-methyltransferase",
    "2.1.1.106\ttryptophan 2-C-methyltransferase",
    "2.1.1.107\turoporphyrinogen-III C-methyltransferase",
    "2.1.1.108\t6-hydroxymellein O-methyltransferase",
    "2.1.1.109\tdemethylsterigmatocystin 6-O-methyltransferase",
    "2.1.1.110\tsterigmatocystin 8-O-methyltransferase",
    "2.1.1.111\tanthranilate N-methyltransferase",
    "2.1.1.112\tglucuronoxylan 4-O-methyltransferase",
    "2.1.1.113\tsite-specific DNA-methyltransferase (cytosine-N(4)-specific)",
    "2.1.1.114\tpolyprenyldihydroxybenzoate methyltransferase",
    "2.1.1.115\t(RS)-1-benzyl-1,2,3,4-tetrahydroisoquinoline N-methyltransferase",
    "2.1.1.116\t3'-hydroxy-N-methyl-(S)-coclaurine 4'-O-methyltransferase",
    "2.1.1.117\t(S)-scoulerine 9-O-methyltransferase",
    "2.1.1.118\tcolumbamine O-methyltransferase",
    "2.1.1.119\t10-hydroxydihydrosanguinarine 10-O-methyltransferase",
    "2.1.1.120\t12-hydroxydihydrochelirubine 12-O-methyltransferase",
    "2.1.1.121\t6-O-methylnorlaudanosoline 5'-O-methyltransferase",
    "2.1.1.122\t(S)-tetrahydroprotoberberine N-methyltransferase",
    "2.1.1.123\t[cytochrome c]-methionine S-methyltransferase",
    "2.1.1.127\t[ribulose-bisphosphate carboxylase]-lysine N-methyltransferase",
    "2.1.1.128\t(RS)-norcoclaurine 6-O-methyltransferase",
    "2.1.1.129\tinositol 4-methyltransferase",
    "2.1.1.130\tprecorrin-2 C(20)-methyltransferase",
    "2.1.1.131\tprecorrin-3B C(17)-methyltransferase",
    "2.1.1.132\tprecorrin-6B C(5,15)-methyltransferase (decarboxylating)",
    "2.1.1.133\tprecorrin-4 C(11)-methyltransferase",
    "2.1.1.136\tchlorophenol O-methyltransferase",
    "2.1.1.137\tarsenite methyltransferase",
    "2.1.1.139\t3'-demethylstaurosporine O-methyltransferase",
    "2.1.1.140\t(S)-coclaurine-N-methyltransferase",
    "2.1.1.141\tjasmonate O-methyltransferase",
    "2.1.1.142\tcycloartenol 24-C-methyltransferase",
    "2.1.1.143\t24-methylenesterol C-methyltransferase",
    "2.1.1.144\ttrans-aconitate 2-methyltransferase",
    "2.1.1.145\ttrans-aconitate 3-methyltransferase",
    "2.1.1.146\t(iso)eugenol O-methyltransferase",
    "2.1.1.147\tcorydaline synthase",
    "2.1.1.148\tthymidylate synthase (FAD)",
    "2.1.1.150\tisoflavone 7-O-methyltransferase",
    "2.1.1.151\tcobalt-factor II C(20)-methyltransferase",
    "2.1.1.152\tprecorrin-6A synthase (deacetylating)",
    "2.1.1.153\tvitexin 2''-O-rhamnoside 7-O-methyltransferase",
    "2.1.1.154\tisoliquiritigenin 2'-O-methyltransferase",
    "2.1.1.155\tkaempferol 4'-O-methyltransferase",
    "2.1.1.156\tglycine/sarcosine N-methyltransferase",
    "2.1.1.157\tsarcosine/dimethylglycine N-methyltransferase",
    "2.1.1.158\t7-methylxanthosine synthase",
    "2.1.1.159\ttheobromine synthase",
    "2.1.1.160\tcaffeine synthase",
    "2.1.1.161\tdimethylglycine N-methyltransferase",
    "2.1.1.162\tglycine/sarcosine/dimethylglycine N-methyltransferase",
    "2.1.1.163\tdemethylmenaquinone methyltransferase",
    "2.1.1.164\tdemethylrebeccamycin-D-glucose O-methyltransferase",
    "2.1.1.165\tmethyl halide transferase",
    "2.1.1.166\t23S rRNA (uridine(2552)-2'-O)-methyltransferase",
    "2.1.1.167\t27S pre-rRNA (guanosine(2922)-2'-O)-methyltransferase",
    "2.1.1.168\t21S rRNA (uridine(2791)-2'-O)-methyltransferase",
    "2.1.1.169\ttricetin 3',4',5'-O-trimethyltransferase",
    "2.1.1.170\t16S rRNA (guanine(527)-N(7))-methyltransferase",
    "2.1.1.171\t16S rRNA (guanine(966)-N(2))-methyltransferase",
    "2.1.1.172\t16S rRNA (guanine(1207)-N(2))-methyltransferase",
    "2.1.1.173\t23S rRNA (guanine(2445)-N(2))-methyltransferase",
    "2.1.1.174\t23S rRNA (guanine(1835)-N(2))-methyltransferase",
    "2.1.1.175\ttricin synthase",
    "2.1.1.176\t16S rRNA (cytosine(967)-C(5))-methyltransferase",
    "2.1.1.177\t23S rRNA (pseudouridine(1915)-N(3))-methyltransferase",
    "2.1.1.178\t16S rRNA (cytosine(1407)-C(5))-methyltransferase",
    "2.1.1.179\t16S rRNA (guanine(1405)-N(7))-methyltransferase",
    "2.1.1.180\t16S rRNA (adenine(1408)-N(1))-methyltransferase",
    "2.1.1.181\t23S rRNA (adenine(1618)-N(6))-methyltransferase",
    "2.1.1.182\t16S rRNA (adenine(1518)-N(6)/adenine(1519)-N(6))-dimethyltransferase",
    "2.1.1.183\t18S rRNA (adenine(1779)-N(6)/adenine(1780)-N(6))-dimethyltransferase",
    "2.1.1.184\t23S rRNA (adenine(2085)-N(6))-dimethyltransferase",
    "2.1.1.185\t23S rRNA (guanosine(2251)-2'-O)-methyltransferase",
    "2.1.1.186\t23S rRNA (cytidine(2498)-2'-O)-methyltransferase",
    "2.1.1.187\t23S rRNA (guanine(745)-N(1))-methyltransferase",
    "2.1.1.188\t23S rRNA (guanine(748)-N(1))-methyltransferase",
    "2.1.1.189\t23S rRNA (uracil(747)-C(5))-methyltransferase",
    "2.1.1.190\t23S rRNA (uracil(1939)-C(5))-methyltransferase",
    "2.1.1.191\t23S rRNA (cytosine(1962)-C(5))-methyltransferase",
    "2.1.1.192\t23S rRNA (adenine(2503)-C(2))-methyltransferase",
    "2.1.1.193\t16S rRNA (uracil(1498)-N(3))-methyltransferase",
    "2.1.1.195\tcobalt-precorrin-5B (C(1))-methyltransferase",
    "2.1.1.196\tcobalt-precorrin-6B (C(15))-methyltransferase [decarboxylating]",
    "2.1.1.197\tmalonyl-[acyl-carrier protein] O-methyltransferase",
    "2.1.1.198\t16S rRNA (cytidine(1402)-2'-O)-methyltransferase",
    "2.1.1.199\t16S rRNA (cytosine(1402)-N(4))-methyltransferase",
    "2.1.1.200\ttRNA (cytidine(32)/uridine(32)-2'-O)-methyltransferase",
    "2.1.1.201\t2-methoxy-6-polyprenyl-1,4-benzoquinol methylase",
    "2.1.1.202\tmultisite-specific tRNA:(cytosine-C(5))-methyltransferase",
    "2.1.1.203\ttRNA (cytosine(34)-C(5))-methyltransferase",
    "2.1.1.204\ttRNA (cytosine(38)-C(5))-methyltransferase",
    "2.1.1.205\ttRNA (cytidine(32)/guanosine(34)-2'-O)-methyltransferase",
    "2.1.1.206\ttRNA (cytidine(56)-2'-O)-methyltransferase",
    "2.1.1.207\ttRNA (cytidine(34)-2'-O)-methyltransferase",
    "2.1.1.208\t23S rRNA (uridine(2479)-2'-O)-methyltransferase",
    "2.1.1.209\t23S rRNA (guanine(2535)-N(1))-methyltransferase",
    "2.1.1.210\tdemethylspheroidene O-methyltransferase",
    "2.1.1.211\ttRNA(Ser) (uridine(44)-2'-O)-methyltransferase",
    "2.1.1.212\t2,7,4'-trihydroxyisoflavanone 4'-O-methyltransferase",
    "2.1.1.213\ttRNA (guanine(10)-N(2))-dimethyltransferase",
    "2.1.1.214\ttRNA (guanine(10)-N(2))-methyltransferase",
    "2.1.1.215\ttRNA (guanine(26)-N(2)/guanine(27)-N(2))-dimethyltransferase",
    "2.1.1.216\ttRNA (guanine(26)-N(2))-dimethyltransferase",
    "2.1.1.217\ttRNA (adenine(22)-N(1))-methyltransferase",
    "2.1.1.218\ttRNA (adenine(9)-N(1))-methyltransferase",
    "2.1.1.219\ttRNA (adenine(57)-N(1)/adenine(58)-N(1))-methyltransferase",
    "2.1.1.220\ttRNA (adenine(58)-N(1))-methyltransferase",
    "2.1.1.221\ttRNA (guanine(9)-N(1))-methyltransferase",
    "2.1.1.222\t2-polyprenyl-6-hydroxyphenol methylase",
    "2.1.1.223\ttRNA1(Val) (adenine(37)-N(6))-methyltransferase",
    "2.1.1.224\t23S rRNA (adenine(2503)-C(8))-methyltransferase",
    "2.1.1.225\ttRNA:m(4)X modification enzyme",
    "2.1.1.226\t23S rRNA (cytidine(1920)-2'-O)-methyltransferase",
    "2.1.1.227\t16S rRNA (cytidine(1409)-2'-O)-methyltransferase",
    "2.1.1.228\ttRNA (guanine(37)-N(1))-methyltransferase",
    "2.1.1.229\ttRNA (carboxymethyluridine(34)-5-O)-methyltransferase",
    "2.1.1.230\t23S rRNA (adenosine(1067)-2'-O)-methyltransferase",
    "2.1.1.231\tflavonoid 4'-O-methyltransferase",
    "2.1.1.232\tnaringenin 7-O-methyltransferase",
    "2.1.1.233\t[phosphatase 2A protein]-leucine-carboxy methyltransferase",
    "2.1.1.234\tdTDP-3-amino-3,4,6-trideoxy-alpha-D-glucopyranose N,N-dimethyltransferase",
    "2.1.1.235\tdTDP-3-amino-3,6-dideoxy-alpha-D-glucopyranose N,N-dimethyltransferase",
    "2.1.1.236\tdTDP-3-amino-3,6-dideoxy-alpha-D-galactopyranose N,N-dimethyltransferase",
    "2.1.1.237\tmycinamicin III 3''-O-methyltransferase",
    "2.1.1.238\tmycinamicin VI 2''-O-methyltransferase",
    "2.1.1.239\tL-olivosyl-oleandolide 3-O-methyltransferase",
    "2.1.1.240\ttrans-resveratrol di-O-methyltransferase",
    "2.1.1.241\t2,4,7-trihydroxy-1,4-benzoxazin-3-one-glucoside 7-O-methyltransferase",
    "2.1.1.242\t16S rRNA (guanine(1516)-N(2))-methyltransferase",
    "2.1.1.243\t2-ketoarginine methyltransferase",
    "2.1.1.244\tprotein N-terminal methyltransferase",
    "2.1.1.245\t5-methyltetrahydrosarcinapterin:corrinoid/iron-sulfur protein Co-methyltransferase",
    "2.1.1.246\t[methyl-Co(III) methanol-specific corrinoid protein]:coenzyme M methyltransferase",
    "2.1.1.247\t[methyl-Co(III) methylamine-specific corrinoid protein]:coenzyme M methyltransferase",
    "2.1.1.248\t[methylamine--corrinoid protein] Co-methyltransferase",
    "2.1.1.249\t[dimethylamine--corrinoid protein] Co-methyltransferase",
    "2.1.1.250\t[trimethylamine--corrinoid protein] Co-methyltransferase",
    "2.1.1.251\tmethylated-thiol--coenzyme M methyltransferase",
    "2.1.1.252\ttetramethylammonium--corrinoid protein Co-methyltransferase",
    "2.1.1.253\t[methyl-Co(III) tetramethylammonium-specific corrinoid protein]:coenzyme M methyltransferase",
    "2.1.1.254\terythromycin 3''-O-methyltransferase",
    "2.1.1.255\tgeranyl diphosphate 2-C-methyltransferase",
    "2.1.1.256\ttRNA (guanine(6)-N(2))-methyltransferase",
    "2.1.1.257\ttRNA (pseudouridine(54)-N(1))-methyltransferase",
    "2.1.1.258\t5-methyltetrahydrofolate:corrinoid/iron-sulfur protein Co-methyltransferase",
    "2.1.1.259\t[fructose-bisphosphate aldolase]-lysine N-methyltransferase",
    "2.1.1.260\trRNA small subunit pseudouridine methyltransferase Nep1",
    "2.1.1.261\t4-dimethylallyltryptophan N-methyltransferase",
    "2.1.1.262\tsqualene methyltransferase",
    "2.1.1.263\tbotryococcene C-methyltransferase",
    "2.1.1.264\t23S rRNA (guanine(2069)-N(7))-methyltransferase",
    "2.1.1.265\ttellurite methyltransferase",
    "2.1.1.266\t23S rRNA (adenine(2030)-N(6))-methyltransferase",
    "2.1.1.267\tflavonoid 3',5'-methyltransferase",
    "2.1.1.268\ttRNA(Thr) (cytosine(32)-N(3))-methyltransferase",
    "2.1.1.269\tdimethylsulfoniopropionate demethylase",
    "2.1.1.270\t(+)-6a-hydroxymaackiain 3-O-methyltransferase",
    "2.1.1.271\tcobalt-precorrin-4 methyltransferase",
    "2.1.1.272\tcobalt-factor III methyltransferase",
    "2.1.1.273\tbenzoate O-methyltransferase",
    "2.1.1.274\tsalicylate carboxymethyltransferase",
    "2.1.1.275\tgibberellin A9 O-methyltransferase",
    "2.1.1.276\tgibberellin A4 carboxyl methyltransferase",
    "2.1.1.277\tanthranilate O-methyltransferase",
    "2.1.1.278\tindole-3-acetate O-methyltransferase",
    "2.1.1.279\ttrans-anol O-methyltransferase",
    "2.1.1.280\tselenocysteine Se-methyltransferase",
    "2.1.1.281\tphenylpyruvate C(3)-methyltransferase",
    "2.1.1.282\ttRNA(Phe) 7-[(3-amino-3-carboxypropyl)-4-demethylwyosine(37)-N(4)]-methyltransferase",
    "2.1.1.283\temodin O-methyltransferase",
    "2.1.1.284\t8-demethylnovobiocic acid C(8)-methyltransferase",
    "2.1.1.285\tdemethyldecarbamoylnovobiocin O-methyltransferase",
    "2.1.1.286\t25S rRNA (adenine(2142)-N(1))-methyltransferase",
    "2.1.1.287\t25S rRNA (adenine(645)-N(1))-methyltransferase",
    "2.1.1.288\taklanonic acid methyltransferase",
    "2.1.1.289\tcobalt-precorrin-7 (C(5))-methyltransferase",
    "2.1.1.290\ttRNA(Phe) [7-(3-amino-3-carboxypropyl)wyosine(37)-O]-methyltransferase",
    "2.1.1.291\t(R,S)-reticuline 7-O-methyltransferase",
    "2.1.1.292\tcarminomycin 4-O-methyltransferase",
    "2.1.1.293\t6-hydroxytryprostatin B O-methyltransferase",
    "2.1.1.294\t3-O-phospho-polymannosyl GlcNAc-diphospho-ditrans,octacis-undecaprenol 3-phospho-methyltransferase",
    "2.1.1.295\t2-methyl-6-phytyl-1,4-hydroquinone methyltransferase",
    "2.1.1.296\tmethyltransferase cap2",
    "2.1.1.297\tpeptide chain release factor N(5)-glutamine methyltransferase",
    "2.1.1.298\tribosomal protein L3 N(5)-glutamine methyltransferase",
    "2.1.1.299\tprotein N-terminal monomethyltransferase",
    "2.1.1.300\tpavine N-methyltransferase",
    "2.1.1.301\tcypemycin N-terminal methyltransferase",
    "2.1.1.302\t3-hydroxy-5-methyl-1-naphthoate 3-O-methyltransferase",
    "2.1.1.303\t2,7-dihydroxy-5-methyl-1-naphthoate 7-O-methyltransferase",
    "2.1.1.304\tL-tyrosine C(3)-methyltransferase",
    "2.1.1.305\t8-demethyl-8-alpha-L-rhamnosyl tetracenomycin-C 2'-O-methyltransferase",
    "2.1.1.306\t8-demethyl-8-(2-methoxy-alpha-L-rhamnosyl)-tetracenomycin-C 3'-O-methyltransferase",
    "2.1.1.307\t8-demethyl-8-(2,3-dimethoxy-alpha-L-rhamnosyl)-tetracenomycin-C 4'-O-methyltransferase",
    "2.1.1.308\tcytidylyl-2-hydroxyethylphosphonate methyltransferase",
    "2.1.1.309\t18S rRNA (guanine(1575)-N(7))-methyltransferase",
    "2.1.1.310\t25S rRNA (cytosine(2870)-C(5))-methyltransferase",
    "2.1.1.311\t25S rRNA (cytosine(2278)-C(5))-methyltransferase",
    "2.1.1.312\t25S rRNA (uracil(2843)-N(3))-methyltransferase",
    "2.1.1.313\t25S rRNA (uracil(2634)-N(3))-methyltransferase",
    "2.1.1.314\tdiphthine methyl ester synthase",
    "2.1.1.315\t27-O-demethylrifamycin SV methyltransferase",
    "2.1.1.316\tmitomycin 6-O-methyltransferase",
    "2.1.1.317\tsphingolipid C(9)-methyltransferase",
    "2.1.1.318\t[trehalose-6-phosphate synthase]-L-cysteine S-methyltransferase",
    "2.1.1.319\ttype I protein arginine methyltransferase",
    "2.1.1.320\ttype II protein arginine methyltransferase",
    "2.1.1.321\ttype III protein arginine methyltransferase",
    "2.1.1.322\ttype IV protein arginine methyltransferase",
    "2.1.1.323\t(-)-pluviatolide 4-O-methyltransferase",
    "2.1.1.324\tdTDP-4-amino-2,3,4,6-tetradeoxy-D-glucose N,N-dimethyltransferase",
    "2.1.1.325\tjuvenile hormone-III synthase",
    "2.1.1.326\tN-acetyl-demethylphosphinothricin P-methyltransferase",
    "2.1.1.327\tphenazine-1-carboxylate N-methyltransferase",
    "2.1.1.328\tN-demethylindolmycin N-methyltransferase",
    "2.1.1.329\tdemethylphylloquinol methyltransferase",
    "2.1.1.330\t5'-demethylyatein 5'-O-methyltransferase",
    "2.1.1.331\tbacteriochlorophyllide d C-12(1)-methyltransferase",
    "2.1.1.332\tbacteriochlorophyllide d C-8(2)-methyltransferase",
    "2.1.1.333\tbacteriochlorophyllide d C-20 methyltransferase",
    "2.1.1.334\tmethanethiol S-methyltransferase",
    "2.1.1.335\t4-amino-anhydrotetracycline N(4)-methyltransferase",
    "2.1.1.336\tnorbelladine O-methyltransferase",
    "2.1.1.337\treticuline N-methyltransferase",
    "2.1.1.338\tdesmethylxanthohumol 6'-O-methyltransferase",
    "2.1.1.339\txanthohumol 4-O-methyltransferase",
    "2.1.1.340\t3-aminomethylindole N-methyltransferase",
    "2.1.1.341\tvanillate/3-O-methylgallate O-demethylase",
    "2.1.1.342\tanaerobilin synthase",
    "2.1.1.343\t8-amino-8-demethylriboflavin N,N-dimethyltransferase",
    "2.1.1.344\tornithine lipid N-methyltransferase",
    "2.1.1.345\tpsilocybin synthase",
    "2.1.1.346\tU6 snRNA m(6)A methyltransferase",
    "2.1.1.347\t(+)-O-methylkolavelool synthase",
    "2.1.1.348\tmRNA m(6)A methyltransferase",
    "2.1.1.349\ttoxoflavin synthase",
    "2.1.1.350\tmenaquinone C(8)-methyltransferase",
    "2.1.1.351\tnocamycin O-methyltransferase",
    "2.1.1.352\t3-O-acetyl-4'-O-demethylpapaveroxine 4'-O-methyltransferase",
    "2.1.1.353\tdemethylluteothin O-methyltransferase",
    "2.1.1.354\t[histone H3]-lysine(4) N-trimethyltransferase",
    "2.1.1.355\t[histone H3]-lysine(9) N-trimethyltransferase",
    "2.1.1.356\t[histone H3]-lysine(27) N-trimethyltransferase",
    "2.1.1.357\t[histone H3]-lysine(36) N-dimethyltransferase",
    "2.1.1.359\t[histone H3]-lysine(36) N-trimethyltransferase",
    "2.1.1.360\t[histone H3]-lysine(79) N-trimethyltransferase",
    "2.1.1.361\t[histone H4]-lysine(20) N-methyltransferase",
    "2.1.1.362\t[histone H4]-N-methyl-L-lysine(20) N-methyltransferase",
    "2.1.1.363\tpre-sodorifen synthase",
    "2.1.1.364\t[histone H3]-lysine(4) N-methyltransferase",
    "2.1.1.365\tMMP 1-O-methyltransferase",
    "2.1.1.366\t[histone H3]-N(6),N(6)-dimethyl-lysine(9) N-methyltransferase",
    "2.1.1.367\t[histone H3]-lysine(9) N-methyltransferase",
    "2.1.1.368\t[histone H3]-lysine(9) N-dimethyltransferase",
    "2.1.1.369\t[histone H3]-lysine(27) N-methyltransferase",
    "2.1.1.370\t[histone H3]-lysine(4) N-dimethyltransferase",
    "2.1.1.371\t[histone H3]-lysine(27) N-dimethyltransferase",
    "2.1.1.372\t[histone H4]-lysine(20) N-trimethyltransferase",
    "2.1.1.373\t2-hydroxy-4-(methylsulfanyl)butanoate S-methyltransferase",
    "2.1.1.374\t2-heptyl-1-hydroxyquinolin-4(1H)-one methyltransferase",
    "2.1.1.375\tNNS virus cap methyltransferase",
    "2.1.1.376\tglycine betaine--corrinoid protein Co-methyltransferase",
    "2.1.1.377\t[methyl-Co(III) glycine betaine-specific corrinoid protein]--coenzyme M methyltransferase",
    "2.1.1.378\t[methyl-Co(III) glycine betaine-specific corrinoid protein]--tetrahydrofolate methyltransferase",
    "2.1.1.379\t[methyl coenzyme M reductase]-L-arginine C-5-methyltransferase",
    "2.1.1.380\t3-amino-4-hydroxybenzoate 4-O-methyltransferase",
    "2.1.1.381\targinine N(omega)-methyltransferase",
    "2.1.1.n1\tresorcinol O-methyltransferase",
    "2.1.1.n4\tthiocyanate methyltransferase",
    "2.1.1.n7\t5-pentadecatrienyl resorcinol O-methyltransferase",
    "2.1.1.n8\tsmall RNA 2'-O-methyltransferase",
    "2.1.1.n11\tmethylphosphotriester-DNA--[protein]-cysteine S-methyltransferase",
    "2.1.2.1\tglycine hydroxymethyltransferase",
    "2.1.2.2\tphosphoribosylglycinamide formyltransferase 1",
    "2.1.2.3\tphosphoribosylaminoimidazolecarboxamide formyltransferase",
    "2.1.2.4\tglycine formimidoyltransferase",
    "2.1.2.5\tglutamate formimidoyltransferase",
    "2.1.2.7\tD-alanine 2-hydroxymethyltransferase",
    "2.1.2.8\tdeoxycytidylate 5-hydroxymethyltransferase",
    "2.1.2.9\tmethionyl-tRNA formyltransferase",
    "2.1.2.10\taminomethyltransferase",
    "2.1.2.11\t3-methyl-2-oxobutanoate hydroxymethyltransferase",
    "2.1.2.13\tUDP-4-amino-4-deoxy-L-arabinose formyltransferase",
    "2.1.2.14\tGDP-perosamine N-formyltransferase",
    "2.1.3.1\tmethylmalonyl-CoA carboxytransferase",
    "2.1.3.2\taspartate carbamoyltransferase",
    "2.1.3.3\tornithine carbamoyltransferase",
    "2.1.3.5\toxamate carbamoyltransferase",
    "2.1.3.6\tputrescine carbamoyltransferase",
    "2.1.3.7\t3-hydroxymethylcephem carbamoyltransferase",
    "2.1.3.8\tlysine carbamoyltransferase",
    "2.1.3.9\tN-acetylornithine carbamoyltransferase",
    "2.1.3.10\tmalonyl-S-ACP:biotin-protein carboxyltransferase",
    "2.1.3.11\tN-succinylornithine carbamoyltransferase",
    "2.1.3.12\tdecarbamoylnovobiocin carbamoyltransferase",
    "2.1.3.15\tacetyl-CoA carboxytransferase",
    "2.1.4.1\tglycine amidinotransferase",
    "2.1.4.2\tscyllo-inosamine-4-phosphate amidinotransferase",
    "2.1.4.3\tL-arginine:L-lysine amidinotransferase",
    "2.1.5.1\tsesamin methylene transferase",
    "2.2.1.1\ttransketolase",
    "2.2.1.2\ttransaldolase",
    "2.2.1.3\tformaldehyde transketolase",
    "2.2.1.4\tacetoin--ribose-5-phosphate transaldolase",
    "2.2.1.5\t2-hydroxy-3-oxoadipate synthase",
    "2.2.1.6\tacetolactate synthase",
    "2.2.1.7\t1-deoxy-D-xylulose-5-phosphate synthase",
    "2.2.1.8\tfluorothreonine transaldolase",
    "2.2.1.9\t2-succinyl-5-enolpyruvyl-6-hydroxy-3-cyclohexene-1-carboxylic-acid synthase",
    "2.2.1.10\t2-amino-3,7-dideoxy-D-threo-hept-6-ulosonate synthase",
    "2.2.1.11\t6-deoxy-5-ketofructose 1-phosphate synthase",
    "2.2.1.12\t3-acetyloctanal synthase",
    "2.2.1.13\tapulose-4-phosphate transketolase",
    "2.2.1.14\t6-deoxy-6-sulfo-D-fructose transaldolase",
    "2.3.1.1\tamino-acid N-acetyltransferase",
    "2.3.1.2\timidazole N-acetyltransferase",
    "2.3.1.3\tglucosamine N-acetyltransferase",
    "2.3.1.4\tglucosamine-phosphate N-acetyltransferase",
    "2.3.1.5\tarylamine N-acetyltransferase",
    "2.3.1.6\tcholine O-acetyltransferase",
    "2.3.1.7\tcarnitine O-acetyltransferase",
    "2.3.1.8\tphosphate acetyltransferase",
    "2.3.1.9\tacetyl-CoA C-acetyltransferase",
    "2.3.1.10\thydrogen-sulfide S-acetyltransferase",
    "2.3.1.11\tthioethanolamine S-acetyltransferase",
    "2.3.1.12\tdihydrolipoyllysine-residue acetyltransferase",
    "2.3.1.13\tglycine N-acyltransferase",
    "2.3.1.14\tglutamine N-phenylacetyltransferase",
    "2.3.1.15\tglycerol-3-phosphate 1-O-acyltransferase",
    "2.3.1.16\tacetyl-CoA C-acyltransferase",
    "2.3.1.17\taspartate N-acetyltransferase",
    "2.3.1.18\tgalactoside O-acetyltransferase",
    "2.3.1.19\tphosphate butyryltransferase",
    "2.3.1.20\tdiacylglycerol O-acyltransferase",
    "2.3.1.21\tcarnitine O-palmitoyltransferase",
    "2.3.1.22\t2-acylglycerol O-acyltransferase",
    "2.3.1.23\t1-acylglycerophosphocholine O-acyltransferase",
    "2.3.1.24\tsphingosine N-acyltransferase",
    "2.3.1.25\tplasmalogen synthase",
    "2.3.1.26\tsterol O-acyltransferase",
    "2.3.1.27\tcortisol O-acetyltransferase",
    "2.3.1.28\tchloramphenicol O-acetyltransferase",
    "2.3.1.29\tglycine C-acetyltransferase",
    "2.3.1.30\tserine O-acetyltransferase",
    "2.3.1.31\thomoserine O-acetyltransferase",
    "2.3.1.32\tlysine N-acetyltransferase",
    "2.3.1.33\thistidine N-acetyltransferase",
    "2.3.1.34\tD-tryptophan N-acetyltransferase",
    "2.3.1.35\tglutamate N-acetyltransferase",
    "2.3.1.36\tD-amino-acid N-acetyltransferase",
    "2.3.1.37\t5-aminolevulinate synthase",
    "2.3.1.38\t[acyl-carrier-protein] S-acetyltransferase",
    "2.3.1.39\t[acyl-carrier-protein] S-malonyltransferase",
    "2.3.1.40\tacyl-[acyl-carrier-protein]--phospholipid O-acyltransferase",
    "2.3.1.41\tbeta-ketoacyl-[acyl-carrier-protein] synthase I",
    "2.3.1.42\tglycerone-phosphate O-acyltransferase",
    "2.3.1.43\tphosphatidylcholine--sterol O-acyltransferase",
    "2.3.1.44\tN-acetylneuraminate 4-O-acetyltransferase",
    "2.3.1.45\tN-acetylneuraminate 7-O(or 9-O)-acetyltransferase",
    "2.3.1.46\thomoserine O-succinyltransferase",
    "2.3.1.47\t8-amino-7-oxononanoate synthase",
    "2.3.1.48\thistone acetyltransferase",
    "2.3.1.49\tdeacetyl-[citrate-(pro-3S)-lyase] S-acetyltransferase",
    "2.3.1.50\tserine C-palmitoyltransferase",
    "2.3.1.51\t1-acylglycerol-3-phosphate O-acyltransferase",
    "2.3.1.52\t2-acylglycerol-3-phosphate O-acyltransferase",
    "2.3.1.53\tphenylalanine N-acetyltransferase",
    "2.3.1.54\tformate C-acetyltransferase",
    "2.3.1.56\taromatic-hydroxylamine O-acetyltransferase",
    "2.3.1.57\tdiamine N-acetyltransferase",
    "2.3.1.58\t2,3-diaminopropionate N-oxalyltransferase",
    "2.3.1.59\tgentamicin 2'-N-acetyltransferase",
    "2.3.1.60\tgentamicin 3-N-acetyltransferase",
    "2.3.1.61\tdihydrolipoyllysine-residue succinyltransferase",
    "2.3.1.62\t2-acylglycerophosphocholine O-acyltransferase",
    "2.3.1.63\t1-alkylglycerophosphocholine O-acyltransferase",
    "2.3.1.64\tagmatine N(4)-coumaroyltransferase",
    "2.3.1.65\tbile acid-CoA:amino acid N-acyltransferase",
    "2.3.1.66\tleucine N-acetyltransferase",
    "2.3.1.67\t1-alkylglycerophosphocholine O-acetyltransferase",
    "2.3.1.68\tglutamine N-acyltransferase",
    "2.3.1.69\tmonoterpenol O-acetyltransferase",
    "2.3.1.71\tglycine N-benzoyltransferase",
    "2.3.1.72\tindoleacetylglucose--inositol O-acyltransferase",
    "2.3.1.73\tdiacylglycerol--sterol O-acyltransferase",
    "2.3.1.74\tchalcone synthase",
    "2.3.1.75\tlong-chain-alcohol O-fatty-acyltransferase",
    "2.3.1.76\tretinol O-fatty-acyltransferase",
    "2.3.1.77\ttriacylglycerol--sterol O-acyltransferase",
    "2.3.1.78\theparan-alpha-glucosaminide N-acetyltransferase",
    "2.3.1.79\tmaltose O-acetyltransferase",
    "2.3.1.80\tcysteine-S-conjugate N-acetyltransferase",
    "2.3.1.81\taminoglycoside N(3)-acetyltransferase",
    "2.3.1.82\taminoglycoside 6'-N-acetyltransferase",
    "2.3.1.83\tphosphatidylcholine--dolichol O-acyltransferase",
    "2.3.1.84\talcohol O-acetyltransferase",
    "2.3.1.85\tfatty-acid synthase system",
    "2.3.1.86\tfatty-acyl-CoA synthase system",
    "2.3.1.87\taralkylamine N-acetyltransferase",
    "2.3.1.89\ttetrahydrodipicolinate N-acetyltransferase",
    "2.3.1.90\tbeta-glucogallin O-galloyltransferase",
    "2.3.1.91\tsinapoylglucose--choline O-sinapoyltransferase",
    "2.3.1.92\tsinapoylglucose--malate O-sinapoyltransferase",
    "2.3.1.93\t13-hydroxylupanine O-tigloyltransferase",
    "2.3.1.94\t6-deoxyerythronolide-B synthase",
    "2.3.1.95\ttrihydroxystilbene synthase",
    "2.3.1.97\tglycylpeptide N-tetradecanoyltransferase",
    "2.3.1.98\tchlorogenate--glucarate O-hydroxycinnamoyltransferase",
    "2.3.1.99\tquinate O-hydroxycinnamoyltransferase",
    "2.3.1.100\t[myelin-proteolipid] O-palmitoyltransferase",
    "2.3.1.101\tformylmethanofuran--tetrahydromethanopterin N-formyltransferase",
    "2.3.1.102\tN(6)-hydroxylysine O-acetyltransferase",
    "2.3.1.103\tsinapoylglucose--sinapoylglucose O-sinapoyltransferase",
    "2.3.1.105\talkylglycerophosphate 2-O-acetyltransferase",
    "2.3.1.106\ttartronate O-hydroxycinnamoyltransferase",
    "2.3.1.107\tdeacetylvindoline O-acetyltransferase",
    "2.3.1.108\talpha-tubulin N-acetyltransferase",
    "2.3.1.109\targinine N-succinyltransferase",
    "2.3.1.110\ttyramine N-feruloyltransferase",
    "2.3.1.111\tmycocerosate synthase",
    "2.3.1.112\tD-tryptophan N-malonyltransferase",
    "2.3.1.113\tanthranilate N-malonyltransferase",
    "2.3.1.114\t3,4-dichloroaniline N-malonyltransferase",
    "2.3.1.115\tisoflavone-7-O-beta-glucoside 6''-O-malonyltransferase",
    "2.3.1.116\tflavonol-3-O-beta-glucoside O-malonyltransferase",
    "2.3.1.117\t2,3,4,5-tetrahydropyridine-2,6-dicarboxylate N-succinyltransferase",
    "2.3.1.118\tN-hydroxyarylamine O-acetyltransferase",
    "2.3.1.121\t1-alkenylglycerophosphoethanolamine O-acyltransferase",
    "2.3.1.122\ttrehalose O-mycolyltransferase",
    "2.3.1.123\tdolichol O-acyltransferase",
    "2.3.1.125\t1-alkyl-2-acetylglycerol O-acyltransferase",
    "2.3.1.126\tisocitrate O-dihydroxycinnamoyltransferase",
    "2.3.1.127\tornithine N-benzoyltransferase",
    "2.3.1.129\tacyl-[acyl-carrier-protein]--UDP-N-acetylglucosamine O-acyltransferase",
    "2.3.1.130\tgalactarate O-hydroxycinnamoyltransferase",
    "2.3.1.131\tglucarate O-hydroxycinnamoyltransferase",
    "2.3.1.132\tglucarolactone O-hydroxycinnamoyltransferase",
    "2.3.1.133\tshikimate O-hydroxycinnamoyltransferase",
    "2.3.1.134\tgalactolipid O-acyltransferase",
    "2.3.1.135\tphosphatidylcholine--retinol O-acyltransferase",
    "2.3.1.136\tpolysialic-acid O-acetyltransferase",
    "2.3.1.137\tcarnitine O-octanoyltransferase",
    "2.3.1.138\tputrescine N-hydroxycinnamoyltransferase",
    "2.3.1.139\tecdysone O-acyltransferase",
    "2.3.1.140\trosmarinate synthase",
    "2.3.1.141\tgalactosylacylglycerol O-acyltransferase",
    "2.3.1.142\tglycoprotein O-fatty-acyltransferase",
    "2.3.1.143\tbeta-glucogallin--tetrakisgalloylglucose O-galloyltransferase",
    "2.3.1.144\tanthranilate N-benzoyltransferase",
    "2.3.1.145\tpiperidine N-piperoyltransferase",
    "2.3.1.146\tpinosylvin synthase",
    "2.3.1.147\tglycerophospholipid arachidonoyl-transferase (CoA-independent)",
    "2.3.1.148\tglycerophospholipid acyltransferase (CoA-dependent)",
    "2.3.1.149\tplatelet-activating factor acetyltransferase",
    "2.3.1.150\tsalutaridinol 7-O-acetyltransferase",
    "2.3.1.151\t2,3',4,6-tetrahydroxybenzophenone synthase",
    "2.3.1.152\talcohol O-cinnamoyltransferase",
    "2.3.1.153\tanthocyanin 5-(6'''-hydroxycinnamoyltransferase)",
    "2.3.1.155\tacetyl-CoA C-myristoyltransferase",
    "2.3.1.156\tphloroisovalerophenone synthase",
    "2.3.1.157\tglucosamine-1-phosphate N-acetyltransferase",
    "2.3.1.158\tphospholipid:diacylglycerol acyltransferase",
    "2.3.1.159\tacridone synthase",
    "2.3.1.160\tvinorine synthase",
    "2.3.1.161\tlovastatin nonaketide synthase",
    "2.3.1.162\ttaxadien-5alpha-ol O-acetyltransferase",
    "2.3.1.163\t10-hydroxytaxane O-acetyltransferase",
    "2.3.1.164\tisopenicillin-N N-acyltransferase",
    "2.3.1.165\t6-methylsalicylic acid synthase",
    "2.3.1.166\t2alpha-hydroxytaxane 2-O-benzoyltransferase",
    "2.3.1.167\t10-deacetylbaccatin III 10-O-acetyltransferase",
    "2.3.1.168\tdihydrolipoyllysine-residue (2-methylpropanoyl)transferase",
    "2.3.1.169\tCO-methylating acetyl-CoA synthase",
    "2.3.1.170\t6'-deoxychalcone synthase",
    "2.3.1.171\tanthocyanin 6''-O-malonyltransferase",
    "2.3.1.172\tanthocyanin 5-O-glucoside 6'''-O-malonyltransferase",
    "2.3.1.173\tflavonol-3-O-triglucoside O-coumaroyltransferase",
    "2.3.1.174\t3-oxoadipyl-CoA thiolase",
    "2.3.1.175\tdeacetylcephalosporin-C acetyltransferase",
    "2.3.1.176\tpropanoyl-CoA C-acyltransferase",
    "2.3.1.177\t3,5-dihydroxybiphenyl synthase",
    "2.3.1.178\tdiaminobutyrate acetyltransferase",
    "2.3.1.179\tbeta-ketoacyl-[acyl-carrier-protein] synthase II",
    "2.3.1.180\tbeta-ketoacyl-[acyl-carrier-protein] synthase III",
    "2.3.1.181\tlipoyl(octanoyl) transferase",
    "2.3.1.182\t(R)-citramalate synthase",
    "2.3.1.183\tphosphinothricin acetyltransferase",
    "2.3.1.184\tacyl-homoserine-lactone synthase",
    "2.3.1.185\ttropine acyltransferase",
    "2.3.1.186\tpseudotropine acyltransferase",
    "2.3.1.187\tacetyl-S-ACP:malonate ACP transferase",
    "2.3.1.188\tomega-hydroxypalmitate O-feruloyl transferase",
    "2.3.1.189\tmycothiol synthase",
    "2.3.1.190\tacetoin dehydrogenase system",
    "2.3.1.191\tUDP-3-O-(3-hydroxymyristoyl)glucosamine N-acyltransferase",
    "2.3.1.192\tglycine N-phenylacetyltransferase",
    "2.3.1.193\ttRNA(Met) cytidine acetyltransferase",
    "2.3.1.194\tacetoacetyl-CoA synthase",
    "2.3.1.195\t(Z)-3-hexen-1-ol acetyltransferase",
    "2.3.1.196\tbenzyl alcohol O-benzoyltransferase",
    "2.3.1.197\tdTDP-3-amino-3,6-dideoxy-alpha-D-galactopyranose 3-N-acetyltransferase",
    "2.3.1.198\tglycerol-3-phosphate 2-O-acyltransferase",
    "2.3.1.199\tvery-long-chain 3-oxoacyl-CoA synthase",
    "2.3.1.200\tlipoyl amidotransferase",
    "2.3.1.201\tUDP-2-acetamido-3-amino-2,3-dideoxy-glucuronate N-acetyltransferase",
    "2.3.1.202\tUDP-4-amino-4,6-dideoxy-N-acetyl-beta-L-altrosamine N-acetyltransferase",
    "2.3.1.203\tUDP-N-acetylbacillosamine N-acetyltransferase",
    "2.3.1.204\toctanoyl-[GcvH]:protein N-octanoyltransferase",
    "2.3.1.205\tfumigaclavine B O-acetyltransferase",
    "2.3.1.206\t3,5,7-trioxododecanoyl-CoA synthase",
    "2.3.1.207\tbeta-ketodecanoyl-[acyl-carrier-protein] synthase",
    "2.3.1.208\t4-hydroxycoumarin synthase",
    "2.3.1.209\tdTDP-4-amino-4,6-dideoxy-D-glucose acyltransferase",
    "2.3.1.210\tdTDP-4-amino-4,6-dideoxy-D-galactose acyltransferase",
    "2.3.1.211\tbisdemethoxycurcumin synthase",
    "2.3.1.212\tbenzalacetone synthase",
    "2.3.1.213\tcyanidin 3-O-(6-O-glucosyl-2-O-xylosylgalactoside) 6'''-O-hydroxycinnamoyltransferase",
    "2.3.1.214\tpelargonidin 3-O-(6-caffeoylglucoside) 5-O-(6-O-malonylglucoside) 4'''-malonyltransferase",
    "2.3.1.215\tanthocyanidin 3-O-glucoside 6''-O-acyltransferase",
    "2.3.1.216\t5,7-dihydroxy-2-methylchromone synthase",
    "2.3.1.217\tcurcumin synthase",
    "2.3.1.218\tphenylpropanoylacetyl-CoA synthase",
    "2.3.1.219\tdemethoxycurcumin synthase",
    "2.3.1.220\t2,4,6-trihydroxybenzophenone synthase",
    "2.3.1.221\tnoranthrone synthase",
    "2.3.1.222\tphosphate propanoyltransferase",
    "2.3.1.223\t3-oxo-5,6-didehydrosuberyl-CoA thiolase",
    "2.3.1.224\tacetyl-CoA-benzylalcohol acetyltransferase",
    "2.3.1.225\tprotein S-acyltransferase",
    "2.3.1.226\tcarboxymethylproline synthase",
    "2.3.1.227\tGDP-perosamine N-acetyltransferase",
    "2.3.1.228\tisovaleryl-homoserine lactone synthase",
    "2.3.1.229\t4-coumaroyl-homoserine lactone synthase",
    "2.3.1.230\t2-heptyl-4(1H)-quinolone synthase",
    "2.3.1.231\ttRNA(Phe) {7-[3-amino-3-(methoxycarbonyl)propyl]wyosine(37)-N}-methoxycarbonyltransferase",
    "2.3.1.232\tmethanol O-anthraniloyltransferase",
    "2.3.1.233\t1,3,6,8-tetrahydroxynaphthalene synthase",
    "2.3.1.234\tN(6)-L-threonylcarbamoyladenine synthase",
    "2.3.1.235\ttetracenomycin F2 synthase",
    "2.3.1.236\t5-methylnaphthoic acid synthase",
    "2.3.1.237\tneocarzinostatin naphthoate synthase",
    "2.3.1.238\tmonacolin J acid methylbutanoate transferase",
    "2.3.1.239\t10-deoxymethynolide syntase",
    "2.3.1.240\tnarbonolide synthase",
    "2.3.1.241\tKdo2-lipid IVA lauroyltransferase",
    "2.3.1.242\tKdo2-lipid IVA palmitoleoyltransferase",
    "2.3.1.243\tacyl-Kdo2-lipid IVA acyltransferase",
    "2.3.1.244\t2-methylbutanoate polyketide synthase",
    "2.3.1.245\t3-hydroxy-5-phosphooxypentane-2,4-dione thiolase",
    "2.3.1.246\t3,5-dihydroxyphenylacetyl-CoA synthase",
    "2.3.1.247\t3-keto-5-aminohexanoate cleavage enzyme",
    "2.3.1.248\tspermidine disinapoyl transferase",
    "2.3.1.249\tspermidine dicoumaroyl transferase",
    "2.3.1.250\t[Wnt protein] O-palmitoleoyl transferase",
    "2.3.1.251\tlipid IVA palmitoyltransferase",
    "2.3.1.252\tmycolipanoate synthase",
    "2.3.1.253\tphloroglucinol synthase",
    "2.3.1.254\tN-terminal methionine N(alpha)-acetyltransferase NatB",
    "2.3.1.255\tN-terminal amino-acid N(alpha)-acetyltransferase NatA",
    "2.3.1.256\tN-terminal methionine N(alpha)-acetyltransferase NatC",
    "2.3.1.257\tN-terminal L-serine N(alpha)-acetyltransferase NatD",
    "2.3.1.258\tN-terminal methionine N(alpha)-acetyltransferase NatE",
    "2.3.1.259\tN-terminal methionine N(alpha)-acetyltransferase NatF",
    "2.3.1.260\ttetracycline polyketide synthase",
    "2.3.1.261\t(4-hydroxyphenyl)alkanoate synthase",
    "2.3.1.262\tanthraniloyl-CoA anthraniloyltransferase",
    "2.3.1.263\t2-amino-4-oxopentanoate thiolase",
    "2.3.1.264\tbeta-lysine N(6)-acetyltransferase",
    "2.3.1.265\tphosphatidylinositol dimannoside acyltransferase",
    "2.3.1.266\t[ribosomal protein S18]-alanine N-acetyltransferase",
    "2.3.1.267\t[ribosomal protein S5]-alanine N-acetyltransferase",
    "2.3.1.268\tethanol O-acetyltransferase",
    "2.3.1.269\tapolipoprotein N-acyltransferase",
    "2.3.1.270\tlyso-ornithine lipid O-acyltransferase",
    "2.3.1.271\tL-glutamate-5-semialdehyde N-acetyltransferase",
    "2.3.1.272\t2-acetylphloroglucinol acetyltransferase",
    "2.3.1.273\tdiglucosylglycerate octanoyltransferase",
    "2.3.1.274\tphosphate acyltransferase",
    "2.3.1.275\tacyl phosphate:glycerol-3-phosphate acyltransferase",
    "2.3.1.276\tgalactosamine-1-phosphate N-acetyltransferase",
    "2.3.1.277\t2-oxo-3-(phosphooxy)propyl 3-oxoalkanoate synthase",
    "2.3.1.278\tmycolipenoyl-CoA--2-(long-chain-fatty acyl)-trehalose mycolipenoyltransferase",
    "2.3.1.279\tlong-chain-acyl-CoA--trehalose acyltransferase",
    "2.3.1.280\t(aminoalkyl)phosphonate N-acetyltransferase",
    "2.3.1.281\tcoelimycin P1 polyketide synthase",
    "2.3.1.282\tphenolphthiocerol/phthiocerol/phthiodiolone dimycocerosyl transferase",
    "2.3.1.283\t2'-acyl-2-O-sulfo-trehalose (hydroxy)phthioceranyltransferase",
    "2.3.1.284\t3'-(hydroxy)phthioceranyl-2'-palmitoyl(stearoyl)-2-O-sulfo-trehalose (hydroxy)phthioceranyltransferase",
    "2.3.1.285\t(13S,14R)-1,13-dihydroxy-N-methylcanadine 13-O-acetyltransferase",
    "2.3.1.286\tprotein acetyllysine N-acetyltransferase",
    "2.3.1.287\tphthioceranic/hydroxyphthioceranic acid synthase",
    "2.3.1.288\t2-O-sulfo trehalose long-chain-acyltransferase",
    "2.3.1.289\taureothin polyketide synthase system",
    "2.3.1.290\tspectinabilin polyketide synthase system",
    "2.3.1.291\tsphingoid base N-palmitoyltransferase",
    "2.3.1.292\t(phenol)carboxyphthiodiolenone synthase",
    "2.3.1.293\tmeromycolic acid 3-oxoacyl-(acyl carrier protein) synthase I",
    "2.3.1.294\tmeromycolic acid 3-oxoacyl-(acyl carrier protein) synthase II",
    "2.3.1.295\tmycoketide-CoA synthase",
    "2.3.1.296\tomega-hydroxyceramide transacylase",
    "2.3.1.297\tvery-long-chain ceramide synthase",
    "2.3.1.298\tultra-long-chain ceramide synthase",
    "2.3.1.299\tsphingoid base N-stearoyltransferase",
    "2.3.1.300\tbranched-chain beta-ketoacyl-[acyl-carrier-protein] synthase",
    "2.3.1.301\tmycobacterial beta-ketoacyl-[acyl carrier protein] synthase III",
    "2.3.1.302\thydroxycinnamoyl-CoA:5-hydroxyanthranilate N-hydroxycinnamoyltransferase",
    "2.3.1.303\talpha-L-Rha-(1->2)-alpha-D-Man-(1->2)-alpha-D-Man-(1->3)-alpha-D-Gal-PP-Und 2(IV)-O-acetyltransferase",
    "2.3.1.304\tpoly[(R)-3-hydroxyalkanoate] polymerase",
    "2.3.1.n4\t1-acyl-sn-glycerol-3-phosphate acyltransferase",
    "2.3.1.n5\tglycerol-3-phosphate acyltransferase (acyl-[acyl-carrier-protein]-transferring)",
    "2.3.1.n6\t1-acylglycerophosphoserine O-acyltransferase",
    "2.3.1.n7\t1-acylglycerophosphoethanolamine O-acyltransferase",
    "2.3.1.n12\tsinapoyl-beta-D-glucose:anthocyanin sinapoyltransferase",
    "2.3.2.1\tD-glutamyltransferase",
    "2.3.2.2\tgamma-glutamyltransferase",
    "2.3.2.3\tlysyltransferase",
    "2.3.2.5\tglutaminyl-peptide cyclotransferase",
    "2.3.2.6\tlysine/arginine leucyltransferase",
    "2.3.2.7\taspartyltransferase",
    "2.3.2.8\targinyltransferase",
    "2.3.2.9\tagaritine gamma-glutamyltransferase",
    "2.3.2.10\tUDP-N-acetylmuramoylpentapeptide-lysine N(6)-alanyltransferase",
    "2.3.2.11\talanylphosphatidylglycerol synthase",
    "2.3.2.12\tpeptidyltransferase",
    "2.3.2.13\tprotein-glutamine gamma-glutamyltransferase",
    "2.3.2.14\tD-alanine gamma-glutamyltransferase",
    "2.3.2.15\tglutathione gamma-glutamylcysteinyltransferase",
    "2.3.2.16\tlipid II:glycine glycyltransferase",
    "2.3.2.17\tN-acetylmuramoyl-L-alanyl-D-glutamyl-L-lysyl-(N(6)-glycyl)-D-alanyl-D-alanine-diphosphoundecaprenyl-N-acetylglucosamine:glycine glycyltransferase",
    "2.3.2.18\tN-acetylmuramoyl-L-alanyl-D-glutamyl-L-lysyl-(N(6)-triglycine)-D-alanyl-D-alanine-diphosphoundecaprenyl-N-acetylglucosamine:glycine glycyltransferase",
    "2.3.2.19\tribostamycin:4-(gamma-L-glutamylamino)-(S)-2-hydroxybutanoyl-[BtrI acyl-carrier protein] 4-(gamma-L-glutamylamino)-(S)-2-hydroxybutanoate transferase",
    "2.3.2.20\tcyclo(L-leucyl-L-phenylalanyl) synthase",
    "2.3.2.21\tcyclo(L-tyrosyl-L-tyrosyl) synthase",
    "2.3.2.22\tcyclo(L-leucyl-L-leucyl) synthase",
    "2.3.2.23\tE2 ubiquitin-conjugating enzyme",
    "2.3.2.24\t(E3-independent) E2 ubiquitin-conjugating enzyme",
    "2.3.2.25\tN-terminal E2 ubiquitin-conjugating enzyme",
    "2.3.2.26\tHECT-type E3 ubiquitin transferase",
    "2.3.2.27\tRING-type E3 ubiquitin transferase",
    "2.3.2.28\tL-allo-isoleucyltransferase",
    "2.3.2.29\taspartate/glutamate leucyltransferase",
    "2.3.2.30\tL-ornithine N(alpha)-acyltransferase",
    "2.3.2.31\tRBR-type E3 ubiquitin transferase",
    "2.3.2.32\tcullin-RING-type E3 NEDD8 transferase",
    "2.3.2.33\tRCR-type E3 ubiquitin transferase",
    "2.3.2.34\tE2 NEDD8-conjugating enzyme",
    "2.3.2.35\tcapsaicin synthase",
    "2.3.2.36\tRING-type E3 ubiquitin transferase (cysteine targeting)",
    "2.3.3.1\tcitrate (Si)-synthase",
    "2.3.3.2\tdecylcitrate synthase",
    "2.3.3.3\tcitrate (Re)-synthase",
    "2.3.3.4\tdecylhomocitrate synthase",
    "2.3.3.5\t2-methylcitrate synthase",
    "2.3.3.6\t2-ethylmalate synthase",
    "2.3.3.7\t3-ethylmalate synthase",
    "2.3.3.8\tATP citrate synthase",
    "2.3.3.9\tmalate synthase",
    "2.3.3.10\thydroxymethylglutaryl-CoA synthase",
    "2.3.3.11\t2-hydroxyglutarate synthase",
    "2.3.3.12\t3-propylmalate synthase",
    "2.3.3.13\t2-isopropylmalate synthase",
    "2.3.3.14\thomocitrate synthase",
    "2.3.3.15\tsulfoacetaldehyde acetyltransferase",
    "2.3.3.16\tcitrate synthase (unknown stereospecificity)",
    "2.3.3.17\tmethylthioalkylmalate synthase",
    "2.3.3.18\t2-phosphinomethylmalate synthase",
    "2.3.3.19\t2-phosphonomethylmalate synthase",
    "2.3.3.20\tacyl-CoA:acyl-CoA alkyltransferase",
    "2.4.1.1\tglycogen phosphorylase",
    "2.4.1.2\tdextrin dextranase",
    "2.4.1.4\tamylosucrase",
    "2.4.1.5\tdextransucrase",
    "2.4.1.7\tsucrose phosphorylase",
    "2.4.1.8\tmaltose phosphorylase",
    "2.4.1.9\tinulosucrase",
    "2.4.1.10\tlevansucrase",
    "2.4.1.11\tglycogen(starch) synthase",
    "2.4.1.12\tcellulose synthase (UDP-forming)",
    "2.4.1.13\tsucrose synthase",
    "2.4.1.14\tsucrose-phosphate synthase",
    "2.4.1.15\talpha,alpha-trehalose-phosphate synthase (UDP-forming)",
    "2.4.1.16\tchitin synthase",
    "2.4.1.17\tglucuronosyltransferase",
    "2.4.1.18\t1,4-alpha-glucan branching enzyme",
    "2.4.1.19\tcyclomaltodextrin glucanotransferase",
    "2.4.1.20\tcellobiose phosphorylase",
    "2.4.1.21\tstarch synthase",
    "2.4.1.22\tlactose synthase",
    "2.4.1.23\tsphingosine beta-galactosyltransferase",
    "2.4.1.24\t1,4-alpha-glucan 6-alpha-glucosyltransferase",
    "2.4.1.25\t4-alpha-glucanotransferase",
    "2.4.1.26\tDNA alpha-glucosyltransferase",
    "2.4.1.27\tDNA beta-glucosyltransferase",
    "2.4.1.28\tglucosyl-DNA beta-glucosyltransferase",
    "2.4.1.29\tcellulose synthase (GDP-forming)",
    "2.4.1.30\t1,3-beta-oligoglucan phosphorylase",
    "2.4.1.31\tlaminaribiose phosphorylase",
    "2.4.1.32\tglucomannan 4-beta-mannosyltransferase",
    "2.4.1.33\tmannuronan synthase",
    "2.4.1.34\t1,3-beta-glucan synthase",
    "2.4.1.35\tphenol beta-glucosyltransferase",
    "2.4.1.36\talpha,alpha-trehalose-phosphate synthase (GDP-forming)",
    "2.4.1.37\tfucosylgalactoside 3-alpha-galactosyltransferase",
    "2.4.1.38\tbeta-N-acetylglucosaminylglycopeptide beta-1,4-galactosyltransferase",
    "2.4.1.39\tsteroid N-acetylglucosaminyltransferase",
    "2.4.1.40\tglycoprotein-fucosylgalactoside alpha-N-acetylgalactosaminyltransferase",
    "2.4.1.41\tpolypeptide N-acetylgalactosaminyltransferase",
    "2.4.1.43\tpolygalacturonate 4-alpha-galacturonosyltransferase",
    "2.4.1.44\tlipopolysaccharide 3-alpha-galactosyltransferase",
    "2.4.1.46\tmonogalactosyldiacylglycerol synthase",
    "2.4.1.47\tN-acylsphingosine galactosyltransferase",
    "2.4.1.48\theteroglycan alpha-mannosyltransferase",
    "2.4.1.49\tcellodextrin phosphorylase",
    "2.4.1.50\tprocollagen galactosyltransferase",
    "2.4.1.52\tpoly(glycerol-phosphate) alpha-glucosyltransferase",
    "2.4.1.53\tpoly(ribitol-phosphate) beta-glucosyltransferase",
    "2.4.1.54\tundecaprenyl-phosphate mannosyltransferase",
    "2.4.1.56\tlipopolysaccharide N-acetylglucosaminyltransferase",
    "2.4.1.58\tlipopolysaccharide glucosyltransferase I",
    "2.4.1.60\tCDP-abequose:alpha-D-Man-(1->4)-alpha-L-Rha-(1->3)-alpha-D-Gal-PP-Und alpha-1,3-abequosyltransferase",
    "2.4.1.62\tganglioside galactosyltransferase",
    "2.4.1.63\tlinamarin synthase",
    "2.4.1.64\talpha,alpha-trehalose phosphorylase",
    "2.4.1.65\t3-galactosyl-N-acetylglucosaminide 4-alpha-L-fucosyltransferase",
    "2.4.1.66\tprocollagen glucosyltransferase",
    "2.4.1.67\tgalactinol--raffinose galactosyltransferase",
    "2.4.1.68\tglycoprotein 6-alpha-L-fucosyltransferase",
    "2.4.1.69\ttype 1 galactoside alpha-(1,2)-fucosyltransferase",
    "2.4.1.70\tpoly(ribitol-phosphate) alpha-N-acetylglucosaminyltransferase",
    "2.4.1.71\tarylamine glucosyltransferase",
    "2.4.1.73\tlipopolysaccharide glucosyltransferase II",
    "2.4.1.74\tglycosaminoglycan galactosyltransferase",
    "2.4.1.78\tphosphopolyprenol glucosyltransferase",
    "2.4.1.79\tglobotriaosylceramide 3-beta-N-acetylgalactosaminyltransferase",
    "2.4.1.80\tceramide glucosyltransferase",
    "2.4.1.81\tflavone 7-O-beta-glucosyltransferase",
    "2.4.1.82\tgalactinol--sucrose galactosyltransferase",
    "2.4.1.83\tdolichyl-phosphate beta-D-mannosyltransferase",
    "2.4.1.85\tcyanohydrin beta-glucosyltransferase",
    "2.4.1.86\tN-acetyl-beta-D-glucosaminide beta-(1,3)-galactosyltransferase",
    "2.4.1.87\tN-acetyllactosaminide 3-alpha-galactosyltransferase",
    "2.4.1.88\tgloboside alpha-N-acetylgalactosaminyltransferase",
    "2.4.1.90\tN-acetyllactosamine synthase",
    "2.4.1.91\tflavonol 3-O-glucosyltransferase",
    "2.4.1.92\t(N-acetylneuraminyl)-galactosylglucosylceramide N-acetylgalactosaminyltransferase",
    "2.4.1.94\tprotein N-acetylglucosaminyltransferase",
    "2.4.1.96\tsn-glycerol-3-phosphate 1-galactosyltransferase",
    "2.4.1.97\t1,3-beta-D-glucan phosphorylase",
    "2.4.1.99\tsucrose:sucrose fructosyltransferase",
    "2.4.1.100\t2,1-fructan:2,1-fructan 1-fructosyltransferase",
    "2.4.1.101\talpha-1,3-mannosyl-glycoprotein 2-beta-N-acetylglucosaminyltransferase",
    "2.4.1.102\tbeta-1,3-galactosyl-O-glycosyl-glycoprotein beta-1,6-N-acetylglucosaminyltransferase",
    "2.4.1.103\talizarin 2-beta-glucosyltransferase",
    "2.4.1.104\to-dihydroxycoumarin 7-O-glucosyltransferase",
    "2.4.1.105\tvitexin beta-glucosyltransferase",
    "2.4.1.106\tisovitexin beta-glucosyltransferase",
    "2.4.1.109\tdolichyl-phosphate-mannose--protein mannosyltransferase",
    "2.4.1.110\ttRNA-queuosine alpha-mannosyltransferase",
    "2.4.1.111\tconiferyl-alcohol glucosyltransferase",
    "2.4.1.113\talpha-1,4-glucan-protein synthase (ADP-forming)",
    "2.4.1.114\t2-coumarate O-beta-glucosyltransferase",
    "2.4.1.115\tanthocyanidin 3-O-glucosyltransferase",
    "2.4.1.116\tcyanidin 3-O-rutinoside 5-O-glucosyltransferase",
    "2.4.1.117\tdolichyl-phosphate beta-glucosyltransferase",
    "2.4.1.118\tcytokinin 7-beta-glucosyltransferase",
    "2.4.1.120\tsinapate 1-glucosyltransferase",
    "2.4.1.121\tindole-3-acetate beta-glucosyltransferase",
    "2.4.1.122\tN-acetylgalactosaminide beta-1,3-galactosyltransferase",
    "2.4.1.123\tinositol 3-alpha-galactosyltransferase",
    "2.4.1.125\tsucrose--1,6-alpha-glucan 3(6)-alpha-glucosyltransferase",
    "2.4.1.126\thydroxycinnamate 4-beta-glucosyltransferase",
    "2.4.1.127\tmonoterpenol beta-glucosyltransferase",
    "2.4.1.128\tscopoletin glucosyltransferase",
    "2.4.1.129\tpeptidoglycan glycosyltransferase",
    "2.4.1.131\tGDP-Man:Man3GlcNAc2-PP-dolichol alpha-1,2-mannosyltransferase",
    "2.4.1.132\tGDP-Man:Man1GlcNAc2-PP-dolichol alpha-1,3-mannosyltransferase",
    "2.4.1.133\txylosylprotein 4-beta-galactosyltransferase",
    "2.4.1.134\tgalactosylxylosylprotein 3-beta-galactosyltransferase",
    "2.4.1.135\tgalactosylgalactosylxylosylprotein 3-beta-glucuronosyltransferase",
    "2.4.1.136\tgallate 1-beta-glucosyltransferase",
    "2.4.1.137\tsn-glycerol-3-phosphate 2-alpha-galactosyltransferase",
    "2.4.1.138\tmannotetraose 2-alpha-N-acetylglucosaminyltransferase",
    "2.4.1.139\tmaltose synthase",
    "2.4.1.140\talternansucrase",
    "2.4.1.141\tN-acetylglucosaminyldiphosphodolichol N-acetylglucosaminyltransferase",
    "2.4.1.142\tchitobiosyldiphosphodolichol beta-mannosyltransferase",
    "2.4.1.143\talpha-1,6-mannosyl-glycoprotein 2-beta-N-acetylglucosaminyltransferase",
    "2.4.1.144\tbeta-1,4-mannosyl-glycoprotein 4-beta-N-acetylglucosaminyltransferase",
    "2.4.1.145\talpha-1,3-mannosyl-glycoprotein 4-beta-N-acetylglucosaminyltransferase",
    "2.4.1.146\tbeta-1,3-galactosyl-O-glycosyl-glycoprotein beta-1,3-N-acetylglucosaminyltransferase",
    "2.4.1.147\tacetylgalactosaminyl-O-glycosyl-glycoprotein beta-1,3-N-acetylglucosaminyltransferase",
    "2.4.1.148\tacetylgalactosaminyl-O-glycosyl-glycoprotein beta-1,6-N-acetylglucosaminyltransferase",
    "2.4.1.149\tN-acetyllactosaminide beta-1,3-N-acetylglucosaminyltransferase",
    "2.4.1.150\tN-acetyllactosaminide beta-1,6-N-acetylglucosaminyltransferase",
    "2.4.1.152\t4-galactosyl-N-acetylglucosaminide 3-alpha-L-fucosyltransferase",
    "2.4.1.153\tUDP-N-acetylglucosamine--dolichyl-phosphate N-acetylglucosaminyltransferase",
    "2.4.1.155\talpha-1,6-mannosyl-glycoprotein 6-beta-N-acetylglucosaminyltransferase",
    "2.4.1.156\tindolylacetyl-myo-inositol galactosyltransferase",
    "2.4.1.158\t13-hydroxydocosanoate 13-beta-glucosyltransferase",
    "2.4.1.159\tflavonol-3-O-glucoside L-rhamnosyltransferase",
    "2.4.1.160\tpyridoxine 5'-O-beta-D-glucosyltransferase",
    "2.4.1.161\toligosaccharide 4-alpha-D-glucosyltransferase",
    "2.4.1.162\taldose beta-D-fructosyltransferase",
    "2.4.1.165\tN-acetylneuraminylgalactosylglucosylceramide beta-1,4-N-acetylgalactosaminyltransferase",
    "2.4.1.166\traffinose--raffinose alpha-galactosyltransferase",
    "2.4.1.167\tsucrose 6(F)-alpha-galactosyltransferase",
    "2.4.1.168\txyloglucan 4-glucosyltransferase",
    "2.4.1.170\tisoflavone 7-O-glucosyltransferase",
    "2.4.1.171\tmethyl-ONN-azoxymethanol beta-D-glucosyltransferase",
    "2.4.1.172\tsalicyl-alcohol beta-D-glucosyltransferase",
    "2.4.1.173\tsterol 3beta-glucosyltransferase",
    "2.4.1.174\tglucuronylgalactosylproteoglycan 4-beta-N-acetylgalactosaminyltransferase",
    "2.4.1.175\tglucuronosyl-N-acetylgalactosaminyl-proteoglycan 4-beta-N-acetylgalactosaminyltransferase",
    "2.4.1.176\tgibberellin beta-D-glucosyltransferase",
    "2.4.1.177\tcinnamate beta-D-glucosyltransferase",
    "2.4.1.178\thydroxymandelonitrile glucosyltransferase",
    "2.4.1.179\tlactosylceramide beta-1,3-galactosyltransferase",
    "2.4.1.180\tlipopolysaccharide N-acetylmannosaminouronosyltransferase",
    "2.4.1.181\thydroxyanthraquinone glucosyltransferase",
    "2.4.1.182\tlipid-A-disaccharide synthase",
    "2.4.1.183\talpha-1,3-glucan synthase",
    "2.4.1.184\tgalactolipid galactosyltransferase",
    "2.4.1.185\tflavanone 7-O-beta-glucosyltransferase",
    "2.4.1.186\tglycogenin glucosyltransferase",
    "2.4.1.187\tN-acetylglucosaminyldiphosphoundecaprenol N-acetyl-beta-D-mannosaminyltransferase",
    "2.4.1.188\tN-acetylglucosaminyldiphosphoundecaprenol glucosyltransferase",
    "2.4.1.189\tluteolin 7-O-glucuronosyltransferase",
    "2.4.1.190\tluteolin-7-O-glucuronide 2''-O-glucuronosyltransferase",
    "2.4.1.191\tluteolin-7-O-diglucuronide 4'-O-glucuronosyltransferase",
    "2.4.1.192\tnuatigenin 3beta-glucosyltransferase",
    "2.4.1.193\tsarsapogenin 3beta-glucosyltransferase",
    "2.4.1.194\t4-hydroxybenzoate 4-O-beta-D-glucosyltransferase",
    "2.4.1.195\tN-hydroxythioamide S-beta-glucosyltransferase",
    "2.4.1.196\tnicotinate glucosyltransferase",
    "2.4.1.197\thigh-mannose-oligosaccharide beta-1,4-N-acetylglucosaminyltransferase",
    "2.4.1.198\tphosphatidylinositol N-acetylglucosaminyltransferase",
    "2.4.1.199\tbeta-mannosylphosphodecaprenol--mannooligosaccharide 6-mannosyltransferase",
    "2.4.1.201\talpha-1,6-mannosyl-glycoprotein 4-beta-N-acetylglucosaminyltransferase",
    "2.4.1.202\t2,4-dihydroxy-7-methoxy-2H-1,4-benzoxazin-3(4H)-one 2-D-glucosyltransferase",
    "2.4.1.203\ttrans-zeatin O-beta-D-glucosyltransferase",
    "2.4.1.205\tgalactogen 6beta-galactosyltransferase",
    "2.4.1.206\tlactosylceramide 1,3-N-acetyl-beta-D-glucosaminyltransferase",
    "2.4.1.207\txyloglucan:xyloglucosyl transferase",
    "2.4.1.208\tdiglucosyl diacylglycerol synthase (1,2-linking)",
    "2.4.1.209\tcis-p-coumarate glucosyltransferase",
    "2.4.1.210\tlimonoid glucosyltransferase",
    "2.4.1.211\t1,3-beta-galactosyl-N-acetylhexosamine phosphorylase",
    "2.4.1.212\thyaluronan synthase",
    "2.4.1.213\tglucosylglycerol-phosphate synthase",
    "2.4.1.214\tglycoprotein 3-alpha-L-fucosyltransferase",
    "2.4.1.215\tcis-zeatin O-beta-D-glucosyltransferase",
    "2.4.1.216\ttrehalose 6-phosphate phosphorylase",
    "2.4.1.217\tmannosyl-3-phosphoglycerate synthase",
    "2.4.1.218\thydroquinone glucosyltransferase",
    "2.4.1.219\tvomilenine glucosyltransferase",
    "2.4.1.220\tindoxyl-UDPG glucosyltransferase",
    "2.4.1.221\tpeptide-O-fucosyltransferase",
    "2.4.1.222\tO-fucosylpeptide 3-beta-N-acetylglucosaminyltransferase",
    "2.4.1.223\tglucuronosyl-galactosyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase",
    "2.4.1.224\tglucuronosyl-N-acetylglucosaminyl-proteoglycan 4-alpha-N-acetylglucosaminyltransferase",
    "2.4.1.225\tN-acetylglucosaminyl-proteoglycan 4-beta-glucuronosyltransferase",
    "2.4.1.226\tN-acetylgalactosaminyl-proteoglycan 3-beta-glucuronosyltransferase",
    "2.4.1.227\tundecaprenyldiphospho-muramoylpentapeptide beta-N-acetylglucosaminyltransferase",
    "2.4.1.228\tlactosylceramide 4-alpha-galactosyltransferase",
    "2.4.1.229\t[Skp1-protein]-hydroxyproline N-acetylglucosaminyltransferase",
    "2.4.1.230\tkojibiose phosphorylase",
    "2.4.1.231\talpha,alpha-trehalose phosphorylase (configuration-retaining)",
    "2.4.1.232\tinitiation-specific alpha-1,6-mannosyltransferase",
    "2.4.1.234\tkaempferol 3-O-galactosyltransferase",
    "2.4.1.236\tflavanone 7-O-glucoside 2''-O-beta-L-rhamnosyltransferase",
    "2.4.1.237\tflavonol 7-O-beta-glucosyltransferase",
    "2.4.1.238\tdelphinidin 3,5-di-O-glucoside 3'-O-glucosyltransferase",
    "2.4.1.239\tflavonol-3-O-glucoside glucosyltransferase",
    "2.4.1.240\tflavonol-3-O-glycoside glucosyltransferase",
    "2.4.1.241\tdigalactosyldiacylglycerol synthase",
    "2.4.1.242\tNDP-glucose--starch glucosyltransferase",
    "2.4.1.243\t6(G)-fructosyltransferase",
    "2.4.1.244\tN-acetyl-beta-glucosaminyl-glycoprotein 4-beta-N-acetylgalactosaminyltransferase",
    "2.4.1.245\talpha,alpha-trehalose synthase",
    "2.4.1.246\tmannosylfructose-phosphate synthase",
    "2.4.1.247\tbeta-D-galactosyl-(1->4)-L-rhamnose phosphorylase",
    "2.4.1.248\tcycloisomaltooligosaccharide glucanotransferase",
    "2.4.1.249\tdelphinidin 3',5'-O-glucosyltransferase",
    "2.4.1.250\tD-inositol-3-phosphate glycosyltransferase",
    "2.4.1.251\tGlcA-beta-(1->2)-D-Man-alpha-(1->3)-D-Glc-beta-(1->4)-D-Glc-alpha-1-diphospho-ditrans,octacis-undecaprenol 4-beta-mannosyltransferase",
    "2.4.1.252\tGDP-mannose:cellobiosyl-diphosphopolyprenol alpha-mannosyltransferase",
    "2.4.1.253\tbaicalein 7-O-glucuronosyltransferase",
    "2.4.1.254\tcyanidin-3-O-glucoside 2''-O-glucuronosyltransferase",
    "2.4.1.255\tprotein O-GlcNAc transferase",
    "2.4.1.256\tdolichyl-P-Glc:Glc2Man9GlcNAc2-PP-dolichol alpha-1,2-glucosyltransferase",
    "2.4.1.257\tGDP-Man:Man2GlcNAc2-PP-dolichol alpha-1,6-mannosyltransferase",
    "2.4.1.258\tdolichyl-P-Man:Man5GlcNAc2-PP-dolichol alpha-1,3-mannosyltransferase",
    "2.4.1.259\tdolichyl-P-Man:Man6GlcNAc2-PP-dolichol alpha-1,2-mannosyltransferase",
    "2.4.1.260\tdolichyl-P-Man:Man7GlcNAc2-PP-dolichol alpha-1,6-mannosyltransferase",
    "2.4.1.261\tdolichyl-P-Man:Man8GlcNAc2-PP-dolichol alpha-1,2-mannosyltransferase",
    "2.4.1.262\tsoyasapogenol glucuronosyltransferase",
    "2.4.1.263\tabscisate beta-glucosyltransferase",
    "2.4.1.264\tD-Man-alpha-(1->3)-D-Glc-beta-(1->4)-D-Glc-alpha-1-diphosphoundecaprenol 2-beta-glucuronosyltransferase",
    "2.4.1.265\tdolichyl-P-Glc:Glc1Man9GlcNAc2-PP-dolichol alpha-1,3-glucosyltransferase",
    "2.4.1.266\tglucosyl-3-phosphoglycerate synthase",
    "2.4.1.267\tdolichyl-P-Glc:Man9GlcNAc2-PP-dolichol alpha-1,3-glucosyltransferase",
    "2.4.1.268\tglucosylglycerate synthase",
    "2.4.1.269\tmannosylglycerate synthase",
    "2.4.1.270\tmannosylglucosyl-3-phosphoglycerate synthase",
    "2.4.1.271\tcrocetin glucosyltransferase",
    "2.4.1.272\tsoyasapogenol B glucuronide galactosyltransferase",
    "2.4.1.273\tsoyasaponin III rhamnosyltransferase",
    "2.4.1.274\tglucosylceramide beta-1,4-galactosyltransferase",
    "2.4.1.275\tneolactotriaosylceramide beta-1,4-galactosyltransferase",
    "2.4.1.276\tzeaxanthin glucosyltransferase",
    "2.4.1.277\t10-deoxymethynolide desosaminyltransferase",
    "2.4.1.278\t3-alpha-mycarosylerythronolide B desosaminyl transferase",
    "2.4.1.279\tnigerose phosphorylase",
    "2.4.1.280\tN,N'-diacetylchitobiose phosphorylase",
    "2.4.1.281\t4-O-beta-D-mannosyl-D-glucose phosphorylase",
    "2.4.1.282\t3-O-alpha-D-glucosyl-L-rhamnose phosphorylase",
    "2.4.1.283\t2-deoxystreptamine N-acetyl-D-glucosaminyltransferase",
    "2.4.1.284\t2-deoxystreptamine glucosyltransferase",
    "2.4.1.285\tUDP-GlcNAc:ribostamycin N-acetylglucosaminyltransferase",
    "2.4.1.286\tchalcone 4'-O-glucosyltransferase",
    "2.4.1.287\trhamnopyranosyl-N-acetylglucosaminyl-diphospho-decaprenol beta-1,4/1,5-galactofuranosyltransferase",
    "2.4.1.288\tgalactofuranosylgalactofuranosylrhamnosyl-N-acetylglucosaminyl-diphospho-decaprenol beta-1,5/1,6-galactofuranosyltransferase",
    "2.4.1.289\tN-acetylglucosaminyl-diphospho-decaprenol L-rhamnosyltransferase",
    "2.4.1.290\tN,N'-diacetylbacillosaminyl-diphospho-undecaprenol alpha-1,3-N-acetylgalactosaminyltransferase",
    "2.4.1.291\tN-acetylgalactosamine-N,N'-diacetylbacillosaminyl-diphospho-undecaprenol 4-alpha-N-acetylgalactosaminyltransferase",
    "2.4.1.292\tGalNAc-alpha-(1->4)-GalNAc-alpha-(1->3)-diNAcBac-PP-undecaprenol alpha-1,4-N-acetyl-D-galactosaminyltransferase",
    "2.4.1.293\tGalNAc5-diNAcBac-PP-undecaprenol beta-1,3-glucosyltransferase",
    "2.4.1.294\tcyanidin 3-O-galactosyltransferase",
    "2.4.1.295\tanthocyanin 3-O-sambubioside 5-O-glucosyltransferase",
    "2.4.1.296\tanthocyanidin 3-O-coumaroylrutinoside 5-O-glucosyltransferase",
    "2.4.1.297\tanthocyanidin 3-O-glucoside 2''-O-glucosyltransferase",
    "2.4.1.298\tanthocyanidin 3-O-glucoside 5-O-glucosyltransferase",
    "2.4.1.299\tcyanidin 3-O-glucoside 5-O-glucosyltransferase (acyl-glucose)",
    "2.4.1.300\tcyanidin 3-O-glucoside 7-O-glucosyltransferase (acyl-glucose)",
    "2.4.1.301\t2'-deamino-2'-hydroxyneamine 1-alpha-D-kanosaminyltransferase",
    "2.4.1.302\tL-demethylnoviosyl transferase",
    "2.4.1.303\tUDP-Gal:alpha-D-GlcNAc-diphosphoundecaprenol beta-1,3-galactosyltransferase",
    "2.4.1.304\tUDP-Gal:alpha-D-GlcNAc-diphosphoundecaprenol beta-1,4-galactosyltransferase",
    "2.4.1.305\tUDP-Glc:alpha-D-GlcNAc-glucosaminyl-diphosphoundecaprenol beta-1,3-glucosyltransferase",
    "2.4.1.306\tUDP-GalNAc:alpha-D-GalNAc-diphosphoundecaprenol alpha-1,3-N-acetylgalactosaminyltransferase",
    "2.4.1.308\tGDP-Fuc:beta-D-Gal-1,3-alpha-D-GalNAc-1,3-alpha-GalNAc-diphosphoundecaprenol alpha-1,2-fucosyltransferase",
    "2.4.1.309\tUDP-Gal:alpha-L-Fuc-1,2-beta-Gal-1,3-alpha-GalNAc-1,3-alpha-GalNAc-diphosphoundecaprenol alpha-1,3-galactosyltransferase",
    "2.4.1.310\tvancomycin aglycone glucosyltransferase",
    "2.4.1.311\tdTDP-epi-vancosaminyltransferase",
    "2.4.1.312\tprotein O-mannose beta-1,4-N-acetylglucosaminyltransferase",
    "2.4.1.313\tprotein O-mannose beta-1,3-N-acetylgalactosaminyltransferase",
    "2.4.1.314\tginsenoside Rd glucosyltransferase",
    "2.4.1.315\tdiglucosyl diacylglycerol synthase (1,6-linking)",
    "2.4.1.316\ttylactone mycaminosyltransferase",
    "2.4.1.317\tO-mycaminosyltylonolide 6-deoxyallosyltransferase",
    "2.4.1.318\tdemethyllactenocin mycarosyltransferase",
    "2.4.1.319\tbeta-1,4-mannooligosaccharide phosphorylase",
    "2.4.1.320\t1,4-beta-mannosyl-N-acetylglucosamine phosphorylase",
    "2.4.1.321\tcellobionic acid phosphorylase",
    "2.4.1.322\tdevancosaminyl-vancomycin vancosaminetransferase",
    "2.4.1.323\t7-deoxyloganetic acid glucosyltransferase",
    "2.4.1.324\t7-deoxyloganetin glucosyltransferase",
    "2.4.1.325\tTDP-N-acetylfucosamine:lipid II N-acetylfucosaminyltransferase",
    "2.4.1.326\taklavinone 7-L-rhodosaminyltransferase",
    "2.4.1.327\taclacinomycin-T 2-deoxy-L-fucose transferase",
    "2.4.1.328\terythronolide mycarosyltransferase",
    "2.4.1.329\tsucrose 6(F)-phosphate phosphorylase",
    "2.4.1.330\tbeta-D-glucosyl crocetin beta-1,6-glucosyltransferase",
    "2.4.1.331\t8-demethyltetracenomycin C L-rhamnosyltransferase",
    "2.4.1.332\t1,2-alpha-glucosylglycerol phosphorylase",
    "2.4.1.333\t1,2-beta-oligoglucan phosphorylase",
    "2.4.1.334\t1,3-alpha-oligoglucan phosphorylase",
    "2.4.1.335\tdolichyl N-acetyl-alpha-D-glucosaminyl phosphate 3-beta-D-2,3-diacetamido-2,3-dideoxy-beta-D-glucuronosyltransferase",
    "2.4.1.336\tmonoglucosyldiacylglycerol synthase",
    "2.4.1.337\t1,2-diacylglycerol 3-alpha-glucosyltransferase",
    "2.4.1.338\tvalidoxylamine A glucosyltransferase",
    "2.4.1.339\tbeta-1,2-mannobiose phosphorylase",
    "2.4.1.340\t1,2-beta-oligomannan phosphorylase",
    "2.4.1.341\talpha-1,2-colitosyltransferase",
    "2.4.1.342\talpha-maltose-1-phosphate synthase",
    "2.4.1.343\tUDP-Gal:alpha-D-GlcNAc-diphosphoundecaprenol alpha-1,3-galactosyltransferase",
    "2.4.1.344\ttype 2 galactoside alpha-(1,2)-fucosyltransferase",
    "2.4.1.345\tphosphatidyl-myo-inositol alpha-mannosyltransferase",
    "2.4.1.346\tphosphatidyl-myo-inositol dimannoside synthase",
    "2.4.1.347\talpha,alpha-trehalose-phosphate synthase (ADP-forming)",
    "2.4.1.348\tN-acetyl-alpha-D-glucosaminyl-diphospho-ditrans,octacis-undecaprenol 3-alpha-mannosyltransferase",
    "2.4.1.349\tmannosyl-N-acetyl-alpha-D-glucosaminyl-diphospho-ditrans,octacis-undecaprenol 3-alpha-mannosyltransferase",
    "2.4.1.350\tmogroside IE synthase",
    "2.4.1.351\trhamnogalacturonan I rhamnosyltransferase",
    "2.4.1.352\tglucosylglycerate phosphorylase",
    "2.4.1.353\tsordaricin 6-deoxyaltrosyltransferase",
    "2.4.1.354\t(R)-mandelonitrile beta-glucosyltransferase",
    "2.4.1.355\tpoly(ribitol-phosphate) beta-N-acetylglucosaminyltransferase",
    "2.4.1.356\tglucosyl-dolichyl phosphate glucuronosyltransferase",
    "2.4.1.357\tphlorizin synthase",
    "2.4.1.358\tacylphloroglucinol glucosyltransferase",
    "2.4.1.359\tglucosylglycerol phosphorylase (configuration-retaining)",
    "2.4.1.360\t2-hydroxyflavanone C-glucosyltransferase",
    "2.4.1.361\tGDP-mannose:di-myo-inositol-1,3'-phosphate beta-1,2-mannosyltransferase",
    "2.4.1.362\talpha-(1->3) branching sucrase",
    "2.4.1.363\tginsenoside 20-O-glucosyltransferase",
    "2.4.1.364\tprotopanaxadiol-type ginsenoside 3-O-glucosyltransferase",
    "2.4.1.365\tprotopanaxadiol-type ginsenoside-3-O-glucoside 2''-O-glucosyltransferase",
    "2.4.1.366\tginsenoside F1 6-O-glucosyltransferase",
    "2.4.1.367\tginsenoside 6-O-glucosyltransferase",
    "2.4.1.368\toleanolate 3-O-glucosyltransferase",
    "2.4.1.369\tenterobactin C-glucosyltransferase",
    "2.4.1.370\tinositol phosphorylceramide mannosyltransferase",
    "2.4.1.371\tpolymannosyl GlcNAc-diphospho-ditrans,octacis-undecaprenol 2,3-alpha-mannosylpolymerase",
    "2.4.1.372\tmutansucrase",
    "2.4.1.373\talpha-(1->2) branching sucrase",
    "2.4.1.374\tbeta-1,2-mannooligosaccharide synthase",
    "2.4.1.375\trhamnogalacturonan I galactosyltransferase",
    "2.4.1.376\tEGF-domain serine glucosyltransferase",
    "2.4.1.377\tdTDP-Rha:alpha-D-Gal-diphosphoundecaprenol alpha-1,3-rhamnosyltransferase",
    "2.4.1.378\tGDP-mannose:alpha-L-Rha-(1->3)-alpha-D-Gal-PP-Und alpha-1,4-mannosyltransferase",
    "2.4.1.379\tGDP-Man:alpha-D-Gal-diphosphoundecaprenol alpha-1,3-mannosyltransferase",
    "2.4.1.380\tGDP-Man:alpha-D-Man-(1->3)-alpha-D-Gal diphosphoundecaprenol alpha-1,2-mannosyltransferase",
    "2.4.1.381\tdTDP-Rha:alpha-D-Man-(1->3)-alpha-D-Gal diphosphoundecaprenol alpha-1,2-rahmnosyltransferase",
    "2.4.1.382\tCDP-abequose:alpha-L-Rha2OAc-(1->2)-alpha-D-Man-(1->2)-alpha-D-Man-(1->3)-alpha-D-Gal-PP-Und alpha-1,3-abequosyltransferase",
    "2.4.1.383\tGDP-Man:alpha-L-Rha-(1->3)-alpha-D-Gal-PP-Und beta-1,4-mannosyltransferase",
    "2.4.1.384\tNDP-glycosyltransferase",
    "2.4.1.n2\tloliose synthase",
    "2.4.2.1\tpurine-nucleoside phosphorylase",
    "2.4.2.2\tpyrimidine-nucleoside phosphorylase",
    "2.4.2.3\turidine phosphorylase",
    "2.4.2.4\tthymidine phosphorylase",
    "2.4.2.5\tnucleoside ribosyltransferase",
    "2.4.2.6\tnucleoside deoxyribosyltransferase",
    "2.4.2.7\tadenine phosphoribosyltransferase",
    "2.4.2.8\thypoxanthine phosphoribosyltransferase",
    "2.4.2.9\turacil phosphoribosyltransferase",
    "2.4.2.10\torotate phosphoribosyltransferase",
    "2.4.2.12\tnicotinamide phosphoribosyltransferase",
    "2.4.2.14\tamidophosphoribosyltransferase",
    "2.4.2.15\tguanosine phosphorylase",
    "2.4.2.16\turate-ribonucleoside phosphorylase",
    "2.4.2.17\tATP phosphoribosyltransferase",
    "2.4.2.18\tanthranilate phosphoribosyltransferase",
    "2.4.2.19\tnicotinate-nucleotide diphosphorylase (carboxylating)",
    "2.4.2.20\tdioxotetrahydropyrimidine phosphoribosyltransferase",
    "2.4.2.21\tnicotinate-nucleotide--dimethylbenzimidazole phosphoribosyltransferase",
    "2.4.2.22\txanthine phosphoribosyltransferase",
    "2.4.2.24\t1,4-beta-D-xylan synthase",
    "2.4.2.25\tflavone apiosyltransferase",
    "2.4.2.26\tprotein xylosyltransferase",
    "2.4.2.27\tdTDP-dihydrostreptose--streptidine-6-phosphate dihydrostreptosyltransferase",
    "2.4.2.28\tS-methyl-5'-thioadenosine phosphorylase",
    "2.4.2.29\ttRNA-guanosine(34) preQ1 transglycosylase",
    "2.4.2.30\tNAD(+) ADP-ribosyltransferase",
    "2.4.2.31\tNAD(+)--protein-arginine ADP-ribosyltransferase",
    "2.4.2.32\tdolichyl-phosphate D-xylosyltransferase",
    "2.4.2.33\tdolichyl-xylosyl-phosphate--protein xylosyltransferase",
    "2.4.2.34\tindolylacetylinositol arabinosyltransferase",
    "2.4.2.35\tflavonol-3-O-glycoside xylosyltransferase",
    "2.4.2.36\tNAD(+)--diphthamide ADP-ribosyltransferase",
    "2.4.2.37\tNAD(+)--dinitrogen-reductase ADP-D-ribosyltransferase",
    "2.4.2.38\tglycoprotein 2-beta-D-xylosyltransferase",
    "2.4.2.39\txyloglucan 6-xylosyltransferase",
    "2.4.2.40\tzeatin O-beta-D-xylosyltransferase",
    "2.4.2.41\txylogalacturonan beta-1,3-xylosyltransferase",
    "2.4.2.42\tUDP-D-xylose:beta-D-glucoside alpha-1,3-D-xylosyltransferase",
    "2.4.2.43\tlipid IVA 4-amino-4-deoxy-L-arabinosyltransferase",
    "2.4.2.44\tS-methyl-5'-thioinosine phosphorylase",
    "2.4.2.45\tdecaprenyl-phosphate phosphoribosyltransferase",
    "2.4.2.46\tgalactan 5-O-arabinofuranosyltransferase",
    "2.4.2.47\tarabinofuranan 3-O-arabinosyltransferase",
    "2.4.2.48\ttRNA-guanine(15) transglycosylase",
    "2.4.2.49\tneamine phosphoribosyltransferase",
    "2.4.2.50\tcyanidin 3-O-galactoside 2''-O-xylosyltransferase",
    "2.4.2.51\tanthocyanidin 3-O-glucoside 2'''-O-xylosyltransferase",
    "2.4.2.52\ttriphosphoribosyl-dephospho-CoA synthase",
    "2.4.2.53\tundecaprenyl-phosphate 4-deoxy-4-formamido-L-arabinose transferase",
    "2.4.2.54\tbeta-ribofuranosylphenol 5'-phosphate synthase",
    "2.4.2.55\tnicotinate D-ribonucleotide:phenol phospho-D-ribosyltransferase",
    "2.4.2.56\tkaempferol 3-O-xylosyltransferase",
    "2.4.2.57\tAMP phosphorylase",
    "2.4.2.58\thydroxyproline O-arabinosyltransferase",
    "2.4.2.59\tsulfide-dependent adenosine diphosphate thiazole synthase",
    "2.4.2.60\tcysteine-dependent adenosine diphosphate thiazole synthase",
    "2.4.2.61\talpha-dystroglycan beta1,4-xylosyltransferase",
    "2.4.2.62\txylosyl alpha-1,3-xylosyltransferase",
    "2.4.2.63\tEGF-domain serine xylosyltransferase",
    "2.4.2.64\ttRNA-guanosine(34) queuine transglycosylase",
    "2.4.99.1\tbeta-galactoside alpha-(2,6)-sialyltransferase",
    "2.4.99.2\tbeta-D-galactosyl-(1->3)-N-acetyl-beta-D-galactosaminide alpha-2,3-sialyltransferase",
    "2.4.99.3\talpha-N-acetylgalactosaminide alpha-2,6-sialyltransferase",
    "2.4.99.4\tbeta-galactoside alpha-2,3-sialyltransferase",
    "2.4.99.5\tgalactosyldiacylglycerol alpha-2,3-sialyltransferase",
    "2.4.99.6\tN-acetyllactosaminide alpha-2,3-sialyltransferase",
    "2.4.99.7\talpha-N-acetylneuraminyl-2,3-beta-galactosyl-1,3-N-acetylgalactosaminide 6-alpha-sialyltransferase",
    "2.4.99.8\talpha-N-acetylneuraminate alpha-2,8-sialyltransferase",
    "2.4.99.9\tlactosylceramide alpha-2,3-sialyltransferase",
    "2.4.99.12\tlipid IVA 3-deoxy-D-manno-octulosonic acid transferase",
    "2.4.99.13\t(Kdo)-lipid IVA 3-deoxy-D-manno-octulosonic acid transferase",
    "2.4.99.14\t(Kdo)2-lipid IVA (2-8) 3-deoxy-D-manno-octulosonic acid transferase",
    "2.4.99.15\t(Kdo)3-lipid IVA (2-4) 3-deoxy-D-manno-octulosonic acid transferase",
    "2.4.99.16\tstarch synthase (maltosyl-transferring)",
    "2.4.99.17\tS-adenosylmethionine:tRNA ribosyltransferase-isomerase",
    "2.4.99.18\tdolichyl-diphosphooligosaccharide--protein glycotransferase",
    "2.4.99.19\tundecaprenyl-diphosphooligosaccharide--protein glycotransferase",
    "2.4.99.20\t2'-phospho-ADP-ribosyl cyclase/2'-phospho-cyclic-ADP-ribose transferase",
    "2.4.99.21\tdolichyl-phosphooligosaccharide-protein glycotransferase",
    "2.4.99.22\tN-acetylglucosaminide alpha-(2,6)-sialyltransferase",
    "2.5.1.1\tdimethylallyltranstransferase",
    "2.5.1.2\tthiamine pyridinylase",
    "2.5.1.3\tthiamine phosphate synthase",
    "2.5.1.4\tadenosylmethionine cyclotransferase",
    "2.5.1.5\tgalactose-6-sulfurylase",
    "2.5.1.6\tmethionine adenosyltransferase",
    "2.5.1.7\tUDP-N-acetylglucosamine 1-carboxyvinyltransferase",
    "2.5.1.9\triboflavin synthase",
    "2.5.1.10\t(2E,6E)-farnesyl diphosphate synthase",
    "2.5.1.15\tdihydropteroate synthase",
    "2.5.1.16\tspermidine synthase",
    "2.5.1.17\tcorrinoid adenosyltransferase",
    "2.5.1.18\tglutathione transferase",
    "2.5.1.19\t3-phosphoshikimate 1-carboxyvinyltransferase",
    "2.5.1.20\trubber cis-polyprenylcistransferase",
    "2.5.1.21\tsqualene synthase",
    "2.5.1.22\tspermine synthase",
    "2.5.1.23\tsym-norspermidine synthase",
    "2.5.1.24\tdiscadenine synthase",
    "2.5.1.25\ttRNA-uridine aminocarboxypropyltransferase",
    "2.5.1.26\talkylglycerone-phosphate synthase",
    "2.5.1.27\tadenylate dimethylallyltransferase (AMP-dependent)",
    "2.5.1.28\tdimethylallylcistransferase",
    "2.5.1.29\tgeranylgeranyl diphosphate synthase",
    "2.5.1.30\theptaprenyl diphosphate synthase",
    "2.5.1.31\tditrans,polycis-undecaprenyl-diphosphate synthase [(2E,6E)-farnesyl-diphosphate specific]",
    "2.5.1.32\t15-cis-phytoene synthase",
    "2.5.1.34\t4-dimethylallyltryptophan synthase",
    "2.5.1.35\taspulvinone dimethylallyltransferase",
    "2.5.1.36\ttrihydroxypterocarpan dimethylallyltransferase",
    "2.5.1.38\tisonocardicin synthase",
    "2.5.1.39\t4-hydroxybenzoate polyprenyltransferase",
    "2.5.1.41\tphosphoglycerol geranylgeranyltransferase",
    "2.5.1.42\tgeranylgeranylglycerol-phosphate geranylgeranyltransferase",
    "2.5.1.43\tnicotianamine synthase",
    "2.5.1.44\thomospermidine synthase",
    "2.5.1.45\thomospermidine synthase (spermidine-specific)",
    "2.5.1.46\tdeoxyhypusine synthase",
    "2.5.1.47\tcysteine synthase",
    "2.5.1.48\tcystathionine gamma-synthase",
    "2.5.1.49\tO-acetylhomoserine aminocarboxypropyltransferase",
    "2.5.1.50\tzeatin 9-aminocarboxyethyltransferase",
    "2.5.1.51\tbeta-pyrazolylalanine synthase",
    "2.5.1.52\tL-mimosine synthase",
    "2.5.1.53\turacilylalanine synthase",
    "2.5.1.54\t3-deoxy-7-phosphoheptulonate synthase",
    "2.5.1.55\t3-deoxy-8-phosphooctulonate synthase",
    "2.5.1.56\tN-acetylneuraminate synthase",
    "2.5.1.57\tN-acylneuraminate-9-phosphate synthase",
    "2.5.1.58\tprotein farnesyltransferase",
    "2.5.1.59\tprotein geranylgeranyltransferase type I",
    "2.5.1.60\tprotein geranylgeranyltransferase type II",
    "2.5.1.61\thydroxymethylbilane synthase",
    "2.5.1.62\tchlorophyll synthase",
    "2.5.1.63\tadenosyl-fluoride synthase",
    "2.5.1.65\tO-phosphoserine sulfhydrylase",
    "2.5.1.66\tN(2)-(2-carboxyethyl)arginine synthase",
    "2.5.1.67\tchrysanthemyl diphosphate synthase",
    "2.5.1.68\t(2Z,6E)-farnesyl diphosphate synthase",
    "2.5.1.69\tlavandulyl diphosphate synthase",
    "2.5.1.70\tnaringenin 8-dimethylallyltransferase",
    "2.5.1.71\tleachianone-G 2''-dimethylallyltransferase",
    "2.5.1.72\tquinolinate synthase",
    "2.5.1.73\tO-phospho-L-seryl-tRNA:Cys-tRNA synthase",
    "2.5.1.74\t1,4-dihydroxy-2-naphthoate polyprenyltransferase",
    "2.5.1.75\ttRNA dimethylallyltransferase",
    "2.5.1.76\tcysteate synthase",
    "2.5.1.78\t6,7-dimethyl-8-ribityllumazine synthase",
    "2.5.1.79\tthermospermine synthase",
    "2.5.1.80\t7-dimethylallyltryptophan synthase",
    "2.5.1.81\tgeranylfarnesyl diphosphate synthase",
    "2.5.1.82\thexaprenyl diphosphate synthase [geranylgeranyl-diphosphate specific]",
    "2.5.1.83\thexaprenyl-diphosphate synthase [(2E,6E)-farnesyl-diphosphate specific]",
    "2.5.1.84\tall-trans-nonaprenyl-diphosphate synthase [geranyl-diphosphate specific]",
    "2.5.1.85\tall-trans-nonaprenyl-diphosphate synthase [geranylgeranyl-diphosphate specific]",
    "2.5.1.86\ttrans,polycis-decaprenyl diphosphate synthase",
    "2.5.1.87\tditrans,polycis-polyprenyl diphosphate synthase [(2E,6E)-farnesyl diphosphate specific]",
    "2.5.1.88\ttrans,polycis-polyprenyl diphosphate synthase [(2Z,6E)-farnesyl diphosphate specific]",
    "2.5.1.89\ttritrans,polycis-undecaprenyl-diphosphate synthase [geranylgeranyl-diphosphate specific]",
    "2.5.1.90\tall-trans-octaprenyl-diphosphate synthase",
    "2.5.1.91\tall-trans-decaprenyl-diphosphate synthase",
    "2.5.1.92\t(2Z,6Z)-farnesyl diphosphate synthase",
    "2.5.1.93\t4-hydroxybenzoate geranyltransferase",
    "2.5.1.94\tadenosyl-chloride synthase",
    "2.5.1.95\txanthan pyruvate transferase",
    "2.5.1.96\t4,4'-diapophytoene synthase",
    "2.5.1.97\tpseudaminic acid synthase",
    "2.5.1.98\tRhizobium leguminosarum exopolysaccharide glucosyl ketal-pyruvate-transferase",
    "2.5.1.100\tfumigaclavine A dimethylallyltransferase",
    "2.5.1.101\tN,N'-diacetyllegionaminate synthase",
    "2.5.1.102\tgeranylpyrophosphate--olivetolic acid geranyltransferase",
    "2.5.1.103\tpresqualene diphosphate synthase",
    "2.5.1.104\tN(1)-aminopropylagmatine synthase",
    "2.5.1.105\t7,8-dihydropterin-6-yl-methyl-4-(beta-D-ribofuranosyl)aminobenzene 5'-phosphate synthase",
    "2.5.1.106\ttryprostatin B synthase",
    "2.5.1.107\tverruculogen prenyltransferase",
    "2.5.1.108\t2-(3-amino-3-carboxypropyl)histidine synthase",
    "2.5.1.109\tbrevianamide F prenyltransferase (deoxybrevianamide E-forming)",
    "2.5.1.110\t12alpha,13alpha-dihydroxyfumitremorgin C prenyltransferase",
    "2.5.1.111\t4-hydroxyphenylpyruvate 3-dimethylallyltransferase",
    "2.5.1.112\tadenylate dimethylallyltransferase (ADP/ATP-dependent)",
    "2.5.1.113\t[CysO sulfur-carrier protein]-thiocarboxylate-dependent cysteine synthase",
    "2.5.1.114\ttRNA(Phe) (4-demethylwyosine(37)-C(7)) aminocarboxypropyltransferase",
    "2.5.1.115\thomogentisate phytyltransferase",
    "2.5.1.116\thomogentisate geranylgeranyltransferase",
    "2.5.1.117\thomogentisate solanesyltransferase",
    "2.5.1.118\tbeta-(isoxazolin-5-on-2-yl)-L-alanine synthase",
    "2.5.1.119\tbeta-(isoxazolin-5-on-4-yl)-L-alanine synthase",
    "2.5.1.120\taminodeoxyfutalosine synthase",
    "2.5.1.121\t5,10-dihydrophenazine-1-carboxylate 9-dimethylallyltransferase",
    "2.5.1.122\t4-O-dimethylallyl-L-tyrosine synthase",
    "2.5.1.123\tflaviolin linalyltransferase",
    "2.5.1.124\t6-linalyl-2-O,3-dimethylflaviolin synthase",
    "2.5.1.125\t7-geranyloxy-5-hydroxy-2-methoxy-3-methylnaphthalene-1,4-dione synthase",
    "2.5.1.126\tnorspermine synthase",
    "2.5.1.127\tcaldopentamine synthase",
    "2.5.1.128\tN(4)-bis(aminopropyl)spermidine synthase",
    "2.5.1.129\tflavin prenyltransferase",
    "2.5.1.130\t2-carboxy-1,4-naphthoquinone phytyltransferase",
    "2.5.1.131\t(4-{4-[2-(gamma-L-glutamylamino)ethyl]phenoxymethyl}furan-2-yl)methanamine synthase",
    "2.5.1.132\t3-deoxy-D-glycero-D-galacto-nononate 9-phosphate synthase",
    "2.5.1.133\tbacteriochlorophyll a synthase",
    "2.5.1.134\tcystathionine beta-synthase (O-acetyl-L-serine)",
    "2.5.1.135\tvalidamine 7-phosphate valienyltransferase",
    "2.5.1.136\t2-acylphloroglucinol 4-prenyltransferase",
    "2.5.1.137\t2-acyl-4-prenylphloroglucinol 6-prenyltransferase",
    "2.5.1.138\tcoumarin 8-geranyltransferase",
    "2.5.1.139\tumbelliferone 6-dimethylallyltransferase",
    "2.5.1.140\tN-(2-amino-2-carboxyethyl)-L-glutamate synthase",
    "2.5.1.141\theme o synthase",
    "2.5.1.142\tnerylneryl diphosphate synthase",
    "2.5.1.143\tpyridinium-3,5-biscarboxylic acid mononucleotide synthase",
    "2.5.1.144\tS-sulfo-L-cysteine synthase (O-acetyl-L-serine-dependent)",
    "2.5.1.145\tphosphatidylglycerol--prolipoprotein diacylglyceryl transferase",
    "2.5.1.146\t3-geranyl-3-[(Z)-2-isocyanoethenyl]indole synthase",
    "2.5.1.147\t5-amino-6-(D-ribitylamino)uracil--L-tyrosine 4-hydroxyphenyl transferase",
    "2.5.1.148\tlycopaoctaene synthase",
    "2.5.1.149\tlycopene elongase/hydratase (flavuxanthin-forming)",
    "2.5.1.150\tlycopene elongase/hydratase (dihydrobisanhydrobacterioruberin-forming)",
    "2.5.1.151\talkylcobalamin dealkylase",
    "2.5.1.152\tD-histidine 2-aminobutanoyltransferase",
    "2.5.1.153\tadenosine tuberculosinyltransferase",
    "2.5.1.n9\theptaprenylglyceryl phosphate synthase",
    "2.6.1.1\taspartate transaminase",
    "2.6.1.2\talanine transaminase",
    "2.6.1.3\tcysteine transaminase",
    "2.6.1.4\tglycine transaminase",
    "2.6.1.5\ttyrosine transaminase",
    "2.6.1.6\tleucine transaminase",
    "2.6.1.7\tkynurenine--oxoglutarate transaminase",
    "2.6.1.8\t2,5-diaminovalerate transaminase",
    "2.6.1.9\thistidinol-phosphate transaminase",
    "2.6.1.11\tacetylornithine transaminase",
    "2.6.1.12\talanine--oxo-acid transaminase",
    "2.6.1.13\tornithine aminotransferase",
    "2.6.1.14\tasparagine--oxo-acid transaminase",
    "2.6.1.15\tglutamine--pyruvate transaminase",
    "2.6.1.16\tglutamine--fructose-6-phosphate transaminase (isomerizing)",
    "2.6.1.17\tsuccinyldiaminopimelate transaminase",
    "2.6.1.18\tbeta-alanine--pyruvate transaminase",
    "2.6.1.19\t4-aminobutyrate--2-oxoglutarate transaminase",
    "2.6.1.21\tD-amino-acid transaminase",
    "2.6.1.22\t(S)-3-amino-2-methylpropionate transaminase",
    "2.6.1.23\t4-hydroxyglutamate transaminase",
    "2.6.1.24\tdiiodotyrosine transaminase",
    "2.6.1.26\tthyroid-hormone transaminase",
    "2.6.1.27\ttryptophan transaminase",
    "2.6.1.28\ttryptophan--phenylpyruvate transaminase",
    "2.6.1.29\tdiamine transaminase",
    "2.6.1.30\tpyridoxamine--pyruvate transaminase",
    "2.6.1.31\tpyridoxamine--oxaloacetate transaminase",
    "2.6.1.32\tvaline--3-methyl-2-oxovalerate transaminase",
    "2.6.1.33\tdTDP-4-amino-4,6-dideoxy-D-glucose transaminase",
    "2.6.1.34\tUDP-N-acetylbacillosamine transaminase",
    "2.6.1.35\tglycine--oxaloacetate transaminase",
    "2.6.1.36\tL-lysine 6-transaminase",
    "2.6.1.37\t2-aminoethylphosphonate--pyruvate transaminase",
    "2.6.1.38\thistidine transaminase",
    "2.6.1.39\t2-aminoadipate transaminase",
    "2.6.1.40\t(R)-3-amino-2-methylpropionate--pyruvate transaminase",
    "2.6.1.41\tD-methionine--pyruvate transaminase",
    "2.6.1.42\tbranched-chain-amino-acid transaminase",
    "2.6.1.43\taminolevulinate transaminase",
    "2.6.1.44\talanine--glyoxylate transaminase",
    "2.6.1.45\tserine--glyoxylate transaminase",
    "2.6.1.46\tdiaminobutyrate--pyruvate transaminase",
    "2.6.1.47\talanine--oxomalonate transaminase",
    "2.6.1.48\t5-aminovalerate transaminase",
    "2.6.1.49\tdihydroxyphenylalanine transaminase",
    "2.6.1.50\tglutamine--scyllo-inositol transaminase",
    "2.6.1.51\tserine--pyruvate transaminase",
    "2.6.1.52\tphosphoserine transaminase",
    "2.6.1.54\tpyridoxamine-phosphate transaminase",
    "2.6.1.55\ttaurine--2-oxoglutarate transaminase",
    "2.6.1.56\t1D-1-guanidino-3-amino-1,3-dideoxy-scyllo-inositol transaminase",
    "2.6.1.57\taromatic-amino-acid transaminase",
    "2.6.1.58\tphenylalanine(histidine) transaminase",
    "2.6.1.59\tdTDP-4-amino-4,6-dideoxygalactose transaminase",
    "2.6.1.60\taromatic-amino-acid--glyoxylate transaminase",
    "2.6.1.62\tadenosylmethionine--8-amino-7-oxononanoate transaminase",
    "2.6.1.63\tkynurenine--glyoxylate transaminase",
    "2.6.1.64\tglutamine--phenylpyruvate transaminase",
    "2.6.1.65\tN(6)-acetyl-beta-lysine transaminase",
    "2.6.1.66\tvaline--pyruvate transaminase",
    "2.6.1.67\t2-aminohexanoate transaminase",
    "2.6.1.70\taspartate--phenylpyruvate transaminase",
    "2.6.1.71\tlysine--pyruvate 6-transaminase",
    "2.6.1.72\tD-4-hydroxyphenylglycine transaminase",
    "2.6.1.73\tmethionine--glyoxylate transaminase",
    "2.6.1.74\tcephalosporin-C transaminase",
    "2.6.1.75\tcysteine-conjugate transaminase",
    "2.6.1.76\tdiaminobutyrate--2-oxoglutarate transaminase",
    "2.6.1.77\ttaurine--pyruvate aminotransferase",
    "2.6.1.78\taspartate--prephenate aminotransferase",
    "2.6.1.79\tglutamate--prephenate aminotransferase",
    "2.6.1.80\tnicotianamine aminotransferase",
    "2.6.1.81\tsuccinylornithine transaminase",
    "2.6.1.82\tputrescine--2-oxoglutarate transaminase",
    "2.6.1.83\tLL-diaminopimelate aminotransferase",
    "2.6.1.84\targinine--pyruvate transaminase",
    "2.6.1.85\taminodeoxychorismate synthase",
    "2.6.1.86\t2-amino-4-deoxychorismate synthase",
    "2.6.1.87\tUDP-4-amino-4-deoxy-L-arabinose aminotransferase",
    "2.6.1.88\tmethionine transaminase",
    "2.6.1.89\tdTDP-3-amino-3,6-dideoxy-alpha-D-glucopyranose transaminase",
    "2.6.1.90\tdTDP-3-amino-3,6-dideoxy-alpha-D-galactopyranose transaminase",
    "2.6.1.92\tUDP-4-amino-4,6-dideoxy-N-acetyl-beta-L-altrosamine transaminase",
    "2.6.1.93\tneamine transaminase",
    "2.6.1.94\t2'-deamino-2'-hydroxyneamine transaminase",
    "2.6.1.95\tneomycin C transaminase",
    "2.6.1.96\t4-aminobutyrate--pyruvate transaminase",
    "2.6.1.97\tarchaeosine synthase",
    "2.6.1.98\tUDP-2-acetamido-2-deoxy-ribo-hexuluronate aminotransferase",
    "2.6.1.99\tL-tryptophan--pyruvate aminotransferase",
    "2.6.1.100\tL-glutamine:2-deoxy-scyllo-inosose aminotransferase",
    "2.6.1.101\tL-glutamine:3-amino-2,3-dideoxy-scyllo-inosose aminotransferase",
    "2.6.1.102\tGDP-perosamine synthase",
    "2.6.1.103\t(S)-3,5-dihydroxyphenylglycine transaminase",
    "2.6.1.104\t3-dehydro-glucose-6-phosphate--glutamate transaminase",
    "2.6.1.105\tlysine--8-amino-7-oxononanoate transaminase",
    "2.6.1.106\tdTDP-3-amino-3,4,6-trideoxy-alpha-D-glucose transaminase",
    "2.6.1.107\tbeta-methylphenylalanine transaminase",
    "2.6.1.108\t(5-formylfuran-3-yl)methyl phosphate transaminase",
    "2.6.1.109\t8-amino-3,8-dideoxy-alpha-D-manno-octulosonate transaminase",
    "2.6.1.110\tdTDP-4-dehydro-2,3,6-trideoxy-D-glucose 4-aminotransferase",
    "2.6.1.111\t3-aminobutanoyl-CoA transaminase",
    "2.6.1.112\t(S)-ureidoglycine--glyoxylate transaminase",
    "2.6.1.113\tputrescine--pyruvate transaminase",
    "2.6.1.114\t8-demethyl-8-aminoriboflavin-5'-phosphate synthase",
    "2.6.1.115\t5-hydroxydodecatetraenal 1-aminotransferase",
    "2.6.1.116\t6-aminohexanoate aminotransferase",
    "2.6.1.117\tL-glutamine--4-(methylsulfanyl)-2-oxobutanoate aminotransferase",
    "2.6.1.118\t[amino group carrier protein]-gamma-(L-lysyl)-L-glutamate aminotransferase",
    "2.6.1.119\tvanillin aminotransferase",
    "2.6.3.1\toximinotransferase",
    "2.6.99.1\tdATP(dGTP)--DNA purinetransferase",
    "2.6.99.2\tpyridoxine 5'-phosphate synthase",
    "2.6.99.3\tO-ureido-L-serine synthase",
    "2.7.1.1\thexokinase",
    "2.7.1.2\tglucokinase",
    "2.7.1.3\tketohexokinase",
    "2.7.1.4\tfructokinase",
    "2.7.1.5\trhamnulokinase",
    "2.7.1.6\tgalactokinase",
    "2.7.1.7\tmannokinase",
    "2.7.1.8\tglucosamine kinase",
    "2.7.1.10\tphosphoglucokinase",
    "2.7.1.11\t6-phosphofructokinase",
    "2.7.1.12\tgluconokinase",
    "2.7.1.13\tdehydrogluconokinase",
    "2.7.1.14\tsedoheptulokinase",
    "2.7.1.15\tribokinase",
    "2.7.1.16\tribulokinase",
    "2.7.1.17\txylulokinase",
    "2.7.1.18\tphosphoribokinase",
    "2.7.1.19\tphosphoribulokinase",
    "2.7.1.20\tadenosine kinase",
    "2.7.1.21\tthymidine kinase",
    "2.7.1.22\tribosylnicotinamide kinase",
    "2.7.1.23\tNAD(+) kinase",
    "2.7.1.24\tdephospho-CoA kinase",
    "2.7.1.25\tadenylyl-sulfate kinase",
    "2.7.1.26\triboflavin kinase",
    "2.7.1.27\terythritol kinase (D-erythritol 4-phosphate-forming)",
    "2.7.1.28\ttriokinase",
    "2.7.1.29\tglycerone kinase",
    "2.7.1.30\tglycerol kinase",
    "2.7.1.31\tglycerate 3-kinase",
    "2.7.1.32\tcholine kinase",
    "2.7.1.33\tpantothenate kinase",
    "2.7.1.34\tpantetheine kinase",
    "2.7.1.35\tpyridoxal kinase",
    "2.7.1.36\tmevalonate kinase",
    "2.7.1.39\thomoserine kinase",
    "2.7.1.40\tpyruvate kinase",
    "2.7.1.41\tglucose-1-phosphate phosphodismutase",
    "2.7.1.42\triboflavin phosphotransferase",
    "2.7.1.43\tglucuronokinase",
    "2.7.1.44\tgalacturonokinase",
    "2.7.1.45\t2-dehydro-3-deoxygluconokinase",
    "2.7.1.46\tL-arabinokinase",
    "2.7.1.47\tD-ribulokinase",
    "2.7.1.48\turidine/cytidine kinase",
    "2.7.1.49\thydroxymethylpyrimidine kinase",
    "2.7.1.50\thydroxyethylthiazole kinase",
    "2.7.1.51\tL-fuculokinase",
    "2.7.1.52\tfucokinase",
    "2.7.1.53\tL-xylulokinase",
    "2.7.1.54\tD-arabinokinase",
    "2.7.1.55\tallose kinase",
    "2.7.1.56\t1-phosphofructokinase",
    "2.7.1.58\t2-dehydro-3-deoxygalactonokinase",
    "2.7.1.59\tN-acetylglucosamine kinase",
    "2.7.1.60\tN-acylmannosamine kinase",
    "2.7.1.61\tacyl-phosphate--hexose phosphotransferase",
    "2.7.1.62\tphosphoramidate--hexose phosphotransferase",
    "2.7.1.63\tpolyphosphate--glucose phosphotransferase",
    "2.7.1.64\tinositol 3-kinase",
    "2.7.1.65\tscyllo-inosamine 4-kinase",
    "2.7.1.66\tundecaprenol kinase",
    "2.7.1.67\t1-phosphatidylinositol 4-kinase",
    "2.7.1.68\t1-phosphatidylinositol-4-phosphate 5-kinase",
    "2.7.1.71\tshikimate kinase",
    "2.7.1.72\tstreptomycin 6-kinase",
    "2.7.1.73\tinosine kinase",
    "2.7.1.74\tdeoxycytidine kinase",
    "2.7.1.76\tdeoxyadenosine kinase",
    "2.7.1.77\tnucleoside phosphotransferase",
    "2.7.1.78\tpolynucleotide 5'-hydroxyl-kinase",
    "2.7.1.79\tdiphosphate--glycerol phosphotransferase",
    "2.7.1.80\tdiphosphate--serine phosphotransferase",
    "2.7.1.81\thydroxylysine kinase",
    "2.7.1.82\tethanolamine kinase",
    "2.7.1.83\tpseudouridine kinase",
    "2.7.1.84\talkylglycerone kinase",
    "2.7.1.85\tbeta-glucoside kinase",
    "2.7.1.86\tNADH kinase",
    "2.7.1.87\tstreptomycin 3''-kinase",
    "2.7.1.88\tdihydrostreptomycin-6-phosphate 3'alpha-kinase",
    "2.7.1.89\tthiamine kinase",
    "2.7.1.90\tdiphosphate--fructose-6-phosphate 1-phosphotransferase",
    "2.7.1.91\tsphingosine kinase",
    "2.7.1.92\t5-dehydro-2-deoxygluconokinase",
    "2.7.1.93\talkylglycerol kinase",
    "2.7.1.94\tacylglycerol kinase",
    "2.7.1.95\tkanamycin kinase",
    "2.7.1.100\tS-methyl-5-thioribose kinase",
    "2.7.1.101\ttagatose kinase",
    "2.7.1.102\thamamelose kinase",
    "2.7.1.103\tviomycin kinase",
    "2.7.1.105\t6-phosphofructo-2-kinase",
    "2.7.1.106\tglucose-1,6-bisphosphate synthase",
    "2.7.1.107\tdiacylglycerol kinase (ATP)",
    "2.7.1.108\tdolichol kinase",
    "2.7.1.113\tdeoxyguanosine kinase",
    "2.7.1.114\tAMP--thymidine kinase",
    "2.7.1.118\tADP--thymidine kinase",
    "2.7.1.119\thygromycin-B 7''-O-kinase",
    "2.7.1.121\tphosphoenolpyruvate--glycerone phosphotransferase",
    "2.7.1.122\txylitol kinase",
    "2.7.1.127\tinositol-trisphosphate 3-kinase",
    "2.7.1.130\ttetraacyldisaccharide 4'-kinase",
    "2.7.1.134\tinositol-tetrakisphosphate 1-kinase",
    "2.7.1.136\tmacrolide 2'-kinase",
    "2.7.1.137\tphosphatidylinositol 3-kinase",
    "2.7.1.138\tceramide kinase",
    "2.7.1.140\tinositol-tetrakisphosphate 5-kinase",
    "2.7.1.142\tglycerol-3-phosphate--glucose phosphotransferase",
    "2.7.1.143\tdiphosphate-purine nucleoside kinase",
    "2.7.1.144\ttagatose-6-phosphate kinase",
    "2.7.1.145\tdeoxynucleoside kinase",
    "2.7.1.146\tADP-specific phosphofructokinase",
    "2.7.1.147\tADP-specific glucose/glucosamine kinase",
    "2.7.1.148\t4-(cytidine 5'-diphospho)-2-C-methyl-D-erythritol kinase",
    "2.7.1.149\t1-phosphatidylinositol-5-phosphate 4-kinase",
    "2.7.1.150\t1-phosphatidylinositol-3-phosphate 5-kinase",
    "2.7.1.151\tinositol-polyphosphate multikinase",
    "2.7.1.153\tphosphatidylinositol-4,5-bisphosphate 3-kinase",
    "2.7.1.154\tphosphatidylinositol-4-phosphate 3-kinase",
    "2.7.1.156\tadenosylcobinamide kinase",
    "2.7.1.157\tN-acetylgalactosamine kinase",
    "2.7.1.158\tinositol-pentakisphosphate 2-kinase",
    "2.7.1.159\tinositol-1,3,4-trisphosphate 5/6-kinase",
    "2.7.1.160\t2'-phosphotransferase",
    "2.7.1.161\tCTP-dependent riboflavin kinase",
    "2.7.1.162\tN-acetylhexosamine 1-kinase",
    "2.7.1.163\thygromycin B 4-O-kinase",
    "2.7.1.164\tO-phosphoseryl-tRNA(Sec) kinase",
    "2.7.1.165\tglycerate 2-kinase",
    "2.7.1.166\t3-deoxy-D-manno-octulosonic acid kinase",
    "2.7.1.167\tD-glycero-beta-D-manno-heptose-7-phosphate kinase",
    "2.7.1.168\tD-glycero-alpha-D-manno-heptose-7-phosphate kinase",
    "2.7.1.169\tpantoate kinase",
    "2.7.1.170\tanhydro-N-acetylmuramic acid kinase",
    "2.7.1.171\tprotein-fructosamine 3-kinase",
    "2.7.1.172\tprotein-ribulosamine 3-kinase",
    "2.7.1.173\tnicotinate riboside kinase",
    "2.7.1.174\tdiacylglycerol kinase (CTP)",
    "2.7.1.175\tmaltokinase",
    "2.7.1.176\tUDP-N-acetylglucosamine kinase",
    "2.7.1.177\tL-threonine kinase",
    "2.7.1.178\t2-dehydro-3-deoxyglucono/galactono-kinase",
    "2.7.1.179\tkanosamine kinase",
    "2.7.1.180\tFAD:protein FMN transferase",
    "2.7.1.181\tpolymannosyl GlcNAc-diphospho-ditrans,octacis-undecaprenol kinase",
    "2.7.1.182\tphytol kinase",
    "2.7.1.183\tglycoprotein-mannosyl O(6)-kinase",
    "2.7.1.184\tsulfofructose kinase",
    "2.7.1.185\tmevalonate 3-kinase",
    "2.7.1.186\tmevalonate-3-phosphate 5-kinase",
    "2.7.1.187\tacarbose 7(IV)-phosphotransferase",
    "2.7.1.188\t2-epi-5-epi-valiolone 7-kinase",
    "2.7.1.189\tautoinducer-2 kinase",
    "2.7.1.190\taminoglycoside 2''-phosphotransferase",
    "2.7.1.191\tprotein-N(pi)-phosphohistidine--D-mannose phosphotransferase",
    "2.7.1.192\tprotein-N(pi)-phosphohistidine--N-acetylmuramate phosphotransferase",
    "2.7.1.193\tprotein-N(pi)-phosphohistidine--N-acetyl-D-glucosamine phosphotransferase",
    "2.7.1.194\tprotein-N(pi)-phosphohistidine--L-ascorbate phosphotransferase",
    "2.7.1.195\tprotein-N(pi)-phosphohistidine--2-O-alpha-mannosyl-D-glycerate phosphotransferase",
    "2.7.1.196\tprotein-N(pi)-phosphohistidine--N,N'-diacetylchitobiose phosphotransferase",
    "2.7.1.197\tprotein-N(pi)-phosphohistidine--D-mannitol phosphotransferase",
    "2.7.1.198\tprotein-N(pi)-phosphohistidine--D-sorbitol phosphotransferase",
    "2.7.1.199\tprotein-N(pi)-phosphohistidine--D-glucose phosphotransferase",
    "2.7.1.200\tprotein-N(pi)-phosphohistidine--galactitol phosphotransferase",
    "2.7.1.201\tprotein-N(pi)-phosphohistidine--trehalose phosphotransferase",
    "2.7.1.202\tprotein-N(pi)-phosphohistidine--D-fructose phosphotransferase",
    "2.7.1.203\tprotein-N(pi)-phosphohistidine--D-glucosaminate phosphotransferase",
    "2.7.1.204\tprotein-N(pi)-phosphohistidine--D-galactose phosphotransferase",
    "2.7.1.205\tprotein-N(pi)-phosphohistidine--D-cellobiose phosphotransferase",
    "2.7.1.206\tprotein-N(pi)-phosphohistidine--L-sorbose phosphotransferase",
    "2.7.1.207\tprotein-N(pi)-phosphohistidine--lactose phosphotransferase",
    "2.7.1.208\tprotein-N(pi)-phosphohistidine--maltose phosphotransferase",
    "2.7.1.209\tL-erythrulose 1-kinase",
    "2.7.1.210\tD-erythrulose 4-kinase",
    "2.7.1.211\tprotein-N(pi)-phosphohistidine--sucrose phosphotransferase",
    "2.7.1.212\talpha-D-ribose-1-phosphate 5-kinase (ADP)",
    "2.7.1.213\tcytidine kinase",
    "2.7.1.214\tC7-cyclitol 7-kinase",
    "2.7.1.215\terythritol kinase (D-erythritol 1-phosphate-forming)",
    "2.7.1.216\tfarnesol kinase",
    "2.7.1.217\t3-dehydrotetronate 4-kinase",
    "2.7.1.218\tfructoselysine 6-kinase",
    "2.7.1.219\tD-threonate 4-kinase",
    "2.7.1.220\tD-erythronate 4-kinase",
    "2.7.1.221\tN-acetylmuramate 1-kinase",
    "2.7.1.222\t4-hydroxytryptamine kinase",
    "2.7.1.223\taminoimidazole riboside kinase",
    "2.7.1.224\tcytidine diphosphoramidate kinase",
    "2.7.1.225\tL-serine kinase (ATP)",
    "2.7.1.226\tL-serine kinase (ADP)",
    "2.7.1.227\tinositol phosphorylceramide synthase",
    "2.7.1.228\tmannosyl-inositol-phosphoceramide inositolphosphotransferase",
    "2.7.1.229\tdeoxyribokinase",
    "2.7.1.230\tamicoumacin kinase",
    "2.7.1.231\t3-oxoisoapionate kinase",
    "2.7.1.232\tlevoglucosan kinase",
    "2.7.1.233\tapulose kinase",
    "2.7.2.1\tacetate kinase",
    "2.7.2.2\tcarbamate kinase",
    "2.7.2.3\tphosphoglycerate kinase",
    "2.7.2.4\taspartate kinase",
    "2.7.2.6\tformate kinase",
    "2.7.2.7\tbutyrate kinase",
    "2.7.2.8\tacetylglutamate kinase",
    "2.7.2.10\tphosphoglycerate kinase (GTP)",
    "2.7.2.11\tglutamate 5-kinase",
    "2.7.2.12\tacetate kinase (diphosphate)",
    "2.7.2.14\tbranched-chain-fatty-acid kinase",
    "2.7.2.15\tpropionate kinase",
    "2.7.2.16\t2-phosphoglycerate kinase",
    "2.7.2.17\t[amino-group carrier protein]-L-2-aminoadipate 6-kinase",
    "2.7.2.18\tfatty acid kinase",
    "2.7.3.1\tguanidinoacetate kinase",
    "2.7.3.2\tcreatine kinase",
    "2.7.3.3\targinine kinase",
    "2.7.3.4\ttaurocyamine kinase",
    "2.7.3.5\tlombricine kinase",
    "2.7.3.6\thypotaurocyamine kinase",
    "2.7.3.7\topheline kinase",
    "2.7.3.8\tammonia kinase",
    "2.7.3.9\tphosphoenolpyruvate--protein phosphotransferase",
    "2.7.3.10\tagmatine kinase",
    "2.7.3.13\tglutamine kinase",
    "2.7.4.1\tATP-polyphosphate phosphotransferase",
    "2.7.4.2\tphosphomevalonate kinase",
    "2.7.4.3\tadenylate kinase",
    "2.7.4.4\tnucleoside-phosphate kinase",
    "2.7.4.6\tnucleoside-diphosphate kinase",
    "2.7.4.7\tphosphooxymethylpyrimidine kinase",
    "2.7.4.8\tguanylate kinase",
    "2.7.4.9\tdTMP kinase",
    "2.7.4.10\tnucleoside-triphosphate--adenylate kinase",
    "2.7.4.11\t(deoxy)adenylate kinase",
    "2.7.4.12\tT2-induced deoxynucleotide kinase",
    "2.7.4.13\t(deoxy)nucleoside-phosphate kinase",
    "2.7.4.14\tUMP/CMP kinase",
    "2.7.4.15\tthiamine-diphosphate kinase",
    "2.7.4.16\tthiamine-phosphate kinase",
    "2.7.4.17\t3-phosphoglyceroyl-phosphate--polyphosphate phosphotransferase",
    "2.7.4.18\tfarnesyl-diphosphate kinase",
    "2.7.4.19\t5-methyldeoxycytidine-5'-phosphate kinase",
    "2.7.4.20\tdolichyl-diphosphate--polyphosphate phosphotransferase",
    "2.7.4.21\tinositol-hexakisphosphate kinase",
    "2.7.4.22\tUMP kinase",
    "2.7.4.23\tribose 1,5-bisphosphate phosphokinase",
    "2.7.4.24\tdiphosphoinositol-pentakisphosphate kinase",
    "2.7.4.25\t(d)CMP kinase",
    "2.7.4.26\tisopentenyl phosphate kinase",
    "2.7.4.27\t([Pyruvate, phosphate dikinase] phosphate) phosphotransferase",
    "2.7.4.28\t([Pyruvate, water dikinase] phosphate) phosphotransferase",
    "2.7.4.29\tKdo2-lipid A phosphotransferase",
    "2.7.4.31\t[5-(aminomethyl)furan-3-yl]methyl phosphate kinase",
    "2.7.4.32\tfarnesyl phosphate kinase",
    "2.7.4.33\tAMP-polyphosphate phosphotransferase",
    "2.7.4.34\tGDP-polyphosphate phosphotransferase",
    "2.7.6.1\tribose-phosphate diphosphokinase",
    "2.7.6.2\tthiamine diphosphokinase",
    "2.7.6.3\t2-amino-4-hydroxy-6-hydroxymethyldihydropteridine diphosphokinase",
    "2.7.6.4\tnucleotide diphosphokinase",
    "2.7.6.5\tGTP diphosphokinase",
    "2.7.7.1\tnicotinamide-nucleotide adenylyltransferase",
    "2.7.7.2\tFAD synthase",
    "2.7.7.3\tpantetheine-phosphate adenylyltransferase",
    "2.7.7.4\tsulfate adenylyltransferase",
    "2.7.7.5\tsulfate adenylyltransferase (ADP)",
    "2.7.7.6\tDNA-directed RNA polymerase",
    "2.7.7.7\tDNA-directed DNA polymerase",
    "2.7.7.8\tpolyribonucleotide nucleotidyltransferase",
    "2.7.7.9\tUTP--glucose-1-phosphate uridylyltransferase",
    "2.7.7.10\tUTP--hexose-1-phosphate uridylyltransferase",
    "2.7.7.11\tUTP--xylose-1-phosphate uridylyltransferase",
    "2.7.7.12\tUDP-glucose--hexose-1-phosphate uridylyltransferase",
    "2.7.7.13\tmannose-1-phosphate guanylyltransferase",
    "2.7.7.14\tethanolamine-phosphate cytidylyltransferase",
    "2.7.7.15\tcholine-phosphate cytidylyltransferase",
    "2.7.7.18\tnicotinate-nucleotide adenylyltransferase",
    "2.7.7.19\tpolynucleotide adenylyltransferase",
    "2.7.7.22\tmannose-1-phosphate guanylyltransferase (GDP)",
    "2.7.7.23\tUDP-N-acetylglucosamine diphosphorylase",
    "2.7.7.24\tglucose-1-phosphate thymidylyltransferase",
    "2.7.7.27\tglucose-1-phosphate adenylyltransferase",
    "2.7.7.28\tnucleoside-triphosphate-aldose-1-phosphate nucleotidyltransferase",
    "2.7.7.30\tfucose-1-phosphate guanylyltransferase",
    "2.7.7.31\tDNA nucleotidylexotransferase",
    "2.7.7.32\tgalactose-1-phosphate thymidylyltransferase",
    "2.7.7.33\tglucose-1-phosphate cytidylyltransferase",
    "2.7.7.34\tglucose-1-phosphate guanylyltransferase",
    "2.7.7.35\tADP ribose phosphorylase",
    "2.7.7.36\taldose-1-phosphate adenylyltransferase",
    "2.7.7.37\taldose-1-phosphate nucleotidyltransferase",
    "2.7.7.38\t3-deoxy-manno-octulosonate cytidylyltransferase",
    "2.7.7.39\tglycerol-3-phosphate cytidylyltransferase",
    "2.7.7.40\tD-ribitol-5-phosphate cytidylyltransferase",
    "2.7.7.41\tphosphatidate cytidylyltransferase",
    "2.7.7.42\t[glutamine synthetase] adenylyltransferase",
    "2.7.7.43\tN-acylneuraminate cytidylyltransferase",
    "2.7.7.44\tglucuronate-1-phosphate uridylyltransferase",
    "2.7.7.45\tguanosine-triphosphate guanylyltransferase",
    "2.7.7.46\tgentamicin 2''-nucleotidyltransferase",
    "2.7.7.47\tstreptomycin 3''-adenylyltransferase",
    "2.7.7.48\tRNA-directed RNA polymerase",
    "2.7.7.49\tRNA-directed DNA polymerase",
    "2.7.7.50\tmRNA guanylyltransferase",
    "2.7.7.51\tadenylylsulfate--ammonia adenylyltransferase",
    "2.7.7.52\tRNA uridylyltransferase",
    "2.7.7.53\tATP adenylyltransferase",
    "2.7.7.56\ttRNA nucleotidyltransferase",
    "2.7.7.57\tN-methylphosphoethanolamine cytidylyltransferase",
    "2.7.7.59\t[protein-PII] uridylyltransferase",
    "2.7.7.60\t2-C-methyl-D-erythritol 4-phosphate cytidylyltransferase",
    "2.7.7.61\tcitrate lyase holo-[acyl-carrier protein] synthase",
    "2.7.7.62\tadenosylcobinamide-phosphate guanylyltransferase",
    "2.7.7.64\tUTP-monosaccharide-1-phosphate uridylyltransferase",
    "2.7.7.65\tdiguanylate cyclase",
    "2.7.7.66\tmalonate decarboxylase holo-[acyl-carrier protein] synthase",
    "2.7.7.67\tCDP-2,3-bis-(O-geranylgeranyl)-sn-glycerol synthase",
    "2.7.7.68\t2-phospho-L-lactate guanylyltransferase",
    "2.7.7.69\tGDP-L-galactose/GDP-D-glucose: hexose 1-phosphate guanylyltransferase",
    "2.7.7.70\tD-glycero-beta-D-manno-heptose 1-phosphate adenylyltransferase",
    "2.7.7.71\tD-glycero-alpha-D-manno-heptose 1-phosphate guanylyltransferase",
    "2.7.7.72\tCCA tRNA nucleotidyltransferase",
    "2.7.7.73\tsulfur carrier protein ThiS adenylyltransferase",
    "2.7.7.74\t1L-myo-inositol 1-phosphate cytidylyltransferase",
    "2.7.7.75\tmolybdopterin adenylyltransferase",
    "2.7.7.76\tmolybdenum cofactor cytidylyltransferase",
    "2.7.7.77\tmolybdenum cofactor guanylyltransferase",
    "2.7.7.78\tGDP-D-glucose phosphorylase",
    "2.7.7.79\ttRNA(His) guanylyltransferase",
    "2.7.7.80\tmolybdopterin-synthase adenylyltransferase",
    "2.7.7.81\tpseudaminic acid cytidylyltransferase",
    "2.7.7.82\tCMP-N,N'-diacetyllegionaminic acid synthase",
    "2.7.7.83\tUDP-N-acetylgalactosamine diphosphorylase",
    "2.7.7.84\t2'-5' oligoadenylate synthase",
    "2.7.7.85\tdiadenylate cyclase",
    "2.7.7.86\tcyclic GMP-AMP synthase",
    "2.7.7.87\tL-threonylcarbamoyladenylate synthase",
    "2.7.7.88\tGDP polyribonucleotidyltransferase",
    "2.7.7.89\t[glutamine synthetase]-adenylyl-L-tyrosine phosphorylase",
    "2.7.7.90\t8-amino-3,8-dideoxy-manno-octulosonate cytidylyltransferase",
    "2.7.7.91\tvalienol-1-phosphate guanylyltransferase",
    "2.7.7.92\t3-deoxy-D-glycero-D-galacto-nononate cytidylyltransferase",
    "2.7.7.93\tphosphonoformate cytidylyltransferase",
    "2.7.7.96\tADP-D-ribose pyrophosphorylase",
    "2.7.7.97\t3-hydroxy-4-methylanthranilate adenylyltransferase",
    "2.7.7.99\tN-acetyl-alpha-D-muramate 1-phosphate uridylyltransferase",
    "2.7.7.100\tSAMP-activating enzyme",
    "2.7.7.101\tDNA primase DnaG",
    "2.7.7.102\tDNA primase AEP",
    "2.7.7.103\tL-glutamine-phosphate cytidylyltransferase",
    "2.7.7.104\t2-hydroxyethylphosphonate cytidylyltransferase",
    "2.7.7.105\tphosphoenolpyruvate guanylyltransferase",
    "2.7.7.106\t3-phospho-D-glycerate guanylyltransferase",
    "2.7.7.n1\tprotein adenylyltransferase",
    "2.7.7.n6\tguanine phosphate-protein transferase",
    "2.7.8.1\tethanolaminephosphotransferase",
    "2.7.8.2\tdiacylglycerol cholinephosphotransferase",
    "2.7.8.3\tceramide cholinephosphotransferase",
    "2.7.8.4\tserine-phosphoethanolamine synthase",
    "2.7.8.5\tCDP-diacylglycerol--glycerol-3-phosphate 1-phosphatidyltransferase",
    "2.7.8.6\tundecaprenyl-phosphate galactose phosphotransferase",
    "2.7.8.7\tholo-[acyl-carrier-protein] synthase",
    "2.7.8.8\tCDP-diacylglycerol--serine O-phosphatidyltransferase",
    "2.7.8.9\tphosphomannan mannosephosphotransferase",
    "2.7.8.10\tsphingosine cholinephosphotransferase",
    "2.7.8.11\tCDP-diacylglycerol--inositol 3-phosphatidyltransferase",
    "2.7.8.12\tteichoic acid poly(glycerol phosphate) polymerase",
    "2.7.8.13\tphospho-N-acetylmuramoyl-pentapeptide-transferase",
    "2.7.8.14\tCDP-ribitol ribitolphosphotransferase",
    "2.7.8.15\tUDP-N-acetylglucosamine--dolichyl-phosphate N-acetylglucosaminephosphotransferase",
    "2.7.8.17\tUDP-N-acetylglucosamine--lysosomal-enzyme N-acetylglucosaminephosphotransferase",
    "2.7.8.18\tUDP-galactose--UDP-N-acetylglucosamine galactose phosphotransferase",
    "2.7.8.19\tUDP-glucose--glycoprotein glucose phosphotransferase",
    "2.7.8.20\tphosphatidylglycerol--membrane-oligosaccharide glycerophosphotransferase",
    "2.7.8.21\tmembrane-oligosaccharide glycerophosphotransferase",
    "2.7.8.22\t1-alkenyl-2-acylglycerol choline phosphotransferase",
    "2.7.8.23\tcarboxyvinyl-carboxyphosphonate phosphorylmutase",
    "2.7.8.24\tphosphatidylcholine synthase",
    "2.7.8.26\tadenosylcobinamide-GDP ribazoletransferase",
    "2.7.8.27\tsphingomyelin synthase",
    "2.7.8.28\t2-phospho-L-lactate transferase",
    "2.7.8.29\tL-serine-phosphatidylethanolamine phosphatidyltransferase",
    "2.7.8.31\tundecaprenyl-phosphate glucose phosphotransferase",
    "2.7.8.32\t3-O-alpha-D-mannopyranosyl-alpha-D-mannopyranose xylosylphosphotransferase",
    "2.7.8.33\tUDP-N-acetylglucosamine--undecaprenyl-phosphate N-acetylglucosaminephosphotransferase",
    "2.7.8.34\tCDP-L-myo-inositol myo-inositolphosphotransferase",
    "2.7.8.35\tUDP-N-acetylglucosamine--decaprenyl-phosphate N-acetylglucosaminephosphotransferase",
    "2.7.8.36\tundecaprenyl phosphate N,N'-diacetylbacillosamine 1-phosphate transferase",
    "2.7.8.37\talpha-D-ribose 1-methylphosphonate 5-triphosphate synthase",
    "2.7.8.38\tarchaetidylserine synthase",
    "2.7.8.39\tarchaetidylinositol phosphate synthase",
    "2.7.8.40\tUDP-N-acetylgalactosamine-undecaprenyl-phosphate N-acetylgalactosaminephosphotransferase",
    "2.7.8.41\tcardiolipin synthase (CMP-forming)",
    "2.7.8.42\tKdo2-lipid A phosphoethanolamine 7''-transferase",
    "2.7.8.43\tlipid A phosphoethanolamine transferase",
    "2.7.8.44\tteichoic acid glycerol-phosphate primase",
    "2.7.8.45\tteichoic acid glycerol-phosphate transferase",
    "2.7.8.46\tteichoic acid ribitol-phosphate primase",
    "2.7.8.47\tteichoic acid ribitol-phosphate polymerase",
    "2.7.8.n3\tceramide phosphoethanolamine synthase",
    "2.7.9.1\tpyruvate, phosphate dikinase",
    "2.7.9.2\tpyruvate, water dikinase",
    "2.7.9.3\tselenide, water dikinase",
    "2.7.9.4\talpha-glucan, water dikinase",
    "2.7.9.5\tphosphoglucan, water dikinase",
    "2.7.9.6\trifampicin phosphotransferase",
    "2.7.10.1\treceptor protein-tyrosine kinase",
    "2.7.10.2\tnon-specific protein-tyrosine kinase",
    "2.7.11.1\tnon-specific serine/threonine protein kinase",
    "2.7.11.2\t[pyruvate dehydrogenase (acetyl-transferring)] kinase",
    "2.7.11.3\tdephospho-[reductase kinase] kinase",
    "2.7.11.4\t[3-methyl-2-oxobutanoate dehydrogenase (acetyl-transferring)] kinase",
    "2.7.11.5\t[isocitrate dehydrogenase (NADP(+))] kinase",
    "2.7.11.6\t[tyrosine 3-monooxygenase] kinase",
    "2.7.11.7\t[myosin heavy-chain] kinase",
    "2.7.11.8\tFas-activated serine/threonine kinase",
    "2.7.11.9\t[Goodpasture-antigen-binding protein] kinase",
    "2.7.11.10\tIkappaB kinase",
    "2.7.11.11\tcAMP-dependent protein kinase",
    "2.7.11.12\tcGMP-dependent protein kinase",
    "2.7.11.13\tprotein kinase C",
    "2.7.11.14\trhodopsin kinase",
    "2.7.11.15\t[beta-adrenergic-receptor] kinase",
    "2.7.11.16\t[G-protein-coupled receptor] kinase",
    "2.7.11.17\tcalcium/calmodulin-dependent protein kinase",
    "2.7.11.18\t[myosin light-chain] kinase",
    "2.7.11.19\tphosphorylase kinase",
    "2.7.11.20\t[elongation factor 2] kinase",
    "2.7.11.21\tpolo kinase",
    "2.7.11.22\tcyclin-dependent kinase",
    "2.7.11.23\t[RNA-polymerase]-subunit kinase",
    "2.7.11.24\tmitogen-activated protein kinase",
    "2.7.11.25\tmitogen-activated protein kinase kinase kinase",
    "2.7.11.26\t[tau protein] kinase",
    "2.7.11.27\t[acetyl-CoA carboxylase] kinase",
    "2.7.11.28\ttropomyosin kinase",
    "2.7.11.29\t[low-density-lipoprotein receptor] kinase",
    "2.7.11.30\treceptor protein serine/threonine kinase",
    "2.7.11.31\t[hydroxymethylglutaryl-CoA reductase (NADPH)] kinase",
    "2.7.11.32\t[pyruvate, phosphate dikinase] kinase",
    "2.7.11.33\t[pyruvate, water dikinase] kinase",
    "2.7.12.1\tdual-specificity kinase",
    "2.7.12.2\tmitogen-activated protein kinase kinase",
    "2.7.13.1\tprotein-histidine pros-kinase",
    "2.7.13.2\tprotein-histidine tele-kinase",
    "2.7.13.3\thistidine kinase",
    "2.7.14.1\tprotein arginine kinase",
    "2.7.99.1\ttriphosphate--protein phosphotransferase",
    "2.8.1.1\tthiosulfate sulfurtransferase",
    "2.8.1.2\t3-mercaptopyruvate sulfurtransferase",
    "2.8.1.3\tthiosulfate--thiol sulfurtransferase",
    "2.8.1.4\ttRNA uracil 4-sulfurtransferase",
    "2.8.1.5\tthiosulfate--dithiol sulfurtransferase",
    "2.8.1.6\tbiotin synthase",
    "2.8.1.7\tcysteine desulfurase",
    "2.8.1.8\tlipoyl synthase",
    "2.8.1.9\tmolybdenum cofactor sulfurtransferase",
    "2.8.1.10\tthiazole synthase",
    "2.8.1.11\tmolybdopterin synthase sulfurtransferase",
    "2.8.1.12\tmolybdopterin synthase",
    "2.8.1.13\ttRNA-uridine 2-sulfurtransferase",
    "2.8.1.14\ttRNA-5-taurinomethyluridine 2-sulfurtransferase",
    "2.8.1.15\ttRNA-5-methyluridine(54) 2-sulfurtransferase",
    "2.8.1.16\tL-aspartate semialdehyde sulfurtransferase",
    "2.8.2.1\taryl sulfotransferase",
    "2.8.2.2\talcohol sulfotransferase",
    "2.8.2.3\tamine sulfotransferase",
    "2.8.2.4\testrone sulfotransferase",
    "2.8.2.5\tchondroitin 4-sulfotransferase",
    "2.8.2.6\tcholine sulfotransferase",
    "2.8.2.7\tUDP-N-acetylgalactosamine-4-sulfate sulfotransferase",
    "2.8.2.8\t[heparan sulfate]-glucosamine N-sulfotransferase",
    "2.8.2.9\ttyrosine-ester sulfotransferase",
    "2.8.2.10\tRenilla-luciferin sulfotransferase",
    "2.8.2.11\tgalactosylceramide sulfotransferase",
    "2.8.2.13\tpsychosine sulfotransferase",
    "2.8.2.14\tbile-salt sulfotransferase",
    "2.8.2.15\tsteroid sulfotransferase",
    "2.8.2.16\tthiol sulfotransferase",
    "2.8.2.17\tchondroitin 6-sulfotransferase",
    "2.8.2.18\tcortisol sulfotransferase",
    "2.8.2.19\ttriglucosylalkylacylglycerol sulfotransferase",
    "2.8.2.20\tprotein-tyrosine sulfotransferase",
    "2.8.2.21\tkeratan sulfotransferase",
    "2.8.2.22\taryl-sulfate sulfotransferase",
    "2.8.2.23\t[heparan sulfate]-glucosamine 3-sulfotransferase 1",
    "2.8.2.24\taromatic desulfoglucosinolate sulfotransferase",
    "2.8.2.25\tflavonol 3-sulfotransferase",
    "2.8.2.26\tquercetin-3-sulfate 3'-sulfotransferase",
    "2.8.2.27\tquercetin-3-sulfate 4'-sulfotransferase",
    "2.8.2.28\tquercetin-3,3'-bissulfate 7-sulfotransferase",
    "2.8.2.29\t[heparan sulfate]-glucosamine 3-sulfotransferase 2",
    "2.8.2.30\t[heparan sulfate]-glucosamine 3-sulfotransferase 3",
    "2.8.2.31\tpetromyzonol sulfotransferase",
    "2.8.2.32\tscymnol sulfotransferase",
    "2.8.2.33\tN-acetylgalactosamine 4-sulfate 6-O-sulfotransferase",
    "2.8.2.34\tglycochenodeoxycholate sulfotransferase",
    "2.8.2.35\tdermatan 4-sulfotransferase",
    "2.8.2.36\tdesulfo-A47934 sulfotransferase",
    "2.8.2.37\ttrehalose 2-sulfotransferase",
    "2.8.2.38\taliphatic desulfoglucosinolate sulfotransferase",
    "2.8.2.39\thydroxyjasmonate sulfotransferase",
    "2.8.2.40\tomega-hydroxy-beta-dihydromenaquinone-9 sulfotransferase",
    "2.8.2.n2\tthyroxine sulfotransferase",
    "2.8.3.1\tpropionate CoA-transferase",
    "2.8.3.2\toxalate CoA-transferase",
    "2.8.3.3\tmalonate CoA-transferase",
    "2.8.3.5\t3-oxoacid CoA-transferase",
    "2.8.3.6\t3-oxoadipate CoA-transferase",
    "2.8.3.8\tacetate CoA-transferase",
    "2.8.3.9\tbutyrate--acetoacetate CoA-transferase",
    "2.8.3.10\tcitrate CoA-transferase",
    "2.8.3.11\tcitramalate CoA-transferase",
    "2.8.3.12\tglutaconate CoA-transferase",
    "2.8.3.13\tsuccinate--hydroxymethylglutarate CoA-transferase",
    "2.8.3.14\t5-hydroxypentanoate CoA-transferase",
    "2.8.3.15\tsuccinyl-CoA:(R)-benzylsuccinate CoA-transferase",
    "2.8.3.16\tformyl-CoA transferase",
    "2.8.3.17\t3-(aryl)acryloyl-CoA:(R)-3-(aryl)lactate CoA-transferase",
    "2.8.3.18\tsuccinyl-CoA:acetate CoA-transferase",
    "2.8.3.19\tCoA:oxalate CoA-transferase",
    "2.8.3.20\tsuccinyl-CoA--D-citramalate CoA-transferase",
    "2.8.3.21\tL-carnitine CoA-transferase",
    "2.8.3.22\tsuccinyl-CoA--L-malate CoA-transferase",
    "2.8.3.23\tcaffeate CoA-transferase",
    "2.8.3.24\t(R)-2-hydroxy-4-methylpentanoate CoA-transferase",
    "2.8.3.25\tbile acid CoA-transferase",
    "2.8.3.26\tsuccinyl-CoA:mesaconate CoA transferase",
    "2.8.4.1\tcoenzyme-B sulfoethylthiotransferase",
    "2.8.4.2\tarsenate-mycothiol transferase",
    "2.8.4.3\ttRNA-2-methylthio-N(6)-dimethylallyladenosine synthase",
    "2.8.4.4\t[ribosomal protein S12] (aspartate(89)-C(3))-methylthiotransferase",
    "2.8.4.5\ttRNA (N(6)-L-threonylcarbamoyladenosine(37)-C(2))-methylthiotransferase",
    "2.8.5.1\tS-sulfo-L-cysteine synthase (3-phospho-L-serine-dependent)",
    "2.8.5.2\tL-cysteine S-thiosulfotransferase",
    "2.9.1.1\tL-seryl-tRNA(Sec) selenium transferase",
    "2.9.1.2\tO-phospho-L-seryl-tRNA(Sec):L-selenocysteinyl-tRNA synthase",
    "2.9.1.3\ttRNA 2-selenouridine synthase",
    "2.10.1.1\tmolybdopterin molybdotransferase",
    "3.1.1.1\tcarboxylesterase",
    "3.1.1.2\tarylesterase",
    "3.1.1.3\ttriacylglycerol lipase",
    "3.1.1.4\tphospholipase A2",
    "3.1.1.5\tlysophospholipase",
    "3.1.1.6\tacetylesterase",
    "3.1.1.7\tacetylcholinesterase",
    "3.1.1.8\tcholinesterase",
    "3.1.1.10\ttropinesterase",
    "3.1.1.11\tpectinesterase",
    "3.1.1.13\tsterol esterase",
    "3.1.1.14\tchlorophyllase",
    "3.1.1.15\tL-arabinonolactonase",
    "3.1.1.17\tgluconolactonase",
    "3.1.1.19\turonolactonase",
    "3.1.1.20\ttannase",
    "3.1.1.22\thydroxybutyrate-dimer hydrolase",
    "3.1.1.23\tacylglycerol lipase",
    "3.1.1.24\t3-oxoadipate enol-lactonase",
    "3.1.1.25\t1,4-lactonase",
    "3.1.1.26\tgalactolipase",
    "3.1.1.27\t4-pyridoxolactonase",
    "3.1.1.28\tacylcarnitine hydrolase",
    "3.1.1.29\taminoacyl-tRNA hydrolase",
    "3.1.1.30\tD-arabinonolactonase",
    "3.1.1.31\t6-phosphogluconolactonase",
    "3.1.1.32\tphospholipase A1",
    "3.1.1.33\t6-acetylglucose deacetylase",
    "3.1.1.34\tlipoprotein lipase",
    "3.1.1.35\tdihydrocoumarin hydrolase",
    "3.1.1.36\tlimonin-D-ring-lactonase",
    "3.1.1.37\tsteroid-lactonase",
    "3.1.1.38\ttriacetate-lactonase",
    "3.1.1.39\tactinomycin lactonase",
    "3.1.1.40\torsellinate-depside hydrolase",
    "3.1.1.41\tcephalosporin-C deacetylase",
    "3.1.1.42\tchlorogenate hydrolase",
    "3.1.1.43\talpha-amino-acid esterase",
    "3.1.1.44\t4-methyloxaloacetate esterase",
    "3.1.1.45\tcarboxymethylenebutenolidase",
    "3.1.1.46\tdeoxylimonate A-ring-lactonase",
    "3.1.1.47\t1-alkyl-2-acetylglycerophosphocholine esterase",
    "3.1.1.48\tfusarinine-C ornithinesterase",
    "3.1.1.49\tsinapine esterase",
    "3.1.1.50\twax-ester hydrolase",
    "3.1.1.51\tphorbol-diester hydrolase",
    "3.1.1.52\tphosphatidylinositol deacylase",
    "3.1.1.53\tsialate O-acetylesterase",
    "3.1.1.54\tacetoxybutynylbithiophene deacetylase",
    "3.1.1.55\tacetylsalicylate deacetylase",
    "3.1.1.56\tmethylumbelliferyl-acetate deacetylase",
    "3.1.1.57\t2-pyrone-4,6-dicarboxylate lactonase",
    "3.1.1.58\tN-acetylgalactosaminoglycan deacetylase",
    "3.1.1.59\tjuvenile-hormone esterase",
    "3.1.1.60\tbis(2-ethylhexyl)phthalate esterase",
    "3.1.1.61\tprotein-glutamate methylesterase",
    "3.1.1.63\t11-cis-retinyl-palmitate hydrolase",
    "3.1.1.64\tretinoid isomerohydrolase",
    "3.1.1.65\tL-rhamnono-1,4-lactonase",
    "3.1.1.66\t5-(3,4-diacetoxybut-1-ynyl)-2,2'-bithiophene deacetylase",
    "3.1.1.67\tfatty-acyl-ethyl-ester synthase",
    "3.1.1.68\txylono-1,4-lactonase",
    "3.1.1.70\tcetraxate benzylesterase",
    "3.1.1.71\tacetylalkylglycerol acetylhydrolase",
    "3.1.1.72\tacetylxylan esterase",
    "3.1.1.73\tferuloyl esterase",
    "3.1.1.74\tcutinase",
    "3.1.1.75\tpoly(3-hydroxybutyrate) depolymerase",
    "3.1.1.76\tpoly(3-hydroxyoctanoate) depolymerase",
    "3.1.1.77\tacyloxyacyl hydrolase",
    "3.1.1.78\tpolyneuridine-aldehyde esterase",
    "3.1.1.79\thormone-sensitive lipase",
    "3.1.1.80\tacetylajmaline esterase",
    "3.1.1.81\tquorum-quenching N-acyl-homoserine lactonase",
    "3.1.1.82\tpheophorbidase",
    "3.1.1.83\tmonoterpene epsilon-lactone hydrolase",
    "3.1.1.84\tcocaine esterase",
    "3.1.1.85\tpimeloyl-[acyl-carrier protein] methyl ester esterase",
    "3.1.1.86\trhamnogalacturonan acetylesterase",
    "3.1.1.87\tfumonisin B1 esterase",
    "3.1.1.88\tpyrethroid hydrolase",
    "3.1.1.89\tprotein phosphatase methylesterase-1",
    "3.1.1.90\tall-trans-retinyl ester 13-cis isomerohydrolase",
    "3.1.1.91\t2-oxo-3-(5-oxofuran-2-ylidene)propanoate lactonase",
    "3.1.1.92\t4-sulfomuconolactone hydrolase",
    "3.1.1.93\tmycophenolic acid acyl-glucuronide esterase",
    "3.1.1.94\tversiconal hemiacetal acetate esterase",
    "3.1.1.95\taclacinomycin methylesterase",
    "3.1.1.96\tD-aminoacyl-tRNA deacylase",
    "3.1.1.97\tmethylated diphthine methylhydrolase",
    "3.1.1.98\t[Wnt protein] O-palmitoleoyl-L-serine hydrolase",
    "3.1.1.99\t6-deoxy-6-sulfogluconolactonase",
    "3.1.1.100\tchlorophyllide a hydrolase",
    "3.1.1.101\tpoly(ethylene terephthalate) hydrolase",
    "3.1.1.102\tmono(ethylene terephthalate) hydrolase",
    "3.1.1.103\tteichoic acid D-alanine hydrolase",
    "3.1.1.104\t5-phospho-D-xylono-1,4-lactonase",
    "3.1.1.105\t3-O-acetylpapaveroxine carboxylesterase",
    "3.1.1.106\tO-acetyl-ADP-ribose deacetylase",
    "3.1.1.107\tapo-salmochelin esterase",
    "3.1.1.108\tiron(III) enterobactin esterase",
    "3.1.1.109\tiron(III) salmochelin esterase",
    "3.1.1.110\txylono-1,5-lactonase",
    "3.1.1.111\tphosphatidylserine sn-1 acylhydrolase",
    "3.1.1.112\tisoamyl acetate esterase",
    "3.1.1.113\tethyl acetate hydrolase",
    "3.1.1.114\tmethyl acetate hydrolase",
    "3.1.1.115\tD-apionolactonase",
    "3.1.1.116\tsn-1-specific diacylglycerol lipase",
    "3.1.1.117\t(4-O-methyl)-D-glucuronate--lignin esterase",
    "3.1.1.118\tphospholipid sn-1 acylhydrolase",
    "3.1.1.n2\tprotein-S-isoprenylcysteine alpha-carbonyl methylesterase",
    "3.1.2.1\tacetyl-CoA hydrolase",
    "3.1.2.2\tpalmitoyl-CoA hydrolase",
    "3.1.2.3\tsuccinyl-CoA hydrolase",
    "3.1.2.4\t3-hydroxyisobutyryl-CoA hydrolase",
    "3.1.2.5\thydroxymethylglutaryl-CoA hydrolase",
    "3.1.2.6\thydroxyacylglutathione hydrolase",
    "3.1.2.7\tglutathione thiolesterase",
    "3.1.2.10\tformyl-CoA hydrolase",
    "3.1.2.11\tacetoacetyl-CoA hydrolase",
    "3.1.2.12\tS-formylglutathione hydrolase",
    "3.1.2.13\tS-succinylglutathione hydrolase",
    "3.1.2.14\toleoyl-[acyl-carrier-protein] hydrolase",
    "3.1.2.16\tcitrate-lyase deacetylase",
    "3.1.2.17\t(S)-methylmalonyl-CoA hydrolase",
    "3.1.2.18\tADP-dependent short-chain-acyl-CoA hydrolase",
    "3.1.2.19\tADP-dependent medium-chain-acyl-CoA hydrolase",
    "3.1.2.20\tacyl-CoA hydrolase",
    "3.1.2.21\tdodecanoyl-[acyl-carrier-protein] hydrolase",
    "3.1.2.22\tpalmitoyl-protein hydrolase",
    "3.1.2.23\t4-hydroxybenzoyl-CoA thioesterase",
    "3.1.2.25\tphenylacetyl-CoA hydrolase",
    "3.1.2.27\tcholoyl-CoA hydrolase",
    "3.1.2.28\t1,4-dihydroxy-2-naphthoyl-CoA hydrolase",
    "3.1.2.29\tfluoroacetyl-CoA thioesterase",
    "3.1.2.30\t(3S)-malyl-CoA thioesterase",
    "3.1.2.31\tdihydromonacolin L-[lovastatin nonaketide synthase] thioesterase",
    "3.1.2.32\t2-aminobenzoylacetyl-CoA thioesterase",
    "3.1.3.1\talkaline phosphatase",
    "3.1.3.2\tacid phosphatase",
    "3.1.3.3\tphosphoserine phosphatase",
    "3.1.3.4\tphosphatidate phosphatase",
    "3.1.3.5\t5'-nucleotidase",
    "3.1.3.6\t3'-nucleotidase",
    "3.1.3.7\t3'(2'),5'-bisphosphate nucleotidase",
    "3.1.3.8\t3-phytase",
    "3.1.3.9\tglucose-6-phosphatase",
    "3.1.3.10\tglucose-1-phosphatase",
    "3.1.3.11\tfructose-bisphosphatase",
    "3.1.3.12\ttrehalose-phosphatase",
    "3.1.3.14\tmethylphosphothioglycerate phosphatase",
    "3.1.3.15\thistidinol-phosphatase",
    "3.1.3.16\tprotein-serine/threonine phosphatase",
    "3.1.3.17\t[phosphorylase] phosphatase",
    "3.1.3.18\tphosphoglycolate phosphatase",
    "3.1.3.19\tglycerol-2-phosphatase",
    "3.1.3.20\tphosphoglycerate phosphatase",
    "3.1.3.21\tglycerol-1-phosphatase",
    "3.1.3.22\tmannitol-1-phosphatase",
    "3.1.3.23\tsugar-phosphatase",
    "3.1.3.24\tsucrose-phosphate phosphatase",
    "3.1.3.25\tinositol-phosphate phosphatase",
    "3.1.3.26\t4-phytase",
    "3.1.3.27\tphosphatidylglycerophosphatase",
    "3.1.3.28\tADP-phosphoglycerate phosphatase",
    "3.1.3.29\tN-acylneuraminate-9-phosphatase",
    "3.1.3.32\tpolynucleotide 3'-phosphatase",
    "3.1.3.33\tpolynucleotide 5'-phosphatase",
    "3.1.3.34\tdeoxynucleotide 3'-phosphatase",
    "3.1.3.35\tthymidylate 5'-phosphatase",
    "3.1.3.36\tphosphoinositide 5-phosphatase",
    "3.1.3.37\tsedoheptulose-bisphosphatase",
    "3.1.3.38\t3-phosphoglycerate phosphatase",
    "3.1.3.39\tstreptomycin-6-phosphatase",
    "3.1.3.40\tguanidinodeoxy-scyllo-inositol-4-phosphatase",
    "3.1.3.41\t4-nitrophenylphosphatase",
    "3.1.3.42\t[glycogen-synthase-D] phosphatase",
    "3.1.3.43\t[pyruvate dehydrogenase (acetyl-transferring)]-phosphatase",
    "3.1.3.44\t[acetyl-CoA carboxylase]-phosphatase",
    "3.1.3.45\t3-deoxy-manno-octulosonate-8-phosphatase",
    "3.1.3.46\tfructose-2,6-bisphosphate 2-phosphatase",
    "3.1.3.47\t[hydroxymethylglutaryl-CoA reductase (NADPH)]-phosphatase",
    "3.1.3.48\tprotein-tyrosine-phosphatase",
    "3.1.3.49\t[pyruvate kinase]-phosphatase",
    "3.1.3.50\tsorbitol-6-phosphatase",
    "3.1.3.51\tdolichyl-phosphatase",
    "3.1.3.52\t[3-methyl-2-oxobutanoate dehydrogenase (2-methylpropanoyl-transferring)]-phosphatase",
    "3.1.3.53\t[myosin-light-chain] phosphatase",
    "3.1.3.54\tfructose-2,6-bisphosphate 6-phosphatase",
    "3.1.3.55\tcaldesmon-phosphatase",
    "3.1.3.56\tinositol-polyphosphate 5-phosphatase",
    "3.1.3.57\tinositol-1,4-bisphosphate 1-phosphatase",
    "3.1.3.58\tsugar-terminal-phosphatase",
    "3.1.3.59\talkylacetylglycerophosphatase",
    "3.1.3.60\tphosphoenolpyruvate phosphatase",
    "3.1.3.62\tmultiple inositol-polyphosphate phosphatase",
    "3.1.3.63\t2-carboxy-D-arabinitol-1-phosphatase",
    "3.1.3.64\tphosphatidylinositol-3-phosphatase",
    "3.1.3.66\tphosphatidylinositol-3,4-bisphosphate 4-phosphatase",
    "3.1.3.67\tphosphatidylinositol-3,4,5-trisphosphate 3-phosphatase",
    "3.1.3.68\t2-deoxyglucose-6-phosphatase",
    "3.1.3.69\tglucosylglycerol 3-phosphatase",
    "3.1.3.70\tmannosyl-3-phosphoglycerate phosphatase",
    "3.1.3.71\t2-phosphosulfolactate phosphatase",
    "3.1.3.72\t5-phytase",
    "3.1.3.73\tadenosylcobalamin/alpha-ribazole phosphatase",
    "3.1.3.74\tpyridoxal phosphatase",
    "3.1.3.75\tphosphoethanolamine/phosphocholine phosphatase",
    "3.1.3.76\tlipid-phosphate phosphatase",
    "3.1.3.77\tacireductone synthase",
    "3.1.3.78\tphosphatidylinositol-4,5-bisphosphate 4-phosphatase",
    "3.1.3.79\tmannosylfructose-phosphate phosphatase",
    "3.1.3.80\t2,3-bisphosphoglycerate 3-phosphatase",
    "3.1.3.81\tdiacylglycerol diphosphate phosphatase",
    "3.1.3.82\tD-glycero-beta-D-manno-heptose 1,7-bisphosphate 7-phosphatase",
    "3.1.3.83\tD-glycero-alpha-D-manno-heptose-1,7-bisphosphate 7-phosphatase",
    "3.1.3.84\tADP-ribose 1''-phosphate phosphatase",
    "3.1.3.85\tglucosyl-3-phosphoglycerate phosphatase",
    "3.1.3.86\tphosphatidylinositol-3,4,5-trisphosphate 5-phosphatase",
    "3.1.3.87\t2-hydroxy-3-keto-5-methylthiopentenyl-1-phosphate phosphatase",
    "3.1.3.88\t5''-phosphoribostamycin phosphatase",
    "3.1.3.89\t5'-deoxynucleotidase",
    "3.1.3.90\tmaltose 6'-phosphate phosphatase",
    "3.1.3.91\t7-methylguanosine nucleotidase",
    "3.1.3.92\tkanosamine-6-phosphate phosphatase",
    "3.1.3.93\tL-galactose 1-phosphate phosphatase",
    "3.1.3.94\tD-galactose 1-phosphate phosphatase",
    "3.1.3.95\tphosphatidylinositol-3,5-bisphosphate 3-phosphatase",
    "3.1.3.96\tpseudouridine 5'-phosphatase",
    "3.1.3.97\t3',5'-nucleoside bisphosphate phosphatase",
    "3.1.3.99\tIMP-specific 5'-nucleotidase",
    "3.1.3.100\tthiamine phosphate phosphatase",
    "3.1.3.101\tvalidoxylamine A 7'-phosphate phosphatase",
    "3.1.3.102\tFMN hydrolase",
    "3.1.3.103\t3-deoxy-D-glycero-D-galacto-nonulopyranosonate 9-phosphatase",
    "3.1.3.104\t5-amino-6-(5-phospho-D-ribitylamino)uracil phosphatase",
    "3.1.3.105\tN-acetyl-D-muramate 6-phosphate phosphatase",
    "3.1.3.106\t2-lysophosphatidate phosphatase",
    "3.1.3.107\tamicoumacin phosphatase",
    "3.1.3.108\tnocturnin",
    "3.1.4.1\tphosphodiesterase I",
    "3.1.4.2\tglycerophosphocholine phosphodiesterase",
    "3.1.4.3\tphospholipase C",
    "3.1.4.4\tphospholipase D",
    "3.1.4.11\tphosphoinositide phospholipase C",
    "3.1.4.12\tsphingomyelin phosphodiesterase",
    "3.1.4.13\tserine-ethanolaminephosphate phosphodiesterase",
    "3.1.4.14\t[acyl-carrier-protein] phosphodiesterase",
    "3.1.4.16\t2',3'-cyclic-nucleotide 2'-phosphodiesterase",
    "3.1.4.17\t3',5'-cyclic-nucleotide phosphodiesterase",
    "3.1.4.35\t3',5'-cyclic-GMP phosphodiesterase",
    "3.1.4.37\t2',3'-cyclic-nucleotide 3'-phosphodiesterase",
    "3.1.4.38\tglycerophosphocholine cholinephosphodiesterase",
    "3.1.4.39\talkylglycerophosphoethanolamine phosphodiesterase",
    "3.1.4.40\tCMP-N-acylneuraminate phosphodiesterase",
    "3.1.4.41\tsphingomyelin phosphodiesterase D",
    "3.1.4.42\tglycerol-1,2-cyclic-phosphate 2-phosphodiesterase",
    "3.1.4.43\tglycerophosphoinositol inositolphosphodiesterase",
    "3.1.4.44\tglycerophosphoinositol glycerophosphodiesterase",
    "3.1.4.45\tN-acetylglucosamine-1-phosphodiester alpha-N-acetylglucosaminidase",
    "3.1.4.46\tglycerophosphodiester phosphodiesterase",
    "3.1.4.48\tdolichylphosphate-glucose phosphodiesterase",
    "3.1.4.49\tdolichylphosphate-mannose phosphodiesterase",
    "3.1.4.50\tglycosylphosphatidylinositol phospholipase D",
    "3.1.4.51\tglucose-1-phospho-D-mannosylglycoprotein phosphodiesterase",
    "3.1.4.52\tcyclic-guanylate-specific phosphodiesterase",
    "3.1.4.53\t3',5'-cyclic-AMP phosphodiesterase",
    "3.1.4.54\tN-acetylphosphatidylethanolamine-hydrolyzing phospholipase D",
    "3.1.4.55\tphosphoribosyl 1,2-cyclic phosphate phosphodiesterase",
    "3.1.4.56\t7,8-dihydroneopterin 2',3'-cyclic phosphate phosphodiesterase",
    "3.1.4.57\tphosphoribosyl 1,2-cyclic phosphate 1,2-diphosphodiesterase",
    "3.1.4.58\tRNA 2',3'-cyclic 3'-phosphodiesterase",
    "3.1.4.59\tcyclic-di-AMP phosphodiesterase",
    "3.1.4.60\tpApA phosphodiesterase",
    "3.1.4.61\tcyclic 2,3-diphosphoglycerate hydrolase",
    "3.1.5.1\tdGTPase",
    "3.1.6.1\tarylsulfatase (type I)",
    "3.1.6.2\tsteryl-sulfatase",
    "3.1.6.3\tglycosulfatase",
    "3.1.6.4\tN-acetylgalactosamine-6-sulfatase",
    "3.1.6.6\tcholine-sulfatase",
    "3.1.6.7\tcellulose-polysulfatase",
    "3.1.6.8\tcerebroside-sulfatase",
    "3.1.6.9\tchondro-4-sulfatase",
    "3.1.6.10\tchondro-6-sulfatase",
    "3.1.6.11\tdisulfoglucosamine-6-sulfatase",
    "3.1.6.12\tN-acetylgalactosamine-4-sulfatase",
    "3.1.6.13\tiduronate-2-sulfatase",
    "3.1.6.14\tN-acetylglucosamine-6-sulfatase",
    "3.1.6.15\tN-sulfoglucosamine-3-sulfatase",
    "3.1.6.16\tmonomethyl-sulfatase",
    "3.1.6.17\tD-lactate-2-sulfatase",
    "3.1.6.18\tglucuronate-2-sulfatase",
    "3.1.6.19\t(R)-specific secondary-alkylsulfatase (type III)",
    "3.1.6.20\tS-sulfosulfanyl-L-cysteine sulfohydrolase",
    "3.1.6.21\tlinear primary-alkylsulfatase",
    "3.1.6.22\tbranched primary-alkylsulfatase",
    "3.1.7.1\tprenyl-diphosphatase",
    "3.1.7.2\tguanosine-3',5'-bis(diphosphate) 3'-diphosphatase",
    "3.1.7.3\tmonoterpenyl-diphosphatase",
    "3.1.7.5\tgeranylgeranyl diphosphate diphosphatase",
    "3.1.7.6\tfarnesyl diphosphatase",
    "3.1.7.9\tisotuberculosinol synthase",
    "3.1.7.10\t(13E)-labda-7,13-dien-15-ol synthase",
    "3.1.7.11\tgeranyl diphosphate diphosphatase",
    "3.1.7.12\t(+)-kolavelool synthase",
    "3.1.8.1\taryldialkylphosphatase",
    "3.1.8.2\tdiisopropyl-fluorophosphatase",
    "3.1.11.1\texodeoxyribonuclease I",
    "3.1.11.2\texodeoxyribonuclease III",
    "3.1.11.3\texodeoxyribonuclease (lambda-induced)",
    "3.1.11.4\texodeoxyribonuclease (phage SP3-induced)",
    "3.1.11.5\texodeoxyribonuclease V",
    "3.1.11.6\texodeoxyribonuclease VII",
    "3.1.12.1\t5' to 3' exodeoxyribonuclease (nucleoside 3'-phosphate-forming)",
    "3.1.13.1\texoribonuclease II",
    "3.1.13.2\texoribonuclease H",
    "3.1.13.3\toligonucleotidase",
    "3.1.13.4\tpoly(A)-specific ribonuclease",
    "3.1.13.5\tribonuclease D",
    "3.1.14.1\tyeast ribonuclease",
    "3.1.15.1\tvenom exonuclease",
    "3.1.16.1\tspleen exonuclease",
    "3.1.21.1\tdeoxyribonuclease I",
    "3.1.21.2\tdeoxyribonuclease IV",
    "3.1.21.3\ttype I site-specific deoxyribonuclease",
    "3.1.21.4\ttype II site-specific deoxyribonuclease",
    "3.1.21.5\ttype III site-specific deoxyribonuclease",
    "3.1.21.6\tCC-preferring endodeoxyribonuclease",
    "3.1.21.7\tdeoxyribonuclease V",
    "3.1.21.8\tT4 deoxyribonuclease II",
    "3.1.21.9\tT4 deoxyribonuclease IV",
    "3.1.21.10\tcrossover junction endodeoxyribonuclease",
    "3.1.22.1\tdeoxyribonuclease II",
    "3.1.22.2\tAspergillus deoxyribonuclease K1",
    "3.1.22.5\tdeoxyribonuclease X",
    "3.1.25.1\tdeoxyribonuclease (pyrimidine dimer)",
    "3.1.26.1\tPhysarum polycephalum ribonuclease",
    "3.1.26.2\tribonuclease alpha",
    "3.1.26.3\tribonuclease III",
    "3.1.26.4\tribonuclease H",
    "3.1.26.5\tribonuclease P",
    "3.1.26.6\tribonuclease IV",
    "3.1.26.7\tribonuclease P4",
    "3.1.26.8\tribonuclease M5",
    "3.1.26.9\tribonuclease [poly-(U)-specific]",
    "3.1.26.10\tribonuclease IX",
    "3.1.26.11\tribonuclease Z",
    "3.1.26.12\tribonuclease E",
    "3.1.26.13\tretroviral ribonuclease H",
    "3.1.26.n2\targonaute-2",
    "3.1.27.7\tribonuclease F",
    "3.1.27.8\tribonuclease V",
    "3.1.30.1\tAspergillus nuclease S1",
    "3.1.30.2\tSerratia marcescens nuclease",
    "3.1.31.1\tmicrococcal nuclease",
    "3.2.1.1\talpha-amylase",
    "3.2.1.2\tbeta-amylase",
    "3.2.1.3\tglucan 1,4-alpha-glucosidase",
    "3.2.1.4\tcellulase",
    "3.2.1.6\tendo-1,3(4)-beta-glucanase",
    "3.2.1.7\tinulinase",
    "3.2.1.8\tendo-1,4-beta-xylanase",
    "3.2.1.10\toligo-1,6-glucosidase",
    "3.2.1.11\tdextranase",
    "3.2.1.14\tchitinase",
    "3.2.1.15\tendo-polygalacturonase",
    "3.2.1.17\tlysozyme",
    "3.2.1.18\texo-alpha-sialidase",
    "3.2.1.20\talpha-glucosidase",
    "3.2.1.21\tbeta-glucosidase",
    "3.2.1.22\talpha-galactosidase",
    "3.2.1.23\tbeta-galactosidase",
    "3.2.1.24\talpha-mannosidase",
    "3.2.1.25\tbeta-mannosidase",
    "3.2.1.26\tbeta-fructofuranosidase",
    "3.2.1.28\talpha,alpha-trehalase",
    "3.2.1.31\tbeta-glucuronidase",
    "3.2.1.32\tendo-1,3-beta-xylanase",
    "3.2.1.33\tamylo-alpha-1,6-glucosidase",
    "3.2.1.35\thyaluronoglucosaminidase",
    "3.2.1.36\thyaluronoglucuronidase",
    "3.2.1.37\txylan 1,4-beta-xylosidase",
    "3.2.1.38\tbeta-D-fucosidase",
    "3.2.1.39\tglucan endo-1,3-beta-D-glucosidase",
    "3.2.1.40\talpha-L-rhamnosidase",
    "3.2.1.41\tpullulanase",
    "3.2.1.42\tGDP-glucosidase",
    "3.2.1.43\tbeta-L-rhamnosidase",
    "3.2.1.45\tglucosylceramidase",
    "3.2.1.46\tgalactosylceramidase",
    "3.2.1.47\tgalactosylgalactosylglucosylceramidase",
    "3.2.1.48\tsucrose alpha-glucosidase",
    "3.2.1.49\talpha-N-acetylgalactosaminidase",
    "3.2.1.50\talpha-N-acetylglucosaminidase",
    "3.2.1.51\talpha-L-fucosidase",
    "3.2.1.52\tbeta-N-acetylhexosaminidase",
    "3.2.1.53\tbeta-N-acetylgalactosaminidase",
    "3.2.1.54\tcyclomaltodextrinase",
    "3.2.1.55\tnon-reducing end alpha-L-arabinofuranosidase",
    "3.2.1.56\tglucuronosyl-disulfoglucosamine glucuronidase",
    "3.2.1.57\tisopullulanase",
    "3.2.1.58\tglucan 1,3-beta-glucosidase",
    "3.2.1.59\tglucan endo-1,3-alpha-glucosidase",
    "3.2.1.60\tglucan 1,4-alpha-maltotetraohydrolase",
    "3.2.1.61\tmycodextranase",
    "3.2.1.62\tglycosylceramidase",
    "3.2.1.63\t1,2-alpha-L-fucosidase",
    "3.2.1.64\t2,6-beta-fructan 6-levanbiohydrolase",
    "3.2.1.65\tlevanase",
    "3.2.1.67\tgalacturonan 1,4-alpha-galacturonidase",
    "3.2.1.68\tisoamylase",
    "3.2.1.70\tglucan 1,6-alpha-glucosidase",
    "3.2.1.71\tglucan endo-1,2-beta-glucosidase",
    "3.2.1.72\txylan 1,3-beta-xylosidase",
    "3.2.1.73\tlicheninase",
    "3.2.1.74\tglucan 1,4-beta-glucosidase",
    "3.2.1.75\tglucan endo-1,6-beta-glucosidase",
    "3.2.1.76\tL-iduronidase",
    "3.2.1.77\tmannan 1,2-(1,3)-alpha-mannosidase",
    "3.2.1.78\tmannan endo-1,4-beta-mannosidase",
    "3.2.1.80\tfructan beta-fructosidase",
    "3.2.1.81\tbeta-agarase",
    "3.2.1.82\texo-poly-alpha-digalacturonosidase",
    "3.2.1.83\tkappa-carrageenase",
    "3.2.1.84\tglucan 1,3-alpha-glucosidase",
    "3.2.1.85\t6-phospho-beta-galactosidase",
    "3.2.1.86\t6-phospho-beta-glucosidase",
    "3.2.1.87\tcapsular-polysaccharide endo-1,3-alpha-galactosidase",
    "3.2.1.88\tnon-reducing end beta-L-arabinopyranosidase",
    "3.2.1.89\tarabinogalactan endo-beta-1,4-galactanase",
    "3.2.1.91\tcellulose 1,4-beta-cellobiosidase (non-reducing end)",
    "3.2.1.92\tpeptidoglycan beta-N-acetylmuramidase",
    "3.2.1.93\talpha,alpha-phosphotrehalase",
    "3.2.1.94\tglucan 1,6-alpha-isomaltosidase",
    "3.2.1.95\tdextran 1,6-alpha-isomaltotriosidase",
    "3.2.1.96\tmannosyl-glycoprotein endo-beta-N-acetylglucosaminidase",
    "3.2.1.97\tendo-alpha-N-acetylgalactosaminidase",
    "3.2.1.98\tglucan 1,4-alpha-maltohexaosidase",
    "3.2.1.99\tarabinan endo-1,5-alpha-L-arabinosidase",
    "3.2.1.100\tmannan 1,4-mannobiosidase",
    "3.2.1.101\tmannan endo-1,6-alpha-mannosidase",
    "3.2.1.102\tblood-group-substance endo-1,4-beta-galactosidase",
    "3.2.1.103\tkeratan-sulfate endo-1,4-beta-galactosidase",
    "3.2.1.104\tsteryl-beta-glucosidase",
    "3.2.1.105\t3alpha(S)-strictosidine beta-glucosidase",
    "3.2.1.106\tmannosyl-oligosaccharide glucosidase",
    "3.2.1.107\tprotein-glucosylgalactosylhydroxylysine glucosidase",
    "3.2.1.108\tlactase",
    "3.2.1.109\tendogalactosaminidase",
    "3.2.1.111\t1,3-alpha-L-fucosidase",
    "3.2.1.112\t2-deoxyglucosidase",
    "3.2.1.113\tmannosyl-oligosaccharide 1,2-alpha-mannosidase",
    "3.2.1.114\tmannosyl-oligosaccharide 1,3-1,6-alpha-mannosidase",
    "3.2.1.115\tbranched-dextran exo-1,2-alpha-glucosidase",
    "3.2.1.116\tglucan 1,4-alpha-maltotriohydrolase",
    "3.2.1.117\tamygdalin beta-glucosidase",
    "3.2.1.118\tprunasin beta-glucosidase",
    "3.2.1.119\tvicianin beta-glucosidase",
    "3.2.1.120\toligoxyloglucan beta-glycosidase",
    "3.2.1.121\tpolymannuronate hydrolase",
    "3.2.1.122\tmaltose-6'-phosphate glucosidase",
    "3.2.1.123\tendoglycosylceramidase",
    "3.2.1.124\t3-deoxy-2-octulosonidase",
    "3.2.1.125\traucaffricine beta-glucosidase",
    "3.2.1.126\tconiferin beta-glucosidase",
    "3.2.1.127\t1,6-alpha-L-fucosidase",
    "3.2.1.128\tglycyrrhizinate beta-glucuronidase",
    "3.2.1.129\tendo-alpha-sialidase",
    "3.2.1.130\tglycoprotein endo-alpha-1,2-mannosidase",
    "3.2.1.131\txylan alpha-1,2-glucuronosidase",
    "3.2.1.132\tchitosanase",
    "3.2.1.133\tglucan 1,4-alpha-maltohydrolase",
    "3.2.1.134\tdifructose-anhydride-I synthase",
    "3.2.1.135\tneopullulanase",
    "3.2.1.136\tglucuronoarabinoxylan endo-1,4-beta-xylanase",
    "3.2.1.137\tmannan exo-1,2-1,6-alpha-mannosidase",
    "3.2.1.139\talpha-glucuronidase",
    "3.2.1.140\tlacto-N-biosidase",
    "3.2.1.141\t4-alpha-D-{(1->4)-alpha-D-glucano}trehalose trehalohydrolase",
    "3.2.1.142\tlimit dextrinase",
    "3.2.1.143\tpoly(ADP-ribose) glycohydrolase",
    "3.2.1.144\t3-deoxyoctulosonase",
    "3.2.1.145\tgalactan 1,3-beta-galactosidase",
    "3.2.1.146\tbeta-galactofuranosidase",
    "3.2.1.147\tthioglucosidase",
    "3.2.1.149\tbeta-primeverosidase",
    "3.2.1.150\toligoxyloglucan reducing-end-specific cellobiohydrolase",
    "3.2.1.151\txyloglucan-specific endo-beta-1,4-glucanase",
    "3.2.1.152\tmannosylglycoprotein endo-beta-mannosidase",
    "3.2.1.153\tfructan beta-(2,1)-fructosidase",
    "3.2.1.154\tfructan beta-(2,6)-fructosidase",
    "3.2.1.155\txyloglucan-specific endo-processive beta-1,4-glucanase",
    "3.2.1.156\toligosaccharide reducing-end xylanase",
    "3.2.1.157\tiota-carrageenase",
    "3.2.1.158\talpha-agarase",
    "3.2.1.159\talpha-neoagaro-oligosaccharide hydrolase",
    "3.2.1.161\tbeta-apiosyl-beta-glucosidase",
    "3.2.1.162\tlambda-carrageenase",
    "3.2.1.163\t1,6-alpha-D-mannosidase",
    "3.2.1.164\tgalactan endo-1,6-beta-galactosidase",
    "3.2.1.165\texo-1,4-beta-D-glucosaminidase",
    "3.2.1.166\theparanase",
    "3.2.1.167\tbaicalin-beta-D-glucuronidase",
    "3.2.1.168\thesperidin 6-O-alpha-L-rhamnosyl-beta-D-glucosidase",
    "3.2.1.169\tprotein O-GlcNAcase",
    "3.2.1.170\tmannosylglycerate hydrolase",
    "3.2.1.171\trhamnogalacturonan hydrolase",
    "3.2.1.172\tunsaturated rhamnogalacturonyl hydrolase",
    "3.2.1.173\trhamnogalacturonan galacturonohydrolase",
    "3.2.1.174\trhamnogalacturonan rhamnohydrolase",
    "3.2.1.175\tbeta-D-glucopyranosyl abscisate beta-glucosidase",
    "3.2.1.176\tcellulose 1,4-beta-cellobiosidase (reducing end)",
    "3.2.1.177\talpha-D-xyloside xylohydrolase",
    "3.2.1.178\tbeta-porphyranase",
    "3.2.1.179\tgellan tetrasaccharide unsaturated glucuronosyl hydrolase",
    "3.2.1.180\tunsaturated chondroitin disaccharide hydrolase",
    "3.2.1.181\tgalactan endo-beta-1,3-galactanase",
    "3.2.1.182\t4-hydroxy-7-methoxy-3-oxo-3,4-dihydro-2H-1,4-benzoxazin-2-yl glucoside beta-D-glucosidase",
    "3.2.1.183\tUDP-N-acetylglucosamine 2-epimerase (hydrolyzing)",
    "3.2.1.184\tUDP-N,N'-diacetylbacillosamine 2-epimerase (hydrolyzing)",
    "3.2.1.185\tnon-reducing end beta-L-arabinofuranosidase",
    "3.2.1.186\tprotodioscin 26-O-beta-D-glucosidase",
    "3.2.1.187\t(Ara-f)3-Hyp beta-L-arabinobiosidase",
    "3.2.1.188\tavenacosidase",
    "3.2.1.189\tdioscin glycosidase (diosgenin-forming)",
    "3.2.1.190\tdioscin glycosidase (3-O-beta-D-Glc-diosgenin-forming)",
    "3.2.1.191\tginsenosidase type III",
    "3.2.1.192\tginsenoside Rb1 beta-glucosidase",
    "3.2.1.193\tginsenosidase type I",
    "3.2.1.194\tginsenosidase type IV",
    "3.2.1.195\t20-O-multi-glycoside ginsenosidase",
    "3.2.1.196\tlimit dextrin alpha-1,6-maltotetraose-hydrolase",
    "3.2.1.197\tbeta-1,2-mannosidase",
    "3.2.1.198\talpha-mannan endo-1,2-alpha-mannanase",
    "3.2.1.199\tsulfoquinovosidase",
    "3.2.1.200\texo-chitinase (non-reducing end)",
    "3.2.1.201\texo-chitinase (reducing end)",
    "3.2.1.202\tendo-chitodextinase",
    "3.2.1.203\tcarboxymethylcellulase",
    "3.2.1.204\t1,3-alpha-isomaltosidase",
    "3.2.1.205\tisomaltose glucohydrolase",
    "3.2.1.206\toleuropein beta-glucosidase",
    "3.2.1.207\tmannosyl-oligosaccharide alpha-1,3-glucosidase",
    "3.2.1.208\tglucosylglycerate hydrolase",
    "3.2.1.209\tendoplasmic reticulum Man9GlcNAc2 1,2-alpha-mannosidase",
    "3.2.1.210\tendoplasmic reticulum Man8GlcNAc2 1,2-alpha-mannosidase",
    "3.2.1.211\tendo-(1->3)-fucoidanase",
    "3.2.1.212\tendo-(1->4)-fucoidanase",
    "3.2.1.213\tgalactan exo-1,6-beta-galactobiohydrolase (non-reducing end)",
    "3.2.1.214\texo beta-1,2-glucooligosaccharide sophorohydrolase (non-reducing end)",
    "3.2.1.n1\tblood group B branched chain alpha-1,3-galactosidase",
    "3.2.1.n2\tblood group B linear chain alpha-1,3-galactosidase",
    "3.2.1.n3\tDictyostelium lysozyme A",
    "3.2.2.1\tpurine nucleosidase",
    "3.2.2.2\tinosine nucleosidase",
    "3.2.2.3\turidine nucleosidase",
    "3.2.2.4\tAMP nucleosidase",
    "3.2.2.5\tNAD(+) glycohydrolase",
    "3.2.2.6\tADP-ribosyl cyclase/cyclic ADP-ribose hydrolase",
    "3.2.2.7\tadenosine nucleosidase",
    "3.2.2.8\tribosylpyrimidine nucleosidase",
    "3.2.2.9\tadenosylhomocysteine nucleosidase",
    "3.2.2.10\tpyrimidine-5'-nucleotide nucleosidase",
    "3.2.2.11\tbeta-aspartyl-N-acetylglucosaminidase",
    "3.2.2.12\tinosinate nucleosidase",
    "3.2.2.13\t1-methyladenosine nucleosidase",
    "3.2.2.14\tNMN nucleosidase",
    "3.2.2.15\tDNA-deoxyinosine glycosylase",
    "3.2.2.16\tmethylthioadenosine nucleosidase",
    "3.2.2.17\tdeoxyribodipyrimidine endonucleosidase",
    "3.2.2.19\t[protein ADP-ribosylarginine] hydrolase",
    "3.2.2.20\tDNA-3-methyladenine glycosylase I",
    "3.2.2.21\tDNA-3-methyladenine glycosylase II",
    "3.2.2.22\trRNA N-glycosylase",
    "3.2.2.23\tDNA-formamidopyrimidine glycosylase",
    "3.2.2.24\tADP-ribosyl-[dinitrogen reductase] hydrolase",
    "3.2.2.25\tN-methyl nucleosidase",
    "3.2.2.26\tfutalosine hydrolase",
    "3.2.2.27\turacil-DNA glycosylase",
    "3.2.2.28\tdouble-stranded uracil-DNA glycosylase",
    "3.2.2.29\tthymine-DNA glycosylase",
    "3.2.2.30\taminodeoxyfutalosine nucleosidase",
    "3.2.2.31\tadenine glycosylase",
    "3.2.2.n1\tcytokinin riboside 5'-monophosphate phosphoribohydrolase",
    "3.3.1.1\tadenosylhomocysteinase",
    "3.3.1.2\tS-adenosyl-L-methionine hydrolase (L-homoserine-forming)",
    "3.3.2.1\tisochorismatase",
    "3.3.2.2\tlysoplasmalogenase",
    "3.3.2.4\ttrans-epoxysuccinate hydrolase",
    "3.3.2.6\tleukotriene-A4 hydrolase",
    "3.3.2.7\thepoxilin-epoxide hydrolase",
    "3.3.2.8\tlimonene-1,2-epoxide hydrolase",
    "3.3.2.9\tmicrosomal epoxide hydrolase",
    "3.3.2.10\tsoluble epoxide hydrolase",
    "3.3.2.11\tcholesterol-5,6-oxide hydrolase",
    "3.3.2.12\toxepin-CoA hydrolase",
    "3.3.2.13\tchorismatase",
    "3.3.2.14\t2,4-dinitroanisole O-demethylase",
    "3.3.2.15\ttrans-2,3-dihydro-3-hydroxyanthranilic acid synthase",
    "3.4.11.1\tleucyl aminopeptidase",
    "3.4.11.2\tmembrane alanyl aminopeptidase",
    "3.4.11.3\tcystinyl aminopeptidase",
    "3.4.11.4\ttripeptide aminopeptidase",
    "3.4.11.5\tprolyl aminopeptidase",
    "3.4.11.6\taminopeptidase B",
    "3.4.11.7\tglutamyl aminopeptidase",
    "3.4.11.9\tXaa-Pro aminopeptidase",
    "3.4.11.10\tbacterial leucyl aminopeptidase",
    "3.4.11.13\tclostridial aminopeptidase",
    "3.4.11.14\tcytosol alanyl aminopeptidase",
    "3.4.11.15\taminopeptidase Y",
    "3.4.11.16\tXaa-Trp aminopeptidase",
    "3.4.11.17\ttryptophanyl aminopeptidase",
    "3.4.11.18\tmethionyl aminopeptidase",
    "3.4.11.19\tD-stereospecific aminopeptidase",
    "3.4.11.20\taminopeptidase Ey",
    "3.4.11.21\taspartyl aminopeptidase",
    "3.4.11.22\taminopeptidase I",
    "3.4.11.23\tPepB aminopeptidase",
    "3.4.11.24\taminopeptidase S",
    "3.4.11.25\tbeta-peptidyl aminopeptidase",
    "3.4.11.26\tintermediate cleaving peptidase 55",
    "3.4.13.4\tXaa-Arg dipeptidase",
    "3.4.13.5\tXaa-methyl-His dipeptidase",
    "3.4.13.7\tGlu-Glu dipeptidase",
    "3.4.13.9\tXaa-Pro dipeptidase",
    "3.4.13.12\tMet-Xaa dipeptidase",
    "3.4.13.17\tnon-stereospecific dipeptidase",
    "3.4.13.18\tcytosol non-specific dipeptidase",
    "3.4.13.19\tmembrane dipeptidase",
    "3.4.13.20\tbeta-Ala-His dipeptidase",
    "3.4.13.21\tdipeptidase E",
    "3.4.13.22\tD-Ala-D-Ala dipeptidase",
    "3.4.13.23\tcysteinylglycine-S-conjugate dipeptidase",
    "3.4.14.1\tdipeptidyl-peptidase I",
    "3.4.14.2\tdipeptidyl-peptidase II",
    "3.4.14.4\tdipeptidyl-peptidase III",
    "3.4.14.5\tdipeptidyl-peptidase IV",
    "3.4.14.6\tdipeptidyl-dipeptidase",
    "3.4.14.9\ttripeptidyl-peptidase I",
    "3.4.14.10\ttripeptidyl-peptidase II",
    "3.4.14.11\tXaa-Pro dipeptidyl-peptidase",
    "3.4.14.12\tXaa-Xaa-Pro tripeptidyl-peptidase",
    "3.4.14.13\tgamma-D-glutamyl-L-lysine dipeptidyl-peptidase",
    "3.4.14.14\t[mycofactocin precursor peptide] peptidase",
    "3.4.15.1\tpeptidyl-dipeptidase A",
    "3.4.15.4\tpeptidyl-dipeptidase B",
    "3.4.15.5\tpeptidyl-dipeptidase Dcp",
    "3.4.15.6\tcyanophycinase",
    "3.4.16.2\tlysosomal Pro-Xaa carboxypeptidase",
    "3.4.16.4\tserine-type D-Ala-D-Ala carboxypeptidase",
    "3.4.16.5\tcarboxypeptidase C",
    "3.4.16.6\tcarboxypeptidase D",
    "3.4.17.1\tcarboxypeptidase A",
    "3.4.17.2\tcarboxypeptidase B",
    "3.4.17.3\tlysine carboxypeptidase",
    "3.4.17.4\tGly-Xaa carboxypeptidase",
    "3.4.17.6\talanine carboxypeptidase",
    "3.4.17.8\tmuramoylpentapeptide carboxypeptidase",
    "3.4.17.10\tcarboxypeptidase E",
    "3.4.17.11\tglutamate carboxypeptidase",
    "3.4.17.12\tcarboxypeptidase M",
    "3.4.17.13\tmuramoyltetrapeptide carboxypeptidase",
    "3.4.17.14\tzinc D-Ala-D-Ala carboxypeptidase",
    "3.4.17.15\tcarboxypeptidase A2",
    "3.4.17.16\tmembrane Pro-Xaa carboxypeptidase",
    "3.4.17.17\ttubulinyl-Tyr carboxypeptidase",
    "3.4.17.18\tcarboxypeptidase T",
    "3.4.17.19\tcarboxypeptidase Taq",
    "3.4.17.20\tcarboxypeptidase U",
    "3.4.17.21\tglutamate carboxypeptidase II",
    "3.4.17.22\tmetallocarboxypeptidase D",
    "3.4.17.23\tangiotensin-converting enzyme 2",
    "3.4.17.24\ttubulin-glutamate carboxypeptidase",
    "3.4.18.1\tcathepsin X",
    "3.4.19.1\tacylaminoacyl-peptidase",
    "3.4.19.2\tpeptidyl-glycinamidase",
    "3.4.19.3\tpyroglutamyl-peptidase I",
    "3.4.19.5\tbeta-aspartyl-peptidase",
    "3.4.19.6\tpyroglutamyl-peptidase II",
    "3.4.19.7\tN-formylmethionyl-peptidase",
    "3.4.19.9\tfolate gamma-glutamyl hydrolase",
    "3.4.19.11\tgamma-D-glutamyl-meso-diaminopimelate peptidase",
    "3.4.19.12\tubiquitinyl hydrolase 1",
    "3.4.19.13\tglutathione gamma-glutamate hydrolase",
    "3.4.19.14\tleukotriene-C4 hydrolase",
    "3.4.19.15\tdesampylase",
    "3.4.19.16\tglucosinolate gamma-glutamyl hydrolase",
    "3.4.21.1\tchymotrypsin",
    "3.4.21.2\tchymotrypsin C",
    "3.4.21.3\tmetridin",
    "3.4.21.4\ttrypsin",
    "3.4.21.5\tthrombin",
    "3.4.21.6\tcoagulation factor Xa",
    "3.4.21.7\tplasmin",
    "3.4.21.9\tenteropeptidase",
    "3.4.21.10\tacrosin",
    "3.4.21.12\talpha-lytic endopeptidase",
    "3.4.21.19\tglutamyl endopeptidase",
    "3.4.21.20\tcathepsin G",
    "3.4.21.21\tcoagulation factor VIIa",
    "3.4.21.22\tcoagulation factor IXa",
    "3.4.21.25\tcucumisin",
    "3.4.21.26\tprolyl oligopeptidase",
    "3.4.21.27\tcoagulation factor XIa",
    "3.4.21.32\tbrachyurin",
    "3.4.21.34\tplasma kallikrein",
    "3.4.21.35\ttissue kallikrein",
    "3.4.21.36\tpancreatic elastase",
    "3.4.21.37\tleukocyte elastase",
    "3.4.21.38\tcoagulation factor XIIa",
    "3.4.21.39\tchymase",
    "3.4.21.41\tcomplement subcomponent C1r",
    "3.4.21.42\tcomplement subcomponent C1s",
    "3.4.21.43\tclassical-complement-pathway C3/C5 convertase",
    "3.4.21.45\tcomplement factor I",
    "3.4.21.46\tcomplement factor D",
    "3.4.21.47\talternative-complement-pathway C3/C5 convertase",
    "3.4.21.48\tcerevisin",
    "3.4.21.49\thypodermin C",
    "3.4.21.50\tlysyl endopeptidase",
    "3.4.21.53\tendopeptidase La",
    "3.4.21.54\tgamma-renin",
    "3.4.21.55\tvenombin AB",
    "3.4.21.57\tleucyl endopeptidase",
    "3.4.21.59\ttryptase",
    "3.4.21.60\tscutelarin",
    "3.4.21.61\tkexin",
    "3.4.21.62\tsubtilisin",
    "3.4.21.63\toryzin",
    "3.4.21.64\tpeptidase K",
    "3.4.21.65\tthermomycolin",
    "3.4.21.66\tthermitase",
    "3.4.21.67\tendopeptidase So",
    "3.4.21.68\tt-plasminogen activator",
    "3.4.21.69\tprotein C (activated)",
    "3.4.21.70\tpancreatic endopeptidase E",
    "3.4.21.71\tpancreatic elastase II",
    "3.4.21.72\tIgA-specific serine endopeptidase",
    "3.4.21.73\tu-plasminogen activator",
    "3.4.21.74\tvenombin A",
    "3.4.21.75\tfurin",
    "3.4.21.76\tmyeloblastin",
    "3.4.21.77\tsemenogelase",
    "3.4.21.78\tgranzyme A",
    "3.4.21.79\tgranzyme B",
    "3.4.21.80\tstreptogrisin A",
    "3.4.21.81\tstreptogrisin B",
    "3.4.21.82\tglutamyl endopeptidase II",
    "3.4.21.83\toligopeptidase B",
    "3.4.21.84\tlimulus clotting factor C",
    "3.4.21.85\tlimulus clotting factor B",
    "3.4.21.86\tlimulus clotting enzyme",
    "3.4.21.88\trepressor LexA",
    "3.4.21.89\tsignal peptidase I",
    "3.4.21.90\ttogavirin",
    "3.4.21.91\tflavivirin",
    "3.4.21.92\tendopeptidase Clp",
    "3.4.21.93\tproprotein convertase 1",
    "3.4.21.94\tproprotein convertase 2",
    "3.4.21.95\tsnake venom factor V activator",
    "3.4.21.96\tlactocepin",
    "3.4.21.97\tassemblin",
    "3.4.21.98\thepacivirin",
    "3.4.21.99\tspermosin",
    "3.4.21.100\tsedolisin",
    "3.4.21.101\txanthomonalisin",
    "3.4.21.102\tC-terminal processing peptidase",
    "3.4.21.103\tphysarolisin",
    "3.4.21.104\tmannan-binding lectin-associated serine protease-2",
    "3.4.21.105\trhomboid protease",
    "3.4.21.106\thepsin",
    "3.4.21.107\tpeptidase Do",
    "3.4.21.108\tHtrA2 peptidase",
    "3.4.21.109\tmatriptase",
    "3.4.21.110\tC5a peptidase",
    "3.4.21.111\taqualysin 1",
    "3.4.21.112\tsite-1 protease",
    "3.4.21.113\tpestivirus NS3 polyprotein peptidase",
    "3.4.21.114\tequine arterivirus serine peptidase",
    "3.4.21.115\tinfectious pancreatic necrosis birnavirus Vp4 peptidase",
    "3.4.21.116\tSpoIVB peptidase",
    "3.4.21.117\tstratum corneum chymotryptic enzyme",
    "3.4.21.118\tkallikrein 8",
    "3.4.21.119\tkallikrein 13",
    "3.4.21.120\toviductin",
    "3.4.21.121\tLys-Lys/Arg-Xaa endopeptidase",
    "3.4.22.1\tcathepsin B",
    "3.4.22.2\tpapain",
    "3.4.22.3\tficain",
    "3.4.22.6\tchymopapain",
    "3.4.22.7\tasclepain",
    "3.4.22.8\tclostripain",
    "3.4.22.10\tstreptopain",
    "3.4.22.14\tactinidain",
    "3.4.22.15\tcathepsin L",
    "3.4.22.16\tcathepsin H",
    "3.4.22.24\tcathepsin T",
    "3.4.22.25\tglycyl endopeptidase",
    "3.4.22.26\tcancer procoagulant",
    "3.4.22.27\tcathepsin S",
    "3.4.22.28\tpicornain 3C",
    "3.4.22.29\tpicornain 2A",
    "3.4.22.30\tcaricain",
    "3.4.22.31\tananain",
    "3.4.22.32\tstem bromelain",
    "3.4.22.33\tfruit bromelain",
    "3.4.22.34\tlegumain",
    "3.4.22.35\thistolysain",
    "3.4.22.36\tcaspase-1",
    "3.4.22.37\tgingipain R",
    "3.4.22.38\tcathepsin K",
    "3.4.22.39\tadenain",
    "3.4.22.40\tbleomycin hydrolase",
    "3.4.22.41\tcathepsin F",
    "3.4.22.42\tcathepsin O",
    "3.4.22.43\tcathepsin V",
    "3.4.22.44\tnuclear-inclusion-a endopeptidase",
    "3.4.22.45\thelper-component proteinase",
    "3.4.22.46\tL-peptidase",
    "3.4.22.47\tgingipain K",
    "3.4.22.48\tstaphopain",
    "3.4.22.49\tseparase",
    "3.4.22.50\tV-cath endopeptidase",
    "3.4.22.51\tcruzipain",
    "3.4.22.52\tcalpain-1",
    "3.4.22.53\tcalpain-2",
    "3.4.22.54\tcalpain-3",
    "3.4.22.55\tcaspase-2",
    "3.4.22.56\tcaspase-3",
    "3.4.22.57\tcaspase-4",
    "3.4.22.58\tcaspase-5",
    "3.4.22.59\tcaspase-6",
    "3.4.22.60\tcaspase-7",
    "3.4.22.61\tcaspase-8",
    "3.4.22.62\tcaspase-9",
    "3.4.22.63\tcaspase-10",
    "3.4.22.64\tcaspase-11",
    "3.4.22.65\tpeptidase 1 (mite)",
    "3.4.22.66\tcalicivirin",
    "3.4.22.67\tzingipain",
    "3.4.22.68\tUlp1 peptidase",
    "3.4.22.69\tSARS coronavirus main proteinase",
    "3.4.22.70\tsortase A",
    "3.4.22.71\tsortase B",
    "3.4.23.1\tpepsin A",
    "3.4.23.2\tpepsin B",
    "3.4.23.3\tgastricsin",
    "3.4.23.4\tchymosin",
    "3.4.23.5\tcathepsin D",
    "3.4.23.12\tnepenthesin",
    "3.4.23.15\trenin",
    "3.4.23.16\tHIV-1 retropepsin",
    "3.4.23.17\tpro-opiomelanocortin converting enzyme",
    "3.4.23.18\taspergillopepsin I",
    "3.4.23.19\taspergillopepsin II",
    "3.4.23.20\tpenicillopepsin",
    "3.4.23.21\trhizopuspepsin",
    "3.4.23.22\tendothiapepsin",
    "3.4.23.23\tmucorpepsin",
    "3.4.23.24\tcandidapepsin",
    "3.4.23.25\tsaccharopepsin",
    "3.4.23.26\trhodotorulapepsin",
    "3.4.23.28\tacrocylindropepsin",
    "3.4.23.29\tpolyporopepsin",
    "3.4.23.30\tpycnoporopepsin",
    "3.4.23.31\tscytalidopepsin A",
    "3.4.23.32\tscytalidopepsin B",
    "3.4.23.34\tcathepsin E",
    "3.4.23.35\tbarrierpepsin",
    "3.4.23.36\tsignal peptidase II",
    "3.4.23.38\tplasmepsin I",
    "3.4.23.39\tplasmepsin II",
    "3.4.23.40\tphytepsin",
    "3.4.23.41\tyapsin 1",
    "3.4.23.42\tthermopsin",
    "3.4.23.43\tprepilin peptidase",
    "3.4.23.44\tnodavirus endopeptidase",
    "3.4.23.45\tmemapsin 1",
    "3.4.23.46\tmemapsin 2",
    "3.4.23.47\tHIV-2 retropepsin",
    "3.4.23.48\tplasminogen activator Pla",
    "3.4.23.49\tomptin",
    "3.4.23.50\thuman endogenous retrovirus K endopeptidase",
    "3.4.23.51\tHycI peptidase",
    "3.4.23.52\tpreflagellin peptidase",
    "3.4.24.1\tatrolysin A",
    "3.4.24.3\tmicrobial collagenase",
    "3.4.24.6\tleucolysin",
    "3.4.24.7\tinterstitial collagenase",
    "3.4.24.11\tneprilysin",
    "3.4.24.12\tenvelysin",
    "3.4.24.13\tIgA-specific metalloendopeptidase",
    "3.4.24.14\tprocollagen N-endopeptidase",
    "3.4.24.15\tthimet oligopeptidase",
    "3.4.24.16\tneurolysin",
    "3.4.24.17\tstromelysin 1",
    "3.4.24.18\tmeprin A",
    "3.4.24.19\tprocollagen C-endopeptidase",
    "3.4.24.20\tpeptidyl-Lys metalloendopeptidase",
    "3.4.24.21\tastacin",
    "3.4.24.22\tstromelysin 2",
    "3.4.24.23\tmatrilysin",
    "3.4.24.24\tgelatinase A",
    "3.4.24.25\tvibriolysin",
    "3.4.24.26\tpseudolysin",
    "3.4.24.27\tthermolysin",
    "3.4.24.28\tbacillolysin",
    "3.4.24.29\taureolysin",
    "3.4.24.30\tcoccolysin",
    "3.4.24.31\tmycolysin",
    "3.4.24.32\tbeta-lytic metalloendopeptidase",
    "3.4.24.33\tpeptidyl-Asp metalloendopeptidase",
    "3.4.24.34\tneutrophil collagenase",
    "3.4.24.35\tgelatinase B",
    "3.4.24.36\tleishmanolysin",
    "3.4.24.37\tsaccharolysin",
    "3.4.24.38\tgametolysin",
    "3.4.24.39\tdeuterolysin",
    "3.4.24.40\tserralysin",
    "3.4.24.41\tatrolysin B",
    "3.4.24.42\tatrolysin C",
    "3.4.24.43\tatroxase",
    "3.4.24.44\tatrolysin E",
    "3.4.24.45\tatrolysin F",
    "3.4.24.46\tadamalysin",
    "3.4.24.47\thorrilysin",
    "3.4.24.48\truberlysin",
    "3.4.24.49\tbothropasin",
    "3.4.24.50\tbothrolysin",
    "3.4.24.51\tophiolysin",
    "3.4.24.52\ttrimerelysin I",
    "3.4.24.53\ttrimerelysin II",
    "3.4.24.54\tmucrolysin",
    "3.4.24.55\tpitrilysin",
    "3.4.24.56\tinsulysin",
    "3.4.24.57\tO-sialoglycoprotein endopeptidase",
    "3.4.24.58\trussellysin",
    "3.4.24.59\tmitochondrial intermediate peptidase",
    "3.4.24.60\tdactylysin",
    "3.4.24.61\tnardilysin",
    "3.4.24.62\tmagnolysin",
    "3.4.24.63\tmeprin B",
    "3.4.24.64\tmitochondrial processing peptidase",
    "3.4.24.65\tmacrophage elastase",
    "3.4.24.66\tchoriolysin L",
    "3.4.24.67\tchoriolysin H",
    "3.4.24.68\ttentoxilysin",
    "3.4.24.69\tbontoxilysin",
    "3.4.24.70\toligopeptidase A",
    "3.4.24.71\tendothelin-converting enzyme 1",
    "3.4.24.72\tfibrolase",
    "3.4.24.73\tjararhagin",
    "3.4.24.74\tfragilysin",
    "3.4.24.75\tlysostaphin",
    "3.4.24.76\tflavastacin",
    "3.4.24.77\tsnapalysin",
    "3.4.24.78\tGPR endopeptidase",
    "3.4.24.79\tpappalysin-1",
    "3.4.24.80\tmembrane-type matrix metalloproteinase-1",
    "3.4.24.81\tADAM10 endopeptidase",
    "3.4.24.82\tADAMTS-4 endopeptidase",
    "3.4.24.83\tanthrax lethal factor endopeptidase",
    "3.4.24.84\tSte24 endopeptidase",
    "3.4.24.85\tS2P endopeptidase",
    "3.4.24.86\tADAM 17 endopeptidase",
    "3.4.24.87\tADAMTS13 endopeptidase",
    "3.4.24.89\tPro-Pro endopeptidase",
    "3.4.25.1\tproteasome endopeptidase complex",
    "3.4.25.2\tHslU--HslV peptidase",
    "3.5.1.1\tasparaginase",
    "3.5.1.2\tglutaminase",
    "3.5.1.3\tomega-amidase",
    "3.5.1.4\tamidase",
    "3.5.1.5\turease",
    "3.5.1.6\tbeta-ureidopropionase",
    "3.5.1.7\tureidosuccinase",
    "3.5.1.8\tformylaspartate deformylase",
    "3.5.1.9\tarylformamidase",
    "3.5.1.10\tformyltetrahydrofolate deformylase",
    "3.5.1.11\tpenicillin amidase",
    "3.5.1.12\tbiotinidase",
    "3.5.1.13\taryl-acylamidase",
    "3.5.1.14\tN-acyl-aliphatic-L-amino acid amidohydrolase",
    "3.5.1.15\taspartoacylase",
    "3.5.1.16\tacetylornithine deacetylase",
    "3.5.1.17\tacyl-lysine deacylase",
    "3.5.1.18\tsuccinyl-diaminopimelate desuccinylase",
    "3.5.1.19\tnicotinamidase",
    "3.5.1.20\tcitrullinase",
    "3.5.1.21\tN-acetyl-beta-alanine deacetylase",
    "3.5.1.22\tpantothenase",
    "3.5.1.23\tceramidase",
    "3.5.1.24\tcholoylglycine hydrolase",
    "3.5.1.25\tN-acetylglucosamine-6-phosphate deacetylase",
    "3.5.1.26\tN(4)-(beta-N-acetylglucosaminyl)-L-asparaginase",
    "3.5.1.28\tN-acetylmuramoyl-L-alanine amidase",
    "3.5.1.29\t2-(acetamidomethylene)succinate hydrolase",
    "3.5.1.30\t5-aminopentanamidase",
    "3.5.1.31\tformylmethionine deformylase",
    "3.5.1.32\thippurate hydrolase",
    "3.5.1.33\tN-acetylglucosamine deacetylase",
    "3.5.1.35\tD-glutaminase",
    "3.5.1.36\tN-methyl-2-oxoglutaramate hydrolase",
    "3.5.1.38\tglutamin-(asparagin-)ase",
    "3.5.1.39\talkylamidase",
    "3.5.1.40\tacylagmatine amidase",
    "3.5.1.41\tchitin deacetylase",
    "3.5.1.42\tnicotinamide-nucleotide amidase",
    "3.5.1.43\tpeptidyl-glutaminase",
    "3.5.1.44\tprotein-glutamine glutaminase",
    "3.5.1.46\t6-aminohexanoate-oligomer exohydrolase",
    "3.5.1.47\tN-acetyldiaminopimelate deacetylase",
    "3.5.1.48\tacetylspermidine deacetylase",
    "3.5.1.49\tformamidase",
    "3.5.1.50\tpentanamidase",
    "3.5.1.51\t4-acetamidobutyryl-CoA deacetylase",
    "3.5.1.52\tpeptide-N(4)-(N-acetyl-beta-glucosaminyl)asparagine amidase",
    "3.5.1.53\tN-carbamoylputrescine amidase",
    "3.5.1.54\tallophanate hydrolase",
    "3.5.1.55\tlong-chain-fatty-acyl-glutamate deacylase",
    "3.5.1.56\tN,N-dimethylformamidase",
    "3.5.1.57\ttryptophanamidase",
    "3.5.1.58\tN-benzyloxycarbonylglycine hydrolase",
    "3.5.1.59\tN-carbamoylsarcosine amidase",
    "3.5.1.60\tN-(long-chain-acyl)ethanolamine deacylase",
    "3.5.1.61\tmimosinase",
    "3.5.1.62\tacetylputrescine deacetylase",
    "3.5.1.63\t4-acetamidobutyrate deacetylase",
    "3.5.1.64\tN(alpha)-benzyloxycarbonylleucine hydrolase",
    "3.5.1.65\ttheanine hydrolase",
    "3.5.1.66\t2-(hydroxymethyl)-3-(acetamidomethylene)succinate hydrolase",
    "3.5.1.67\t4-methyleneglutaminase",
    "3.5.1.68\tN-formylglutamate deformylase",
    "3.5.1.69\tglycosphingolipid deacylase",
    "3.5.1.70\taculeacin-A deacylase",
    "3.5.1.71\tN-feruloylglycine deacylase",
    "3.5.1.72\tD-benzoylarginine-4-nitroanilide amidase",
    "3.5.1.73\tcarnitinamidase",
    "3.5.1.74\tchenodeoxycholoyltaurine hydrolase",
    "3.5.1.75\turethanase",
    "3.5.1.76\tarylalkyl acylamidase",
    "3.5.1.77\tN-carbamoyl-D-amino-acid hydrolase",
    "3.5.1.78\tglutathionylspermidine amidase",
    "3.5.1.79\tphthalyl amidase",
    "3.5.1.81\tN-acyl-D-amino-acid deacylase",
    "3.5.1.82\tN-acyl-D-glutamate deacylase",
    "3.5.1.83\tN-acyl-D-aspartate deacylase",
    "3.5.1.84\tbiuret amidohydrolase",
    "3.5.1.85\t(S)-N-acetyl-1-phenylethylamine hydrolase",
    "3.5.1.86\tmandelamide amidase",
    "3.5.1.87\tN-carbamoyl-L-amino-acid hydrolase",
    "3.5.1.88\tpeptide deformylase",
    "3.5.1.89\tN-acetylglucosaminylphosphatidylinositol deacetylase",
    "3.5.1.90\tadenosylcobinamide hydrolase",
    "3.5.1.91\tN-substituted formamide deformylase",
    "3.5.1.92\tpantetheine hydrolase",
    "3.5.1.93\tglutaryl-7-aminocephalosporanic-acid acylase",
    "3.5.1.94\tgamma-glutamyl-gamma-aminobutyrate hydrolase",
    "3.5.1.95\tN-malonylurea hydrolase",
    "3.5.1.96\tsuccinylglutamate desuccinylase",
    "3.5.1.97\tacyl-homoserine-lactone acylase",
    "3.5.1.98\thistone deacetylase",
    "3.5.1.99\tfatty acid amide hydrolase",
    "3.5.1.100\t(R)-amidase",
    "3.5.1.101\tL-proline amide hydrolase",
    "3.5.1.102\t2-amino-5-formylamino-6-ribosylaminopyrimidin-4(3H)-one 5'-monophosphate deformylase",
    "3.5.1.103\tN-acetyl-1-D-myo-inositol-2-amino-2-deoxy-alpha-D-glucopyranoside deacetylase",
    "3.5.1.104\tpeptidoglycan-N-acetylglucosamine deacetylase",
    "3.5.1.105\tchitin disaccharide deacetylase",
    "3.5.1.106\tN-formylmaleamate deformylase",
    "3.5.1.107\tmaleamate amidohydrolase",
    "3.5.1.108\tUDP-3-O-acyl-N-acetylglucosamine deacetylase",
    "3.5.1.109\tsphingomyelin deacylase",
    "3.5.1.110\tureidoacrylate amidohydrolase",
    "3.5.1.111\t2-oxoglutaramate amidase",
    "3.5.1.112\t2'-N-acetylparomamine deacetylase",
    "3.5.1.113\t2'''-acetyl-6'''-hydroxyneomycin C deacetylase",
    "3.5.1.114\tN-acyl-aromatic-L-amino acid amidohydrolase",
    "3.5.1.115\tmycothiol S-conjugate amidase",
    "3.5.1.116\tureidoglycolate amidohydrolase",
    "3.5.1.117\t6-aminohexanoate-oligomer endohydrolase",
    "3.5.1.118\tgamma-glutamyl hercynylcysteine S-oxide hydrolase",
    "3.5.1.119\tPup amidohydrolase",
    "3.5.1.121\tprotein N-terminal asparagine amidohydrolase",
    "3.5.1.122\tprotein N-terminal glutamine amidohydrolase",
    "3.5.1.123\tgamma-glutamylanilide hydrolase",
    "3.5.1.124\tprotein deglycase",
    "3.5.1.125\tN(2)-acetyl-L-2,4-diaminobutanoate deacetylase",
    "3.5.1.126\toxamate amidohydrolase",
    "3.5.1.127\tjasmonoyl-L-amino acid hydrolase",
    "3.5.1.128\tdeaminated glutathione amidase",
    "3.5.1.129\tN(5)-(cytidine 5'-diphosphoramidyl)-L-glutamine hydrolase",
    "3.5.1.130\t[amino group carrier protein]-lysine hydrolase",
    "3.5.1.131\t1-carboxybiuret hydrolase",
    "3.5.1.132\t[amino group carrier protein]-ornithine hydrolase",
    "3.5.1.133\tN(alpha)-acyl-L-glutamine aminoacylase",
    "3.5.1.134\t(indol-3-yl)acetyl-L-aspartate hydrolase",
    "3.5.1.135\tN(4)-acetylcytidine amidohydrolase",
    "3.5.1.136\tN,N'-diacetylchitobiose non-reducing end deacetylase",
    "3.5.1.n3\t4-deoxy-4-formamido-L-arabinose-phosphoundecaprenol deformylase",
    "3.5.2.1\tbarbiturase",
    "3.5.2.2\tdihydropyrimidinase",
    "3.5.2.3\tdihydroorotase",
    "3.5.2.4\tcarboxymethylhydantoinase",
    "3.5.2.5\tallantoinase",
    "3.5.2.6\tbeta-lactamase",
    "3.5.2.7\timidazolonepropionase",
    "3.5.2.9\t5-oxoprolinase (ATP-hydrolyzing)",
    "3.5.2.10\tcreatininase",
    "3.5.2.11\tL-lysine-lactamase",
    "3.5.2.12\t6-aminohexanoate-cyclic-dimer hydrolase",
    "3.5.2.13\t2,5-dioxopiperazine hydrolase",
    "3.5.2.14\tN-methylhydantoinase (ATP-hydrolyzing)",
    "3.5.2.15\tcyanuric acid amidohydrolase",
    "3.5.2.16\tmaleimide hydrolase",
    "3.5.2.17\thydroxyisourate hydrolase",
    "3.5.2.18\tenamidase",
    "3.5.2.19\tstreptothricin hydrolase",
    "3.5.2.20\tisatin hydrolase",
    "3.5.3.1\targinase",
    "3.5.3.2\tguanidinoacetase",
    "3.5.3.3\tcreatinase",
    "3.5.3.4\tallantoicase",
    "3.5.3.5\tformimidoylaspartate deiminase",
    "3.5.3.6\targinine deiminase",
    "3.5.3.7\tguanidinobutyrase",
    "3.5.3.8\tformimidoylglutamase",
    "3.5.3.9\tallantoate deiminase",
    "3.5.3.10\tD-arginase",
    "3.5.3.11\tagmatinase",
    "3.5.3.12\tagmatine deiminase",
    "3.5.3.13\tformimidoylglutamate deiminase",
    "3.5.3.14\tamidinoaspartase",
    "3.5.3.15\tprotein-arginine deiminase",
    "3.5.3.16\tmethylguanidinase",
    "3.5.3.17\tguanidinopropionase",
    "3.5.3.18\tdimethylargininase",
    "3.5.3.20\tdiguanidinobutanase",
    "3.5.3.21\tmethylenediurea deaminase",
    "3.5.3.22\tproclavaminate amidinohydrolase",
    "3.5.3.23\tN-succinylarginine dihydrolase",
    "3.5.3.24\tN(1)-aminopropylagmatine ureohydrolase",
    "3.5.3.25\tN(omega)-hydroxy-L-arginine amidinohydrolase",
    "3.5.3.26\t(S)-ureidoglycine aminohydrolase",
    "3.5.4.1\tcytosine deaminase",
    "3.5.4.2\tadenine deaminase",
    "3.5.4.3\tguanine deaminase",
    "3.5.4.4\tadenosine deaminase",
    "3.5.4.5\tcytidine deaminase",
    "3.5.4.6\tAMP deaminase",
    "3.5.4.7\tADP deaminase",
    "3.5.4.8\taminoimidazolase",
    "3.5.4.9\tmethenyltetrahydrofolate cyclohydrolase",
    "3.5.4.10\tIMP cyclohydrolase",
    "3.5.4.11\tpterin deaminase",
    "3.5.4.12\tdCMP deaminase",
    "3.5.4.13\tdCTP deaminase",
    "3.5.4.15\tguanosine deaminase",
    "3.5.4.16\tGTP cyclohydrolase I",
    "3.5.4.17\tadenosine-phosphate deaminase",
    "3.5.4.18\tATP deaminase",
    "3.5.4.19\tphosphoribosyl-AMP cyclohydrolase",
    "3.5.4.20\tpyrithiamine deaminase",
    "3.5.4.21\tcreatinine deaminase",
    "3.5.4.22\t1-pyrroline-4-hydroxy-2-carboxylate deaminase",
    "3.5.4.23\tblasticidin-S deaminase",
    "3.5.4.24\tsepiapterin deaminase",
    "3.5.4.25\tGTP cyclohydrolase II",
    "3.5.4.26\tdiaminohydroxyphosphoribosylaminopyrimidine deaminase",
    "3.5.4.27\tmethenyltetrahydromethanopterin cyclohydrolase",
    "3.5.4.28\tS-adenosylhomocysteine deaminase",
    "3.5.4.29\tGTP cyclohydrolase IIa",
    "3.5.4.30\tdCTP deaminase (dUMP-forming)",
    "3.5.4.31\tS-methyl-5'-thioadenosine deaminase",
    "3.5.4.32\t8-oxoguanine deaminase",
    "3.5.4.33\ttRNA(adenine(34)) deaminase",
    "3.5.4.34\ttRNA(Ala)(adenine(37)) deaminase",
    "3.5.4.35\ttRNA(cytosine(8)) deaminase",
    "3.5.4.36\tmRNA(cytosine(6666)) deaminase",
    "3.5.4.37\tdouble-stranded RNA adenine deaminase",
    "3.5.4.38\tsingle-stranded DNA cytosine deaminase",
    "3.5.4.39\tGTP cyclohydrolase IV",
    "3.5.4.40\taminodeoxyfutalosine deaminase",
    "3.5.4.41\t5'-deoxyadenosine deaminase",
    "3.5.4.42\tN-isopropylammelide isopropylaminohydrolase",
    "3.5.4.43\thydroxydechloroatrazine ethylaminohydrolase",
    "3.5.4.44\tectoine hydrolase",
    "3.5.4.45\tmelamine deaminase",
    "3.5.4.46\tcAMP deaminase",
    "3.5.5.1\tnitrilase",
    "3.5.5.2\tricinine nitrilase",
    "3.5.5.4\tcyanoalanine nitrilase",
    "3.5.5.5\tarylacetonitrilase",
    "3.5.5.6\tbromoxynil nitrilase",
    "3.5.5.7\taliphatic nitrilase",
    "3.5.5.8\tthiocyanate hydrolase",
    "3.5.99.1\triboflavinase",
    "3.5.99.2\taminopyrimidine aminohydrolase",
    "3.5.99.5\t2-aminomuconate deaminase",
    "3.5.99.6\tglucosamine-6-phosphate deaminase",
    "3.5.99.7\t1-aminocyclopropane-1-carboxylate deaminase",
    "3.5.99.8\t5-nitroanthranilic acid aminohydrolase",
    "3.5.99.9\t2-nitroimidazole nitrohydrolase",
    "3.5.99.10\t2-iminobutanoate/2-iminopropanoate deaminase",
    "3.5.99.11\t2-aminomuconate deaminase (2-hydroxymuconate-forming)",
    "3.6.1.1\tinorganic diphosphatase",
    "3.6.1.2\ttrimetaphosphatase",
    "3.6.1.5\tapyrase",
    "3.6.1.6\tnucleoside diphosphate phosphatase",
    "3.6.1.7\tacylphosphatase",
    "3.6.1.8\tATP diphosphatase",
    "3.6.1.9\tnucleotide diphosphatase",
    "3.6.1.10\tendopolyphosphatase",
    "3.6.1.11\texopolyphosphatase",
    "3.6.1.12\tdCTP diphosphatase",
    "3.6.1.13\tADP-ribose diphosphatase",
    "3.6.1.14\tadenosine-tetraphosphatase",
    "3.6.1.15\tnucleoside-triphosphate phosphatase",
    "3.6.1.16\tCDP-glycerol diphosphatase",
    "3.6.1.17\tbis(5'-nucleosyl)-tetraphosphatase (asymmetrical)",
    "3.6.1.18\tFAD diphosphatase",
    "3.6.1.20\t5'-acylphosphoadenosine hydrolase",
    "3.6.1.21\tADP-sugar diphosphatase",
    "3.6.1.22\tNAD(+) diphosphatase",
    "3.6.1.23\tdUTP diphosphatase",
    "3.6.1.24\tnucleoside phosphoacylhydrolase",
    "3.6.1.25\ttriphosphatase",
    "3.6.1.26\tCDP-diacylglycerol diphosphatase",
    "3.6.1.27\tundecaprenyl-diphosphate phosphatase",
    "3.6.1.28\tthiamine-triphosphatase",
    "3.6.1.29\tbis(5'-adenosyl)-triphosphatase",
    "3.6.1.31\tphosphoribosyl-ATP diphosphatase",
    "3.6.1.39\tthymidine-triphosphatase",
    "3.6.1.40\tguanosine-5'-triphosphate,3'-diphosphate diphosphatase",
    "3.6.1.41\tbis(5'-nucleosyl)-tetraphosphatase (symmetrical)",
    "3.6.1.42\tguanosine-diphosphatase",
    "3.6.1.43\tdolichyldiphosphatase",
    "3.6.1.44\toligosaccharide-diphosphodolichol diphosphatase",
    "3.6.1.45\tUDP-sugar diphosphatase",
    "3.6.1.52\tdiphosphoinositol-polyphosphate diphosphatase",
    "3.6.1.53\tMn(2+)-dependent ADP-ribose/CDP-alcohol diphosphatase",
    "3.6.1.54\tUDP-2,3-diacylglucosamine diphosphatase",
    "3.6.1.55\t8-oxo-dGTP diphosphatase",
    "3.6.1.56\t2-hydroxy-dATP diphosphatase",
    "3.6.1.57\tUDP-2,4-diacetamido-2,4,6-trideoxy-beta-L-altropyranose hydrolase",
    "3.6.1.58\t8-oxo-dGDP phosphatase",
    "3.6.1.59\t5'-(N(7)-methyl 5'-triphosphoguanosine)-[mRNA] diphosphatase",
    "3.6.1.60\tdiadenosine hexaphosphate hydrolase (AMP-forming)",
    "3.6.1.61\tdiadenosine hexaphosphate hydrolase (ATP-forming)",
    "3.6.1.62\t5'-(N(7)-methylguanosine 5'-triphospho)-[mRNA] hydrolase",
    "3.6.1.63\talpha-D-ribose 1-methylphosphonate 5-triphosphate diphosphatase",
    "3.6.1.64\tinosine diphosphate phosphatase",
    "3.6.1.65\t(d)CTP diphosphatase",
    "3.6.1.66\tXTP/dITP diphosphatase",
    "3.6.1.67\tdihydroneopterin triphosphate diphosphatase",
    "3.6.1.68\tgeranyl diphosphate phosphohydrolase",
    "3.6.1.69\t8-oxo-(d)GTP phosphatase",
    "3.6.1.70\tguaosine-5'-diphospho-5'-[DNA] diphosphatase",
    "3.6.1.71\tadenosine-5'-diphospho-5'-[DNA] diphosphatase",
    "3.6.1.72\tDNA-3'-diphospho-5'-guanosine diphosphatase",
    "3.6.1.73\tinosine/xanthosine triphosphatase",
    "3.6.1.74\tmRNA 5'-phosphatase",
    "3.6.1.n2\tL-cysteinyl-tRNA(Pro)",
    "3.6.1.n3\tL-cysteinyl-tRNA(Cys) hydrolase",
    "3.6.2.1\tadenylylsulfatase",
    "3.6.2.2\tphosphoadenylylsulfatase",
    "3.6.4.6\tvesicle-fusing ATPase",
    "3.6.4.7\tperoxisome-assembly ATPase",
    "3.6.4.10\tnon-chaperonin molecular chaperone ATPase",
    "3.6.4.12\tDNA helicase",
    "3.6.4.13\tRNA helicase",
    "3.6.5.1\theterotrimeric G-protein GTPase",
    "3.6.5.2\tsmall monomeric GTPase",
    "3.6.5.3\tprotein-synthesizing GTPase",
    "3.6.5.4\tsignal-recognition-particle GTPase",
    "3.6.5.5\tdynamin GTPase",
    "3.6.5.6\ttubulin GTPase",
    "3.6.5.n1\telongation factor 4",
    "3.7.1.1\toxaloacetase",
    "3.7.1.2\tfumarylacetoacetase",
    "3.7.1.3\tkynureninase",
    "3.7.1.4\tphloretin hydrolase",
    "3.7.1.5\tacylpyruvate hydrolase",
    "3.7.1.6\tacetylpyruvate hydrolase",
    "3.7.1.7\tbeta-diketone hydrolase",
    "3.7.1.8\t2,6-dioxo-6-phenylhexa-3-enoate hydrolase",
    "3.7.1.9\t2-hydroxymuconate-6-semialdehyde hydrolase",
    "3.7.1.10\tcyclohexane-1,3-dione hydrolase",
    "3.7.1.11\tcyclohexane-1,2-dione hydrolase",
    "3.7.1.12\tcobalt-precorrin 5A hydrolase",
    "3.7.1.13\t2-hydroxy-6-oxo-6-(2-aminophenyl)hexa-2,4-dienoate hydrolase",
    "3.7.1.14\t2-hydroxy-6-oxonona-2,4-dienedioate hydrolase",
    "3.7.1.17\t4,5-9,10-diseco-3-hydroxy-5,9,17-trioxoandrosta-1(10),2-diene-4-oate hydrolase",
    "3.7.1.18\t6-oxocamphor hydrolase",
    "3.7.1.19\t2,6-dihydroxypseudooxynicotine hydrolase",
    "3.7.1.20\t3-fumarylpyruvate hydrolase",
    "3.7.1.21\t6-oxocyclohex-1-ene-1-carbonyl-CoA hydratase",
    "3.7.1.22\t3D-(3,5/4)-trihydroxycyclohexane-1,2-dione acylhydrolase (decyclizing)",
    "3.7.1.23\tmaleylpyruvate hydrolase",
    "3.7.1.24\t2,4-diacetylphloroglucinol hydrolase",
    "3.7.1.25\t2-hydroxy-6-oxohepta-2,4-dienoate hydrolase",
    "3.7.1.26\t2,4-didehydro-3-deoxy-L-rhamnonate hydrolase",
    "3.7.1.27\tneryl diphosphate diphosphatase",
    "3.7.1.28\t3-oxoisoapionate-4-phosphate transcarboxylase/hydrolase",
    "3.8.1.2\t(S)-2-haloacid dehalogenase",
    "3.8.1.3\thaloacetate dehalogenase",
    "3.8.1.5\thaloalkane dehalogenase",
    "3.8.1.6\t4-chlorobenzoate dehalogenase",
    "3.8.1.7\t4-chlorobenzoyl-CoA dehalogenase",
    "3.8.1.8\tatrazine chlorohydrolase",
    "3.8.1.9\t(R)-2-haloacid dehalogenase",
    "3.8.1.10\t2-haloacid dehalogenase (configuration-inverting)",
    "3.8.1.11\t2-haloacid dehalogenase (configuration-retaining)",
    "3.9.1.1\tphosphoamidase",
    "3.9.1.2\tprotein arginine phosphatase",
    "3.9.1.3\tphosphohistidine phosphatase",
    "3.10.1.1\tN-sulfoglucosamine sulfohydrolase",
    "3.10.1.2\tcyclamate sulfohydrolase",
    "3.11.1.1\tphosphonoacetaldehyde hydrolase",
    "3.11.1.2\tphosphonoacetate hydrolase",
    "3.11.1.3\tphosphonopyruvate hydrolase",
    "3.12.1.1\ttrithionate hydrolase",
    "3.13.1.1\tUDP-sulfoquinovose synthase",
    "3.13.1.3\t2'-hydroxybiphenyl-2-sulfinate desulfinase",
    "3.13.1.4\t3-sulfinopropanoyl-CoA desulfinase",
    "3.13.1.5\tcarbon disulfide hydrolase",
    "3.13.1.6\t[CysO sulfur-carrier protein]-S-L-cysteine hydrolase",
    "3.13.1.7\tcarbonyl sulfide hydrolase",
    "3.13.1.8\tS-adenosyl-L-methionine hydrolase (adenosine-forming)",
    "3.13.1.9\tS-inosyl-L-homocysteine hydrolase",
    "4.1.1.1\tpyruvate decarboxylase",
    "4.1.1.2\toxalate decarboxylase",
    "4.1.1.4\tacetoacetate decarboxylase",
    "4.1.1.5\tacetolactate decarboxylase",
    "4.1.1.6\tcis-aconitate decarboxylase",
    "4.1.1.7\tbenzoylformate decarboxylase",
    "4.1.1.8\toxalyl-CoA decarboxylase",
    "4.1.1.9\tmalonyl-CoA decarboxylase",
    "4.1.1.11\taspartate 1-decarboxylase",
    "4.1.1.12\taspartate 4-decarboxylase",
    "4.1.1.14\tvaline decarboxylase",
    "4.1.1.15\tglutamate decarboxylase",
    "4.1.1.16\thydroxyglutamate decarboxylase",
    "4.1.1.17\tornithine decarboxylase",
    "4.1.1.18\tlysine decarboxylase",
    "4.1.1.19\targinine decarboxylase",
    "4.1.1.20\tdiaminopimelate decarboxylase",
    "4.1.1.21\tphosphoribosylaminoimidazole carboxylase",
    "4.1.1.22\thistidine decarboxylase",
    "4.1.1.23\torotidine-5'-phosphate decarboxylase",
    "4.1.1.24\taminobenzoate decarboxylase",
    "4.1.1.25\ttyrosine decarboxylase",
    "4.1.1.28\taromatic-L-amino-acid decarboxylase",
    "4.1.1.29\tsulfinoalanine decarboxylase",
    "4.1.1.30\tpantothenoylcysteine decarboxylase",
    "4.1.1.31\tphosphoenolpyruvate carboxylase",
    "4.1.1.32\tphosphoenolpyruvate carboxykinase (GTP)",
    "4.1.1.33\tdiphosphomevalonate decarboxylase",
    "4.1.1.34\tdehydro-L-gulonate decarboxylase",
    "4.1.1.35\tUDP-glucuronate decarboxylase",
    "4.1.1.36\tphosphopantothenoylcysteine decarboxylase",
    "4.1.1.37\turoporphyrinogen decarboxylase",
    "4.1.1.38\tphosphoenolpyruvate carboxykinase (diphosphate)",
    "4.1.1.39\tribulose-bisphosphate carboxylase",
    "4.1.1.40\thydroxypyruvate decarboxylase",
    "4.1.1.42\tcarnitine decarboxylase",
    "4.1.1.43\tphenylpyruvate decarboxylase",
    "4.1.1.44\t4-carboxymuconolactone decarboxylase",
    "4.1.1.45\taminocarboxymuconate-semialdehyde decarboxylase",
    "4.1.1.46\to-pyrocatechuate decarboxylase",
    "4.1.1.47\ttartronate-semialdehyde synthase",
    "4.1.1.48\tindole-3-glycerol-phosphate synthase",
    "4.1.1.49\tphosphoenolpyruvate carboxykinase (ATP)",
    "4.1.1.50\tadenosylmethionine decarboxylase",
    "4.1.1.51\t3-hydroxy-2-methylpyridine-4,5-dicarboxylate 4-decarboxylase",
    "4.1.1.52\t6-methylsalicylate decarboxylase",
    "4.1.1.53\tphenylalanine decarboxylase",
    "4.1.1.54\tdihydroxyfumarate decarboxylase",
    "4.1.1.55\t4,5-dihydroxyphthalate decarboxylase",
    "4.1.1.56\t3-oxolaurate decarboxylase",
    "4.1.1.57\tmethionine decarboxylase",
    "4.1.1.58\torsellinate decarboxylase",
    "4.1.1.59\tgallate decarboxylase",
    "4.1.1.60\tstipitatonate decarboxylase",
    "4.1.1.61\t4-hydroxybenzoate decarboxylase",
    "4.1.1.62\tgentisate decarboxylase",
    "4.1.1.63\tprotocatechuate decarboxylase",
    "4.1.1.64\t2,2-dialkylglycine decarboxylase (pyruvate)",
    "4.1.1.65\tphosphatidylserine decarboxylase",
    "4.1.1.66\turacil-5-carboxylate decarboxylase",
    "4.1.1.67\tUDP-galacturonate decarboxylase",
    "4.1.1.68\t5-oxopent-3-ene-1,2,5-tricarboxylate decarboxylase",
    "4.1.1.69\t3,4-dihydroxyphthalate decarboxylase",
    "4.1.1.71\t2-oxoglutarate decarboxylase",
    "4.1.1.72\tbranched-chain-2-oxoacid decarboxylase",
    "4.1.1.73\ttartrate decarboxylase",
    "4.1.1.74\tindolepyruvate decarboxylase",
    "4.1.1.75\t5-guanidino-2-oxopentanoate decarboxylase",
    "4.1.1.76\tarylmalonate decarboxylase",
    "4.1.1.77\t2-oxo-3-hexenedioate decarboxylase",
    "4.1.1.78\tacetylenedicarboxylate decarboxylase",
    "4.1.1.79\tsulfopyruvate decarboxylase",
    "4.1.1.80\t4-hydroxyphenylpyruvate decarboxylase",
    "4.1.1.81\tthreonine-phosphate decarboxylase",
    "4.1.1.82\tphosphonopyruvate decarboxylase",
    "4.1.1.83\t4-hydroxyphenylacetate decarboxylase",
    "4.1.1.84\tD-dopachrome decarboxylase",
    "4.1.1.85\t3-dehydro-L-gulonate-6-phosphate decarboxylase",
    "4.1.1.86\tdiaminobutyrate decarboxylase",
    "4.1.1.87\tmalonyl-S-ACP decarboxylase",
    "4.1.1.88\tbiotin-independent malonate decarboxylase",
    "4.1.1.90\tpeptidyl-glutamate 4-carboxylase",
    "4.1.1.91\tsalicylate decarboxylase",
    "4.1.1.92\tindole-3-carboxylate decarboxylase",
    "4.1.1.93\tpyrrole-2-carboxylate decarboxylase",
    "4.1.1.94\tethylmalonyl-CoA decarboxylase",
    "4.1.1.95\tL-glutamyl-[BtrI acyl-carrier protein] decarboxylase",
    "4.1.1.96\tcarboxynorspermidine decarboxylase",
    "4.1.1.97\t2-oxo-4-hydroxy-4-carboxy-5-ureidoimidazoline decarboxylase",
    "4.1.1.98\t4-hydroxy-3-polyprenylbenzoate decarboxylase",
    "4.1.1.99\tphosphomevalonate decarboxylase",
    "4.1.1.100\tprephenate decarboxylase",
    "4.1.1.101\tmalolactic enzyme",
    "4.1.1.102\tphenacrylate decarboxylase",
    "4.1.1.103\tgamma-resorcylate decarboxylase",
    "4.1.1.104\t3-dehydro-4-phosphotetronate decarboxylase",
    "4.1.1.105\tL-tryptophan decarboxylase",
    "4.1.1.106\tfatty acid photodecarboxylase",
    "4.1.1.107\t3,4-dihydroxyphenylacetaldehyde synthase",
    "4.1.1.108\t4-hydroxyphenylacetaldehyde synthase",
    "4.1.1.109\tphenylacetaldehyde synthase",
    "4.1.1.110\tbisphosphomevalonate decarboxylase",
    "4.1.1.111\tsiroheme decarboxylase",
    "4.1.1.112\toxaloacetate decarboxylase",
    "4.1.1.113\ttrans-aconitate decarboxylase",
    "4.1.1.114\tcis-3-alkyl-4-alkyloxetan-2-one decarboxylase",
    "4.1.1.115\tindoleacetate decarboxylase",
    "4.1.1.116\tD-ornithine/D-lysine decarboxylase",
    "4.1.1.117\t2-[(L-alanin-3-ylcarbamoyl)methyl]-2-hydroxybutanedioate decarboxylase",
    "4.1.1.118\tisophthalyl-CoA decarboxylase",
    "4.1.1.119\tphenylacetate decarboxylase",
    "4.1.1.120\t3-oxoisoapionate decarboxylase",
    "4.1.1.121\t3-oxoisoapionate-4-phosphate decarboxylase",
    "4.1.2.2\tketotetrose-phosphate aldolase",
    "4.1.2.4\tdeoxyribose-phosphate aldolase",
    "4.1.2.5\tL-threonine aldolase",
    "4.1.2.8\tindole-3-glycerol-phosphate lyase",
    "4.1.2.9\tphosphoketolase",
    "4.1.2.10\t(R)-mandelonitrile lyase",
    "4.1.2.11\thydroxymandelonitrile lyase",
    "4.1.2.12\t2-dehydropantoate aldolase",
    "4.1.2.13\tfructose-bisphosphate aldolase",
    "4.1.2.14\t2-dehydro-3-deoxy-phosphogluconate aldolase",
    "4.1.2.17\tL-fuculose-phosphate aldolase",
    "4.1.2.18\t2-dehydro-3-deoxy-L-pentonate aldolase",
    "4.1.2.19\trhamnulose-1-phosphate aldolase",
    "4.1.2.20\t2-dehydro-3-deoxyglucarate aldolase",
    "4.1.2.21\t2-dehydro-3-deoxy-6-phosphogalactonate aldolase",
    "4.1.2.22\tfructose-6-phosphate phosphoketolase",
    "4.1.2.23\t3-deoxy-D-manno-octulosonate aldolase",
    "4.1.2.24\tdimethylaniline-N-oxide aldolase",
    "4.1.2.25\tdihydroneopterin aldolase",
    "4.1.2.26\tphenylserine aldolase",
    "4.1.2.27\tsphinganine-1-phosphate aldolase",
    "4.1.2.28\t2-dehydro-3-deoxy-D-pentonate aldolase",
    "4.1.2.29\t5-dehydro-2-deoxyphosphogluconate aldolase",
    "4.1.2.32\ttrimethylamine-oxide aldolase",
    "4.1.2.33\tfucosterol-epoxide lyase",
    "4.1.2.34\t4-(2-carboxyphenyl)-2-oxobut-3-enoate aldolase",
    "4.1.2.35\tpropioin synthase",
    "4.1.2.36\tlactate aldolase",
    "4.1.2.38\tbenzoin aldolase",
    "4.1.2.40\ttagatose-bisphosphate aldolase",
    "4.1.2.42\tD-threonine aldolase",
    "4.1.2.43\t3-hexulose-6-phosphate synthase",
    "4.1.2.44\t2,3-epoxybenzoyl-CoA dihydrolase",
    "4.1.2.45\ttrans-o-hydroxybenzylidenepyruvate hydratase-aldolase",
    "4.1.2.46\taliphatic (R)-hydroxynitrile lyase",
    "4.1.2.47\t(S)-hydroxynitrile lyase",
    "4.1.2.48\tlow-specificity L-threonine aldolase",
    "4.1.2.49\tL-allo-threonine aldolase",
    "4.1.2.50\t6-carboxytetrahydropterin synthase",
    "4.1.2.51\t2-dehydro-3-deoxy-D-gluconate aldolase",
    "4.1.2.52\t4-hydroxy-2-oxoheptanedioate aldolase",
    "4.1.2.53\t2-keto-3-deoxy-L-rhamnonate aldolase",
    "4.1.2.54\tL-threo-3-deoxy-hexylosonate aldolase",
    "4.1.2.55\t2-dehydro-3-deoxy-phosphogluconate/2-dehydro-3-deoxy-6-phosphogalactonate aldolase",
    "4.1.2.56\t2-amino-4,5-dihydroxy-6-oxo-7-(phosphonooxy)heptanoate synthase",
    "4.1.2.57\tsulfofructosephosphate aldolase",
    "4.1.2.58\t2-dehydro-3,6-dideoxy-6-sulfogluconate aldolase",
    "4.1.2.59\tdihydroneopterin phosphate aldolase",
    "4.1.2.60\tdihydroneopterin triphosphate aldolase",
    "4.1.2.61\tferuloyl-CoA hydratase/lyase",
    "4.1.2.62\t5-deoxyribulose 1-phosphate aldolase",
    "4.1.2.63\t2-hydroxyacyl-CoA lyase",
    "4.1.3.1\tisocitrate lyase",
    "4.1.3.3\tN-acetylneuraminate lyase",
    "4.1.3.4\thydroxymethylglutaryl-CoA lyase",
    "4.1.3.6\tcitrate (pro-3S)-lyase",
    "4.1.3.13\toxalomalate lyase",
    "4.1.3.14\tL-erythro-3-hydroxyaspartate aldolase",
    "4.1.3.16\t4-hydroxy-2-oxoglutarate aldolase",
    "4.1.3.17\t4-hydroxy-4-methyl-2-oxoglutarate aldolase",
    "4.1.3.22\tcitramalate lyase",
    "4.1.3.24\tmalyl-CoA lyase",
    "4.1.3.25\t(S)-citramalyl-CoA lyase",
    "4.1.3.26\t3-hydroxy-3-isohexenylglutaryl-CoA lyase",
    "4.1.3.27\tanthranilate synthase",
    "4.1.3.30\tmethylisocitrate lyase",
    "4.1.3.32\t2,3-dimethylmalate lyase",
    "4.1.3.34\tcitryl-CoA lyase",
    "4.1.3.35\t(1-hydroxycyclohexan-1-yl)acetyl-CoA lyase",
    "4.1.3.36\t1,4-dihydroxy-2-naphthoyl-CoA synthase",
    "4.1.3.38\taminodeoxychorismate lyase",
    "4.1.3.39\t4-hydroxy-2-oxovalerate aldolase",
    "4.1.3.40\tchorismate lyase",
    "4.1.3.41\t3-hydroxy-D-aspartate aldolase",
    "4.1.3.42\t(4S)-4-hydroxy-2-oxoglutarate aldolase",
    "4.1.3.43\t4-hydroxy-2-oxohexanoate aldolase",
    "4.1.3.44\ttRNA 4-demethylwyosine synthase (AdoMet-dependent)",
    "4.1.3.45\t3-hydroxybenzoate synthase",
    "4.1.3.46\t(R)-citramalyl-CoA lyase",
    "4.1.99.1\ttryptophanase",
    "4.1.99.2\ttyrosine phenol-lyase",
    "4.1.99.3\tdeoxyribodipyrimidine photo-lyase",
    "4.1.99.5\taldehyde oxygenase (deformylating)",
    "4.1.99.11\tbenzylsuccinate synthase",
    "4.1.99.12\t3,4-dihydroxy-2-butanone-4-phosphate synthase",
    "4.1.99.13\t(6-4)DNA photolyase",
    "4.1.99.14\tspore photoproduct lyase",
    "4.1.99.16\tgeosmin synthase",
    "4.1.99.17\tphosphomethylpyrimidine synthase",
    "4.1.99.19\t2-iminoacetate synthase",
    "4.1.99.20\t3-amino-4-hydroxybenzoate synthase",
    "4.1.99.22\tGTP 3',8-cyclase",
    "4.1.99.23\t5-hydroxybenzimidazole synthase",
    "4.1.99.24\tL-tyrosine isonitrile synthase",
    "4.1.99.25\tL-tryptophan isonitrile synthase",
    "4.1.99.26\t3-amino-5-[(4-hydroxyphenyl)methyl]-4,4-dimethylpyrrolidin-2-one synthase",
    "4.2.1.1\tcarbonic anhydrase",
    "4.2.1.2\tfumarate hydratase",
    "4.2.1.3\taconitate hydratase",
    "4.2.1.5\tarabinonate dehydratase",
    "4.2.1.6\tgalactonate dehydratase",
    "4.2.1.7\taltronate dehydratase",
    "4.2.1.8\tmannonate dehydratase",
    "4.2.1.9\tdihydroxy-acid dehydratase",
    "4.2.1.10\t3-dehydroquinate dehydratase",
    "4.2.1.11\tphosphopyruvate hydratase",
    "4.2.1.12\tphosphogluconate dehydratase",
    "4.2.1.17\tenoyl-CoA hydratase",
    "4.2.1.18\tmethylglutaconyl-CoA hydratase",
    "4.2.1.19\timidazoleglycerol-phosphate dehydratase",
    "4.2.1.20\ttryptophan synthase",
    "4.2.1.22\tcystathionine beta-synthase",
    "4.2.1.24\tporphobilinogen synthase",
    "4.2.1.25\tL-arabinonate dehydratase",
    "4.2.1.27\tacetylenecarboxylate hydratase",
    "4.2.1.28\tpropanediol dehydratase",
    "4.2.1.30\tglycerol dehydratase",
    "4.2.1.31\tmaleate hydratase",
    "4.2.1.32\tL(+)-tartrate dehydratase",
    "4.2.1.33\t3-isopropylmalate dehydratase",
    "4.2.1.34\t(S)-2-methylmalate dehydratase",
    "4.2.1.35\t(R)-2-methylmalate dehydratase",
    "4.2.1.36\thomoaconitate hydratase",
    "4.2.1.39\tgluconate dehydratase",
    "4.2.1.40\tglucarate dehydratase",
    "4.2.1.41\t5-dehydro-4-deoxyglucarate dehydratase",
    "4.2.1.42\tgalactarate dehydratase",
    "4.2.1.43\t2-dehydro-3-deoxy-L-arabinonate dehydratase",
    "4.2.1.44\tmyo-inosose-2 dehydratase",
    "4.2.1.45\tCDP-glucose 4,6-dehydratase",
    "4.2.1.46\tdTDP-glucose 4,6-dehydratase",
    "4.2.1.47\tGDP-mannose 4,6-dehydratase",
    "4.2.1.48\tD-glutamate cyclase",
    "4.2.1.49\turocanate hydratase",
    "4.2.1.50\tpyrazolylalanine synthase",
    "4.2.1.51\tprephenate dehydratase",
    "4.2.1.53\toleate hydratase",
    "4.2.1.54\tlactoyl-CoA dehydratase",
    "4.2.1.55\t3-hydroxybutyryl-CoA dehydratase",
    "4.2.1.56\titaconyl-CoA hydratase",
    "4.2.1.57\tisohexenylglutaconyl-CoA hydratase",
    "4.2.1.59\t3-hydroxyacyl-[acyl-carrier-protein] dehydratase",
    "4.2.1.62\t5alpha-hydroxysteroid dehydratase",
    "4.2.1.65\t3-cyanoalanine hydratase",
    "4.2.1.66\tcyanide hydratase",
    "4.2.1.67\tD-fuconate dehydratase",
    "4.2.1.68\tL-fuconate dehydratase",
    "4.2.1.69\tcyanamide hydratase",
    "4.2.1.70\tpseudouridylate synthase",
    "4.2.1.73\tprotoaphin-aglucone dehydratase (cyclizing)",
    "4.2.1.74\tmedium-chain-enoyl-CoA hydratase",
    "4.2.1.75\turoporphyrinogen-III synthase",
    "4.2.1.76\tUDP-glucose 4,6-dehydratase",
    "4.2.1.77\ttrans-L-3-hydroxyproline dehydratase",
    "4.2.1.78\t(S)-norcoclaurine synthase",
    "4.2.1.79\t2-methylcitrate dehydratase",
    "4.2.1.80\t2-oxopent-4-enoate hydratase",
    "4.2.1.81\tD(-)-tartrate dehydratase",
    "4.2.1.82\txylonate dehydratase",
    "4.2.1.83\t4-oxalmesaconate hydratase",
    "4.2.1.84\tnitrile hydratase",
    "4.2.1.85\tdimethylmaleate hydratase",
    "4.2.1.87\toctopamine dehydratase",
    "4.2.1.88\tsynephrine dehydratase",
    "4.2.1.90\tL-rhamnonate dehydratase",
    "4.2.1.91\tarogenate dehydratase",
    "4.2.1.92\thydroperoxide dehydratase",
    "4.2.1.93\tATP-dependent NAD(P)H-hydrate dehydratase",
    "4.2.1.94\tscytalone dehydratase",
    "4.2.1.95\tkievitone hydratase",
    "4.2.1.96\t4a-hydroxytetrahydrobiopterin dehydratase",
    "4.2.1.97\tphaseollidin hydratase",
    "4.2.1.98\t16alpha-hydroxyprogesterone dehydratase",
    "4.2.1.99\t2-methylisocitrate dehydratase",
    "4.2.1.100\tcyclohexa-1,5-dienecarbonyl-CoA hydratase",
    "4.2.1.101\ttrans-feruloyl-CoA hydratase",
    "4.2.1.103\tcyclohexyl-isocyanide hydratase",
    "4.2.1.104\tcyanase",
    "4.2.1.105\t2-hydroxyisoflavanone dehydratase",
    "4.2.1.106\tbile-acid 7alpha-dehydratase",
    "4.2.1.107\t3alpha,7alpha,12alpha-trihydroxy-5beta-cholest-24-enoyl-CoA hydratase",
    "4.2.1.108\tectoine synthase",
    "4.2.1.109\tmethylthioribulose 1-phosphate dehydratase",
    "4.2.1.110\taldos-2-ulose dehydratase",
    "4.2.1.111\t1,5-anhydro-D-fructose dehydratase",
    "4.2.1.112\tacetylene hydratase",
    "4.2.1.113\to-succinylbenzoate synthase",
    "4.2.1.114\tmethanogen homoaconitase",
    "4.2.1.115\tUDP-N-acetylglucosamine 4,6-dehydratase (inverting)",
    "4.2.1.116\t3-hydroxypropionyl-CoA dehydratase",
    "4.2.1.117\t2-methylcitrate dehydratase (2-methyl-trans-aconitate forming)",
    "4.2.1.118\t3-dehydroshikimate dehydratase",
    "4.2.1.119\tenoyl-CoA hydratase 2",
    "4.2.1.120\t4-hydroxybutanoyl-CoA dehydratase",
    "4.2.1.121\tcolneleate synthase",
    "4.2.1.122\ttryptophan synthase (indole-salvaging)",
    "4.2.1.123\ttetrahymanol synthase",
    "4.2.1.124\tarabidiol synthase",
    "4.2.1.125\tdammarenediol II synthase",
    "4.2.1.126\tN-acetylmuramic acid 6-phosphate etherase",
    "4.2.1.127\tlinalool dehydratase",
    "4.2.1.128\tlupan-3beta,20-diol synthase",
    "4.2.1.129\tsqualene--hopanol cyclase",
    "4.2.1.130\tD-lactate dehydratase",
    "4.2.1.131\tcarotenoid 1,2-hydratase",
    "4.2.1.132\t2-hydroxyhexa-2,4-dienoate hydratase",
    "4.2.1.133\tcopal-8-ol diphosphate hydratase",
    "4.2.1.134\tvery-long-chain (3R)-3-hydroxyacyl-CoA dehydratase",
    "4.2.1.135\tUDP-N-acetylglucosamine 4,6-dehydratase (configuration-retaining)",
    "4.2.1.136\tADP-dependent NAD(P)H-hydrate dehydratase",
    "4.2.1.137\tsporulenol synthase",
    "4.2.1.138\t(+)-caryolan-1-ol synthase",
    "4.2.1.139\tpterocarpan synthase",
    "4.2.1.140\tgluconate/galactonate dehydratase",
    "4.2.1.141\t2-dehydro-3-deoxy-D-arabinonate dehydratase",
    "4.2.1.142\t5'-oxoaverantin cyclase",
    "4.2.1.143\tversicolorin B synthase",
    "4.2.1.144\t3-amino-5-hydroxybenzoate synthase",
    "4.2.1.145\tcapreomycidine synthase",
    "4.2.1.146\tL-galactonate dehydratase",
    "4.2.1.147\t5,6,7,8-tetrahydromethanopterin hydro-lyase",
    "4.2.1.148\t2-methylfumaryl-CoA hydratase",
    "4.2.1.149\tcrotonobetainyl-CoA hydratase",
    "4.2.1.150\tshort-chain-enoyl-CoA hydratase",
    "4.2.1.151\tchorismate dehydratase",
    "4.2.1.152\thydroperoxy icosatetraenoate dehydratase",
    "4.2.1.153\t3-methylfumaryl-CoA hydratase",
    "4.2.1.154\ttetracenomycin F2 cyclase",
    "4.2.1.155\tmethylthioacryloyl-CoA hydratase",
    "4.2.1.156\tL-talarate dehydratase",
    "4.2.1.157\t(R)-2-hydroxyisocaproyl-CoA dehydratase",
    "4.2.1.158\tgalactarate dehydratase (D-threo-forming)",
    "4.2.1.159\tdTDP-4-dehydro-6-deoxy-alpha-D-glucopyranose 2,3-dehydratase",
    "4.2.1.160\t2,5-diamino-6-(5-phospho-D-ribosylamino)pyrimidin-4(3H)-one isomerase/dehydratase",
    "4.2.1.161\tbisanhydrobacterioruberin hydratase",
    "4.2.1.162\t6-deoxy-6-sulfo-D-gluconate dehydratase",
    "4.2.1.163\t2-oxo-hept-4-ene-1,7-dioate hydratase",
    "4.2.1.164\tdTDP-4-dehydro-2,6-dideoxy-D-glucose 3-dehydratase",
    "4.2.1.165\tchlorophyllide a 3(1)-hydratase",
    "4.2.1.166\tphosphinomethylmalate isomerase",
    "4.2.1.167\t(R)-2-hydroxyglutaryl-CoA dehydratase",
    "4.2.1.168\tGDP-4-dehydro-6-deoxy-alpha-D-mannose 3-dehydratase",
    "4.2.1.169\t3-vinylbacteriochlorophyllide d 3(1)-hydratase",
    "4.2.1.170\t2-(omega-methylthio)alkylmalate dehydratase",
    "4.2.1.171\tcis-L-3-hydroxyproline dehydratase",
    "4.2.1.172\ttrans-4-hydroxy-L-proline dehydratase",
    "4.2.1.173\tent-8alpha-hydroxylabd-13-en-15-yl diphosphate synthase",
    "4.2.1.174\tperegrinol diphosphate synthase",
    "4.2.1.175\t(R)-3-(aryl)lactoyl-CoA dehydratase",
    "4.2.1.176\tL-lyxonate dehydratase",
    "4.2.1.177\t(2S)-3-sulfopropanediol dehydratase",
    "4.2.2.1\thyaluronate lyase",
    "4.2.2.2\tpectate lyase",
    "4.2.2.3\tmannuronate-specific alginate lyase",
    "4.2.2.5\tchondroitin AC lyase",
    "4.2.2.6\toligogalacturonide lyase",
    "4.2.2.7\theparin lyase",
    "4.2.2.8\theparin-sulfate lyase",
    "4.2.2.9\tpectate disaccharide-lyase",
    "4.2.2.10\tpectin lyase",
    "4.2.2.11\tguluronate-specific alginate lyase",
    "4.2.2.12\txanthan lyase",
    "4.2.2.13\texo-(1->4)-alpha-D-glucan lyase",
    "4.2.2.14\tglucuronan lyase",
    "4.2.2.15\tanhydrosialidase",
    "4.2.2.16\tlevan fructotransferase (DFA-IV-forming)",
    "4.2.2.17\tinulin fructotransferase (DFA-I-forming)",
    "4.2.2.18\tinulin fructotransferase (DFA-III-forming)",
    "4.2.2.19\tchondroitin B lyase",
    "4.2.2.20\tchondroitin-sulfate-ABC endolyase",
    "4.2.2.21\tchondroitin-sulfate-ABC exolyase",
    "4.2.2.22\tpectate trisaccharide-lyase",
    "4.2.2.23\trhamnogalacturonan endolyase",
    "4.2.2.24\trhamnogalacturonan exolyase",
    "4.2.2.25\tgellan lyase",
    "4.2.2.26\toligo-alginate lyase",
    "4.2.2.27\tpectin monosaccharide-lyase",
    "4.2.2.n1\tpeptidoglycan lytic exotransglycosylase",
    "4.2.2.n2\tpeptidoglycan lytic endotransglycosylase",
    "4.2.3.1\tthreonine synthase",
    "4.2.3.2\tethanolamine-phosphate phospho-lyase",
    "4.2.3.3\tmethylglyoxal synthase",
    "4.2.3.4\t3-dehydroquinate synthase",
    "4.2.3.5\tchorismate synthase",
    "4.2.3.6\ttrichodiene synthase",
    "4.2.3.7\tpentalenene synthase",
    "4.2.3.8\tcasbene synthase",
    "4.2.3.9\taristolochene synthase",
    "4.2.3.10\t(-)-endo-fenchol synthase",
    "4.2.3.11\tsabinene-hydrate synthase",
    "4.2.3.12\t6-pyruvoyltetrahydropterin synthase",
    "4.2.3.13\t(+)-delta-cadinene synthase",
    "4.2.3.15\tmyrcene synthase",
    "4.2.3.16\t(4S)-limonene synthase",
    "4.2.3.17\ttaxadiene synthase",
    "4.2.3.18\tabieta-7,13-diene synthase",
    "4.2.3.19\tent-kaurene synthase",
    "4.2.3.20\t(R)-limonene synthase",
    "4.2.3.21\tvetispiradiene synthase",
    "4.2.3.22\tgermacradienol synthase",
    "4.2.3.23\tgermacrene-A synthase",
    "4.2.3.24\tamorpha-4,11-diene synthase",
    "4.2.3.25\tS-linalool synthase",
    "4.2.3.26\tR-linalool synthase",
    "4.2.3.27\tisoprene synthase",
    "4.2.3.28\tent-cassa-12,15-diene synthase",
    "4.2.3.29\tent-sandaracopimaradiene synthase",
    "4.2.3.30\tent-pimara-8(14),15-diene synthase",
    "4.2.3.31\tent-pimara-9(11),15-diene synthase",
    "4.2.3.32\tlevopimaradiene synthase",
    "4.2.3.33\tstemar-13-ene synthase",
    "4.2.3.34\tstemod-13(17)-ene synthase",
    "4.2.3.35\tsyn-pimara-7,15-diene synthase",
    "4.2.3.36\tterpentetriene synthase",
    "4.2.3.37\tepi-isozizaene synthase",
    "4.2.3.38\talpha-bisabolene synthase",
    "4.2.3.39\tepi-cedrol synthase",
    "4.2.3.40\t(Z)-gamma-bisabolene synthase",
    "4.2.3.41\telisabethatriene synthase",
    "4.2.3.42\taphidicolan-16beta-ol synthase",
    "4.2.3.43\tfusicocca-2,10(14)-diene synthase",
    "4.2.3.44\tisopimara-7,15-diene synthase",
    "4.2.3.45\tphyllocladan-16alpha-ol synthase",
    "4.2.3.46\talpha-farnesene synthase",
    "4.2.3.47\tbeta-farnesene synthase",
    "4.2.3.48\t(3S,6E)-nerolidol synthase",
    "4.2.3.49\t(3R,6E)-nerolidol synthase",
    "4.2.3.50\t(+)-alpha-santalene synthase [(2Z,6Z)-farnesyl diphosphate cyclizing]",
    "4.2.3.51\tbeta-phellandrene synthase (neryl-diphosphate-cyclizing)",
    "4.2.3.52\t(4S)-beta-phellandrene synthase (geranyl-diphosphate-cyclizing)",
    "4.2.3.53\t(+)-endo-beta-bergamotene synthase [(2Z,6Z)-farnesyl diphosphate cyclizing]",
    "4.2.3.54\t(-)-endo-alpha-bergamotene synthase [(2Z,6Z)-farnesyl diphosphate cyclizing]",
    "4.2.3.55\t(S)-beta-bisabolene synthase",
    "4.2.3.56\tgamma-humulene synthase",
    "4.2.3.57\t(-)-beta-caryophyllene synthase",
    "4.2.3.58\tlongifolene synthase",
    "4.2.3.59\t(E)-gamma-bisabolene synthase",
    "4.2.3.60\tgermacrene C synthase",
    "4.2.3.61\t5-epiaristolochene synthase",
    "4.2.3.62\t(-)-gamma-cadinene synthase [(2Z,6E)-farnesyl diphosphate cyclizing]",
    "4.2.3.63\t(+)-cubenene synthase",
    "4.2.3.64\t(+)-epicubenol synthase",
    "4.2.3.65\tzingiberene synthase",
    "4.2.3.66\tbeta-selinene cyclase",
    "4.2.3.67\tcis-muuroladiene synthase",
    "4.2.3.68\tbeta-eudesmol synthase",
    "4.2.3.69\t(+)-alpha-barbatene synthase",
    "4.2.3.70\tpatchoulol synthase",
    "4.2.3.71\t(E,E)-germacrene B synthase",
    "4.2.3.72\talpha-gurjunene synthase",
    "4.2.3.73\tvalencene synthase",
    "4.2.3.74\tpresilphiperfolanol synthase",
    "4.2.3.75\t(-)-germacrene D synthase",
    "4.2.3.76\t(+)-delta-selinene synthase",
    "4.2.3.77\t(+)-germacrene D synthase",
    "4.2.3.78\tbeta-chamigrene synthase",
    "4.2.3.79\tthujopsene synthase",
    "4.2.3.80\talpha-longipinene synthase",
    "4.2.3.81\texo-alpha-bergamotene synthase",
    "4.2.3.82\talpha-santalene synthase",
    "4.2.3.83\tbeta-santalene synthase",
    "4.2.3.84\t10-epi-gamma-eudesmol synthase",
    "4.2.3.85\talpha-eudesmol synthase",
    "4.2.3.86\t7-epi-alpha-selinene synthase",
    "4.2.3.87\talpha-guaiene synthase",
    "4.2.3.88\tviridiflorene synthase",
    "4.2.3.89\t(+)-beta-caryophyllene synthase",
    "4.2.3.90\t5-epi-alpha-selinene synthase",
    "4.2.3.91\tcubebol synthase",
    "4.2.3.92\t(+)-gamma-cadinene synthase",
    "4.2.3.93\tdelta-guaiene synthase",
    "4.2.3.94\tgamma-curcumene synthase",
    "4.2.3.95\t(-)-alpha-cuprenene synthase",
    "4.2.3.96\tavermitilol synthase",
    "4.2.3.97\t(-)-delta-cadinene synthase",
    "4.2.3.98\t(+)-T-muurolol synthase",
    "4.2.3.99\tlabdatriene synthase",
    "4.2.3.100\tbicyclogermacrene synthase",
    "4.2.3.101\t7-epi-sesquithujene synthase",
    "4.2.3.102\tsesquithujene synthase",
    "4.2.3.103\tent-isokaurene synthase",
    "4.2.3.104\talpha-humulene synthase",
    "4.2.3.105\ttricyclene synthase",
    "4.2.3.106\t(E)-beta-ocimene synthase",
    "4.2.3.107\t(+)-car-3-ene synthase",
    "4.2.3.108\t1,8-cineole synthase",
    "4.2.3.109\t(-)-sabinene synthase",
    "4.2.3.110\t(+)-sabinene synthase",
    "4.2.3.111\t(-)-alpha-terpineol synthase",
    "4.2.3.112\t(+)-alpha-terpineol synthase",
    "4.2.3.113\tterpinolene synthase",
    "4.2.3.114\tgamma-terpinene synthase",
    "4.2.3.115\talpha-terpinene synthase",
    "4.2.3.116\t(+)-camphene synthase",
    "4.2.3.117\t(-)-camphene synthase",
    "4.2.3.118\t2-methylisoborneol synthase",
    "4.2.3.119\t(-)-alpha-pinene synthase",
    "4.2.3.120\t(-)-beta-pinene synthase",
    "4.2.3.121\t(+)-alpha-pinene synthase",
    "4.2.3.122\t(+)-beta-pinene synthase",
    "4.2.3.123\tbeta-sesquiphellandrene synthase",
    "4.2.3.124\t2-deoxy-scyllo-inosose synthase",
    "4.2.3.125\talpha-muurolene synthase",
    "4.2.3.126\tgamma-muurolene synthase",
    "4.2.3.127\tbeta-copaene synthase",
    "4.2.3.128\tbeta-cubebene synthase",
    "4.2.3.129\t(+)-sativene synthase",
    "4.2.3.130\ttetraprenyl-beta-curcumene synthase",
    "4.2.3.131\tmiltiradiene synthase",
    "4.2.3.132\tneoabietadiene synthase",
    "4.2.3.133\talpha-copaene synthase",
    "4.2.3.134\t5-phosphooxy-L-lysine phospho-lyase",
    "4.2.3.135\tDelta(6)-protoilludene synthase",
    "4.2.3.136\talpha-isocomene synthase",
    "4.2.3.137\t(E)-2-epi-beta-caryophyllene synthase",
    "4.2.3.138\t(+)-epi-alpha-bisabolol synthase",
    "4.2.3.139\tvalerena-4,7(11)-diene synthase",
    "4.2.3.140\tcis-abienol synthase",
    "4.2.3.141\tsclareol synthase",
    "4.2.3.142\t7-epizingiberene synthase [(2Z,6Z)-farnesyl diphosphate cyclizing]",
    "4.2.3.143\tkunzeaol synthase",
    "4.2.3.144\tgeranyllinalool synthase",
    "4.2.3.145\tophiobolin F synthase",
    "4.2.3.146\tcyclooctat-9-en-7-ol synthase",
    "4.2.3.147\tpimaradiene synthase",
    "4.2.3.148\tcembrene C synthase",
    "4.2.3.149\tnephthenol synthase",
    "4.2.3.150\tcembrene A synthase",
    "4.2.3.151\tpentamethylcyclopentadecatrienol synthase",
    "4.2.3.152\t2-epi-5-epi-valiolone synthase",
    "4.2.3.153\t(5-formylfuran-3-yl)methyl phosphate synthase",
    "4.2.3.154\tdemethyl-4-deoxygadusol synthase",
    "4.2.3.155\t2-epi-valiolone synthase",
    "4.2.3.156\thydroxysqualene synthase",
    "4.2.3.157\t(+)-isoafricanol synthase",
    "4.2.3.158\t(-)-spiroviolene synthase",
    "4.2.3.159\ttsukubadiene synthase",
    "4.2.3.160\t(2S,3R,6S,9S)-(-)-protoillud-7-ene synthase",
    "4.2.3.161\t(3S)-(+)-asterisca-2(9),6-diene synthase",
    "4.2.3.162\t(-)-alpha-amorphene synthase",
    "4.2.3.163\t(+)-corvol ether B synthase",
    "4.2.3.164\t(+)-eremophilene synthase",
    "4.2.3.165\t(1R,4R,5S)-(-)-guaia-6,10(14)-diene synthase",
    "4.2.3.166\t(+)-(1(10)E,4E,6S,7R)-germacradien-6-ol synthase",
    "4.2.3.167\tdolabella-3,7-dien-18-ol synthase",
    "4.2.3.168\tdolathalia-3,7,11-triene synthase",
    "4.2.3.169\t7-epi-alpha-eudesmol synthase",
    "4.2.3.170\t4-epi-cubebol synthase",
    "4.2.3.171\t(+)-corvol ether A synthase",
    "4.2.3.172\t10-epi-juneol synthase",
    "4.2.3.173\ttau-cadinol synthase",
    "4.2.3.174\t(2E,6E)-hedycaryol synthase",
    "4.2.3.175\t10-epi-cubebol synthase",
    "4.2.3.176\tsesterfisherol synthase",
    "4.2.3.177\tbeta-thujene synthase",
    "4.2.3.178\tstellata-2,6,19-triene synthase",
    "4.2.3.179\tguaia-4,6-diene synthase",
    "4.2.3.180\tpseudolaratriene synthase",
    "4.2.3.181\tselina-4(15),7(11)-diene synthase",
    "4.2.3.182\tpristinol synthase",
    "4.2.3.183\tnezukol synthase",
    "4.2.3.184\t5-hydroxy-alpha-gurjunene synthase",
    "4.2.3.185\tent-atiserene synthase",
    "4.2.3.186\tent-13-epi-manoyl oxide synthase",
    "4.2.3.187\t(2Z,6E)-hedycaryol synthase",
    "4.2.3.188\tbeta-geranylfarnesene synthase",
    "4.2.3.189\t9,13-epoxylabda-14-ene synthase",
    "4.2.3.190\tmanoyl oxide synthase",
    "4.2.3.191\tcycloaraneosene synthase",
    "4.2.3.192\tlabda-7,13(16),14-triene synthase",
    "4.2.3.193\t(12E)-labda-8(17),12,14-triene synthase",
    "4.2.3.194\t(-)-drimenol synthase",
    "4.2.3.195\trhizathalene A synthase",
    "4.2.3.196\tdolabradiene synthase",
    "4.2.3.197\teudesmane-5,11-diol synthase",
    "4.2.3.198\talpha-selinene synthase",
    "4.2.3.199\t(-)-5-epieremophilene synthase",
    "4.2.3.200\tbeta-pinacene synthase",
    "4.2.3.201\thydropyrene synthase",
    "4.2.3.202\thydropyrenol synthase",
    "4.2.3.203\tisoelisabethatriene synthase",
    "4.2.3.204\tvalerianol synthase",
    "4.2.3.205\tsodorifen synthase",
    "4.2.99.12\tcarboxymethyloxysuccinate lyase",
    "4.2.99.18\tDNA-(apurinic or apyrimidinic site) lyase",
    "4.2.99.20\t2-succinyl-6-hydroxy-2,4-cyclohexadiene-1-carboxylate synthase",
    "4.2.99.21\tisochorismate lyase",
    "4.2.99.22\ttuliposide A-converting enzyme",
    "4.2.99.23\ttuliposide B-converting enzyme",
    "4.2.99.24\tthebaine synthase",
    "4.3.1.1\taspartate ammonia-lyase",
    "4.3.1.2\tmethylaspartate ammonia-lyase",
    "4.3.1.3\thistidine ammonia-lyase",
    "4.3.1.4\tformimidoyltetrahydrofolate cyclodeaminase",
    "4.3.1.6\tbeta-alanyl-CoA ammonia-lyase",
    "4.3.1.7\tethanolamine ammonia-lyase",
    "4.3.1.9\tglucosaminate ammonia-lyase",
    "4.3.1.10\tserine-sulfate ammonia-lyase",
    "4.3.1.12\tornithine cyclodeaminase",
    "4.3.1.13\tcarbamoyl-serine ammonia-lyase",
    "4.3.1.14\t3-aminobutyryl-CoA ammonia-lyase",
    "4.3.1.15\tdiaminopropionate ammonia-lyase",
    "4.3.1.16\tthreo-3-hydroxy-L-aspartate ammonia-lyase",
    "4.3.1.17\tL-serine ammonia-lyase",
    "4.3.1.18\tD-serine ammonia-lyase",
    "4.3.1.19\tthreonine ammonia-lyase",
    "4.3.1.20\terythro-3-hydroxy-L-aspartate ammonia-lyase",
    "4.3.1.22\t3,4-dihydroxyphenylalanine reductive deaminase",
    "4.3.1.23\ttyrosine ammonia-lyase",
    "4.3.1.24\tphenylalanine ammonia-lyase",
    "4.3.1.25\tphenylalanine/tyrosine ammonia-lyase",
    "4.3.1.27\tthreo-3-hydroxy-D-aspartate ammonia-lyase",
    "4.3.1.28\tL-lysine cyclodeaminase",
    "4.3.1.29\tD-glucosaminate-6-phosphate ammonia lyase",
    "4.3.1.30\tdTDP-4-amino-4,6-dideoxy-D-glucose ammonia-lyase",
    "4.3.1.31\tL-tryptophan ammonia lyase",
    "4.3.1.32\t7,8-didemethyl-8-hydroxy-5-deazariboflavin synthase",
    "4.3.2.1\targininosuccinate lyase",
    "4.3.2.2\tadenylosuccinate lyase",
    "4.3.2.3\tureidoglycolate lyase",
    "4.3.2.4\tpurine imidazole-ring cyclase",
    "4.3.2.5\tpeptidylamidoglycolate lyase",
    "4.3.2.6\tgamma-L-glutamyl-butirosin B gamma-glutamyl cyclotransferase",
    "4.3.2.7\tglutathione-specific gamma-glutamylcyclotransferase",
    "4.3.2.8\tgamma-glutamylamine cyclotransferase",
    "4.3.2.9\tgamma-glutamylcyclotransferase",
    "4.3.2.10\timidazole glycerol-phosphate synthase",
    "4.3.3.1\t3-ketovalidoxylamine C-N-lyase",
    "4.3.3.2\tstrictosidine synthase",
    "4.3.3.3\tdeacetylisoipecoside synthase",
    "4.3.3.4\tdeacetylipecoside synthase",
    "4.3.3.5\t4'-demethylrebeccamycin synthase",
    "4.3.3.6\tpyridoxal 5'-phosphate synthase (glutamine hydrolyzing)",
    "4.3.3.7\t4-hydroxy-tetrahydrodipicolinate synthase",
    "4.3.99.3\t7-carboxy-7-deazaguanine synthase",
    "4.3.99.4\tcholine trimethylamine-lyase",
    "4.4.1.1\tcystathionine gamma-lyase",
    "4.4.1.2\thomocysteine desulfhydrase",
    "4.4.1.3\tdimethylpropiothetin dethiomethylase",
    "4.4.1.4\talliin lyase",
    "4.4.1.5\tlactoylglutathione lyase",
    "4.4.1.6\tS-alkylcysteine lyase",
    "4.4.1.8\tcystathionine beta-lyase",
    "4.4.1.9\tL-3-cyanoalanine synthase",
    "4.4.1.10\tcysteine lyase",
    "4.4.1.11\tmethionine gamma-lyase",
    "4.4.1.13\tcysteine-S-conjugate beta-lyase",
    "4.4.1.14\t1-aminocyclopropane-1-carboxylate synthase",
    "4.4.1.15\tD-cysteine desulfhydrase",
    "4.4.1.16\tselenocysteine lyase",
    "4.4.1.17\tholocytochrome-c synthase",
    "4.4.1.19\tphosphosulfolactate synthase",
    "4.4.1.20\tleukotriene-C4 synthase",
    "4.4.1.21\tS-ribosylhomocysteine lyase",
    "4.4.1.22\tS-(hydroxymethyl)glutathione synthase",
    "4.4.1.23\t2-hydroxypropyl-CoM lyase",
    "4.4.1.24\t(2R)-sulfolactate sulfo-lyase",
    "4.4.1.25\tL-cysteate sulfo-lyase",
    "4.4.1.26\tolivetolic acid cyclase",
    "4.4.1.28\tL-cysteine desulfidase",
    "4.4.1.29\tphycobiliprotein cysteine-84 phycobilin lyase",
    "4.4.1.30\tphycobiliprotein beta-cysteine-155 phycobilin lyase",
    "4.4.1.31\tphycoerythrocyanin alpha-cysteine-84 phycoviolobilin lyase/isomerase",
    "4.4.1.32\tC-phycocyanin alpha-cysteine-84 phycocyanobilin lyase",
    "4.4.1.33\tR-phycocyanin alpha-cysteine-84 phycourobilin lyase/isomerase",
    "4.4.1.34\tisoprene-epoxide--glutathione S-transferase",
    "4.4.1.35\tL-cystine beta-lyase",
    "4.4.1.36\thercynylcysteine S-oxide lyase",
    "4.4.1.37\tpyridinium-3,5-bisthiocarboxylic acid mononucleotide synthase",
    "4.4.1.38\tisethionate sulfite-lyase",
    "4.4.1.39\tC-phycoerythrin alpha-cysteine-82 phycoerythrobilin lyase",
    "4.4.1.40\tC-phycoerythrin beta-cysteine-48/59 phycoerythrobilin lyase",
    "4.4.1.41\t(2S)-3-sulfopropanediol sulfolyase",
    "4.5.1.1\tDDT-dehydrochlorinase",
    "4.5.1.2\t3-chloro-D-alanine dehydrochlorinase",
    "4.5.1.3\tdichloromethane dehalogenase",
    "4.5.1.4\tL-2-amino-4-chloropent-4-enoate dehydrochlorinase",
    "4.5.1.5\tS-carboxymethylcysteine synthase",
    "4.6.1.1\tadenylate cyclase",
    "4.6.1.2\tguanylate cyclase",
    "4.6.1.6\tcytidylate cyclase",
    "4.6.1.12\t2-C-methyl-D-erythritol 2,4-cyclodiphosphate synthase",
    "4.6.1.13\tphosphatidylinositol diacylglycerol-lyase",
    "4.6.1.14\tglycosylphosphatidylinositol diacylglycerol-lyase",
    "4.6.1.15\tFAD-AMP lyase (cyclizing)",
    "4.6.1.16\ttRNA-intron lyase",
    "4.6.1.17\tcyclic pyranopterin monophosphate synthase",
    "4.6.1.18\tpancreatic ribonuclease",
    "4.6.1.19\tribonuclease T2",
    "4.6.1.20\tribonuclease U2",
    "4.6.1.21\tEnterobacter ribonuclease",
    "4.6.1.22\tBacillus subtilis ribonuclease",
    "4.6.1.23\tribotoxin",
    "4.6.1.24\tribonuclease T1",
    "4.6.1.25\tbacteriophage T4 restriction endoribonuclease RegB",
    "4.7.1.1\talpha-D-ribose 1-methylphosphonate 5-phosphate C-P-lyase",
    "4.99.1.1\tprotoporphyrin ferrochelatase",
    "4.99.1.2\talkylmercury lyase",
    "4.99.1.3\tsirohydrochlorin cobaltochelatase",
    "4.99.1.4\tsirohydrochlorin ferrochelatase",
    "4.99.1.5\taliphatic aldoxime dehydratase",
    "4.99.1.6\tindoleacetaldoxime dehydratase",
    "4.99.1.7\tphenylacetaldoxime dehydratase",
    "4.99.1.8\theme ligase",
    "4.99.1.9\tcoproporphyrin ferrochelatase",
    "4.99.1.10\tmagnesium dechelatase",
    "4.99.1.11\tsirohydrochlorin nickelchelatase",
    "4.99.1.12\tpyridinium-3,5-bisthiocarboxylic acid mononucleotide nickel chelatase",
    "5.1.1.1\talanine racemase",
    "5.1.1.2\tmethionine racemase",
    "5.1.1.3\tglutamate racemase",
    "5.1.1.4\tproline racemase",
    "5.1.1.5\tlysine racemase",
    "5.1.1.6\tthreonine racemase",
    "5.1.1.7\tdiaminopimelate epimerase",
    "5.1.1.8\t4-hydroxyproline epimerase",
    "5.1.1.9\targinine racemase",
    "5.1.1.10\tamino-acid racemase",
    "5.1.1.11\tphenylalanine racemase (ATP-hydrolyzing)",
    "5.1.1.12\tornithine racemase",
    "5.1.1.13\taspartate racemase",
    "5.1.1.14\tnocardicin-A epimerase",
    "5.1.1.15\t2-aminohexano-6-lactam racemase",
    "5.1.1.16\tprotein-serine epimerase",
    "5.1.1.17\tisopenicillin-N epimerase",
    "5.1.1.18\tserine racemase",
    "5.1.1.19\tO-ureido-serine racemase",
    "5.1.1.20\tL-Ala-D/L-Glu epimerase",
    "5.1.1.21\tisoleucine 2-epimerase",
    "5.1.1.22\t4-hydroxyproline betaine 2-epimerase",
    "5.1.1.23\tUDP-N-acetyl-alpha-D-muramoyl-L-alanyl-L-glutamate epimerase",
    "5.1.1.24\thistidine racemase",
    "5.1.2.1\tlactate racemase",
    "5.1.2.2\tmandelate racemase",
    "5.1.2.3\t3-hydroxybutyryl-CoA epimerase",
    "5.1.2.4\tacetoin racemase",
    "5.1.2.5\ttartrate epimerase",
    "5.1.2.6\tisocitrate epimerase",
    "5.1.2.7\ttagaturonate epimerase",
    "5.1.3.1\tribulose-phosphate 3-epimerase",
    "5.1.3.2\tUDP-glucose 4-epimerase",
    "5.1.3.3\taldose 1-epimerase",
    "5.1.3.4\tL-ribulose-5-phosphate 4-epimerase",
    "5.1.3.5\tUDP-arabinose 4-epimerase",
    "5.1.3.6\tUDP-glucuronate 4-epimerase",
    "5.1.3.7\tUDP-N-acetylglucosamine 4-epimerase",
    "5.1.3.8\tN-acylglucosamine 2-epimerase",
    "5.1.3.9\tN-acylglucosamine-6-phosphate 2-epimerase",
    "5.1.3.10\tCDP-paratose 2-epimerase",
    "5.1.3.11\tcellobiose epimerase",
    "5.1.3.13\tdTDP-4-dehydrorhamnose 3,5-epimerase",
    "5.1.3.14\tUDP-N-acetylglucosamine 2-epimerase (non-hydrolyzing)",
    "5.1.3.15\tglucose-6-phosphate 1-epimerase",
    "5.1.3.16\tUDP-glucosamine 4-epimerase",
    "5.1.3.17\theparosan-N-sulfate-glucuronate 5-epimerase",
    "5.1.3.18\tGDP-mannose 3,5-epimerase",
    "5.1.3.19\tchondroitin-glucuronate 5-epimerase",
    "5.1.3.20\tADP-glyceromanno-heptose 6-epimerase",
    "5.1.3.21\tmaltose epimerase",
    "5.1.3.22\tL-ribulose-5-phosphate 3-epimerase",
    "5.1.3.23\tUDP-2,3-diacetamido-2,3-dideoxyglucuronic acid 2-epimerase",
    "5.1.3.24\tN-acetylneuraminate epimerase",
    "5.1.3.25\tdTDP-L-rhamnose 4-epimerase",
    "5.1.3.26\tN-acetyl-alpha-D-glucosaminyl-diphospho-ditrans,octacis-undecaprenol 4-epimerase",
    "5.1.3.27\tdTDP-4-dehydro-6-deoxy-D-glucose 3-epimerase",
    "5.1.3.28\tUDP-N-acetyl-L-fucosamine synthase",
    "5.1.3.29\tL-fucose mutarotase",
    "5.1.3.30\tD-psicose 3-epimerase",
    "5.1.3.31\tD-tagatose 3-epimerase",
    "5.1.3.32\tL-rhamnose mutarotase",
    "5.1.3.33\t2-epi-5-epi-valiolone epimerase",
    "5.1.3.34\tmonoglucosyldiacylglycerol epimerase",
    "5.1.3.35\t2-epi-5-epi-valiolone 7-phosphate 2-epimerase",
    "5.1.3.36\theparosan-glucuronate 5-epimerase",
    "5.1.3.37\tmannuronan 5-epimerase",
    "5.1.3.38\tD-erythrulose 1-phosphate 3-epimerase",
    "5.1.3.40\tD-tagatose 6-phosphate 4-epimerase",
    "5.1.3.41\tfructoselysine 3-epimerase",
    "5.1.3.42\tD-glucosamine-6-phosphate 4-epimerase",
    "5.1.3.43\tsulfoquinovose mutarotase",
    "5.1.3.44\tmannose 2-epimerase",
    "5.1.99.1\tmethylmalonyl-CoA epimerase",
    "5.1.99.2\t16-hydroxysteroid epimerase",
    "5.1.99.3\tallantoin racemase",
    "5.1.99.4\talpha-methylacyl-CoA racemase",
    "5.1.99.5\thydantoin racemase",
    "5.1.99.6\tNAD(P)H-hydrate epimerase",
    "5.1.99.7\tdihydroneopterin triphosphate 2'-epimerase",
    "5.1.99.8\t7,8-dihydroneopterin epimerase",
    "5.2.1.1\tmaleate isomerase",
    "5.2.1.2\tmaleylacetoacetate isomerase",
    "5.2.1.4\tmaleylpyruvate isomerase",
    "5.2.1.5\tlinoleate isomerase",
    "5.2.1.6\tfurylfuramide isomerase",
    "5.2.1.8\tpeptidylprolyl isomerase",
    "5.2.1.9\tfarnesol 2-isomerase",
    "5.2.1.10\t2-chloro-4-carboxymethylenebut-2-en-1,4-olide isomerase",
    "5.2.1.12\tzeta-carotene isomerase",
    "5.2.1.13\tprolycopene isomerase",
    "5.2.1.14\tbeta-carotene isomerase",
    "5.3.1.1\ttriose-phosphate isomerase",
    "5.3.1.3\tD-arabinose isomerase",
    "5.3.1.4\tL-arabinose isomerase",
    "5.3.1.5\txylose isomerase",
    "5.3.1.6\tribose-5-phosphate isomerase",
    "5.3.1.7\tmannose isomerase",
    "5.3.1.8\tmannose-6-phosphate isomerase",
    "5.3.1.9\tglucose-6-phosphate isomerase",
    "5.3.1.12\tglucuronate isomerase",
    "5.3.1.13\tarabinose-5-phosphate isomerase",
    "5.3.1.14\tL-rhamnose isomerase",
    "5.3.1.15\tD-lyxose ketol-isomerase",
    "5.3.1.16\t1-(5-phosphoribosyl)-5-[(5-phosphoribosylamino)methylideneamino]imidazole-4-carboxamide isomerase",
    "5.3.1.17\t5-dehydro-4-deoxy-D-glucuronate isomerase",
    "5.3.1.20\tribose isomerase",
    "5.3.1.21\tcorticosteroid side-chain-isomerase",
    "5.3.1.22\thydroxypyruvate isomerase",
    "5.3.1.23\tS-methyl-5-thioribose-1-phosphate isomerase",
    "5.3.1.24\tphosphoribosylanthranilate isomerase",
    "5.3.1.25\tL-fucose isomerase",
    "5.3.1.26\tgalactose-6-phosphate isomerase",
    "5.3.1.27\t6-phospho-3-hexuloisomerase",
    "5.3.1.28\tD-sedoheptulose-7-phosphate isomerase",
    "5.3.1.29\tribose-1,5-bisphosphate isomerase",
    "5.3.1.30\t5-deoxy-glucuronate isomerase",
    "5.3.1.31\tsulfoquinovose isomerase",
    "5.3.1.32\t(4S)-4-hydroxy-5-phosphooxypentane-2,3-dione isomerase",
    "5.3.1.33\tL-erythrulose-1-phosphate isomerase",
    "5.3.1.34\tD-erythrulose 4-phosphate isomerase",
    "5.3.1.35\t2-dehydrotetronate isomerase",
    "5.3.1.36\tD-apiose isomerase",
    "5.3.2.1\tphenylpyruvate tautomerase",
    "5.3.2.2\toxaloacetate tautomerase",
    "5.3.2.3\tTDP-4-oxo-6-deoxy-alpha-D-glucose-3,4-oxoisomerase (dTDP-3-dehydro-6-deoxy-alpha-D-galactopyranose-forming)",
    "5.3.2.4\tTDP-4-oxo-6-deoxy-alpha-D-glucose-3,4-oxoisomerase (dTDP-3-dehydro-6-deoxy-alpha-D-glucopyranose-forming)",
    "5.3.2.5\t2,3-diketo-5-methylthiopentyl-1-phosphate enolase",
    "5.3.2.6\t2-hydroxymuconate tautomerase",
    "5.3.2.7\tascopyrone tautomerase",
    "5.3.2.8\t4-oxalomesaconate tautomerase",
    "5.3.3.1\tsteroid Delta-isomerase",
    "5.3.3.2\tisopentenyl-diphosphate Delta-isomerase",
    "5.3.3.3\tvinylacetyl-CoA Delta-isomerase",
    "5.3.3.4\tmuconolactone Delta-isomerase",
    "5.3.3.5\tcholestenol Delta-isomerase",
    "5.3.3.6\tmethylitaconate Delta-isomerase",
    "5.3.3.7\taconitate Delta-isomerase",
    "5.3.3.8\tDelta(3)-Delta(2)-enoyl-CoA isomerase",
    "5.3.3.9\tprostaglandin-A1 Delta-isomerase",
    "5.3.3.10\t5-carboxymethyl-2-hydroxymuconate Delta-isomerase",
    "5.3.3.11\tisopiperitenone Delta-isomerase",
    "5.3.3.12\tL-dopachrome isomerase",
    "5.3.3.13\tpolyenoic fatty acid isomerase",
    "5.3.3.14\ttrans-2-decenoyl-[acyl-carrier-protein] isomerase",
    "5.3.3.17\ttrans-2,3-dihydro-3-hydroxyanthranilate isomerase",
    "5.3.3.18\t2-(1,2-epoxy-1,2-dihydrophenyl)acetyl-CoA isomerase",
    "5.3.3.19\t3-[(4R)-4-hydroxycyclohexa-1,5-dien-1-yl]-2-oxopropanoate isomerase",
    "5.3.3.21\tDelta(3,5)-Delta(2,4)-dienoyl-CoA isomerase",
    "5.3.3.22\tlutein isomerase",
    "5.3.3.23\tS-methyl-5-thioribulose 1-phosphate isomerase",
    "5.3.4.1\tprotein disulfide-isomerase",
    "5.3.99.2\tprostaglandin-D synthase",
    "5.3.99.3\tprostaglandin-E synthase",
    "5.3.99.4\tprostaglandin-I synthase",
    "5.3.99.5\tthromboxane-A synthase",
    "5.3.99.6\tallene-oxide cyclase",
    "5.3.99.7\tstyrene-oxide isomerase",
    "5.3.99.8\tcapsanthin/capsorubin synthase",
    "5.3.99.9\tneoxanthin synthase",
    "5.3.99.10\tthiazole tautomerase",
    "5.3.99.11\t2-keto-myo-inositol isomerase",
    "5.4.1.1\tlysolecithin acylmutase",
    "5.4.1.3\t2-methylfumaryl-CoA isomerase",
    "5.4.1.4\tD-galactarolactone isomerase",
    "5.4.2.2\tphosphoglucomutase (alpha-D-glucose-1,6-bisphosphate-dependent)",
    "5.4.2.3\tphosphoacetylglucosamine mutase",
    "5.4.2.4\tbisphosphoglycerate mutase",
    "5.4.2.5\tphosphoglucomutase (glucose-cofactor)",
    "5.4.2.6\tbeta-phosphoglucomutase",
    "5.4.2.7\tphosphopentomutase",
    "5.4.2.8\tphosphomannomutase",
    "5.4.2.9\tphosphoenolpyruvate mutase",
    "5.4.2.10\tphosphoglucosamine mutase",
    "5.4.2.11\tphosphoglycerate mutase (2,3-diphosphoglycerate-dependent)",
    "5.4.2.12\tphosphoglycerate mutase (2,3-diphosphoglycerate-independent)",
    "5.4.2.13\tphosphogalactosamine mutase",
    "5.4.3.2\tlysine 2,3-aminomutase",
    "5.4.3.3\tlysine 5,6-aminomutase",
    "5.4.3.4\tD-lysine 5,6-aminomutase",
    "5.4.3.5\tD-ornithine 4,5-aminomutase",
    "5.4.3.6\ttyrosine 2,3-aminomutase",
    "5.4.3.7\tleucine 2,3-aminomutase",
    "5.4.3.8\tglutamate-1-semialdehyde 2,1-aminomutase",
    "5.4.3.9\tglutamate 2,3-aminomutase",
    "5.4.3.10\tphenylalanine aminomutase (L-beta-phenylalanine forming)",
    "5.4.3.11\tphenylalanine aminomutase (D-beta-phenylalanine forming)",
    "5.4.4.1\t(hydroxyamino)benzene mutase",
    "5.4.4.2\tisochorismate synthase",
    "5.4.4.3\t3-(hydroxyamino)phenol mutase",
    "5.4.4.4\tgeraniol isomerase",
    "5.4.4.5\t9,12-octadecadienoate 8-hydroperoxide 8R-isomerase",
    "5.4.4.6\t9,12-octadecadienoate 8-hydroperoxide 8S-isomerase",
    "5.4.4.7\thydroperoxy icosatetraenoate isomerase",
    "5.4.4.8\tlinalool isomerase",
    "5.4.99.1\tmethylaspartate mutase",
    "5.4.99.2\tmethylmalonyl-CoA mutase",
    "5.4.99.3\t2-acetolactate mutase",
    "5.4.99.4\t2-methyleneglutarate mutase",
    "5.4.99.5\tchorismate mutase",
    "5.4.99.7\tlanosterol synthase",
    "5.4.99.8\tcycloartenol synthase",
    "5.4.99.9\tUDP-galactopyranose mutase",
    "5.4.99.11\tisomaltulose synthase",
    "5.4.99.12\ttRNA pseudouridine(38-40) synthase",
    "5.4.99.13\tisobutyryl-CoA mutase",
    "5.4.99.14\t4-carboxymethyl-4-methylbutenolide mutase",
    "5.4.99.15\t(1->4)-alpha-D-glucan 1-alpha-D-glucosylmutase",
    "5.4.99.16\tmaltose alpha-D-glucosyltransferase",
    "5.4.99.17\tsqualene--hopene cyclase",
    "5.4.99.18\t5-(carboxyamino)imidazole ribonucleotide mutase",
    "5.4.99.19\t16S rRNA pseudouridine(516) synthase",
    "5.4.99.20\t23S rRNA pseudouridine(2457) synthase",
    "5.4.99.21\t23S rRNA pseudouridine(2604) synthase",
    "5.4.99.22\t23S rRNA pseudouridine(2605) synthase",
    "5.4.99.23\t23S rRNA pseudouridine(1911/1915/1917) synthase",
    "5.4.99.24\t23S rRNA pseudouridine(955/2504/2580) synthase",
    "5.4.99.25\ttRNA pseudouridine(55) synthase",
    "5.4.99.26\ttRNA pseudouridine(65) synthase",
    "5.4.99.27\ttRNA pseudouridine(13) synthase",
    "5.4.99.28\ttRNA pseudouridine(32) synthase",
    "5.4.99.29\t23S rRNA pseudouridine(746) synthase",
    "5.4.99.30\tUDP-arabinopyranose mutase",
    "5.4.99.31\tthalianol synthase",
    "5.4.99.32\tprotostadienol synthase",
    "5.4.99.33\tcucurbitadienol synthase",
    "5.4.99.34\tgermanicol synthase",
    "5.4.99.35\ttaraxerol synthase",
    "5.4.99.36\tisomultiflorenol synthase",
    "5.4.99.37\tdammaradiene synthase",
    "5.4.99.38\tcamelliol C synthase",
    "5.4.99.39\tbeta-amyrin synthase",
    "5.4.99.40\talpha-amyrin synthase",
    "5.4.99.41\tlupeol synthase",
    "5.4.99.42\ttRNA pseudouridine(31) synthase",
    "5.4.99.43\t21S rRNA pseudouridine(2819) synthase",
    "5.4.99.44\tmitochondrial tRNA pseudouridine(27/28) synthase",
    "5.4.99.45\ttRNA pseudouridine(38/39) synthase",
    "5.4.99.46\tshionone synthase",
    "5.4.99.47\tparkeol synthase",
    "5.4.99.48\tachilleol B synthase",
    "5.4.99.49\tglutinol synthase",
    "5.4.99.50\tfriedelin synthase",
    "5.4.99.51\tbaccharis oxide synthase",
    "5.4.99.52\talpha-seco-amyrin synthase",
    "5.4.99.53\tmarneral synthase",
    "5.4.99.54\tbeta-seco-amyrin synthase",
    "5.4.99.55\tdelta-amyrin synthase",
    "5.4.99.56\ttirucalladienol synthase",
    "5.4.99.57\tbaruol synthase",
    "5.4.99.58\tmethylornithine synthase",
    "5.4.99.59\tdTDP-fucopyranose mutase",
    "5.4.99.60\tcobalt-precorrin-8 methylmutase",
    "5.4.99.61\tprecorrin-8X methylmutase",
    "5.4.99.62\tD-ribose pyranase",
    "5.4.99.63\tethylmalonyl-CoA mutase",
    "5.4.99.64\t2-hydroxyisobutanoyl-CoA mutase",
    "5.4.99.65\tpre-alpha-onocerin synthase",
    "5.4.99.66\talpha-onocerin synthase",
    "5.4.99.67\t4-amino-4-deoxychorismate mutase",
    "5.5.1.1\tmuconate cycloisomerase",
    "5.5.1.2\t3-carboxy-cis,cis-muconate cycloisomerase",
    "5.5.1.3\ttetrahydroxypteridine cycloisomerase",
    "5.5.1.4\tinositol-3-phosphate synthase",
    "5.5.1.5\tcarboxy-cis,cis-muconate cyclase",
    "5.5.1.6\tchalcone isomerase",
    "5.5.1.7\tchloromuconate cycloisomerase",
    "5.5.1.8\t(+)-bornyl diphosphate synthase",
    "5.5.1.9\tcycloeucalenol cycloisomerase",
    "5.5.1.10\talpha-pinene-oxide decyclase",
    "5.5.1.11\tdichloromuconate cycloisomerase",
    "5.5.1.12\tcopalyl diphosphate synthase",
    "5.5.1.13\tent-copalyl diphosphate synthase",
    "5.5.1.14\tsyn-copalyl-diphosphate synthase",
    "5.5.1.15\tterpentedienyl-diphosphate synthase",
    "5.5.1.16\thalimadienyl-diphosphate synthase",
    "5.5.1.17\t(S)-beta-macrocarpene synthase",
    "5.5.1.18\tlycopene epsilon-cyclase",
    "5.5.1.19\tlycopene beta-cyclase",
    "5.5.1.20\tprosolanapyrone-III cycloisomerase",
    "5.5.1.22\t(-)-bornyl diphosphate synthase",
    "5.5.1.23\taklanonic acid methyl ester cyclase",
    "5.5.1.24\ttocopherol cyclase",
    "5.5.1.25\t3,6-anhydro-L-galactonate cycloisomerase",
    "5.5.1.26\tnogalonic acid methyl ester cyclase",
    "5.5.1.27\tD-galactarolactone cycloisomerase",
    "5.5.1.28\t(-)-kolavenyl diphosphate synthase",
    "5.5.1.29\t(+)-kolavenyl diphosphate synthase",
    "5.5.1.30\tlabda-7,13-dienyl diphosphate synthase",
    "5.5.1.31\thapalindole H synthase",
    "5.5.1.32\t12-epi-hapalindole U synthase",
    "5.5.1.33\t12-epi-fischerindole U synthase",
    "5.5.1.34\t(+)-cis,trans-nepetalactol synthase",
    "5.5.1.35\t(+)-cis,cis-nepetalactol synthase",
    "5.6.1.1\tmicrotubule-severing ATPase",
    "5.6.1.2\tdynein ATPase",
    "5.6.1.3\tplus-end-directed kinesin ATPase",
    "5.6.1.4\tminus-end-directed kinesin ATPase",
    "5.6.1.5\tproteasome ATPase",
    "5.6.1.6\tchannel-conductance-controlling ATPase",
    "5.6.1.7\tchaperonin ATPase",
    "5.6.1.8\tmyosin ATPase",
    "5.6.1.9\t(R)-2-hydroxyacyl-CoA dehydratase activating ATPase",
    "5.6.2.1\tDNA topoisomerase",
    "5.6.2.2\tDNA topoisomerase (ATP-hydrolyzing)",
    "5.99.1.1\tthiocyanate isomerase",
    "5.99.1.4\t2-hydroxychromene-2-carboxylate isomerase",
    "6.1.1.1\ttyrosine--tRNA ligase",
    "6.1.1.2\ttryptophan--tRNA ligase",
    "6.1.1.3\tthreonine--tRNA ligase",
    "6.1.1.4\tleucine--tRNA ligase",
    "6.1.1.5\tisoleucine--tRNA ligase",
    "6.1.1.6\tlysine--tRNA ligase",
    "6.1.1.7\talanine--tRNA ligase",
    "6.1.1.9\tvaline--tRNA ligase",
    "6.1.1.10\tmethionine--tRNA ligase",
    "6.1.1.11\tserine--tRNA ligase",
    "6.1.1.12\taspartate--tRNA ligase",
    "6.1.1.13\tD-alanine--poly(phosphoribitol) ligase",
    "6.1.1.14\tglycine--tRNA ligase",
    "6.1.1.15\tproline--tRNA ligase",
    "6.1.1.16\tcysteine--tRNA ligase",
    "6.1.1.17\tglutamate--tRNA ligase",
    "6.1.1.18\tglutamine--tRNA ligase",
    "6.1.1.19\targinine--tRNA ligase",
    "6.1.1.20\tphenylalanine--tRNA ligase",
    "6.1.1.21\thistidine--tRNA ligase",
    "6.1.1.22\tasparagine--tRNA ligase",
    "6.1.1.23\taspartate--tRNA(Asn) ligase",
    "6.1.1.24\tglutamate--tRNA(Gln) ligase",
    "6.1.1.26\tpyrrolysine--tRNA(Pyl) ligase",
    "6.1.1.27\tO-phosphoserine--tRNA ligase",
    "6.1.2.1\tD-alanine--(R)-lactate ligase",
    "6.1.2.2\tnebramycin 5' synthase",
    "6.1.3.1\tolefin beta-lactone synthetase",
    "6.2.1.1\tacetate--CoA ligase",
    "6.2.1.2\tmedium-chain acyl-CoA ligase",
    "6.2.1.3\tlong-chain-fatty-acid--CoA ligase",
    "6.2.1.4\tsuccinate--CoA ligase (GDP-forming)",
    "6.2.1.5\tsuccinate--CoA ligase (ADP-forming)",
    "6.2.1.6\tglutarate--CoA ligase",
    "6.2.1.7\tcholate--CoA ligase",
    "6.2.1.8\toxalate--CoA ligase",
    "6.2.1.9\tmalate--CoA ligase",
    "6.2.1.10\tacid--CoA ligase (GDP-forming)",
    "6.2.1.11\tbiotin--CoA ligase",
    "6.2.1.12\t4-coumarate--CoA ligase",
    "6.2.1.13\tacetate--CoA ligase (ADP-forming)",
    "6.2.1.14\t6-carboxyhexanoate--CoA ligase",
    "6.2.1.15\tarachidonate--CoA ligase",
    "6.2.1.16\tacetoacetate--CoA ligase",
    "6.2.1.17\tpropionate--CoA ligase",
    "6.2.1.18\tcitrate--CoA ligase",
    "6.2.1.19\tlong-chain-fatty-acid--protein ligase",
    "6.2.1.20\tlong-chain-fatty-acid--[acyl-carrier-protein] ligase",
    "6.2.1.22\t[citrate (pro-3S)-lyase] ligase",
    "6.2.1.23\tdicarboxylate--CoA ligase",
    "6.2.1.24\tphytanate--CoA ligase",
    "6.2.1.25\tbenzoate--CoA ligase",
    "6.2.1.26\to-succinylbenzoate--CoA ligase",
    "6.2.1.27\t4-hydroxybenzoate--CoA ligase",
    "6.2.1.28\t3alpha,7alpha-dihydroxy-5beta-cholestanate--CoA ligase",
    "6.2.1.30\tphenylacetate--CoA ligase",
    "6.2.1.31\t2-furoate--CoA ligase",
    "6.2.1.32\tanthranilate--CoA ligase",
    "6.2.1.33\t4-chlorobenzoate--CoA ligase",
    "6.2.1.34\ttrans-feruloyl-CoA synthase",
    "6.2.1.35\tacetate--[acyl-carrier protein] ligase",
    "6.2.1.36\t3-hydroxypropionyl-CoA synthase",
    "6.2.1.37\t3-hydroxybenzoate--CoA ligase",
    "6.2.1.38\t(2,2,3-trimethyl-5-oxocyclopent-3-enyl)acetyl-CoA synthase",
    "6.2.1.39\t[butirosin acyl-carrier protein]--L-glutamate ligase",
    "6.2.1.40\t4-hydroxybutyrate--CoA ligase (AMP-forming)",
    "6.2.1.41\t3-[(3aS,4S,7aS)-7a-methyl-1,5-dioxo-octahydro-1H-inden-4-yl]propanoate--CoA ligase",
    "6.2.1.42\t3-oxocholest-4-en-26-oate--CoA ligase",
    "6.2.1.43\t2-hydroxy-7-methoxy-5-methyl-1-naphthoate--CoA ligase",
    "6.2.1.44\t3-(methylthio)propionyl--CoA ligase",
    "6.2.1.45\tE1 ubiquitin-activating enzyme",
    "6.2.1.46\tL-allo-isoleucine--holo-[CmaA peptidyl-carrier protein] ligase",
    "6.2.1.47\tmedium-chain-fatty-acid--[acyl-carrier-protein] ligase",
    "6.2.1.48\tcarnitine--CoA ligase",
    "6.2.1.49\tlong-chain fatty acid adenylyltransferase FadD28",
    "6.2.1.50\t4-hydroxybenzoate adenylyltransferase FadD22",
    "6.2.1.51\t4-hydroxyphenylalkanoate adenylyltransferase FadD29",
    "6.2.1.52\tL-firefly luciferin--CoA ligase",
    "6.2.1.53\tL-proline--[L-prolyl-carrier protein] ligase",
    "6.2.1.54\tD-alanine--[D-alanyl-carrier protein] ligase",
    "6.2.1.55\tE1 SAMP-activating enzyme",
    "6.2.1.56\t4-hydroxybutyrate--CoA ligase (ADP-forming)",
    "6.2.1.57\tlong-chain fatty acid adenylase/transferase FadD23",
    "6.2.1.58\tisophthalate--CoA ligase",
    "6.2.1.59\tlong-chain fatty acid adenylase/transferase FadD26",
    "6.2.1.60\tmarinolic acid--CoA ligase",
    "6.2.1.61\tsalicylate--[aryl-carrier protein] ligase",
    "6.2.1.62\t3,4-dihydroxybenzoate--[aryl-carrier protein] ligase",
    "6.2.1.63\tL-arginine--[L-arginyl-carrier protein] ligase",
    "6.2.1.64\tE1 NEDD8-activating enzyme",
    "6.2.1.65\tsalicylate--CoA ligase",
    "6.2.1.66\tglyine--[glycyl-carrier protein] ligase",
    "6.2.1.67\tL-alanine--[L-alanyl-carrier protein] ligase",
    "6.2.1.68\tL-glutamate--[L-glutamyl-carrier protein] ligase",
    "6.2.1.69\tL-cysteine--[L-cysteinyl-carrier protein] ligase",
    "6.2.1.70\tL-threonine--[L-threonyl-carrier protein] ligase",
    "6.2.1.71\t2,3-dihydroxybenzoate--[aryl-carrier protein] ligase",
    "6.2.1.72\tL-serine--[L-seryl-carrier protein] ligase",
    "6.2.1.73\tL-tryptophan--[L-tryptophyl-carrier protein] ligase",
    "6.2.1.74\t3-amino-5-hydroxybenzoate--[acyl-carrier protein] ligase",
    "6.2.1.n2\tamino acid--[acyl-carrier-protein] ligase",
    "6.2.1.n3\tmalonate--CoA ligase",
    "6.2.2.1\tthioglycine synthase",
    "6.2.2.2\toxazoline synthase",
    "6.2.2.3\tthiazoline synthase",
    "6.3.1.1\taspartate--ammonia ligase",
    "6.3.1.2\tglutamine synthetase",
    "6.3.1.4\taspartate--ammonia ligase (ADP-forming)",
    "6.3.1.5\tNAD(+) synthase",
    "6.3.1.6\tglutamate--ethylamine ligase",
    "6.3.1.7\t4-methyleneglutamate--ammonia ligase",
    "6.3.1.8\tglutathionylspermidine synthase",
    "6.3.1.9\ttrypanothione synthase",
    "6.3.1.10\tadenosylcobinamide-phosphate synthase",
    "6.3.1.11\tglutamate--putrescine ligase",
    "6.3.1.12\tD-aspartate ligase",
    "6.3.1.13\tL-cysteine:1D-myo-inositol 2-amino-2-deoxy-alpha-D-glucopyranoside ligase",
    "6.3.1.14\tdiphthine--ammonia ligase",
    "6.3.1.15\t8-demethylnovobiocic acid synthase",
    "6.3.1.17\tbeta-citrylglutamate synthase",
    "6.3.1.18\tgamma-glutamylanilide synthase",
    "6.3.1.19\tprokaryotic ubiquitin-like protein ligase",
    "6.3.1.20\tlipoate--protein ligase",
    "6.3.1.21\tphosphoribosylglycinamide formyltransferase 2",
    "6.3.2.1\tpantoate--beta-alanine ligase (AMP-forming)",
    "6.3.2.2\tglutamate--cysteine ligase",
    "6.3.2.3\tglutathione synthase",
    "6.3.2.4\tD-alanine--D-alanine ligase",
    "6.3.2.5\tphosphopantothenate--cysteine ligase (CTP)",
    "6.3.2.6\tphosphoribosylaminoimidazolesuccinocarboxamide synthase",
    "6.3.2.7\tUDP-N-acetylmuramoyl-L-alanyl-D-glutamate--L-lysine ligase",
    "6.3.2.8\tUDP-N-acetylmuramate--L-alanine ligase",
    "6.3.2.9\tUDP-N-acetylmuramoyl-L-alanine--D-glutamate ligase",
    "6.3.2.10\tUDP-N-acetylmuramoyl-tripeptide--D-alanyl-D-alanine ligase",
    "6.3.2.11\tcarnosine synthase",
    "6.3.2.12\tdihydrofolate synthase",
    "6.3.2.13\tUDP-N-acetylmuramoyl-L-alanyl-D-glutamate--2,6-diaminopimelate ligase",
    "6.3.2.14\tenterobactin synthase",
    "6.3.2.16\tD-alanine--alanyl-poly(glycerolphosphate) ligase",
    "6.3.2.17\ttetrahydrofolate synthase",
    "6.3.2.18\tgamma-glutamylhistamine synthase",
    "6.3.2.20\tindoleacetate--lysine synthetase",
    "6.3.2.23\thomoglutathione synthase",
    "6.3.2.24\ttyrosine--arginine ligase",
    "6.3.2.25\ttubulin--tyrosine ligase",
    "6.3.2.26\tN-(5-amino-5-carboxypentanoyl)-L-cysteinyl-D-valine synthase",
    "6.3.2.29\tcyanophycin synthase (L-aspartate-adding)",
    "6.3.2.30\tcyanophycin synthase (L-arginine-adding)",
    "6.3.2.31\tcoenzyme F420-0:L-glutamate ligase",
    "6.3.2.32\tcoenzyme gamma-F420-2:alpha-L-glutamate ligase",
    "6.3.2.33\ttetrahydrosarcinapterin synthase",
    "6.3.2.34\tcoenzyme F420-1:gamma-L-glutamate ligase",
    "6.3.2.35\tD-alanine--D-serine ligase",
    "6.3.2.36\t4-phosphopantoate--beta-alanine ligase",
    "6.3.2.37\tUDP-N-acetylmuramoyl-L-alanyl-D-glutamate--D-lysine ligase",
    "6.3.2.38\tN(2)-citryl-N(6)-acetyl-N(6)-hydroxylysine synthase",
    "6.3.2.39\taerobactin synthase",
    "6.3.2.40\tcyclopeptine synthase",
    "6.3.2.41\tN-acetylaspartylglutamate synthase",
    "6.3.2.42\tN-acetylaspartylglutamylglutamate synthase",
    "6.3.2.43\t[amino-group carrier protein]--L-2-aminoadipate ligase",
    "6.3.2.44\tpantoate--beta-alanine ligase (ADP-forming)",
    "6.3.2.45\tUDP-N-acetylmuramate L-alanyl-gamma-D-glutamyl-meso-2,6-diaminoheptanedioate ligase",
    "6.3.2.46\tfumarate--(S)-2,3-diaminopropanoate ligase",
    "6.3.2.47\tdapdiamide synthase",
    "6.3.2.48\tL-arginine-specific L-amino acid ligase",
    "6.3.2.49\tL-alanine--L-anticapsin ligase",
    "6.3.2.50\ttenuazonic acid synthetase",
    "6.3.2.51\tphosphopantothenate--cysteine ligase (ATP)",
    "6.3.2.52\tjasmonoyl--L-amino acid ligase",
    "6.3.2.53\tUDP-N-acetylmuramoyl-L-alanine--L-glutamate ligase",
    "6.3.2.54\tL-2,3-diaminopropanoate--citrate ligase",
    "6.3.2.55\t2-[(L-alanin-3-ylcarbamoyl)methyl]-3-(2-aminoethylcarbamoyl)-2-hydroxypropanoate synthase",
    "6.3.2.56\tstaphyloferrin B synthase",
    "6.3.2.57\tstaphyloferrin A synthase",
    "6.3.2.58\tD-ornithine--citrate ligase",
    "6.3.2.59\t3-methyl-D-ornithine--L-lysine ligase",
    "6.3.2.60\tglutamate--[amino group carrier protein] ligase",
    "6.3.2.n3\tISG15--protein ligase",
    "6.3.3.1\tphosphoribosylformylglycinamidine cyclo-ligase",
    "6.3.3.2\t5-formyltetrahydrofolate cyclo-ligase",
    "6.3.3.3\tdethiobiotin synthase",
    "6.3.3.4\t(carboxyethyl)arginine beta-lactam-synthase",
    "6.3.3.5\tO-ureido-D-serine cyclo-ligase",
    "6.3.3.6\tcarbapenam-3-carboxylate synthase",
    "6.3.3.7\tNi-sirohydrochlorin a,c-diamide reductive cyclase",
    "6.3.4.2\tCTP synthase (glutamine hydrolyzing)",
    "6.3.4.3\tformate--tetrahydrofolate ligase",
    "6.3.4.4\tadenylosuccinate synthase",
    "6.3.4.5\targininosuccinate synthase",
    "6.3.4.6\turea carboxylase",
    "6.3.4.7\tribose-5-phosphate--ammonia ligase",
    "6.3.4.8\timidazoleacetate--phosphoribosyldiphosphate ligase",
    "6.3.4.9\tbiotin--[methylmalonyl-CoA-carboxytransferase] ligase",
    "6.3.4.10\tbiotin--[propionyl-CoA-carboxylase (ATP-hydrolyzing)] ligase",
    "6.3.4.11\tbiotin--[methylcrotonoyl-CoA-carboxylase] ligase",
    "6.3.4.12\tglutamate--methylamine ligase",
    "6.3.4.13\tphosphoribosylamine--glycine ligase",
    "6.3.4.14\tbiotin carboxylase",
    "6.3.4.15\tbiotin--[biotin carboxyl-carrier protein] ligase",
    "6.3.4.16\tcarbamoyl-phosphate synthase (ammonia)",
    "6.3.4.17\tformate--dihydrofolate ligase",
    "6.3.4.18\t5-(carboxyamino)imidazole ribonucleotide synthase",
    "6.3.4.19\ttRNA(Ile)-lysidine synthetase",
    "6.3.4.20\t7-cyano-7-deazaguanine synthase",
    "6.3.4.21\tnicotinate phosphoribosyltransferase",
    "6.3.4.22\ttRNA(Ile)(2)-agmatinylcytidine synthase",
    "6.3.4.23\tformate--phosphoribosylaminoimidazolecarboxamide ligase",
    "6.3.4.24\ttyramine--L-glutamate ligase",
    "6.3.4.25\t2-amino-2'-deoxyadenylo-succinate synthase",
    "6.3.5.1\tNAD(+) synthase (glutamine-hydrolyzing)",
    "6.3.5.2\tGMP synthase (glutamine-hydrolyzing)",
    "6.3.5.3\tphosphoribosylformylglycinamidine synthase",
    "6.3.5.4\tasparagine synthase (glutamine-hydrolyzing)",
    "6.3.5.5\tcarbamoyl-phosphate synthase (glutamine-hydrolyzing)",
    "6.3.5.6\tasparaginyl-tRNA synthase (glutamine-hydrolyzing)",
    "6.3.5.7\tglutaminyl-tRNA synthase (glutamine-hydrolyzing)",
    "6.3.5.9\thydrogenobyrinic acid a,c-diamide synthase (glutamine-hydrolyzing)",
    "6.3.5.10\tadenosylcobyric acid synthase (glutamine-hydrolyzing)",
    "6.3.5.11\tcobyrinate a,c-diamide synthase (glutamine-hydrolyzing)",
    "6.3.5.12\tNi-sirohydrochlorin a,c-diamide synthase",
    "6.3.5.13\tlipid II isoglutaminyl synthase (glutamine-hydrolyzing)",
    "6.4.1.1\tpyruvate carboxylase",
    "6.4.1.2\tacetyl-CoA carboxylase",
    "6.4.1.3\tpropionyl-CoA carboxylase",
    "6.4.1.4\tmethylcrotonoyl-CoA carboxylase",
    "6.4.1.5\tgeranoyl-CoA carboxylase",
    "6.4.1.6\tacetone carboxylase",
    "6.4.1.7\t2-oxoglutarate carboxylase",
    "6.4.1.8\tacetophenone carboxylase",
    "6.4.1.9\tcoenzyme F430 synthetase",
    "6.5.1.1\tDNA ligase (ATP)",
    "6.5.1.2\tDNA ligase (NAD(+))",
    "6.5.1.3\tRNA ligase (ATP)",
    "6.5.1.4\tRNA 3'-terminal-phosphate cyclase (ATP)",
    "6.5.1.5\tRNA 3'-terminal-phosphate cyclase (GTP)",
    "6.5.1.6\tDNA ligase (ATP or NAD(+))",
    "6.5.1.7\tDNA ligase (ATP, ADP or GTP)",
    "6.5.1.8\t3'-phosphate/5'-hydroxy nucleic acid ligase",
    "6.5.1.9\tcyclic 2,3-diphosphoglycerate synthase",
    "6.6.1.1\tmagnesium chelatase",
    "6.6.1.2\tcobaltochelatase",
    "7.1.1.1\tproton-translocating NAD(P)(+) transhydrogenase",
    "7.1.1.2\tNADH:ubiquinone reductase (H(+)-translocating)",
    "7.1.1.3\tubiquinol oxidase (H(+)-transporting)",
    "7.1.1.4\tcaldariellaquinol oxidase (H(+)-transporting)",
    "7.1.1.5\tmenaquinol oxidase (H(+)-transporting)",
    "7.1.1.6\tplastoquinol--plastocyanin reductase",
    "7.1.1.7\tubiquinol oxidase (electrogenic, proton-motive force generating)",
    "7.1.1.8\tquinol--cytochrome-c reductase",
    "7.1.1.9\tcytochrome-c oxidase",
    "7.1.1.10\tferredoxin--quinone oxidoreductase (H(+)-translocating)",
    "7.1.1.11\tferredoxin--NAD(+) oxidoreductase (H(+)-transporting)",
    "7.1.2.1\tP-type H(+)-exporting transporter",
    "7.1.2.2\tH(+)-transporting two-sector ATPase",
    "7.1.3.1\tH(+)-exporting diphosphatase",
    "7.1.3.2\tNa(+)-exporting diphosphatase",
    "7.2.1.1\tNADH:ubiquinone reductase (Na(+)-transporting)",
    "7.2.1.2\tferredoxin--NAD(+) oxidoreductase (Na(+)-transporting)",
    "7.2.1.3\tascorbate ferrireductase (transmembrane)",
    "7.2.2.1\tNa(+)-transporting two-sector ATPase",
    "7.2.2.2\tABC-type Cd(2+) transporter",
    "7.2.2.3\tP-type Na(+) transporter",
    "7.2.2.4\tABC-type Na(+) transporter",
    "7.2.2.5\tABC-type Mn(2+) transporter",
    "7.2.2.6\tP-type K(+) transporter",
    "7.2.2.7\tABC-type Fe(3+) transporter",
    "7.2.2.8\tP-type Cu(+) transporter",
    "7.2.2.9\tP-type Cu(2+) transporter",
    "7.2.2.10\tP-type Ca(2+) transporter",
    "7.2.2.11\tABC-type Ni(2+) transporter",
    "7.2.2.12\tP-type Zn(2+) transporter",
    "7.2.2.13\tNa(+)/K(+)-exchanging ATPase",
    "7.2.2.14\tP-type Mg(2+) transporter",
    "7.2.2.15\tP-type Ag(+) transporter",
    "7.2.2.16\tABC-type ferric hydroxamate transporter",
    "7.2.2.17\tABC-type ferric enterobactin transporter",
    "7.2.2.18\tABC-type ferric citrate transporter",
    "7.2.2.19\tH(+)/K(+)-exchanging ATPase",
    "7.2.2.20\tABC-type Zn(2+) transporter",
    "7.2.2.21\tCd(2+)-exporting ATPase",
    "7.2.2.22\tP-type Mn(2+) transporter",
    "7.2.4.1\tcarboxybiotin decarboxylase",
    "7.2.4.2\toxaloacetate decarboxylase (Na(+) extruding)",
    "7.2.4.3\t(S)-methylmalonyl-CoA decarboxylase (sodium-transporting)",
    "7.2.4.4\tbiotin-dependent malonate decarboxylase",
    "7.2.4.5\tglutaconyl-CoA decarboxylase",
    "7.3.2.1\tABC-type phosphate transporter",
    "7.3.2.2\tABC-type phosphonate transporter",
    "7.3.2.3\tABC-type sulfate transporter",
    "7.3.2.4\tABC-type nitrate transporter",
    "7.3.2.5\tABC-type molybdate transporter",
    "7.3.2.6\tABC-type tungstate transporter",
    "7.3.2.7\tarsenite-transporting ATPase",
    "7.4.2.1\tABC-type polar-amino-acid transporter",
    "7.4.2.2\tABC-type nonpolar-amino-acid transporter",
    "7.4.2.3\tmitochondrial protein-transporting ATPase",
    "7.4.2.4\tchloroplast protein-transporting ATPase",
    "7.4.2.5\tbacterial ABC-type protein transporter",
    "7.4.2.6\tABC-type oligopeptide transporter",
    "7.4.2.7\tABC-type alpha-factor-pheromone transporter",
    "7.4.2.8\tprotein-secreting ATPase",
    "7.4.2.9\tABC-type dipeptide transporter",
    "7.4.2.10\tABC-type glutathione transporter",
    "7.4.2.11\tABC-type methionine transporter",
    "7.4.2.12\tABC-type cystine transporter",
    "7.4.2.13\tABC-type tyrosine transporter",
    "7.4.2.14\tABC-type antigen peptide transporter",
    "7.5.2.1\tABC-type maltose transporter",
    "7.5.2.2\tABC-type oligosaccharide transporter",
    "7.5.2.3\tABC-type beta-glucan transporter",
    "7.5.2.4\tABC-type teichoic-acid transporter",
    "7.5.2.5\tABC-type lipopolysaccharide transporter",
    "7.5.2.6\tABC-type lipid A-core oligosaccharide transporter",
    "7.5.2.7\tABC-type D-ribose transporter",
    "7.5.2.8\tABC-type D-allose transporter",
    "7.5.2.9\tABC-type D-galactofuranose transporter",
    "7.5.2.10\tABC-type D-xylose transporter",
    "7.5.2.11\tABC-type D-galactose transporter",
    "7.5.2.12\tABC-type L-arabinose transporter",
    "7.5.2.13\tABC-type D-xylose/L-arabinose transporter",
    "7.6.2.1\tP-type phospholipid transporter",
    "7.6.2.2\tABC-type xenobiotic transporter",
    "7.6.2.3\tABC-type glutathione-S-conjugate transporter",
    "7.6.2.4\tABC-type fatty-acyl-CoA transporter",
    "7.6.2.5\tABC-type heme transporter",
    "7.6.2.6\tABC-type guanine transporter",
    "7.6.2.7\tABC-type taurine transporter",
    "7.6.2.8\tABC-type vitamin B12 transporter",
    "7.6.2.9\tABC-type quaternary amine transporter",
    "7.6.2.10\tABC-type glycerol 3-phosphate transporter",
    "7.6.2.11\tABC-type polyamine transporter",
    "7.6.2.12\tABC-type capsular-polysaccharide transporter",
    "7.6.2.13\tABC-type autoinducer-2 transporter",
    "7.6.2.14\tABC-type aliphatic sulfonate transporter",
    "7.6.2.15\tABC-type thiamine transporter",
    "7.6.2.16\tABC-type putrescine transporter"
};
