/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLCORE_ARRAY_H_
#define _GTLCORE_ARRAY_H_

#include <GTLCore/Buffer.h>

namespace GTLCore {
  /**
   * This class implement a \ref Buffer for a memory array. This class will
   * allocate and disallocate the memory.
   * @ingroup GTLCore
   */
  class GTLCORE_EXPORT Array : public Buffer {
    public:
      /**
       * Initialise an emtpy array, no memorry is allocated.
       */
      Array();
      /**
       * Initialise an array of the given size.
       * @param size size of the array in byte
       * 
       * @code
       * Array array(10); // Create an array of 10 bytes
       * @endcode
       */
      Array(int size);
      /**
       * This constructor will make a deep copy of the \ref Array given as
       * argument.
       */
      Array(const Array& rhs);
      Array& operator=(const Array& arr);
      ~Array();
      /**
       * Change the size of the array, this will erase the content of the array.
       * @param _size new size of the array
       */
      void resize(int _size);
    private:
      void clear();
      struct Private;
      Private* const d;
  };
}

#endif
