# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1308-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58356);
 script_cve_id("CVE-2007-1362", "CVE-2007-2867", "CVE-2007-2868", "CVE-2007-2869", "CVE-2007-2870", "CVE-2007-2871");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1308-1 (iceweasel)";
 script_name(name);

 desc = "The remote host is missing an update to iceweasel
announced via advisory DSA 1308-1.

Several remote vulnerabilities have been discovered in the Iceweasel web
browser, an unbranded version of the Firefox browser. The Common
Vulnerabilities and Exposures project identifies the following problems:

CVE-2007-1362

Nicolas Derouet discovered that Iceweasel performs insufficient
validation of cookies, which could lead to denial of service.

CVE-2007-2867

Boris Zbarsky, Eli Friedman, Georgi Guninski, Jesse Ruderman, Martijn
Wargers and Olli Pettay discovered crashes in the layout engine, which
might allow the execution of arbitrary code.

CVE-2007-2868

Brendan Eich, Igor Bukanov, Jesse Ruderman, moz_bug_r_a4 and Wladimir Palant
discovered crashes in the javascript engine, which might allow the execution of
arbitrary code.

CVE-2007-2869

Marcel discovered that malicous web sites can cause massive
ressource comsumption through the auto completion feature, resulting
in denial of service.

CVE-2007-2870

moz_bug_r_a4 discovered that adding an event listener through the
addEventListener() function allows cross-site scripting.

CVE-2007-2871

Chris Thomas discovered that XUL popups can can be abused for spoofing or
phishing attacks.

Fixes for the oldstable distribution (sarge) are not available. While there
will be another round of security updates for Mozilla products, Debian doesn't
have the ressources to backport further security fixes to the old Mozilla
products. You're strongly encouraged to upgrade to stable as soon as possible.

For the stable distribution (etch) these problems have been fixed in version
2.0.0.4-0etch1. A build for the Alpha architecture is not yet available, it will
be provided later.

For the unstable distribution (sid) these problems have been fixed in version
2.0.0.4-1.

We recommend that you upgrade your iceweasel packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201308-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1308-1 (iceweasel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dom-inspector", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dbg", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-gnome-support", ver:"2.0.0.4-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
