# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10180 (samba)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65000);
 script_cve_id("CVE-2009-2813", "CVE-2009-2948", "CVE-2009-2906");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.0");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-10180 (samba)");

 desc = "The remote host is missing an update to samba
announced via advisory FEDORA-2009-10180.

Update Information:

Security Release, fixes CVE-2009-2813, CVE-2009-2948 and CVE-2009-2906

ChangeLog:

* Thu Oct  1 2009 Guenther Deschner  - 3.4.2-0.42
- Update to 3.4.2
- Security Release, fixes CVE-2009-2813, CVE-2009-2948 and CVE-2009-2906
* Wed Sep  9 2009 Guenther Deschner  - 3.4.1.0-41
- Update to 3.4.1

References:

[ 1 ] Bug #523752 - CVE-2009-2813 Samba: Share restriction bypass via home-less directory user account(s)
https://bugzilla.redhat.com/show_bug.cgi?id=523752
[ 2 ] Bug #526074 - CVE-2009-2948 samba: information disclosure in suid mount.cifs
https://bugzilla.redhat.com/show_bug.cgi?id=526074
[ 3 ] Bug #526645 - CVE-2009-2906 samba: infinite loop flaw in smbd on unexpected oplock break notification reply
https://bugzilla.redhat.com/show_bug.cgi?id=526645

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update samba' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10180

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-10180 (samba)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libsmbclient", rpm:"libsmbclient~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba", rpm:"samba~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-common", rpm:"samba-common~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-doc", rpm:"samba-doc~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-domainjoin-gui", rpm:"samba-domainjoin-gui~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-swat", rpm:"samba-swat~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-winbind-devel", rpm:"samba-winbind-devel~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-debuginfo", rpm:"samba-debuginfo~3.4.2~0.42.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
