###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ikiwiki_detect.nasl 4418 2009-09-01 15:21:24Z sep $
#
# ikiwiki Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800688);
  script_version("Revision:1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("ikiwiki Version Detection");
  desc = "
  Overview: This script detects the installed version of ikiwiki and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets KB for the version of ikiwiki");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock)
{
  exit(0);
}

paths = find_bin(prog_name:"ikiwiki", sock:sock);
foreach ikiwikibin (paths)
{
  ikiwikiVer = get_bin_version(full_prog_name:chomp(ikiwikibin), sock:sock,
               version_argv:"--version", ver_pattern:"ikiwiki version ([0-9.]+)");
  if(ikiwikiVer[1] != NULL)
  {
    set_kb_item(name:"ikiwiki/Ver", value:ikiwikiVer[1]);
    security_note(data:"ikiwiki version " + ikiwikiVer[1] + " running at location "
                        + ikiwikibin + " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
