###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_apache_tomcat_priv_esc_vuln_win.nasl 5768 2009-11-16 16:40:40Z nov $
#
# Apache Tomcat Windows Installer Privilege Escalation Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901050);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-3548");
  script_bugtraq_id(36954);
  script_name("Apache Tomcat Windows Installer Privilege Escalation Vulnerability");
  desc = "
  Overview: Apache Tomcat Server is running on this host and that is prone to
  Privilege Escalation vulnerability.

  Vulnerability Insight:
  The flaw is due to the windows installer setting a blank password by default
  for the administrative user, which could be exploited by attackers to gain
  unauthorized administrative access to a vulnerable installation.

  Impact:
  Successful attempt could lead remote attackers to bypass security restrictions
  and gain the privileges.

  Impact Level: Application.

  Affected Software/OS:
  Apache Tomcat version 5.5.0 to 5.5.28 and 6.0.0 through 6.0.20 on Windows.

  Fix: Apply patch from below link,
  http://svn.apache.org/viewvc?view=revision&revision=834047

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://tomcat.apache.org/security-5.html
  http://tomcat.apache.org/security-6.html
  http://www.vupen.com/english/advisories/2009/3185
  http://securitytracker.com/alerts/2009/Nov/1023146.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Apache Tomcat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Web application abuses");
  script_dependencies("gb_apache_tomcat_detect.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}

include("http_func.inc");
include("version_func.inc");

tomPort = get_http_port(default:8080);
if(tomPort == NULL){
  exit(0);
}

tomcatVer = get_kb_item("www/" + tomPort + "/ApacheTomcat");
if(tomcatVer == NULL){
  exit(0);
}

# Check Tomcat version < 5.5.28, or < 6.0.20
if(version_in_range(version:tomcatVer, test_version:"5.5.0", test_version2:"5.5.28")||
   version_in_range(version:tomcatVer, test_version:"6.0.0", test_version2:"6.0.20")){
  security_hole(tomPort);
}
