#!/usr/bin/env python3
# Copyright 2016 The Chromium Authors
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.
"""Takes a timestamp and writes it in as readable text to a .h file."""

import argparse
import datetime
import os
import sys

def main():
    argument_parser = argparse.ArgumentParser()
    argument_parser.add_argument('output_file', help='The file to write to')
    argument_parser.add_argument('timestamp')
    args = argument_parser.parse_args()

    date_val = int(args.timestamp)
    date = datetime.datetime.fromtimestamp(date_val, tz=datetime.timezone.utc)
    output = ('// Generated by //base/write_build_date_header.py\n'
              '#ifndef BASE_GENERATED_BUILD_DATE_TIMESTAMP \n'
              f'#define BASE_GENERATED_BUILD_DATE_TIMESTAMP {date_val}'
              f'  // {date:%b %d %Y %H:%M:%S}\n'
              '#endif  // BASE_GENERATED_BUILD_DATE_TIMESTAMP \n')

    current_contents = ''
    if os.path.isfile(args.output_file):
        with open(args.output_file, 'r') as current_file:
            current_contents = current_file.read()

    if current_contents != output:
        with open(args.output_file, 'w') as output_file:
            output_file.write(output)
    return 0

if __name__ == '__main__':
    sys.exit(main())
