/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.UsageMarker;

public class UsedClassFilter
implements ClassVisitor {
    private final UsageMarker usageMarker;
    private final ClassVisitor classVisitor;

    public UsedClassFilter(UsageMarker usageMarker, ClassVisitor classVisitor) {
        this.usageMarker = usageMarker;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.usageMarker.isUsed(programClass)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.usageMarker.isUsed(libraryClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }
}

