// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorscalepseudo8.h"
#include "base.h"

ColorScalePseudoColor8::ColorScalePseudoColor8(int s) : ColorScale(s)
{
  colors_ = new unsigned char[s];

  for (int i=0; i<s; i++)
    colors_[i] = psIndex_[i];
}

ColorScalePseudoColor8::~ColorScalePseudoColor8()
{
  if (colors_)
    delete [] colors_;
}

LinearScalePseudoColor8::LinearScalePseudoColor8(int s, 
						 unsigned short* indexCells, 
						 unsigned char* colorCells,
						 int count)
  : LinearScale(s, indexCells, colorCells, count), 
    ColorScalePseudoColor8(s), 
    ColorScale(s) {}

LogScalePseudoColor8::LogScalePseudoColor8(int s, 
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count, double exp)
  : LogScale(s, indexCells, colorCells, count, exp),
    ColorScalePseudoColor8(s),
    ColorScale(s) {}

PowScalePseudoColor8::PowScalePseudoColor8(int s, 
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count, double exp)
  : PowScale(s, indexCells, colorCells, count, exp),
    ColorScalePseudoColor8(s),
    ColorScale(s) {}

SqrtScalePseudoColor8::SqrtScalePseudoColor8(int s,
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count)
  : SqrtScale(s, indexCells, colorCells, count),
    ColorScalePseudoColor8(s),
    ColorScale(s) {}

SquaredScalePseudoColor8::SquaredScalePseudoColor8(int s, 
						   unsigned short* indexCells,
						   unsigned char* colorCells,
						   int count)
  : SquaredScale(s, indexCells, colorCells, count), 
    ColorScalePseudoColor8(s),
    ColorScale(s) {}

AsinhScalePseudoColor8::AsinhScalePseudoColor8(int s, 
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count)
  : AsinhScale(s, indexCells, colorCells, count), 
    ColorScalePseudoColor8(s),
    ColorScale(s) {}

SinhScalePseudoColor8::SinhScalePseudoColor8(int s, 
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count)
  : SinhScale(s, indexCells, colorCells, count), 
    ColorScalePseudoColor8(s),
    ColorScale(s) {}

IISScalePseudoColor8::IISScalePseudoColor8(Base* parent,
					   unsigned short* indexCells, 
					   unsigned char* colorCells,
					   int count)
  : IISScale(indexCells, colorCells, count), 
    ColorScalePseudoColor8(IISSIZE), 
    ColorScale(IISSIZE)
{
  colors_[200] = psIndex_[200] = parent->getColor("black");
  colors_[201] = psIndex_[201] = parent->getColor("black");
  colors_[202] = psIndex_[202] = parent->getColor("white");
  colors_[203] = psIndex_[203] = parent->getColor("red");
  colors_[204] = psIndex_[204] = parent->getColor("green");
  colors_[205] = psIndex_[205] = parent->getColor("blue");
  colors_[206] = psIndex_[206] = parent->getColor("yellow");
  colors_[207] = psIndex_[207] = parent->getColor("cyan");
  colors_[208] = psIndex_[208] = parent->getColor("magenta");
  colors_[209] = psIndex_[209] = parent->getColor("coral");
  colors_[210] = psIndex_[210] = parent->getColor("maroon");
  colors_[211] = psIndex_[211] = parent->getColor("orange");
  colors_[212] = psIndex_[212] = parent->getColor("khaki");
  colors_[213] = psIndex_[213] = parent->getColor("orchid");
  colors_[214] = psIndex_[214] = parent->getColor("turquoise");
  colors_[215] = psIndex_[215] = parent->getColor("violet");
  colors_[216] = psIndex_[216] = parent->getColor("wheat");
}

HistEquScalePseudoColor8::HistEquScalePseudoColor8(int s, 
						   unsigned short* indexCells, 
						   unsigned char* colorCells,
						   int count, 
						   double* hist, int histsize)
  : HistEquScale(s, indexCells, colorCells, count, hist, histsize), 
    ColorScalePseudoColor8(s), 
    ColorScale(s) {}
