//<-- CLI SHELL MODE -->
// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) ????-2008 - INRIA
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
warning("off");

function r=testresult(eps)
  if argn(2)<=0 then eps=1d-10;end
  if or(isnan(real(y))<>isnan(real(yref)))  then r=%t,return,end;
  if or(isnan(imag(y))<>isnan(imag(yref)))  then r=%t,return,end;
  if or(size(y)<>size(yref)) then r=%t,return,end;
  if yref==[] then r=%f,return,end;
  k=find(abs(yref)==0);
  r=or(abs(y(k)-yref(k))>eps);
  k=find(abs(yref)<>0);
  r=r|or(max(abs(y(k)-yref(k))./abs(yref(k)))>eps);
endfunction
ieee(1)

// ------------------------------ besselj(alpha,x)------------------------------
//test of numerical precision reference computed by maple
exec(SCI+'/modules/special_functions/tests/unit_tests/besselj_ref.sce',-1)
besselJ=besselj(alpha',x);
if norm((besselJ-besselJ_ref)./abs(besselJ_ref),1)>1.1d6*%eps then pause,end



alpha=[];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[1];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[1];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[0.999999999999997446];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.999999999999997446];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[0.765197686557966605];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.765197686557966605];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[-0.260051954901933557 -0.397149809863847236 -0.177596771314338348];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933557 -0.397149809863847236 -0.177596771314338348];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.288216947635014376-1.63247121237385119e-16*%i 0.0691572616569850473+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.288216947635014376-1.63247121237385119e-16*%i 0.0691572616569850473+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[-0.260051954901933557
-0.397149809863847236
-0.177596771314338348];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933557
-0.397149809863847236
-0.177596771314338348];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ 0.288216947635014376-1.63247121237385119e-16*%i 
0.0691572616569850473+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.288216947635014376-1.63247121237385119e-16*%i 
0.0691572616569850473+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.288272330491939344+0.00165156721805876858*%i 0.0691646458471141812-0.00541608716438180676*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.282564155899245439+0.0016188639960181446*%i 0.0677950940990729028-0.00530884145304078969*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[4.99999999999999647e-08];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[4.99999999999999647e-08];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[0.440050585744933553];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.440050585744933553];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[0.339058958525936538 -0.0660433280235490638 -0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.339058958525936538 -0.0660433280235490638 -0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i 0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i 0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[ 0.339058958525936538
-0.0660433280235490638
 -0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.339058958525936538
-0.0660433280235490638
 -0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i 
 0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i 
 0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.0825942221022646084+0.00553845279173677783*%i 0.270840538797723684+0.000738422002625521083*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0809587469274432592+0.0054287840786324832*%i 0.265477536807215531+0.000723800267314064468*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[0 0 0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0 0 0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[4.99999999999999647e-08 1.25e-15 2.08333333333333265e-23];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[4.99999999999999647e-08 1.25e-15 2.08333333333333265e-23];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[0.440050585744933553 0.114903484931900501 0.0195633539826684105];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.440050585744933553 0.114903484931900501 0.0195633539826684105];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[0.339058958525936538 0.36412814585207276 0.364831230613666901];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.339058958525936538 0.36412814585207276 0.364831230613666901];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[ 0.339058958525936649 0.486091260585891194 0.30906272225525161
-0.0660433280235490083 0.364128145852072926 0.430171473875621935
 -0.327579137591465064 0.046565116277752297 0.364831230613666901];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.339058958525936649 0.486091260585891194 0.30906272225525161
-0.0660433280235490083 0.364128145852072926 0.430171473875621935
 -0.327579137591465064 0.046565116277752297 0.364831230613666901];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i -0.265594911883436868+1.66696379225679121e-16*%i 0.228101889059524748-1.43164485837168552e-16*%i 
 0.270786268276835385+0*%i -0.00468434063869093212+0*%i -0.273016906676211979+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i -0.265594911883436868+1.66696379225679121e-16*%i 0.228101889059524748-1.43164485837168552e-16*%i 
 0.270786268276835385+0*%i -0.00468434063869093212+0*%i -0.273016906676211979+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[-0 0 0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0 0 0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[1.57275203335608714e-09 3.57443643944564709e-17 5.585056936633812e-25];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[1.57275203335608714e-09 3.57443643944564709e-17 5.585056936633812e-25];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[0.351883806529722176 0.0829767227596755474 0.0132137736128501541];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.351883806529722176 0.0829767227596755474 0.0132137736128501541];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[0.412044162415463822 0.406986020132752813 0.391959608420348327];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.412044162415463822 0.406986020132752813 0.391959608420348327];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[ 0.412044162415463822 0.463422297657139715 0.267641874148340286
0.0388438196375475928 0.406986020132752813 0.40884080250847965
 -0.2772936869328117 0.130302183508563874 0.391959608420348327];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.412044162415463822 0.463422297657139715 0.267641874148340286
0.0388438196375475928 0.406986020132752813 0.40884080250847965
 -0.2772936869328117 0.130302183508563874 0.391959608420348327];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.000439741362268266983+0.000319490801010906766*%i -0.237705022442928571-0.172702807925255664*%i 0.142834518740318772+0.103775352332019871*%i 
 0.244808700524772438+0*%i -0.0775662890440063368+0*%i -0.285438661452585507+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.000439741362268266983+0.000319490801010906766*%i -0.237705022442928571-0.172702807925255664*%i 0.142834518740318772+0.103775352332019871*%i 
 0.244808700524772438+0*%i -0.0775662890440063368+0*%i -0.285438661452585507+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[1
0
0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[1
0
0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[ 0.999999999999997446
4.99999999999999647e-08
 1.25e-15];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.999999999999997446
4.99999999999999647e-08
 1.25e-15];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[0.765197686557966605
0.440050585744933553
0.114903484931900501];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.765197686557966605
0.440050585744933553
0.114903484931900501];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[-0.260051954901933557 0.339058958525936482 0.486091260585891194
-0.397149809863847236 -0.0660433280235490638 0.36412814585207276
-0.177596771314338348 -0.327579137591465064 0.046565116277752297];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933557 0.339058958525936482 0.486091260585891194
-0.397149809863847236 -0.0660433280235490638 0.36412814585207276
-0.177596771314338348 -0.327579137591465064 0.046565116277752297];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.288216947635014376-1.63247121237385119e-16*%i -0.0825704304932580041+4.67681903786785266e-17*%i -0.265594911883436868+1.5043391839391156e-16*%i 
0.0691572616569850473+0*%i 0.270786268276835385+0*%i -0.00468434063869093212+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.288216947635014376-1.63247121237385119e-16*%i -0.0825704304932580041+4.67681903786785266e-17*%i -0.265594911883436868+1.5043391839391156e-16*%i 
0.0691572616569850473+0*%i 0.270786268276835385+0*%i -0.00468434063869093212+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[ -0.260051954901933557
-0.0660433280235490638
 0.046565116277752297];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.260051954901933557
-0.0660433280235490638
 0.046565116277752297];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.288272330491939344+0.00165156721805876858*%i -0.0825942221022646084+0.00553845279173677263*%i -0.265639789156075279-0.0031069445819979849*%i 
0.0691646458471141812-0.00541608716438180676*%i 0.270840538797723684+0.000738422002625537671*%i -0.00467875023595177783+0.00543836408021845449*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.282564155899245439+0.0016188639960181446*%i -0.0809587469274432592+0.005428784078632478*%i -0.260379768908271136-0.00304542295731204116*%i 
0.0677950940990729028-0.00530884145304078969*%i 0.265477536807215531+0.000723800267314080731*%i -0.00458610477401360205+0.00533067725638924125*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[0];
yref=[ 0
-0
 0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0
-0
 0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[ 0.722522753107868621
3.54177820150916157e-08
8.76677772650784535e-16];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.722522753107868621
3.54177820150916157e-08
8.76677772650784535e-16];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[1];
yref=[0.767624213200681971
0.430847058235354519
0.111303785599441221];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.767624213200681971
0.430847058235354519
0.111303785599441221];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3 4 5];
yref=[-0.248113342531625397 0.347410321977723313 0.4843523614764772
-0.397488017750937228 -0.0555197528009771721 0.369172943822438926
-0.187188738237360264 -0.323527150348924653 0.0551896608949990139];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.248113342531625397 0.347410321977723313 0.4843523614764772
-0.397488017750937228 -0.0555197528009771721 0.369172943822438926
-0.187188738237360264 -0.323527150348924653 0.0551896608949990139];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.289473237714468368+0.0182121124296419773*%i -0.0742460772355384713-0.00467116724416256467*%i -0.268725018870564547-0.0169067451449718964*%i 
0.0774792372615417391+0*%i 0.269158266698860282+0*%i -0.0121122296346756614+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.289473237714468368+0.0182121124296419773*%i -0.0742460772355384713-0.00467116724416256467*%i -0.268725018870564547-0.0169067451449718964*%i 
0.0774792372615417391+0*%i 0.269158266698860282+0*%i -0.0121122296346756614+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3
4
5];
yref=[ -0.24811334253162734
-0.0555197528009771929
 0.0551896608949990139];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.24811334253162734
-0.0555197528009771929
 0.0551896608949990139];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.289436686533186605+0.0196848354538640968*%i -0.0746194938467206886+0.000909756330523188092*%i -0.2685835756459789-0.0198819369191412312*%i 
0.0774883289690142946-0.00537983661590852799*%i 0.269212372909699293+0.0008959309889286695*%i -0.0121080338436329836+0.00544175248673077396*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.283705456146132684+0.0192950495961393617*%i -0.0731419288713772014+0.000891741948211250118*%i -0.263265264520173126-0.0194882481909108424*%i 
0.0759539572521852335-0.00527330871352064186*%i 0.263881610763850749+0.000878190366722298409*%i -0.0118682787098823468+0.00533399856795724152*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[-0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[-4.99999999999999647e-08];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-4.99999999999999647e-08];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[-0.440050585744933553];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.440050585744933553];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[-0.339058958525936538 0.0660433280235490638 0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538 0.0660433280235490638 0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0825704304932580041-5.18240040696731648e-17*%i -0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0825704304932580041-5.18240040696731648e-17*%i -0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[-0.339058958525936538
0.0660433280235490638
 0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538
0.0660433280235490638
 0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 
-0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 
-0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0825942221022646084-0.00553845279173677783*%i -0.270840538797723684-0.000738422002625521083*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0809587469274432592-0.0054287840786324832*%i -0.265477536807215531-0.000723800267314064468*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[ -0
-%inf];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0
-%inf];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[-4.99999999999999647e-08
 -25231325220.2017288];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-4.99999999999999647e-08
 -25231325220.2017288];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[-0.440050585744933553
 -1.10249557516017949];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.440050585744933553
 -1.10249557516017949];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[-0.339058958525936538 0.0870080907208351517
0.0660433280235490638 0.367112032460934101
 0.327579137591465064 0.3219244429611402];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538 0.0870080907208351378
0.0660433280235490638 0.367112032460934101
 0.327579137591465064 0.321924442961140256];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 9.50628464835290288e-16-0.272424375376841277*%i 
-0.270786268276835385+0*%i -0.218249100772301557+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 9.43689570931383059e-16-0.272424375376841332*%i 
-0.270786268276835385+0*%i -0.218249100772301585+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 
-0.218249100772301557+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 
-0.218249100772301585+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0825942221022646084-0.00553845279173677783*%i -0.00198764870679882157-0.272479284229019014*%i 
-0.270840538797723684-0.000738422002625521083*%i -0.218287028059932248+0.0036388855639192105*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0809587469274432592-0.0054287840786324832*%i -0.00194829062540415629-0.267083832904858764*%i 
-0.265477536807215531-0.000723800267314064468*%i -0.213964655304420243+0.00356683080206891736*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[0];
yref=[-0
 0
-0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0
 0
-0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[9.99999999999999955e-08];
yref=[-2.08333333333333265e-23
 1.25e-15
-4.99999999999999647e-08];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-2.08333333333333265e-23
 1.25e-15
-4.99999999999999647e-08];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[1];
yref=[-0.0195633539826684105
 0.114903484931900501
 -0.440050585744933553];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0195633539826684105
 0.114903484931900501
 -0.440050585744933553];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[3 4 5];
yref=[ -0.30906272225525161 0.486091260585891194 -0.339058958525936538
-0.430171473875621935 0.36412814585207276 0.0660433280235490638
-0.364831230613666901 0.046565116277752297 0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.30906272225525161 0.486091260585891194 -0.339058958525936538
-0.430171473875621935 0.36412814585207276 0.0660433280235490638
-0.364831230613666901 0.046565116277752297 0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.228101889059524748+1.43164485837168552e-16*%i -0.265594911883436868+1.5043391839391156e-16*%i 0.0825704304932580041-5.18240040696731648e-17*%i 
 0.273016906676211979+0*%i -0.00468434063869093212+0*%i -0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.228101889059524748+1.43164485837168552e-16*%i -0.265594911883436868+1.5043391839391156e-16*%i 0.0825704304932580041-5.18240040696731648e-17*%i 
 0.273016906676211979+0*%i -0.00468434063869093212+0*%i -0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[3
4
5];
yref=[-0.30906272225525161
 0.36412814585207276
0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.30906272225525161
 0.36412814585207276
0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.228144514233508455+0.00343724948069338773*%i -0.265639789156075279-0.0031069445819979849*%i 0.0825942221022646084-0.00553845279173677783*%i 
 0.273062336559663221-0.00185656517310216836*%i -0.00467875023595177783+0.00543836408021845449*%i -0.270840538797723684-0.000738422002625521083*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.223626950173899136+0.00336918738079998795*%i -0.260379768908271136-0.00304542295731204116*%i 0.0809587469274432592-0.0054287840786324832*%i 
 0.267655340025824695-0.00181980271958226327*%i -0.00458610477401360205+0.00533067725638924125*%i -0.265477536807215531-0.000723800267314064468*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[0];
yref=[ 0
-0
 1
 0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0
-0
 1
 0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[ 1.25e-15
-4.99999999999999647e-08
 0.999999999999997446
 4.99999999999999647e-08];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 1.25e-15
-4.99999999999999647e-08
 0.999999999999997446
 4.99999999999999647e-08];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[1];
yref=[ 0.114903484931900501
-0.440050585744933553
 0.765197686557966605
 0.440050585744933553];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.114903484931900501
-0.440050585744933553
 0.765197686557966605
 0.440050585744933553];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[3 4 5];
yref=[0.486091260585891194 -0.339058958525936538 -0.260051954901933557 0.339058958525936538
 0.36412814585207276 0.0660433280235490638 -0.397149809863847236 -0.0660433280235490638
0.046565116277752297 0.327579137591465064 -0.177596771314338348 -0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.486091260585891194 -0.339058958525936538 -0.260051954901933557 0.339058958525936538
 0.36412814585207276 0.0660433280235490638 -0.397149809863847236 -0.0660433280235490638
0.046565116277752297 0.327579137591465064 -0.177596771314338348 -0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ -0.265594911883436868+1.5043391839391156e-16*%i 0.0825704304932580041-5.18240040696731648e-17*%i 0.288216947635014376-1.63247121237385119e-16*%i -0.0825704304932580041+5.18240040696731648e-17*%i 
-0.00468434063869093212+0*%i -0.270786268276835385+0*%i 0.0691572616569850473+0*%i 0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.265594911883436868+1.5043391839391156e-16*%i 0.0825704304932580041-5.18240040696731648e-17*%i 0.288216947635014376-1.63247121237385119e-16*%i -0.0825704304932580041+5.18240040696731648e-17*%i 
-0.00468434063869093212+0*%i -0.270786268276835385+0*%i 0.0691572616569850473+0*%i 0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -0.265639789156075279-0.0031069445819979849*%i 0.0825942221022646084-0.00553845279173677783*%i 0.288272330491939344+0.00165156721805876858*%i -0.0825942221022646084+0.00553845279173677783*%i 
-0.00467875023595177783+0.00543836408021845449*%i -0.270840538797723684-0.000738422002625521083*%i 0.0691646458471141812-0.00541608716438180676*%i 0.270840538797723684+0.000738422002625521083*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.260379768908271136-0.00304542295731204116*%i 0.0809587469274432592-0.0054287840786324832*%i 0.282564155899245439+0.0016188639960181446*%i -0.0809587469274432592+0.0054287840786324832*%i 
-0.00458610477401360205+0.00533067725638924125*%i -0.265477536807215531-0.000723800267314064468*%i 0.0677950940990729028-0.00530884145304078969*%i 0.265477536807215531+0.000723800267314064468*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
 0
 -0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
 0
 -0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ -716418914.617646098
 119.403152436272933
8.52879660259094751e-06
2.50846958899734603e-13];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -716418914.617646098
 119.403152436272933
8.52879660259094751e-06
2.50846958899734603e-13];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[-0.962671286840223628
 0.633870726369385018
 0.582348851018592018
 0.181417665056644584];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.962671286840223739
 0.633870726369385018
 0.582348851018592018
 0.181417665056644584];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[-0.106536302179580183 -0.40675205644906709 0.187886713469395089 0.494432522734784052
 0.268869311811566036 -0.344459534063007056 -0.217200381702116863 0.268439400467269551
 0.359445845778418371 -0.0150494093195678302 -0.357639916660074997 -0.0850897673452510606];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.106536302179580156 -0.406752056449067145 0.187886713469395089 0.494432522734784052
 0.268869311811565981 -0.344459534063007056 -0.217200381702116863 0.268439400467269551
 0.359445845778418316 -0.0150494093195678025 -0.357639916660074997 -0.0850897673452510606];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.12542315847504959-0.172630167733447554*%i 0.133575862270551238-0.183851401840542522*%i -0.114444320480207362+0.157519093609566369*%i -0.111627636425035953+0.153642260600349023*%i 
-0.26289292206878756+0*%i -0.0606892109991253315+0*%i 0.267227865711584134+0*%i 0.105227188617724732+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.125423158475049479-0.172630167733447665*%i 0.13357586227055121-0.183851401840542578*%i -0.114444320480207362+0.157519093609566369*%i -0.111627636425035953+0.153642260600349023*%i 
-0.262892922068787505+0*%i -0.0606892109991253037+0*%i 0.267227865711584134+0*%i 0.105227188617724732+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.122388153838117283-0.174892716810286619*%i 0.136900984596519226-0.181484735590922708*%i -0.111095235613447238+0.160007102702057979*%i -0.115511137516278492+0.150857044242800997*%i 
-0.262941829098775337+0.00202766723967471967*%i -0.0607076451088290336-0.00530154123317297127*%i 0.267278966499405468-0.00165931224063856075*%i 0.10525322854217678+0.00491892828012802791*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.119964706020585635-0.171429608988457022*%i 0.134190163475896684-0.177891097051649821*%i -0.108895402559002416+0.156838749788214965*%i -0.113223863745610387+0.147869874625772002*%i 
-0.257735232039471018+0.00198751673823663755*%i -0.0595055531952515537-0.00519656368323724409*%i 0.261986488365517967-0.0016264556568755667*%i 0.103169074978294403+0.00482152697427259275*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
-%inf
 0
 -0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
 0
 -0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 18626891780058596
 -716418914.617646098
 119.403152436272933
8.52879660259094751e-06
2.50846958899734603e-13];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 18626891780058600
 -716418914.617646098
 119.403152436272933
8.52879660259094751e-06
2.50846958899734603e-13];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ 1.86907461941519504
-0.962671286840223628
 0.633870726369385018
 0.582348851018592018
 0.181417665056644584];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 1.86907461941519526
-0.962671286840223739
 0.633870726369385018
 0.582348851018592018
 0.181417665056644584];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[ 0.499083518338036658 -0.106536302179580183 -0.40675205644906709 0.187886713469395089 0.494432522734784052
 0.16969448138548901 0.268869311811566036 -0.344459534063007056 -0.217200381702116863 0.268439400467269551
-0.171862430485209827 0.359445845778418371 -0.0150494093195678302 -0.357639916660074997 -0.0850897673452510606];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.499083518338036658 -0.106536302179580156 -0.406752056449067145 0.187886713469395089 0.494432522734784052
 0.169694481385489065 0.268869311811565981 -0.344459534063007056 -0.217200381702116863 0.268439400467269551
-0.171862430485209772 0.359445845778418316 -0.0150494093195678025 -0.357639916660074997 -0.0850897673452510606];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.0889046003479301572+0.122366684565615697*%i 0.12542315847504959-0.172630167733447554*%i 0.133575862270551238-0.183851401840542522*%i -0.114444320480207362+0.157519093609566369*%i -0.111627636425035953+0.153642260600349023*%i 
 0.142060829734702354+0*%i -0.26289292206878756+0*%i -0.0606892109991253315+0*%i 0.267227865711584134+0*%i 0.105227188617724732+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0889046003479302266+0.122366684565615863*%i 0.125423158475049479-0.172630167733447665*%i 0.13357586227055121-0.183851401840542578*%i -0.114444320480207362+0.157519093609566369*%i -0.111627636425035953+0.153642260600349023*%i 
 0.142060829734702354+0*%i -0.262892922068787505+0*%i -0.0606892109991253037+0*%i 0.267227865711584134+0*%i 0.105227188617724732+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.0931403526417651506+0.119314071061107668*%i 0.122388153838117283-0.174892716810286619*%i 0.136900984596519226-0.181484735590922708*%i -0.111095235613447238+0.160007102702057979*%i -0.115511137516278492+0.150857044242800997*%i 
 0.142092446056964028+0.00448015660911126913*%i -0.262941829098775337+0.00202766723967471967*%i -0.0607076451088290336-0.00530154123317297127*%i 0.267278966499405468-0.00165931224063856075*%i 0.10525322854217678+0.00491892828012802791*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0912960500907815109+0.116951494160925568*%i 0.119964706020585635-0.171429608988457022*%i 0.134190163475896684-0.177891097051649821*%i -0.108895402559002416+0.156838749788214965*%i -0.113223863745610387+0.147869874625772002*%i 
 0.139278827111947917+0.00439144356445757625*%i -0.257735232039471018+0.00198751673823663755*%i -0.0595055531952515537-0.00519656368323724409*%i 0.261986488365517967-0.0016264556568755667*%i 0.103169074978294403+0.00482152697427259275*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
