/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 3.0.7
 *
 * This file is not intended to be easily readable and contains a number of
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG
 * interface file instead.
 * ----------------------------------------------------------------------------- */

#define SWIGJAVA

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__))
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__))
# else
#   define SWIGUNUSED
# endif
#endif

#ifndef SWIG_MSC_UNSUPPRESS_4505
# if defined(_MSC_VER)
#   pragma warning(disable : 4505) /* unreferenced local function has been removed */
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif

/* Deal with Apple's deprecated 'AssertMacros.h' from Carbon-framework */
#if defined(__APPLE__) && !defined(__ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES)
# define __ASSERT_MACROS_DEFINE_VERSIONS_WITHOUT_UNDERSCORES 0
#endif

/* Intel's compiler complains if a variable which was never initialised is
 * cast to void, which is a common idiom which we use to indicate that we
 * are aware a variable isn't used.  So we just silence that warning.
 * See: https://github.com/swig/swig/issues/192 for more discussion.
 */
#ifdef __INTEL_COMPILER
# pragma warning disable 592
#endif


/* Fix for jlong on some versions of gcc on Windows */
#if defined(__GNUC__) && !defined(__INTEL_COMPILER)
  typedef long long __int64;
#endif

/* Fix for jlong on 64-bit x86 Solaris */
#if defined(__x86_64)
# ifdef _LP64
#   undef _LP64
# endif
#endif

#include <jni.h>
#include <stdlib.h>
#include <string.h>


/* Support for throwing Java exceptions */
typedef enum {
  SWIG_JavaOutOfMemoryError = 1, 
  SWIG_JavaIOException, 
  SWIG_JavaRuntimeException, 
  SWIG_JavaIndexOutOfBoundsException,
  SWIG_JavaArithmeticException,
  SWIG_JavaIllegalArgumentException,
  SWIG_JavaNullPointerException,
  SWIG_JavaDirectorPureVirtual,
  SWIG_JavaUnknownError
} SWIG_JavaExceptionCodes;

typedef struct {
  SWIG_JavaExceptionCodes code;
  const char *java_exception;
} SWIG_JavaExceptions_t;


static void SWIGUNUSED SWIG_JavaThrowException(JNIEnv *jenv, SWIG_JavaExceptionCodes code, const char *msg) {
  jclass excep;
  static const SWIG_JavaExceptions_t java_exceptions[] = {
    { SWIG_JavaOutOfMemoryError, "java/lang/OutOfMemoryError" },
    { SWIG_JavaIOException, "java/io/IOException" },
    { SWIG_JavaRuntimeException, "java/lang/RuntimeException" },
    { SWIG_JavaIndexOutOfBoundsException, "java/lang/IndexOutOfBoundsException" },
    { SWIG_JavaArithmeticException, "java/lang/ArithmeticException" },
    { SWIG_JavaIllegalArgumentException, "java/lang/IllegalArgumentException" },
    { SWIG_JavaNullPointerException, "java/lang/NullPointerException" },
    { SWIG_JavaDirectorPureVirtual, "java/lang/RuntimeException" },
    { SWIG_JavaUnknownError,  "java/lang/UnknownError" },
    { (SWIG_JavaExceptionCodes)0,  "java/lang/UnknownError" }
  };
  const SWIG_JavaExceptions_t *except_ptr = java_exceptions;

  while (except_ptr->code != code && except_ptr->code)
    except_ptr++;

  (*jenv)->ExceptionClear(jenv);
  excep = (*jenv)->FindClass(jenv, except_ptr->java_exception);
  if (excep)
    (*jenv)->ThrowNew(jenv, excep, msg);
}


/* Contract support */

#define SWIG_contract_assert(nullreturn, expr, msg) if (!(expr)) {SWIG_JavaThrowException(jenv, SWIG_JavaIllegalArgumentException, msg); return nullreturn; } else



#include "createGraphicObject.h"
#include "deleteGraphicObject.h"
#include "returnType.h"
#include "getGraphicObjectProperty.h"
#include "setGraphicObjectProperty.h"
#include "graphicObjectProperties.h"
#include "sci_malloc.h"
#include "math.h"

/*help funtion*/
int getDataSize_(int uid)
{
	int size = 0;
	int *j = &size;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_NUM_ELEMENTS__, jni_int, (void**)&j);
	return size;
}

BOOL isZCoordSet(int uid)
{
	int result = 0;
	int *pResult = &result;

	getGraphicObjectProperty(uid, __GO_DATA_MODEL_Z_COORDINATES_SET__, jni_int, (void**)&pResult);
	return (BOOL)result;
}

double * getDataX(int uid)
{
	double *vec;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_X__, jni_double_vector, (void**)&vec);
	return vec;
}
double * getDataY(int uid)
{
	double *vec;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_Y__, jni_double_vector, (void**)&vec);
	return vec;
}

double * getDataZ(int uid)
{
	double *vec;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_Z__, jni_double_vector, (void**)&vec);
	return vec;
}

double * getShiftX(int uid)
{
	double *vec;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_X_COORDINATES_SHIFT__, jni_double_vector, (void**)&vec);
	return vec;
}

double * getShiftY(int uid)
{
	double *vec;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_Y_COORDINATES_SHIFT__, jni_double_vector, (void**)&vec);
	return vec;
}

double * getShiftZ(int uid)
{
	double *vec;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_Z_COORDINATES_SHIFT__, jni_double_vector, (void**)&vec);
	return vec;
}

BOOL isXShiftSet(int uid)
{
	int b = 0;
	int * pb = &b;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_X_COORDINATES_SHIFT_SET__, jni_int, (void**)&pb);
	return b;
}

BOOL isYShiftSet(int uid)
{
	int b = 0;
	int * pb = &b;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_Y_COORDINATES_SHIFT_SET__, jni_int, (void**)&pb);
	return b;
}

BOOL isZShiftSet(int uid)
{
	int b = 0;
	int * pb = &b;
	getGraphicObjectProperty(uid, __GO_DATA_MODEL_Z_COORDINATES_SHIFT_SET__, jni_int, (void**)&pb);
	return b;
}


int createPolylineData(int uidFrom, int uidTo)
{
	double *dataFrom, *dataTo;
	int n[2];
	int size = 63;
	int *tmp = &size;
	BOOL result;

    int polylineID = createDataObject(uidTo, __GO_POLYLINE__);
	if (polylineID == NULL)
    {
        return NULL;
    }

	getGraphicObjectProperty(uidFrom, __GO_DATA_MODEL_NUM_ELEMENTS__, jni_int, (void**)&tmp);
	n[0] = 1; n[1] = size;
	
	result = setGraphicObjectProperty(polylineID, __GO_DATA_MODEL_NUM_ELEMENTS_ARRAY__, &n, jni_int_vector, 2);
	if (result == FALSE)
    {
            deleteDataObject(polylineID);
            return NULL;
    }

	getGraphicObjectProperty(uidFrom, __GO_DATA_MODEL_X__, jni_double_vector, (void**)&dataFrom);
	getGraphicObjectProperty(uidTo, __GO_DATA_MODEL_X__, jni_double_vector, (void**)&dataTo);

	memcpy(dataTo, dataFrom, sizeof(double)*3*size);
	return uidTo;
	
}

BOOL translatePolyline(int uid, double x, double y, double z, int flagX, int flagY, int flagZ)
{
    double *datax = NULL;
    double *datay = NULL;
	double *dataz = NULL;

    int i = 0;
    if (x != 0.0)
    {
        datax = getDataX(uid);
        if (datax == NULL) return FALSE;
        if (flagX) {
            for (i = 0; i < getDataSize_(uid); ++i)
            {
                datax[i] = pow(10.,log10(datax[i]) + x);
            }
        } else {
            for (i = 0; i < getDataSize_(uid); ++i)
            {
                datax[i] += x;
            }
        }
    }
    if (y != 0.0)
    {
        datay = getDataY(uid);
        if (datay == NULL) return FALSE;
        if (flagY) {
            for (i = 0; i < getDataSize_(uid); ++i)
            {
                datay[i] = pow(10.,log10(datay[i]) + y);
            }
        } else {
            for (i = 0; i < getDataSize_(uid); ++i)
            {
                datay[i] += y;
            }
        }
    }
	if (z != 0 && isZCoordSet(uid))
	{
        if (flagZ) {
            for (i = 0; i < getDataSize_(uid); ++i)
            {
                dataz[i] = pow(10.,log10(dataz[i]) + z);
            }
        } else {
            for (i = 0; i < getDataSize_(uid); ++i)
            {
                dataz[i] += z;
            }
        }
	}

	return TRUE;
}

BOOL translatePoint(int uid, int index, double x, double y, double z, int flagX, int flagY, int flagZ)
{
    double *datax = NULL;
    double *datay = NULL;
    double *dataz = NULL;

    int size = getDataSize_(uid);

    if (index >= 0 && index < size) 
    {
	datax = getDataX(uid);
	if (datax == NULL) return FALSE;
	datay = getDataY(uid);
	if (datay == NULL) return FALSE;
	
	if (flagX) {
	    datax[index] *= pow(10., x);
	} else {
	    datax[index] += x;
	}
	
	if (flagY) {
	    datay[index] *= pow(10., y);
	} else {
	    datay[index] += y;
	}

	if (z != 0 && isZCoordSet(uid))
	{
	    dataz = getDataZ(uid);
	    if (flagZ) {
		dataz[index] *= pow(10., z);
	    } else {
		dataz[index] += z;
	    }
	}
    }
    /*update*/
    setGraphicObjectProperty(uid, __GO_DATA_MODEL__, &uid, jni_int, 1);
    return TRUE;
}

BOOL setPointValue(int uid, int index, double x, double y, double z)
{
    double *datax = NULL;
    double *datay = NULL;
    double *dataz = NULL;

    int size = getDataSize_(uid);


	if (index >= 0 && index < size) 
	{
		datax = getDataX(uid);
		if (datax == NULL) return FALSE;
		datay = getDataY(uid);
		if (datay == NULL) return FALSE;

		datax[index] = x;
		datay[index] = y;

		if (z != 0 && isZCoordSet(uid))
		{
			dataz = getDataZ(uid);
			dataz[index] = z;
		}	
	}
	/*update*/
	setGraphicObjectProperty(uid, __GO_DATA_MODEL__, &uid, jni_int, 1);
	return TRUE;
}

BOOL insertPoint(int uid, int index, double x, double y, double z)
{
    double *curData, *newData;
	int size = getDataSize_(uid);
	BOOL result;
	int i ,j, n[2];

	// -1 = inset before the first element
	if (index >= size || index < -1) return FALSE;

	curData = getDataX(uid);
	if (curData == NULL) return FALSE;

	newData = MALLOC(sizeof(double)*3*(size+1));
	if (newData == NULL) return FALSE;

	j = index == -1 ? 1 : 0;
	for (i = 0; i < size; ++i, ++j)
	{
		newData[j] = curData[i];
		newData[(size+1)+j] = curData[size+i];
		newData[(size+1)*2+j] = curData[size*2+i];
		if (i == index)
			++j;
	}

	newData[index+1] = x;
	newData[size+index+2] = y;
	if (isZCoordSet(uid))
	{
		newData[(size+1)*2+index+1] = z;
	}
	else
	{
		newData[(size+1)*2+index+1] = 0.0;
	}

	n[0] = 1; n[1] = size+1;
	
	result = setGraphicObjectProperty(uid, __GO_DATA_MODEL_NUM_ELEMENTS_ARRAY__, &n, jni_int_vector, 2);
	setGraphicObjectProperty(uid, __GO_DATA_MODEL_COORDINATES__, newData, jni_double_vector, size+1);

	FREE(newData);
	return TRUE;
}

BOOL removePoint(int uid, int index)
{
	double *curData, *newData;
	int size = getDataSize_(uid);
	BOOL result;
	int i ,j, n[2];

	if (index >= size || index < 0) return FALSE;

	curData = getDataX(uid);
	if (curData == NULL) return FALSE;

	newData = MALLOC(sizeof(double)*3*(size-1));
	if (newData == NULL) return FALSE;

	j = 0;
	for (i = 0; i < size; ++i, ++j)
	{
		if (i == index)
		{
			--j;
			continue;
		}

		newData[j] = curData[i];
		newData[(size-1)+j] = curData[size+i];
		newData[(size-1)*2+j] = curData[size*2+i];
	}

	n[0] = 1; n[1] = size-1;
	result = setGraphicObjectProperty(uid, __GO_DATA_MODEL_NUM_ELEMENTS_ARRAY__, &n, jni_int_vector, 2);
	setGraphicObjectProperty(uid, __GO_DATA_MODEL_COORDINATES__, newData, jni_double_vector, size-1);

	FREE(newData);
	return TRUE;
}


#ifdef __cplusplus
extern "C" {
#endif

SWIGEXPORT jobject JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_getDataX(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jobject jresult = 0 ;
  int arg1 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (double *)getDataX(arg1);
  {
    jresult = (*jenv)->NewDoubleArray(jenv, getDataSize_(arg1));
    (*jenv)->SetDoubleArrayRegion(jenv, jresult, 0, getDataSize_(arg1), result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_getDataY(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jobject jresult = 0 ;
  int arg1 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (double *)getDataY(arg1);
  {
    jresult = (*jenv)->NewDoubleArray(jenv, getDataSize_(arg1));
    (*jenv)->SetDoubleArrayRegion(jenv, jresult, 0, getDataSize_(arg1), result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_getDataZ(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jobject jresult = 0 ;
  int arg1 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (double *)getDataZ(arg1);
  {
    jresult = (*jenv)->NewDoubleArray(jenv, getDataSize_(arg1));
    (*jenv)->SetDoubleArrayRegion(jenv, jresult, 0, getDataSize_(arg1), result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_getShiftX(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jobject jresult = 0 ;
  int arg1 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (double *)getShiftX(arg1);
  {
    jresult = (*jenv)->NewDoubleArray(jenv, getDataSize_(arg1));
    (*jenv)->SetDoubleArrayRegion(jenv, jresult, 0, getDataSize_(arg1), result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_getShiftY(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jobject jresult = 0 ;
  int arg1 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (double *)getShiftY(arg1);
  {
    jresult = (*jenv)->NewDoubleArray(jenv, getDataSize_(arg1));
    (*jenv)->SetDoubleArrayRegion(jenv, jresult, 0, getDataSize_(arg1), result);
  }
  return jresult;
}


SWIGEXPORT jobject JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_getShiftZ(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jobject jresult = 0 ;
  int arg1 ;
  double *result = 0 ;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (double *)getShiftZ(arg1);
  {
    jresult = (*jenv)->NewDoubleArray(jenv, getDataSize_(arg1));
    (*jenv)->SetDoubleArrayRegion(jenv, jresult, 0, getDataSize_(arg1), result);
  }
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_isZCoordSet(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)isZCoordSet(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_isXShiftSet(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)isXShiftSet(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_isYShiftSet(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)isYShiftSet(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_isZShiftSet(JNIEnv *jenv, jclass jcls, jint jarg1) {
  jint jresult = 0 ;
  int arg1 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  result = (int)isZShiftSet(arg1);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_createPolylineData(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jint jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (int)createPolylineData(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_translatePolyline(JNIEnv *jenv, jclass jcls, jint jarg1, jdouble jarg2, jdouble jarg3, jdouble jarg4, jint jarg5, jint jarg6, jint jarg7) {
  jint jresult = 0 ;
  int arg1 ;
  double arg2 ;
  double arg3 ;
  double arg4 ;
  int arg5 ;
  int arg6 ;
  int arg7 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (double)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (int)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  result = (int)translatePolyline(arg1,arg2,arg3,arg4,arg5,arg6,arg7);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_translatePoint(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5, jint jarg6, jint jarg7, jint jarg8) {
  jint jresult = 0 ;
  int arg1 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  int arg6 ;
  int arg7 ;
  int arg8 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  arg6 = (int)jarg6; 
  arg7 = (int)jarg7; 
  arg8 = (int)jarg8; 
  result = (int)translatePoint(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_setPointValue(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
  jint jresult = 0 ;
  int arg1 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  result = (int)setPointValue(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_insertPoint(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2, jdouble jarg3, jdouble jarg4, jdouble jarg5) {
  jint jresult = 0 ;
  int arg1 ;
  int arg2 ;
  double arg3 ;
  double arg4 ;
  double arg5 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  arg3 = (double)jarg3; 
  arg4 = (double)jarg4; 
  arg5 = (double)jarg5; 
  result = (int)insertPoint(arg1,arg2,arg3,arg4,arg5);
  jresult = (jint)result; 
  return jresult;
}


SWIGEXPORT jint JNICALL Java_org_scilab_modules_graphic_1objects_PolylineDataJNI_removePoint(JNIEnv *jenv, jclass jcls, jint jarg1, jint jarg2) {
  jint jresult = 0 ;
  int arg1 ;
  int arg2 ;
  int result;
  
  (void)jenv;
  (void)jcls;
  arg1 = (int)jarg1; 
  arg2 = (int)jarg2; 
  result = (int)removePoint(arg1,arg2);
  jresult = (jint)result; 
  return jresult;
}


#ifdef __cplusplus
}
#endif

